/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import org.apache.openejb.BeanType;
import org.apache.openejb.Injection;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.assembler.classic.AssemblerTool;
import org.apache.openejb.assembler.classic.CallbackInfo;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.openejb.assembler.classic.EntityBeanInfo;
import org.apache.openejb.assembler.classic.InitMethodInfo;
import org.apache.openejb.assembler.classic.InjectionBuilder;
import org.apache.openejb.assembler.classic.JndiEncBuilder;
import org.apache.openejb.assembler.classic.MessageDrivenBeanInfo;
import org.apache.openejb.assembler.classic.MethodInfoUtil;
import org.apache.openejb.assembler.classic.NamedMethodInfo;
import org.apache.openejb.assembler.classic.PersistenceContextReferenceInfo;
import org.apache.openejb.assembler.classic.QueryInfo;
import org.apache.openejb.assembler.classic.RemoveMethodInfo;
import org.apache.openejb.assembler.classic.SecurityRoleReferenceInfo;
import org.apache.openejb.assembler.classic.SingletonBeanInfo;
import org.apache.openejb.assembler.classic.StatefulBeanInfo;
import org.apache.openejb.assembler.classic.StatelessBeanInfo;
import org.apache.openejb.core.CoreDeploymentInfo;
import org.apache.openejb.core.DeploymentContext;
import org.apache.openejb.core.cmp.CmpUtil;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.Classes;
import org.apache.openejb.util.Index;
import org.apache.openejb.util.Messages;
import org.apache.openejb.util.SafeToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EnterpriseBeanBuilder {
    protected static final Messages messages = new Messages("org.apache.openejb.util.resources");
    private final EnterpriseBeanInfo bean;
    private final String moduleId;
    private final List<String> defaultInterceptors;
    private final BeanType ejbType;
    private final ClassLoader cl;
    private List<Exception> warnings = new ArrayList<Exception>();

    public EnterpriseBeanBuilder(ClassLoader cl, EnterpriseBeanInfo bean, String moduleId, List<String> defaultInterceptors) {
        this.bean = bean;
        this.moduleId = moduleId;
        this.defaultInterceptors = defaultInterceptors;
        if (bean.type == 1) {
            this.ejbType = BeanType.STATEFUL;
        } else if (bean.type == 2) {
            this.ejbType = BeanType.STATELESS;
        } else if (bean.type == 4) {
            this.ejbType = BeanType.SINGLETON;
        } else if (bean.type == 5) {
            this.ejbType = BeanType.MANAGED;
        } else if (bean.type == 3) {
            this.ejbType = BeanType.MESSAGE_DRIVEN;
        } else if (bean.type == 0) {
            String persistenceType = ((EntityBeanInfo)bean).persistenceType;
            this.ejbType = persistenceType.equalsIgnoreCase("Container") ? BeanType.CMP_ENTITY : BeanType.BMP_ENTITY;
        } else {
            throw new UnsupportedOperationException("No building support for bean type: " + bean);
        }
        this.cl = cl;
    }

    public Object build() throws OpenEJBException {
        CoreDeploymentInfo deployment;
        Class ejbClass = this.loadClass(this.bean.ejbClass, "classNotFound.ejbClass");
        Class home = null;
        Class remote = null;
        if (this.bean.home != null) {
            home = this.loadClass(this.bean.home, "classNotFound.home");
            remote = this.loadClass(this.bean.remote, "classNotFound.remote");
        }
        Class localhome = null;
        Class local = null;
        if (this.bean.localHome != null) {
            localhome = this.loadClass(this.bean.localHome, "classNotFound.localHome");
            local = this.loadClass(this.bean.local, "classNotFound.local");
        }
        ArrayList<Class> businessLocals = new ArrayList<Class>();
        for (String businessLocal : this.bean.businessLocal) {
            businessLocals.add(this.loadClass(businessLocal, "classNotFound.businessLocal"));
        }
        ArrayList<Class> businessRemotes = new ArrayList<Class>();
        for (String businessRemote : this.bean.businessRemote) {
            businessRemotes.add(this.loadClass(businessRemote, "classNotFound.businessRemote"));
        }
        Class serviceEndpoint = null;
        if ((BeanType.STATELESS == this.ejbType || BeanType.SINGLETON == this.ejbType) && this.bean.serviceEndpoint != null) {
            serviceEndpoint = this.loadClass(this.bean.serviceEndpoint, "classNotFound.sei");
        }
        Class primaryKey = null;
        if (this.ejbType.isEntity() && ((EntityBeanInfo)this.bean).primKeyClass != null) {
            String className = ((EntityBeanInfo)this.bean).primKeyClass;
            primaryKey = this.loadClass(className, "classNotFound.primaryKey");
        }
        String transactionType = this.bean.transactionType;
        InjectionBuilder injectionBuilder = new InjectionBuilder(this.cl);
        List<Injection> injections = injectionBuilder.buildInjections(this.bean.jndiEnc);
        JndiEncBuilder jndiEncBuilder = new JndiEncBuilder(this.bean.jndiEnc, injections, transactionType, this.moduleId, this.cl);
        Context root = jndiEncBuilder.build();
        DeploymentContext deploymentContext = new DeploymentContext(this.bean.ejbDeploymentId, this.cl, root);
        if (BeanType.MESSAGE_DRIVEN != this.ejbType) {
            deployment = new CoreDeploymentInfo(deploymentContext, ejbClass, home, remote, localhome, local, serviceEndpoint, businessLocals, businessRemotes, primaryKey, this.ejbType);
        } else {
            MessageDrivenBeanInfo messageDrivenBeanInfo = (MessageDrivenBeanInfo)this.bean;
            Class mdbInterface = this.loadClass(messageDrivenBeanInfo.mdbInterface, "classNotFound.mdbInterface");
            deployment = new CoreDeploymentInfo(deploymentContext, ejbClass, mdbInterface, messageDrivenBeanInfo.activationProperties);
            deployment.setDestinationId(messageDrivenBeanInfo.destinationId);
        }
        deployment.setEjbName(this.bean.ejbName);
        deployment.setModuleId(this.moduleId);
        deployment.setRunAs(this.bean.runAs);
        for (SecurityRoleReferenceInfo roleReferenceInfo : this.bean.securityRoleReferences) {
            String alias = roleReferenceInfo.roleName;
            String actualName = roleReferenceInfo.roleLink;
            if (actualName == null) {
                actualName = alias;
            }
            deployment.addSecurityRoleReference(alias, actualName);
        }
        deployment.getInjections().addAll(injections);
        deployment.getProperties().putAll((Map<?, ?>)this.bean.properties);
        deployment.setEjbTimeout(this.getTimeout(ejbClass, this.bean.timeoutMethod));
        if (this.bean instanceof StatefulBeanInfo) {
            StatefulBeanInfo statefulBeanInfo = (StatefulBeanInfo)this.bean;
            for (InitMethodInfo init : statefulBeanInfo.initMethods) {
                Method beanMethod = this.toMethod(ejbClass, init.beanMethod);
                ArrayList<Method> methods = new ArrayList<Method>();
                if (home != null) {
                    methods.addAll(Arrays.asList(home.getMethods()));
                }
                if (localhome != null) {
                    methods.addAll(Arrays.asList(localhome.getMethods()));
                }
                for (Method homeMethod : methods) {
                    if (init.createMethod != null && !init.createMethod.methodName.equals(homeMethod.getName()) || !homeMethod.getName().startsWith("create") || !EnterpriseBeanBuilder.paramsMatch(beanMethod, homeMethod)) continue;
                    deployment.mapMethods(homeMethod, beanMethod);
                }
            }
            for (RemoveMethodInfo removeMethod : statefulBeanInfo.removeMethods) {
                Method method = this.toMethod(ejbClass, removeMethod.beanMethod);
                deployment.getRemoveMethods().add(method);
                deployment.setRetainIfExeption(method, removeMethod.retainIfException);
            }
            HashMap<EntityManagerFactory, Properties> extendedEntityManagerFactories = new HashMap<EntityManagerFactory, Properties>();
            for (PersistenceContextReferenceInfo info : statefulBeanInfo.jndiEnc.persistenceContextRefs) {
                if (!info.extended) continue;
                try {
                    ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
                    Object o = containerSystem.getJNDIContext().lookup("openejb/PersistenceUnit/" + info.unitId);
                    extendedEntityManagerFactories.put((EntityManagerFactory)o, info.properties);
                }
                catch (NamingException e) {
                    throw new OpenEJBException("PersistenceUnit '" + info.unitId + "' not found for EXTENDED ref '" + info.referenceName + "'");
                }
            }
            deployment.setExtendedEntityManagerFactories(new Index<EntityManagerFactory, Map>(extendedEntityManagerFactories));
            deployment.setLocalbean(((StatefulBeanInfo)this.bean).localbean);
        }
        if (this.ejbType.isSession() || this.ejbType.isMessageDriven()) {
            deployment.setBeanManagedTransaction("Bean".equalsIgnoreCase(this.bean.transactionType));
        }
        if (this.ejbType.isSession()) {
            deployment.getDependsOn().addAll(this.bean.dependsOn);
        }
        if (this.ejbType == BeanType.SINGLETON) {
            deployment.setBeanManagedConcurrency("Bean".equalsIgnoreCase(this.bean.concurrencyType));
            deployment.setLoadOnStartup(this.bean.loadOnStartup);
            deployment.setLocalbean(((SingletonBeanInfo)this.bean).localbean);
        }
        if (this.ejbType == BeanType.STATELESS) {
            deployment.setLocalbean(((StatelessBeanInfo)this.bean).localbean);
        }
        if (this.ejbType.isEntity()) {
            EntityBeanInfo entity = (EntityBeanInfo)this.bean;
            deployment.setCmp2(entity.cmpVersion == 2);
            deployment.setIsReentrant(entity.reentrant.equalsIgnoreCase("true"));
            if (this.ejbType == BeanType.CMP_ENTITY) {
                Class cmpImplClass = null;
                String cmpImplClassName = CmpUtil.getCmpImplClassName(entity.abstractSchemaName, entity.ejbClass);
                cmpImplClass = this.loadClass(cmpImplClassName, "classNotFound.cmpImplClass");
                deployment.setCmpImplClass(cmpImplClass);
                deployment.setAbstractSchemaName(entity.abstractSchemaName);
                for (QueryInfo query : entity.queries) {
                    ArrayList<Method> finderMethods = new ArrayList<Method>();
                    if (home != null) {
                        finderMethods.addAll(MethodInfoUtil.matchingMethods(query.method, home));
                    }
                    if (localhome != null) {
                        finderMethods.addAll(MethodInfoUtil.matchingMethods(query.method, localhome));
                    }
                    for (Method method : finderMethods) {
                        deployment.addQuery(method, query.queryStatement);
                    }
                    if (!query.remoteResultType) continue;
                    StringBuilder methodSignature = new StringBuilder();
                    methodSignature.append(query.method.methodName);
                    if (query.method.methodParams != null && !query.method.methodParams.isEmpty()) {
                        methodSignature.append('(');
                        boolean first = true;
                        for (String methodParam : query.method.methodParams) {
                            if (!first) {
                                methodSignature.append(",");
                            }
                            methodSignature.append(methodParam);
                            first = false;
                        }
                        methodSignature.append(')');
                    }
                    deployment.setRemoteQueryResults(methodSignature.toString());
                }
                deployment.setCmrFields(entity.cmpFieldNames.toArray(new String[0]));
                if (entity.primKeyField != null) {
                    deployment.setPrimaryKeyField(entity.primKeyField);
                }
            }
        }
        deployment.createMethodMap();
        return deployment;
    }

    public static boolean paramsMatch(Method methodA, Method methodB) {
        if (methodA.getParameterTypes().length != methodB.getParameterTypes().length) {
            return false;
        }
        for (int i = 0; i < methodA.getParameterTypes().length; ++i) {
            Class<?> b;
            Class<?> a = methodA.getParameterTypes()[i];
            if (a.equals(b = methodB.getParameterTypes()[i])) continue;
            return false;
        }
        return true;
    }

    public List<Exception> getWarnings() {
        return this.warnings;
    }

    private Method getCallback(Class ejbClass, List<CallbackInfo> callbackInfos) {
        Method callback = null;
        for (CallbackInfo info : callbackInfos) {
            try {
                if (ejbClass.getName().equals(info.className)) {
                    if (callback != null) {
                        throw new IllegalStateException("Spec requirements only allow one callback method of a given type per class.  The following callback will be ignored: " + info.className + "." + info.method);
                    }
                    try {
                        callback = ejbClass.getMethod(info.method, new Class[0]);
                        continue;
                    }
                    catch (NoSuchMethodException e) {
                        throw (IllegalStateException)new IllegalStateException("Callback method does not exist: " + info.className + "." + info.method).initCause(e);
                    }
                }
                throw new UnsupportedOperationException("Callback: " + info.className + "." + info.method + " -- We currently do not support callbacks where the callback class is not the bean class.  If you need this feature, please let us know and we will complete it asap.");
            }
            catch (Exception e) {
                this.warnings.add(e);
            }
        }
        return callback;
    }

    private Method getTimeout(Class ejbClass, NamedMethodInfo info) {
        Method timeout = null;
        try {
            if (TimedObject.class.isAssignableFrom(ejbClass)) {
                timeout = ejbClass.getMethod("ejbTimeout", Timer.class);
            } else if (info.methodParams != null) {
                timeout = this.toMethod(ejbClass, info);
            }
        }
        catch (Exception e) {
            this.warnings.add(e);
        }
        return timeout;
    }

    private Method toMethod(Class clazz, NamedMethodInfo info) {
        ArrayList<Class> parameterTypes = new ArrayList<Class>();
        if (info.methodParams != null) {
            for (String paramType : info.methodParams) {
                try {
                    parameterTypes.add(Classes.forName(paramType, clazz.getClassLoader()));
                }
                catch (ClassNotFoundException cnfe) {
                    throw new IllegalStateException("Parameter class could not be loaded for type " + paramType, cnfe);
                }
            }
        }
        Class[] parameters = parameterTypes.toArray(new Class[parameterTypes.size()]);
        IllegalStateException noSuchMethod = null;
        while (clazz != null) {
            try {
                return clazz.getDeclaredMethod(info.methodName, parameters);
            }
            catch (NoSuchMethodException e) {
                if (noSuchMethod == null) {
                    noSuchMethod = new IllegalStateException("Callback method does not exist: " + clazz.getName() + "." + info.methodName, e);
                }
                clazz = clazz.getSuperclass();
            }
        }
        throw noSuchMethod;
    }

    private Class loadClass(String className, String messageCode) throws OpenEJBException {
        Class clazz = this.load(className, messageCode);
        try {
            return clazz;
        }
        catch (NoClassDefFoundError e) {
            if (clazz.getClassLoader() != this.cl) {
                String message = SafeToolkit.messages.format("cl0008", className, clazz.getClassLoader(), this.cl, e.getMessage());
                throw new OpenEJBException(AssemblerTool.messages.format(messageCode, className, this.bean.ejbDeploymentId, message), e);
            }
            String message = SafeToolkit.messages.format("cl0009", className, clazz.getClassLoader(), e.getMessage());
            throw new OpenEJBException(AssemblerTool.messages.format(messageCode, className, this.bean.ejbDeploymentId, message), e);
        }
    }

    private Class load(String className, String messageCode) throws OpenEJBException {
        try {
            return Class.forName(className, true, this.cl);
        }
        catch (ClassNotFoundException e) {
            String message = SafeToolkit.messages.format("cl0007", className, this.bean.codebase);
            throw new OpenEJBException(AssemblerTool.messages.format(messageCode, className, this.bean.ejbDeploymentId, message));
        }
    }
}

