/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.assembler.classic.MethodAttributeInfo;
import org.apache.openejb.assembler.classic.MethodInfo;
import org.apache.openejb.assembler.classic.MethodInfoUtil;
import org.apache.openejb.assembler.classic.MethodTransactionInfo;
import org.apache.openejb.core.CoreDeploymentInfo;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodTransactionBuilder {
    public static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP, MethodTransactionBuilder.class);

    public void build(HashMap<String, DeploymentInfo> deployments, List<MethodTransactionInfo> methodTransactions) throws OpenEJBException {
        for (DeploymentInfo deploymentInfo : deployments.values()) {
            MethodTransactionBuilder.applyTransactionAttributes((CoreDeploymentInfo)deploymentInfo, methodTransactions);
        }
    }

    public static void applyTransactionAttributes(CoreDeploymentInfo deploymentInfo, List<MethodTransactionInfo> methodTransactionInfos) throws OpenEJBException {
        if (deploymentInfo.isBeanManagedTransaction()) {
            return;
        }
        methodTransactionInfos = MethodTransactionBuilder.normalize(methodTransactionInfos);
        Map<Method, MethodAttributeInfo> attributes = MethodInfoUtil.resolveAttributes(methodTransactionInfos, deploymentInfo);
        Logger log = Logger.getInstance(LogCategory.OPENEJB_STARTUP.createChild("attributes"), MethodTransactionBuilder.class);
        if (log.isDebugEnabled()) {
            for (Map.Entry<Method, MethodAttributeInfo> entry : attributes.entrySet()) {
                Method method = entry.getKey();
                MethodTransactionInfo value = (MethodTransactionInfo)entry.getValue();
                log.debug("Transaction Attribute: " + method + " -- " + MethodInfoUtil.toString(value));
            }
        }
        for (Map.Entry<Method, MethodAttributeInfo> entry : attributes.entrySet()) {
            MethodTransactionInfo value = (MethodTransactionInfo)entry.getValue();
            deploymentInfo.setMethodTransactionAttribute(entry.getKey(), value.transAttribute);
        }
    }

    public static List<MethodTransactionInfo> normalize(List<MethodTransactionInfo> infos) {
        ArrayList<MethodTransactionInfo> normalized = new ArrayList<MethodTransactionInfo>();
        for (MethodTransactionInfo oldInfo : infos) {
            for (MethodInfo methodInfo : oldInfo.methods) {
                MethodTransactionInfo newInfo = new MethodTransactionInfo();
                newInfo.description = oldInfo.description;
                newInfo.methods.add(methodInfo);
                newInfo.transAttribute = oldInfo.transAttribute;
                normalized.add(newInfo);
            }
        }
        Collections.reverse(normalized);
        Collections.sort(normalized, new MethodTransactionComparator());
        return normalized;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MethodTransactionComparator
    extends MethodInfoUtil.BaseComparator<MethodTransactionInfo> {
        @Override
        public int compare(MethodTransactionInfo a, MethodTransactionInfo b) {
            return this.compare((MethodInfo)a.methods.get(0), (MethodInfo)b.methods.get(0));
        }
    }
}

