/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.util.Map;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.oejb3.EjbDeployment;
import org.apache.openejb.jee.oejb3.Jndi;
import org.apache.openejb.jee.oejb3.OpenejbJar;

public class MappedNameBuilder
implements DynamicDeployer {
    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            OpenejbJar openejbJar = ejbModule.getOpenejbJar();
            if (openejbJar == null) {
                return appModule;
            }
            Map ejbDeployments = openejbJar.getDeploymentsByEjbName();
            for (EnterpriseBean enterpriseBean : ejbModule.getEjbJar().getEnterpriseBeans()) {
                String mappedName;
                EjbDeployment ejbDeployment = (EjbDeployment)ejbDeployments.get(enterpriseBean.getEjbName());
                if (ejbDeployment == null || (mappedName = enterpriseBean.getMappedName()) == null || mappedName.length() <= 0) continue;
                ejbDeployment.getJndi().add(new Jndi(mappedName, "Remote"));
            }
        }
        return appModule;
    }
}

