/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.openejb.Container;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.core.JndiFactory;
import org.apache.openejb.core.WebDeploymentInfo;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;

public class CoreContainerSystem
implements ContainerSystem {
    Map<Object, DeploymentInfo> deployments = new ConcurrentHashMap<Object, DeploymentInfo>();
    Map<Object, Container> containers = new ConcurrentHashMap<Object, Container>();
    Map<String, WebDeploymentInfo> webDeployments = new ConcurrentHashMap<String, WebDeploymentInfo>();
    private final Context jndiContext;

    public CoreContainerSystem(JndiFactory jndiFactory) {
        if (jndiFactory == null) {
            throw new NullPointerException("JndiFactory required");
        }
        this.jndiContext = jndiFactory.createRootContext();
        try {
            this.jndiContext.bind("openejb/local/.", (Object)"");
            this.jndiContext.bind("openejb/remote/.", (Object)"");
            this.jndiContext.bind("openejb/client/.", (Object)"");
            this.jndiContext.bind("openejb/Deployment/.", (Object)"");
        }
        catch (NamingException exception) {
            throw new RuntimeException(exception);
        }
        SystemInstance.get().setComponent(JndiFactory.class, (Object)jndiFactory);
    }

    public DeploymentInfo getDeploymentInfo(Object deploymentID) {
        return this.deployments.get(deploymentID);
    }

    public DeploymentInfo[] deployments() {
        return this.deployments.values().toArray(new DeploymentInfo[this.deployments.size()]);
    }

    public void addDeployment(DeploymentInfo deployment) {
        this.deployments.put(deployment.getDeploymentID(), deployment);
    }

    public void removeDeploymentInfo(DeploymentInfo info) {
        this.deployments.remove(info.getDeploymentID());
    }

    public Container getContainer(Object id) {
        return this.containers.get(id);
    }

    public Container[] containers() {
        return this.containers.values().toArray(new Container[this.containers.size()]);
    }

    public void addContainer(Object id, Container c) {
        this.containers.put(id, c);
    }

    public void removeContainer(Object id) {
        this.containers.remove(id);
    }

    public WebDeploymentInfo getWebDeploymentInfo(String id) {
        return this.webDeployments.get(id);
    }

    public WebDeploymentInfo[] WebDeployments() {
        return this.webDeployments.values().toArray(new WebDeploymentInfo[this.webDeployments.size()]);
    }

    public void addWebDeployment(WebDeploymentInfo webDeployment) {
        this.webDeployments.put(webDeployment.getId(), webDeployment);
    }

    public void removeWebDeploymentInfo(WebDeploymentInfo info) {
        this.webDeployments.remove(info.getId());
    }

    public Context getJNDIContext() {
        return this.jndiContext;
    }
}

