/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.cmp;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.ejb.EJBAccessException;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.ejb.Timer;
import javax.transaction.Synchronization;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.ContainerType;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.ProxyInfo;
import org.apache.openejb.RpcContainer;
import org.apache.openejb.core.CoreDeploymentInfo;
import org.apache.openejb.core.ExceptionType;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.cmp.CmpCallback;
import org.apache.openejb.core.cmp.CmpEngine;
import org.apache.openejb.core.cmp.CmpEngineFactory;
import org.apache.openejb.core.cmp.KeyGenerator;
import org.apache.openejb.core.cmp.ProxyFactory;
import org.apache.openejb.core.entity.EntrancyTracker;
import org.apache.openejb.core.timer.EjbTimerService;
import org.apache.openejb.core.timer.EjbTimerServiceImpl;
import org.apache.openejb.core.transaction.EjbTransactionUtil;
import org.apache.openejb.core.transaction.TransactionPolicy;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.Enumerator;

public class CmpContainer
implements RpcContainer {
    protected final Object containerID;
    protected final SecurityService securityService;
    protected final Map<Object, DeploymentInfo> deploymentsById = new HashMap<Object, DeploymentInfo>();
    protected final Map<Class, DeploymentInfo> deploymentsByClass = new HashMap<Class, DeploymentInfo>();
    protected final CmpEngine cmpEngine;
    protected EntrancyTracker entrancyTracker;
    protected TransactionSynchronizationRegistry synchronizationRegistry;
    private static final Object ENTITIES_TO_STORE = new Object(){

        public String toString() {
            return "EntitiesToStore";
        }
    };

    public CmpContainer(Object id, TransactionManager transactionManager, SecurityService securityService, String cmpEngineFactory) throws OpenEJBException {
        CmpEngineFactory factory;
        this.containerID = id;
        this.securityService = securityService;
        this.synchronizationRegistry = (TransactionSynchronizationRegistry)SystemInstance.get().getComponent(TransactionSynchronizationRegistry.class);
        this.entrancyTracker = new EntrancyTracker(this.synchronizationRegistry);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        try {
            Class<?> cmpEngineFactoryClass = classLoader.loadClass(cmpEngineFactory);
            factory = (CmpEngineFactory)cmpEngineFactoryClass.newInstance();
        }
        catch (Exception e) {
            throw new OpenEJBException("Unable to create cmp engine factory " + cmpEngineFactory, e);
        }
        factory.setTransactionManager(transactionManager);
        factory.setTransactionSynchronizationRegistry(this.synchronizationRegistry);
        factory.setCmpCallback(new ContainerCmpCallback());
        this.cmpEngine = factory.create();
    }

    public Object getContainerID() {
        return this.containerID;
    }

    public ContainerType getContainerType() {
        return ContainerType.CMP_ENTITY;
    }

    public synchronized DeploymentInfo[] deployments() {
        return this.deploymentsById.values().toArray(new DeploymentInfo[this.deploymentsById.size()]);
    }

    public synchronized DeploymentInfo getDeploymentInfo(Object deploymentID) {
        return this.deploymentsById.get(deploymentID);
    }

    private DeploymentInfo getDeploymentInfoByClass(Class type) {
        DeploymentInfo deploymentInfo = null;
        while (type != null && deploymentInfo == null) {
            deploymentInfo = this.deploymentsByClass.get(type);
            type = type.getSuperclass();
        }
        return deploymentInfo;
    }

    public void deploy(DeploymentInfo deploymentInfo) throws OpenEJBException {
        this.deploy((CoreDeploymentInfo)deploymentInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(CoreDeploymentInfo deploymentInfo) throws OpenEJBException {
        CmpContainer cmpContainer = this;
        synchronized (cmpContainer) {
            Object deploymentId = deploymentInfo.getDeploymentID();
            this.cmpEngine.deploy(deploymentInfo);
            deploymentInfo.setContainerData(this.cmpEngine);
            try {
                Field field = deploymentInfo.getCmpImplClass().getField("deploymentInfo");
                field.set(null, deploymentInfo);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.deploymentsById.put(deploymentId, deploymentInfo);
            this.deploymentsByClass.put(deploymentInfo.getCmpImplClass(), deploymentInfo);
            deploymentInfo.setContainer(this);
        }
        EjbTimerService timerService = deploymentInfo.getEjbTimerService();
        if (timerService != null) {
            timerService.start();
        }
    }

    public void undeploy(DeploymentInfo deploymentInfo) throws OpenEJBException {
        EjbTimerService timerService = deploymentInfo.getEjbTimerService();
        if (timerService != null) {
            timerService.stop();
        }
        this.undeploy((CoreDeploymentInfo)deploymentInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(CoreDeploymentInfo deploymentInfo) throws OpenEJBException {
        CmpContainer cmpContainer = this;
        synchronized (cmpContainer) {
            this.deploymentsById.remove(deploymentInfo.getDeploymentID());
            this.deploymentsByClass.remove(deploymentInfo.getCmpImplClass());
            try {
                Field field = deploymentInfo.getCmpImplClass().getField("deploymentInfo");
                field.set(null, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            deploymentInfo.setContainer(null);
            deploymentInfo.setContainerData(null);
        }
    }

    public Object getEjbInstance(DeploymentInfo deployInfo, Object primaryKey) {
        return this.getEjbInstance((CoreDeploymentInfo)deployInfo, primaryKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getEjbInstance(CoreDeploymentInfo deployInfo, Object primaryKey) {
        Object object;
        ThreadContext callContext = new ThreadContext(deployInfo, primaryKey);
        ThreadContext oldCallContext = ThreadContext.enter(callContext);
        try {
            Object bean;
            object = bean = this.cmpEngine.loadBean(callContext, primaryKey);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            ThreadContext.exit(oldCallContext);
            throw throwable;
        }
        ThreadContext.exit(oldCallContext);
        return object;
    }

    public Object invoke(Object deployID, Method callMethod, Object[] args, Object primKey, Object securityIdentity) throws OpenEJBException {
        return this.invoke(deployID, null, callMethod.getDeclaringClass(), callMethod, args, primKey);
    }

    public Object invoke(Object deployID, Class callInterface, Method callMethod, Object[] args, Object primKey) throws OpenEJBException {
        return this.invoke(deployID, null, callInterface, callMethod, args, primKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object deployID, InterfaceType type, Class callInterface, Method callMethod, Object[] args, Object primKey) throws OpenEJBException {
        Object retValue;
        ThreadContext oldCallContext;
        ThreadContext callContext;
        CoreDeploymentInfo deployInfo;
        block16: {
            String methodName;
            Class<?> declaringClass;
            block11: {
                block12: {
                    block15: {
                        block14: {
                            block13: {
                                ProxyInfo proxyInfo;
                                deployInfo = (CoreDeploymentInfo)this.getDeploymentInfo(deployID);
                                if (deployInfo == null) {
                                    throw new OpenEJBException("Deployment does not exist in this container. Deployment(id='" + deployID + "'), Container(id='" + this.containerID + "')");
                                }
                                if (type == null) {
                                    type = deployInfo.getInterfaceType(callInterface);
                                }
                                callContext = new ThreadContext(deployInfo, primKey);
                                oldCallContext = ThreadContext.enter(callContext);
                                try {
                                    boolean authorized = this.securityService.isCallerAuthorized(callMethod, type);
                                    if (!authorized) {
                                        throw new ApplicationException((Exception)new EJBAccessException("Unauthorized Access by Principal Denied"));
                                    }
                                    declaringClass = callMethod.getDeclaringClass();
                                    methodName = callMethod.getName();
                                    if (!EJBHome.class.isAssignableFrom(declaringClass) && !EJBLocalHome.class.isAssignableFrom(declaringClass)) break block11;
                                    if (declaringClass == EJBHome.class || declaringClass == EJBLocalHome.class) break block12;
                                    if (!methodName.startsWith("create")) break block13;
                                    proxyInfo = this.createEJBObject(callMethod, args, callContext);
                                    Object var17_20 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var17_27 = null;
                                    ThreadContext.exit(oldCallContext);
                                    throw throwable;
                                }
                                ThreadContext.exit(oldCallContext);
                                return proxyInfo;
                            }
                            if (!methodName.equals("findByPrimaryKey")) break block14;
                            Object object = this.findByPrimaryKey(callMethod, args, callContext);
                            Object var17_21 = null;
                            ThreadContext.exit(oldCallContext);
                            return object;
                        }
                        if (!methodName.startsWith("find")) break block15;
                        Object object = this.findEJBObject(callMethod, args, callContext);
                        Object var17_22 = null;
                        ThreadContext.exit(oldCallContext);
                        return object;
                    }
                    Object object = this.homeMethod(callMethod, args, callContext);
                    Object var17_23 = null;
                    ThreadContext.exit(oldCallContext);
                    return object;
                }
                if (!methodName.equals("remove")) break block16;
                this.removeEJBObject(callMethod, callContext);
                Object var13_17 = null;
                Object var17_24 = null;
                ThreadContext.exit(oldCallContext);
                return var13_17;
            }
            if (EJBObject.class != declaringClass && EJBLocalObject.class != declaringClass || !methodName.equals("remove")) break block16;
            this.removeEJBObject(callMethod, callContext);
            Object var13_18 = null;
            Object var17_25 = null;
            ThreadContext.exit(oldCallContext);
            return var13_18;
        }
        callContext.setCurrentOperation(Operation.BUSINESS);
        callContext.setCurrentAllowedStates(org.apache.openejb.core.entity.EntityContext.getStates());
        Method runMethod = deployInfo.getMatchingBeanMethod(callMethod);
        callContext.set(Method.class, runMethod);
        Object object = retValue = this.businessMethod(callMethod, runMethod, args, callContext);
        Object var17_26 = null;
        ThreadContext.exit(oldCallContext);
        return object;
    }

    private EntityBean createNewInstance(ThreadContext callContext) {
        CoreDeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
        try {
            EntityBean bean = (EntityBean)deploymentInfo.getCmpImplClass().newInstance();
            return bean;
        }
        catch (Exception e) {
            throw new EJBException("Unable to create new entity bean instance " + deploymentInfo.getCmpImplClass(), e);
        }
    }

    private ThreadContext createThreadContext(EntityBean entityBean) {
        if (entityBean == null) {
            throw new NullPointerException("entityBean is null");
        }
        CoreDeploymentInfo deployInfo = (CoreDeploymentInfo)this.getDeploymentInfoByClass(entityBean.getClass());
        KeyGenerator keyGenerator = deployInfo.getKeyGenerator();
        Object primaryKey = keyGenerator.getPrimaryKey(entityBean);
        ThreadContext callContext = new ThreadContext(deployInfo, primaryKey);
        return callContext;
    }

    private void setEntityContext(EntityBean entityBean) {
        if (entityBean == null) {
            throw new NullPointerException("entityBean is null");
        }
        CoreDeploymentInfo deployInfo = (CoreDeploymentInfo)this.getDeploymentInfoByClass(entityBean.getClass());
        ThreadContext callContext = new ThreadContext(deployInfo, null);
        callContext.setCurrentOperation(Operation.SET_CONTEXT);
        callContext.setCurrentAllowedStates(org.apache.openejb.core.entity.EntityContext.getStates());
        ThreadContext oldCallContext = ThreadContext.enter(callContext);
        try {
            try {
                entityBean.setEntityContext((EntityContext)new org.apache.openejb.core.entity.EntityContext(this.securityService));
            }
            catch (RemoteException e) {
                throw new EJBException((Exception)e);
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            ThreadContext.exit(oldCallContext);
            throw throwable;
        }
        ThreadContext.exit(oldCallContext);
    }

    private void unsetEntityContext(EntityBean entityBean) {
        if (entityBean == null) {
            throw new NullPointerException("entityBean is null");
        }
        ThreadContext callContext = this.createThreadContext(entityBean);
        callContext.setCurrentOperation(Operation.UNSET_CONTEXT);
        callContext.setCurrentAllowedStates(org.apache.openejb.core.entity.EntityContext.getStates());
        ThreadContext oldCallContext = ThreadContext.enter(callContext);
        try {
            try {
                entityBean.unsetEntityContext();
            }
            catch (RemoteException e) {
                throw new EJBException((Exception)e);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            ThreadContext.exit(oldCallContext);
            throw throwable;
        }
        ThreadContext.exit(oldCallContext);
    }

    private void ejbLoad(EntityBean entityBean) {
        if (entityBean == null) {
            throw new NullPointerException("entityBean is null");
        }
        ThreadContext callContext = this.createThreadContext(entityBean);
        callContext.setCurrentOperation(Operation.LOAD);
        callContext.setCurrentAllowedStates(org.apache.openejb.core.entity.EntityContext.getStates());
        ThreadContext oldCallContext = ThreadContext.enter(callContext);
        try {
            try {
                entityBean.ejbLoad();
            }
            catch (RemoteException e) {
                throw new EJBException((Exception)e);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            ThreadContext.exit(oldCallContext);
            throw throwable;
        }
        ThreadContext.exit(oldCallContext);
        try {
            LinkedHashSet<EntityBean> registeredEntities = (LinkedHashSet<EntityBean>)this.synchronizationRegistry.getResource(ENTITIES_TO_STORE);
            if (registeredEntities == null) {
                registeredEntities = new LinkedHashSet<EntityBean>();
                this.synchronizationRegistry.putResource(ENTITIES_TO_STORE, registeredEntities);
                this.synchronizationRegistry.registerInterposedSynchronization(new Synchronization(){

                    public void beforeCompletion() {
                        LinkedHashSet registeredEntities = (LinkedHashSet)CmpContainer.this.synchronizationRegistry.getResource(ENTITIES_TO_STORE);
                        if (registeredEntities == null) {
                            return;
                        }
                        for (EntityBean entityBean : registeredEntities) {
                            CmpContainer.this.ejbStore(entityBean);
                        }
                    }

                    public void afterCompletion(int i) {
                    }
                });
            }
            registeredEntities.add(entityBean);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void ejbStore(EntityBean entityBean) {
        if (entityBean == null) {
            throw new NullPointerException("entityBean is null");
        }
        ThreadContext callContext = this.createThreadContext(entityBean);
        callContext.setCurrentOperation(Operation.STORE);
        callContext.setCurrentAllowedStates(org.apache.openejb.core.entity.EntityContext.getStates());
        ThreadContext oldCallContext = ThreadContext.enter(callContext);
        try {
            try {
                entityBean.ejbStore();
            }
            catch (RemoteException e) {
                throw new EJBException((Exception)e);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            ThreadContext.exit(oldCallContext);
            throw throwable;
        }
        ThreadContext.exit(oldCallContext);
    }

    /*
     * Loose catch block
     */
    private void ejbRemove(EntityBean entityBean) throws RemoveException {
        ThreadContext oldCallContext;
        ThreadContext callContext;
        block9: {
            if (entityBean == null) {
                throw new NullPointerException("entityBean is null");
            }
            if (this.isDeleted(entityBean)) {
                return;
            }
            callContext = this.createThreadContext(entityBean);
            callContext.setCurrentOperation(Operation.REMOVE);
            callContext.setCurrentAllowedStates(org.apache.openejb.core.entity.EntityContext.getStates());
            oldCallContext = ThreadContext.enter(callContext);
            entityBean.ejbRemove();
            Object var6_4 = null;
            try {
                entityBean.getClass().getMethod("OpenEJB_deleted", new Class[0]).invoke((Object)entityBean, new Object[0]);
                break block9;
            }
            catch (Exception ignored) {
                // empty catch block
            }
            {
                break block9;
                catch (RemoteException e) {
                    throw new EJBException((Exception)e);
                }
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                try {
                    entityBean.getClass().getMethod("OpenEJB_deleted", new Class[0]).invoke((Object)entityBean, new Object[0]);
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                this.cancelTimers(callContext);
                ThreadContext.exit(oldCallContext);
                throw throwable;
            }
        }
        this.cancelTimers(callContext);
        ThreadContext.exit(oldCallContext);
    }

    private boolean isDeleted(EntityBean entityBean) {
        try {
            return (Boolean)entityBean.getClass().getMethod("OpenEJB_isDeleted", new Class[0]).invoke((Object)entityBean, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    private void ejbActivate(EntityBean entityBean) {
        if (entityBean == null) {
            throw new NullPointerException("entityBean is null");
        }
        ThreadContext callContext = this.createThreadContext(entityBean);
        callContext.setCurrentOperation(Operation.ACTIVATE);
        callContext.setCurrentAllowedStates(org.apache.openejb.core.entity.EntityContext.getStates());
        ThreadContext oldCallContext = ThreadContext.enter(callContext);
        try {
            try {
                entityBean.ejbActivate();
            }
            catch (RemoteException e) {
                throw new EJBException((Exception)e);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            ThreadContext.exit(oldCallContext);
            throw throwable;
        }
        ThreadContext.exit(oldCallContext);
    }

    private void ejbPassivate(EntityBean entityBean) {
        if (entityBean == null) {
            throw new NullPointerException("entityBean is null");
        }
        ThreadContext callContext = this.createThreadContext(entityBean);
        callContext.setCurrentOperation(Operation.PASSIVATE);
        callContext.setCurrentAllowedStates(org.apache.openejb.core.entity.EntityContext.getStates());
        ThreadContext oldCallContext = ThreadContext.enter(callContext);
        try {
            try {
                entityBean.ejbPassivate();
            }
            catch (RemoteException e) {
                throw new EJBException((Exception)e);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            ThreadContext.exit(oldCallContext);
            throw throwable;
        }
        ThreadContext.exit(oldCallContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object businessMethod(Method callMethod, Method runMethod, Object[] args, ThreadContext callContext) throws OpenEJBException {
        CoreDeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
        TransactionPolicy txPolicy = EjbTransactionUtil.createTransactionPolicy(deploymentInfo.getTransactionType(callMethod), callContext);
        Object returnValue = null;
        this.entrancyTracker.enter(deploymentInfo, callContext.getPrimaryKey());
        try {
            try {
                EntityBean bean = (EntityBean)this.cmpEngine.loadBean(callContext, callContext.getPrimaryKey());
                if (bean == null) {
                    throw new NoSuchObjectException(deploymentInfo.getDeploymentID() + " : " + callContext.getPrimaryKey());
                }
                returnValue = runMethod.invoke((Object)bean, args);
                this.cmpEngine.storeBeanIfNoTx(callContext, bean);
            }
            catch (NoSuchObjectException e) {
                EjbTransactionUtil.handleApplicationException(txPolicy, e, false);
                Object var12_10 = null;
                this.entrancyTracker.exit(deploymentInfo, callContext.getPrimaryKey());
                EjbTransactionUtil.afterInvoke(txPolicy, callContext);
                return returnValue;
            }
            catch (Throwable e) {
                ExceptionType type;
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getTargetException();
                }
                if ((type = callContext.getDeploymentInfo().getExceptionType(e)) == ExceptionType.SYSTEM) {
                    EjbTransactionUtil.handleSystemException(txPolicy, e, callContext);
                } else {
                    EjbTransactionUtil.handleApplicationException(txPolicy, e, type == ExceptionType.APPLICATION_ROLLBACK);
                }
                Object var12_11 = null;
                this.entrancyTracker.exit(deploymentInfo, callContext.getPrimaryKey());
                EjbTransactionUtil.afterInvoke(txPolicy, callContext);
                return returnValue;
            }
            Object var12_9 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            this.entrancyTracker.exit(deploymentInfo, callContext.getPrimaryKey());
            EjbTransactionUtil.afterInvoke(txPolicy, callContext);
            throw throwable;
        }
        this.entrancyTracker.exit(deploymentInfo, callContext.getPrimaryKey());
        EjbTransactionUtil.afterInvoke(txPolicy, callContext);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object homeMethod(Method callMethod, Object[] args, ThreadContext callContext) throws OpenEJBException {
        CoreDeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
        TransactionPolicy txPolicy = EjbTransactionUtil.createTransactionPolicy(deploymentInfo.getTransactionType(callMethod), callContext);
        Object returnValue = null;
        try {
            try {
                EntityBean bean = this.createNewInstance(callContext);
                this.setEntityContext(bean);
                try {
                    callContext.setCurrentOperation(Operation.HOME);
                    callContext.setCurrentAllowedStates(org.apache.openejb.core.entity.EntityContext.getStates());
                    Method runMethod = deploymentInfo.getMatchingBeanMethod(callMethod);
                    try {
                        returnValue = runMethod.invoke((Object)bean, args);
                    }
                    catch (IllegalArgumentException e) {
                        System.out.println("********************************************************");
                        System.out.println("callMethod = " + callMethod);
                        System.out.println("runMethod = " + runMethod);
                        System.out.println("bean = " + bean.getClass().getName());
                        throw e;
                    }
                    Object var11_13 = null;
                    this.unsetEntityContext(bean);
                }
                catch (Throwable throwable) {
                    Object var11_14 = null;
                    this.unsetEntityContext(bean);
                    throw throwable;
                }
                Object var13_16 = null;
            }
            catch (Throwable e) {
                ExceptionType type;
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getTargetException();
                }
                if ((type = callContext.getDeploymentInfo().getExceptionType(e)) == ExceptionType.SYSTEM) {
                    EjbTransactionUtil.handleSystemException(txPolicy, e, callContext);
                } else {
                    EjbTransactionUtil.handleApplicationException(txPolicy, e, type == ExceptionType.APPLICATION_ROLLBACK);
                }
                Object var13_17 = null;
                EjbTransactionUtil.afterInvoke(txPolicy, callContext);
                return returnValue;
            }
        }
        catch (Throwable throwable) {
            Object var13_18 = null;
            EjbTransactionUtil.afterInvoke(txPolicy, callContext);
            throw throwable;
        }
        EjbTransactionUtil.afterInvoke(txPolicy, callContext);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ProxyInfo createEJBObject(Method callMethod, Object[] args, ThreadContext callContext) throws OpenEJBException {
        CoreDeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
        TransactionPolicy txPolicy = EjbTransactionUtil.createTransactionPolicy(deploymentInfo.getTransactionType(callMethod), callContext);
        Object primaryKey = null;
        try {
            try {
                EntityBean bean = this.createNewInstance(callContext);
                this.setEntityContext(bean);
                Method ejbCreateMethod = deploymentInfo.getMatchingBeanMethod(callMethod);
                callContext.setCurrentOperation(Operation.CREATE);
                callContext.setCurrentAllowedStates(org.apache.openejb.core.entity.EntityContext.getStates());
                ejbCreateMethod.invoke((Object)bean, args);
                primaryKey = this.cmpEngine.createBean(bean, callContext);
                Method ejbPostCreateMethod = deploymentInfo.getMatchingPostCreateMethod(ejbCreateMethod);
                ThreadContext postCreateContext = new ThreadContext(deploymentInfo, primaryKey);
                postCreateContext.setCurrentOperation(Operation.POST_CREATE);
                postCreateContext.setCurrentAllowedStates(org.apache.openejb.core.entity.EntityContext.getStates());
                ThreadContext oldContext = ThreadContext.enter(postCreateContext);
                try {
                    ejbPostCreateMethod.invoke((Object)bean, args);
                    Object var13_15 = null;
                }
                catch (Throwable throwable) {
                    Object var13_16 = null;
                    ThreadContext.exit(oldContext);
                    throw throwable;
                }
                ThreadContext.exit(oldContext);
                this.cmpEngine.storeBeanIfNoTx(callContext, bean);
            }
            catch (Throwable e) {
                ExceptionType type;
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getTargetException();
                }
                if ((type = callContext.getDeploymentInfo().getExceptionType(e)) == ExceptionType.SYSTEM) {
                    EjbTransactionUtil.handleSystemException(txPolicy, e, callContext);
                } else {
                    EjbTransactionUtil.handleApplicationException(txPolicy, e, type == ExceptionType.APPLICATION_ROLLBACK);
                }
                Object var15_19 = null;
                EjbTransactionUtil.afterInvoke(txPolicy, callContext);
                return new ProxyInfo(deploymentInfo, primaryKey);
            }
            Object var15_18 = null;
        }
        catch (Throwable throwable) {
            Object var15_20 = null;
            EjbTransactionUtil.afterInvoke(txPolicy, callContext);
            throw throwable;
        }
        EjbTransactionUtil.afterInvoke(txPolicy, callContext);
        return new ProxyInfo(deploymentInfo, primaryKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object findByPrimaryKey(Method callMethod, Object[] args, ThreadContext callContext) throws OpenEJBException {
        ProxyInfo proxyInfo;
        CoreDeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
        TransactionPolicy txPolicy = EjbTransactionUtil.createTransactionPolicy(deploymentInfo.getTransactionType(callMethod), callContext);
        try {
            try {
                EntityBean bean = (EntityBean)this.cmpEngine.loadBean(callContext, args[0]);
                if (bean == null) {
                    throw new ObjectNotFoundException(deploymentInfo.getDeploymentID() + " : " + args[0]);
                }
                KeyGenerator kg = deploymentInfo.getKeyGenerator();
                Object primaryKey = kg.getPrimaryKey(bean);
                proxyInfo = new ProxyInfo(deploymentInfo, primaryKey);
                Object var11_12 = null;
            }
            catch (FinderException fe) {
                EjbTransactionUtil.handleApplicationException(txPolicy, fe, false);
                Object var11_13 = null;
                EjbTransactionUtil.afterInvoke(txPolicy, callContext);
                throw new AssertionError((Object)"Should not get here");
            }
            catch (Throwable e) {
                EjbTransactionUtil.handleSystemException(txPolicy, e, callContext);
                Object var11_14 = null;
                EjbTransactionUtil.afterInvoke(txPolicy, callContext);
                throw new AssertionError((Object)"Should not get here");
            }
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            EjbTransactionUtil.afterInvoke(txPolicy, callContext);
            throw throwable;
        }
        EjbTransactionUtil.afterInvoke(txPolicy, callContext);
        return proxyInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object findEJBObject(Method callMethod, Object[] args, ThreadContext callContext) throws OpenEJBException {
        ProxyInfo proxyInfo;
        TransactionPolicy txPolicy;
        block13: {
            Object i$2;
            block12: {
                CoreDeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
                txPolicy = EjbTransactionUtil.createTransactionPolicy(deploymentInfo.getTransactionType(callMethod), callContext);
                try {
                    try {
                        List<Object> results = this.cmpEngine.queryBeans(callContext, callMethod, args);
                        KeyGenerator kg = deploymentInfo.getKeyGenerator();
                        if (callMethod.getReturnType() == Collection.class || callMethod.getReturnType() == Enumeration.class) {
                            Object i$2;
                            ArrayList<ProxyInfo> proxies = new ArrayList<ProxyInfo>();
                            for (Object value : results) {
                                EntityBean bean = (EntityBean)value;
                                if (value == null) {
                                    proxies.add(null);
                                    continue;
                                }
                                Object primaryKey = kg.getPrimaryKey(bean);
                                proxies.add(new ProxyInfo(deploymentInfo, primaryKey));
                            }
                            if (callMethod.getReturnType() == Enumeration.class) {
                                i$2 = new Enumerator(proxies);
                                Object var14_19 = null;
                                EjbTransactionUtil.afterInvoke(txPolicy, callContext);
                                return i$2;
                            }
                            i$2 = proxies;
                            Object var14_20 = null;
                            EjbTransactionUtil.afterInvoke(txPolicy, callContext);
                            return i$2;
                        }
                        if (results.size() != 1) {
                            throw new ObjectNotFoundException("A Enteprise bean with deployment_id = " + deploymentInfo.getDeploymentID() + " and primarykey = " + args[0] + " Does not exist");
                        }
                        EntityBean bean = (EntityBean)results.get(0);
                        if (bean == null) {
                            i$2 = null;
                            break block12;
                        }
                        Object primaryKey = kg.getPrimaryKey(bean);
                        proxyInfo = new ProxyInfo(deploymentInfo, primaryKey);
                        break block13;
                    }
                    catch (FinderException fe) {
                        EjbTransactionUtil.handleApplicationException(txPolicy, fe, false);
                        Object var14_23 = null;
                        EjbTransactionUtil.afterInvoke(txPolicy, callContext);
                        throw new AssertionError((Object)"Should not get here");
                    }
                    catch (Throwable e) {
                        EjbTransactionUtil.handleSystemException(txPolicy, e, callContext);
                        Object var14_24 = null;
                        EjbTransactionUtil.afterInvoke(txPolicy, callContext);
                        throw new AssertionError((Object)"Should not get here");
                    }
                }
                catch (Throwable throwable) {
                    Object var14_25 = null;
                    EjbTransactionUtil.afterInvoke(txPolicy, callContext);
                    throw throwable;
                }
            }
            Object var14_21 = null;
            EjbTransactionUtil.afterInvoke(txPolicy, callContext);
            return i$2;
        }
        Object var14_22 = null;
        EjbTransactionUtil.afterInvoke(txPolicy, callContext);
        return proxyInfo;
    }

    /*
     * WARNING - void declaration
     */
    public Object select(DeploymentInfo di, String methodSignature, String returnType, Object ... args) throws FinderException {
        CoreDeploymentInfo deploymentInfo = (CoreDeploymentInfo)di;
        String signature = deploymentInfo.getAbstractSchemaName() + "." + methodSignature;
        try {
            List<Object> results = this.cmpEngine.queryBeans(deploymentInfo, signature, args);
            AbstractCollection proxies = returnType.equals("java.util.Set") ? new LinkedHashSet() : new ArrayList();
            boolean isSingleValued = !returnType.equals("java.util.Collection") && !returnType.equals("java.util.Set");
            ProxyFactory proxyFactory = null;
            for (Object e : results) {
                void var12_13;
                if (isSingleValued && !proxies.isEmpty()) {
                    throw new FinderException("The single valued query " + methodSignature + "returned more than one item");
                }
                if (e instanceof EntityBean) {
                    CoreDeploymentInfo resultInfo;
                    EntityBean entityBean = (EntityBean)e;
                    if (proxyFactory == null && (resultInfo = (CoreDeploymentInfo)this.getDeploymentInfoByClass(entityBean.getClass())) != null) {
                        proxyFactory = new ProxyFactory(resultInfo);
                    }
                    if (proxyFactory != null) {
                        if (deploymentInfo.isRemoteQueryResults(methodSignature)) {
                            Object object = proxyFactory.createRemoteProxy(entityBean, this);
                        } else {
                            Object object = proxyFactory.createLocalProxy(entityBean, this);
                        }
                    }
                }
                proxies.add(var12_13);
            }
            if (!isSingleValued) {
                return proxies;
            }
            if (proxies.isEmpty()) {
                throw new ObjectNotFoundException();
            }
            Object returnValue = proxies.iterator().next();
            return returnValue;
        }
        catch (RuntimeException e) {
            throw new EJBException((Exception)e);
        }
    }

    public int update(DeploymentInfo di, String methodSignature, Object ... args) throws FinderException {
        CoreDeploymentInfo deploymentInfo = (CoreDeploymentInfo)di;
        String signature = deploymentInfo.getAbstractSchemaName() + "." + methodSignature;
        int result = this.cmpEngine.executeUpdateQuery(deploymentInfo, signature, args);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeEJBObject(Method callMethod, ThreadContext callContext) throws OpenEJBException {
        CoreDeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
        TransactionPolicy txPolicy = EjbTransactionUtil.createTransactionPolicy(deploymentInfo.getTransactionType(callMethod), callContext);
        try {
            try {
                EntityBean entityBean = (EntityBean)this.cmpEngine.loadBean(callContext, callContext.getPrimaryKey());
                if (entityBean == null) {
                    throw new NoSuchObjectException(callContext.getDeploymentInfo().getDeploymentID() + " " + callContext.getPrimaryKey());
                }
                this.ejbRemove(entityBean);
                this.cmpEngine.removeBean(callContext);
            }
            catch (NoSuchObjectException e) {
                EjbTransactionUtil.handleApplicationException(txPolicy, e, false);
                Object var7_9 = null;
                EjbTransactionUtil.afterInvoke(txPolicy, callContext);
                return;
            }
            catch (Throwable e) {
                EjbTransactionUtil.handleSystemException(txPolicy, e, callContext);
                Object var7_10 = null;
                EjbTransactionUtil.afterInvoke(txPolicy, callContext);
                return;
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            EjbTransactionUtil.afterInvoke(txPolicy, callContext);
            throw throwable;
        }
        EjbTransactionUtil.afterInvoke(txPolicy, callContext);
    }

    private void cancelTimers(ThreadContext threadContext) {
        EjbTimerService timerService;
        CoreDeploymentInfo deploymentInfo = threadContext.getDeploymentInfo();
        Object primaryKey = threadContext.getPrimaryKey();
        if (primaryKey != null && deploymentInfo.getEjbTimerService() != null && (timerService = deploymentInfo.getEjbTimerService()) != null && timerService instanceof EjbTimerServiceImpl) {
            for (Timer timer : deploymentInfo.getEjbTimerService().getTimers(primaryKey)) {
                timer.cancel();
            }
        }
    }

    private class ContainerCmpCallback
    implements CmpCallback {
        private ContainerCmpCallback() {
        }

        public void setEntityContext(EntityBean entity) {
            CmpContainer.this.setEntityContext(entity);
        }

        public void unsetEntityContext(EntityBean entity) {
            CmpContainer.this.unsetEntityContext(entity);
        }

        public void ejbActivate(EntityBean entity) {
            CmpContainer.this.ejbActivate(entity);
        }

        public void ejbPassivate(EntityBean entity) {
            CmpContainer.this.ejbPassivate(entity);
        }

        public void ejbLoad(EntityBean entity) {
            CmpContainer.this.ejbLoad(entity);
        }

        public void ejbStore(EntityBean entity) {
            CmpContainer.this.ejbStore(entity);
        }

        public void ejbRemove(EntityBean entity) throws RemoveException {
            CmpContainer.this.ejbRemove(entity);
        }
    }
}

