/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.ivm.naming;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import org.apache.openejb.core.ivm.EjbObjectInputStream;
import org.apache.openejb.core.ivm.IntraVmCopyMonitor;
import org.apache.openejb.core.ivm.naming.IntraVmJndiReference;
import org.apache.openejb.core.ivm.naming.NamingException;

public class CrossClassLoaderJndiReference
extends IntraVmJndiReference {
    public CrossClassLoaderJndiReference(String jndiName) {
        super(jndiName);
    }

    public Object getObject() throws javax.naming.NamingException {
        Object o = super.getObject();
        try {
            o = CrossClassLoaderJndiReference.copy(o);
        }
        catch (Exception e) {
            throw new NamingException("Error copying object into local class loader", e);
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object copy(Object source) throws Exception {
        IntraVmCopyMonitor.preCrossClassLoaderOperation();
        try {
            Object copy;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
            ObjectOutputStream out = new ObjectOutputStream(baos);
            out.writeObject(source);
            out.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            EjbObjectInputStream in = new EjbObjectInputStream(bais);
            Object object = copy = in.readObject();
            return object;
        }
        finally {
            IntraVmCopyMonitor.postCrossClassLoaderOperation();
        }
    }
}

