/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.ivm.naming;

import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.openejb.SystemException;
import org.apache.openejb.core.JndiFactory;
import org.apache.openejb.core.ivm.naming.IvmContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IvmJndiFactory
implements JndiFactory {
    private Context jndiRootContext = IvmContext.createRootContext();

    @Override
    public Context createComponentContext(Map<String, Object> bindings) throws SystemException {
        IvmContext context = new IvmContext();
        try {
            context.bind("java:comp/env/dummy", (Object)"dummy");
        }
        catch (NamingException e) {
            throw new SystemException("Unable to create subcontext 'java:comp/env'.  Exception:" + e.getMessage(), e);
        }
        for (Map.Entry<String, Object> entry : bindings.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            try {
                context.bind(name, value);
            }
            catch (NamingException e) {
                throw new SystemException("Unable to bind '" + name + "' into bean's enc.", e);
            }
        }
        return context;
    }

    @Override
    public Context createRootContext() {
        return this.jndiRootContext;
    }
}

