/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.managed;

import javax.transaction.UserTransaction;
import javax.xml.rpc.handler.MessageContext;
import org.apache.openejb.core.BaseContext;
import org.apache.openejb.core.BaseSessionContext;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.spi.SecurityService;

public class ManagedContext
extends BaseSessionContext {
    protected static final BaseContext.State[] states = new BaseContext.State[Operation.values().length];

    public static BaseContext.State[] getStates() {
        return states;
    }

    public ManagedContext(SecurityService securityService, UserTransaction userTransaction) {
        super(securityService, userTransaction);
    }

    protected BaseContext.State getState() {
        Operation operation = ThreadContext.getThreadContext().getCurrentOperation();
        BaseContext.State state = states[operation.ordinal()];
        if (state == null) {
            throw new IllegalArgumentException("Invalid operation " + (Object)((Object)operation) + " for this context");
        }
        return state;
    }

    static {
        ManagedContext.states[Operation.INJECTION.ordinal()] = new BaseSessionContext.InjectionSessionState();
        ManagedContext.states[Operation.CREATE.ordinal()] = new LifecycleManagedBeanState();
        ManagedContext.states[Operation.BUSINESS.ordinal()] = new BaseSessionContext.BusinessSessionState();
        ManagedContext.states[Operation.AFTER_BEGIN.ordinal()] = new BeforeCompletion();
        ManagedContext.states[Operation.BEFORE_COMPLETION.ordinal()] = new BeforeCompletion();
        ManagedContext.states[Operation.AFTER_COMPLETION.ordinal()] = new AfterCompletion();
        ManagedContext.states[Operation.TIMEOUT.ordinal()] = new BaseSessionContext.TimeoutSessionState();
        ManagedContext.states[Operation.PRE_DESTROY.ordinal()] = new LifecycleManagedBeanState();
        ManagedContext.states[Operation.REMOVE.ordinal()] = new LifecycleManagedBeanState();
        ManagedContext.states[Operation.POST_CONSTRUCT.ordinal()] = new LifecycleManagedBeanState();
    }

    public static class AfterCompletion
    extends BaseSessionContext.SessionState {
        public MessageContext getMessageContext() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public Class getInvokedBusinessInterface() {
            throw new IllegalStateException();
        }

        public void setRollbackOnly() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public boolean getRollbackOnly() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public boolean isUserTransactionAccessAllowed() {
            return false;
        }

        public boolean isMessageContextAccessAllowed() {
            return false;
        }

        public boolean isJNDIAccessAllowed() {
            return false;
        }

        public boolean isEntityManagerFactoryAccessAllowed() {
            return false;
        }

        public boolean isEntityManagerAccessAllowed() {
            return false;
        }

        public boolean isTimerAccessAllowed() {
            return false;
        }

        public boolean isTimerMethodAllowed() {
            return false;
        }
    }

    public static class BeforeCompletion
    extends BaseSessionContext.SessionState {
        public Class getInvokedBusinessInterface() {
            throw new IllegalStateException();
        }

        public MessageContext getMessageContext() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public boolean isMessageContextAccessAllowed() {
            return false;
        }
    }

    public static class LifecycleManagedBeanState
    extends BaseSessionContext.SessionState {
        public MessageContext getMessageContext() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public Class getInvokedBusinessInterface() {
            throw new IllegalStateException();
        }

        public void setRollbackOnly() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public boolean getRollbackOnly() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public boolean isMessageContextAccessAllowed() {
            return false;
        }

        public boolean isTimerAccessAllowed() {
            return false;
        }

        public boolean isTimerMethodAllowed() {
            return false;
        }
    }
}

