/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.mdb;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import org.apache.openejb.core.CoreDeploymentInfo;
import org.apache.openejb.core.mdb.EndpointHandler;
import org.apache.openejb.core.mdb.MdbContainer;
import org.apache.openejb.core.mdb.MdbInstanceFactory;
import org.apache.openejb.core.transaction.TransactionType;
import org.apache.openejb.resource.XAResourceWrapper;

public class EndpointFactory
implements MessageEndpointFactory {
    private final ActivationSpec activationSpec;
    private final MdbContainer container;
    private final CoreDeploymentInfo deploymentInfo;
    private final MdbInstanceFactory instanceFactory;
    private final ClassLoader classLoader;
    private final Class[] interfaces;
    private final XAResourceWrapper xaResourceWrapper;
    protected final List<ObjectName> jmxNames = new ArrayList<ObjectName>();

    public EndpointFactory(ActivationSpec activationSpec, MdbContainer container, CoreDeploymentInfo deploymentInfo, MdbInstanceFactory instanceFactory, XAResourceWrapper xaResourceWrapper) {
        this.activationSpec = activationSpec;
        this.container = container;
        this.deploymentInfo = deploymentInfo;
        this.instanceFactory = instanceFactory;
        this.classLoader = container.getMessageListenerInterface().getClassLoader();
        this.interfaces = new Class[]{container.getMessageListenerInterface(), MessageEndpoint.class};
        this.xaResourceWrapper = xaResourceWrapper;
    }

    public ActivationSpec getActivationSpec() {
        return this.activationSpec;
    }

    public MdbInstanceFactory getInstanceFactory() {
        return this.instanceFactory;
    }

    public MessageEndpoint createEndpoint(XAResource xaResource) throws UnavailableException {
        if (xaResource != null && this.xaResourceWrapper != null) {
            xaResource = this.xaResourceWrapper.wrap(xaResource, this.container.getContainerID().toString());
        }
        EndpointHandler endpointHandler = new EndpointHandler(this.container, this.deploymentInfo, this.instanceFactory, xaResource);
        MessageEndpoint messageEndpoint = (MessageEndpoint)Proxy.newProxyInstance(this.classLoader, this.interfaces, (InvocationHandler)endpointHandler);
        return messageEndpoint;
    }

    public boolean isDeliveryTransacted(Method method) throws NoSuchMethodException {
        TransactionType transactionType = this.deploymentInfo.getTransactionType(method);
        return TransactionType.Required == transactionType;
    }
}

