/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.singleton;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.ejb.ConcurrentAccessTimeoutException;
import javax.ejb.EJBAccessException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.interceptor.AroundInvoke;
import javax.xml.rpc.handler.MessageContext;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.ContainerType;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.ProxyInfo;
import org.apache.openejb.RpcContainer;
import org.apache.openejb.core.CoreDeploymentInfo;
import org.apache.openejb.core.ExceptionType;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.interceptor.InterceptorData;
import org.apache.openejb.core.interceptor.InterceptorStack;
import org.apache.openejb.core.singleton.Instance;
import org.apache.openejb.core.singleton.SingletonContext;
import org.apache.openejb.core.singleton.SingletonInstanceManager;
import org.apache.openejb.core.timer.EjbTimerService;
import org.apache.openejb.core.transaction.EjbTransactionUtil;
import org.apache.openejb.core.transaction.TransactionPolicy;
import org.apache.openejb.core.webservices.AddressingSupport;
import org.apache.openejb.core.webservices.NoAddressingSupport;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.Duration;
import org.apache.xbean.finder.ClassFinder;

public class SingletonContainer
implements RpcContainer {
    private SingletonInstanceManager instanceManager;
    private HashMap<String, DeploymentInfo> deploymentRegistry = new HashMap();
    private Object containerID = null;
    private SecurityService securityService;
    private long wait = 30L;
    private TimeUnit unit = TimeUnit.SECONDS;

    public SingletonContainer(Object id, SecurityService securityService) throws OpenEJBException {
        this.containerID = id;
        this.securityService = securityService;
        this.instanceManager = new SingletonInstanceManager(securityService);
        for (DeploymentInfo deploymentInfo : this.deploymentRegistry.values()) {
            CoreDeploymentInfo di = (CoreDeploymentInfo)deploymentInfo;
            di.setContainer(this);
        }
    }

    public void setAccessTimeout(Duration duration) {
        if (duration.getUnit() != null) {
            this.unit = duration.getUnit();
        }
        this.wait = duration.getTime();
    }

    public synchronized DeploymentInfo[] deployments() {
        return this.deploymentRegistry.values().toArray(new DeploymentInfo[this.deploymentRegistry.size()]);
    }

    public synchronized DeploymentInfo getDeploymentInfo(Object deploymentID) {
        String id = (String)deploymentID;
        return this.deploymentRegistry.get(id);
    }

    public ContainerType getContainerType() {
        return ContainerType.SINGLETON;
    }

    public Object getContainerID() {
        return this.containerID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentInfo info) throws OpenEJBException {
        CoreDeploymentInfo deploymentInfo = (CoreDeploymentInfo)info;
        this.instanceManager.deploy(deploymentInfo);
        String id = (String)deploymentInfo.getDeploymentID();
        SingletonContainer singletonContainer = this;
        synchronized (singletonContainer) {
            this.deploymentRegistry.put(id, deploymentInfo);
            deploymentInfo.setContainer(this);
        }
        EjbTimerService timerService = deploymentInfo.getEjbTimerService();
        if (timerService != null) {
            timerService.start();
        }
        if (deploymentInfo.isLoadOnStartup()) {
            try {
                ThreadContext callContext = new ThreadContext(deploymentInfo, null);
                ThreadContext old = ThreadContext.enter(callContext);
                try {
                    this.instanceManager.getInstance(callContext);
                    Object var8_9 = null;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    ThreadContext.exit(old);
                    throw throwable;
                }
                ThreadContext.exit(old);
                {
                }
            }
            catch (OpenEJBException e) {
                throw new OpenEJBException("Singleton startup failed: " + deploymentInfo.getDeploymentID(), e);
            }
        }
    }

    public void undeploy(DeploymentInfo info) {
        this.undeploy((CoreDeploymentInfo)info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undeploy(CoreDeploymentInfo deploymentInfo) {
        SingletonContainer singletonContainer;
        ThreadContext threadContext = new ThreadContext(deploymentInfo, null);
        ThreadContext old = ThreadContext.enter(threadContext);
        try {
            this.instanceManager.freeInstance(threadContext);
            singletonContainer = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ThreadContext.exit(old);
            throw throwable;
        }
        ThreadContext.exit(old);
        this.instanceManager.undeploy(deploymentInfo);
        EjbTimerService timerService = deploymentInfo.getEjbTimerService();
        if (timerService != null) {
            timerService.stop();
        }
        singletonContainer = this;
        synchronized (singletonContainer) {
            String id = (String)deploymentInfo.getDeploymentID();
            deploymentInfo.setContainer(null);
            deploymentInfo.setContainerData(null);
            this.deploymentRegistry.remove(id);
        }
    }

    public Object invoke(Object deployID, Method callMethod, Object[] args, Object primKey, Object securityIdentity) throws OpenEJBException {
        return this.invoke(deployID, null, callMethod.getDeclaringClass(), callMethod, args, primKey);
    }

    public Object invoke(Object deployID, Class callInterface, Method callMethod, Object[] args, Object primKey) throws OpenEJBException {
        return this.invoke(deployID, null, callInterface, callMethod, args, primKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object deployID, InterfaceType type, Class callInterface, Method callMethod, Object[] args, Object primKey) throws OpenEJBException {
        Object retValue;
        ThreadContext oldCallContext;
        ThreadContext callContext;
        CoreDeploymentInfo deployInfo;
        block10: {
            Class<?> declaringClass;
            block8: {
                block9: {
                    ProxyInfo proxyInfo;
                    deployInfo = (CoreDeploymentInfo)this.getDeploymentInfo(deployID);
                    if (deployInfo == null) {
                        throw new OpenEJBException("Deployment does not exist in this container. Deployment(id='" + deployID + "'), Container(id='" + this.containerID + "')");
                    }
                    if (type == null) {
                        type = deployInfo.getInterfaceType(callInterface);
                    }
                    callContext = new ThreadContext(deployInfo, primKey);
                    oldCallContext = ThreadContext.enter(callContext);
                    try {
                        boolean authorized = this.getSecurityService().isCallerAuthorized(callMethod, type);
                        if (!authorized) {
                            throw new ApplicationException((Exception)new EJBAccessException("Unauthorized Access by Principal Denied"));
                        }
                        declaringClass = callMethod.getDeclaringClass();
                        if (!EJBHome.class.isAssignableFrom(declaringClass) && !EJBLocalHome.class.isAssignableFrom(declaringClass)) break block8;
                        if (!callMethod.getName().startsWith("create")) break block9;
                        proxyInfo = this.createEJBObject(deployInfo, callMethod);
                        Object var17_16 = null;
                    }
                    catch (Throwable throwable) {
                        Object var17_20 = null;
                        ThreadContext.exit(oldCallContext);
                        throw throwable;
                    }
                    ThreadContext.exit(oldCallContext);
                    return proxyInfo;
                }
                Object var12_13 = null;
                Object var17_17 = null;
                ThreadContext.exit(oldCallContext);
                return var12_13;
            }
            if (EJBObject.class != declaringClass && EJBLocalObject.class != declaringClass) break block10;
            Object var12_14 = null;
            Object var17_18 = null;
            ThreadContext.exit(oldCallContext);
            return var12_14;
        }
        Instance instance = this.instanceManager.getInstance(callContext);
        callContext.setCurrentOperation(Operation.BUSINESS);
        callContext.setCurrentAllowedStates(SingletonContext.getStates());
        Method runMethod = deployInfo.getMatchingBeanMethod(callMethod);
        callContext.set(Method.class, runMethod);
        callContext.setInvokedInterface(callInterface);
        Object object = retValue = this._invoke(callMethod, runMethod, args, instance, callContext, type);
        Object var17_19 = null;
        ThreadContext.exit(oldCallContext);
        return object;
    }

    private SecurityService getSecurityService() {
        return this.securityService;
    }

    public SingletonInstanceManager getInstanceManager() {
        return this.instanceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object _invoke(Method callMethod, Method runMethod, Object[] args, Instance instance, ThreadContext callContext, InterfaceType callType) throws OpenEJBException {
        CoreDeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
        boolean read = deploymentInfo.getConcurrencyAttribute(runMethod) == 6;
        Lock lock = this.aquireLock(read, instance);
        try {
            Object returnValue;
            block11: {
                TransactionPolicy txPolicy = EjbTransactionUtil.createTransactionPolicy(deploymentInfo.getTransactionType(callMethod), callContext);
                returnValue = null;
                try {
                    try {
                        if (callType == InterfaceType.SERVICE_ENDPOINT) {
                            callContext.setCurrentOperation(Operation.BUSINESS_WS);
                            returnValue = this.invokeWebService(args, deploymentInfo, runMethod, instance);
                        } else {
                            List<InterceptorData> interceptors = deploymentInfo.getMethodInterceptors(runMethod);
                            InterceptorStack interceptorStack = new InterceptorStack(instance.bean, runMethod, Operation.BUSINESS, interceptors, instance.interceptors);
                            returnValue = interceptorStack.invoke(args);
                        }
                    }
                    catch (Throwable e) {
                        ExceptionType type = deploymentInfo.getExceptionType(e);
                        if (type == ExceptionType.SYSTEM) {
                            EjbTransactionUtil.handleSystemException(txPolicy, e, callContext);
                        } else {
                            EjbTransactionUtil.handleApplicationException(txPolicy, e, type == ExceptionType.APPLICATION_ROLLBACK);
                        }
                        Object var15_17 = null;
                        EjbTransactionUtil.afterInvoke(txPolicy, callContext);
                        break block11;
                    }
                    Object var15_16 = null;
                }
                catch (Throwable throwable) {
                    Object var15_18 = null;
                    EjbTransactionUtil.afterInvoke(txPolicy, callContext);
                    throw throwable;
                }
                EjbTransactionUtil.afterInvoke(txPolicy, callContext);
            }
            Object var17_20 = null;
            lock.unlock();
            return returnValue;
        }
        catch (Throwable throwable) {
            Object var17_21 = null;
            lock.unlock();
            throw throwable;
        }
    }

    private Lock aquireLock(boolean read, Instance instance) {
        Lock lock = read ? instance.lock.readLock() : instance.lock.writeLock();
        try {
            if (!lock.tryLock(this.wait, this.unit)) {
                throw new ConcurrentAccessTimeoutException();
            }
        }
        catch (InterruptedException e) {
            throw (ConcurrentAccessTimeoutException)new ConcurrentAccessTimeoutException().initCause((Throwable)e);
        }
        return lock;
    }

    private Object invokeWebService(Object[] args, CoreDeploymentInfo deploymentInfo, Method runMethod, Instance instance) throws Exception {
        if (args.length < 2) {
            throw new IllegalArgumentException("WebService calls must follow format {messageContext, interceptor, [arg...]}.");
        }
        Object messageContext = args[0];
        if (messageContext == null) {
            throw new IllegalArgumentException("MessageContext is null.");
        }
        Object interceptor = args[1];
        if (interceptor == null) {
            throw new IllegalArgumentException("Interceptor instance is null.");
        }
        HashMap<String, Object> interceptors = new HashMap<String, Object>(instance.interceptors);
        interceptors.put(interceptor.getClass().getName(), interceptor);
        ArrayList<InterceptorData> interceptorDatas = new ArrayList<InterceptorData>(deploymentInfo.getMethodInterceptors(runMethod));
        InterceptorData providerData = new InterceptorData(interceptor.getClass());
        ClassFinder finder = new ClassFinder(new Class[]{interceptor.getClass()});
        providerData.getAroundInvoke().addAll(finder.findAnnotatedMethods(AroundInvoke.class));
        interceptorDatas.add(providerData);
        InterceptorStack interceptorStack = new InterceptorStack(instance.bean, runMethod, Operation.BUSINESS_WS, interceptorDatas, interceptors);
        Object[] params = new Object[runMethod.getParameterTypes().length];
        if (messageContext instanceof MessageContext) {
            ThreadContext.getThreadContext().set(MessageContext.class, (MessageContext)messageContext);
            return interceptorStack.invoke((MessageContext)messageContext, params);
        }
        if (messageContext instanceof javax.xml.ws.handler.MessageContext) {
            AddressingSupport wsaSupport = NoAddressingSupport.INSTANCE;
            for (int i = 2; i < args.length; ++i) {
                if (!(args[i] instanceof AddressingSupport)) continue;
                wsaSupport = (AddressingSupport)args[i];
            }
            ThreadContext.getThreadContext().set(AddressingSupport.class, wsaSupport);
            ThreadContext.getThreadContext().set(javax.xml.ws.handler.MessageContext.class, (javax.xml.ws.handler.MessageContext)messageContext);
            return interceptorStack.invoke((javax.xml.ws.handler.MessageContext)messageContext, params);
        }
        throw new IllegalArgumentException("Uknown MessageContext type: " + messageContext.getClass().getName());
    }

    protected ProxyInfo createEJBObject(CoreDeploymentInfo deploymentInfo, Method callMethod) {
        return new ProxyInfo(deploymentInfo, null);
    }
}

