/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.stateful;

import javax.transaction.UserTransaction;
import javax.xml.rpc.handler.MessageContext;
import org.apache.openejb.core.BaseContext;
import org.apache.openejb.core.BaseSessionContext;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.spi.SecurityService;

public class StatefulContext
extends BaseSessionContext {
    protected static final BaseContext.State[] states = new BaseContext.State[Operation.values().length];

    public static BaseContext.State[] getStates() {
        return states;
    }

    public StatefulContext(SecurityService securityService, UserTransaction userTransaction) {
        super(securityService, userTransaction);
    }

    protected BaseContext.State getState() {
        Operation operation = ThreadContext.getThreadContext().getCurrentOperation();
        BaseContext.State state = states[operation.ordinal()];
        if (state == null) {
            throw new IllegalArgumentException("Invalid operation " + (Object)((Object)operation) + " for this context");
        }
        return state;
    }

    static {
        StatefulContext.states[Operation.INJECTION.ordinal()] = new BaseSessionContext.InjectionSessionState();
        StatefulContext.states[Operation.CREATE.ordinal()] = new LifecycleStatefulSessionState();
        StatefulContext.states[Operation.BUSINESS.ordinal()] = new BaseSessionContext.BusinessSessionState();
        StatefulContext.states[Operation.AFTER_BEGIN.ordinal()] = new BeforeCompletion();
        StatefulContext.states[Operation.BEFORE_COMPLETION.ordinal()] = new BeforeCompletion();
        StatefulContext.states[Operation.AFTER_COMPLETION.ordinal()] = new AfterCompletion();
        StatefulContext.states[Operation.TIMEOUT.ordinal()] = new BaseSessionContext.TimeoutSessionState();
        StatefulContext.states[Operation.PRE_DESTROY.ordinal()] = new LifecycleStatefulSessionState();
        StatefulContext.states[Operation.REMOVE.ordinal()] = new LifecycleStatefulSessionState();
        StatefulContext.states[Operation.POST_CONSTRUCT.ordinal()] = new LifecycleStatefulSessionState();
    }

    public static class AfterCompletion
    extends BaseSessionContext.SessionState {
        public MessageContext getMessageContext() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public Class getInvokedBusinessInterface() {
            throw new IllegalStateException();
        }

        public void setRollbackOnly() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public boolean getRollbackOnly() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public boolean isUserTransactionAccessAllowed() {
            return false;
        }

        public boolean isMessageContextAccessAllowed() {
            return false;
        }

        public boolean isJNDIAccessAllowed() {
            return false;
        }

        public boolean isEntityManagerFactoryAccessAllowed() {
            return false;
        }

        public boolean isEntityManagerAccessAllowed() {
            return false;
        }

        public boolean isTimerAccessAllowed() {
            return false;
        }

        public boolean isTimerMethodAllowed() {
            return false;
        }
    }

    public static class BeforeCompletion
    extends BaseSessionContext.SessionState {
        public Class getInvokedBusinessInterface() {
            throw new IllegalStateException();
        }

        public MessageContext getMessageContext() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public boolean isMessageContextAccessAllowed() {
            return false;
        }
    }

    public static class LifecycleStatefulSessionState
    extends BaseSessionContext.SessionState {
        public MessageContext getMessageContext() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public Class getInvokedBusinessInterface() {
            throw new IllegalStateException();
        }

        public void setRollbackOnly() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public boolean getRollbackOnly() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public boolean isMessageContextAccessAllowed() {
            return false;
        }

        public boolean isTimerAccessAllowed() {
            return false;
        }

        public boolean isTimerMethodAllowed() {
            return false;
        }
    }
}

