/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.timer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.sql.DataSource;
import org.apache.openejb.core.timer.EjbTimerServiceImpl;
import org.apache.openejb.core.timer.TimerData;
import org.apache.openejb.core.timer.TimerStore;
import org.apache.openejb.core.timer.TimerStoreException;
import org.apache.openejb.util.Base64;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseTimerStore
implements TimerStore {
    private static final Logger log = Logger.getInstance(LogCategory.TIMER, "org.apache.openejb.util.resources");
    private static final String createSequenceSQL = "create sequence timertasks_seq";
    private static final String createTableSQLWithSequence = "create table timertasks (id long primary key, serverid varchar(256) not null, timerkey varchar(256) not null, userid varchar(4096), userinfo varchar(4096), firsttime long not null, period long)";
    private static final String createTableSQLWithIdentity = "create table timertasks (id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), serverid varchar(256) not null, timerkey varchar(256) not null, userid varchar(4096), userinfo varchar(4096), firsttime NUMERIC(18,0) not null, period NUMERIC(18, 0))";
    private static final String sequenceSQL = "select timertasks_seq.nextval";
    private static final String identitySQL = "values IDENTITY_VAL_LOCAL()";
    private static final String insertSQLWithSequence = "insert into timertasks (id, serverid, timerkey, userid, userinfo, firsttime, period) values (?, ?, ?, ?, ?, ?, ?)";
    private static final String insertSQLWithIdentity = "insert into timertasks (serverid, timerkey, userid, userinfo, firsttime, period) values (?, ?, ?, ?, ?, ?)";
    private static final String deleteSQL = "delete from timertasks where id=?";
    private static final String selectSQL = "select id, userid, userinfo, firsttime, period from timertasks where serverid = ? and timerkey=?";
    private static final String fixedRateUpdateSQL = "update timertasks set firsttime = ? where id = ?";
    private final String serverUniqueId;
    private final DataSource dataSource;
    private boolean useSequence = false;

    protected DatabaseTimerStore(String serverUniqueId, DataSource datasource, boolean useSequence) throws SQLException {
        this.serverUniqueId = serverUniqueId;
        this.dataSource = datasource;
        this.useSequence = useSequence;
        if (this.useSequence) {
            this.execSQL(createSequenceSQL);
            this.execSQL(createTableSQLWithSequence);
        } else {
            this.execSQL(createTableSQLWithIdentity);
        }
    }

    @Override
    public TimerData getTimer(String deploymentId, long timerId) {
        return null;
    }

    @Override
    public Collection<TimerData> getTimers(String deploymentId) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimerData createTimer(EjbTimerServiceImpl timerService, String deploymentId, Object primaryKey, Object info, Date expiration, long intervalDuration) throws TimerStoreException {
        long id;
        boolean threwException = false;
        Connection c = this.getConnection();
        try {
            try {
                block19: {
                    if (this.useSequence) {
                        PreparedStatement seqStatement = c.prepareStatement(sequenceSQL);
                        try {
                            ResultSet seqRS = seqStatement.executeQuery();
                            try {
                                seqRS.next();
                                id = seqRS.getLong(1);
                                Object var15_14 = null;
                            }
                            catch (Throwable throwable) {
                                Object var15_15 = null;
                                seqRS.close();
                                throw throwable;
                            }
                            seqRS.close();
                            Object var17_20 = null;
                        }
                        catch (Throwable throwable) {
                            Object var17_21 = null;
                            seqStatement.close();
                            throw throwable;
                        }
                        seqStatement.close();
                        PreparedStatement insertStatement = c.prepareStatement(insertSQLWithSequence);
                        try {
                            String serializedPrimaryKey = this.serializeObject(primaryKey);
                            String serializedInfo = this.serializeObject(info);
                            insertStatement.setLong(1, id);
                            insertStatement.setString(2, this.serverUniqueId);
                            insertStatement.setString(3, deploymentId);
                            insertStatement.setString(4, serializedPrimaryKey);
                            insertStatement.setString(5, serializedInfo);
                            insertStatement.setLong(6, expiration.getTime());
                            insertStatement.setLong(7, intervalDuration);
                            int result = insertStatement.executeUpdate();
                            if (result != 1) {
                                throw new TimerStoreException("Could not insert!");
                            }
                            Object var19_24 = null;
                        }
                        catch (Throwable throwable) {
                            Object var19_25 = null;
                            insertStatement.close();
                            throw throwable;
                        }
                        insertStatement.close();
                        {
                            break block19;
                        }
                    }
                    PreparedStatement insertStatement = c.prepareStatement(insertSQLWithIdentity);
                    try {
                        String serializedPrimaryKey = this.serializeObject(primaryKey);
                        String serializedInfo = this.serializeObject(info);
                        insertStatement.setString(1, this.serverUniqueId);
                        insertStatement.setString(2, deploymentId);
                        insertStatement.setString(3, serializedPrimaryKey);
                        insertStatement.setString(4, serializedInfo);
                        insertStatement.setLong(5, expiration.getTime());
                        insertStatement.setLong(6, intervalDuration);
                        int result = insertStatement.executeUpdate();
                        if (result != 1) {
                            throw new TimerStoreException("Could not insert!");
                        }
                        Object var21_27 = null;
                    }
                    catch (Throwable throwable) {
                        Object var21_28 = null;
                        insertStatement.close();
                        throw throwable;
                    }
                    insertStatement.close();
                    PreparedStatement identityStatement = c.prepareStatement(identitySQL);
                    try {
                        ResultSet seqRS = identityStatement.executeQuery();
                        try {
                            seqRS.next();
                            id = seqRS.getLong(1);
                            Object var23_30 = null;
                        }
                        catch (Throwable throwable) {
                            Object var23_31 = null;
                            seqRS.close();
                            throw throwable;
                        }
                        seqRS.close();
                        Object var25_33 = null;
                    }
                    catch (Throwable throwable) {
                        Object var25_34 = null;
                        identityStatement.close();
                        throw throwable;
                    }
                    identityStatement.close();
                    {
                    }
                }
                Object var27_36 = null;
                this.close(c, !threwException);
            }
            catch (SQLException e) {
                threwException = true;
                throw new TimerStoreException(e);
            }
        }
        catch (Throwable throwable) {
            Object var27_37 = null;
            this.close(c, !threwException);
            throw throwable;
        }
        TimerData timerData = new TimerData(id, timerService, deploymentId, primaryKey, info, expiration, intervalDuration);
        return timerData;
    }

    @Override
    public void addTimerData(TimerData timerData) throws TimerStoreException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTimer(long timerId) {
        boolean threwException = false;
        Connection c = null;
        try {
            try {
                c = this.getConnection();
                PreparedStatement deleteStatement = c.prepareStatement(deleteSQL);
                try {
                    deleteStatement.setLong(1, timerId);
                    deleteStatement.execute();
                    Object var7_7 = null;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    deleteStatement.close();
                    throw throwable;
                }
                deleteStatement.close();
                Object var9_10 = null;
                this.close(c, !threwException);
            }
            catch (TimerStoreException e) {
                log.warning("Unable to remove get a database connection", e);
                Object var9_11 = null;
                this.close(c, !threwException);
            }
            catch (SQLException e) {
                threwException = true;
                log.warning("Unable to remove timer data from database", e);
                Object var9_12 = null;
                this.close(c, !threwException);
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            this.close(c, !threwException);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<TimerData> loadTimers(EjbTimerServiceImpl timerService, String deploymentId) throws TimerStoreException {
        ArrayList<TimerData> timerDatas = new ArrayList<TimerData>();
        boolean threwException = false;
        Connection c = this.getConnection();
        try {
            try {
                PreparedStatement selectStatement = c.prepareStatement(selectSQL);
                selectStatement.setString(1, this.serverUniqueId);
                selectStatement.setString(2, deploymentId);
                try {
                    ResultSet taskRS = selectStatement.executeQuery();
                    try {
                        while (taskRS.next()) {
                            long id = taskRS.getLong(1);
                            String serizalizedUserId = taskRS.getString(2);
                            Object userId = this.deserializeObject(serizalizedUserId);
                            String serializedUserInfo = taskRS.getString(3);
                            Object userInfo = this.deserializeObject(serializedUserInfo);
                            long timeMillis = taskRS.getLong(4);
                            Date time = new Date(timeMillis);
                            long period = taskRS.getLong(5);
                            TimerData timerData = new TimerData(id, timerService, deploymentId, userId, userInfo, time, period);
                            timerDatas.add(timerData);
                        }
                        Object var21_18 = null;
                    }
                    catch (Throwable throwable) {
                        Object var21_19 = null;
                        taskRS.close();
                        throw throwable;
                    }
                    taskRS.close();
                    Object var23_21 = null;
                }
                catch (Throwable throwable) {
                    Object var23_22 = null;
                    selectStatement.close();
                    throw throwable;
                }
                selectStatement.close();
                Object var25_24 = null;
                this.close(c, !threwException);
            }
            catch (SQLException e) {
                threwException = true;
                throw new TimerStoreException(e);
            }
        }
        catch (Throwable throwable) {
            Object var25_25 = null;
            this.close(c, !threwException);
            throw throwable;
        }
        return timerDatas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateIntervalTimer(TimerData timerData) {
        boolean threwException = false;
        Connection c = null;
        try {
            try {
                c = this.getConnection();
                PreparedStatement updateStatement = c.prepareStatement(fixedRateUpdateSQL);
                try {
                    updateStatement.setLong(1, timerData.getExpiration().getTime());
                    updateStatement.setLong(2, timerData.getId());
                    updateStatement.execute();
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    updateStatement.close();
                    throw throwable;
                }
                updateStatement.close();
                Object var8_10 = null;
                this.close(c, !threwException);
            }
            catch (TimerStoreException e) {
                log.warning("Unable to remove get a database connection", e);
                Object var8_11 = null;
                this.close(c, !threwException);
            }
            catch (SQLException e) {
                threwException = true;
                log.warning("Unable to remove timer data from database", e);
                Object var8_12 = null;
                this.close(c, !threwException);
            }
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            this.close(c, !threwException);
            throw throwable;
        }
    }

    private String serializeObject(Object object) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(baos);
            out.writeObject(object);
            out.close();
            byte[] encoded = Base64.encodeBase64(baos.toByteArray());
            return new String(encoded);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Object deserializeObject(String serializedValue) {
        try {
            byte[] bytes = Base64.decodeBase64(serializedValue.getBytes());
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream in = new ObjectInputStream(bais);
            return in.readObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void execSQL(String sql) throws SQLException {
        Connection connection = this.dataSource.getConnection();
        try {
            block6: {
                PreparedStatement updateStatement = connection.prepareStatement(sql);
                try {
                    try {
                        updateStatement.execute();
                    }
                    catch (SQLException e) {
                        Object var6_5 = null;
                        updateStatement.close();
                        break block6;
                    }
                    Object var6_4 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    updateStatement.close();
                    throw throwable;
                }
                updateStatement.close();
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            connection.close();
            throw throwable;
        }
        connection.close();
    }

    private Connection getConnection() throws TimerStoreException {
        try {
            return this.dataSource.getConnection();
        }
        catch (Exception e) {
            throw new TimerStoreException(e);
        }
    }

    private void close(Connection connection, boolean reportSqlException) {
        block3: {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    if (reportSqlException) break block3;
                    log.warning("Unable to close database connection", e);
                }
            }
        }
    }
}

