/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.timer;

import java.util.Date;
import java.util.TimerTask;
import javax.ejb.Timer;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.apache.openejb.core.timer.EjbTimerServiceImpl;
import org.apache.openejb.core.timer.TimerImpl;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class TimerData {
    private static final Logger log = Logger.getInstance(LogCategory.TIMER, "org.apache.openejb.util.resources");
    private final long id;
    private final EjbTimerServiceImpl timerService;
    private final String deploymentId;
    private final Object primaryKey;
    private final Object info;
    private final long intervalDuration;
    private Date expiration;
    private final Timer timer;
    private TimerTask timerTask;
    private boolean newTimer = false;
    private boolean cancelled = false;
    private boolean synchronizationRegistered = false;

    public TimerData(long id, EjbTimerServiceImpl timerService, String deploymentId, Object primaryKey, Object info, Date expiration, long intervalDuration) {
        this.id = id;
        this.timerService = timerService;
        this.deploymentId = deploymentId;
        this.primaryKey = primaryKey;
        this.info = info;
        this.expiration = expiration;
        this.intervalDuration = intervalDuration;
        this.timer = new TimerImpl(this);
    }

    public void stop() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
        this.cancelled = true;
    }

    public long getId() {
        return this.id;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public Object getPrimaryKey() {
        return this.primaryKey;
    }

    public Object getInfo() {
        return this.info;
    }

    public Date getExpiration() {
        return this.expiration;
    }

    public long getIntervalDuration() {
        return this.intervalDuration;
    }

    public TimerTask getTimerTask() {
        return this.timerTask;
    }

    public void setTimerTask(TimerTask timerTask) {
        this.timerTask = timerTask;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public boolean isOneTime() {
        return this.intervalDuration <= 0L;
    }

    void nextTime() {
        if (this.isOneTime()) {
            throw new IllegalStateException("This is a one-time timerTask");
        }
        this.expiration = new Date(this.expiration.getTime() + this.intervalDuration);
    }

    public boolean isNewTimer() {
        return this.newTimer;
    }

    public void newTimer() {
        this.newTimer = true;
        this.registerTimerDataSynchronization();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void cancel() {
        this.timerService.cancelled(this);
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
        this.cancelled = true;
        this.registerTimerDataSynchronization();
    }

    private void transactionComplete(boolean committed) {
        if (this.newTimer) {
            this.newTimer = false;
            if (!this.isCancelled() && committed) {
                this.timerService.schedule(this);
            }
        } else if (!committed) {
            this.cancelled = false;
            this.timerService.addTimerData(this);
            this.timerService.schedule(this);
        }
    }

    private void registerTimerDataSynchronization() {
        if (this.synchronizationRegistered) {
            return;
        }
        try {
            int status;
            Transaction transaction = this.timerService.getTransactionManager().getTransaction();
            int n = status = transaction == null ? 6 : transaction.getStatus();
            if (transaction != null && status == 0 || status == 1) {
                transaction.registerSynchronization((Synchronization)new TimerDataSynchronization());
                this.synchronizationRegistered = true;
                return;
            }
        }
        catch (Exception e) {
            log.warning("Unable to register timer data transaction synchronization", e);
        }
        this.transactionComplete(true);
    }

    private class TimerDataSynchronization
    implements Synchronization {
        private TimerDataSynchronization() {
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            TimerData.this.synchronizationRegistered = false;
            TimerData.this.transactionComplete(status == 3);
        }
    }
}

