/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.junit;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import org.apache.openejb.InjectionProcessor;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.ConnectorModule;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.PersistenceModule;
import org.apache.openejb.core.CoreDeploymentInfo;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.ivm.naming.InitContextFactory;
import org.apache.openejb.jee.Application;
import org.apache.openejb.jee.Connector;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.ManagedBean;
import org.apache.openejb.jee.TransactionType;
import org.apache.openejb.jee.jpa.unit.Persistence;
import org.apache.openejb.jee.jpa.unit.PersistenceUnit;
import org.apache.openejb.jee.oejb3.EjbDeployment;
import org.apache.openejb.jee.oejb3.OpenejbJar;
import org.apache.openejb.junit.Configuration;
import org.apache.openejb.junit.Module;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.Join;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.OptionsLog;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationComposer
extends BlockJUnit4ClassRunner {
    private final TestClass testClass;

    public ApplicationComposer(Class<?> klass) throws InitializationError {
        super(klass);
        this.testClass = new TestClass(klass);
        this.validate();
    }

    private void validate() throws InitializationError {
        String gripe;
        ArrayList<Exception> errors = new ArrayList<Exception>();
        List configs = this.testClass.getAnnotatedMethods(Configuration.class);
        if (configs.size() > 1) {
            String gripe2 = "Test class should have no more than one @Configuration method";
            errors.add(new Exception("Test class should have no more than one @Configuration method"));
        }
        for (FrameworkMethod method : configs) {
            Class<?> type = method.getMethod().getReturnType();
            if (Properties.class.isAssignableFrom(type)) continue;
            gripe = "@Configuration method must return " + Properties.class.getName();
            errors.add(new Exception(gripe));
        }
        int appModules = 0;
        int modules = 0;
        Object[] moduleTypes = new Class[]{EjbJar.class, EnterpriseBean.class, Persistence.class, PersistenceUnit.class, Connector.class};
        for (FrameworkMethod method : this.testClass.getAnnotatedMethods(Module.class)) {
            ++modules;
            Class<?> type = method.getMethod().getReturnType();
            if (Application.class.isAssignableFrom(type)) {
                ++appModules;
                continue;
            }
            if (this.isValidModuleType(type, (Class[])moduleTypes)) continue;
            String gripe3 = "@Module method must return " + Join.join(" or ", moduleTypes).replaceAll("(class|interface) ", "");
            errors.add(new Exception(gripe3));
        }
        if (appModules > 1) {
            gripe = "Test class should have no more than one @Module method that returns " + Application.class.getName();
            errors.add(new Exception(gripe));
        }
        if (modules < 1) {
            gripe = "Test class should have at least one @Module method";
            errors.add(new Exception("Test class should have at least one @Module method"));
        }
        if (!errors.isEmpty()) {
            throw new InitializationError(errors);
        }
    }

    private boolean isValidModuleType(Class<?> type, Class[] moduleTypes) {
        for (Class moduleType : moduleTypes) {
            if (!moduleType.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    protected Statement withAfters(FrameworkMethod method, Object target, Statement statement) {
        statement = super.withAfters(method, target, statement);
        statement = new DeployApplication(target, statement);
        return statement;
    }

    public class DeployApplication
    extends Statement {
        private final Object testInstance;
        private final Statement next;

        public DeployApplication(Object testInstance, Statement next) {
            this.testInstance = testInstance;
            this.next = next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() throws Throwable {
            FrameworkMethod method;
            Object o;
            Class javaClass = ApplicationComposer.this.testClass.getJavaClass();
            ClassLoader loader = javaClass.getClassLoader();
            AppModule appModule = new AppModule(loader, javaClass.getSimpleName());
            EjbJar ejbJar = new EjbJar();
            OpenejbJar openejbJar = new OpenejbJar();
            ManagedBean bean = (ManagedBean)ejbJar.addEnterpriseBean((EnterpriseBean)new ManagedBean(javaClass));
            bean.setTransactionType(TransactionType.BEAN);
            EjbDeployment ejbDeployment = openejbJar.addEjbDeployment((EnterpriseBean)bean);
            ejbDeployment.setDeploymentId(javaClass.getName());
            appModule.getEjbModules().add(new EjbModule(ejbJar, openejbJar));
            Object application = null;
            for (FrameworkMethod method2 : ApplicationComposer.this.testClass.getAnnotatedMethods(Module.class)) {
                Object obj = method2.invokeExplosively(this.testInstance, new Object[0]);
                if (obj instanceof EjbJar) {
                    EjbJar ejbJar2 = (EjbJar)obj;
                    appModule.getEjbModules().add(new EjbModule(ejbJar2));
                    continue;
                }
                if (obj instanceof EnterpriseBean) {
                    EnterpriseBean bean2 = (EnterpriseBean)obj;
                    EjbJar ejbJar3 = new EjbJar();
                    ejbJar3.addEnterpriseBean(bean2);
                    appModule.getEjbModules().add(new EjbModule(ejbJar3));
                    continue;
                }
                if (obj instanceof Connector) {
                    Connector connector = (Connector)obj;
                    appModule.getResourceModules().add(new ConnectorModule(connector));
                    continue;
                }
                if (obj instanceof Persistence) {
                    Persistence persistence = (Persistence)obj;
                    appModule.getPersistenceModules().add(new PersistenceModule("", persistence));
                    continue;
                }
                if (!(obj instanceof PersistenceUnit)) continue;
                PersistenceUnit unit = (PersistenceUnit)obj;
                appModule.getPersistenceModules().add(new PersistenceModule("", new Persistence(new PersistenceUnit[]{unit})));
            }
            Properties configuration = new Properties();
            configuration.put("openejb.deployments.classpath", "false");
            List methods = ApplicationComposer.this.testClass.getAnnotatedMethods(Configuration.class);
            Iterator i$ = methods.iterator();
            if (i$.hasNext() && (o = (method = (FrameworkMethod)i$.next()).invokeExplosively(this.testInstance, new Object[0])) instanceof Properties) {
                Properties properties = (Properties)o;
                configuration.putAll((Map<?, ?>)properties);
            }
            if (SystemInstance.isInitialized()) {
                SystemInstance.reset();
            }
            SystemInstance.init((Properties)configuration);
            SystemInstance.get().setProperty("openejb.embedded", "true");
            Logger.configure();
            OptionsLog.install();
            try {
                ConfigurationFactory config = new ConfigurationFactory();
                config.init(SystemInstance.get().getProperties());
                Assembler assembler = new Assembler();
                assembler.buildContainerSystem(config.getOpenEjbConfiguration());
                AppInfo appInfo = config.configureApplication(appModule);
                assembler.createApplication(appInfo);
                try {
                    ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
                    CoreDeploymentInfo context = (CoreDeploymentInfo)containerSystem.getDeploymentInfo(javaClass.getName());
                    Context jndi = (Context)context.getJndiEnc().lookup("comp/env");
                    InjectionProcessor<Object> processor = new InjectionProcessor<Object>(this.testInstance, context.getInjections(), jndi);
                    processor.createInstance();
                    System.setProperty("java.naming.factory.initial", InitContextFactory.class.getName());
                    ThreadContext previous = ThreadContext.enter(new ThreadContext(context, null, Operation.BUSINESS));
                    try {
                        this.next.evaluate();
                        Object var16_15 = null;
                    }
                    catch (Throwable throwable) {
                        Object var16_16 = null;
                        ThreadContext.exit(previous);
                        throw throwable;
                    }
                    ThreadContext.exit(previous);
                    Object var18_18 = null;
                }
                catch (Throwable throwable) {
                    Object var18_19 = null;
                    throw throwable;
                }
                Object var20_21 = null;
            }
            catch (Throwable throwable) {
                Object var20_22 = null;
                SystemInstance.reset();
                throw throwable;
            }
            SystemInstance.reset();
        }
    }
}

