/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.monitoring;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ObjectNameBuilder {
    private Map<String, String> map = new LinkedHashMap<String, String>();
    private String domain;

    public ObjectNameBuilder() {
        this("default");
    }

    public ObjectNameBuilder(String domain) {
        this.domain = domain;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public ObjectName build() {
        try {
            StringBuilder sb = new StringBuilder(this.domain + ":");
            for (Map.Entry<String, String> entry : this.map.entrySet()) {
                sb.append(entry.getKey()).append("=").append(entry.getValue()).append(",");
            }
            sb.deleteCharAt(sb.lastIndexOf(","));
            return new ObjectName(sb.toString());
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException(e);
        }
    }

    public ObjectNameBuilder set(String key, String value) {
        this.map.put(key, value);
        return this;
    }

    public ObjectNameBuilder copy() {
        ObjectNameBuilder builder = new ObjectNameBuilder();
        builder.domain = this.domain;
        builder.map.putAll(this.map);
        return builder;
    }
}

