/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.persistence;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.TransactionRequiredException;
import javax.transaction.Synchronization;
import javax.transaction.TransactionSynchronizationRegistry;
import org.apache.openejb.persistence.EntityManagerAlreadyRegisteredException;
import org.apache.openejb.persistence.EntityManagerTxKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JtaEntityManagerRegistry {
    private final TransactionSynchronizationRegistry transactionRegistry;
    private final ThreadLocal<ExtendedRegistry> extendedRegistry = new ThreadLocal<ExtendedRegistry>(){

        @Override
        protected ExtendedRegistry initialValue() {
            return new ExtendedRegistry();
        }
    };

    public JtaEntityManagerRegistry(TransactionSynchronizationRegistry transactionSynchronizationRegistry) {
        this.transactionRegistry = transactionSynchronizationRegistry;
    }

    public EntityManager getEntityManager(EntityManagerFactory entityManagerFactory, Map properties, boolean extended) throws IllegalStateException {
        EntityManager entityManager;
        if (entityManagerFactory == null) {
            throw new NullPointerException("entityManagerFactory is null");
        }
        EntityManagerTxKey txKey = new EntityManagerTxKey(entityManagerFactory);
        boolean transactionActive = this.isTransactionActive();
        if (transactionActive && (entityManager = (EntityManager)this.transactionRegistry.getResource((Object)txKey)) != null) {
            return entityManager;
        }
        if (extended) {
            entityManager = this.getInheritedEntityManager(entityManagerFactory);
            if (entityManager == null) {
                throw new IllegalStateException("InternalError: an entity manager should already be registered for this extended persistence unit");
            }
            if (transactionActive) {
                entityManager.joinTransaction();
                this.transactionRegistry.putResource((Object)txKey, (Object)entityManager);
            }
            return entityManager;
        }
        entityManager = properties != null ? entityManagerFactory.createEntityManager(properties) : entityManagerFactory.createEntityManager();
        if (transactionActive) {
            this.transactionRegistry.registerInterposedSynchronization((Synchronization)new CloseEntityManager(entityManager));
            this.transactionRegistry.putResource((Object)txKey, (Object)entityManager);
        }
        return entityManager;
    }

    public void addEntityManagers(String deploymentId, Object primaryKey, Map<EntityManagerFactory, EntityManager> entityManagers) throws EntityManagerAlreadyRegisteredException {
        this.extendedRegistry.get().addEntityManagers(new InstanceId(deploymentId, primaryKey), entityManagers);
    }

    public void removeEntityManagers(String deploymentId, Object primaryKey) {
        this.extendedRegistry.get().removeEntityManagers(new InstanceId(deploymentId, primaryKey));
    }

    public EntityManager getInheritedEntityManager(EntityManagerFactory entityManagerFactory) {
        return this.extendedRegistry.get().getInheritedEntityManager(entityManagerFactory);
    }

    public void transactionStarted(String deploymentId, Object primaryKey) {
        this.extendedRegistry.get().transactionStarted(new InstanceId(deploymentId, primaryKey));
    }

    public boolean isTransactionActive() {
        int txStatus = this.transactionRegistry.getTransactionStatus();
        boolean transactionActive = txStatus == 0 || txStatus == 1;
        return transactionActive;
    }

    private static class CloseEntityManager
    implements Synchronization {
        private final EntityManager entityManager;

        public CloseEntityManager(EntityManager entityManager) {
            this.entityManager = entityManager;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int i) {
            this.entityManager.close();
        }
    }

    private static class InstanceId {
        private final String deploymentId;
        private final Object primaryKey;

        public InstanceId(String deploymentId, Object primaryKey) {
            if (deploymentId == null) {
                throw new NullPointerException("deploymentId is null");
            }
            if (primaryKey == null) {
                throw new NullPointerException("primaryKey is null");
            }
            this.deploymentId = deploymentId;
            this.primaryKey = primaryKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InstanceId that = (InstanceId)o;
            return this.deploymentId.equals(that.deploymentId) && this.primaryKey.equals(that.primaryKey);
        }

        public int hashCode() {
            int result = this.deploymentId.hashCode();
            result = 29 * result + this.primaryKey.hashCode();
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExtendedRegistry {
        private final Map<InstanceId, Map<EntityManagerFactory, EntityManager>> entityManagersByDeploymentId = new HashMap<InstanceId, Map<EntityManagerFactory, EntityManager>>();

        private ExtendedRegistry() {
        }

        private void addEntityManagers(InstanceId instanceId, Map<EntityManagerFactory, EntityManager> entityManagers) throws EntityManagerAlreadyRegisteredException {
            if (instanceId == null) {
                throw new NullPointerException("instanceId is null");
            }
            if (entityManagers == null) {
                throw new NullPointerException("entityManagers is null");
            }
            if (JtaEntityManagerRegistry.this.isTransactionActive()) {
                for (Map.Entry<EntityManagerFactory, EntityManager> entry : entityManagers.entrySet()) {
                    EntityManagerFactory entityManagerFactory = entry.getKey();
                    EntityManager entityManager = entry.getValue();
                    EntityManagerTxKey txKey = new EntityManagerTxKey(entityManagerFactory);
                    EntityManager oldEntityManager = (EntityManager)JtaEntityManagerRegistry.this.transactionRegistry.getResource((Object)txKey);
                    if (entityManager == oldEntityManager) break;
                    if (oldEntityManager != null) {
                        throw new EntityManagerAlreadyRegisteredException("Another entity manager is already registered for this persistence unit");
                    }
                    entityManager.joinTransaction();
                    JtaEntityManagerRegistry.this.transactionRegistry.putResource((Object)txKey, (Object)entityManager);
                }
            }
            this.entityManagersByDeploymentId.put(instanceId, entityManagers);
        }

        private void removeEntityManagers(InstanceId instanceId) {
            if (instanceId == null) {
                throw new NullPointerException("InstanceId is null");
            }
            this.entityManagersByDeploymentId.remove(instanceId);
        }

        private EntityManager getInheritedEntityManager(EntityManagerFactory entityManagerFactory) {
            if (entityManagerFactory == null) {
                throw new NullPointerException("entityManagerFactory is null");
            }
            for (Map<EntityManagerFactory, EntityManager> entityManagers : this.entityManagersByDeploymentId.values()) {
                EntityManager entityManager = entityManagers.get(entityManagerFactory);
                if (entityManager == null) continue;
                return entityManager;
            }
            return null;
        }

        private void transactionStarted(InstanceId instanceId) {
            if (instanceId == null) {
                throw new NullPointerException("instanceId is null");
            }
            if (!JtaEntityManagerRegistry.this.isTransactionActive()) {
                throw new TransactionRequiredException();
            }
            Map<EntityManagerFactory, EntityManager> entityManagers = this.entityManagersByDeploymentId.get(instanceId);
            if (entityManagers == null) {
                return;
            }
            for (Map.Entry<EntityManagerFactory, EntityManager> entry : entityManagers.entrySet()) {
                EntityManagerFactory entityManagerFactory = entry.getKey();
                EntityManager entityManager = entry.getValue();
                entityManager.joinTransaction();
                EntityManagerTxKey txKey = new EntityManagerTxKey(entityManagerFactory);
                JtaEntityManagerRegistry.this.transactionRegistry.putResource((Object)txKey, (Object)entityManager);
            }
        }
    }
}

