/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.jdbc;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.openejb.resource.XAResourceWrapper;
import org.apache.openejb.resource.jdbc.BasicManagedDataSource;

public class ManagedDataSourceWithRecovery
extends BasicManagedDataSource {
    private TransactionManager suppliedTransactionManager;
    private final XAResourceWrapper xaResourceWrapper;

    public ManagedDataSourceWithRecovery(XAResourceWrapper xaResourceWrapper) {
        this.xaResourceWrapper = xaResourceWrapper;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.suppliedTransactionManager = transactionManager;
    }

    protected void wrapTransactionManager() {
        if (this.suppliedTransactionManager != null) {
            super.setTransactionManager((TransactionManager)new TransactionManagerWrapper(this.suppliedTransactionManager, this.getUrl(), this.xaResourceWrapper));
        }
    }

    private static class TransactionWrapper
    implements Transaction {
        private final Transaction transaction;
        private final String name;
        private final XAResourceWrapper xaResourceWrapper;

        private TransactionWrapper(Transaction transaction, String name, XAResourceWrapper xaResourceWrapper) {
            this.transaction = transaction;
            this.name = name;
            this.xaResourceWrapper = xaResourceWrapper;
        }

        public void commit() throws HeuristicMixedException, HeuristicRollbackException, RollbackException, SecurityException, SystemException {
            this.transaction.commit();
        }

        public boolean delistResource(XAResource xaResource, int i) throws IllegalStateException, SystemException {
            XAResource wrapper = this.xaResourceWrapper.wrap(xaResource, this.name);
            return this.transaction.delistResource(wrapper, i);
        }

        public boolean enlistResource(XAResource xaResource) throws IllegalStateException, RollbackException, SystemException {
            XAResource wrapper = this.xaResourceWrapper.wrap(xaResource, this.name);
            return this.transaction.enlistResource(wrapper);
        }

        public int getStatus() throws SystemException {
            return this.transaction.getStatus();
        }

        public void registerSynchronization(Synchronization synchronization) throws IllegalStateException, RollbackException, SystemException {
            this.transaction.registerSynchronization(synchronization);
        }

        public void rollback() throws IllegalStateException, SystemException {
            this.transaction.rollback();
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            this.transaction.setRollbackOnly();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TransactionWrapper that = (TransactionWrapper)o;
            return this.transaction.equals(that.transaction);
        }

        public int hashCode() {
            return this.transaction.hashCode();
        }
    }

    private static class TransactionManagerWrapper
    implements TransactionManager {
        private final TransactionManager transactionManager;
        private final String name;
        private final XAResourceWrapper xaResourceWrapper;

        private TransactionManagerWrapper(TransactionManager transactionManager, String name, XAResourceWrapper xaResourceWrapper) {
            this.transactionManager = transactionManager;
            this.name = name;
            this.xaResourceWrapper = xaResourceWrapper;
        }

        public void begin() throws NotSupportedException, SystemException {
            this.transactionManager.begin();
        }

        public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
            this.transactionManager.commit();
        }

        public int getStatus() throws SystemException {
            return this.transactionManager.getStatus();
        }

        public Transaction getTransaction() throws SystemException {
            Transaction tx = this.transactionManager.getTransaction();
            return tx == null ? null : new TransactionWrapper(this.transactionManager.getTransaction(), this.name, this.xaResourceWrapper);
        }

        public void resume(Transaction transaction) throws IllegalStateException, InvalidTransactionException, SystemException {
            this.transactionManager.resume(((TransactionWrapper)transaction).transaction);
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            this.transactionManager.rollback();
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            this.transactionManager.setRollbackOnly();
        }

        public void setTransactionTimeout(int i) throws SystemException {
            this.transactionManager.setTransactionTimeout(i);
        }

        public Transaction suspend() throws SystemException {
            return new TransactionWrapper(this.transactionManager.suspend(), this.name, this.xaResourceWrapper);
        }
    }
}

