/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import sun.misc.Unsafe;

public class PojoSerialization
implements Serializable {
    private static final byte CLASS = 50;
    private static final byte FIELD = 51;
    private static final byte DONE = 52;
    private Object object;
    private static final Unsafe unsafe = (Unsafe)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            try {
                Field field = Unsafe.class.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                return field.get(null);
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot get sun.misc.Unsafe", e);
            }
        }
    });

    public PojoSerialization() {
    }

    public PojoSerialization(Object object) {
        this.object = object;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.write(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.read(in);
    }

    protected Object readResolve() throws ObjectStreamException {
        return this.object;
    }

    protected void read(ObjectInput in) throws IOException, ClassNotFoundException {
        Object object;
        byte b = in.readByte();
        if (b != 50) {
            throw new IOException("Expected 'CLASS' byte 50, got: " + b);
        }
        Class clazz = (Class)in.readObject();
        try {
            object = unsafe.allocateInstance(clazz);
        }
        catch (Exception e) {
            throw (IOException)new IOException("Cannot construct " + clazz.getName()).initCause(e);
        }
        while (b != 52) {
            b = in.readByte();
            switch (b) {
                case 51: {
                    String fieldName = in.readUTF();
                    Object value = in.readObject();
                    Field field = null;
                    try {
                        field = clazz.getDeclaredField(fieldName);
                    }
                    catch (NoSuchFieldException e) {
                        throw (IOException)new IOException("Cannot find field " + field.getName()).initCause(e);
                    }
                    this.setValue(field, object, value);
                    break;
                }
                case 50: {
                    clazz = (Class)in.readObject();
                }
            }
        }
        this.object = object;
    }

    protected void write(ObjectOutput out) throws IOException {
        ArrayList classes = new ArrayList();
        for (Class<?> c = this.object.getClass(); c != null && !c.equals(Object.class); c = c.getSuperclass()) {
            classes.add(c);
        }
        for (Class clazz : classes) {
            Field[] fields;
            out.writeByte(50);
            out.writeObject(clazz);
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
                field.setAccessible(true);
                out.writeByte(51);
                out.writeUTF(field.getName());
                try {
                    out.writeObject(field.get(this.object));
                }
                catch (IllegalAccessException e) {
                    throw (IOException)new IOException("Cannot write field " + field.getName()).initCause(e);
                }
            }
        }
        out.writeByte(52);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setValue(Field field, Object object, Object value) {
        long offset;
        try {
            offset = unsafe.objectFieldOffset(field);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed getting offset for: field=" + field.getName() + "  class=" + field.getDeclaringClass().getName(), e);
        }
        Class<?> type = field.getType();
        if (type.isPrimitive()) {
            if (type.equals(Integer.TYPE)) {
                unsafe.putInt(object, offset, (Integer)value);
                return;
            } else if (type.equals(Long.TYPE)) {
                unsafe.putLong(object, offset, (Long)value);
                return;
            } else if (type.equals(Short.TYPE)) {
                unsafe.putShort(object, offset, (Short)value);
                return;
            } else if (type.equals(Character.TYPE)) {
                unsafe.putChar(object, offset, ((Character)value).charValue());
                return;
            } else if (type.equals(Byte.TYPE)) {
                unsafe.putByte(object, offset, (Byte)value);
                return;
            } else if (type.equals(Float.TYPE)) {
                unsafe.putFloat(object, offset, ((Float)value).floatValue());
                return;
            } else if (type.equals(Double.TYPE)) {
                unsafe.putDouble(object, offset, (Double)value);
                return;
            } else {
                if (!type.equals(Boolean.TYPE)) throw new IllegalStateException("Unknown primitive type: " + type.getName());
                unsafe.putBoolean(object, offset, (Boolean)value);
            }
            return;
        } else {
            unsafe.putObject(object, offset, value);
        }
    }
}

