/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.cmp;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.ejb.EJBAccessException;
import javax.ejb.EJBContext;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.ejb.Timer;
import javax.transaction.Synchronization;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.BeanContext;
import org.apache.openejb.ContainerType;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.ProxyInfo;
import org.apache.openejb.RpcContainer;
import org.apache.openejb.core.ExceptionType;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.cmp.CmpCallback;
import org.apache.openejb.core.cmp.CmpEngine;
import org.apache.openejb.core.cmp.CmpEngineFactory;
import org.apache.openejb.core.cmp.KeyGenerator;
import org.apache.openejb.core.cmp.ProxyFactory;
import org.apache.openejb.core.entity.EntrancyTracker;
import org.apache.openejb.core.timer.EjbTimerService;
import org.apache.openejb.core.timer.EjbTimerServiceImpl;
import org.apache.openejb.core.transaction.EjbTransactionUtil;
import org.apache.openejb.core.transaction.TransactionPolicy;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.Enumerator;

public class CmpContainer
implements RpcContainer {
    protected final Object containerID;
    protected final SecurityService securityService;
    protected final Map<Object, BeanContext> deploymentsById = new HashMap<Object, BeanContext>();
    protected final Map<Class, BeanContext> beansByClass = new HashMap<Class, BeanContext>();
    protected final CmpEngine cmpEngine;
    protected EntrancyTracker entrancyTracker;
    protected TransactionSynchronizationRegistry synchronizationRegistry;
    private static final Object ENTITIES_TO_STORE = new Object(){

        public String toString() {
            return "EntitiesToStore";
        }
    };

    public CmpContainer(Object id, TransactionManager transactionManager, SecurityService securityService, String cmpEngineFactory) throws OpenEJBException {
        CmpEngineFactory factory;
        this.containerID = id;
        this.securityService = securityService;
        this.synchronizationRegistry = (TransactionSynchronizationRegistry)SystemInstance.get().getComponent(TransactionSynchronizationRegistry.class);
        this.entrancyTracker = new EntrancyTracker(this.synchronizationRegistry);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        try {
            Class<?> cmpEngineFactoryClass = classLoader.loadClass(cmpEngineFactory);
            factory = (CmpEngineFactory)cmpEngineFactoryClass.newInstance();
        }
        catch (Exception e) {
            throw new OpenEJBException("Unable to create cmp engine factory " + cmpEngineFactory, e);
        }
        factory.setTransactionManager(transactionManager);
        factory.setTransactionSynchronizationRegistry(this.synchronizationRegistry);
        factory.setCmpCallback(new ContainerCmpCallback());
        this.cmpEngine = factory.create();
    }

    @Override
    public Object getContainerID() {
        return this.containerID;
    }

    @Override
    public ContainerType getContainerType() {
        return ContainerType.CMP_ENTITY;
    }

    @Override
    public synchronized BeanContext[] getBeanContexts() {
        return this.deploymentsById.values().toArray(new BeanContext[this.deploymentsById.size()]);
    }

    @Override
    public synchronized BeanContext getBeanContext(Object deploymentID) {
        return this.deploymentsById.get(deploymentID);
    }

    private BeanContext getBeanContextByClass(Class type) {
        BeanContext beanContext = null;
        while (type != null && beanContext == null) {
            beanContext = this.beansByClass.get(type);
            type = type.getSuperclass();
        }
        return beanContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deploy(BeanContext beanContext) throws OpenEJBException {
        CmpContainer cmpContainer = this;
        synchronized (cmpContainer) {
            Object deploymentId = beanContext.getDeploymentID();
            this.cmpEngine.deploy(beanContext);
            beanContext.setContainerData(this.cmpEngine);
            beanContext.set(EJBContext.class, new org.apache.openejb.core.entity.EntityContext(this.securityService));
            try {
                Field field = beanContext.getCmpImplClass().getField("deploymentInfo");
                field.set(null, beanContext);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.deploymentsById.put(deploymentId, beanContext);
            this.beansByClass.put(beanContext.getCmpImplClass(), beanContext);
            beanContext.setContainer(this);
        }
    }

    @Override
    public void start(BeanContext beanContext) throws OpenEJBException {
        EjbTimerService timerService = beanContext.getEjbTimerService();
        if (timerService != null) {
            timerService.start();
        }
    }

    @Override
    public void stop(BeanContext beanContext) throws OpenEJBException {
        beanContext.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undeploy(BeanContext beanContext) throws OpenEJBException {
        CmpContainer cmpContainer = this;
        synchronized (cmpContainer) {
            this.deploymentsById.remove(beanContext.getDeploymentID());
            this.beansByClass.remove(beanContext.getCmpImplClass());
            try {
                Field field = beanContext.getCmpImplClass().getField("deploymentInfo");
                field.set(null, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            beanContext.setContainer(null);
            beanContext.setContainerData(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getEjbInstance(BeanContext beanContext, Object primaryKey) {
        ThreadContext callContext = new ThreadContext(beanContext, primaryKey);
        ThreadContext oldCallContext = ThreadContext.enter(callContext);
        try {
            Object object = this.cmpEngine.loadBean(callContext, primaryKey);
            return object;
        }
        finally {
            ThreadContext.exit(oldCallContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object deployID, InterfaceType type, Class callInterface, Method callMethod, Object[] args, Object primKey) throws OpenEJBException {
        BeanContext beanContext = this.getBeanContext(deployID);
        if (beanContext == null) {
            throw new OpenEJBException("Deployment does not exist in this container. Deployment(id='" + deployID + "'), Container(id='" + this.containerID + "')");
        }
        if (type == null) {
            type = beanContext.getInterfaceType(callInterface);
        }
        ThreadContext callContext = new ThreadContext(beanContext, primKey);
        ThreadContext oldCallContext = ThreadContext.enter(callContext);
        try {
            boolean authorized = this.securityService.isCallerAuthorized(callMethod, type);
            if (!authorized) {
                throw new ApplicationException((Exception)new EJBAccessException("Unauthorized Access by Principal Denied"));
            }
            Class<?> declaringClass = callMethod.getDeclaringClass();
            String methodName = callMethod.getName();
            if (EJBHome.class.isAssignableFrom(declaringClass) || EJBLocalHome.class.isAssignableFrom(declaringClass)) {
                if (declaringClass != EJBHome.class && declaringClass != EJBLocalHome.class) {
                    if (methodName.startsWith("create")) {
                        ProxyInfo proxyInfo = this.createEJBObject(callMethod, args, callContext, type);
                        return proxyInfo;
                    }
                    if (methodName.equals("findByPrimaryKey")) {
                        Object object = this.findByPrimaryKey(callMethod, args, callContext, type);
                        return object;
                    }
                    if (methodName.startsWith("find")) {
                        Object object = this.findEJBObject(callMethod, args, callContext, type);
                        return object;
                    }
                    Object object = this.homeMethod(callMethod, args, callContext, type);
                    return object;
                }
                if (methodName.equals("remove")) {
                    this.removeEJBObject(callMethod, callContext, type);
                    Object var13_17 = null;
                    return var13_17;
                }
            } else if ((EJBObject.class == declaringClass || EJBLocalObject.class == declaringClass) && methodName.equals("remove")) {
                this.removeEJBObject(callMethod, callContext, type);
                Object var13_18 = null;
                return var13_18;
            }
            callContext.setCurrentOperation(Operation.BUSINESS);
            Method runMethod = beanContext.getMatchingBeanMethod(callMethod);
            callContext.set(Method.class, runMethod);
            Object object = this.businessMethod(callMethod, runMethod, args, callContext, type);
            return object;
        }
        finally {
            ThreadContext.exit(oldCallContext);
        }
    }

    private EntityBean createNewInstance(ThreadContext callContext) {
        BeanContext beanContext = callContext.getBeanContext();
        try {
            return (EntityBean)beanContext.getCmpImplClass().newInstance();
        }
        catch (Exception e) {
            throw new EJBException("Unable to create new entity bean instance " + beanContext.getCmpImplClass(), e);
        }
    }

    private ThreadContext createThreadContext(EntityBean entityBean) {
        if (entityBean == null) {
            throw new NullPointerException("entityBean is null");
        }
        BeanContext beanContext = this.getBeanContextByClass(entityBean.getClass());
        KeyGenerator keyGenerator = beanContext.getKeyGenerator();
        Object primaryKey = keyGenerator.getPrimaryKey(entityBean);
        return new ThreadContext(beanContext, primaryKey);
    }

    private void setEntityContext(EntityBean entityBean) {
        if (entityBean == null) {
            throw new NullPointerException("entityBean is null");
        }
        BeanContext beanContext = this.getBeanContextByClass(entityBean.getClass());
        ThreadContext callContext = new ThreadContext(beanContext, null);
        callContext.setCurrentOperation(Operation.SET_CONTEXT);
        ThreadContext oldCallContext = ThreadContext.enter(callContext);
        try {
            entityBean.setEntityContext((EntityContext)new org.apache.openejb.core.entity.EntityContext(this.securityService));
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            ThreadContext.exit(oldCallContext);
        }
    }

    private void unsetEntityContext(EntityBean entityBean) {
        if (entityBean == null) {
            throw new NullPointerException("entityBean is null");
        }
        ThreadContext callContext = this.createThreadContext(entityBean);
        callContext.setCurrentOperation(Operation.UNSET_CONTEXT);
        ThreadContext oldCallContext = ThreadContext.enter(callContext);
        try {
            entityBean.unsetEntityContext();
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            ThreadContext.exit(oldCallContext);
        }
    }

    private void ejbLoad(EntityBean entityBean) {
        if (entityBean == null) {
            throw new NullPointerException("entityBean is null");
        }
        ThreadContext callContext = this.createThreadContext(entityBean);
        callContext.setCurrentOperation(Operation.LOAD);
        ThreadContext oldCallContext = ThreadContext.enter(callContext);
        try {
            entityBean.ejbLoad();
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            ThreadContext.exit(oldCallContext);
        }
        try {
            LinkedHashSet<EntityBean> registeredEntities = (LinkedHashSet<EntityBean>)this.synchronizationRegistry.getResource(ENTITIES_TO_STORE);
            if (registeredEntities == null) {
                registeredEntities = new LinkedHashSet<EntityBean>();
                this.synchronizationRegistry.putResource(ENTITIES_TO_STORE, registeredEntities);
                this.synchronizationRegistry.registerInterposedSynchronization(new Synchronization(){

                    public void beforeCompletion() {
                        LinkedHashSet registeredEntities = (LinkedHashSet)CmpContainer.this.synchronizationRegistry.getResource(ENTITIES_TO_STORE);
                        if (registeredEntities == null) {
                            return;
                        }
                        for (EntityBean entityBean : registeredEntities) {
                            CmpContainer.this.ejbStore(entityBean);
                        }
                    }

                    public void afterCompletion(int i) {
                    }
                });
            }
            registeredEntities.add(entityBean);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void ejbStore(EntityBean entityBean) {
        if (entityBean == null) {
            throw new NullPointerException("entityBean is null");
        }
        ThreadContext callContext = this.createThreadContext(entityBean);
        callContext.setCurrentOperation(Operation.STORE);
        ThreadContext oldCallContext = ThreadContext.enter(callContext);
        try {
            entityBean.ejbStore();
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            ThreadContext.exit(oldCallContext);
        }
    }

    private void ejbRemove(EntityBean entityBean) throws RemoveException {
        if (entityBean == null) {
            throw new NullPointerException("entityBean is null");
        }
        if (this.isDeleted(entityBean)) {
            return;
        }
        ThreadContext callContext = this.createThreadContext(entityBean);
        callContext.setCurrentOperation(Operation.REMOVE);
        ThreadContext oldCallContext = ThreadContext.enter(callContext);
        try {
            entityBean.ejbRemove();
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            try {
                entityBean.getClass().getMethod("OpenEJB_deleted", new Class[0]).invoke((Object)entityBean, new Object[0]);
            }
            catch (Exception ignored) {}
            this.cancelTimers(callContext);
            ThreadContext.exit(oldCallContext);
        }
    }

    private boolean isDeleted(EntityBean entityBean) {
        try {
            return (Boolean)entityBean.getClass().getMethod("OpenEJB_isDeleted", new Class[0]).invoke((Object)entityBean, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    private void ejbActivate(EntityBean entityBean) {
        if (entityBean == null) {
            throw new NullPointerException("entityBean is null");
        }
        ThreadContext callContext = this.createThreadContext(entityBean);
        callContext.setCurrentOperation(Operation.ACTIVATE);
        ThreadContext oldCallContext = ThreadContext.enter(callContext);
        try {
            entityBean.ejbActivate();
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            ThreadContext.exit(oldCallContext);
        }
    }

    private void ejbPassivate(EntityBean entityBean) {
        if (entityBean == null) {
            throw new NullPointerException("entityBean is null");
        }
        ThreadContext callContext = this.createThreadContext(entityBean);
        callContext.setCurrentOperation(Operation.PASSIVATE);
        ThreadContext oldCallContext = ThreadContext.enter(callContext);
        try {
            entityBean.ejbPassivate();
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            ThreadContext.exit(oldCallContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object businessMethod(Method callMethod, Method runMethod, Object[] args, ThreadContext callContext, InterfaceType interfaceType) throws OpenEJBException {
        BeanContext beanContext = callContext.getBeanContext();
        TransactionPolicy txPolicy = EjbTransactionUtil.createTransactionPolicy(beanContext.getTransactionType(callMethod, interfaceType), callContext);
        Object returnValue = null;
        this.entrancyTracker.enter(beanContext, callContext.getPrimaryKey());
        try {
            EntityBean bean = (EntityBean)this.cmpEngine.loadBean(callContext, callContext.getPrimaryKey());
            if (bean == null) {
                throw new NoSuchObjectException(beanContext.getDeploymentID() + " : " + callContext.getPrimaryKey());
            }
            returnValue = runMethod.invoke((Object)bean, args);
            this.cmpEngine.storeBeanIfNoTx(callContext, bean);
        }
        catch (NoSuchObjectException e) {
            EjbTransactionUtil.handleApplicationException(txPolicy, e, false);
        }
        catch (Throwable e) {
            ExceptionType type;
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            if ((type = callContext.getBeanContext().getExceptionType(e)) == ExceptionType.SYSTEM) {
                EjbTransactionUtil.handleSystemException(txPolicy, e, callContext);
            } else {
                EjbTransactionUtil.handleApplicationException(txPolicy, e, type == ExceptionType.APPLICATION_ROLLBACK);
            }
        }
        finally {
            this.entrancyTracker.exit(beanContext, callContext.getPrimaryKey());
            EjbTransactionUtil.afterInvoke(txPolicy, callContext);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object homeMethod(Method callMethod, Object[] args, ThreadContext callContext, InterfaceType interfaceType) throws OpenEJBException {
        BeanContext beanContext = callContext.getBeanContext();
        TransactionPolicy txPolicy = EjbTransactionUtil.createTransactionPolicy(beanContext.getTransactionType(callMethod, interfaceType), callContext);
        Object returnValue = null;
        try {
            EntityBean bean = this.createNewInstance(callContext);
            this.setEntityContext(bean);
            try {
                callContext.setCurrentOperation(Operation.HOME);
                Method runMethod = beanContext.getMatchingBeanMethod(callMethod);
                try {
                    returnValue = runMethod.invoke((Object)bean, args);
                }
                catch (IllegalArgumentException e) {
                    System.out.println("********************************************************");
                    System.out.println("callMethod = " + callMethod);
                    System.out.println("runMethod = " + runMethod);
                    System.out.println("bean = " + bean.getClass().getName());
                    throw e;
                }
            }
            finally {
                this.unsetEntityContext(bean);
            }
        }
        catch (Throwable e) {
            ExceptionType type;
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            if ((type = callContext.getBeanContext().getExceptionType(e)) == ExceptionType.SYSTEM) {
                EjbTransactionUtil.handleSystemException(txPolicy, e, callContext);
            } else {
                EjbTransactionUtil.handleApplicationException(txPolicy, e, type == ExceptionType.APPLICATION_ROLLBACK);
            }
        }
        finally {
            EjbTransactionUtil.afterInvoke(txPolicy, callContext);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProxyInfo createEJBObject(Method callMethod, Object[] args, ThreadContext callContext, InterfaceType interfaceType) throws OpenEJBException {
        BeanContext beanContext = callContext.getBeanContext();
        TransactionPolicy txPolicy = EjbTransactionUtil.createTransactionPolicy(beanContext.getTransactionType(callMethod, interfaceType), callContext);
        Object primaryKey = null;
        try {
            EntityBean bean = this.createNewInstance(callContext);
            this.setEntityContext(bean);
            Method ejbCreateMethod = beanContext.getMatchingBeanMethod(callMethod);
            callContext.setCurrentOperation(Operation.CREATE);
            ejbCreateMethod.invoke((Object)bean, args);
            primaryKey = this.cmpEngine.createBean(bean, callContext);
            Method ejbPostCreateMethod = beanContext.getMatchingPostCreateMethod(ejbCreateMethod);
            ThreadContext postCreateContext = new ThreadContext(beanContext, primaryKey);
            postCreateContext.setCurrentOperation(Operation.POST_CREATE);
            ThreadContext oldContext = ThreadContext.enter(postCreateContext);
            try {
                ejbPostCreateMethod.invoke((Object)bean, args);
            }
            finally {
                ThreadContext.exit(oldContext);
            }
            this.cmpEngine.storeBeanIfNoTx(callContext, bean);
        }
        catch (Throwable e) {
            ExceptionType type;
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            if ((type = callContext.getBeanContext().getExceptionType(e)) == ExceptionType.SYSTEM) {
                EjbTransactionUtil.handleSystemException(txPolicy, e, callContext);
            } else {
                EjbTransactionUtil.handleApplicationException(txPolicy, e, type == ExceptionType.APPLICATION_ROLLBACK);
            }
        }
        finally {
            EjbTransactionUtil.afterInvoke(txPolicy, callContext);
        }
        return new ProxyInfo(beanContext, primaryKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object findByPrimaryKey(Method callMethod, Object[] args, ThreadContext callContext, InterfaceType interfaceType) throws OpenEJBException {
        BeanContext beanContext = callContext.getBeanContext();
        TransactionPolicy txPolicy = EjbTransactionUtil.createTransactionPolicy(beanContext.getTransactionType(callMethod, interfaceType), callContext);
        try {
            EntityBean bean = (EntityBean)this.cmpEngine.loadBean(callContext, args[0]);
            if (bean == null) {
                throw new ObjectNotFoundException(beanContext.getDeploymentID() + " : " + args[0]);
            }
            KeyGenerator kg = beanContext.getKeyGenerator();
            Object primaryKey = kg.getPrimaryKey(bean);
            ProxyInfo proxyInfo = new ProxyInfo(beanContext, primaryKey);
            return proxyInfo;
        }
        catch (FinderException fe) {
            EjbTransactionUtil.handleApplicationException(txPolicy, fe, false);
        }
        catch (Throwable e) {
            EjbTransactionUtil.handleSystemException(txPolicy, e, callContext);
        }
        finally {
            EjbTransactionUtil.afterInvoke(txPolicy, callContext);
        }
        throw new AssertionError((Object)"Should not get here");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object findEJBObject(Method callMethod, Object[] args, ThreadContext callContext, InterfaceType interfaceType) throws OpenEJBException {
        BeanContext beanContext = callContext.getBeanContext();
        TransactionPolicy txPolicy = EjbTransactionUtil.createTransactionPolicy(beanContext.getTransactionType(callMethod, interfaceType), callContext);
        try {
            List<Object> results = this.cmpEngine.queryBeans(callContext, callMethod, args);
            KeyGenerator kg = beanContext.getKeyGenerator();
            if (callMethod.getReturnType() == Collection.class || callMethod.getReturnType() == Enumeration.class) {
                Object i$;
                ArrayList<ProxyInfo> proxies = new ArrayList<ProxyInfo>();
                for (Object value : results) {
                    EntityBean bean = (EntityBean)value;
                    if (value == null) {
                        proxies.add(null);
                        continue;
                    }
                    Object primaryKey = kg.getPrimaryKey(bean);
                    proxies.add(new ProxyInfo(beanContext, primaryKey));
                }
                if (callMethod.getReturnType() == Enumeration.class) {
                    i$ = new Enumerator(proxies);
                    return i$;
                }
                i$ = proxies;
                return i$;
            }
            if (results.size() != 1) {
                throw new ObjectNotFoundException("A Enteprise bean with deployment_id = " + beanContext.getDeploymentID() + " and primarykey = " + args[0] + " Does not exist");
            }
            EntityBean bean = (EntityBean)results.get(0);
            if (bean == null) {
                Object i$ = null;
                return i$;
            }
            Object primaryKey = kg.getPrimaryKey(bean);
            ProxyInfo proxyInfo = new ProxyInfo(beanContext, primaryKey);
            return proxyInfo;
        }
        catch (FinderException fe) {
            EjbTransactionUtil.handleApplicationException(txPolicy, fe, false);
        }
        catch (Throwable e) {
            EjbTransactionUtil.handleSystemException(txPolicy, e, callContext);
        }
        finally {
            EjbTransactionUtil.afterInvoke(txPolicy, callContext);
        }
        throw new AssertionError((Object)"Should not get here");
    }

    /*
     * WARNING - void declaration
     */
    public Object select(BeanContext beanContext, String methodSignature, String returnType, Object ... args) throws FinderException {
        String signature = beanContext.getAbstractSchemaName() + "." + methodSignature;
        try {
            List<Object> results = this.cmpEngine.queryBeans(beanContext, signature, args);
            AbstractCollection proxies = returnType.equals("java.util.Set") ? new LinkedHashSet() : new ArrayList();
            boolean isSingleValued = !returnType.equals("java.util.Collection") && !returnType.equals("java.util.Set");
            ProxyFactory proxyFactory = null;
            for (Object e : results) {
                void var11_12;
                if (isSingleValued && !proxies.isEmpty()) {
                    throw new FinderException("The single valued query " + methodSignature + "returned more than one item");
                }
                if (e instanceof EntityBean) {
                    BeanContext result;
                    EntityBean entityBean = (EntityBean)e;
                    if (proxyFactory == null && (result = this.getBeanContextByClass(entityBean.getClass())) != null) {
                        proxyFactory = new ProxyFactory(result);
                    }
                    if (proxyFactory != null) {
                        if (beanContext.isRemoteQueryResults(methodSignature)) {
                            Object object = proxyFactory.createRemoteProxy(entityBean, this);
                        } else {
                            Object object = proxyFactory.createLocalProxy(entityBean, this);
                        }
                    }
                }
                proxies.add(var11_12);
            }
            if (!isSingleValued) {
                return proxies;
            }
            if (proxies.isEmpty()) {
                throw new ObjectNotFoundException();
            }
            return proxies.iterator().next();
        }
        catch (RuntimeException e) {
            throw new EJBException((Exception)e);
        }
    }

    public int update(BeanContext beanContext, String methodSignature, Object ... args) throws FinderException {
        String signature = beanContext.getAbstractSchemaName() + "." + methodSignature;
        return this.cmpEngine.executeUpdateQuery(beanContext, signature, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEJBObject(Method callMethod, ThreadContext callContext, InterfaceType interfaceType) throws OpenEJBException {
        BeanContext beanContext = callContext.getBeanContext();
        TransactionPolicy txPolicy = EjbTransactionUtil.createTransactionPolicy(beanContext.getTransactionType(callMethod, interfaceType), callContext);
        try {
            EntityBean entityBean = (EntityBean)this.cmpEngine.loadBean(callContext, callContext.getPrimaryKey());
            if (entityBean == null) {
                throw new NoSuchObjectException(callContext.getBeanContext().getDeploymentID() + " " + callContext.getPrimaryKey());
            }
            this.ejbRemove(entityBean);
            this.cmpEngine.removeBean(callContext);
        }
        catch (NoSuchObjectException e) {
            EjbTransactionUtil.handleApplicationException(txPolicy, e, false);
        }
        catch (Throwable e) {
            EjbTransactionUtil.handleSystemException(txPolicy, e, callContext);
        }
        finally {
            EjbTransactionUtil.afterInvoke(txPolicy, callContext);
        }
    }

    private void cancelTimers(ThreadContext threadContext) {
        EjbTimerService timerService;
        BeanContext beanContext = threadContext.getBeanContext();
        Object primaryKey = threadContext.getPrimaryKey();
        if (primaryKey != null && beanContext.getEjbTimerService() != null && (timerService = beanContext.getEjbTimerService()) != null && timerService instanceof EjbTimerServiceImpl) {
            for (Timer timer : beanContext.getEjbTimerService().getTimers(primaryKey)) {
                timer.cancel();
            }
        }
    }

    private class ContainerCmpCallback
    implements CmpCallback {
        private ContainerCmpCallback() {
        }

        @Override
        public void setEntityContext(EntityBean entity) {
            CmpContainer.this.setEntityContext(entity);
        }

        @Override
        public void unsetEntityContext(EntityBean entity) {
            CmpContainer.this.unsetEntityContext(entity);
        }

        @Override
        public void ejbActivate(EntityBean entity) {
            CmpContainer.this.ejbActivate(entity);
        }

        @Override
        public void ejbPassivate(EntityBean entity) {
            CmpContainer.this.ejbPassivate(entity);
        }

        @Override
        public void ejbLoad(EntityBean entity) {
            CmpContainer.this.ejbLoad(entity);
        }

        @Override
        public void ejbStore(EntityBean entity) {
            CmpContainer.this.ejbStore(entity);
        }

        @Override
        public void ejbRemove(EntityBean entity) throws RemoveException {
            CmpContainer.this.ejbRemove(entity);
        }
    }
}

