/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.timer;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.quartz.SchedulerConfigException;
import org.apache.openejb.quartz.spi.ThreadPool;
import org.apache.openejb.util.ExecutorBuilder;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class DefaultTimerThreadPoolAdapter
implements ThreadPool {
    private static final Logger logger = Logger.getInstance(LogCategory.TIMER, "org.apache.openejb.util.resources");
    public static final String OPENEJB_TIMER_POOL_SIZE = "openejb.timer.pool.size";
    public static final String OPENEJB_EJB_TIMER_POOL_AWAIT_SECONDS = "openejb.ejb-timer-pool.shutdown.timeout";
    private Executor executor;
    private String instanceId;
    private String instanceName;
    private int threadCount = 3;
    private int threadPriority = 5;
    private final Object threadAvailableLock = new Object();
    private final boolean threadPoolExecutorUsed;

    public DefaultTimerThreadPoolAdapter() {
        TimerExecutor timerExecutor = (TimerExecutor)SystemInstance.get().getComponent(TimerExecutor.class);
        if (timerExecutor != null) {
            this.executor = timerExecutor.executor;
        } else {
            this.executor = new ExecutorBuilder().size(3).prefix("EjbTimerPool").build(SystemInstance.get().getOptions());
            SystemInstance.get().setComponent(TimerExecutor.class, (Object)new TimerExecutor(this.executor));
        }
        this.threadPoolExecutorUsed = this.executor instanceof ThreadPoolExecutor;
        if (!this.threadPoolExecutorUsed) {
            logger.warning("Unrecognized ThreadPool implementation [" + this.executor.getClass().getName() + "] is used, EJB Timer service may not work correctly");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int blockForAvailableThreads() {
        if (this.threadPoolExecutorUsed) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)this.executor;
            Object object = this.threadAvailableLock;
            synchronized (object) {
                while (threadPoolExecutor.getMaximumPoolSize() - threadPoolExecutor.getActiveCount() < 1 && !threadPoolExecutor.isShutdown()) {
                    try {
                        this.threadAvailableLock.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return threadPoolExecutor.getMaximumPoolSize() - threadPoolExecutor.getActiveCount();
            }
        }
        return 1;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public int getPoolSize() {
        if (this.threadPoolExecutorUsed) {
            return ((ThreadPoolExecutor)this.executor).getPoolSize();
        }
        return 1;
    }

    public void initialize() throws SchedulerConfigException {
    }

    public boolean runInThread(Runnable runnable) {
        try {
            this.executor.execute(runnable);
            return true;
        }
        catch (RejectedExecutionException e) {
            logger.error("Failed to execute timer task", e);
            return false;
        }
    }

    public void shutdown(boolean arg0) {
        if (this.threadPoolExecutorUsed) {
            ThreadPoolExecutor tpe = (ThreadPoolExecutor)this.executor;
            tpe.shutdown();
            if (arg0) {
                int timeout = SystemInstance.get().getOptions().get(OPENEJB_EJB_TIMER_POOL_AWAIT_SECONDS, 5);
                try {
                    tpe.awaitTermination(timeout, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }

    public static final class TimerExecutor {
        private final Executor executor;

        private TimerExecutor(Executor executor) {
            if (executor == null) {
                throw new IllegalArgumentException("executor cannot be null");
            }
            this.executor = executor;
        }
    }
}

