/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.InvalidPropertiesFormatException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SuperProperties
extends Properties {
    private static final String PROP_DTD_NAME = "http://java.sun.com/dtd/properties.dtd";
    private static final String PROP_DTD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>    <!ELEMENT properties (comment?, entry*) >    <!ATTLIST properties version CDATA #FIXED \"1.0\" >    <!ELEMENT comment (#PCDATA) >    <!ELEMENT entry (#PCDATA) >    <!ATTLIST entry key CDATA #REQUIRED >";
    protected LinkedHashMap<Object, Object> properties = new LinkedHashMap();
    protected LinkedHashMap<String, String> comments = new LinkedHashMap();
    protected LinkedHashMap<String, LinkedHashMap<String, String>> attributes = new LinkedHashMap();
    protected Properties defaults;
    protected boolean caseInsensitive;
    protected String keyValueSeparator = "=";
    protected String lineSeparator = System.getProperty("line.separator");
    protected String indent = "";
    protected String commentIndent = " ";
    protected boolean spaceBetweenProperties = true;
    protected boolean spaceAfterComment = false;
    private DocumentBuilder builder = null;
    private static final int EOF = -1;
    private static final int LINE_ENDING = -4200;
    private static final int ENCODED_EQUALS = -5000;
    private static final int ENCODED_COLON = -5001;
    private static final int ENCODED_SPACE = -5002;
    private static final int ENCODED_TAB = -5003;
    private static final int ENCODED_NEWLINE = -5004;
    private static final int ENCODED_CARRIAGE_RETURN = -5005;

    public SuperProperties() {
    }

    public SuperProperties(Properties properties) {
        super(properties);
        this.defaults = properties;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public SuperProperties caseInsensitive(boolean caseInsensitive) {
        this.setCaseInsensitive(caseInsensitive);
        return this;
    }

    public String getKeyValueSeparator() {
        return this.keyValueSeparator;
    }

    public void setKeyValueSeparator(String keyValueSeparator) {
        if (keyValueSeparator == null) {
            throw new NullPointerException("keyValueSeparator is null");
        }
        if (keyValueSeparator.length() == 0) {
            throw new NullPointerException("keyValueSeparator is empty");
        }
        this.keyValueSeparator = keyValueSeparator;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        if (lineSeparator == null) {
            throw new NullPointerException("lineSeparator is null");
        }
        if (lineSeparator.length() == 0) {
            throw new NullPointerException("lineSeparator is empty");
        }
        this.lineSeparator = lineSeparator;
    }

    public int getIndent() {
        return this.indent.length();
    }

    public void setIndent(int indent) {
        char[] chars = new char[indent];
        Arrays.fill(chars, ' ');
        this.indent = new String(chars);
    }

    public int getCommentIndent() {
        return this.commentIndent.length();
    }

    public void setCommentIndent(int commentIndent) {
        char[] chars = new char[commentIndent];
        Arrays.fill(chars, ' ');
        this.commentIndent = new String(chars);
    }

    public boolean isSpaceBetweenProperties() {
        return this.spaceBetweenProperties;
    }

    public void setSpaceBetweenProperties(boolean spaceBetweenProperties) {
        this.spaceBetweenProperties = spaceBetweenProperties;
    }

    public boolean isSpaceAfterComment() {
        return this.spaceAfterComment;
    }

    public void setSpaceAfterComment(boolean spaceAfterComment) {
        this.spaceAfterComment = spaceAfterComment;
    }

    @Override
    public String getProperty(String name) {
        String property;
        Object result = this.get(name);
        String string = property = result instanceof String ? (String)result : null;
        if (property == null && this.defaults != null) {
            property = this.defaults.getProperty(name);
        }
        return property;
    }

    @Override
    public String getProperty(String name, String defaultValue) {
        String property;
        Object result = this.get(name);
        String string = property = result instanceof String ? (String)result : null;
        if (property == null && this.defaults != null) {
            property = this.defaults.getProperty(name);
        }
        if (property == null) {
            return defaultValue;
        }
        return property;
    }

    @Override
    public synchronized Object setProperty(String name, String value) {
        return this.put(name, value);
    }

    public String getComment(String name) {
        String comment = this.comments.get(name = this.normalize(name));
        if (comment == null && this.defaults instanceof SuperProperties) {
            comment = ((SuperProperties)this.defaults).getComment(name);
        }
        return comment;
    }

    public void setComment(String name, String comment) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (comment == null) {
            throw new NullPointerException("comment is null");
        }
        name = this.normalize(name);
        this.comments.put(name, comment);
    }

    public Map<String, String> getAttributes(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        Map<String, String> attributes = (Map<String, String>)this.attributes.get(name = this.normalize(name));
        if (attributes == null && this.defaults instanceof SuperProperties) {
            attributes = ((SuperProperties)this.defaults).getAttributes(name);
        }
        return attributes;
    }

    @Override
    public void list(PrintStream out) {
        if (out == null) {
            throw new NullPointerException();
        }
        StringBuilder buffer = new StringBuilder(80);
        Enumeration<?> keys = this.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            buffer.append(key);
            buffer.append('=');
            String property = (String)this.get(key);
            if (property == null) {
                property = this.defaults.getProperty(key);
            }
            if (property.length() > 40) {
                buffer.append(property.substring(0, 37));
                buffer.append("...");
            } else {
                buffer.append(property);
            }
            out.println(buffer.toString());
            buffer.setLength(0);
        }
    }

    @Override
    public void list(PrintWriter writer) {
        if (writer == null) {
            throw new NullPointerException();
        }
        StringBuilder buffer = new StringBuilder(80);
        Enumeration<?> keys = this.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            buffer.append(key);
            buffer.append('=');
            String property = (String)this.get(key);
            while (property == null) {
                property = this.defaults.getProperty(key);
            }
            if (property.length() > 40) {
                buffer.append(property.substring(0, 37));
                buffer.append("...");
            } else {
                buffer.append(property);
            }
            writer.println(buffer.toString());
            buffer.setLength(0);
        }
    }

    @Override
    public synchronized void load(InputStream in) throws IOException {
        int nextByte;
        StringBuilder key = new StringBuilder();
        StringBuilder value = null;
        StringBuilder comment = new StringBuilder();
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        int indent = 0;
        boolean globalIndentSet = false;
        int commentIndent = -1;
        boolean globalCommentIndentSet = false;
        boolean inSeparator = false;
        block14: while ((nextByte = this.decodeNextCharacter(in)) != -1) {
            char nextChar = (char)(nextByte & 0xFF);
            switch (nextByte) {
                case 9: 
                case 32: {
                    if (key.length() <= 0 || value != null) break;
                    inSeparator = true;
                    value = new StringBuilder();
                    continue block14;
                }
                case 58: 
                case 61: {
                    if (inSeparator) {
                        inSeparator = false;
                        continue block14;
                    }
                    if (value != null) break;
                    value = new StringBuilder();
                    continue block14;
                }
                case -4200: {
                    if (key.length() > 0) {
                        this.put(key.toString(), value == null ? "" : value.toString());
                        if (comment.length() > 0) {
                            this.setComment(key.toString(), comment.toString());
                            comment = new StringBuilder();
                        }
                        this.attributes.put(this.normalize(key.toString()), attributes);
                        attributes = new LinkedHashMap();
                        if (!globalIndentSet) {
                            this.setIndent(indent);
                            globalIndentSet = true;
                        }
                        indent = 0;
                    }
                    key = new StringBuilder();
                    value = null;
                    continue block14;
                }
                case 33: 
                case 35: {
                    if (key.length() != 0) break;
                    if (!globalIndentSet) {
                        this.setIndent(indent);
                        globalIndentSet = true;
                    }
                    indent = 0;
                    StringBuilder commentLine = new StringBuilder();
                    int commentLineIndent = 0;
                    boolean inIndent = true;
                    while ((nextByte = in.read()) >= 0) {
                        nextChar = (char)nextByte;
                        if (inIndent && nextChar == ' ') {
                            ++commentLineIndent;
                            commentLine.append(' ');
                            continue;
                        }
                        if (inIndent && nextChar == '\t') {
                            commentLineIndent += 4;
                            commentLine.append("    ");
                            continue;
                        }
                        if (nextChar == '\r' || nextChar == '\n') break;
                        inIndent = false;
                        commentLine.append(nextChar);
                    }
                    if (comment.length() == 0) {
                        commentIndent = commentLineIndent;
                        if (!globalCommentIndentSet) {
                            this.setCommentIndent(commentIndent);
                            globalCommentIndentSet = true;
                        }
                    }
                    commentLineIndent = Math.min(commentIndent, commentLineIndent);
                    if (commentLine.toString().trim().startsWith("@")) {
                        String attribute = commentLine.toString().trim().substring(1);
                        String[] parts = attribute.split("=", 2);
                        String attributeName = parts[0].trim();
                        String attributeValue = parts.length == 2 ? parts[1].trim() : "";
                        attributes.put(attributeName, attributeValue);
                        continue block14;
                    }
                    if (comment.length() != 0) {
                        comment.append(this.lineSeparator);
                    }
                    comment.append(commentLine.toString().substring(commentLineIndent));
                    continue block14;
                }
            }
            if (nextByte >= 0 && Character.isWhitespace(nextChar)) {
                if (key.length() == 0) {
                    indent = nextChar == '\t' ? (indent += 4) : ++indent;
                }
                if (key.length() == 0 || value == null || value.length() == 0) continue;
            }
            switch (nextByte) {
                case -5000: {
                    nextChar = '=';
                    break;
                }
                case -5001: {
                    nextChar = ':';
                    break;
                }
                case -5002: {
                    nextChar = ' ';
                    break;
                }
                case -5003: {
                    nextChar = '\t';
                    break;
                }
                case -5004: {
                    nextChar = '\n';
                    break;
                }
                case -5005: {
                    nextChar = '\r';
                }
            }
            inSeparator = false;
            if (value == null) {
                key.append(nextChar);
                continue;
            }
            value.append(nextChar);
        }
        if (key.length() > 0) {
            this.put(key.toString(), value == null ? "" : value.toString());
            if (comment.length() > 0) {
                this.setComment(key.toString(), comment.toString());
            }
            this.attributes.put(this.normalize(key.toString()), attributes);
            if (!globalIndentSet) {
                this.setIndent(indent);
            }
        }
    }

    private int decodeNextCharacter(InputStream in) throws IOException {
        char nextChar;
        boolean lineContinuation = false;
        boolean carriageReturnLineContinuation = false;
        boolean encoded = false;
        block13: while (true) {
            int nextByte;
            if ((nextByte = in.read()) < 0) {
                return -1;
            }
            nextChar = (char)(nextByte & 0xFF);
            if (carriageReturnLineContinuation) {
                carriageReturnLineContinuation = false;
                if (nextChar == '\n') continue;
            }
            if (nextChar == '\\') {
                nextByte = in.read();
                nextChar = nextByte < 0 ? (char)'\u0000' : (char)(nextByte & 0xFF);
                switch (nextChar) {
                    case '\r': {
                        carriageReturnLineContinuation = true;
                    }
                    case '\n': {
                        lineContinuation = true;
                        continue block13;
                    }
                    case 'u': {
                        nextChar = this.readUnicode(in);
                        break;
                    }
                    default: {
                        encoded = true;
                        nextChar = this.decodeEscapeChar(nextChar);
                        break;
                    }
                }
            } else if (nextChar == '\n' || nextChar == '\r') {
                return -4200;
            }
            if (!lineContinuation || nextChar != ' ' && nextChar != '\t') break;
        }
        if (encoded) {
            switch (nextChar) {
                case '=': {
                    return -5000;
                }
                case ':': {
                    return -5001;
                }
                case ' ': {
                    return -5002;
                }
                case '\t': {
                    return -5003;
                }
                case '\n': {
                    return -5004;
                }
                case '\r': {
                    return -5005;
                }
            }
        }
        return nextChar;
    }

    private char decodeEscapeChar(char nextChar) {
        switch (nextChar) {
            case 'b': {
                return '\b';
            }
            case 'f': {
                return '\f';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
            case 'u': {
                throw new IllegalArgumentException("decodeEscapeChar can not decode an unicode sequence");
            }
        }
        return nextChar;
    }

    private char readUnicode(InputStream in) throws IOException {
        char[] buf = new char[4];
        int unicode = 0;
        for (int i = 0; i < buf.length; ++i) {
            char nextChar;
            int nextByte = in.read();
            if (nextByte < 0) {
                throw new IllegalArgumentException("Invalid unicode sequence: expected format \\uxxxx, but got \\u" + new String(buf, 0, i));
            }
            buf[i] = nextChar = (char)(nextByte & 0xFF);
            int nextDigit = Character.digit(nextChar, 16);
            if (nextDigit < 0) {
                throw new IllegalArgumentException("Illegal character " + nextChar + " in unicode sequence \\u" + new String(buf, 0, i + 1));
            }
            unicode = (unicode << 4) + nextDigit;
        }
        return (char)unicode;
    }

    @Override
    public Enumeration<?> propertyNames() {
        if (this.defaults == null) {
            return this.keys();
        }
        Hashtable set = new Hashtable(this.defaults.size() + this.size());
        Enumeration<Object> keys = this.defaults.propertyNames();
        while (keys.hasMoreElements()) {
            set.put(keys.nextElement(), set);
        }
        keys = this.keys();
        while (keys.hasMoreElements()) {
            set.put(keys.nextElement(), set);
        }
        return set.keys();
    }

    @Override
    public void save(OutputStream out, String comment) {
        try {
            this.store(out, comment);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void store(OutputStream out, String headComment) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, "ISO8859_1");
        if (headComment != null) {
            writer.write(this.indent);
            writer.write("#");
            writer.write(this.commentIndent);
            writer.write(headComment);
            writer.write(this.lineSeparator);
        }
        boolean firstProperty = true;
        StringBuilder buffer = new StringBuilder(200);
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!firstProperty && this.spaceBetweenProperties) {
                buffer.append(this.lineSeparator);
            }
            String comment = this.comments.get(key);
            Map attributes = this.attributes.get(key);
            if (comment != null || !attributes.isEmpty()) {
                this.dumpComment(buffer, comment, attributes, "#");
                if (this.spaceAfterComment) {
                    buffer.append(this.lineSeparator);
                }
            }
            buffer.append(this.indent);
            this.dumpString(buffer, key, true);
            if (value != null && value.length() > 0) {
                buffer.append(this.keyValueSeparator);
                this.dumpString(buffer, value, false);
            }
            buffer.append(this.lineSeparator);
            writer.write(buffer.toString());
            buffer.setLength(0);
            firstProperty = false;
        }
        writer.flush();
    }

    private void dumpString(StringBuilder buffer, String string, boolean key) {
        int i = 0;
        if (!key && i < string.length() && string.charAt(i) == ' ') {
            buffer.append("\\ ");
            ++i;
        }
        while (i < string.length()) {
            char ch = string.charAt(i);
            switch (ch) {
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\f': {
                    buffer.append("\\f");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                default: {
                    if ("\\".indexOf(ch) >= 0 || key && "#!=: ".indexOf(ch) >= 0) {
                        buffer.append('\\');
                    }
                    if (ch >= ' ' && ch <= '~') {
                        buffer.append(ch);
                        break;
                    }
                    String hex = Integer.toHexString(ch);
                    buffer.append("\\u");
                    for (int j = 0; j < 4 - hex.length(); ++j) {
                        buffer.append("0");
                    }
                    buffer.append(hex);
                }
            }
            ++i;
        }
    }

    private void dumpComment(StringBuilder buffer, String comment, Map<String, String> attributes, String commentToken) {
        if (comment != null) {
            boolean startOfLine = true;
            char ch = '\u0000';
            block4: for (int i = 0; i < comment.length(); ++i) {
                ch = comment.charAt(i);
                if (startOfLine) {
                    buffer.append(this.indent);
                    buffer.append(commentToken);
                    buffer.append(this.commentIndent);
                    startOfLine = false;
                }
                switch (ch) {
                    case '\r': {
                        if (i + 1 >= comment.length() || comment.charAt(i + 1) == '\n') continue block4;
                        buffer.append(this.lineSeparator);
                        startOfLine = true;
                        continue block4;
                    }
                    case '\n': {
                        buffer.append(this.lineSeparator);
                        startOfLine = true;
                        continue block4;
                    }
                    default: {
                        buffer.append(ch);
                    }
                }
            }
            if (ch != '\r' && ch != '\n') {
                buffer.append(this.lineSeparator);
            }
        }
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            buffer.append(this.indent);
            buffer.append("#");
            buffer.append(this.commentIndent);
            buffer.append("@");
            buffer.append(entry.getKey());
            if (entry.getValue() != null && entry.getValue().length() > 0) {
                buffer.append("=");
                buffer.append(entry.getValue());
            }
            buffer.append(this.lineSeparator);
        }
    }

    @Override
    public synchronized void loadFromXML(InputStream in) throws IOException {
        if (in == null) {
            throw new NullPointerException();
        }
        DocumentBuilder builder = this.getDocumentBuilder();
        try {
            Document doc = builder.parse(in);
            NodeList entries = doc.getElementsByTagName("entry");
            if (entries == null) {
                return;
            }
            int entriesListLength = entries.getLength();
            block2: for (int i = 0; i < entriesListLength; ++i) {
                Element entry = (Element)entries.item(i);
                String key = entry.getAttribute("key");
                String value = entry.getTextContent();
                this.put(key, value);
                for (Node node = entry.getPreviousSibling(); node != null && !(node instanceof Element); node = node.getPreviousSibling()) {
                    int nextByte;
                    if (!(node instanceof Comment)) continue;
                    ByteArrayInputStream cin = new ByteArrayInputStream(((Comment)node).getData().getBytes());
                    StringBuilder comment = new StringBuilder();
                    LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
                    boolean firstLine = true;
                    int commentIndent = Integer.MAX_VALUE;
                    do {
                        StringBuilder commentLine = new StringBuilder();
                        int commentLineIndent = 0;
                        boolean inIndent = true;
                        while ((nextByte = ((InputStream)cin).read()) >= 0) {
                            char nextChar = (char)nextByte;
                            if (inIndent && nextChar == ' ') {
                                ++commentLineIndent;
                                commentLine.append(' ');
                                continue;
                            }
                            if (inIndent && nextChar == '\t') {
                                commentLineIndent += 4;
                                commentLine.append("    ");
                                continue;
                            }
                            if (nextChar == '\r' || nextChar == '\n') break;
                            inIndent = false;
                            commentLine.append(nextChar);
                        }
                        if (!firstLine && commentIndent == Integer.MAX_VALUE && commentLine.length() > 0) {
                            commentIndent = commentLineIndent;
                        }
                        commentLineIndent = Math.min(commentIndent, commentLineIndent);
                        if (commentLine.toString().trim().startsWith("@")) {
                            String attribute = commentLine.toString().trim().substring(1);
                            String[] parts = attribute.split("=", 2);
                            String attributeName = parts[0].trim();
                            String attributeValue = parts.length == 2 ? parts[1].trim() : "";
                            attributes.put(attributeName, attributeValue);
                        } else {
                            if (comment.length() != 0) {
                                comment.append(this.lineSeparator);
                            }
                            comment.append(commentLine.toString().substring(commentLineIndent));
                        }
                        firstLine = false;
                    } while (nextByte > 0);
                    if (comment.length() > 0) {
                        this.setComment(key, comment.toString());
                    }
                    this.attributes.put(this.normalize(key), attributes);
                    continue block2;
                }
            }
        }
        catch (SAXException e) {
            throw new InvalidPropertiesFormatException(e);
        }
    }

    private DocumentBuilder getDocumentBuilder() {
        if (this.builder == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            try {
                this.builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new Error(e);
            }
            this.builder.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException e) throws SAXException {
                    throw e;
                }

                @Override
                public void error(SAXParseException e) throws SAXException {
                    throw e;
                }

                @Override
                public void fatalError(SAXParseException e) throws SAXException {
                    throw e;
                }
            });
            this.builder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    if (systemId.equals(SuperProperties.PROP_DTD_NAME)) {
                        InputSource result = new InputSource(new StringReader(SuperProperties.PROP_DTD));
                        result.setSystemId(SuperProperties.PROP_DTD_NAME);
                        return result;
                    }
                    throw new SAXException("Invalid DOCTYPE declaration: " + systemId);
                }
            });
        }
        return this.builder;
    }

    @Override
    public void storeToXML(OutputStream os, String comment) throws IOException {
        this.storeToXML(os, comment, "UTF-8");
    }

    @Override
    public synchronized void storeToXML(OutputStream os, String headComment, String encoding) throws IOException {
        if (os == null || encoding == null) {
            throw new NullPointerException();
        }
        String encodingCanonicalName = "UTF-8";
        OutputStreamWriter osw = new OutputStreamWriter(os, "UTF-8");
        StringBuilder buf = new StringBuilder(200);
        buf.append("<?xml version=\"1.0\" encoding=\"").append("UTF-8").append("\"?>").append(this.lineSeparator);
        buf.append("<!DOCTYPE properties SYSTEM \"http://java.sun.com/dtd/properties.dtd\">").append(this.lineSeparator);
        buf.append("<properties>").append(this.lineSeparator);
        if (headComment != null) {
            buf.append(this.indent);
            buf.append("<comment>");
            buf.append(this.substitutePredefinedEntries(headComment));
            buf.append("</comment>");
            buf.append(this.lineSeparator);
            if (!this.isEmpty() && (this.spaceBetweenProperties || this.spaceAfterComment)) {
                buf.append(this.lineSeparator);
            }
        }
        boolean firstProperty = true;
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!firstProperty && this.spaceBetweenProperties) {
                buf.append(this.lineSeparator);
            }
            String comment = this.comments.get(key);
            Map attributes = this.attributes.get(key);
            if (comment != null || !attributes.isEmpty()) {
                buf.append(this.indent);
                buf.append("<!--");
                buf.append(this.lineSeparator);
                comment = comment.replaceAll("--*", "-");
                this.dumpComment(buf, comment, attributes, "");
                buf.append(this.indent);
                buf.append("-->");
                buf.append(this.lineSeparator);
                if (this.spaceAfterComment) {
                    buf.append(this.lineSeparator);
                }
            }
            buf.append(this.indent);
            buf.append("<entry key=\"");
            buf.append(this.substitutePredefinedEntries(key));
            buf.append("\">");
            buf.append(this.substitutePredefinedEntries(value));
            buf.append("</entry>");
            buf.append(this.lineSeparator);
            firstProperty = false;
        }
        buf.append("</properties>").append(this.lineSeparator);
        osw.write(buf.toString());
        osw.flush();
    }

    private String substitutePredefinedEntries(String s) {
        return s.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("'", "&apos;").replaceAll("\"", "&quot;");
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    @Override
    public Object get(Object key) {
        key = this.normalize(key);
        return this.properties.get(key);
    }

    @Override
    public Object put(Object key, Object value) {
        String name;
        if ((key = this.normalize(key)) instanceof String && !this.attributes.containsKey(name = (String)key)) {
            this.attributes.put(name, new LinkedHashMap());
        }
        return this.properties.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        key = this.normalize(key);
        this.comments.remove(key);
        this.attributes.remove(key);
        return this.properties.remove(key);
    }

    @Override
    public void putAll(Map<?, ?> t) {
        for (Map.Entry<?, ?> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
        if (t instanceof SuperProperties) {
            SuperProperties superProperties = (SuperProperties)t;
            for (Map.Entry<String, String> entry : superProperties.comments.entrySet()) {
                this.comments.put(this.normalize(entry.getKey()), entry.getValue());
            }
            for (Map.Entry<String, Object> entry : superProperties.attributes.entrySet()) {
                this.attributes.put(this.normalize(entry.getKey()), (LinkedHashMap<String, String>)entry.getValue());
            }
        }
    }

    @Override
    public Set<Object> keySet() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    @Override
    public Enumeration<Object> keys() {
        return Collections.enumeration(this.properties.keySet());
    }

    @Override
    public Collection<Object> values() {
        return Collections.unmodifiableCollection(this.properties.values());
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return Collections.unmodifiableSet(this.properties.entrySet());
    }

    @Override
    public Enumeration<Object> elements() {
        return Collections.enumeration(this.properties.values());
    }

    @Override
    public boolean containsKey(Object key) {
        key = this.normalize(key);
        return this.properties.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.properties.containsValue(value);
    }

    @Override
    public boolean contains(Object value) {
        return this.properties.containsValue(value);
    }

    @Override
    public void clear() {
        this.properties.clear();
        this.comments.clear();
        this.attributes.clear();
    }

    @Override
    public Object clone() {
        SuperProperties clone = (SuperProperties)super.clone();
        clone.properties = (LinkedHashMap)this.properties.clone();
        clone.comments = (LinkedHashMap)this.comments.clone();
        clone.attributes = (LinkedHashMap)this.attributes.clone();
        for (Map.Entry<String, LinkedHashMap<String, String>> entry : clone.attributes.entrySet()) {
            entry.setValue((LinkedHashMap)entry.getValue().clone());
        }
        return clone;
    }

    @Override
    public boolean equals(Object o) {
        return this.properties.equals(o);
    }

    @Override
    public int hashCode() {
        return this.properties.hashCode();
    }

    @Override
    public String toString() {
        return this.properties.toString();
    }

    @Override
    protected void rehash() {
    }

    private Object normalize(Object key) {
        if (key instanceof String) {
            return this.normalize((String)key);
        }
        return key;
    }

    private String normalize(String property) {
        String key;
        if (!this.caseInsensitive) {
            return property;
        }
        if (super.containsKey(property)) {
            return property;
        }
        for (Object o : this.keySet()) {
            if (!(o instanceof String) || !(key = (String)o).equalsIgnoreCase(property)) continue;
            return key;
        }
        if (this.defaults != null) {
            for (Object o : this.defaults.keySet()) {
                if (!(o instanceof String) || !(key = (String)o).equalsIgnoreCase(property)) continue;
                return key;
            }
        }
        return property;
    }
}

