/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.spi.DeploymentException;
import javax.transaction.Transactional;
import org.apache.openejb.AppContext;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.cdi.CdiAppContextsService;
import org.apache.openejb.cdi.CdiResourceInjectionService;
import org.apache.openejb.cdi.CdiScanner;
import org.apache.openejb.cdi.CustomELAdapter;
import org.apache.openejb.cdi.ManagedSecurityService;
import org.apache.openejb.cdi.OpenEJBBeanInfoService;
import org.apache.openejb.cdi.OpenEJBJndiService;
import org.apache.openejb.cdi.OpenEJBLifecycle;
import org.apache.openejb.cdi.OpenEJBTransactionService;
import org.apache.openejb.cdi.OpenEJBValidatorService;
import org.apache.openejb.cdi.OptimizedLoaderService;
import org.apache.openejb.cdi.StartupObject;
import org.apache.openejb.cdi.ThreadSingletonService;
import org.apache.openejb.cdi.WebBeansContextCreated;
import org.apache.openejb.cdi.WebappWebBeansContext;
import org.apache.openejb.cdi.transactional.TransactionContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.AppFinder;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.classloader.MultipleClassLoader;
import org.apache.webbeans.config.OpenWebBeansConfiguration;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.corespi.se.DefaultApplicationBoundaryService;
import org.apache.webbeans.intercept.ApplicationScopedBeanInterceptorHandler;
import org.apache.webbeans.intercept.NormalScopedBeanInterceptorHandler;
import org.apache.webbeans.spi.ApplicationBoundaryService;
import org.apache.webbeans.spi.BeanArchiveService;
import org.apache.webbeans.spi.ContainerLifecycle;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.spi.ConversationService;
import org.apache.webbeans.spi.JNDIService;
import org.apache.webbeans.spi.LoaderService;
import org.apache.webbeans.spi.ResourceInjectionService;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.spi.SecurityService;
import org.apache.webbeans.spi.TransactionService;
import org.apache.webbeans.spi.adaptor.ELAdaptor;
import org.apache.webbeans.web.intercept.RequestScopedBeanInterceptorHandler;

public class ThreadSingletonServiceImpl
implements ThreadSingletonService {
    public static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP, ThreadSingletonServiceImpl.class);
    private String sessionContextClass;
    private volatile boolean cachedApplicationScoped;
    private volatile boolean cachedRequestScoped;
    private static final ThreadLocal<WebBeansContext> contexts = new ThreadLocal();
    private static final Map<ClassLoader, WebBeansContext> contextByClassLoader = new ConcurrentHashMap<ClassLoader, WebBeansContext>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(StartupObject startupObject) {
        if (this.sessionContextClass == null) {
            ThreadSingletonServiceImpl threadSingletonServiceImpl = this;
            synchronized (threadSingletonServiceImpl) {
                if (this.sessionContextClass == null) {
                    this.sessionContextClass = SystemInstance.get().getProperty("openejb.session-context", "").trim();
                    this.cachedApplicationScoped = "true".equalsIgnoreCase(SystemInstance.get().getProperty("openejb.cdi.applicationScope.cached", "true").trim());
                    this.cachedRequestScoped = "true".equalsIgnoreCase(SystemInstance.get().getProperty("openejb.cdi.requestScope.cached", "true").trim());
                }
            }
        }
        AppContext appContext = startupObject.getAppContext();
        appContext.setCdiEnabled(this.hasBeans(startupObject.getAppInfo()));
        Properties properties = new Properties();
        HashMap services = new HashMap();
        properties.setProperty("org.apache.webbeans.application.jsp", "true");
        properties.setProperty("org.apache.webbeans.spi.deployer.useEjbMetaDataDiscoveryService", "true");
        properties.setProperty("org.apache.webbeans.forceNoCheckedExceptions", "false");
        properties.setProperty(SecurityService.class.getName(), ManagedSecurityService.class.getName());
        properties.setProperty("org.apache.webbeans.conversation.Conversation.periodicDelay", "1800000");
        properties.setProperty("org.apache.webbeans.application.supportsConversation", "true");
        properties.setProperty("org.apache.webbeans.ignoredDecoratorInterfaces", "org.apache.aries.proxy.weaving.WovenProxy");
        boolean tomee = SystemInstance.get().getProperty("openejb.loader", "foo").startsWith("tomcat");
        String defaultNormalScopeHandlerClass = NormalScopedBeanInterceptorHandler.class.getName();
        properties.setProperty("org.apache.webbeans.proxy.mapping.javax.enterprise.context.ApplicationScoped", this.cachedApplicationScoped ? ApplicationScopedBeanInterceptorHandler.class.getName() : defaultNormalScopeHandlerClass);
        if (tomee && this.cachedRequestScoped) {
            properties.setProperty("org.apache.webbeans.proxy.mapping.javax.enterprise.context.RequestScoped", RequestScopedBeanInterceptorHandler.class.getName());
        } else {
            properties.setProperty("org.apache.webbeans.proxy.mapping.javax.enterprise.context.RequestScoped", defaultNormalScopeHandlerClass);
        }
        if (this.sessionContextClass() != null && tomee) {
            properties.setProperty("org.apache.webbeans.proxy.mapping.javax.enterprise.context.SessionScoped", "org.apache.tomee.catalina.cdi.SessionNormalScopeBeanHandler");
        }
        properties.put("org.apache.webbeans.application.supportsProducerInterception", SystemInstance.get().getProperty("openejb.cdi.producer.interception", "true"));
        properties.putAll((Map<?, ?>)appContext.getProperties());
        properties.put(ContextsService.class.getName(), CdiAppContextsService.class.getName());
        properties.put(ResourceInjectionService.class.getName(), CdiResourceInjectionService.class.getName());
        properties.put(TransactionService.class.getName(), OpenEJBTransactionService.class.getName());
        services.put(BeanArchiveService.class, new OpenEJBBeanInfoService());
        services.put(AppContext.class, appContext);
        services.put(JNDIService.class, new OpenEJBJndiService());
        try {
            services.put(ELAdaptor.class, new CustomELAdapter(appContext));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        services.put(ScannerService.class, new CdiScanner());
        services.put(ApplicationBoundaryService.class, new DefaultApplicationBoundaryService());
        LoaderService loaderService = (LoaderService)SystemInstance.get().getComponent(LoaderService.class);
        if (loaderService == null && !properties.containsKey(LoaderService.class.getName())) {
            services.put(LoaderService.class, new OptimizedLoaderService());
        } else if (loaderService != null) {
            services.put(LoaderService.class, loaderService);
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader cl = oldClassLoader != ThreadSingletonServiceImpl.class.getClassLoader() && ThreadSingletonServiceImpl.class.getClassLoader() != oldClassLoader.getParent() ? new MultipleClassLoader(oldClassLoader, ThreadSingletonServiceImpl.class.getClassLoader()) : oldClassLoader;
        Thread.currentThread().setContextClassLoader(cl);
        Object old = null;
        try {
            WebBeansContext webBeansContext;
            if (startupObject.getWebContext() == null) {
                webBeansContext = new WebBeansContext(services, properties);
                appContext.set(WebBeansContext.class, webBeansContext);
            } else {
                webBeansContext = new WebappWebBeansContext(services, properties, appContext.getWebBeansContext());
                startupObject.getWebContext().setWebbeansContext(webBeansContext);
            }
            if (webBeansContext.getOpenWebBeansConfiguration().supportsConversation() && "org.apache.webbeans.jsf.DefaultConversationService".equals(webBeansContext.getOpenWebBeansConfiguration().getProperty(ConversationService.class.getName()))) {
                webBeansContext.registerService(ConversationService.class, ConversationService.class.cast(webBeansContext.getService(ContextsService.class)));
            }
            BeanManagerImpl beanManagerImpl = webBeansContext.getBeanManagerImpl();
            beanManagerImpl.addContext((Context)new TransactionContext());
            beanManagerImpl.addAdditionalInterceptorBindings(Transactional.class);
            SystemInstance.get().fireEvent((Object)new WebBeansContextCreated(webBeansContext));
            old = this.contextEntered(webBeansContext);
            this.setConfiguration(webBeansContext.getOpenWebBeansConfiguration());
            try {
                ((ContainerLifecycle)webBeansContext.getService(ContainerLifecycle.class)).startApplication((Object)startupObject);
            }
            catch (Exception e) {
                throw new DeploymentException("couldn't start owb context", (Throwable)e);
            }
            this.contextExited(old);
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        catch (Throwable throwable) {
            this.contextExited(old);
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            throw throwable;
        }
    }

    private boolean hasBeans(AppInfo appInfo) {
        for (EjbJarInfo ejbJar : appInfo.ejbJars) {
            if (ejbJar.beans == null) continue;
            return true;
        }
        return false;
    }

    private void setConfiguration(OpenWebBeansConfiguration configuration) {
        configuration.setProperty(SecurityService.class.getName(), (Object)ManagedSecurityService.class.getName());
        configuration.setProperty("org.apache.webbeans.forceNoCheckedExceptions", (Object)"false");
        configuration.setProperty("org.apache.webbeans.spi.ContainerLifecycle", (Object)OpenEJBLifecycle.class.getName());
        configuration.setProperty("org.apache.webbeans.spi.TransactionService", (Object)OpenEJBTransactionService.class.getName());
        configuration.setProperty("org.apache.webbeans.spi.ScannerService", (Object)CdiScanner.class.getName());
        configuration.setProperty("org.apache.webbeans.spi.ContextsService", (Object)CdiAppContextsService.class.getName());
        configuration.setProperty("org.apache.webbeans.spi.ValidatorService", (Object)OpenEJBValidatorService.class.getName());
        configuration.setProperty(ResourceInjectionService.class.getName(), (Object)CdiResourceInjectionService.class.getName());
    }

    @Override
    public Object contextEntered(WebBeansContext newOWBContext) {
        return ThreadSingletonServiceImpl.enter(newOWBContext);
    }

    public static WebBeansContext enter(WebBeansContext newOWBContext) {
        WebBeansContext oldContext = contexts.get();
        if (newOWBContext != null) {
            contexts.set(newOWBContext);
        } else {
            contexts.remove();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Enter:'" + newOWBContext + "'");
        }
        return oldContext;
    }

    @Override
    public void contextExited(Object oldContext) {
        ThreadSingletonServiceImpl.exit(oldContext);
    }

    public static void exit(Object oldContext) {
        if (oldContext != null && !(oldContext instanceof WebBeansContext)) {
            throw new IllegalArgumentException("ThreadSingletonServiceImpl can only be used with WebBeansContext, not " + oldContext.getClass().getName());
        }
        contexts.set((WebBeansContext)oldContext);
    }

    private WebBeansContext getContext(ClassLoader cl) {
        return ThreadSingletonServiceImpl.get(cl);
    }

    public static WebBeansContext get(ClassLoader cl) {
        WebBeansContext context = contextByClassLoader.get(cl);
        if (context != null) {
            return context;
        }
        context = AppFinder.findAppContextOrWeb(cl, AppFinder.WebBeansContextTransformer.INSTANCE);
        if (context == null) {
            context = contexts.get();
            if (context == null) {
                List<AppContext> appContexts = ((ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class)).getAppContexts();
                if (appContexts.size() > 0) {
                    return ThreadSingletonServiceImpl.getWebBeansContext(appContexts);
                }
                throw new IllegalStateException("On a thread without an initialized context nor a classloader mapping a deployed app");
            }
        } else {
            contextByClassLoader.put(cl, context);
        }
        return context;
    }

    private static WebBeansContext getWebBeansContext(List<AppContext> appContexts) {
        Collections.sort(appContexts, new Comparator<AppContext>(){

            @Override
            public int compare(AppContext appContext, AppContext appContext1) {
                return ThreadSingletonServiceImpl.cdiSize(appContext1) - ThreadSingletonServiceImpl.cdiSize(appContext);
            }
        });
        return appContexts.get(0).getWebBeansContext();
    }

    private static int cdiSize(AppContext ctx) {
        WebBeansContext wbc = ctx.getWebBeansContext();
        if (wbc == null) {
            return 0;
        }
        return wbc.getBeanManagerImpl().getBeans().size();
    }

    public WebBeansContext get(Object key) {
        return this.getContext((ClassLoader)key);
    }

    public void clear(Object key) {
        WebBeansContext ctx = this.getContext((ClassLoader)key);
        if (logger.isDebugEnabled()) {
            logger.debug("Clearing:'" + ctx + "'");
        }
        contextByClassLoader.remove(key);
        if (ctx != null) {
            ctx.clear();
        }
    }

    @Override
    public String sessionContextClass() {
        if (!this.sessionContextClass.isEmpty()) {
            if ("http".equals(this.sessionContextClass)) {
                return "org.apache.tomee.catalina.cdi.SessionContextBackedByHttpSession";
            }
            return this.sessionContextClass;
        }
        return null;
    }
}

