/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import java.lang.reflect.Field;
import java.util.Map;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.webbeans.context.SessionContext;
import org.apache.webbeans.web.context.SessionContextManager;

public class UpdatableSessionContextManager
extends SessionContextManager {
    private static final Field scField;
    private final Map<String, SessionContext> contextById;

    public UpdatableSessionContextManager() {
        try {
            this.contextById = (Map)scField.get((Object)this);
        }
        catch (IllegalAccessException e) {
            throw new OpenEJBRuntimeException("can't get session contexts", e);
        }
    }

    public Map<String, SessionContext> getContextById() {
        return this.contextById;
    }

    public void updateSessionIdMapping(String oldId, String newId) {
        if (oldId == null) {
            return;
        }
        SessionContext sc = this.getSessionContextWithSessionId(oldId);
        if (sc == null) {
            return;
        }
        this.addNewSessionContext(newId, sc);
        this.contextById.remove(oldId);
    }

    static {
        try {
            scField = SessionContextManager.class.getDeclaredField("sessionContexts");
            scField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new OpenEJBRuntimeException("sessionContexts attribute of SessionContextManager not found, you probably use a not compatible version of OWB");
        }
    }
}

