/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.log.SingleLineFormatter;
import org.fusesource.jansi.Ansi;

public class ColorFormatter
extends SingleLineFormatter {
    public static final String OPENEJB_LOG_COLOR_PREFIX = "openejb.log.color.";
    private final Map<Level, Ansi.Color> colors = new HashMap<Level, Ansi.Color>();

    public ColorFormatter() {
        this.colors.put(Level.FINEST, this.color("finest", Ansi.Color.DEFAULT.name()));
        this.colors.put(Level.FINER, this.color("finer", Ansi.Color.DEFAULT.name()));
        this.colors.put(Level.FINE, this.color("fine", Ansi.Color.DEFAULT.name()));
        this.colors.put(Level.INFO, this.color("info", Ansi.Color.WHITE.name()));
        this.colors.put(Level.WARNING, this.color("warning", Ansi.Color.YELLOW.name()));
        this.colors.put(Level.SEVERE, this.color("severe", Ansi.Color.RED.name()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String format(LogRecord record) {
        boolean exception = record.getThrown() != null;
        Ansi sbuf = this.prefix(record);
        sbuf.a(record.getLevel().getLocalizedName());
        sbuf.a(" - ");
        sbuf.a(this.formatMessage(record));
        if (!exception) {
            this.suffix(sbuf, record);
        }
        sbuf.newline();
        if (exception) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sbuf.a(sw.toString());
            }
            catch (Exception ex) {
            }
            finally {
                this.suffix(sbuf, record);
            }
        }
        return sbuf.toString();
    }

    private Ansi.Color color(String lvl, String aDefault) {
        try {
            return Ansi.Color.valueOf((String)SystemInstance.get().getProperty(OPENEJB_LOG_COLOR_PREFIX + lvl, aDefault));
        }
        catch (IllegalArgumentException iae) {
            return Ansi.Color.valueOf((String)aDefault);
        }
    }

    private Ansi color(Level key) {
        if (this.colors.containsKey(key)) {
            return Ansi.ansi().fg(this.colors.get(key));
        }
        return Ansi.ansi().fg(Ansi.Color.DEFAULT);
    }

    protected Ansi prefix(LogRecord record) {
        return this.color(record.getLevel());
    }

    protected Ansi suffix(Ansi ansi, LogRecord record) {
        return ansi.reset();
    }
}

