/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.table;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.openejb.table.Line;

public class Lines {
    private final List<Line> lines = new ArrayList<Line>();
    private final String cr;

    public Lines() {
        this(System.getProperty("line.separator"));
    }

    public Lines(String cr) {
        this.cr = cr;
    }

    public void add(Line line) {
        if (!this.lines.isEmpty() && this.lines.iterator().next().getColumns().length != line.getColumns().length) {
            throw new IllegalArgumentException("columns should have all the same size");
        }
        line.setCr(this.cr);
        this.lines.add(line);
    }

    public void print(PrintStream out) {
        this.print(out, true);
    }

    public void print(PrintStream out, boolean headers) {
        Iterator<Line> it = this.lines.iterator();
        if (!it.hasNext()) {
            return;
        }
        int[] max = Lines.max(this.lines);
        it.next().print(max, out, headers);
        while (it.hasNext()) {
            it.next().print(max, out);
        }
    }

    private static int[] max(List<Line> lines) {
        int[] max = new int[lines.iterator().next().getColumns().length];
        for (Line line : lines) {
            for (int i = 0; i < max.length; ++i) {
                int ll = line.getColumns()[i].length();
                if (max[i] == 0) {
                    max[i] = ll;
                    continue;
                }
                if (max[i] >= ll) continue;
                max[i] = ll;
            }
        }
        return max;
    }

    public List<Line> getLines() {
        return this.lines;
    }
}

