/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.DeploymentLoader;
import org.apache.openejb.config.NewLoaderLogic;
import org.apache.openejb.util.DaemonThreadFactory;
import org.apache.openejb.util.URLs;
import org.apache.xbean.finder.UrlSet;
import org.apache.xbean.finder.filter.Filters;

public class TldScanner {
    private static final Map<ClassLoader, Set<URL>> cache = new WeakHashMap<ClassLoader, Set<URL>>();
    private static final Map<Integer, Set<URL>> cacheByhashCode = new WeakHashMap<Integer, Set<URL>>();

    public static Set<URL> scan(ClassLoader classLoader) throws OpenEJBException {
        if (classLoader == null) {
            return Collections.emptySet();
        }
        Set<URL> urls = cache.get(classLoader);
        if (urls != null) {
            return urls;
        }
        Set<URL> result = TldScanner.scanClassLoaderForTagLibs(classLoader);
        cache.put(classLoader, result);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static Set<URL> scanClassLoaderForTagLibs(ClassLoader classLoader) throws OpenEJBException {
        HashSet<URL> tldUrls = new HashSet<URL>();
        if (classLoader == null) {
            return tldUrls;
        }
        if (classLoader == Object.class.getClassLoader()) {
            return tldUrls;
        }
        List<URL> urls = TldScanner.urls(classLoader);
        int hashCodeForUrls = TldScanner.hash(urls);
        Set<URL> cachedSet = cacheByhashCode.get(hashCodeForUrls);
        if (cachedSet != null) {
            return cachedSet;
        }
        tldUrls.addAll(TldScanner.scan(classLoader.getParent()));
        if (urls.size() > 0) {
            ExecutorService es = Executors.newFixedThreadPool(2 * Runtime.getRuntime().availableProcessors() + 1, new DaemonThreadFactory("OpenEJB-tld-server-scanning"));
            ArrayList<Future<Set<URL>>> futures = new ArrayList<Future<Set<URL>>>(urls.size());
            for (URL uRL : urls) {
                File file;
                void var8_8;
                if (uRL.getProtocol().equals("jar")) {
                    try {
                        String path = uRL.getPath();
                        if (path.endsWith("!/")) {
                            path = path.substring(0, path.length() - 2);
                        }
                        URL uRL2 = new URL(path);
                    }
                    catch (MalformedURLException e) {
                        DeploymentLoader.logger.warning("JSP tag library location bad: " + uRL.toExternalForm(), e);
                        continue;
                    }
                }
                if (!var8_8.getProtocol().equals("file")) continue;
                try {
                    file = URLs.toFile((URL)var8_8).getCanonicalFile().getAbsoluteFile();
                }
                catch (IOException e) {
                    DeploymentLoader.logger.warning("JSP tag library location bad: " + var8_8.toExternalForm(), e);
                    continue;
                }
                futures.add(es.submit(new Callable<Set<URL>>(){

                    @Override
                    public Set<URL> call() throws Exception {
                        return TldScanner.scanForTagLibs(file);
                    }
                }));
            }
            es.shutdown();
            for (Future future : futures) {
                try {
                    tldUrls.addAll((Collection)future.get());
                }
                catch (Exception e) {}
            }
        }
        cacheByhashCode.put(hashCodeForUrls, tldUrls);
        return tldUrls;
    }

    static Set<URL> scanWarForTagLibs(File war) {
        File webInfMetaInf;
        HashSet<URL> urls = new HashSet<URL>();
        File webInfDir = new File(war, "WEB-INF");
        if (!webInfDir.isDirectory()) {
            return urls;
        }
        LinkedList<File> files = new LinkedList<File>();
        File[] list = webInfDir.listFiles();
        if (list != null) {
            for (File file : list) {
                if ("lib".equals(file.getName()) || "classes".equals(file.getName())) continue;
                files.add(file);
            }
        }
        if ((webInfMetaInf = new File(webInfDir, "classes/META-INF")).exists()) {
            files.addAll(Arrays.asList(webInfMetaInf.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".tld");
                }
            })));
        }
        if (files.isEmpty()) {
            return urls;
        }
        while (!files.isEmpty()) {
            File file = (File)files.removeFirst();
            if (file.isDirectory()) {
                File[] a = file.listFiles();
                if (a == null) continue;
                files.addAll(Arrays.asList(a));
                continue;
            }
            if (!file.getName().endsWith(".tld")) continue;
            try {
                file = file.getCanonicalFile().getAbsoluteFile();
                urls.add(file.toURI().toURL());
            }
            catch (IOException e) {
                DeploymentLoader.logger.warning("JSP tag library location bad: " + file.getAbsolutePath(), e);
            }
        }
        return urls;
    }

    static Set<URL> scanForTagLibs(File file) {
        HashSet<URL> tldLocations = new HashSet<URL>();
        try {
            String location = file.toURI().toURL().toExternalForm();
            if (location.endsWith(".jar")) {
                Set<URL> urls = TldScanner.scanJarForTagLibs(file);
                tldLocations.addAll(urls);
            } else if (file.getName().endsWith(".tld")) {
                URL url = file.toURI().toURL();
                tldLocations.add(url);
            }
        }
        catch (IOException e) {
            DeploymentLoader.logger.warning("Error scanning for JSP tag libraries: " + file.getAbsolutePath(), e);
        }
        return tldLocations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<URL> scanJarForTagLibs(File file) {
        HashSet<URL> urls = new HashSet<URL>();
        if (!file.isFile()) {
            return urls;
        }
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
            URL jarFileUrl = new URL("jar", "", -1, file.toURI().toURL().toExternalForm() + "!/");
            for (JarEntry entry : Collections.list(jarFile.entries())) {
                String name = entry.getName();
                if (!name.startsWith("META-INF/") || !name.endsWith(".tld")) continue;
                URL url = new URL(jarFileUrl, name);
                urls.add(url);
            }
        }
        catch (IOException e) {
            DeploymentLoader.logger.warning("Error scanning jar for JSP tag libraries: " + file.getAbsolutePath(), e);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return urls;
    }

    public static void quickClean(ClassLoader loader) {
        if (loader == null) {
            return;
        }
        cache.remove(loader);
        if (loader.getParent() != TldScanner.class.getClassLoader()) {
            TldScanner.quickClean(loader.getParent());
        }
    }

    public static void forceCompleteClean(ClassLoader loader) {
        if (loader == null) {
            return;
        }
        TldScanner.quickClean(loader);
        cacheByhashCode.remove(TldScanner.hash(TldScanner.urls(loader)));
        if (loader.getParent() != TldScanner.class.getClassLoader()) {
            TldScanner.forceCompleteClean(loader.getParent());
        }
    }

    private static List<URL> urls(ClassLoader classLoader) {
        UrlSet urlSet = new UrlSet(new URL[0]);
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            try {
                urlSet = new UrlSet(urlClassLoader.getURLs());
            }
            catch (NullPointerException npe) {
                return Collections.emptyList();
            }
        }
        try {
            urlSet = new UrlSet(classLoader);
        }
        catch (IOException e) {
            DeploymentLoader.logger.warning("Error scanning class loader for JSP tag libraries", e);
        }
        try {
            urlSet = URLs.cullSystemJars(urlSet);
            urlSet = NewLoaderLogic.applyBuiltinExcludes(urlSet, Filters.tokens((String[])new String[]{"openejb-jstl-1.2", "myfaces-impl", "javax.faces-2.", "spring-security-taglibs", "spring-webmvc"}));
        }
        catch (IOException e) {
            DeploymentLoader.logger.warning("Error scanning class loader for JSP tag libraries", e);
        }
        return urlSet.getUrls();
    }

    private static int hash(List<URL> urls) {
        int hash = 0;
        for (URL u : urls) {
            hash *= 31;
            if (u == null) continue;
            hash += u.toExternalForm().hashCode();
        }
        return hash;
    }
}

