/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionAttributeListener;
import org.apache.openejb.AppContext;
import org.apache.openejb.Injection;
import org.apache.openejb.InjectionProcessor;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.cdi.ConstructorInjectionBean;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.creational.CreationalContextImpl;

public class WebContext {
    private String id;
    private ClassLoader classLoader;
    private final Collection<Injection> injections = new ArrayList<Injection>();
    private Context jndiEnc;
    private final AppContext appContext;
    private Map<String, Object> bindings;
    private final Map<Object, CreationalContext<?>> creatonalContexts = new ConcurrentHashMap();
    private WebBeansContext webbeansContext;
    private String contextRoot;
    private String host;
    private Context initialContext;
    private ServletContext servletContext;
    private final Map<Class<?>, ConstructorInjectionBean<Object>> constructorInjectionBeanCache = new ConcurrentHashMap();

    public Context getInitialContext() {
        if (this.initialContext != null) {
            return this.initialContext;
        }
        try {
            this.initialContext = (Context)new InitialContext().lookup("java:");
        }
        catch (NamingException e) {
            throw new IllegalStateException(e);
        }
        return this.initialContext;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setInitialContext(Context initialContext) {
        this.initialContext = initialContext;
    }

    public WebContext(AppContext appContext) {
        this.appContext = appContext;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Collection<Injection> getInjections() {
        return this.injections;
    }

    public Context getJndiEnc() {
        return this.jndiEnc;
    }

    public void setJndiEnc(Context jndiEnc) {
        this.jndiEnc = jndiEnc;
    }

    public AppContext getAppContext() {
        return this.appContext;
    }

    public Object newInstance(Class beanClass) throws OpenEJBException {
        Object o;
        CreationalContextImpl creationalContext;
        WebBeansContext webBeansContext = this.getWebBeansContext();
        ConstructorInjectionBean<Object> beanDefinition = this.getConstructorInjectionBean(beanClass, webBeansContext);
        if (webBeansContext == null) {
            creationalContext = null;
            try {
                o = beanClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new OpenEJBException(e);
            }
        } else {
            creationalContext = webBeansContext.getBeanManagerImpl().createCreationalContext(beanDefinition);
            o = beanDefinition.create((CreationalContext)creationalContext);
        }
        Context unwrap = InjectionProcessor.unwrap(this.getInitialContext());
        InjectionProcessor injectionProcessor = new InjectionProcessor(o, this.injections, unwrap);
        Object beanInstance = injectionProcessor.createInstance();
        if (webBeansContext != null) {
            InjectionTargetBean bean = (InjectionTargetBean)InjectionTargetBean.class.cast(beanDefinition);
            bean.getInjectionTarget().inject(beanInstance, (CreationalContext)creationalContext);
            this.creatonalContexts.put(beanInstance, (CreationalContext<?>)creationalContext);
        }
        return beanInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConstructorInjectionBean<Object> getConstructorInjectionBean(Class beanClass, WebBeansContext webBeansContext) {
        if (webBeansContext == null) {
            return null;
        }
        ConstructorInjectionBean<Object> beanDefinition = this.constructorInjectionBeanCache.get(beanClass);
        if (beanDefinition == null) {
            WebContext webContext = this;
            synchronized (webContext) {
                beanDefinition = this.constructorInjectionBeanCache.get(beanClass);
                if (beanDefinition == null) {
                    AnnotatedType annotatedType = webBeansContext.getAnnotatedElementFactory().newAnnotatedType(beanClass);
                    beanDefinition = WebContext.isWeb(beanClass) ? new ConstructorInjectionBean(webBeansContext, beanClass, annotatedType, false) : new ConstructorInjectionBean(webBeansContext, beanClass, annotatedType);
                    this.constructorInjectionBeanCache.put(beanClass, beanDefinition);
                }
            }
        }
        return beanDefinition;
    }

    private static boolean isWeb(Class<?> beanClass) {
        return Servlet.class.isAssignableFrom(beanClass) || Filter.class.isAssignableFrom(beanClass) || HttpSessionAttributeListener.class.isAssignableFrom(beanClass) || ServletContextListener.class.isAssignableFrom(beanClass) || HttpSessionAttributeListener.class.isAssignableFrom(beanClass) || ServletRequestListener.class.isAssignableFrom(beanClass) || ServletContextAttributeListener.class.isAssignableFrom(beanClass) || ServletRequestAttributeListener.class.isAssignableFrom(beanClass);
    }

    public WebBeansContext getWebBeansContext() {
        if (this.webbeansContext == null) {
            return this.getAppContext().getWebBeansContext();
        }
        return this.webbeansContext;
    }

    public Object inject(Object o) throws OpenEJBException {
        try {
            WebBeansContext webBeansContext = this.getWebBeansContext();
            Context initialContext = (Context)new InitialContext().lookup("java:");
            Context unwrap = InjectionProcessor.unwrap(initialContext);
            InjectionProcessor<Object> injectionProcessor = new InjectionProcessor<Object>(o, this.injections, unwrap);
            Object beanInstance = injectionProcessor.createInstance();
            if (webBeansContext != null) {
                ConstructorInjectionBean<Object> beanDefinition = this.getConstructorInjectionBean(o.getClass(), webBeansContext);
                CreationalContextImpl creationalContext = webBeansContext.getBeanManagerImpl().createCreationalContext(beanDefinition);
                InjectionTargetBean bean = (InjectionTargetBean)InjectionTargetBean.class.cast(beanDefinition);
                bean.getInjectionTarget().inject(beanInstance, (CreationalContext)creationalContext);
                Class scope = beanDefinition.getScope();
                if (scope == null || Dependent.class.equals((Object)scope)) {
                    this.creatonalContexts.put(beanInstance, (CreationalContext<?>)creationalContext);
                }
            }
            return beanInstance;
        }
        catch (NamingException e) {
            throw new OpenEJBException(e);
        }
    }

    public void setBindings(Map<String, Object> bindings) {
        this.bindings = bindings;
    }

    public Map<String, Object> getBindings() {
        return this.bindings;
    }

    public void setWebbeansContext(WebBeansContext webbeansContext) {
        this.webbeansContext = webbeansContext;
    }

    public WebBeansContext getWebbeansContext() {
        return this.webbeansContext;
    }

    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void destroy(Object o) {
        CreationalContext<?> ctx = this.creatonalContexts.remove(o);
        if (ctx != null) {
            ctx.release();
        }
    }
}

