/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.classloader.URLClassLoaderFirst;
import org.apache.xbean.finder.filter.Filter;

public class ContainerClassesFilter
implements Filter {
    private static final String[] EMPTY_ARRAY = new String[0];
    private final String[] forced;
    private final String[] skipped;
    private final Filter delegateAccept;
    private final Filter delegateSkip;

    public ContainerClassesFilter(Properties configuration) {
        String forcedStr = configuration == null ? null : configuration.getProperty("openejb.container.additional.exclude", null);
        String skippedStr = configuration == null ? null : configuration.getProperty("openejb.container.additional.include", null);
        this.forced = forcedStr == null ? EMPTY_ARRAY : forcedStr.split(" *, *");
        this.skipped = skippedStr == null ? EMPTY_ARRAY : skippedStr.split(" *, *");
        HashSet<String> excluded = new HashSet<String>();
        excluded.add("javax");
        excluded.add("org.apache.myfaces");
        excluded.add("org.apache.cxf");
        excluded.add("org.apache.oro");
        excluded.add("org.apache.ws");
        excluded.add("org.apache.jcp");
        excluded.add("org.apache.openejb");
        excluded.add("org.apache.tomee");
        excluded.add("org.apache.tomcat");
        excluded.add("org.apache.juli");
        excluded.add("org.apache.johnzon");
        excluded.add("org.apache.activemq");
        excluded.add("org.apache.neethi");
        excluded.add("org.apache.xml");
        excluded.add("org.apache.velocity");
        excluded.add("org.apache.wss4j");
        excluded.add("org.apache.commons.logging");
        excluded.add("org.metatype.sxc");
        excluded.add("org.openejb");
        excluded.add("org.slf4j");
        excluded.add("org.fusesource.hawtbuf");
        excluded.add("org.objectweb.howl");
        excluded.add("org.joda.time");
        excluded.add("org.codehaus.stax2");
        excluded.add("org.jvnet.mimepull");
        excluded.add("org.jasypt");
        excluded.add("org.hamcrest");
        excluded.add("org.swizzle");
        excluded.add("com.ctc.wstx");
        excluded.add("com.ibm.wsdl");
        excluded.add("net.sf.ehcache");
        excluded.add("junit");
        excluded.add("org.junit");
        excluded.add("serp");
        HashSet<String> included = new HashSet<String>();
        included.add("org.apache.myfaces.cdi");
        included.add("org.apache.myfaces.flow.cdi");
        this.delegateSkip = new OptimizedExclusionFilter(excluded);
        this.delegateAccept = new OptimizedExclusionFilter(included);
    }

    public ContainerClassesFilter() {
        this(SystemInstance.get().getProperties());
    }

    public boolean accept(String name) {
        if (this.forced != null && ContainerClassesFilter.startsWith(this.forced, name)) {
            return true;
        }
        if (this.skipped != null && ContainerClassesFilter.startsWith(this.skipped, name)) {
            return false;
        }
        return this.delegateAccept.accept(name) || !this.delegateSkip.accept(name) && !URLClassLoaderFirst.shouldSkip(name);
    }

    private static boolean startsWith(String[] array, String name) {
        for (String prefix : array) {
            if (!name.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static class OptimizedExclusionFilter
    implements Filter {
        private final Set<String> included;

        public OptimizedExclusionFilter(Set<String> exclusions) {
            this.included = exclusions;
        }

        public boolean accept(String name) {
            int dot = name.indexOf(46);
            while (dot > 0) {
                if (this.included.contains(name.substring(0, dot))) {
                    return true;
                }
                dot = name.indexOf(46, dot + 1);
            }
            return false;
        }
    }
}

