/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.ejbd;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.client.EJBRequest;
import org.apache.openejb.util.Messages;

public class DeploymentIndex {
    Messages messages = new Messages("org.apache.openejb.server.ejbd");
    DeploymentInfo[] deployments = null;
    Map index = null;

    public DeploymentIndex(DeploymentInfo[] deploymentInfos) {
        DeploymentInfo[] ds = deploymentInfos;
        this.deployments = new DeploymentInfo[ds.length + 1];
        System.arraycopy(ds, 0, this.deployments, 1, ds.length);
        this.index = new HashMap(this.deployments.length);
        for (int i = 1; i < this.deployments.length; ++i) {
            this.index.put(this.deployments[i].getDeploymentID(), new Integer(i));
        }
    }

    public DeploymentInfo getDeployment(EJBRequest req) throws RemoteException {
        DeploymentInfo info = null;
        int deploymentCode = req.getDeploymentCode();
        if (deploymentCode > 0 && deploymentCode < this.deployments.length) {
            info = this.deployments[deploymentCode];
            req.setDeploymentId((String)info.getDeploymentID());
            return info;
        }
        if (req.getDeploymentId() == null) {
            throw new RemoteException(this.messages.format("invalidDeploymentIdAndCode", new Object[]{req.getDeploymentId(), req.getDeploymentCode()}));
        }
        int idCode = this.getDeploymentIndex(req.getDeploymentId());
        if (idCode == -1) {
            throw new RemoteException(this.messages.format("noSuchDeploymentIdAndCode", new Object[]{req.getDeploymentId(), req.getDeploymentCode()}));
        }
        req.setDeploymentCode(idCode);
        if (req.getDeploymentCode() < 0 || req.getDeploymentCode() >= this.deployments.length) {
            throw new RemoteException(this.messages.format("invalidDeploymentIdAndCode", new Object[]{req.getDeploymentId(), req.getDeploymentCode()}));
        }
        return this.deployments[req.getDeploymentCode()];
    }

    public int getDeploymentIndex(DeploymentInfo deployment) {
        return this.getDeploymentIndex((String)deployment.getDeploymentID());
    }

    public int getDeploymentIndex(String deploymentID) {
        Integer idCode = (Integer)this.index.get(deploymentID);
        return idCode == null ? -1 : idCode;
    }

    public DeploymentInfo getDeployment(String deploymentID) {
        return this.getDeployment(this.getDeploymentIndex(deploymentID));
    }

    public DeploymentInfo getDeployment(Integer index) {
        return index == null ? null : this.getDeployment((int)index);
    }

    public DeploymentInfo getDeployment(int index) {
        return this.deployments[index];
    }
}

