/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.httpd.HttpRequestImpl;
import org.apache.openejb.server.httpd.HttpResponse;
import org.apache.openejb.server.httpd.HttpSession;
import org.apache.openejb.server.httpd.OpenEJBHttpServer;
import org.apache.openejb.server.httpd.ServletByteArrayOutputStream;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.OpenEjbVersion;

public class HttpResponseImpl
implements HttpResponse {
    private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER, (String)HttpResponseImpl.class.getName());
    private static final String DEFAULT_CONTENT_TYPE = SystemInstance.get().getProperty("openejb.http.default-content-type", "text/html");
    private String responseString = "OK";
    private int code = 200;
    private final Map<String, String> headers = new HashMap<String, String>();
    private transient PrintWriter writer;
    private transient ServletByteArrayOutputStream sosi;
    public static final String HTTP_VERSION = "HTTP/1.1";
    public static final String CRLF = "\r\n";
    public static final String SP = " ";
    public static final String CSP = ": ";
    public static String server;
    private HttpRequestImpl request;
    private URLConnection content;
    private boolean commited = false;
    private String encoding = "UTF-8";
    private Locale locale = Locale.getDefault();

    protected void setRequest(HttpRequestImpl request) {
        this.request = request;
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void setIntHeader(String s, int i) {
        this.headers.put(s, Integer.toString(i));
    }

    public void setStatus(int i) {
        this.setCode(i);
    }

    public void setStatus(int i, String s) {
        this.setCode(i);
        this.setStatusMessage(s);
    }

    public void addCookie(Cookie cookie) {
        this.headers.put(cookie.getName(), cookie.getValue());
    }

    public void addDateHeader(String s, long l) {
        this.headers.put(s, Long.toString(l));
    }

    public void addHeader(String s, String s1) {
        this.headers.put(s, s1);
    }

    public void addIntHeader(String s, int i) {
        this.setIntHeader(s, i);
    }

    public boolean containsHeader(String s) {
        return this.headers.containsKey(s);
    }

    public String encodeURL(String s) {
        return this.toEncoded(s);
    }

    public String encodeRedirectURL(String s) {
        return this.toEncoded(s);
    }

    public String encodeUrl(String s) {
        return this.toEncoded(s);
    }

    public String encodeRedirectUrl(String s) {
        return this.encodeRedirectURL(s);
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public Collection<String> getHeaders(String s) {
        return Arrays.asList(this.headers.get(s));
    }

    public int getStatus() {
        return this.getCode();
    }

    public void sendError(int i) throws IOException {
        this.setCode(i);
    }

    public void sendError(int i, String s) throws IOException {
        this.setCode(i);
        this.setStatusMessage(s);
    }

    public void sendRedirect(String path) throws IOException {
        if (this.commited) {
            throw new IllegalStateException("response already committed");
        }
        this.resetBuffer();
        try {
            this.setStatus(302);
            this.setHeader("Location", this.base() + this.toEncoded(path));
        }
        catch (IllegalArgumentException e) {
            this.setStatus(404);
        }
    }

    public void setDateHeader(String s, long l) {
        this.addDateHeader(s, l);
    }

    public ServletOutputStream getOutputStream() {
        return this.sosi;
    }

    public PrintWriter getWriter() throws IOException {
        return this.writer;
    }

    public boolean isCommitted() {
        return this.commited;
    }

    @Override
    public void flushBuffer() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    public int getBufferSize() {
        return this.sosi.getOutputStream().size();
    }

    public String getCharacterEncoding() {
        return this.encoding;
    }

    public void setCode(int code) {
        this.code = code;
        this.commited = true;
    }

    public int getCode() {
        return this.code;
    }

    @Override
    public void setContentType(String type) {
        this.setHeader("Content-Type", type);
    }

    public void setLocale(Locale loc) {
        this.locale = loc;
    }

    @Override
    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setResponseString(String responseString) {
        this.responseString = responseString;
    }

    public void reset() {
        this.initBody();
    }

    public void resetBuffer() {
        this.sosi.getOutputStream().reset();
    }

    public void setBufferSize(int i) {
    }

    public void setCharacterEncoding(String s) {
        this.encoding = s;
    }

    public void setContentLength(int i) {
    }

    public void setContentLengthLong(long length) {
    }

    public void reset(int code, String responseString) {
        this.setCode(code);
        this.setResponseString(responseString);
        this.initBody();
    }

    protected HttpResponseImpl() {
        this(200, "OK", DEFAULT_CONTENT_TYPE);
    }

    protected HttpResponseImpl(int code, String responseString, String contentType) {
        this.responseString = responseString;
        this.code = code;
        this.setHeader("Server", this.getServerName());
        this.setHeader("Connection", "close");
        this.setHeader("Content-Type", contentType);
        this.initBody();
    }

    protected void writeMessage(OutputStream output, boolean indent) throws IOException {
        this.flushBuffer();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        this.closeMessage();
        this.writeResponseLine(out);
        this.writeHeaders(out);
        this.writeBody(out, indent);
        out.flush();
        output.write(baos.toByteArray());
        output.flush();
    }

    private void initBody() {
        this.sosi = new ServletByteArrayOutputStream();
        this.writer = new PrintWriter((OutputStream)((Object)this.sosi));
    }

    public String toString() {
        return "HTTP/1.1 " + this.code + SP + this.responseString;
    }

    private void closeMessage() {
        this.setContentLengthHeader();
        this.setCookieHeader();
    }

    private void setContentLengthHeader() {
        if (this.content == null) {
            this.writer.flush();
            this.writer.close();
            int length = this.sosi.getOutputStream().toByteArray().length;
            this.setHeader("Content-Length", length + "");
        } else {
            this.setHeader("Content-Length", this.content.getContentLength() + "");
        }
    }

    private void setCookieHeader() {
        if (this.request == null) {
            return;
        }
        HttpSession session = this.request.getSession(false);
        if (session == null) {
            return;
        }
        this.headers.put("Set-Cookie", "EJBSESSIONID=" + session.getId() + "; Path=/");
    }

    private void writeResponseLine(DataOutput out) throws IOException {
        out.writeBytes(HTTP_VERSION);
        out.writeBytes(SP);
        out.writeBytes(this.code + "");
        out.writeBytes(SP);
        if (this.responseString != null) {
            out.writeBytes(this.responseString);
        }
        out.writeBytes(CRLF);
    }

    private void writeHeaders(DataOutput out) throws IOException {
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            out.writeBytes("" + entry.getKey());
            out.writeBytes(CSP);
            out.writeBytes("" + entry.getValue());
            out.writeBytes(CRLF);
        }
    }

    private void writeBody(DataOutput out, boolean indent) throws IOException {
        out.writeBytes(CRLF);
        if (this.content == null) {
            if (indent && OpenEJBHttpServer.isTextXml(this.headers)) {
                String xml = new String(this.sosi.getOutputStream().toByteArray());
                out.write(OpenEJBHttpServer.reformat(xml).getBytes());
            } else {
                out.write(this.sosi.getOutputStream().toByteArray());
            }
        } else {
            int i;
            InputStream in = this.content.getInputStream();
            byte[] buf = new byte[1024];
            while ((i = in.read(buf)) != -1) {
                out.write(buf, 0, i);
            }
        }
    }

    public String getServerName() {
        if (server == null) {
            String version = OpenEjbVersion.get().getVersion();
            String os = System.getProperty("os.name") + "/" + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")";
            server = "OpenEJB/" + version + SP + os;
        }
        return server;
    }

    protected static HttpResponseImpl createError(String message) {
        return HttpResponseImpl.createError(message, null);
    }

    protected static HttpResponseImpl createError(String message, Throwable t) {
        HttpResponseImpl res = new HttpResponseImpl(500, "Internal Server Error", "text/html");
        PrintWriter body = null;
        try {
            body = res.getWriter();
        }
        catch (IOException e) {
            // empty catch block
        }
        body.println("<html>");
        body.println("<body>");
        body.println("<h3>Internal Server Error</h3>");
        body.println("<br><br>");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.error(String.valueOf(t), t);
        }
        if (message != null) {
            StringTokenizer msg = new StringTokenizer(message, "\n\r");
            while (msg.hasMoreTokens()) {
                body.print(msg.nextToken());
                body.println("<br>");
            }
        }
        if (t != null) {
            try {
                body.println("<br><br>");
                body.println("Stack Trace:<br>");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintWriter writer = new PrintWriter(baos);
                t.printStackTrace(writer);
                writer.flush();
                writer.close();
                message = new String(baos.toByteArray());
                StringTokenizer msg = new StringTokenizer(message, "\n\r");
                while (msg.hasMoreTokens()) {
                    body.print(msg.nextToken());
                    body.println("<br>");
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        body.println("</body>");
        body.println("</html>");
        return res;
    }

    protected static HttpResponseImpl createForbidden(String ip) {
        HttpResponseImpl res = new HttpResponseImpl(403, "Forbidden", "text/html");
        PrintWriter body = null;
        try {
            body = res.getWriter();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        body.println("<html>");
        body.println("<body>");
        body.println("<h3>Forbidden</h3>");
        body.println("<br><br>");
        body.println("IP address: " + ip + " is not registered on this server, please contact your system administrator.");
        body.println("</body>");
        body.println("</html>");
        return res;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.responseString);
        out.writeInt(this.code);
        out.writeObject(this.headers);
        this.writer.flush();
        byte[] body = this.sosi.getOutputStream().toByteArray();
        out.writeObject(body);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.responseString = (String)in.readObject();
        this.code = in.readInt();
        Map headers = (Map)in.readObject();
        this.headers.clear();
        this.headers.putAll(headers);
        byte[] body = (byte[])in.readObject();
        this.sosi = new ServletByteArrayOutputStream();
        this.sosi.write(body);
        this.writer = new PrintWriter((OutputStream)((Object)this.sosi));
    }

    public void setContent(URLConnection content) {
        this.content = content;
    }

    @Override
    public void setStatusMessage(String responseString) {
        this.setResponseString(responseString);
    }

    private String base() {
        return this.request == null ? "" : this.request.getURI().getScheme() + "://" + this.request.getURI().getAuthority();
    }

    private String toEncoded(String url) {
        return url;
    }
}

