/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.openejb.AppContext;
import org.apache.openejb.assembler.classic.OpenEjbConfiguration;
import org.apache.openejb.assembler.classic.ServiceInfo;
import org.apache.openejb.core.WebContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.httpd.BeginWebBeansListener;
import org.apache.openejb.server.httpd.EndWebBeansListener;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.httpd.HttpListenerRegistry;
import org.apache.openejb.server.httpd.HttpRequest;
import org.apache.openejb.server.httpd.HttpRequestImpl;
import org.apache.openejb.server.httpd.HttpResponse;
import org.apache.openejb.server.httpd.HttpServerFactory;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.PropertyPlaceHolderHelper;
import org.apache.webbeans.config.WebBeansContext;

public class OpenEJBHttpRegistry {
    public static final Logger log = Logger.getInstance((LogCategory)LogCategory.HTTPSERVER, OpenEJBHttpRegistry.class);
    protected final HttpListenerRegistry registry;
    protected final List<URI> baseUris = new ArrayList<URI>();

    public OpenEJBHttpRegistry() {
        try {
            OpenEjbConfiguration configuration = (OpenEjbConfiguration)SystemInstance.get().getComponent(OpenEjbConfiguration.class);
            for (ServiceInfo service : configuration.facilities.services) {
                if (!service.className.equals(HttpServerFactory.class.getName())) continue;
                int port = Integer.parseInt(PropertyPlaceHolderHelper.simpleValue((String)service.properties.getProperty("port")));
                String ip = service.properties.getProperty("bind");
                if ("0.0.0.0".equals(ip)) {
                    InetAddress[] addresses;
                    for (InetAddress address : addresses = InetAddress.getAllByName(ip)) {
                        this.baseUris.add(new URI("http", null, address.getHostAddress(), port, null, null, null));
                    }
                } else {
                    this.baseUris.add(new URI("http", null, ip, port, null, null, null));
                }
                break;
            }
        }
        catch (Exception e) {
            log.error("Unable to build base URIs for " + this.getClass().getSimpleName() + " registry", (Throwable)e);
        }
        this.registry = (HttpListenerRegistry)SystemInstance.get().getComponent(HttpListenerRegistry.class);
    }

    public HttpListener addWrappedHttpListener(HttpListener httpListener, ClassLoader classLoader, String regex) {
        ClassLoaderHttpListener listener = new ClassLoaderHttpListener(httpListener, classLoader);
        this.registry.addHttpListener(listener, regex);
        return listener;
    }

    public List<String> getResolvedAddresses(String path) {
        String suffix = path;
        if (!path.startsWith("/")) {
            suffix = '/' + suffix;
        }
        ArrayList<String> addresses = new ArrayList<String>();
        Iterator<URI> i$ = this.baseUris.iterator();
        while (i$.hasNext()) {
            int port;
            URI baseUri;
            URI uri = baseUri = i$.next();
            if (baseUri.getPort() == 0 && (port = Integer.parseInt(SystemInstance.get().getProperty("httpejbd.port", "0"))) != 0) {
                try {
                    uri = new URI(baseUri.getScheme(), baseUri.getUserInfo(), baseUri.getHost(), port, baseUri.getPath(), baseUri.getQuery(), baseUri.getFragment());
                }
                catch (URISyntaxException e) {
                    // empty catch block
                }
            }
            URI address = uri.resolve(suffix);
            addresses.add(address.toString());
        }
        return addresses;
    }

    protected static class ClassLoaderHttpListener
    implements HttpListener {
        private final HttpListener delegate;
        private final ClassLoader classLoader;

        protected ClassLoaderHttpListener(HttpListener delegate, ClassLoader classLoader) {
            this.delegate = delegate;
            this.classLoader = classLoader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMessage(HttpRequest request, HttpResponse response) throws Exception {
            Thread thread = Thread.currentThread();
            ClassLoader oldCl = thread.getContextClassLoader();
            WebBeansContext wbc = null;
            try {
                if (request instanceof HttpRequestImpl) {
                    HttpRequestImpl httpRequest = (HttpRequestImpl)HttpRequestImpl.class.cast(request);
                    WebContext web = ClassLoaderHttpListener.findWebContext(request.getURI() == null ? request.getContextPath() : request.getURI().getPath());
                    if (web != null) {
                        httpRequest.setApplication(web);
                        if (web.getClassLoader() != null) {
                            thread.setContextClassLoader(web.getClassLoader());
                        } else if (web.getAppContext().getClassLoader() != null) {
                            thread.setContextClassLoader(web.getAppContext().getClassLoader());
                        }
                        String ctx = (web.getContextRoot().startsWith("/") ? "" : "/") + web.getContextRoot();
                        httpRequest.initPathFromContext(ctx);
                        wbc = web.getWebbeansContext() != null ? web.getWebbeansContext() : web.getAppContext().getWebBeansContext();
                    } else {
                        thread.setContextClassLoader(this.classLoader);
                        if (SystemInstance.isInitialized()) {
                            try {
                                wbc = WebBeansContext.currentInstance();
                            }
                            catch (IllegalStateException ise) {
                                // empty catch block
                            }
                        }
                    }
                    if (wbc != null) {
                        httpRequest.setAttribute("openejb_owb_context", wbc);
                        ClassLoaderHttpListener.initCdi(wbc, httpRequest).init();
                    }
                }
                this.delegate.onMessage(request, response);
            }
            finally {
                if (wbc != null) {
                    ((HttpRequestImpl)HttpRequestImpl.class.cast(request)).destroy();
                }
                thread.setContextClassLoader(oldCl);
            }
        }

        private static WebContext findWebContext(String path) {
            for (AppContext app : ((ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class)).getAppContexts()) {
                for (WebContext web : app.getWebContexts()) {
                    if (!path.startsWith(web.getContextRoot()) && !path.startsWith('/' + web.getContextRoot())) continue;
                    return web;
                }
            }
            return null;
        }

        private static HttpRequestImpl initCdi(WebBeansContext context, HttpRequestImpl request) {
            try {
                if (context.getBeanManagerImpl().isInUse()) {
                    request.setBeginListener(new BeginWebBeansListener(context));
                    request.setEndListener(new EndWebBeansListener(context));
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            return request;
        }

        public HttpListener getDelegate() {
            return this.delegate;
        }
    }
}

