/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.installer;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.jar.JarFile;
import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.SystemInstance;
import org.apache.tomee.installer.Alerts;
import org.apache.tomee.installer.InstallerInterface;
import org.apache.tomee.installer.InstallerTools;
import org.apache.tomee.installer.Installers;
import org.apache.tomee.installer.Paths;
import org.apache.tomee.installer.PathsInterface;
import org.apache.tomee.installer.Status;

public class Installer
implements InstallerInterface {
    private final Alerts alerts = new Alerts();
    private final Paths paths;
    private Status status = Status.NONE;
    private boolean force;
    private static final boolean listenerInstalled;
    private static final boolean agentInstalled;

    public static boolean isListenerInstalled() {
        return listenerInstalled;
    }

    public static boolean isAgentInstalled() {
        return agentInstalled;
    }

    public Installer(Paths paths) {
        this.paths = paths;
        if (listenerInstalled && agentInstalled) {
            this.status = Status.INSTALLED;
        }
    }

    public Installer(Paths paths, boolean force) {
        this(paths);
        this.force = force;
    }

    @Override
    public PathsInterface getPaths() {
        return this.paths;
    }

    @Override
    public Alerts getAlerts() {
        return this.alerts;
    }

    @Override
    public void reset() {
        this.alerts.reset();
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public void installAll() {
        this.installListener();
        this.installJavaagent();
        this.installConfigFiles(false);
        this.removeTomcatLibJar("annotations-api.jar");
        this.addTomEEJuli();
        this.addTomEEAdminConfInTomcatUsers();
        this.addTomEELinkToTomcatHome();
        this.workaroundOnBat();
        if (!this.alerts.hasErrors()) {
            this.status = Status.REBOOT_REQUIRED;
        }
    }

    private void addTomEEJuli() {
        File original = new File(this.paths.getCatalinaBinDir(), "tomcat-juli.jar");
        File juli = this.paths.findOpenEJBJar("tomee-juli");
        try {
            Installers.copyFile(juli, new File(original.getAbsolutePath()));
            if (!juli.delete()) {
                juli.deleteOnExit();
            }
        }
        catch (IOException e) {
            this.alerts.addInfo("Add tomee user to tomcat-users.xml");
        }
    }

    public void addTomEEAdminConfInTomcatUsers() {
        this.addTomEEAdminConfInTomcatUsers(false);
    }

    public void addTomEEAdminConfInTomcatUsers(boolean securityActivated) {
        String tomcatUsersXml = Installers.readAll(this.paths.getTomcatUsersXml(), this.alerts);
        if (tomcatUsersXml == null) {
            return;
        }
        if (tomcatUsersXml.contains("tomee-admin")) {
            this.alerts.addWarning("Can't add tomee user to tomcat-users.xml");
            return;
        }
        if (!Installers.backup(this.paths.getTomcatUsersXml(), this.alerts)) {
            return;
        }
        String roleUserTags = "  <role rolename=\"tomee-admin\" />\n  <user username=\"tomee\" password=\"tomee\" roles=\"tomee-admin,manager-gui\" />\n";
        String content = !securityActivated ? "  <!-- Activate those lines to get access to TomEE GUI -->\n  <!--\n  <role rolename=\"tomee-admin\" />\n  <user username=\"tomee\" password=\"tomee\" roles=\"tomee-admin,manager-gui\" />\n  -->\n</tomcat-users>\n" : "  <!-- Activate those lines to get access to TomEE GUI\n -->  <role rolename=\"tomee-admin\" />\n  <user username=\"tomee\" password=\"tomee\" roles=\"tomee-admin,manager-gui\" />\n</tomcat-users>\n";
        String newTomcatUsers = tomcatUsersXml.replace("</tomcat-users>", content);
        if (Installers.writeAll(this.paths.getTomcatUsersXml(), newTomcatUsers, this.alerts)) {
            this.alerts.addInfo("Add tomee user to tomcat-users.xml");
        }
    }

    public void installFull() {
        this.installListener("org.apache.tomee.catalina.ServerListener");
        this.installJavaagent();
        this.commentDeploymentDir();
        this.installConfigFiles(true);
        this.removeTomcatLibJar("annotations-api.jar");
        this.addTomEEJuli();
        this.moveLibs();
        this.addTomEEAdminConfInTomcatUsers();
        this.addTomEELinkToTomcatHome();
        this.workaroundOnBat();
        if (!this.alerts.hasErrors()) {
            this.status = Status.REBOOT_REQUIRED;
        }
    }

    private void workaroundOnBat() {
        File setclasspath;
        String bat;
        String catalinaBat = Installers.readAll(this.paths.getCatalinaBatFile(), this.alerts);
        if (catalinaBat == null || catalinaBat.contains("set _EXECJAVA=\"%_RUNJAVA%\"")) {
            return;
        }
        catalinaBat = catalinaBat.replace("set _EXECJAVA=%_RUNJAVA%", "set _EXECJAVA=\"%_RUNJAVA%\"").replace(" %_RUNJAVA%", " \"%_RUNJAVA%\"");
        if (!Installers.writeAll(this.paths.getCatalinaBatFile(), catalinaBat, this.alerts)) {
            this.alerts.addInfo("Can't add workarounds for catalina.bat");
        }
        if ((bat = Installers.readAll(setclasspath = new File(this.paths.getCatalinaBinDir(), "setclasspath.bat"), this.alerts)) == null || bat.contains(" NOT DEFINED ")) {
            return;
        }
        if (!Installers.writeAll(setclasspath, bat = bat.replace("not \"%JRE_HOME%\" == \"\"", "DEFINED JRE_HOME").replace("not \"%JAVA_HOME%\" == \"\"", "DEFINED JAVA_HOME").replace("not \"%_RUNJAVA%\" == \"\"", "DEFINED _RUNJAVA").replace("not \"%_RUNJDB%\" == \"\"", "DEFINED _RUNJDB").replace("\"%JAVA_HOME%\" == \"\"", "NOT DEFINED JAVA_HOME"), this.alerts)) {
            this.alerts.addInfo("Can't add workarounds for setclasspath.bat");
        }
    }

    private void removeTomcatLibJar(String name) {
        File jar = new File(this.paths.getCatalinaLibDir(), name);
        this.removeJar(jar);
    }

    private void commentDeploymentDir() {
        File tomeeXml = new File(this.paths.getCatalinaConfDir(), "tomee.xml");
        if (!tomeeXml.exists()) {
            Installers.writeAll(tomeeXml, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<tomee>\n  <!-- see http://tomee.apache.org/containers-and-resources.html -->\n\n  <!-- activate next line to be able to deploy applications in apps -->\n  <!-- <Deployments dir=\"apps\" /> -->\n</tomee>\n", this.alerts);
        }
    }

    private void addTomEELinkToTomcatHome() {
        File home = this.paths.getHome();
        if (!home.exists()) {
            return;
        }
        String indeJsp = Installers.readAll(home, this.alerts);
        if (indeJsp == null) {
            return;
        }
        if (!indeJsp.contains("tomcatUrl")) {
            this.alerts.addWarning("webapps/ROOT/index.jsp was modified");
            return;
        }
        String newIndeJsp = indeJsp.replaceFirst("<div id=\"actions\">", "<div id=\"actions\">\n                    <div class=\"button\">\n                        <a class=\"container shadow\" href=\"/tomee\"><span>TomEE Gui</span></a>\n                    </div>");
        Installers.writeAll(home, newIndeJsp, this.alerts);
    }

    private void moveLibs() {
        File libs = this.paths.getCatalinaLibDir();
        File[] files = this.paths.getOpenEJBLibDir().listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory() || !file.getName().endsWith(".jar")) continue;
                try {
                    Installers.copyFile(file, new File(libs, file.getName()));
                    if (!file.delete()) {
                        file.deleteOnExit();
                    }
                    this.alerts.addInfo("Copy " + file.getName() + " to lib");
                }
                catch (IOException e) {
                    this.alerts.addError("Unable to " + file.getName() + " to Tomcat lib directory.  This will need to be " + "performed manually.", e);
                }
            }
        }
    }

    private void removeJar(File jar) {
        if (jar.exists()) {
            if (!jar.delete()) {
                jar.deleteOnExit();
            }
            this.alerts.addInfo("Please restart the server or delete manually " + jar.getName());
        }
    }

    public void installListener() {
        this.installListener("org.apache.tomee.loader.OpenEJBListener");
    }

    public void installListener(String listener) {
        String serverXmlOriginal;
        if (listenerInstalled && !this.force) {
            return;
        }
        boolean copyOpenEJBLoader = true;
        File destination = new File(this.paths.getCatalinaLibDir(), this.paths.getOpenEJBTomcatLoaderJar().getName());
        if (destination.exists() && this.paths.getOpenEJBTomcatLoaderJar().length() == destination.length()) {
            copyOpenEJBLoader = false;
        }
        if (copyOpenEJBLoader) {
            try {
                Installers.copyFile(this.paths.getOpenEJBTomcatLoaderJar(), destination);
                this.alerts.addInfo("Copy " + this.paths.getOpenEJBTomcatLoaderJar().getName() + " to lib");
            }
            catch (IOException e) {
                this.alerts.addError("Unable to copy OpenEJB Tomcat loader jar to Tomcat lib directory.  This will need to be performed manually.", e);
            }
        }
        if ((serverXmlOriginal = Installers.readAll(this.paths.getServerXmlFile(), this.alerts)) == null) {
            return;
        }
        if (serverXmlOriginal.contains(listener)) {
            this.alerts.addWarning("OpenEJB Listener already declared in Tomcat server.xml file.");
            return;
        }
        if (!Installers.backup(this.paths.getServerXmlFile(), this.alerts)) {
            return;
        }
        String newServerXml = null;
        try {
            newServerXml = Installers.replace(serverXmlOriginal, "<Server", "<Server", ">", ">\r\n  <!-- TomEE plugin for Tomcat -->\r\n  <Listener className=\"" + listener + "\" />");
        }
        catch (IOException e) {
            this.alerts.addError("Error while adding listener to server.xml file", e);
        }
        try {
            newServerXml = Installers.replace(newServerXml, "<Connector port=\"8080\"", "<Connector port=\"8080\"", "/>", "xpoweredBy=\"false\" server=\"Apache TomEE\" />");
            newServerXml = Installers.replace(newServerXml, "<Connector port=\"8443\"", "<Connector port=\"8443\"", "/>", "xpoweredBy=\"false\" server=\"Apache TomEE\" />");
        }
        catch (IOException e) {
            this.alerts.addError("Error adding server attribute to server.xml file", e);
        }
        if (Installers.writeAll(this.paths.getServerXmlFile(), newServerXml, this.alerts)) {
            this.alerts.addInfo("Add OpenEJB listener to server.xml");
        }
    }

    public void installJavaagent() {
        String catalinaBatOriginal;
        boolean isCatalinaShExecutable;
        String catalinaShOriginal;
        if (agentInstalled && !this.force) {
            return;
        }
        boolean copyJavaagentJar = true;
        File javaagentJar = new File(this.paths.getCatalinaLibDir(), "openejb-javaagent.jar");
        if (javaagentJar.exists() && this.paths.getOpenEJBJavaagentJar().length() == javaagentJar.length()) {
            copyJavaagentJar = false;
        }
        if (copyJavaagentJar) {
            try {
                Installers.copyFile(this.paths.getOpenEJBJavaagentJar(), javaagentJar);
                this.alerts.addInfo("Copy " + this.paths.getOpenEJBJavaagentJar().getName() + " to lib");
            }
            catch (IOException e) {
                this.alerts.addError("Unable to copy OpenEJB javaagent jar to Tomcat lib directory.  This will need to be performed manually.", e);
            }
        }
        if ((catalinaShOriginal = Installers.readAll(this.paths.getCatalinaShFile(), this.alerts)) == null) {
            return;
        }
        if (catalinaShOriginal.contains("Add OpenEJB javaagent")) {
            this.alerts.addWarning("OpenEJB javaagent already declared in Tomcat catalina.sh file.");
            return;
        }
        if (!Installers.backup(this.paths.getCatalinaShFile(), this.alerts)) {
            return;
        }
        String openejbJavaagentPath = this.paths.getCatalinaHomeDir().toURI().relativize(javaagentJar.toURI()).getPath();
        String newCatalinaSh = catalinaShOriginal.replace("# ----- Execute The Requested Command", "# Add OpenEJB javaagent\nif [ -r \"$CATALINA_HOME\"/" + openejbJavaagentPath + " ]; then\n" + "  JAVA_OPTS=\"\\\"-javaagent:$CATALINA_HOME/" + openejbJavaagentPath + "\\\" $JAVA_OPTS\"\n" + "fi\n" + "\n" + "# ----- Execute The Requested Command");
        if (Installers.writeAll(this.paths.getCatalinaShFile(), newCatalinaSh, this.alerts)) {
            this.alerts.addInfo("Add OpenEJB JavaAgent to catalina.sh");
        }
        if (!(isCatalinaShExecutable = this.paths.getCatalinaShFile().canExecute())) {
            try {
                isCatalinaShExecutable = this.paths.getCatalinaShFile().setExecutable(true);
            }
            catch (SecurityException e) {
                this.alerts.addWarning("Cannot change CatalinaSh executable attribute.");
            }
        }
        if (!isCatalinaShExecutable) {
            this.alerts.addWarning("CatalinaSh is not executable.");
        }
        if ((catalinaBatOriginal = Installers.readAll(this.paths.getCatalinaBatFile(), this.alerts)) == null) {
            return;
        }
        if (catalinaBatOriginal.contains("Add OpenEJB javaagent")) {
            this.alerts.addWarning("OpenEJB javaagent already declared in Tomcat catalina.bat file.");
            return;
        }
        if (!Installers.backup(this.paths.getCatalinaBatFile(), this.alerts)) {
            return;
        }
        openejbJavaagentPath = openejbJavaagentPath.replace('/', '\\');
        String newCatalinaBat = catalinaBatOriginal.replace("rem ----- Execute The Requested Command", "rem Add OpenEJB javaagent\r\nif not exist \"%CATALINA_HOME%\\" + openejbJavaagentPath + "\" goto noOpenEJBJavaagent\r\n" + "set JAVA_OPTS=\"-javaagent:%CATALINA_HOME%\\" + openejbJavaagentPath + "\" %JAVA_OPTS%\r\n" + ":noOpenEJBJavaagent\r\n" + "\r\n" + "rem ----- Execute The Requested Command");
        if (Installers.writeAll(this.paths.getCatalinaBatFile(), newCatalinaBat, this.alerts)) {
            this.alerts.addInfo("Add OpenEJB JavaAgent to catalina.bat");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installConfigFiles(boolean builtIn) {
        JarFile openejbTomcatCommonJar;
        File openejbSystemProperties;
        String openEjbXml;
        JarFile coreJar;
        File openejbCoreJar = this.paths.getOpenEJBCoreJar();
        File confDir = this.paths.getCatalinaConfDir();
        Alerts alerts = this.alerts;
        if (openejbCoreJar == null) {
            return;
        }
        try {
            coreJar = new JarFile(openejbCoreJar);
        }
        catch (IOException e) {
            return;
        }
        File openEjbXmlFile = new File(confDir, "tomee.xml");
        if (!openEjbXmlFile.exists() && (openEjbXml = Installers.readEntry(coreJar, "default.openejb.conf", alerts)) != null && Installers.writeAll(openEjbXmlFile, openEjbXml.replace("<openejb>", "<tomee>").replace("</openejb>", "</tomee>"), alerts)) {
            alerts.addInfo("Copy tomee.xml to conf");
        }
        String openejbLoggingProps = "################################\r\n# OpenEJB/TomEE specific loggers\r\n################################\r\n#\r\n# ACTIVATE LEVEL/HANDLERS YOU WANT\r\n# IF YOU ACTIVATE 5tomee.org.apache.juli.FileHandler\r\n# ADD IT TO handlers LINE LIKE:\r\n#\r\n# handlers = 1catalina.org.apache.juli.FileHandler, 2localhost.org.apache.juli.FileHandler, 3manager.org.apache.juli.FileHandler, 4host-manager.org.apache.juli.FileHandler, 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n#\r\n# LEVELS:\r\n# =======\r\n#\r\n# OpenEJB.level             = WARNING\r\n# OpenEJB.options.level     = INFO\r\n# OpenEJB.server.level      = INFO\r\n# OpenEJB.startup.level     = INFO\r\n# OpenEJB.startup.service.level = WARNING\r\n# OpenEJB.startup.config.level = INFO\r\n# OpenEJB.hsql.level        = INFO\r\n# CORBA-Adapter.level       = WARNING\r\n# Transaction.level         = WARNING\r\n# org.apache.activemq.level = SEVERE\r\n# org.apache.geronimo.level = SEVERE\r\n# openjpa.level             = WARNING\r\n# OpenEJB.cdi.level         = INFO\r\n# org.apache.webbeans.level = INFO\r\n# org.apache.openejb.level = FINE\r\n#\r\n# HANDLERS:\r\n# =========\r\n#\r\n# OpenEJB.handlers             = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# OpenEJB.options.handlers     = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# OpenEJB.server.handlers      = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# OpenEJB.startup.handlers     = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# OpenEJB.startup.service.handlers = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# OpenEJB.startup.config.handlers = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# OpenEJB.hsql.handlers        = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# CORBA-Adapter.handlers       = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# Transaction.handlers         = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# org.apache.activemq.handlers = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# org.apache.geronimo.handlers = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# openjpa.handlers             = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# OpenEJB.cdi.handlers         = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# org.apache.webbeans.handlers = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# org.apache.openejb.handlers = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n#\r\n# TOMEE HANDLER SAMPLE:\r\n# =====================\r\n#\r\n# 5tomee.org.apache.juli.FileHandler.level = FINEST\r\n# 5tomee.org.apache.juli.FileHandler.directory = ${catalina.base}/logs\r\n# 5tomee.org.apache.juli.FileHandler.prefix = tomee.\r\n";
        File loggingPropsFile = new File(confDir, "logging.properties");
        String newLoggingProps = null;
        if (!loggingPropsFile.exists()) {
            newLoggingProps = "################################\r\n# OpenEJB/TomEE specific loggers\r\n################################\r\n#\r\n# ACTIVATE LEVEL/HANDLERS YOU WANT\r\n# IF YOU ACTIVATE 5tomee.org.apache.juli.FileHandler\r\n# ADD IT TO handlers LINE LIKE:\r\n#\r\n# handlers = 1catalina.org.apache.juli.FileHandler, 2localhost.org.apache.juli.FileHandler, 3manager.org.apache.juli.FileHandler, 4host-manager.org.apache.juli.FileHandler, 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n#\r\n# LEVELS:\r\n# =======\r\n#\r\n# OpenEJB.level             = WARNING\r\n# OpenEJB.options.level     = INFO\r\n# OpenEJB.server.level      = INFO\r\n# OpenEJB.startup.level     = INFO\r\n# OpenEJB.startup.service.level = WARNING\r\n# OpenEJB.startup.config.level = INFO\r\n# OpenEJB.hsql.level        = INFO\r\n# CORBA-Adapter.level       = WARNING\r\n# Transaction.level         = WARNING\r\n# org.apache.activemq.level = SEVERE\r\n# org.apache.geronimo.level = SEVERE\r\n# openjpa.level             = WARNING\r\n# OpenEJB.cdi.level         = INFO\r\n# org.apache.webbeans.level = INFO\r\n# org.apache.openejb.level = FINE\r\n#\r\n# HANDLERS:\r\n# =========\r\n#\r\n# OpenEJB.handlers             = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# OpenEJB.options.handlers     = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# OpenEJB.server.handlers      = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# OpenEJB.startup.handlers     = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# OpenEJB.startup.service.handlers = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# OpenEJB.startup.config.handlers = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# OpenEJB.hsql.handlers        = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# CORBA-Adapter.handlers       = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# Transaction.handlers         = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# org.apache.activemq.handlers = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# org.apache.geronimo.handlers = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# openjpa.handlers             = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# OpenEJB.cdi.handlers         = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# org.apache.webbeans.handlers = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# org.apache.openejb.handlers = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n#\r\n# TOMEE HANDLER SAMPLE:\r\n# =====================\r\n#\r\n# 5tomee.org.apache.juli.FileHandler.level = FINEST\r\n# 5tomee.org.apache.juli.FileHandler.directory = ${catalina.base}/logs\r\n# 5tomee.org.apache.juli.FileHandler.prefix = tomee.\r\n";
        } else {
            String loggingPropsOriginal = Installers.readAll(loggingPropsFile, alerts);
            if (!loggingPropsOriginal.toLowerCase().contains("openejb")) {
                newLoggingProps = loggingPropsOriginal + "\r\n\r\n" + "################################\r\n# OpenEJB/TomEE specific loggers\r\n################################\r\n#\r\n# ACTIVATE LEVEL/HANDLERS YOU WANT\r\n# IF YOU ACTIVATE 5tomee.org.apache.juli.FileHandler\r\n# ADD IT TO handlers LINE LIKE:\r\n#\r\n# handlers = 1catalina.org.apache.juli.FileHandler, 2localhost.org.apache.juli.FileHandler, 3manager.org.apache.juli.FileHandler, 4host-manager.org.apache.juli.FileHandler, 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n#\r\n# LEVELS:\r\n# =======\r\n#\r\n# OpenEJB.level             = WARNING\r\n# OpenEJB.options.level     = INFO\r\n# OpenEJB.server.level      = INFO\r\n# OpenEJB.startup.level     = INFO\r\n# OpenEJB.startup.service.level = WARNING\r\n# OpenEJB.startup.config.level = INFO\r\n# OpenEJB.hsql.level        = INFO\r\n# CORBA-Adapter.level       = WARNING\r\n# Transaction.level         = WARNING\r\n# org.apache.activemq.level = SEVERE\r\n# org.apache.geronimo.level = SEVERE\r\n# openjpa.level             = WARNING\r\n# OpenEJB.cdi.level         = INFO\r\n# org.apache.webbeans.level = INFO\r\n# org.apache.openejb.level = FINE\r\n#\r\n# HANDLERS:\r\n# =========\r\n#\r\n# OpenEJB.handlers             = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# OpenEJB.options.handlers     = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# OpenEJB.server.handlers      = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# OpenEJB.startup.handlers     = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# OpenEJB.startup.service.handlers = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# OpenEJB.startup.config.handlers = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# OpenEJB.hsql.handlers        = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# CORBA-Adapter.handlers       = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# Transaction.handlers         = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# org.apache.activemq.handlers = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# org.apache.geronimo.handlers = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# openjpa.handlers             = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# OpenEJB.cdi.handlers         = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# org.apache.webbeans.handlers = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n# org.apache.openejb.handlers = 5tomee.org.apache.juli.FileHandler, java.util.logging.ConsoleHandler\r\n#\r\n# TOMEE HANDLER SAMPLE:\r\n# =====================\r\n#\r\n# 5tomee.org.apache.juli.FileHandler.level = FINEST\r\n# 5tomee.org.apache.juli.FileHandler.directory = ${catalina.base}/logs\r\n# 5tomee.org.apache.juli.FileHandler.prefix = tomee.\r\n" + "\r\n";
            }
        }
        if (builtIn) {
            this.installTomEEJuli(alerts, loggingPropsFile, newLoggingProps);
        }
        if (!(openejbSystemProperties = new File(confDir, "system.properties")).exists()) {
            FileWriter systemPropertiesWriter = null;
            try {
                systemPropertiesWriter = new FileWriter(openejbSystemProperties);
                systemPropertiesWriter.write("# all this properties are added at JVM system properties at startup\n");
                systemPropertiesWriter.write("# here some default Apache TomEE system properties\n");
                systemPropertiesWriter.write("# for more information please see http://tomee.apache.org/properties-listing.html\n");
                systemPropertiesWriter.write("\n");
                systemPropertiesWriter.write("# openejb.check.classloader = false\n");
                systemPropertiesWriter.write("# openejb.check.classloader.verbose = false\n");
                systemPropertiesWriter.write("\n");
                systemPropertiesWriter.write("# tomee.jaxws.subcontext = webservices\n");
                systemPropertiesWriter.write("# tomee.jaxws.oldsubcontext = false\n");
                systemPropertiesWriter.write("\n");
                systemPropertiesWriter.write("# if you want to propagate a deployment on a cluster when a tomcat cluster is defined\n");
                systemPropertiesWriter.write("# tomee.cluster.deployment = false\n");
                systemPropertiesWriter.write("\n");
                systemPropertiesWriter.write("# openejb.system.apps = true\n");
                systemPropertiesWriter.write("# openejb.servicemanager.enabled = true\n");
                systemPropertiesWriter.write("# openejb.jmx.active = false\n");
                systemPropertiesWriter.write("# openejb.descriptors.output = false\n");
                systemPropertiesWriter.write("# openejb.strict.interface.declaration = false\n");
                systemPropertiesWriter.write("# openejb.conf.file = conf/tomee.xml\n");
                systemPropertiesWriter.write("# openejb.debuggable-vm-hackery = false\n");
                systemPropertiesWriter.write("# openejb.validation.skip = false\n");
                systemPropertiesWriter.write("# openejb.webservices.enabled = true\n");
                systemPropertiesWriter.write("# openejb.validation.output.level = MEDIUM\n");
                systemPropertiesWriter.write("# openejb.user.mbeans.list = *\n");
                systemPropertiesWriter.write("# openejb.deploymentId.format = {appId}/{ejbJarId}/{ejbName}\n");
                systemPropertiesWriter.write("# openejb.jndiname.format = {deploymentId}{interfaceType.annotationName}\n");
                systemPropertiesWriter.write("# openejb.deployments.package.include = .*\n");
                systemPropertiesWriter.write("# openejb.deployments.package.exclude = \n");
                systemPropertiesWriter.write("# openejb.autocreate.jta-datasource-from-non-jta-one = true\n");
                systemPropertiesWriter.write("# openejb.altdd.prefix = \n");
                systemPropertiesWriter.write("# org.apache.openejb.default.system.interceptors = \n");
                systemPropertiesWriter.write("# openejb.jndiname.failoncollision = true\n");
                systemPropertiesWriter.write("# openejb.wsAddress.format = /{ejbDeploymentId}\n");
                systemPropertiesWriter.write("# org.apache.openejb.server.webservices.saaj.provider = \n");
                systemPropertiesWriter.write("# openejb.nobanner = true\n");
                systemPropertiesWriter.write("# openejb.offline = false\n");
                systemPropertiesWriter.write("# openejb.jmx.active = true\n");
                systemPropertiesWriter.write("# openejb.exclude-include.order = include-exclude\n");
                systemPropertiesWriter.write("# openejb.additional.exclude =\n");
                systemPropertiesWriter.write("# openejb.additional.include =\n");
                systemPropertiesWriter.write("# openejb.crosscontext = false\n");
                systemPropertiesWriter.write("# openejb.jsessionid-support = \n");
                systemPropertiesWriter.write("# openejb.myfaces.disable-default-values = true\n");
                systemPropertiesWriter.write("# openejb.web.xml.major = \n");
                systemPropertiesWriter.write("# openjpa.Log = \n");
                systemPropertiesWriter.write("# openejb.jdbc.log = false\n");
                systemPropertiesWriter.write("# javax.persistence.provider = org.apache.openjpa.persistence.PersistenceProviderImpl\n");
                systemPropertiesWriter.write("# javax.persistence.transactionType = \n");
                systemPropertiesWriter.write("# javax.persistence.jtaDataSource = \n");
                systemPropertiesWriter.write("# javax.persistence.nonJtaDataSource = \n");
                systemPropertiesWriter.write("#\n");
                systemPropertiesWriter.write("# Properties for JAS RS\n");
                systemPropertiesWriter.write("# openejb.jaxrs.application = \n");
                systemPropertiesWriter.write("# openejb.cxf-rs.wadl-generator.ignoreRequests = false\n");
                systemPropertiesWriter.write("# openejb.cxf-rs.wadl-generator.ignoreMessageWriters = true\n");
                systemPropertiesWriter.write("#\n");
                systemPropertiesWriter.write("# These properties are only for cxf service (SOAP webservices) and TomEE+\n");
                systemPropertiesWriter.write("# If you don't use special tricks and sun default implementation, uncommenting these 4 lines forces TomEE to use it without overhead at all = \n");
                systemPropertiesWriter.write("# javax.xml.soap.MessageFactory = com.sun.xml.messaging.saaj.soap.ver1_1.SOAPMessageFactory1_1Impl\n");
                systemPropertiesWriter.write("# javax.xml.soap.SOAPFactory = com.sun.xml.messaging.saaj.soap.ver1_1.SOAPFactory1_1Impl\n");
                systemPropertiesWriter.write("# javax.xml.soap.SOAPConnectionFactory = com.sun.xml.messaging.saaj.client.p2p.HttpSOAPConnectionFactory\n");
                systemPropertiesWriter.write("# javax.xml.soap.MetaFactory = com.sun.xml.messaging.saaj.soap.SAAJMetaFactoryImpl\n");
            }
            catch (IOException e) {
            }
            finally {
                if (systemPropertiesWriter != null) {
                    try {
                        systemPropertiesWriter.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        try {
            openejbTomcatCommonJar = new JarFile(this.paths.geOpenEJBTomcatCommonJar());
        }
        catch (IOException e) {
            return;
        }
        File webXmlFile = new File(confDir, "web.xml");
        String webXml = Installers.readEntry(openejbTomcatCommonJar, "conf/web.xml", alerts);
        if (Installers.writeAll(webXmlFile, webXml, alerts)) {
            alerts.addInfo("Set jasper in production mode in TomEE web.xml");
        }
    }

    private void installTomEEJuli(Alerts alerts, File loggingPropsFile, String newLoggingProps) {
        if (newLoggingProps != null && Installers.writeAll(loggingPropsFile, newLoggingProps.replace("java.util.logging.ConsoleHandler", "org.apache.tomee.jul.formatter.AsyncConsoleHandler"), alerts)) {
            alerts.addInfo("Append OpenEJB config to logging.properties");
        }
    }

    static {
        Options opts = SystemInstance.get().getOptions();
        listenerInstalled = "OpenEJBListener".equals(opts.get("openejb.embedder.source", "")) || "ServerListener".equals(opts.get("openejb.embedder.source", ""));
        agentInstalled = InstallerTools.invokeStaticNoArgMethod("org.apache.openejb.javaagent.Agent", "getInstrumentation") != null;
    }
}

