/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jest;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.openjpa.persistence.jest.JSON;

public class JSONObject
implements JSON {
    private final String _type;
    private final String _id;
    private final boolean _ref;
    private final Map<String, Object> _values;

    public JSONObject(String type, Object id, boolean ref) {
        this._type = type;
        this._id = id.toString();
        this._ref = ref;
        this._values = new LinkedHashMap<String, Object>();
    }

    public void set(String key, Object value) {
        this._values.put(key, value);
    }

    public void write(PrintWriter writer) {
        writer.println(this.toString());
    }

    public String toString() {
        return this.asString(0).toString();
    }

    @Override
    public StringBuilder asString(int indent) {
        StringBuilder buf = new StringBuilder().append('{');
        buf.append((CharSequence)JSONObject.encodeField(this._ref ? "$ref" : "$id", this.ior(), 0));
        if (this._ref) {
            return buf.append('}');
        }
        StringBuilder tab = JSONObject.newIndent(indent + 1);
        for (Map.Entry<String, Object> e : this._values.entrySet()) {
            buf.append(',').append("\r\n");
            buf.append((CharSequence)tab).append((CharSequence)JSONObject.encodeField(e.getKey(), e.getValue(), indent + 1));
        }
        buf.append("\r\n").append((CharSequence)JSONObject.newIndent(indent)).append('}');
        return buf;
    }

    private static StringBuilder encodeField(String field, Object value, int indent) {
        return new StringBuilder().append((CharSequence)JSONObject.quoteFieldName(field)).append(':').append((CharSequence)JSONObject.quoteFieldValue(value, indent));
    }

    private static StringBuilder newIndent(int indent) {
        char[] tabs = new char[indent * 4];
        Arrays.fill(tabs, ' ');
        return new StringBuilder().append(tabs);
    }

    StringBuilder ior() {
        return new StringBuilder(this._type).append('-').append(this._id);
    }

    private static StringBuilder quoteFieldName(String s) {
        return new StringBuilder().append('\"').append(s).append('\"');
    }

    private static StringBuilder quoteFieldValue(Object o, int indent) {
        if (o == null) {
            return new StringBuilder("null");
        }
        if (o instanceof Number) {
            return new StringBuilder(o.toString());
        }
        if (o instanceof JSON) {
            return ((JSON)o).asString(indent);
        }
        return JSONObject.quoted(o.toString());
    }

    private static StringBuilder quoted(Object o) {
        if (o == null) {
            return new StringBuilder("null");
        }
        return new StringBuilder().append('\"').append(o.toString()).append('\"');
    }

    public static void main(String[] args) throws Exception {
        JSONObject o = new JSONObject("Person", 1234, false);
        JSONObject r = new JSONObject("Person", 1234, true);
        JSONObject f = new JSONObject("Person", 2345, false);
        Array a = new Array();
        a.add(f);
        a.add(3456);
        a.add(null);
        a.add(r);
        a.add(null);
        KVMap map = new KVMap();
        map.put("k1", r);
        map.put("k2", f);
        map.put("k3", null);
        map.put("k4", 3456);
        map.put(null, 6789);
        f.set("name", "Mary");
        f.set("age", 30);
        f.set("friend", r);
        o.set("name", "John");
        o.set("age", 20);
        o.set("friend", f);
        o.set("friends", a);
        o.set("map", map);
    }

    public static class KVMap
    implements JSON {
        private Map<Object, Object> _entries = new LinkedHashMap<Object, Object>();

        public void put(Object k, Object v) {
            this._entries.put(k, v);
        }

        public String toString() {
            return this.asString(0).toString();
        }

        @Override
        public StringBuilder asString(int indent) {
            StringBuilder buf = new StringBuilder().append('[');
            StringBuilder tab = JSONObject.newIndent(indent + 1);
            for (Map.Entry<Object, Object> e : this._entries.entrySet()) {
                if (buf.length() > 1) {
                    buf.append(',');
                }
                buf.append("\r\n").append((CharSequence)tab);
                Object key = e.getKey();
                if (key instanceof JSON) {
                    buf.append((CharSequence)((JSON)key).asString(indent + 1));
                } else {
                    buf.append(key);
                }
                buf.append(':');
                Object value = e.getValue();
                if (value instanceof JSON) {
                    buf.append((CharSequence)((JSON)value).asString(indent + 2));
                    continue;
                }
                buf.append(value);
            }
            buf.append("\r\n").append((CharSequence)JSONObject.newIndent(indent)).append(']');
            return buf;
        }
    }

    public static class Array
    implements JSON {
        private List<Object> _members = new ArrayList<Object>();

        public void add(Object o) {
            this._members.add(o);
        }

        public String toString() {
            return this.asString(0).toString();
        }

        @Override
        public StringBuilder asString(int indent) {
            StringBuilder buf = new StringBuilder().append('[');
            StringBuilder tab = JSONObject.newIndent(indent + 1);
            for (Object o : this._members) {
                if (buf.length() > 1) {
                    buf.append(',');
                }
                buf.append("\r\n").append((CharSequence)tab);
                if (o instanceof JSON) {
                    buf.append((CharSequence)((JSON)o).asString(indent + 1));
                    continue;
                }
                buf.append(o);
            }
            buf.append("\r\n").append((CharSequence)JSONObject.newIndent(indent)).append(']');
            return buf;
        }
    }
}

