/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.rop;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.commons.lang.ObjectUtils;
import org.apache.openjpa.lib.rop.AbstractListIterator;
import org.apache.openjpa.lib.rop.AbstractResultList;
import org.apache.openjpa.lib.rop.ResultListIterator;

public abstract class AbstractNonSequentialResultList
extends AbstractResultList {
    protected static final Object PAST_END = new Object();

    protected abstract Object getInternal(int var1);

    public boolean contains(Object o) {
        Object obj;
        this.assertOpen();
        int i = 0;
        while ((obj = this.getInternal(i)) != PAST_END) {
            if (ObjectUtils.equals((Object)o, (Object)obj)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean containsAll(Collection c) {
        this.assertOpen();
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            if (this.contains(itr.next())) continue;
            return false;
        }
        return true;
    }

    public Object get(int index) {
        this.assertOpen();
        Object obj = this.getInternal(index);
        if (obj == PAST_END) {
            throw new NoSuchElementException();
        }
        return obj;
    }

    public int indexOf(Object o) {
        Object obj;
        this.assertOpen();
        int i = 0;
        while ((obj = this.getInternal(i)) != PAST_END) {
            if (ObjectUtils.equals((Object)o, (Object)obj)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(Object o) {
        Object obj;
        this.assertOpen();
        int index = -1;
        int i = 0;
        while ((obj = this.getInternal(i)) != PAST_END) {
            if (ObjectUtils.equals((Object)o, (Object)obj)) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    public boolean isEmpty() {
        this.assertOpen();
        return this.getInternal(0) == PAST_END;
    }

    public Iterator iterator() {
        return this.listIterator();
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int index) {
        return new ResultListIterator(new Itr(index), this);
    }

    public Object[] toArray() {
        Object obj;
        this.assertOpen();
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while ((obj = this.getInternal(i)) != PAST_END) {
            list.add(obj);
            ++i;
        }
        return list.toArray();
    }

    public Object[] toArray(Object[] a) {
        Object obj;
        this.assertOpen();
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while ((obj = this.getInternal(i)) != PAST_END) {
            list.add(obj);
            ++i;
        }
        return list.toArray(a);
    }

    public List subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    private class Itr
    extends AbstractListIterator {
        private int _idx = 0;
        private Object _next = PAST_END;

        public Itr(int index) {
            this._idx = index;
        }

        public int nextIndex() {
            return this._idx;
        }

        public int previousIndex() {
            return this._idx - 1;
        }

        public boolean hasNext() {
            this._next = AbstractNonSequentialResultList.this.getInternal(this._idx);
            return this._next != PAST_END;
        }

        public boolean hasPrevious() {
            return this._idx > 0;
        }

        public Object previous() {
            if (this._idx == 0) {
                throw new NoSuchElementException();
            }
            return AbstractNonSequentialResultList.this.getInternal(--this._idx);
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this._idx;
            return this._next;
        }
    }
}

