/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.NestableRuntimeException;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import serp.util.Strings;

public class Files {
    public static File backup(File file, boolean copy) {
        File bk;
        if (file == null || !AccessController.doPrivileged(J2DoPrivHelper.existsAction(file)).booleanValue()) {
            return null;
        }
        String aPath = AccessController.doPrivileged(J2DoPrivHelper.getAbsolutePathAction(file));
        File clone = new File(aPath);
        if (!AccessController.doPrivileged(J2DoPrivHelper.renameToAction(clone, bk = new File(aPath + "~"))).booleanValue()) {
            return null;
        }
        if (copy) {
            try {
                Files.copy(bk, file);
            }
            catch (IOException ioe) {
                throw new NestableRuntimeException((Throwable)ioe);
            }
        }
        return bk;
    }

    public static File revert(File backup, boolean copy) {
        File orig;
        if (backup == null) {
            return null;
        }
        if (!backup.getName().endsWith("~")) {
            backup = new File(backup.getPath() + "~");
        }
        if (!AccessController.doPrivileged(J2DoPrivHelper.existsAction(backup)).booleanValue()) {
            return null;
        }
        String path = AccessController.doPrivileged(J2DoPrivHelper.getAbsolutePathAction(backup));
        File clone = new File(path);
        if (!AccessController.doPrivileged(J2DoPrivHelper.renameToAction(clone, orig = new File(path.substring(0, path.length() - 1)))).booleanValue()) {
            return null;
        }
        if (copy) {
            try {
                Files.copy(orig, backup);
            }
            catch (IOException ioe) {
                throw new NestableRuntimeException((Throwable)ioe);
            }
        }
        return orig;
    }

    public static File getSourceFile(Class cls) {
        return Files.getClassFile(cls, ".java");
    }

    public static File getClassFile(Class cls) {
        return Files.getClassFile(cls, ".class");
    }

    private static File getClassFile(Class cls, String ext) {
        URL rsrc;
        String name = Strings.getClassName((Class)cls);
        int innerIdx = name.indexOf(36);
        if (innerIdx != -1) {
            name = name.substring(0, innerIdx);
        }
        if ((rsrc = AccessController.doPrivileged(J2DoPrivHelper.getResourceAction(cls, name + ext))) != null && rsrc.getProtocol().equals("file")) {
            return new File(URLDecoder.decode(rsrc.getFile()));
        }
        return null;
    }

    public static File getPackageFile(File base, String pkg, boolean mkdirs) {
        if (base == null) {
            base = new File(AccessController.doPrivileged(J2DoPrivHelper.getPropertyAction("user.dir")));
        }
        if (StringUtils.isEmpty((String)pkg)) {
            if (mkdirs && !AccessController.doPrivileged(J2DoPrivHelper.existsAction(base)).booleanValue()) {
                AccessController.doPrivileged(J2DoPrivHelper.mkdirsAction(base));
            }
            return base;
        }
        pkg = pkg.replace('.', File.separatorChar);
        File file = null;
        try {
            file = AccessController.doPrivileged(J2DoPrivHelper.getCanonicalPathAction(base)).endsWith(pkg) ? base : new File(base, pkg);
        }
        catch (PrivilegedActionException pae) {
            throw new NestableRuntimeException((Throwable)((IOException)pae.getException()));
        }
        catch (IOException ioe) {
            throw new NestableRuntimeException((Throwable)ioe);
        }
        if (mkdirs && !AccessController.doPrivileged(J2DoPrivHelper.existsAction(file)).booleanValue()) {
            AccessController.doPrivileged(J2DoPrivHelper.mkdirsAction(file));
        }
        return file;
    }

    public static File getFile(String name, ClassLoader loader) {
        File rsrc;
        String urlFile;
        URL url;
        if (name == null) {
            return null;
        }
        File file = new File(name);
        if (AccessController.doPrivileged(J2DoPrivHelper.existsAction(file)).booleanValue()) {
            return file;
        }
        if (loader == null) {
            loader = AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
        }
        if ((url = AccessController.doPrivileged(J2DoPrivHelper.getResourceAction(loader, name))) != null && (urlFile = url.getFile()) != null && AccessController.doPrivileged(J2DoPrivHelper.existsAction(rsrc = new File(URLDecoder.decode(urlFile)))).booleanValue()) {
            return rsrc;
        }
        return file;
    }

    public static Writer getWriter(String file, ClassLoader loader) throws IOException {
        if (file == null) {
            return null;
        }
        if ("stdout".equals(file)) {
            return new PrintWriter(System.out);
        }
        if ("stderr".equals(file)) {
            return new PrintWriter(System.err);
        }
        try {
            return new FileWriter(Files.getFile(file, loader));
        }
        catch (IOException ioe) {
            throw new NestableRuntimeException((Throwable)ioe);
        }
    }

    public static OutputStream getOutputStream(String file, ClassLoader loader) {
        if (file == null) {
            return null;
        }
        if ("stdout".equals(file)) {
            return System.out;
        }
        if ("stderr".equals(file)) {
            return System.err;
        }
        try {
            return AccessController.doPrivileged(J2DoPrivHelper.newFileOutputStreamAction(Files.getFile(file, loader)));
        }
        catch (PrivilegedActionException pae) {
            throw new NestableRuntimeException((Throwable)pae.getException());
        }
        catch (IOException ioe) {
            throw new NestableRuntimeException((Throwable)ioe);
        }
    }

    /*
     * Loose catch block
     */
    public static boolean copy(File from, File to) throws IOException {
        Exception e22;
        boolean bl;
        FileOutputStream out;
        FileInputStream in;
        block14: {
            int b;
            if (from == null || to == null || !AccessController.doPrivileged(J2DoPrivHelper.existsAction(from)).booleanValue()) {
                return false;
            }
            in = null;
            out = null;
            in = AccessController.doPrivileged(J2DoPrivHelper.newFileInputStreamAction(from));
            BufferedInputStream inbuf = new BufferedInputStream(in);
            out = AccessController.doPrivileged(J2DoPrivHelper.newFileOutputStreamAction(to));
            BufferedOutputStream outbuf = new BufferedOutputStream(out);
            while ((b = inbuf.read()) != -1) {
                outbuf.write(b);
            }
            outbuf.flush();
            bl = true;
            Object var8_8 = null;
            if (in == null) break block14;
            try {
                in.close();
            }
            catch (Exception e22) {
                // empty catch block
            }
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (Exception e22) {
                // empty catch block
            }
        }
        return bl;
        catch (PrivilegedActionException pae) {
            try {
                throw (FileNotFoundException)pae.getException();
            }
            catch (Throwable throwable) {
                block16: {
                    Exception e22;
                    Object var8_9 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception e22) {
                            // empty catch block
                        }
                    }
                    if (out == null) break block16;
                    try {
                        out.close();
                    }
                    catch (Exception e22) {}
                }
                throw throwable;
            }
        }
    }
}

