/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.ResourceBundleProvider;

class ZipResourceBundleProvider
implements ResourceBundleProvider {
    ZipResourceBundleProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceBundle findResource(String name, Locale locale, ClassLoader loader) {
        InputStream in;
        String rsrc = name.replace('.', '/') + ".properties";
        if (loader == null) {
            loader = AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
        }
        if ((in = loader.getResourceAsStream(rsrc)) == null) {
            return null;
        }
        ZipInputStream zip = new ZipInputStream(in);
        try {
            ZipEntry ze;
            while ((ze = zip.getNextEntry()) != null) {
                if (rsrc.equals(ze.getName())) {
                    PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(zip);
                    return propertyResourceBundle;
                }
                zip.closeEntry();
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                zip.close();
            }
            catch (IOException ioe) {}
        }
        return null;
    }
}

