/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.conversation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.BusyConversationException;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.NonexistentConversationException;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import org.apache.webbeans.annotation.BeforeDestroyedLiteral;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.annotation.DestroyedLiteral;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.ConversationContext;
import org.apache.webbeans.context.RequestContext;
import org.apache.webbeans.conversation.ConversationImpl;
import org.apache.webbeans.conversation.ConversationStorageBean;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.ConversationService;
import org.apache.webbeans.util.Asserts;

public class ConversationManager {
    private static final Logger logger = WebBeansLoggerFacade.getLogger(ConversationManager.class);
    private final WebBeansContext webBeansContext;
    private final Bean<Set<ConversationContext>> conversationStorageBean;

    public ConversationManager(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        ConversationStorageBean convBean = new ConversationStorageBean(webBeansContext);
        BeanManagerImpl bm = webBeansContext.getBeanManagerImpl();
        bm.addInternalBean(convBean);
        this.conversationStorageBean = bm.resolve(bm.getBeans("apache.openwebbeans.OwbInternalConversationStorageBean"));
    }

    public ConversationContext getConversationContext(Context sessionContext) {
        ConversationService conversationService = this.webBeansContext.getConversationService();
        Set<ConversationContext> conversationContexts = this.getSessionConversations(sessionContext, false);
        NonexistentConversationException problem = null;
        String conversationId = conversationService.getConversationId();
        if (conversationId != null && conversationId.length() > 0) {
            if (conversationContexts != null) {
                for (ConversationContext conversationContext : conversationContexts) {
                    if (!conversationId.equals(conversationContext.getConversation().getId())) continue;
                    if (conversationContext.getConversation().iUseIt() > 1) {
                        problem = new BusyConversationException("Propogated conversation with cid=" + conversationContext.getConversation().getId() + " is used by other request. It creates a new transient conversation");
                        conversationContext.getConversation().setProblemDuringCreation((RuntimeException)problem);
                    } else {
                        conversationContext.getConversation().updateLastAccessTime();
                    }
                    conversationContext.setActive(true);
                    return conversationContext;
                }
            }
            problem = new NonexistentConversationException("Propogated conversation with cid=" + conversationId + " cannot be restored. Will create a new transient conversation.");
        }
        ConversationContext conversationContext = new ConversationContext(this.webBeansContext);
        conversationContext.setActive(true);
        conversationContext.getConversation().setProblemDuringCreation((RuntimeException)problem);
        return conversationContext;
    }

    public void addToConversationStorage(ConversationContext conversationContext, String conversationId) {
        Asserts.assertNotNull(conversationId, "conversationId");
        Context sessionContext = this.webBeansContext.getContextsService().getCurrentContext(SessionScoped.class);
        Set<ConversationContext> sessionConversations = this.getSessionConversations(sessionContext, true);
        for (ConversationContext sessionConversation : sessionConversations) {
            if (!conversationId.equals(sessionConversation.getConversation().getId())) continue;
            throw new IllegalArgumentException("Conversation with id=" + conversationId + " already exists!");
        }
        sessionConversations.add(conversationContext);
    }

    public boolean removeConversationFromStorage(ConversationContext conversationContext) {
        Context sessionContext = this.webBeansContext.getContextsService().getCurrentContext(SessionScoped.class);
        Set<ConversationContext> sessionConversations = this.getSessionConversations(sessionContext, true);
        return sessionConversations.remove(conversationContext);
    }

    public Conversation getConversationBeanReference() {
        BeanManagerImpl beanManager = this.webBeansContext.getBeanManagerImpl();
        Bean bean = (Bean)beanManager.getBeans((Type)((Object)Conversation.class), new Annotation[]{DefaultLiteral.INSTANCE}).iterator().next();
        Conversation conversation = (Conversation)beanManager.getReference(bean, (Type)((Object)Conversation.class), beanManager.createCreationalContext((Contextual)bean));
        return conversation;
    }

    public boolean conversationTimedOut(ConversationImpl conv) {
        long timeout = 0L;
        try {
            timeout = conv.getTimeout();
        }
        catch (BusyConversationException bce) {
            return false;
        }
        if (timeout != 0L && System.currentTimeMillis() - conv.getLastAccessTime() > timeout) {
            logger.log(Level.FINE, "INFO_0011", conv.getId());
            return true;
        }
        return false;
    }

    public void destroyConversationContext(ConversationContext ctx) {
        this.webBeansContext.getBeanManagerImpl().fireEvent(this.getLifecycleEventPayload(ctx), new Annotation[]{BeforeDestroyedLiteral.INSTANCE_CONVERSATION_SCOPED});
        ctx.destroy();
        this.webBeansContext.getBeanManagerImpl().fireEvent(this.getLifecycleEventPayload(ctx), new Annotation[]{DestroyedLiteral.INSTANCE_CONVERSATION_SCOPED});
    }

    public Object getLifecycleEventPayload(ConversationContext ctx) {
        RequestContext requestContext;
        Object payLoad = null;
        if (ctx.getConversation().getId() != null) {
            payLoad = ctx.getConversation().getId();
        }
        if (payLoad == null && (requestContext = (RequestContext)this.webBeansContext.getContextsService().getCurrentContext(RequestScoped.class)) != null) {
            payLoad = requestContext.getRequestObject();
        }
        if (payLoad == null) {
            payLoad = new Object();
        }
        return payLoad;
    }

    public Set<ConversationContext> getSessionConversations(Context sessionContext, boolean create) {
        Set conversationContexts = null;
        if (sessionContext != null) {
            if (!create) {
                conversationContexts = (Set)sessionContext.get(this.conversationStorageBean);
            } else {
                CreationalContext creationalContext = this.webBeansContext.getBeanManagerImpl().createCreationalContext((Contextual)this.conversationStorageBean);
                conversationContexts = (Set)sessionContext.get(this.conversationStorageBean, creationalContext);
            }
        }
        return conversationContexts;
    }
}

