/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.spi;

import java.net.URL;
import java.util.List;
import java.util.Set;

public interface BeanArchiveService {
    public BeanArchiveInformation getBeanArchiveInformation(URL var1);

    public Set<URL> getRegisteredBeanArchives();

    public void release();

    public static interface BeanArchiveInformation {
        public String getVersion();

        public BeanDiscoveryMode getBeanDiscoveryMode();

        public boolean isClassExcluded(String var1);

        public boolean isPackageExcluded(String var1);

        public List<String> getInterceptors();

        public List<String> getDecorators();

        public List<String> getAlternativeClasses();

        public List<String> getAlternativeStereotypes();

        public List<String> getExcludedClasses();

        public List<String> getExcludedPackages();

        public List<String> getAllowProxyingClasses();
    }

    public static enum BeanDiscoveryMode {
        ALL(10),
        SCOPED(8),
        ANNOTATED(5),
        NONE(2);

        private final int ordinal;

        private BeanDiscoveryMode(int ordinal) {
            this.ordinal = ordinal;
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public static BeanDiscoveryMode getByOrdinal(int ordinal) {
            for (BeanDiscoveryMode beanDiscoveryMode : BeanDiscoveryMode.values()) {
                if (beanDiscoveryMode.getOrdinal() != ordinal) continue;
                return beanDiscoveryMode;
            }
            return null;
        }

        public static BeanDiscoveryMode max(BeanDiscoveryMode bdmA, BeanDiscoveryMode bdmB) {
            if (bdmA == null) {
                return bdmB;
            }
            if (bdmB == null) {
                return bdmA;
            }
            return BeanDiscoveryMode.getByOrdinal(Math.max(bdmA.getOrdinal(), bdmB.getOrdinal()));
        }
    }
}

