/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.examples;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.RecordReader;
import org.apache.orc.TypeDescription;

public class CoreReader {
    public static void main(Configuration conf, String[] args) throws IOException {
        Reader reader = OrcFile.createReader((Path)new Path("my-file.orc"), (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf));
        System.out.println("File schema: " + reader.getSchema());
        System.out.println("Row count: " + reader.getNumberOfRows());
        TypeDescription readSchema = TypeDescription.fromString((String)"struct<z:int,y:string,x:bigint>");
        VectorizedRowBatch batch = readSchema.createRowBatch();
        RecordReader rowIterator = reader.rows(reader.options().schema(readSchema));
        LongColumnVector z = (LongColumnVector)batch.cols[0];
        BytesColumnVector y = (BytesColumnVector)batch.cols[1];
        LongColumnVector x = (LongColumnVector)batch.cols[2];
        while (rowIterator.nextBatch(batch)) {
            for (int row = 0; row < batch.size; ++row) {
                int zRow = z.isRepeating ? 0 : row;
                int xRow = x.isRepeating ? 0 : row;
                System.out.println("z: " + (z.noNulls || !z.isNull[zRow] ? Long.valueOf(z.vector[zRow]) : null));
                System.out.println("y: " + y.toString(row));
                System.out.println("x: " + (x.noNulls || !x.isNull[xRow] ? Long.valueOf(x.vector[xRow]) : null));
            }
        }
        rowIterator.close();
    }

    public static void main(String[] args) throws IOException {
        CoreReader.main(new Configuration(), args);
    }
}

