/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.internal.column.columnindex;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.PrimitiveIterator;
import org.apache.parquet.internal.column.columnindex.IndexIterator;
import org.junit.Assert;
import org.junit.Test;

public class TestIndexIterator {
    @Test
    public void testAll() {
        TestIndexIterator.assertEquals(IndexIterator.all((int)10), 0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
    }

    @Test
    public void testFilter() {
        TestIndexIterator.assertEquals(IndexIterator.filter((int)30, value -> value % 3 == 0), 0, 3, 6, 9, 12, 15, 18, 21, 24, 27);
    }

    @Test
    public void testFilterTranslate() {
        TestIndexIterator.assertEquals(IndexIterator.filterTranslate((int)20, value -> value < 5, Math::negateExact), 0, -1, -2, -3, -4);
    }

    @Test
    public void testRangeTranslate() {
        TestIndexIterator.assertEquals(IndexIterator.rangeTranslate((int)11, (int)18, i -> i - 10), 1, 2, 3, 4, 5, 6, 7, 8);
    }

    static void assertEquals(PrimitiveIterator.OfInt actualIt, int ... expectedValues) {
        IntArrayList actualList = new IntArrayList();
        actualIt.forEachRemaining(arg_0 -> TestIndexIterator.lambda$assertEquals$3((IntList)actualList, arg_0));
        int[] actualValues = actualList.toIntArray();
        Assert.assertArrayEquals((String)("ExpectedValues: " + Arrays.toString(expectedValues) + " ActualValues: " + Arrays.toString(actualValues)), (int[])expectedValues, (int[])actualValues);
    }

    private static /* synthetic */ void lambda$assertEquals$3(IntList actualList, int value) {
        actualList.add(value);
    }
}

