/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.util;

import org.apache.parquet.TestUtils;
import org.apache.parquet.util.Concatenator;
import org.apache.parquet.util.DynConstructors;
import org.apache.parquet.util.DynMethods;
import org.junit.Assert;
import org.junit.Test;

public class TestDynMethods {
    @Test
    public void testNoImplCall() {
        DynMethods.Builder builder = new DynMethods.Builder("concat");
        TestUtils.assertThrows("Checked build should throw NoSuchMethodException", NoSuchMethodException.class, () -> ((DynMethods.Builder)builder).buildChecked());
        TestUtils.assertThrows("Normal build should throw RuntimeException", RuntimeException.class, () -> ((DynMethods.Builder)builder).build());
    }

    @Test
    public void testMissingClass() {
        DynMethods.Builder builder = new DynMethods.Builder("concat").impl("not.a.RealClass", new Class[]{String.class, String.class});
        TestUtils.assertThrows("Checked build should throw NoSuchMethodException", NoSuchMethodException.class, () -> ((DynMethods.Builder)builder).buildChecked());
        TestUtils.assertThrows("Normal build should throw RuntimeException", RuntimeException.class, () -> ((DynMethods.Builder)builder).build());
    }

    @Test
    public void testMissingMethod() {
        DynMethods.Builder builder = new DynMethods.Builder("concat").impl(Concatenator.class, "cat2strings", new Class[]{String.class, String.class});
        TestUtils.assertThrows("Checked build should throw NoSuchMethodException", NoSuchMethodException.class, () -> ((DynMethods.Builder)builder).buildChecked());
        TestUtils.assertThrows("Normal build should throw RuntimeException", RuntimeException.class, () -> ((DynMethods.Builder)builder).build());
    }

    @Test
    public void testFirstImplReturned() throws Exception {
        Concatenator obj = new Concatenator("-");
        DynMethods.UnboundMethod cat2 = new DynMethods.Builder("concat").impl("not.a.RealClass", new Class[]{String.class, String.class}).impl(Concatenator.class, new Class[]{String.class, String.class}).impl(Concatenator.class, new Class[]{String.class, String.class, String.class}).buildChecked();
        Assert.assertEquals((String)"Should call the 2-arg version successfully", (Object)"a-b", (Object)cat2.invoke((Object)obj, new Object[]{"a", "b"}));
        Assert.assertEquals((String)"Should ignore extra arguments", (Object)"a-b", (Object)cat2.invoke((Object)obj, new Object[]{"a", "b", "c"}));
        DynMethods.UnboundMethod cat3 = new DynMethods.Builder("concat").impl("not.a.RealClass", new Class[]{String.class, String.class}).impl(Concatenator.class, new Class[]{String.class, String.class, String.class}).impl(Concatenator.class, new Class[]{String.class, String.class}).build();
        Assert.assertEquals((String)"Should call the 3-arg version successfully", (Object)"a-b-c", (Object)cat3.invoke((Object)obj, new Object[]{"a", "b", "c"}));
        Assert.assertEquals((String)"Should call the 3-arg version null padding", (Object)"a-b-null", (Object)cat3.invoke((Object)obj, new Object[]{"a", "b"}));
    }

    @Test
    public void testVarArgs() throws Exception {
        DynMethods.UnboundMethod cat = new DynMethods.Builder("concat").impl(Concatenator.class, new Class[]{String[].class}).buildChecked();
        Assert.assertEquals((String)"Should use the varargs version", (Object)"abcde", (Object)cat.invokeChecked((Object)new Concatenator(), new Object[]{new String[]{"a", "b", "c", "d", "e"}}));
        Assert.assertEquals((String)"Should use the varargs version", (Object)"abcde", (Object)cat.bind((Object)new Concatenator()).invokeChecked(new Object[]{new String[]{"a", "b", "c", "d", "e"}}));
    }

    @Test
    public void testIncorrectArguments() throws Exception {
        Concatenator obj = new Concatenator("-");
        DynMethods.UnboundMethod cat = new DynMethods.Builder("concat").impl("not.a.RealClass", new Class[]{String.class, String.class}).impl(Concatenator.class, new Class[]{String.class, String.class}).buildChecked();
        TestUtils.assertThrows("Should fail if non-string arguments are passed", IllegalArgumentException.class, () -> cat.invoke((Object)obj, new Object[]{3, 4}));
        TestUtils.assertThrows("Should fail if non-string arguments are passed", IllegalArgumentException.class, () -> cat.invokeChecked((Object)obj, new Object[]{3, 4}));
    }

    @Test
    public void testExceptionThrown() throws Exception {
        Concatenator.SomeCheckedException exc = new Concatenator.SomeCheckedException();
        Concatenator obj = new Concatenator("-");
        DynMethods.UnboundMethod cat = new DynMethods.Builder("concat").impl("not.a.RealClass", new Class[]{String.class, String.class}).impl(Concatenator.class, new Class[]{Exception.class}).buildChecked();
        TestUtils.assertThrows("Should re-throw the exception", Concatenator.SomeCheckedException.class, () -> cat.invokeChecked((Object)obj, new Object[]{exc}));
        TestUtils.assertThrows("Should wrap the exception in RuntimeException", RuntimeException.class, () -> cat.invoke((Object)obj, new Object[]{exc}));
    }

    @Test
    public void testNameChange() throws Exception {
        Concatenator obj = new Concatenator("-");
        DynMethods.UnboundMethod cat = new DynMethods.Builder("cat").impl(Concatenator.class, "concat", new Class[]{String.class, String.class}).buildChecked();
        Assert.assertEquals((String)"Should find 2-arg concat method", (Object)"a-b", (Object)cat.invoke((Object)obj, new Object[]{"a", "b"}));
    }

    @Test
    public void testStringClassname() throws Exception {
        Concatenator obj = new Concatenator("-");
        DynMethods.UnboundMethod cat = new DynMethods.Builder("concat").impl(Concatenator.class.getName(), new Class[]{String.class, String.class}).buildChecked();
        Assert.assertEquals((String)"Should find 2-arg concat method", (Object)"a-b", (Object)cat.invoke((Object)obj, new Object[]{"a", "b"}));
    }

    @Test
    public void testHiddenMethod() throws Exception {
        Concatenator obj = new Concatenator("-");
        TestUtils.assertThrows("Should fail to find hidden method", NoSuchMethodException.class, () -> new DynMethods.Builder("setSeparator").impl(Concatenator.class, new Class[]{String.class}).buildChecked());
        DynMethods.UnboundMethod changeSep = new DynMethods.Builder("setSeparator").hiddenImpl(Concatenator.class, new Class[]{String.class}).buildChecked();
        Assert.assertNotNull((String)"Should find hidden method with hiddenImpl", (Object)changeSep);
        changeSep.invokeChecked((Object)obj, new Object[]{"/"});
        Assert.assertEquals((String)"Should use separator / instead of -", (Object)"a/b", (Object)obj.concat("a", "b"));
    }

    @Test
    public void testBoundMethod() throws Exception {
        DynMethods.UnboundMethod cat = new DynMethods.Builder("concat").impl(Concatenator.class, new Class[]{String.class, String.class}).buildChecked();
        DynMethods.BoundMethod dashCat = cat.bind((Object)new Concatenator("-"));
        DynMethods.BoundMethod underCat = cat.bind((Object)new Concatenator("_"));
        Assert.assertEquals((String)"Should use '-' object without passing", (Object)"a-b", (Object)dashCat.invoke(new Object[]{"a", "b"}));
        Assert.assertEquals((String)"Should use '_' object without passing", (Object)"a_b", (Object)underCat.invoke(new Object[]{"a", "b"}));
        DynMethods.BoundMethod slashCat = new DynMethods.Builder("concat").impl(Concatenator.class, new Class[]{String.class, String.class}).buildChecked((Object)new Concatenator("/"));
        Assert.assertEquals((String)"Should use bound object from builder without passing", (Object)"a/b", (Object)slashCat.invoke(new Object[]{"a", "b"}));
    }

    @Test
    public void testBindStaticMethod() throws Exception {
        DynMethods.Builder builder = new DynMethods.Builder("cat").impl(Concatenator.class, new Class[]{String[].class});
        TestUtils.assertThrows("Should complain that method is static", IllegalStateException.class, () -> builder.buildChecked((Object)new Concatenator()));
        TestUtils.assertThrows("Should complain that method is static", IllegalStateException.class, () -> builder.build((Object)new Concatenator()));
        DynMethods.UnboundMethod staticCat = builder.buildChecked();
        Assert.assertTrue((String)"Should be static", (boolean)staticCat.isStatic());
        TestUtils.assertThrows("Should complain that method is static", IllegalStateException.class, () -> staticCat.bind((Object)new Concatenator()));
    }

    @Test
    public void testStaticMethod() throws Exception {
        DynMethods.StaticMethod staticCat = new DynMethods.Builder("cat").impl(Concatenator.class, new Class[]{String[].class}).buildStaticChecked();
        Assert.assertEquals((String)"Should call varargs static method cat(String...)", (Object)"abcde", (Object)staticCat.invokeChecked(new Object[]{new String[]{"a", "b", "c", "d", "e"}}));
    }

    @Test
    public void testNonStaticMethod() throws Exception {
        DynMethods.Builder builder = new DynMethods.Builder("concat").impl(Concatenator.class, new Class[]{String.class, String.class});
        TestUtils.assertThrows("Should complain that method is not static", IllegalStateException.class, () -> ((DynMethods.Builder)builder).buildStatic());
        TestUtils.assertThrows("Should complain that method is not static", IllegalStateException.class, () -> ((DynMethods.Builder)builder).buildStaticChecked());
        DynMethods.UnboundMethod cat2 = builder.buildChecked();
        Assert.assertFalse((String)"concat(String,String) should not be static", (boolean)cat2.isStatic());
        TestUtils.assertThrows("Should complain that method is not static", IllegalStateException.class, () -> ((DynMethods.UnboundMethod)cat2).asStatic());
    }

    @Test
    public void testConstructorImpl() throws Exception {
        DynMethods.Builder builder = new DynMethods.Builder("newConcatenator").ctorImpl(Concatenator.class, new Class[]{String.class}).impl(Concatenator.class, new Class[]{String.class});
        DynMethods.UnboundMethod newConcatenator = builder.buildChecked();
        Assert.assertTrue((String)"Should find constructor implementation", (boolean)(newConcatenator instanceof DynConstructors.Ctor));
        Assert.assertTrue((String)"Constructor should be a static method", (boolean)newConcatenator.isStatic());
        Assert.assertFalse((String)"Constructor should not be NOOP", (boolean)newConcatenator.isNoop());
        TestUtils.assertThrows("Should complain that ctor method is static", IllegalStateException.class, () -> builder.buildChecked((Object)new Concatenator()));
        TestUtils.assertThrows("Should complain that ctor method is static", IllegalStateException.class, () -> builder.build((Object)new Concatenator()));
        Concatenator concatenator = (Concatenator)newConcatenator.asStatic().invoke(new Object[]{"*"});
        Assert.assertEquals((String)"Should function as a concatenator", (Object)"a*b", (Object)concatenator.concat("a", "b"));
        concatenator = (Concatenator)newConcatenator.asStatic().invokeChecked(new Object[]{"@"});
        Assert.assertEquals((String)"Should function as a concatenator", (Object)"a@b", (Object)concatenator.concat("a", "b"));
    }

    @Test
    public void testConstructorImplAfterFactoryMethod() throws Exception {
        DynMethods.UnboundMethod newConcatenator = new DynMethods.Builder("newConcatenator").impl(Concatenator.class, new Class[]{String.class}).ctorImpl(Concatenator.class, new Class[]{String.class}).buildChecked();
        Assert.assertFalse((String)"Should find factory method before constructor method", (boolean)(newConcatenator instanceof DynConstructors.Ctor));
    }

    @Test
    public void testNoop() throws Exception {
        DynMethods.UnboundMethod noop = new DynMethods.Builder("concat").impl("not.a.RealClass", new Class[]{String.class, String.class}).orNoop().buildChecked();
        Assert.assertTrue((String)"No implementation found, should return NOOP", (boolean)noop.isNoop());
        Assert.assertNull((String)"NOOP should always return null", (Object)noop.invoke((Object)new Concatenator(), new Object[]{"a"}));
        Assert.assertNull((String)"NOOP can be called with null", (Object)noop.invoke(null, new Object[]{"a"}));
        Assert.assertNull((String)"NOOP can be bound", (Object)noop.bind((Object)new Concatenator()).invoke(new Object[]{"a"}));
        Assert.assertNull((String)"NOOP can be bound to null", (Object)noop.bind(null).invoke(new Object[]{"a"}));
        Assert.assertNull((String)"NOOP can be static", (Object)noop.asStatic().invoke(new Object[]{"a"}));
    }
}

