package org.apache.parquet.column.values.bitpacking;
import java.nio.ByteBuffer;

/**
 * Packs from the Most Significant Bit first
 * 
 * See ByteBasedBitPackingGenerator to make changes to this file
 * Automatically generated
 *
 */
public abstract class ByteBitPackingForLongBE {

  private static final BytePackerForLong[] packers = new BytePackerForLong[65];
  static {
    packers[0] = new Packer0();
    packers[1] = new Packer1();
    packers[2] = new Packer2();
    packers[3] = new Packer3();
    packers[4] = new Packer4();
    packers[5] = new Packer5();
    packers[6] = new Packer6();
    packers[7] = new Packer7();
    packers[8] = new Packer8();
    packers[9] = new Packer9();
    packers[10] = new Packer10();
    packers[11] = new Packer11();
    packers[12] = new Packer12();
    packers[13] = new Packer13();
    packers[14] = new Packer14();
    packers[15] = new Packer15();
    packers[16] = new Packer16();
    packers[17] = new Packer17();
    packers[18] = new Packer18();
    packers[19] = new Packer19();
    packers[20] = new Packer20();
    packers[21] = new Packer21();
    packers[22] = new Packer22();
    packers[23] = new Packer23();
    packers[24] = new Packer24();
    packers[25] = new Packer25();
    packers[26] = new Packer26();
    packers[27] = new Packer27();
    packers[28] = new Packer28();
    packers[29] = new Packer29();
    packers[30] = new Packer30();
    packers[31] = new Packer31();
    packers[32] = new Packer32();
    packers[33] = new Packer33();
    packers[34] = new Packer34();
    packers[35] = new Packer35();
    packers[36] = new Packer36();
    packers[37] = new Packer37();
    packers[38] = new Packer38();
    packers[39] = new Packer39();
    packers[40] = new Packer40();
    packers[41] = new Packer41();
    packers[42] = new Packer42();
    packers[43] = new Packer43();
    packers[44] = new Packer44();
    packers[45] = new Packer45();
    packers[46] = new Packer46();
    packers[47] = new Packer47();
    packers[48] = new Packer48();
    packers[49] = new Packer49();
    packers[50] = new Packer50();
    packers[51] = new Packer51();
    packers[52] = new Packer52();
    packers[53] = new Packer53();
    packers[54] = new Packer54();
    packers[55] = new Packer55();
    packers[56] = new Packer56();
    packers[57] = new Packer57();
    packers[58] = new Packer58();
    packers[59] = new Packer59();
    packers[60] = new Packer60();
    packers[61] = new Packer61();
    packers[62] = new Packer62();
    packers[63] = new Packer63();
    packers[64] = new Packer64();
  }

  public static final BytePackerForLongFactory factory = new BytePackerForLongFactory() {
    public BytePackerForLong newBytePackerForLong(int bitWidth) {
      return packers[bitWidth];
    }
  };

  private static final class Packer0 extends BytePackerForLong {

    private Packer0() {
      super(0);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
    }
  }

  private static final class Packer1 extends BytePackerForLong {

    private Packer1() {
      super(1);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //           [7_______]
          //           [0]
           ((in[ 0 + inPos] & 1L) <<  7)
        | //           [_6______]
          //            [0]
           ((in[ 1 + inPos] & 1L) <<  6)
        | //           [__5_____]
          //             [0]
           ((in[ 2 + inPos] & 1L) <<  5)
        | //           [___4____]
          //              [0]
           ((in[ 3 + inPos] & 1L) <<  4)
        | //           [____3___]
          //               [0]
           ((in[ 4 + inPos] & 1L) <<  3)
        | //           [_____2__]
          //                [0]
           ((in[ 5 + inPos] & 1L) <<  2)
        | //           [______1_]
          //                 [0]
           ((in[ 6 + inPos] & 1L) <<  1)
        | //           [_______0]
          //                  [0]
           ((in[ 7 + inPos] & 1L))) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //           [7_______]
          //           [0]
           ((in[ 0 + inPos] & 1L) <<  7)
        | //           [_6______]
          //            [0]
           ((in[ 1 + inPos] & 1L) <<  6)
        | //           [__5_____]
          //             [0]
           ((in[ 2 + inPos] & 1L) <<  5)
        | //           [___4____]
          //              [0]
           ((in[ 3 + inPos] & 1L) <<  4)
        | //           [____3___]
          //               [0]
           ((in[ 4 + inPos] & 1L) <<  3)
        | //           [_____2__]
          //                [0]
           ((in[ 5 + inPos] & 1L) <<  2)
        | //           [______1_]
          //                 [0]
           ((in[ 6 + inPos] & 1L) <<  1)
        | //           [_______0]
          //                  [0]
           ((in[ 7 + inPos] & 1L))) & 255);
      out[ 1 + outPos] = (byte)((
          //           [7_______]
          //           [0]
           ((in[ 8 + inPos] & 1L) <<  7)
        | //           [_6______]
          //            [0]
           ((in[ 9 + inPos] & 1L) <<  6)
        | //           [__5_____]
          //             [0]
           ((in[10 + inPos] & 1L) <<  5)
        | //           [___4____]
          //              [0]
           ((in[11 + inPos] & 1L) <<  4)
        | //           [____3___]
          //               [0]
           ((in[12 + inPos] & 1L) <<  3)
        | //           [_____2__]
          //                [0]
           ((in[13 + inPos] & 1L) <<  2)
        | //           [______1_]
          //                 [0]
           ((in[14 + inPos] & 1L) <<  1)
        | //           [_______0]
          //                  [0]
           ((in[15 + inPos] & 1L))) & 255);
      out[ 2 + outPos] = (byte)((
          //           [7_______]
          //           [0]
           ((in[16 + inPos] & 1L) <<  7)
        | //           [_6______]
          //            [0]
           ((in[17 + inPos] & 1L) <<  6)
        | //           [__5_____]
          //             [0]
           ((in[18 + inPos] & 1L) <<  5)
        | //           [___4____]
          //              [0]
           ((in[19 + inPos] & 1L) <<  4)
        | //           [____3___]
          //               [0]
           ((in[20 + inPos] & 1L) <<  3)
        | //           [_____2__]
          //                [0]
           ((in[21 + inPos] & 1L) <<  2)
        | //           [______1_]
          //                 [0]
           ((in[22 + inPos] & 1L) <<  1)
        | //           [_______0]
          //                  [0]
           ((in[23 + inPos] & 1L))) & 255);
      out[ 3 + outPos] = (byte)((
          //           [7_______]
          //           [0]
           ((in[24 + inPos] & 1L) <<  7)
        | //           [_6______]
          //            [0]
           ((in[25 + inPos] & 1L) <<  6)
        | //           [__5_____]
          //             [0]
           ((in[26 + inPos] & 1L) <<  5)
        | //           [___4____]
          //              [0]
           ((in[27 + inPos] & 1L) <<  4)
        | //           [____3___]
          //               [0]
           ((in[28 + inPos] & 1L) <<  3)
        | //           [_____2__]
          //                [0]
           ((in[29 + inPos] & 1L) <<  2)
        | //           [______1_]
          //                 [0]
           ((in[30 + inPos] & 1L) <<  1)
        | //           [_______0]
          //                  [0]
           ((in[31 + inPos] & 1L))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //           [7_______]
          //           [0]
            ((((long)in[ 0 + inPos]) >>  7) & 1L);
      out[ 1 + outPos] =
          //           [_6______]
          //            [0]
            ((((long)in[ 0 + inPos]) >>  6) & 1L);
      out[ 2 + outPos] =
          //           [__5_____]
          //             [0]
            ((((long)in[ 0 + inPos]) >>  5) & 1L);
      out[ 3 + outPos] =
          //           [___4____]
          //              [0]
            ((((long)in[ 0 + inPos]) >>  4) & 1L);
      out[ 4 + outPos] =
          //           [____3___]
          //               [0]
            ((((long)in[ 0 + inPos]) >>  3) & 1L);
      out[ 5 + outPos] =
          //           [_____2__]
          //                [0]
            ((((long)in[ 0 + inPos]) >>  2) & 1L);
      out[ 6 + outPos] =
          //           [______1_]
          //                 [0]
            ((((long)in[ 0 + inPos]) >>  1) & 1L);
      out[ 7 + outPos] =
          //           [_______0]
          //                  [0]
            ((((long)in[ 0 + inPos]) ) & 1L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //           [7_______]
          //           [0]
            ((((long)in.get( 0 + inPos)) >>  7) & 1L);
      out[ 1 + outPos] =
          //           [_6______]
          //            [0]
            ((((long)in.get( 0 + inPos)) >>  6) & 1L);
      out[ 2 + outPos] =
          //           [__5_____]
          //             [0]
            ((((long)in.get( 0 + inPos)) >>  5) & 1L);
      out[ 3 + outPos] =
          //           [___4____]
          //              [0]
            ((((long)in.get( 0 + inPos)) >>  4) & 1L);
      out[ 4 + outPos] =
          //           [____3___]
          //               [0]
            ((((long)in.get( 0 + inPos)) >>  3) & 1L);
      out[ 5 + outPos] =
          //           [_____2__]
          //                [0]
            ((((long)in.get( 0 + inPos)) >>  2) & 1L);
      out[ 6 + outPos] =
          //           [______1_]
          //                 [0]
            ((((long)in.get( 0 + inPos)) >>  1) & 1L);
      out[ 7 + outPos] =
          //           [_______0]
          //                  [0]
            ((((long)in.get( 0 + inPos)) ) & 1L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //           [7_______]
          //           [0]
            ((((long)in[ 0 + inPos]) >>  7) & 1L);
      out[ 1 + outPos] =
          //           [_6______]
          //            [0]
            ((((long)in[ 0 + inPos]) >>  6) & 1L);
      out[ 2 + outPos] =
          //           [__5_____]
          //             [0]
            ((((long)in[ 0 + inPos]) >>  5) & 1L);
      out[ 3 + outPos] =
          //           [___4____]
          //              [0]
            ((((long)in[ 0 + inPos]) >>  4) & 1L);
      out[ 4 + outPos] =
          //           [____3___]
          //               [0]
            ((((long)in[ 0 + inPos]) >>  3) & 1L);
      out[ 5 + outPos] =
          //           [_____2__]
          //                [0]
            ((((long)in[ 0 + inPos]) >>  2) & 1L);
      out[ 6 + outPos] =
          //           [______1_]
          //                 [0]
            ((((long)in[ 0 + inPos]) >>  1) & 1L);
      out[ 7 + outPos] =
          //           [_______0]
          //                  [0]
            ((((long)in[ 0 + inPos]) ) & 1L);
      out[ 8 + outPos] =
          //           [7_______]
          //           [0]
            ((((long)in[ 1 + inPos]) >>  7) & 1L);
      out[ 9 + outPos] =
          //           [_6______]
          //            [0]
            ((((long)in[ 1 + inPos]) >>  6) & 1L);
      out[10 + outPos] =
          //           [__5_____]
          //             [0]
            ((((long)in[ 1 + inPos]) >>  5) & 1L);
      out[11 + outPos] =
          //           [___4____]
          //              [0]
            ((((long)in[ 1 + inPos]) >>  4) & 1L);
      out[12 + outPos] =
          //           [____3___]
          //               [0]
            ((((long)in[ 1 + inPos]) >>  3) & 1L);
      out[13 + outPos] =
          //           [_____2__]
          //                [0]
            ((((long)in[ 1 + inPos]) >>  2) & 1L);
      out[14 + outPos] =
          //           [______1_]
          //                 [0]
            ((((long)in[ 1 + inPos]) >>  1) & 1L);
      out[15 + outPos] =
          //           [_______0]
          //                  [0]
            ((((long)in[ 1 + inPos]) ) & 1L);
      out[16 + outPos] =
          //           [7_______]
          //           [0]
            ((((long)in[ 2 + inPos]) >>  7) & 1L);
      out[17 + outPos] =
          //           [_6______]
          //            [0]
            ((((long)in[ 2 + inPos]) >>  6) & 1L);
      out[18 + outPos] =
          //           [__5_____]
          //             [0]
            ((((long)in[ 2 + inPos]) >>  5) & 1L);
      out[19 + outPos] =
          //           [___4____]
          //              [0]
            ((((long)in[ 2 + inPos]) >>  4) & 1L);
      out[20 + outPos] =
          //           [____3___]
          //               [0]
            ((((long)in[ 2 + inPos]) >>  3) & 1L);
      out[21 + outPos] =
          //           [_____2__]
          //                [0]
            ((((long)in[ 2 + inPos]) >>  2) & 1L);
      out[22 + outPos] =
          //           [______1_]
          //                 [0]
            ((((long)in[ 2 + inPos]) >>  1) & 1L);
      out[23 + outPos] =
          //           [_______0]
          //                  [0]
            ((((long)in[ 2 + inPos]) ) & 1L);
      out[24 + outPos] =
          //           [7_______]
          //           [0]
            ((((long)in[ 3 + inPos]) >>  7) & 1L);
      out[25 + outPos] =
          //           [_6______]
          //            [0]
            ((((long)in[ 3 + inPos]) >>  6) & 1L);
      out[26 + outPos] =
          //           [__5_____]
          //             [0]
            ((((long)in[ 3 + inPos]) >>  5) & 1L);
      out[27 + outPos] =
          //           [___4____]
          //              [0]
            ((((long)in[ 3 + inPos]) >>  4) & 1L);
      out[28 + outPos] =
          //           [____3___]
          //               [0]
            ((((long)in[ 3 + inPos]) >>  3) & 1L);
      out[29 + outPos] =
          //           [_____2__]
          //                [0]
            ((((long)in[ 3 + inPos]) >>  2) & 1L);
      out[30 + outPos] =
          //           [______1_]
          //                 [0]
            ((((long)in[ 3 + inPos]) >>  1) & 1L);
      out[31 + outPos] =
          //           [_______0]
          //                  [0]
            ((((long)in[ 3 + inPos]) ) & 1L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //           [7_______]
          //           [0]
            ((((long)in.get( 0 + inPos)) >>  7) & 1L);
      out[ 1 + outPos] =
          //           [_6______]
          //            [0]
            ((((long)in.get( 0 + inPos)) >>  6) & 1L);
      out[ 2 + outPos] =
          //           [__5_____]
          //             [0]
            ((((long)in.get( 0 + inPos)) >>  5) & 1L);
      out[ 3 + outPos] =
          //           [___4____]
          //              [0]
            ((((long)in.get( 0 + inPos)) >>  4) & 1L);
      out[ 4 + outPos] =
          //           [____3___]
          //               [0]
            ((((long)in.get( 0 + inPos)) >>  3) & 1L);
      out[ 5 + outPos] =
          //           [_____2__]
          //                [0]
            ((((long)in.get( 0 + inPos)) >>  2) & 1L);
      out[ 6 + outPos] =
          //           [______1_]
          //                 [0]
            ((((long)in.get( 0 + inPos)) >>  1) & 1L);
      out[ 7 + outPos] =
          //           [_______0]
          //                  [0]
            ((((long)in.get( 0 + inPos)) ) & 1L);
      out[ 8 + outPos] =
          //           [7_______]
          //           [0]
            ((((long)in.get( 1 + inPos)) >>  7) & 1L);
      out[ 9 + outPos] =
          //           [_6______]
          //            [0]
            ((((long)in.get( 1 + inPos)) >>  6) & 1L);
      out[10 + outPos] =
          //           [__5_____]
          //             [0]
            ((((long)in.get( 1 + inPos)) >>  5) & 1L);
      out[11 + outPos] =
          //           [___4____]
          //              [0]
            ((((long)in.get( 1 + inPos)) >>  4) & 1L);
      out[12 + outPos] =
          //           [____3___]
          //               [0]
            ((((long)in.get( 1 + inPos)) >>  3) & 1L);
      out[13 + outPos] =
          //           [_____2__]
          //                [0]
            ((((long)in.get( 1 + inPos)) >>  2) & 1L);
      out[14 + outPos] =
          //           [______1_]
          //                 [0]
            ((((long)in.get( 1 + inPos)) >>  1) & 1L);
      out[15 + outPos] =
          //           [_______0]
          //                  [0]
            ((((long)in.get( 1 + inPos)) ) & 1L);
      out[16 + outPos] =
          //           [7_______]
          //           [0]
            ((((long)in.get( 2 + inPos)) >>  7) & 1L);
      out[17 + outPos] =
          //           [_6______]
          //            [0]
            ((((long)in.get( 2 + inPos)) >>  6) & 1L);
      out[18 + outPos] =
          //           [__5_____]
          //             [0]
            ((((long)in.get( 2 + inPos)) >>  5) & 1L);
      out[19 + outPos] =
          //           [___4____]
          //              [0]
            ((((long)in.get( 2 + inPos)) >>  4) & 1L);
      out[20 + outPos] =
          //           [____3___]
          //               [0]
            ((((long)in.get( 2 + inPos)) >>  3) & 1L);
      out[21 + outPos] =
          //           [_____2__]
          //                [0]
            ((((long)in.get( 2 + inPos)) >>  2) & 1L);
      out[22 + outPos] =
          //           [______1_]
          //                 [0]
            ((((long)in.get( 2 + inPos)) >>  1) & 1L);
      out[23 + outPos] =
          //           [_______0]
          //                  [0]
            ((((long)in.get( 2 + inPos)) ) & 1L);
      out[24 + outPos] =
          //           [7_______]
          //           [0]
            ((((long)in.get( 3 + inPos)) >>  7) & 1L);
      out[25 + outPos] =
          //           [_6______]
          //            [0]
            ((((long)in.get( 3 + inPos)) >>  6) & 1L);
      out[26 + outPos] =
          //           [__5_____]
          //             [0]
            ((((long)in.get( 3 + inPos)) >>  5) & 1L);
      out[27 + outPos] =
          //           [___4____]
          //              [0]
            ((((long)in.get( 3 + inPos)) >>  4) & 1L);
      out[28 + outPos] =
          //           [____3___]
          //               [0]
            ((((long)in.get( 3 + inPos)) >>  3) & 1L);
      out[29 + outPos] =
          //           [_____2__]
          //                [0]
            ((((long)in.get( 3 + inPos)) >>  2) & 1L);
      out[30 + outPos] =
          //           [______1_]
          //                 [0]
            ((((long)in.get( 3 + inPos)) >>  1) & 1L);
      out[31 + outPos] =
          //           [_______0]
          //                  [0]
            ((((long)in.get( 3 + inPos)) ) & 1L);
    }
  }

  private static final class Packer2 extends BytePackerForLong {

    private Packer2() {
      super(2);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //            [76______]
          //            [10]
           ((in[ 0 + inPos] & 3L) <<  6)
        | //            [__54____]
          //              [10]
           ((in[ 1 + inPos] & 3L) <<  4)
        | //            [____32__]
          //                [10]
           ((in[ 2 + inPos] & 3L) <<  2)
        | //            [______10]
          //                  [10]
           ((in[ 3 + inPos] & 3L))) & 255);
      out[ 1 + outPos] = (byte)((
          //            [76______]
          //            [10]
           ((in[ 4 + inPos] & 3L) <<  6)
        | //            [__54____]
          //              [10]
           ((in[ 5 + inPos] & 3L) <<  4)
        | //            [____32__]
          //                [10]
           ((in[ 6 + inPos] & 3L) <<  2)
        | //            [______10]
          //                  [10]
           ((in[ 7 + inPos] & 3L))) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //            [76______]
          //            [10]
           ((in[ 0 + inPos] & 3L) <<  6)
        | //            [__54____]
          //              [10]
           ((in[ 1 + inPos] & 3L) <<  4)
        | //            [____32__]
          //                [10]
           ((in[ 2 + inPos] & 3L) <<  2)
        | //            [______10]
          //                  [10]
           ((in[ 3 + inPos] & 3L))) & 255);
      out[ 1 + outPos] = (byte)((
          //            [76______]
          //            [10]
           ((in[ 4 + inPos] & 3L) <<  6)
        | //            [__54____]
          //              [10]
           ((in[ 5 + inPos] & 3L) <<  4)
        | //            [____32__]
          //                [10]
           ((in[ 6 + inPos] & 3L) <<  2)
        | //            [______10]
          //                  [10]
           ((in[ 7 + inPos] & 3L))) & 255);
      out[ 2 + outPos] = (byte)((
          //            [76______]
          //            [10]
           ((in[ 8 + inPos] & 3L) <<  6)
        | //            [__54____]
          //              [10]
           ((in[ 9 + inPos] & 3L) <<  4)
        | //            [____32__]
          //                [10]
           ((in[10 + inPos] & 3L) <<  2)
        | //            [______10]
          //                  [10]
           ((in[11 + inPos] & 3L))) & 255);
      out[ 3 + outPos] = (byte)((
          //            [76______]
          //            [10]
           ((in[12 + inPos] & 3L) <<  6)
        | //            [__54____]
          //              [10]
           ((in[13 + inPos] & 3L) <<  4)
        | //            [____32__]
          //                [10]
           ((in[14 + inPos] & 3L) <<  2)
        | //            [______10]
          //                  [10]
           ((in[15 + inPos] & 3L))) & 255);
      out[ 4 + outPos] = (byte)((
          //            [76______]
          //            [10]
           ((in[16 + inPos] & 3L) <<  6)
        | //            [__54____]
          //              [10]
           ((in[17 + inPos] & 3L) <<  4)
        | //            [____32__]
          //                [10]
           ((in[18 + inPos] & 3L) <<  2)
        | //            [______10]
          //                  [10]
           ((in[19 + inPos] & 3L))) & 255);
      out[ 5 + outPos] = (byte)((
          //            [76______]
          //            [10]
           ((in[20 + inPos] & 3L) <<  6)
        | //            [__54____]
          //              [10]
           ((in[21 + inPos] & 3L) <<  4)
        | //            [____32__]
          //                [10]
           ((in[22 + inPos] & 3L) <<  2)
        | //            [______10]
          //                  [10]
           ((in[23 + inPos] & 3L))) & 255);
      out[ 6 + outPos] = (byte)((
          //            [76______]
          //            [10]
           ((in[24 + inPos] & 3L) <<  6)
        | //            [__54____]
          //              [10]
           ((in[25 + inPos] & 3L) <<  4)
        | //            [____32__]
          //                [10]
           ((in[26 + inPos] & 3L) <<  2)
        | //            [______10]
          //                  [10]
           ((in[27 + inPos] & 3L))) & 255);
      out[ 7 + outPos] = (byte)((
          //            [76______]
          //            [10]
           ((in[28 + inPos] & 3L) <<  6)
        | //            [__54____]
          //              [10]
           ((in[29 + inPos] & 3L) <<  4)
        | //            [____32__]
          //                [10]
           ((in[30 + inPos] & 3L) <<  2)
        | //            [______10]
          //                  [10]
           ((in[31 + inPos] & 3L))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in[ 0 + inPos]) >>  6) & 3L);
      out[ 1 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in[ 0 + inPos]) >>  4) & 3L);
      out[ 2 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in[ 0 + inPos]) >>  2) & 3L);
      out[ 3 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in[ 0 + inPos]) ) & 3L);
      out[ 4 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in[ 1 + inPos]) >>  6) & 3L);
      out[ 5 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in[ 1 + inPos]) >>  4) & 3L);
      out[ 6 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in[ 1 + inPos]) >>  2) & 3L);
      out[ 7 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in[ 1 + inPos]) ) & 3L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in.get( 0 + inPos)) >>  6) & 3L);
      out[ 1 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in.get( 0 + inPos)) >>  4) & 3L);
      out[ 2 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in.get( 0 + inPos)) >>  2) & 3L);
      out[ 3 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in.get( 0 + inPos)) ) & 3L);
      out[ 4 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in.get( 1 + inPos)) >>  6) & 3L);
      out[ 5 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in.get( 1 + inPos)) >>  4) & 3L);
      out[ 6 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in.get( 1 + inPos)) >>  2) & 3L);
      out[ 7 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in.get( 1 + inPos)) ) & 3L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in[ 0 + inPos]) >>  6) & 3L);
      out[ 1 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in[ 0 + inPos]) >>  4) & 3L);
      out[ 2 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in[ 0 + inPos]) >>  2) & 3L);
      out[ 3 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in[ 0 + inPos]) ) & 3L);
      out[ 4 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in[ 1 + inPos]) >>  6) & 3L);
      out[ 5 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in[ 1 + inPos]) >>  4) & 3L);
      out[ 6 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in[ 1 + inPos]) >>  2) & 3L);
      out[ 7 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in[ 1 + inPos]) ) & 3L);
      out[ 8 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in[ 2 + inPos]) >>  6) & 3L);
      out[ 9 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in[ 2 + inPos]) >>  4) & 3L);
      out[10 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in[ 2 + inPos]) >>  2) & 3L);
      out[11 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in[ 2 + inPos]) ) & 3L);
      out[12 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in[ 3 + inPos]) >>  6) & 3L);
      out[13 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in[ 3 + inPos]) >>  4) & 3L);
      out[14 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in[ 3 + inPos]) >>  2) & 3L);
      out[15 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in[ 3 + inPos]) ) & 3L);
      out[16 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in[ 4 + inPos]) >>  6) & 3L);
      out[17 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in[ 4 + inPos]) >>  4) & 3L);
      out[18 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in[ 4 + inPos]) >>  2) & 3L);
      out[19 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in[ 4 + inPos]) ) & 3L);
      out[20 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in[ 5 + inPos]) >>  6) & 3L);
      out[21 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in[ 5 + inPos]) >>  4) & 3L);
      out[22 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in[ 5 + inPos]) >>  2) & 3L);
      out[23 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in[ 5 + inPos]) ) & 3L);
      out[24 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in[ 6 + inPos]) >>  6) & 3L);
      out[25 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in[ 6 + inPos]) >>  4) & 3L);
      out[26 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in[ 6 + inPos]) >>  2) & 3L);
      out[27 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in[ 6 + inPos]) ) & 3L);
      out[28 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in[ 7 + inPos]) >>  6) & 3L);
      out[29 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in[ 7 + inPos]) >>  4) & 3L);
      out[30 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in[ 7 + inPos]) >>  2) & 3L);
      out[31 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in[ 7 + inPos]) ) & 3L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in.get( 0 + inPos)) >>  6) & 3L);
      out[ 1 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in.get( 0 + inPos)) >>  4) & 3L);
      out[ 2 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in.get( 0 + inPos)) >>  2) & 3L);
      out[ 3 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in.get( 0 + inPos)) ) & 3L);
      out[ 4 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in.get( 1 + inPos)) >>  6) & 3L);
      out[ 5 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in.get( 1 + inPos)) >>  4) & 3L);
      out[ 6 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in.get( 1 + inPos)) >>  2) & 3L);
      out[ 7 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in.get( 1 + inPos)) ) & 3L);
      out[ 8 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in.get( 2 + inPos)) >>  6) & 3L);
      out[ 9 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in.get( 2 + inPos)) >>  4) & 3L);
      out[10 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in.get( 2 + inPos)) >>  2) & 3L);
      out[11 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in.get( 2 + inPos)) ) & 3L);
      out[12 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in.get( 3 + inPos)) >>  6) & 3L);
      out[13 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in.get( 3 + inPos)) >>  4) & 3L);
      out[14 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in.get( 3 + inPos)) >>  2) & 3L);
      out[15 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in.get( 3 + inPos)) ) & 3L);
      out[16 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in.get( 4 + inPos)) >>  6) & 3L);
      out[17 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in.get( 4 + inPos)) >>  4) & 3L);
      out[18 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in.get( 4 + inPos)) >>  2) & 3L);
      out[19 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in.get( 4 + inPos)) ) & 3L);
      out[20 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in.get( 5 + inPos)) >>  6) & 3L);
      out[21 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in.get( 5 + inPos)) >>  4) & 3L);
      out[22 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in.get( 5 + inPos)) >>  2) & 3L);
      out[23 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in.get( 5 + inPos)) ) & 3L);
      out[24 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in.get( 6 + inPos)) >>  6) & 3L);
      out[25 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in.get( 6 + inPos)) >>  4) & 3L);
      out[26 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in.get( 6 + inPos)) >>  2) & 3L);
      out[27 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in.get( 6 + inPos)) ) & 3L);
      out[28 + outPos] =
          //            [76______]
          //            [10]
            ((((long)in.get( 7 + inPos)) >>  6) & 3L);
      out[29 + outPos] =
          //            [__54____]
          //              [10]
            ((((long)in.get( 7 + inPos)) >>  4) & 3L);
      out[30 + outPos] =
          //            [____32__]
          //                [10]
            ((((long)in.get( 7 + inPos)) >>  2) & 3L);
      out[31 + outPos] =
          //            [______10]
          //                  [10]
            ((((long)in.get( 7 + inPos)) ) & 3L);
    }
  }

  private static final class Packer3 extends BytePackerForLong {

    private Packer3() {
      super(3);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //             [765_____]
          //             [210]
           ((in[ 0 + inPos] & 7L) <<  5)
        | //             [___432__]
          //                [210]
           ((in[ 1 + inPos] & 7L) <<  2)
        | //             [______10]
          //                   [21_]
           ((in[ 2 + inPos] & 7L) >>> 1)) & 255);
      out[ 1 + outPos] = (byte)((
          //             [7_______]
          //           [__0]
           ((in[ 2 + inPos] & 7L) <<  7)
        | //             [_654____]
          //              [210]
           ((in[ 3 + inPos] & 7L) <<  4)
        | //             [____321_]
          //                 [210]
           ((in[ 4 + inPos] & 7L) <<  1)
        | //             [_______0]
          //                    [2__]
           ((in[ 5 + inPos] & 7L) >>> 2)) & 255);
      out[ 2 + outPos] = (byte)((
          //             [76______]
          //            [_10]
           ((in[ 5 + inPos] & 7L) <<  6)
        | //             [__543___]
          //               [210]
           ((in[ 6 + inPos] & 7L) <<  3)
        | //             [_____210]
          //                  [210]
           ((in[ 7 + inPos] & 7L))) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //             [765_____]
          //             [210]
           ((in[ 0 + inPos] & 7L) <<  5)
        | //             [___432__]
          //                [210]
           ((in[ 1 + inPos] & 7L) <<  2)
        | //             [______10]
          //                   [21_]
           ((in[ 2 + inPos] & 7L) >>> 1)) & 255);
      out[ 1 + outPos] = (byte)((
          //             [7_______]
          //           [__0]
           ((in[ 2 + inPos] & 7L) <<  7)
        | //             [_654____]
          //              [210]
           ((in[ 3 + inPos] & 7L) <<  4)
        | //             [____321_]
          //                 [210]
           ((in[ 4 + inPos] & 7L) <<  1)
        | //             [_______0]
          //                    [2__]
           ((in[ 5 + inPos] & 7L) >>> 2)) & 255);
      out[ 2 + outPos] = (byte)((
          //             [76______]
          //            [_10]
           ((in[ 5 + inPos] & 7L) <<  6)
        | //             [__543___]
          //               [210]
           ((in[ 6 + inPos] & 7L) <<  3)
        | //             [_____210]
          //                  [210]
           ((in[ 7 + inPos] & 7L))) & 255);
      out[ 3 + outPos] = (byte)((
          //             [765_____]
          //             [210]
           ((in[ 8 + inPos] & 7L) <<  5)
        | //             [___432__]
          //                [210]
           ((in[ 9 + inPos] & 7L) <<  2)
        | //             [______10]
          //                   [21_]
           ((in[10 + inPos] & 7L) >>> 1)) & 255);
      out[ 4 + outPos] = (byte)((
          //             [7_______]
          //           [__0]
           ((in[10 + inPos] & 7L) <<  7)
        | //             [_654____]
          //              [210]
           ((in[11 + inPos] & 7L) <<  4)
        | //             [____321_]
          //                 [210]
           ((in[12 + inPos] & 7L) <<  1)
        | //             [_______0]
          //                    [2__]
           ((in[13 + inPos] & 7L) >>> 2)) & 255);
      out[ 5 + outPos] = (byte)((
          //             [76______]
          //            [_10]
           ((in[13 + inPos] & 7L) <<  6)
        | //             [__543___]
          //               [210]
           ((in[14 + inPos] & 7L) <<  3)
        | //             [_____210]
          //                  [210]
           ((in[15 + inPos] & 7L))) & 255);
      out[ 6 + outPos] = (byte)((
          //             [765_____]
          //             [210]
           ((in[16 + inPos] & 7L) <<  5)
        | //             [___432__]
          //                [210]
           ((in[17 + inPos] & 7L) <<  2)
        | //             [______10]
          //                   [21_]
           ((in[18 + inPos] & 7L) >>> 1)) & 255);
      out[ 7 + outPos] = (byte)((
          //             [7_______]
          //           [__0]
           ((in[18 + inPos] & 7L) <<  7)
        | //             [_654____]
          //              [210]
           ((in[19 + inPos] & 7L) <<  4)
        | //             [____321_]
          //                 [210]
           ((in[20 + inPos] & 7L) <<  1)
        | //             [_______0]
          //                    [2__]
           ((in[21 + inPos] & 7L) >>> 2)) & 255);
      out[ 8 + outPos] = (byte)((
          //             [76______]
          //            [_10]
           ((in[21 + inPos] & 7L) <<  6)
        | //             [__543___]
          //               [210]
           ((in[22 + inPos] & 7L) <<  3)
        | //             [_____210]
          //                  [210]
           ((in[23 + inPos] & 7L))) & 255);
      out[ 9 + outPos] = (byte)((
          //             [765_____]
          //             [210]
           ((in[24 + inPos] & 7L) <<  5)
        | //             [___432__]
          //                [210]
           ((in[25 + inPos] & 7L) <<  2)
        | //             [______10]
          //                   [21_]
           ((in[26 + inPos] & 7L) >>> 1)) & 255);
      out[10 + outPos] = (byte)((
          //             [7_______]
          //           [__0]
           ((in[26 + inPos] & 7L) <<  7)
        | //             [_654____]
          //              [210]
           ((in[27 + inPos] & 7L) <<  4)
        | //             [____321_]
          //                 [210]
           ((in[28 + inPos] & 7L) <<  1)
        | //             [_______0]
          //                    [2__]
           ((in[29 + inPos] & 7L) >>> 2)) & 255);
      out[11 + outPos] = (byte)((
          //             [76______]
          //            [_10]
           ((in[29 + inPos] & 7L) <<  6)
        | //             [__543___]
          //               [210]
           ((in[30 + inPos] & 7L) <<  3)
        | //             [_____210]
          //                  [210]
           ((in[31 + inPos] & 7L))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //             [765_____]
          //             [210]
            ((((long)in[ 0 + inPos]) >>  5) & 7L);
      out[ 1 + outPos] =
          //             [___432__]
          //                [210]
            ((((long)in[ 0 + inPos]) >>  2) & 7L);
      out[ 2 + outPos] =
          //             [______10]
          //                   [21_]
            ((((long)in[ 0 + inPos]) <<  1) & 7L)
        | //             [7_______]
          //           [__0]
            ((((long)in[ 1 + inPos]) >>  7) & 1L);
      out[ 3 + outPos] =
          //             [_654____]
          //              [210]
            ((((long)in[ 1 + inPos]) >>  4) & 7L);
      out[ 4 + outPos] =
          //             [____321_]
          //                 [210]
            ((((long)in[ 1 + inPos]) >>  1) & 7L);
      out[ 5 + outPos] =
          //             [_______0]
          //                    [2__]
            ((((long)in[ 1 + inPos]) <<  2) & 7L)
        | //             [76______]
          //            [_10]
            ((((long)in[ 2 + inPos]) >>  6) & 3L);
      out[ 6 + outPos] =
          //             [__543___]
          //               [210]
            ((((long)in[ 2 + inPos]) >>  3) & 7L);
      out[ 7 + outPos] =
          //             [_____210]
          //                  [210]
            ((((long)in[ 2 + inPos]) ) & 7L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //             [765_____]
          //             [210]
            ((((long)in.get( 0 + inPos)) >>  5) & 7L);
      out[ 1 + outPos] =
          //             [___432__]
          //                [210]
            ((((long)in.get( 0 + inPos)) >>  2) & 7L);
      out[ 2 + outPos] =
          //             [______10]
          //                   [21_]
            ((((long)in.get( 0 + inPos)) <<  1) & 7L)
        | //             [7_______]
          //           [__0]
            ((((long)in.get( 1 + inPos)) >>  7) & 1L);
      out[ 3 + outPos] =
          //             [_654____]
          //              [210]
            ((((long)in.get( 1 + inPos)) >>  4) & 7L);
      out[ 4 + outPos] =
          //             [____321_]
          //                 [210]
            ((((long)in.get( 1 + inPos)) >>  1) & 7L);
      out[ 5 + outPos] =
          //             [_______0]
          //                    [2__]
            ((((long)in.get( 1 + inPos)) <<  2) & 7L)
        | //             [76______]
          //            [_10]
            ((((long)in.get( 2 + inPos)) >>  6) & 3L);
      out[ 6 + outPos] =
          //             [__543___]
          //               [210]
            ((((long)in.get( 2 + inPos)) >>  3) & 7L);
      out[ 7 + outPos] =
          //             [_____210]
          //                  [210]
            ((((long)in.get( 2 + inPos)) ) & 7L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //             [765_____]
          //             [210]
            ((((long)in[ 0 + inPos]) >>  5) & 7L);
      out[ 1 + outPos] =
          //             [___432__]
          //                [210]
            ((((long)in[ 0 + inPos]) >>  2) & 7L);
      out[ 2 + outPos] =
          //             [______10]
          //                   [21_]
            ((((long)in[ 0 + inPos]) <<  1) & 7L)
        | //             [7_______]
          //           [__0]
            ((((long)in[ 1 + inPos]) >>  7) & 1L);
      out[ 3 + outPos] =
          //             [_654____]
          //              [210]
            ((((long)in[ 1 + inPos]) >>  4) & 7L);
      out[ 4 + outPos] =
          //             [____321_]
          //                 [210]
            ((((long)in[ 1 + inPos]) >>  1) & 7L);
      out[ 5 + outPos] =
          //             [_______0]
          //                    [2__]
            ((((long)in[ 1 + inPos]) <<  2) & 7L)
        | //             [76______]
          //            [_10]
            ((((long)in[ 2 + inPos]) >>  6) & 3L);
      out[ 6 + outPos] =
          //             [__543___]
          //               [210]
            ((((long)in[ 2 + inPos]) >>  3) & 7L);
      out[ 7 + outPos] =
          //             [_____210]
          //                  [210]
            ((((long)in[ 2 + inPos]) ) & 7L);
      out[ 8 + outPos] =
          //             [765_____]
          //             [210]
            ((((long)in[ 3 + inPos]) >>  5) & 7L);
      out[ 9 + outPos] =
          //             [___432__]
          //                [210]
            ((((long)in[ 3 + inPos]) >>  2) & 7L);
      out[10 + outPos] =
          //             [______10]
          //                   [21_]
            ((((long)in[ 3 + inPos]) <<  1) & 7L)
        | //             [7_______]
          //           [__0]
            ((((long)in[ 4 + inPos]) >>  7) & 1L);
      out[11 + outPos] =
          //             [_654____]
          //              [210]
            ((((long)in[ 4 + inPos]) >>  4) & 7L);
      out[12 + outPos] =
          //             [____321_]
          //                 [210]
            ((((long)in[ 4 + inPos]) >>  1) & 7L);
      out[13 + outPos] =
          //             [_______0]
          //                    [2__]
            ((((long)in[ 4 + inPos]) <<  2) & 7L)
        | //             [76______]
          //            [_10]
            ((((long)in[ 5 + inPos]) >>  6) & 3L);
      out[14 + outPos] =
          //             [__543___]
          //               [210]
            ((((long)in[ 5 + inPos]) >>  3) & 7L);
      out[15 + outPos] =
          //             [_____210]
          //                  [210]
            ((((long)in[ 5 + inPos]) ) & 7L);
      out[16 + outPos] =
          //             [765_____]
          //             [210]
            ((((long)in[ 6 + inPos]) >>  5) & 7L);
      out[17 + outPos] =
          //             [___432__]
          //                [210]
            ((((long)in[ 6 + inPos]) >>  2) & 7L);
      out[18 + outPos] =
          //             [______10]
          //                   [21_]
            ((((long)in[ 6 + inPos]) <<  1) & 7L)
        | //             [7_______]
          //           [__0]
            ((((long)in[ 7 + inPos]) >>  7) & 1L);
      out[19 + outPos] =
          //             [_654____]
          //              [210]
            ((((long)in[ 7 + inPos]) >>  4) & 7L);
      out[20 + outPos] =
          //             [____321_]
          //                 [210]
            ((((long)in[ 7 + inPos]) >>  1) & 7L);
      out[21 + outPos] =
          //             [_______0]
          //                    [2__]
            ((((long)in[ 7 + inPos]) <<  2) & 7L)
        | //             [76______]
          //            [_10]
            ((((long)in[ 8 + inPos]) >>  6) & 3L);
      out[22 + outPos] =
          //             [__543___]
          //               [210]
            ((((long)in[ 8 + inPos]) >>  3) & 7L);
      out[23 + outPos] =
          //             [_____210]
          //                  [210]
            ((((long)in[ 8 + inPos]) ) & 7L);
      out[24 + outPos] =
          //             [765_____]
          //             [210]
            ((((long)in[ 9 + inPos]) >>  5) & 7L);
      out[25 + outPos] =
          //             [___432__]
          //                [210]
            ((((long)in[ 9 + inPos]) >>  2) & 7L);
      out[26 + outPos] =
          //             [______10]
          //                   [21_]
            ((((long)in[ 9 + inPos]) <<  1) & 7L)
        | //             [7_______]
          //           [__0]
            ((((long)in[10 + inPos]) >>  7) & 1L);
      out[27 + outPos] =
          //             [_654____]
          //              [210]
            ((((long)in[10 + inPos]) >>  4) & 7L);
      out[28 + outPos] =
          //             [____321_]
          //                 [210]
            ((((long)in[10 + inPos]) >>  1) & 7L);
      out[29 + outPos] =
          //             [_______0]
          //                    [2__]
            ((((long)in[10 + inPos]) <<  2) & 7L)
        | //             [76______]
          //            [_10]
            ((((long)in[11 + inPos]) >>  6) & 3L);
      out[30 + outPos] =
          //             [__543___]
          //               [210]
            ((((long)in[11 + inPos]) >>  3) & 7L);
      out[31 + outPos] =
          //             [_____210]
          //                  [210]
            ((((long)in[11 + inPos]) ) & 7L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //             [765_____]
          //             [210]
            ((((long)in.get( 0 + inPos)) >>  5) & 7L);
      out[ 1 + outPos] =
          //             [___432__]
          //                [210]
            ((((long)in.get( 0 + inPos)) >>  2) & 7L);
      out[ 2 + outPos] =
          //             [______10]
          //                   [21_]
            ((((long)in.get( 0 + inPos)) <<  1) & 7L)
        | //             [7_______]
          //           [__0]
            ((((long)in.get( 1 + inPos)) >>  7) & 1L);
      out[ 3 + outPos] =
          //             [_654____]
          //              [210]
            ((((long)in.get( 1 + inPos)) >>  4) & 7L);
      out[ 4 + outPos] =
          //             [____321_]
          //                 [210]
            ((((long)in.get( 1 + inPos)) >>  1) & 7L);
      out[ 5 + outPos] =
          //             [_______0]
          //                    [2__]
            ((((long)in.get( 1 + inPos)) <<  2) & 7L)
        | //             [76______]
          //            [_10]
            ((((long)in.get( 2 + inPos)) >>  6) & 3L);
      out[ 6 + outPos] =
          //             [__543___]
          //               [210]
            ((((long)in.get( 2 + inPos)) >>  3) & 7L);
      out[ 7 + outPos] =
          //             [_____210]
          //                  [210]
            ((((long)in.get( 2 + inPos)) ) & 7L);
      out[ 8 + outPos] =
          //             [765_____]
          //             [210]
            ((((long)in.get( 3 + inPos)) >>  5) & 7L);
      out[ 9 + outPos] =
          //             [___432__]
          //                [210]
            ((((long)in.get( 3 + inPos)) >>  2) & 7L);
      out[10 + outPos] =
          //             [______10]
          //                   [21_]
            ((((long)in.get( 3 + inPos)) <<  1) & 7L)
        | //             [7_______]
          //           [__0]
            ((((long)in.get( 4 + inPos)) >>  7) & 1L);
      out[11 + outPos] =
          //             [_654____]
          //              [210]
            ((((long)in.get( 4 + inPos)) >>  4) & 7L);
      out[12 + outPos] =
          //             [____321_]
          //                 [210]
            ((((long)in.get( 4 + inPos)) >>  1) & 7L);
      out[13 + outPos] =
          //             [_______0]
          //                    [2__]
            ((((long)in.get( 4 + inPos)) <<  2) & 7L)
        | //             [76______]
          //            [_10]
            ((((long)in.get( 5 + inPos)) >>  6) & 3L);
      out[14 + outPos] =
          //             [__543___]
          //               [210]
            ((((long)in.get( 5 + inPos)) >>  3) & 7L);
      out[15 + outPos] =
          //             [_____210]
          //                  [210]
            ((((long)in.get( 5 + inPos)) ) & 7L);
      out[16 + outPos] =
          //             [765_____]
          //             [210]
            ((((long)in.get( 6 + inPos)) >>  5) & 7L);
      out[17 + outPos] =
          //             [___432__]
          //                [210]
            ((((long)in.get( 6 + inPos)) >>  2) & 7L);
      out[18 + outPos] =
          //             [______10]
          //                   [21_]
            ((((long)in.get( 6 + inPos)) <<  1) & 7L)
        | //             [7_______]
          //           [__0]
            ((((long)in.get( 7 + inPos)) >>  7) & 1L);
      out[19 + outPos] =
          //             [_654____]
          //              [210]
            ((((long)in.get( 7 + inPos)) >>  4) & 7L);
      out[20 + outPos] =
          //             [____321_]
          //                 [210]
            ((((long)in.get( 7 + inPos)) >>  1) & 7L);
      out[21 + outPos] =
          //             [_______0]
          //                    [2__]
            ((((long)in.get( 7 + inPos)) <<  2) & 7L)
        | //             [76______]
          //            [_10]
            ((((long)in.get( 8 + inPos)) >>  6) & 3L);
      out[22 + outPos] =
          //             [__543___]
          //               [210]
            ((((long)in.get( 8 + inPos)) >>  3) & 7L);
      out[23 + outPos] =
          //             [_____210]
          //                  [210]
            ((((long)in.get( 8 + inPos)) ) & 7L);
      out[24 + outPos] =
          //             [765_____]
          //             [210]
            ((((long)in.get( 9 + inPos)) >>  5) & 7L);
      out[25 + outPos] =
          //             [___432__]
          //                [210]
            ((((long)in.get( 9 + inPos)) >>  2) & 7L);
      out[26 + outPos] =
          //             [______10]
          //                   [21_]
            ((((long)in.get( 9 + inPos)) <<  1) & 7L)
        | //             [7_______]
          //           [__0]
            ((((long)in.get(10 + inPos)) >>  7) & 1L);
      out[27 + outPos] =
          //             [_654____]
          //              [210]
            ((((long)in.get(10 + inPos)) >>  4) & 7L);
      out[28 + outPos] =
          //             [____321_]
          //                 [210]
            ((((long)in.get(10 + inPos)) >>  1) & 7L);
      out[29 + outPos] =
          //             [_______0]
          //                    [2__]
            ((((long)in.get(10 + inPos)) <<  2) & 7L)
        | //             [76______]
          //            [_10]
            ((((long)in.get(11 + inPos)) >>  6) & 3L);
      out[30 + outPos] =
          //             [__543___]
          //               [210]
            ((((long)in.get(11 + inPos)) >>  3) & 7L);
      out[31 + outPos] =
          //             [_____210]
          //                  [210]
            ((((long)in.get(11 + inPos)) ) & 7L);
    }
  }

  private static final class Packer4 extends BytePackerForLong {

    private Packer4() {
      super(4);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[ 0 + inPos] & 15L) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[ 1 + inPos] & 15L))) & 255);
      out[ 1 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[ 2 + inPos] & 15L) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[ 3 + inPos] & 15L))) & 255);
      out[ 2 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[ 4 + inPos] & 15L) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[ 5 + inPos] & 15L))) & 255);
      out[ 3 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[ 6 + inPos] & 15L) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[ 7 + inPos] & 15L))) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[ 0 + inPos] & 15L) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[ 1 + inPos] & 15L))) & 255);
      out[ 1 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[ 2 + inPos] & 15L) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[ 3 + inPos] & 15L))) & 255);
      out[ 2 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[ 4 + inPos] & 15L) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[ 5 + inPos] & 15L))) & 255);
      out[ 3 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[ 6 + inPos] & 15L) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[ 7 + inPos] & 15L))) & 255);
      out[ 4 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[ 8 + inPos] & 15L) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[ 9 + inPos] & 15L))) & 255);
      out[ 5 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[10 + inPos] & 15L) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[11 + inPos] & 15L))) & 255);
      out[ 6 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[12 + inPos] & 15L) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[13 + inPos] & 15L))) & 255);
      out[ 7 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[14 + inPos] & 15L) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[15 + inPos] & 15L))) & 255);
      out[ 8 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[16 + inPos] & 15L) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[17 + inPos] & 15L))) & 255);
      out[ 9 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[18 + inPos] & 15L) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[19 + inPos] & 15L))) & 255);
      out[10 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[20 + inPos] & 15L) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[21 + inPos] & 15L))) & 255);
      out[11 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[22 + inPos] & 15L) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[23 + inPos] & 15L))) & 255);
      out[12 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[24 + inPos] & 15L) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[25 + inPos] & 15L))) & 255);
      out[13 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[26 + inPos] & 15L) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[27 + inPos] & 15L))) & 255);
      out[14 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[28 + inPos] & 15L) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[29 + inPos] & 15L))) & 255);
      out[15 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[30 + inPos] & 15L) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[31 + inPos] & 15L))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[ 0 + inPos]) >>  4) & 15L);
      out[ 1 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[ 0 + inPos]) ) & 15L);
      out[ 2 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[ 1 + inPos]) >>  4) & 15L);
      out[ 3 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[ 1 + inPos]) ) & 15L);
      out[ 4 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[ 2 + inPos]) >>  4) & 15L);
      out[ 5 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[ 2 + inPos]) ) & 15L);
      out[ 6 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[ 3 + inPos]) >>  4) & 15L);
      out[ 7 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[ 3 + inPos]) ) & 15L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get( 0 + inPos)) >>  4) & 15L);
      out[ 1 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get( 0 + inPos)) ) & 15L);
      out[ 2 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get( 1 + inPos)) >>  4) & 15L);
      out[ 3 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get( 1 + inPos)) ) & 15L);
      out[ 4 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get( 2 + inPos)) >>  4) & 15L);
      out[ 5 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get( 2 + inPos)) ) & 15L);
      out[ 6 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get( 3 + inPos)) >>  4) & 15L);
      out[ 7 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get( 3 + inPos)) ) & 15L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[ 0 + inPos]) >>  4) & 15L);
      out[ 1 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[ 0 + inPos]) ) & 15L);
      out[ 2 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[ 1 + inPos]) >>  4) & 15L);
      out[ 3 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[ 1 + inPos]) ) & 15L);
      out[ 4 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[ 2 + inPos]) >>  4) & 15L);
      out[ 5 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[ 2 + inPos]) ) & 15L);
      out[ 6 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[ 3 + inPos]) >>  4) & 15L);
      out[ 7 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[ 3 + inPos]) ) & 15L);
      out[ 8 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[ 4 + inPos]) >>  4) & 15L);
      out[ 9 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[ 4 + inPos]) ) & 15L);
      out[10 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[ 5 + inPos]) >>  4) & 15L);
      out[11 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[ 5 + inPos]) ) & 15L);
      out[12 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[ 6 + inPos]) >>  4) & 15L);
      out[13 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[ 6 + inPos]) ) & 15L);
      out[14 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[ 7 + inPos]) >>  4) & 15L);
      out[15 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[ 7 + inPos]) ) & 15L);
      out[16 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[ 8 + inPos]) >>  4) & 15L);
      out[17 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[ 8 + inPos]) ) & 15L);
      out[18 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[ 9 + inPos]) >>  4) & 15L);
      out[19 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[ 9 + inPos]) ) & 15L);
      out[20 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[10 + inPos]) >>  4) & 15L);
      out[21 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[10 + inPos]) ) & 15L);
      out[22 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[11 + inPos]) >>  4) & 15L);
      out[23 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[11 + inPos]) ) & 15L);
      out[24 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[12 + inPos]) >>  4) & 15L);
      out[25 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[12 + inPos]) ) & 15L);
      out[26 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[13 + inPos]) >>  4) & 15L);
      out[27 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[13 + inPos]) ) & 15L);
      out[28 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[14 + inPos]) >>  4) & 15L);
      out[29 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[14 + inPos]) ) & 15L);
      out[30 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in[15 + inPos]) >>  4) & 15L);
      out[31 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in[15 + inPos]) ) & 15L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get( 0 + inPos)) >>  4) & 15L);
      out[ 1 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get( 0 + inPos)) ) & 15L);
      out[ 2 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get( 1 + inPos)) >>  4) & 15L);
      out[ 3 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get( 1 + inPos)) ) & 15L);
      out[ 4 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get( 2 + inPos)) >>  4) & 15L);
      out[ 5 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get( 2 + inPos)) ) & 15L);
      out[ 6 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get( 3 + inPos)) >>  4) & 15L);
      out[ 7 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get( 3 + inPos)) ) & 15L);
      out[ 8 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get( 4 + inPos)) >>  4) & 15L);
      out[ 9 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get( 4 + inPos)) ) & 15L);
      out[10 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get( 5 + inPos)) >>  4) & 15L);
      out[11 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get( 5 + inPos)) ) & 15L);
      out[12 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get( 6 + inPos)) >>  4) & 15L);
      out[13 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get( 6 + inPos)) ) & 15L);
      out[14 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get( 7 + inPos)) >>  4) & 15L);
      out[15 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get( 7 + inPos)) ) & 15L);
      out[16 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get( 8 + inPos)) >>  4) & 15L);
      out[17 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get( 8 + inPos)) ) & 15L);
      out[18 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get( 9 + inPos)) >>  4) & 15L);
      out[19 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get( 9 + inPos)) ) & 15L);
      out[20 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get(10 + inPos)) >>  4) & 15L);
      out[21 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get(10 + inPos)) ) & 15L);
      out[22 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get(11 + inPos)) >>  4) & 15L);
      out[23 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get(11 + inPos)) ) & 15L);
      out[24 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get(12 + inPos)) >>  4) & 15L);
      out[25 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get(12 + inPos)) ) & 15L);
      out[26 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get(13 + inPos)) >>  4) & 15L);
      out[27 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get(13 + inPos)) ) & 15L);
      out[28 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get(14 + inPos)) >>  4) & 15L);
      out[29 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get(14 + inPos)) ) & 15L);
      out[30 + outPos] =
          //              [7654____]
          //              [3210]
            ((((long)in.get(15 + inPos)) >>  4) & 15L);
      out[31 + outPos] =
          //              [____3210]
          //                  [3210]
            ((((long)in.get(15 + inPos)) ) & 15L);
    }
  }

  private static final class Packer5 extends BytePackerForLong {

    private Packer5() {
      super(5);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //               [76543___]
          //               [43210]
           ((in[ 0 + inPos] & 31L) <<  3)
        | //               [_____210]
          //                    [432__]
           ((in[ 1 + inPos] & 31L) >>> 2)) & 255);
      out[ 1 + outPos] = (byte)((
          //               [76______]
          //            [___10]
           ((in[ 1 + inPos] & 31L) <<  6)
        | //               [__54321_]
          //                 [43210]
           ((in[ 2 + inPos] & 31L) <<  1)
        | //               [_______0]
          //                      [4____]
           ((in[ 3 + inPos] & 31L) >>> 4)) & 255);
      out[ 2 + outPos] = (byte)((
          //               [7654____]
          //              [_3210]
           ((in[ 3 + inPos] & 31L) <<  4)
        | //               [____3210]
          //                   [4321_]
           ((in[ 4 + inPos] & 31L) >>> 1)) & 255);
      out[ 3 + outPos] = (byte)((
          //               [7_______]
          //           [____0]
           ((in[ 4 + inPos] & 31L) <<  7)
        | //               [_65432__]
          //                [43210]
           ((in[ 5 + inPos] & 31L) <<  2)
        | //               [______10]
          //                     [43___]
           ((in[ 6 + inPos] & 31L) >>> 3)) & 255);
      out[ 4 + outPos] = (byte)((
          //               [765_____]
          //             [__210]
           ((in[ 6 + inPos] & 31L) <<  5)
        | //               [___43210]
          //                  [43210]
           ((in[ 7 + inPos] & 31L))) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //               [76543___]
          //               [43210]
           ((in[ 0 + inPos] & 31L) <<  3)
        | //               [_____210]
          //                    [432__]
           ((in[ 1 + inPos] & 31L) >>> 2)) & 255);
      out[ 1 + outPos] = (byte)((
          //               [76______]
          //            [___10]
           ((in[ 1 + inPos] & 31L) <<  6)
        | //               [__54321_]
          //                 [43210]
           ((in[ 2 + inPos] & 31L) <<  1)
        | //               [_______0]
          //                      [4____]
           ((in[ 3 + inPos] & 31L) >>> 4)) & 255);
      out[ 2 + outPos] = (byte)((
          //               [7654____]
          //              [_3210]
           ((in[ 3 + inPos] & 31L) <<  4)
        | //               [____3210]
          //                   [4321_]
           ((in[ 4 + inPos] & 31L) >>> 1)) & 255);
      out[ 3 + outPos] = (byte)((
          //               [7_______]
          //           [____0]
           ((in[ 4 + inPos] & 31L) <<  7)
        | //               [_65432__]
          //                [43210]
           ((in[ 5 + inPos] & 31L) <<  2)
        | //               [______10]
          //                     [43___]
           ((in[ 6 + inPos] & 31L) >>> 3)) & 255);
      out[ 4 + outPos] = (byte)((
          //               [765_____]
          //             [__210]
           ((in[ 6 + inPos] & 31L) <<  5)
        | //               [___43210]
          //                  [43210]
           ((in[ 7 + inPos] & 31L))) & 255);
      out[ 5 + outPos] = (byte)((
          //               [76543___]
          //               [43210]
           ((in[ 8 + inPos] & 31L) <<  3)
        | //               [_____210]
          //                    [432__]
           ((in[ 9 + inPos] & 31L) >>> 2)) & 255);
      out[ 6 + outPos] = (byte)((
          //               [76______]
          //            [___10]
           ((in[ 9 + inPos] & 31L) <<  6)
        | //               [__54321_]
          //                 [43210]
           ((in[10 + inPos] & 31L) <<  1)
        | //               [_______0]
          //                      [4____]
           ((in[11 + inPos] & 31L) >>> 4)) & 255);
      out[ 7 + outPos] = (byte)((
          //               [7654____]
          //              [_3210]
           ((in[11 + inPos] & 31L) <<  4)
        | //               [____3210]
          //                   [4321_]
           ((in[12 + inPos] & 31L) >>> 1)) & 255);
      out[ 8 + outPos] = (byte)((
          //               [7_______]
          //           [____0]
           ((in[12 + inPos] & 31L) <<  7)
        | //               [_65432__]
          //                [43210]
           ((in[13 + inPos] & 31L) <<  2)
        | //               [______10]
          //                     [43___]
           ((in[14 + inPos] & 31L) >>> 3)) & 255);
      out[ 9 + outPos] = (byte)((
          //               [765_____]
          //             [__210]
           ((in[14 + inPos] & 31L) <<  5)
        | //               [___43210]
          //                  [43210]
           ((in[15 + inPos] & 31L))) & 255);
      out[10 + outPos] = (byte)((
          //               [76543___]
          //               [43210]
           ((in[16 + inPos] & 31L) <<  3)
        | //               [_____210]
          //                    [432__]
           ((in[17 + inPos] & 31L) >>> 2)) & 255);
      out[11 + outPos] = (byte)((
          //               [76______]
          //            [___10]
           ((in[17 + inPos] & 31L) <<  6)
        | //               [__54321_]
          //                 [43210]
           ((in[18 + inPos] & 31L) <<  1)
        | //               [_______0]
          //                      [4____]
           ((in[19 + inPos] & 31L) >>> 4)) & 255);
      out[12 + outPos] = (byte)((
          //               [7654____]
          //              [_3210]
           ((in[19 + inPos] & 31L) <<  4)
        | //               [____3210]
          //                   [4321_]
           ((in[20 + inPos] & 31L) >>> 1)) & 255);
      out[13 + outPos] = (byte)((
          //               [7_______]
          //           [____0]
           ((in[20 + inPos] & 31L) <<  7)
        | //               [_65432__]
          //                [43210]
           ((in[21 + inPos] & 31L) <<  2)
        | //               [______10]
          //                     [43___]
           ((in[22 + inPos] & 31L) >>> 3)) & 255);
      out[14 + outPos] = (byte)((
          //               [765_____]
          //             [__210]
           ((in[22 + inPos] & 31L) <<  5)
        | //               [___43210]
          //                  [43210]
           ((in[23 + inPos] & 31L))) & 255);
      out[15 + outPos] = (byte)((
          //               [76543___]
          //               [43210]
           ((in[24 + inPos] & 31L) <<  3)
        | //               [_____210]
          //                    [432__]
           ((in[25 + inPos] & 31L) >>> 2)) & 255);
      out[16 + outPos] = (byte)((
          //               [76______]
          //            [___10]
           ((in[25 + inPos] & 31L) <<  6)
        | //               [__54321_]
          //                 [43210]
           ((in[26 + inPos] & 31L) <<  1)
        | //               [_______0]
          //                      [4____]
           ((in[27 + inPos] & 31L) >>> 4)) & 255);
      out[17 + outPos] = (byte)((
          //               [7654____]
          //              [_3210]
           ((in[27 + inPos] & 31L) <<  4)
        | //               [____3210]
          //                   [4321_]
           ((in[28 + inPos] & 31L) >>> 1)) & 255);
      out[18 + outPos] = (byte)((
          //               [7_______]
          //           [____0]
           ((in[28 + inPos] & 31L) <<  7)
        | //               [_65432__]
          //                [43210]
           ((in[29 + inPos] & 31L) <<  2)
        | //               [______10]
          //                     [43___]
           ((in[30 + inPos] & 31L) >>> 3)) & 255);
      out[19 + outPos] = (byte)((
          //               [765_____]
          //             [__210]
           ((in[30 + inPos] & 31L) <<  5)
        | //               [___43210]
          //                  [43210]
           ((in[31 + inPos] & 31L))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //               [76543___]
          //               [43210]
            ((((long)in[ 0 + inPos]) >>  3) & 31L);
      out[ 1 + outPos] =
          //               [_____210]
          //                    [432__]
            ((((long)in[ 0 + inPos]) <<  2) & 31L)
        | //               [76______]
          //            [___10]
            ((((long)in[ 1 + inPos]) >>  6) & 3L);
      out[ 2 + outPos] =
          //               [__54321_]
          //                 [43210]
            ((((long)in[ 1 + inPos]) >>  1) & 31L);
      out[ 3 + outPos] =
          //               [_______0]
          //                      [4____]
            ((((long)in[ 1 + inPos]) <<  4) & 31L)
        | //               [7654____]
          //              [_3210]
            ((((long)in[ 2 + inPos]) >>  4) & 15L);
      out[ 4 + outPos] =
          //               [____3210]
          //                   [4321_]
            ((((long)in[ 2 + inPos]) <<  1) & 31L)
        | //               [7_______]
          //           [____0]
            ((((long)in[ 3 + inPos]) >>  7) & 1L);
      out[ 5 + outPos] =
          //               [_65432__]
          //                [43210]
            ((((long)in[ 3 + inPos]) >>  2) & 31L);
      out[ 6 + outPos] =
          //               [______10]
          //                     [43___]
            ((((long)in[ 3 + inPos]) <<  3) & 31L)
        | //               [765_____]
          //             [__210]
            ((((long)in[ 4 + inPos]) >>  5) & 7L);
      out[ 7 + outPos] =
          //               [___43210]
          //                  [43210]
            ((((long)in[ 4 + inPos]) ) & 31L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //               [76543___]
          //               [43210]
            ((((long)in.get( 0 + inPos)) >>  3) & 31L);
      out[ 1 + outPos] =
          //               [_____210]
          //                    [432__]
            ((((long)in.get( 0 + inPos)) <<  2) & 31L)
        | //               [76______]
          //            [___10]
            ((((long)in.get( 1 + inPos)) >>  6) & 3L);
      out[ 2 + outPos] =
          //               [__54321_]
          //                 [43210]
            ((((long)in.get( 1 + inPos)) >>  1) & 31L);
      out[ 3 + outPos] =
          //               [_______0]
          //                      [4____]
            ((((long)in.get( 1 + inPos)) <<  4) & 31L)
        | //               [7654____]
          //              [_3210]
            ((((long)in.get( 2 + inPos)) >>  4) & 15L);
      out[ 4 + outPos] =
          //               [____3210]
          //                   [4321_]
            ((((long)in.get( 2 + inPos)) <<  1) & 31L)
        | //               [7_______]
          //           [____0]
            ((((long)in.get( 3 + inPos)) >>  7) & 1L);
      out[ 5 + outPos] =
          //               [_65432__]
          //                [43210]
            ((((long)in.get( 3 + inPos)) >>  2) & 31L);
      out[ 6 + outPos] =
          //               [______10]
          //                     [43___]
            ((((long)in.get( 3 + inPos)) <<  3) & 31L)
        | //               [765_____]
          //             [__210]
            ((((long)in.get( 4 + inPos)) >>  5) & 7L);
      out[ 7 + outPos] =
          //               [___43210]
          //                  [43210]
            ((((long)in.get( 4 + inPos)) ) & 31L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //               [76543___]
          //               [43210]
            ((((long)in[ 0 + inPos]) >>  3) & 31L);
      out[ 1 + outPos] =
          //               [_____210]
          //                    [432__]
            ((((long)in[ 0 + inPos]) <<  2) & 31L)
        | //               [76______]
          //            [___10]
            ((((long)in[ 1 + inPos]) >>  6) & 3L);
      out[ 2 + outPos] =
          //               [__54321_]
          //                 [43210]
            ((((long)in[ 1 + inPos]) >>  1) & 31L);
      out[ 3 + outPos] =
          //               [_______0]
          //                      [4____]
            ((((long)in[ 1 + inPos]) <<  4) & 31L)
        | //               [7654____]
          //              [_3210]
            ((((long)in[ 2 + inPos]) >>  4) & 15L);
      out[ 4 + outPos] =
          //               [____3210]
          //                   [4321_]
            ((((long)in[ 2 + inPos]) <<  1) & 31L)
        | //               [7_______]
          //           [____0]
            ((((long)in[ 3 + inPos]) >>  7) & 1L);
      out[ 5 + outPos] =
          //               [_65432__]
          //                [43210]
            ((((long)in[ 3 + inPos]) >>  2) & 31L);
      out[ 6 + outPos] =
          //               [______10]
          //                     [43___]
            ((((long)in[ 3 + inPos]) <<  3) & 31L)
        | //               [765_____]
          //             [__210]
            ((((long)in[ 4 + inPos]) >>  5) & 7L);
      out[ 7 + outPos] =
          //               [___43210]
          //                  [43210]
            ((((long)in[ 4 + inPos]) ) & 31L);
      out[ 8 + outPos] =
          //               [76543___]
          //               [43210]
            ((((long)in[ 5 + inPos]) >>  3) & 31L);
      out[ 9 + outPos] =
          //               [_____210]
          //                    [432__]
            ((((long)in[ 5 + inPos]) <<  2) & 31L)
        | //               [76______]
          //            [___10]
            ((((long)in[ 6 + inPos]) >>  6) & 3L);
      out[10 + outPos] =
          //               [__54321_]
          //                 [43210]
            ((((long)in[ 6 + inPos]) >>  1) & 31L);
      out[11 + outPos] =
          //               [_______0]
          //                      [4____]
            ((((long)in[ 6 + inPos]) <<  4) & 31L)
        | //               [7654____]
          //              [_3210]
            ((((long)in[ 7 + inPos]) >>  4) & 15L);
      out[12 + outPos] =
          //               [____3210]
          //                   [4321_]
            ((((long)in[ 7 + inPos]) <<  1) & 31L)
        | //               [7_______]
          //           [____0]
            ((((long)in[ 8 + inPos]) >>  7) & 1L);
      out[13 + outPos] =
          //               [_65432__]
          //                [43210]
            ((((long)in[ 8 + inPos]) >>  2) & 31L);
      out[14 + outPos] =
          //               [______10]
          //                     [43___]
            ((((long)in[ 8 + inPos]) <<  3) & 31L)
        | //               [765_____]
          //             [__210]
            ((((long)in[ 9 + inPos]) >>  5) & 7L);
      out[15 + outPos] =
          //               [___43210]
          //                  [43210]
            ((((long)in[ 9 + inPos]) ) & 31L);
      out[16 + outPos] =
          //               [76543___]
          //               [43210]
            ((((long)in[10 + inPos]) >>  3) & 31L);
      out[17 + outPos] =
          //               [_____210]
          //                    [432__]
            ((((long)in[10 + inPos]) <<  2) & 31L)
        | //               [76______]
          //            [___10]
            ((((long)in[11 + inPos]) >>  6) & 3L);
      out[18 + outPos] =
          //               [__54321_]
          //                 [43210]
            ((((long)in[11 + inPos]) >>  1) & 31L);
      out[19 + outPos] =
          //               [_______0]
          //                      [4____]
            ((((long)in[11 + inPos]) <<  4) & 31L)
        | //               [7654____]
          //              [_3210]
            ((((long)in[12 + inPos]) >>  4) & 15L);
      out[20 + outPos] =
          //               [____3210]
          //                   [4321_]
            ((((long)in[12 + inPos]) <<  1) & 31L)
        | //               [7_______]
          //           [____0]
            ((((long)in[13 + inPos]) >>  7) & 1L);
      out[21 + outPos] =
          //               [_65432__]
          //                [43210]
            ((((long)in[13 + inPos]) >>  2) & 31L);
      out[22 + outPos] =
          //               [______10]
          //                     [43___]
            ((((long)in[13 + inPos]) <<  3) & 31L)
        | //               [765_____]
          //             [__210]
            ((((long)in[14 + inPos]) >>  5) & 7L);
      out[23 + outPos] =
          //               [___43210]
          //                  [43210]
            ((((long)in[14 + inPos]) ) & 31L);
      out[24 + outPos] =
          //               [76543___]
          //               [43210]
            ((((long)in[15 + inPos]) >>  3) & 31L);
      out[25 + outPos] =
          //               [_____210]
          //                    [432__]
            ((((long)in[15 + inPos]) <<  2) & 31L)
        | //               [76______]
          //            [___10]
            ((((long)in[16 + inPos]) >>  6) & 3L);
      out[26 + outPos] =
          //               [__54321_]
          //                 [43210]
            ((((long)in[16 + inPos]) >>  1) & 31L);
      out[27 + outPos] =
          //               [_______0]
          //                      [4____]
            ((((long)in[16 + inPos]) <<  4) & 31L)
        | //               [7654____]
          //              [_3210]
            ((((long)in[17 + inPos]) >>  4) & 15L);
      out[28 + outPos] =
          //               [____3210]
          //                   [4321_]
            ((((long)in[17 + inPos]) <<  1) & 31L)
        | //               [7_______]
          //           [____0]
            ((((long)in[18 + inPos]) >>  7) & 1L);
      out[29 + outPos] =
          //               [_65432__]
          //                [43210]
            ((((long)in[18 + inPos]) >>  2) & 31L);
      out[30 + outPos] =
          //               [______10]
          //                     [43___]
            ((((long)in[18 + inPos]) <<  3) & 31L)
        | //               [765_____]
          //             [__210]
            ((((long)in[19 + inPos]) >>  5) & 7L);
      out[31 + outPos] =
          //               [___43210]
          //                  [43210]
            ((((long)in[19 + inPos]) ) & 31L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //               [76543___]
          //               [43210]
            ((((long)in.get( 0 + inPos)) >>  3) & 31L);
      out[ 1 + outPos] =
          //               [_____210]
          //                    [432__]
            ((((long)in.get( 0 + inPos)) <<  2) & 31L)
        | //               [76______]
          //            [___10]
            ((((long)in.get( 1 + inPos)) >>  6) & 3L);
      out[ 2 + outPos] =
          //               [__54321_]
          //                 [43210]
            ((((long)in.get( 1 + inPos)) >>  1) & 31L);
      out[ 3 + outPos] =
          //               [_______0]
          //                      [4____]
            ((((long)in.get( 1 + inPos)) <<  4) & 31L)
        | //               [7654____]
          //              [_3210]
            ((((long)in.get( 2 + inPos)) >>  4) & 15L);
      out[ 4 + outPos] =
          //               [____3210]
          //                   [4321_]
            ((((long)in.get( 2 + inPos)) <<  1) & 31L)
        | //               [7_______]
          //           [____0]
            ((((long)in.get( 3 + inPos)) >>  7) & 1L);
      out[ 5 + outPos] =
          //               [_65432__]
          //                [43210]
            ((((long)in.get( 3 + inPos)) >>  2) & 31L);
      out[ 6 + outPos] =
          //               [______10]
          //                     [43___]
            ((((long)in.get( 3 + inPos)) <<  3) & 31L)
        | //               [765_____]
          //             [__210]
            ((((long)in.get( 4 + inPos)) >>  5) & 7L);
      out[ 7 + outPos] =
          //               [___43210]
          //                  [43210]
            ((((long)in.get( 4 + inPos)) ) & 31L);
      out[ 8 + outPos] =
          //               [76543___]
          //               [43210]
            ((((long)in.get( 5 + inPos)) >>  3) & 31L);
      out[ 9 + outPos] =
          //               [_____210]
          //                    [432__]
            ((((long)in.get( 5 + inPos)) <<  2) & 31L)
        | //               [76______]
          //            [___10]
            ((((long)in.get( 6 + inPos)) >>  6) & 3L);
      out[10 + outPos] =
          //               [__54321_]
          //                 [43210]
            ((((long)in.get( 6 + inPos)) >>  1) & 31L);
      out[11 + outPos] =
          //               [_______0]
          //                      [4____]
            ((((long)in.get( 6 + inPos)) <<  4) & 31L)
        | //               [7654____]
          //              [_3210]
            ((((long)in.get( 7 + inPos)) >>  4) & 15L);
      out[12 + outPos] =
          //               [____3210]
          //                   [4321_]
            ((((long)in.get( 7 + inPos)) <<  1) & 31L)
        | //               [7_______]
          //           [____0]
            ((((long)in.get( 8 + inPos)) >>  7) & 1L);
      out[13 + outPos] =
          //               [_65432__]
          //                [43210]
            ((((long)in.get( 8 + inPos)) >>  2) & 31L);
      out[14 + outPos] =
          //               [______10]
          //                     [43___]
            ((((long)in.get( 8 + inPos)) <<  3) & 31L)
        | //               [765_____]
          //             [__210]
            ((((long)in.get( 9 + inPos)) >>  5) & 7L);
      out[15 + outPos] =
          //               [___43210]
          //                  [43210]
            ((((long)in.get( 9 + inPos)) ) & 31L);
      out[16 + outPos] =
          //               [76543___]
          //               [43210]
            ((((long)in.get(10 + inPos)) >>  3) & 31L);
      out[17 + outPos] =
          //               [_____210]
          //                    [432__]
            ((((long)in.get(10 + inPos)) <<  2) & 31L)
        | //               [76______]
          //            [___10]
            ((((long)in.get(11 + inPos)) >>  6) & 3L);
      out[18 + outPos] =
          //               [__54321_]
          //                 [43210]
            ((((long)in.get(11 + inPos)) >>  1) & 31L);
      out[19 + outPos] =
          //               [_______0]
          //                      [4____]
            ((((long)in.get(11 + inPos)) <<  4) & 31L)
        | //               [7654____]
          //              [_3210]
            ((((long)in.get(12 + inPos)) >>  4) & 15L);
      out[20 + outPos] =
          //               [____3210]
          //                   [4321_]
            ((((long)in.get(12 + inPos)) <<  1) & 31L)
        | //               [7_______]
          //           [____0]
            ((((long)in.get(13 + inPos)) >>  7) & 1L);
      out[21 + outPos] =
          //               [_65432__]
          //                [43210]
            ((((long)in.get(13 + inPos)) >>  2) & 31L);
      out[22 + outPos] =
          //               [______10]
          //                     [43___]
            ((((long)in.get(13 + inPos)) <<  3) & 31L)
        | //               [765_____]
          //             [__210]
            ((((long)in.get(14 + inPos)) >>  5) & 7L);
      out[23 + outPos] =
          //               [___43210]
          //                  [43210]
            ((((long)in.get(14 + inPos)) ) & 31L);
      out[24 + outPos] =
          //               [76543___]
          //               [43210]
            ((((long)in.get(15 + inPos)) >>  3) & 31L);
      out[25 + outPos] =
          //               [_____210]
          //                    [432__]
            ((((long)in.get(15 + inPos)) <<  2) & 31L)
        | //               [76______]
          //            [___10]
            ((((long)in.get(16 + inPos)) >>  6) & 3L);
      out[26 + outPos] =
          //               [__54321_]
          //                 [43210]
            ((((long)in.get(16 + inPos)) >>  1) & 31L);
      out[27 + outPos] =
          //               [_______0]
          //                      [4____]
            ((((long)in.get(16 + inPos)) <<  4) & 31L)
        | //               [7654____]
          //              [_3210]
            ((((long)in.get(17 + inPos)) >>  4) & 15L);
      out[28 + outPos] =
          //               [____3210]
          //                   [4321_]
            ((((long)in.get(17 + inPos)) <<  1) & 31L)
        | //               [7_______]
          //           [____0]
            ((((long)in.get(18 + inPos)) >>  7) & 1L);
      out[29 + outPos] =
          //               [_65432__]
          //                [43210]
            ((((long)in.get(18 + inPos)) >>  2) & 31L);
      out[30 + outPos] =
          //               [______10]
          //                     [43___]
            ((((long)in.get(18 + inPos)) <<  3) & 31L)
        | //               [765_____]
          //             [__210]
            ((((long)in.get(19 + inPos)) >>  5) & 7L);
      out[31 + outPos] =
          //               [___43210]
          //                  [43210]
            ((((long)in.get(19 + inPos)) ) & 31L);
    }
  }

  private static final class Packer6 extends BytePackerForLong {

    private Packer6() {
      super(6);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                [765432__]
          //                [543210]
           ((in[ 0 + inPos] & 63L) <<  2)
        | //                [______10]
          //                      [54____]
           ((in[ 1 + inPos] & 63L) >>> 4)) & 255);
      out[ 1 + outPos] = (byte)((
          //                [7654____]
          //              [__3210]
           ((in[ 1 + inPos] & 63L) <<  4)
        | //                [____3210]
          //                    [5432__]
           ((in[ 2 + inPos] & 63L) >>> 2)) & 255);
      out[ 2 + outPos] = (byte)((
          //                [76______]
          //            [____10]
           ((in[ 2 + inPos] & 63L) <<  6)
        | //                [__543210]
          //                  [543210]
           ((in[ 3 + inPos] & 63L))) & 255);
      out[ 3 + outPos] = (byte)((
          //                [765432__]
          //                [543210]
           ((in[ 4 + inPos] & 63L) <<  2)
        | //                [______10]
          //                      [54____]
           ((in[ 5 + inPos] & 63L) >>> 4)) & 255);
      out[ 4 + outPos] = (byte)((
          //                [7654____]
          //              [__3210]
           ((in[ 5 + inPos] & 63L) <<  4)
        | //                [____3210]
          //                    [5432__]
           ((in[ 6 + inPos] & 63L) >>> 2)) & 255);
      out[ 5 + outPos] = (byte)((
          //                [76______]
          //            [____10]
           ((in[ 6 + inPos] & 63L) <<  6)
        | //                [__543210]
          //                  [543210]
           ((in[ 7 + inPos] & 63L))) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                [765432__]
          //                [543210]
           ((in[ 0 + inPos] & 63L) <<  2)
        | //                [______10]
          //                      [54____]
           ((in[ 1 + inPos] & 63L) >>> 4)) & 255);
      out[ 1 + outPos] = (byte)((
          //                [7654____]
          //              [__3210]
           ((in[ 1 + inPos] & 63L) <<  4)
        | //                [____3210]
          //                    [5432__]
           ((in[ 2 + inPos] & 63L) >>> 2)) & 255);
      out[ 2 + outPos] = (byte)((
          //                [76______]
          //            [____10]
           ((in[ 2 + inPos] & 63L) <<  6)
        | //                [__543210]
          //                  [543210]
           ((in[ 3 + inPos] & 63L))) & 255);
      out[ 3 + outPos] = (byte)((
          //                [765432__]
          //                [543210]
           ((in[ 4 + inPos] & 63L) <<  2)
        | //                [______10]
          //                      [54____]
           ((in[ 5 + inPos] & 63L) >>> 4)) & 255);
      out[ 4 + outPos] = (byte)((
          //                [7654____]
          //              [__3210]
           ((in[ 5 + inPos] & 63L) <<  4)
        | //                [____3210]
          //                    [5432__]
           ((in[ 6 + inPos] & 63L) >>> 2)) & 255);
      out[ 5 + outPos] = (byte)((
          //                [76______]
          //            [____10]
           ((in[ 6 + inPos] & 63L) <<  6)
        | //                [__543210]
          //                  [543210]
           ((in[ 7 + inPos] & 63L))) & 255);
      out[ 6 + outPos] = (byte)((
          //                [765432__]
          //                [543210]
           ((in[ 8 + inPos] & 63L) <<  2)
        | //                [______10]
          //                      [54____]
           ((in[ 9 + inPos] & 63L) >>> 4)) & 255);
      out[ 7 + outPos] = (byte)((
          //                [7654____]
          //              [__3210]
           ((in[ 9 + inPos] & 63L) <<  4)
        | //                [____3210]
          //                    [5432__]
           ((in[10 + inPos] & 63L) >>> 2)) & 255);
      out[ 8 + outPos] = (byte)((
          //                [76______]
          //            [____10]
           ((in[10 + inPos] & 63L) <<  6)
        | //                [__543210]
          //                  [543210]
           ((in[11 + inPos] & 63L))) & 255);
      out[ 9 + outPos] = (byte)((
          //                [765432__]
          //                [543210]
           ((in[12 + inPos] & 63L) <<  2)
        | //                [______10]
          //                      [54____]
           ((in[13 + inPos] & 63L) >>> 4)) & 255);
      out[10 + outPos] = (byte)((
          //                [7654____]
          //              [__3210]
           ((in[13 + inPos] & 63L) <<  4)
        | //                [____3210]
          //                    [5432__]
           ((in[14 + inPos] & 63L) >>> 2)) & 255);
      out[11 + outPos] = (byte)((
          //                [76______]
          //            [____10]
           ((in[14 + inPos] & 63L) <<  6)
        | //                [__543210]
          //                  [543210]
           ((in[15 + inPos] & 63L))) & 255);
      out[12 + outPos] = (byte)((
          //                [765432__]
          //                [543210]
           ((in[16 + inPos] & 63L) <<  2)
        | //                [______10]
          //                      [54____]
           ((in[17 + inPos] & 63L) >>> 4)) & 255);
      out[13 + outPos] = (byte)((
          //                [7654____]
          //              [__3210]
           ((in[17 + inPos] & 63L) <<  4)
        | //                [____3210]
          //                    [5432__]
           ((in[18 + inPos] & 63L) >>> 2)) & 255);
      out[14 + outPos] = (byte)((
          //                [76______]
          //            [____10]
           ((in[18 + inPos] & 63L) <<  6)
        | //                [__543210]
          //                  [543210]
           ((in[19 + inPos] & 63L))) & 255);
      out[15 + outPos] = (byte)((
          //                [765432__]
          //                [543210]
           ((in[20 + inPos] & 63L) <<  2)
        | //                [______10]
          //                      [54____]
           ((in[21 + inPos] & 63L) >>> 4)) & 255);
      out[16 + outPos] = (byte)((
          //                [7654____]
          //              [__3210]
           ((in[21 + inPos] & 63L) <<  4)
        | //                [____3210]
          //                    [5432__]
           ((in[22 + inPos] & 63L) >>> 2)) & 255);
      out[17 + outPos] = (byte)((
          //                [76______]
          //            [____10]
           ((in[22 + inPos] & 63L) <<  6)
        | //                [__543210]
          //                  [543210]
           ((in[23 + inPos] & 63L))) & 255);
      out[18 + outPos] = (byte)((
          //                [765432__]
          //                [543210]
           ((in[24 + inPos] & 63L) <<  2)
        | //                [______10]
          //                      [54____]
           ((in[25 + inPos] & 63L) >>> 4)) & 255);
      out[19 + outPos] = (byte)((
          //                [7654____]
          //              [__3210]
           ((in[25 + inPos] & 63L) <<  4)
        | //                [____3210]
          //                    [5432__]
           ((in[26 + inPos] & 63L) >>> 2)) & 255);
      out[20 + outPos] = (byte)((
          //                [76______]
          //            [____10]
           ((in[26 + inPos] & 63L) <<  6)
        | //                [__543210]
          //                  [543210]
           ((in[27 + inPos] & 63L))) & 255);
      out[21 + outPos] = (byte)((
          //                [765432__]
          //                [543210]
           ((in[28 + inPos] & 63L) <<  2)
        | //                [______10]
          //                      [54____]
           ((in[29 + inPos] & 63L) >>> 4)) & 255);
      out[22 + outPos] = (byte)((
          //                [7654____]
          //              [__3210]
           ((in[29 + inPos] & 63L) <<  4)
        | //                [____3210]
          //                    [5432__]
           ((in[30 + inPos] & 63L) >>> 2)) & 255);
      out[23 + outPos] = (byte)((
          //                [76______]
          //            [____10]
           ((in[30 + inPos] & 63L) <<  6)
        | //                [__543210]
          //                  [543210]
           ((in[31 + inPos] & 63L))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in[ 0 + inPos]) >>  2) & 63L);
      out[ 1 + outPos] =
          //                [______10]
          //                      [54____]
            ((((long)in[ 0 + inPos]) <<  4) & 63L)
        | //                [7654____]
          //              [__3210]
            ((((long)in[ 1 + inPos]) >>  4) & 15L);
      out[ 2 + outPos] =
          //                [____3210]
          //                    [5432__]
            ((((long)in[ 1 + inPos]) <<  2) & 63L)
        | //                [76______]
          //            [____10]
            ((((long)in[ 2 + inPos]) >>  6) & 3L);
      out[ 3 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in[ 2 + inPos]) ) & 63L);
      out[ 4 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in[ 3 + inPos]) >>  2) & 63L);
      out[ 5 + outPos] =
          //                [______10]
          //                      [54____]
            ((((long)in[ 3 + inPos]) <<  4) & 63L)
        | //                [7654____]
          //              [__3210]
            ((((long)in[ 4 + inPos]) >>  4) & 15L);
      out[ 6 + outPos] =
          //                [____3210]
          //                    [5432__]
            ((((long)in[ 4 + inPos]) <<  2) & 63L)
        | //                [76______]
          //            [____10]
            ((((long)in[ 5 + inPos]) >>  6) & 3L);
      out[ 7 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in[ 5 + inPos]) ) & 63L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in.get( 0 + inPos)) >>  2) & 63L);
      out[ 1 + outPos] =
          //                [______10]
          //                      [54____]
            ((((long)in.get( 0 + inPos)) <<  4) & 63L)
        | //                [7654____]
          //              [__3210]
            ((((long)in.get( 1 + inPos)) >>  4) & 15L);
      out[ 2 + outPos] =
          //                [____3210]
          //                    [5432__]
            ((((long)in.get( 1 + inPos)) <<  2) & 63L)
        | //                [76______]
          //            [____10]
            ((((long)in.get( 2 + inPos)) >>  6) & 3L);
      out[ 3 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in.get( 2 + inPos)) ) & 63L);
      out[ 4 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in.get( 3 + inPos)) >>  2) & 63L);
      out[ 5 + outPos] =
          //                [______10]
          //                      [54____]
            ((((long)in.get( 3 + inPos)) <<  4) & 63L)
        | //                [7654____]
          //              [__3210]
            ((((long)in.get( 4 + inPos)) >>  4) & 15L);
      out[ 6 + outPos] =
          //                [____3210]
          //                    [5432__]
            ((((long)in.get( 4 + inPos)) <<  2) & 63L)
        | //                [76______]
          //            [____10]
            ((((long)in.get( 5 + inPos)) >>  6) & 3L);
      out[ 7 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in.get( 5 + inPos)) ) & 63L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in[ 0 + inPos]) >>  2) & 63L);
      out[ 1 + outPos] =
          //                [______10]
          //                      [54____]
            ((((long)in[ 0 + inPos]) <<  4) & 63L)
        | //                [7654____]
          //              [__3210]
            ((((long)in[ 1 + inPos]) >>  4) & 15L);
      out[ 2 + outPos] =
          //                [____3210]
          //                    [5432__]
            ((((long)in[ 1 + inPos]) <<  2) & 63L)
        | //                [76______]
          //            [____10]
            ((((long)in[ 2 + inPos]) >>  6) & 3L);
      out[ 3 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in[ 2 + inPos]) ) & 63L);
      out[ 4 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in[ 3 + inPos]) >>  2) & 63L);
      out[ 5 + outPos] =
          //                [______10]
          //                      [54____]
            ((((long)in[ 3 + inPos]) <<  4) & 63L)
        | //                [7654____]
          //              [__3210]
            ((((long)in[ 4 + inPos]) >>  4) & 15L);
      out[ 6 + outPos] =
          //                [____3210]
          //                    [5432__]
            ((((long)in[ 4 + inPos]) <<  2) & 63L)
        | //                [76______]
          //            [____10]
            ((((long)in[ 5 + inPos]) >>  6) & 3L);
      out[ 7 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in[ 5 + inPos]) ) & 63L);
      out[ 8 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in[ 6 + inPos]) >>  2) & 63L);
      out[ 9 + outPos] =
          //                [______10]
          //                      [54____]
            ((((long)in[ 6 + inPos]) <<  4) & 63L)
        | //                [7654____]
          //              [__3210]
            ((((long)in[ 7 + inPos]) >>  4) & 15L);
      out[10 + outPos] =
          //                [____3210]
          //                    [5432__]
            ((((long)in[ 7 + inPos]) <<  2) & 63L)
        | //                [76______]
          //            [____10]
            ((((long)in[ 8 + inPos]) >>  6) & 3L);
      out[11 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in[ 8 + inPos]) ) & 63L);
      out[12 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in[ 9 + inPos]) >>  2) & 63L);
      out[13 + outPos] =
          //                [______10]
          //                      [54____]
            ((((long)in[ 9 + inPos]) <<  4) & 63L)
        | //                [7654____]
          //              [__3210]
            ((((long)in[10 + inPos]) >>  4) & 15L);
      out[14 + outPos] =
          //                [____3210]
          //                    [5432__]
            ((((long)in[10 + inPos]) <<  2) & 63L)
        | //                [76______]
          //            [____10]
            ((((long)in[11 + inPos]) >>  6) & 3L);
      out[15 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in[11 + inPos]) ) & 63L);
      out[16 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in[12 + inPos]) >>  2) & 63L);
      out[17 + outPos] =
          //                [______10]
          //                      [54____]
            ((((long)in[12 + inPos]) <<  4) & 63L)
        | //                [7654____]
          //              [__3210]
            ((((long)in[13 + inPos]) >>  4) & 15L);
      out[18 + outPos] =
          //                [____3210]
          //                    [5432__]
            ((((long)in[13 + inPos]) <<  2) & 63L)
        | //                [76______]
          //            [____10]
            ((((long)in[14 + inPos]) >>  6) & 3L);
      out[19 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in[14 + inPos]) ) & 63L);
      out[20 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in[15 + inPos]) >>  2) & 63L);
      out[21 + outPos] =
          //                [______10]
          //                      [54____]
            ((((long)in[15 + inPos]) <<  4) & 63L)
        | //                [7654____]
          //              [__3210]
            ((((long)in[16 + inPos]) >>  4) & 15L);
      out[22 + outPos] =
          //                [____3210]
          //                    [5432__]
            ((((long)in[16 + inPos]) <<  2) & 63L)
        | //                [76______]
          //            [____10]
            ((((long)in[17 + inPos]) >>  6) & 3L);
      out[23 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in[17 + inPos]) ) & 63L);
      out[24 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in[18 + inPos]) >>  2) & 63L);
      out[25 + outPos] =
          //                [______10]
          //                      [54____]
            ((((long)in[18 + inPos]) <<  4) & 63L)
        | //                [7654____]
          //              [__3210]
            ((((long)in[19 + inPos]) >>  4) & 15L);
      out[26 + outPos] =
          //                [____3210]
          //                    [5432__]
            ((((long)in[19 + inPos]) <<  2) & 63L)
        | //                [76______]
          //            [____10]
            ((((long)in[20 + inPos]) >>  6) & 3L);
      out[27 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in[20 + inPos]) ) & 63L);
      out[28 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in[21 + inPos]) >>  2) & 63L);
      out[29 + outPos] =
          //                [______10]
          //                      [54____]
            ((((long)in[21 + inPos]) <<  4) & 63L)
        | //                [7654____]
          //              [__3210]
            ((((long)in[22 + inPos]) >>  4) & 15L);
      out[30 + outPos] =
          //                [____3210]
          //                    [5432__]
            ((((long)in[22 + inPos]) <<  2) & 63L)
        | //                [76______]
          //            [____10]
            ((((long)in[23 + inPos]) >>  6) & 3L);
      out[31 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in[23 + inPos]) ) & 63L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in.get( 0 + inPos)) >>  2) & 63L);
      out[ 1 + outPos] =
          //                [______10]
          //                      [54____]
            ((((long)in.get( 0 + inPos)) <<  4) & 63L)
        | //                [7654____]
          //              [__3210]
            ((((long)in.get( 1 + inPos)) >>  4) & 15L);
      out[ 2 + outPos] =
          //                [____3210]
          //                    [5432__]
            ((((long)in.get( 1 + inPos)) <<  2) & 63L)
        | //                [76______]
          //            [____10]
            ((((long)in.get( 2 + inPos)) >>  6) & 3L);
      out[ 3 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in.get( 2 + inPos)) ) & 63L);
      out[ 4 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in.get( 3 + inPos)) >>  2) & 63L);
      out[ 5 + outPos] =
          //                [______10]
          //                      [54____]
            ((((long)in.get( 3 + inPos)) <<  4) & 63L)
        | //                [7654____]
          //              [__3210]
            ((((long)in.get( 4 + inPos)) >>  4) & 15L);
      out[ 6 + outPos] =
          //                [____3210]
          //                    [5432__]
            ((((long)in.get( 4 + inPos)) <<  2) & 63L)
        | //                [76______]
          //            [____10]
            ((((long)in.get( 5 + inPos)) >>  6) & 3L);
      out[ 7 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in.get( 5 + inPos)) ) & 63L);
      out[ 8 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in.get( 6 + inPos)) >>  2) & 63L);
      out[ 9 + outPos] =
          //                [______10]
          //                      [54____]
            ((((long)in.get( 6 + inPos)) <<  4) & 63L)
        | //                [7654____]
          //              [__3210]
            ((((long)in.get( 7 + inPos)) >>  4) & 15L);
      out[10 + outPos] =
          //                [____3210]
          //                    [5432__]
            ((((long)in.get( 7 + inPos)) <<  2) & 63L)
        | //                [76______]
          //            [____10]
            ((((long)in.get( 8 + inPos)) >>  6) & 3L);
      out[11 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in.get( 8 + inPos)) ) & 63L);
      out[12 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in.get( 9 + inPos)) >>  2) & 63L);
      out[13 + outPos] =
          //                [______10]
          //                      [54____]
            ((((long)in.get( 9 + inPos)) <<  4) & 63L)
        | //                [7654____]
          //              [__3210]
            ((((long)in.get(10 + inPos)) >>  4) & 15L);
      out[14 + outPos] =
          //                [____3210]
          //                    [5432__]
            ((((long)in.get(10 + inPos)) <<  2) & 63L)
        | //                [76______]
          //            [____10]
            ((((long)in.get(11 + inPos)) >>  6) & 3L);
      out[15 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in.get(11 + inPos)) ) & 63L);
      out[16 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in.get(12 + inPos)) >>  2) & 63L);
      out[17 + outPos] =
          //                [______10]
          //                      [54____]
            ((((long)in.get(12 + inPos)) <<  4) & 63L)
        | //                [7654____]
          //              [__3210]
            ((((long)in.get(13 + inPos)) >>  4) & 15L);
      out[18 + outPos] =
          //                [____3210]
          //                    [5432__]
            ((((long)in.get(13 + inPos)) <<  2) & 63L)
        | //                [76______]
          //            [____10]
            ((((long)in.get(14 + inPos)) >>  6) & 3L);
      out[19 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in.get(14 + inPos)) ) & 63L);
      out[20 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in.get(15 + inPos)) >>  2) & 63L);
      out[21 + outPos] =
          //                [______10]
          //                      [54____]
            ((((long)in.get(15 + inPos)) <<  4) & 63L)
        | //                [7654____]
          //              [__3210]
            ((((long)in.get(16 + inPos)) >>  4) & 15L);
      out[22 + outPos] =
          //                [____3210]
          //                    [5432__]
            ((((long)in.get(16 + inPos)) <<  2) & 63L)
        | //                [76______]
          //            [____10]
            ((((long)in.get(17 + inPos)) >>  6) & 3L);
      out[23 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in.get(17 + inPos)) ) & 63L);
      out[24 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in.get(18 + inPos)) >>  2) & 63L);
      out[25 + outPos] =
          //                [______10]
          //                      [54____]
            ((((long)in.get(18 + inPos)) <<  4) & 63L)
        | //                [7654____]
          //              [__3210]
            ((((long)in.get(19 + inPos)) >>  4) & 15L);
      out[26 + outPos] =
          //                [____3210]
          //                    [5432__]
            ((((long)in.get(19 + inPos)) <<  2) & 63L)
        | //                [76______]
          //            [____10]
            ((((long)in.get(20 + inPos)) >>  6) & 3L);
      out[27 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in.get(20 + inPos)) ) & 63L);
      out[28 + outPos] =
          //                [765432__]
          //                [543210]
            ((((long)in.get(21 + inPos)) >>  2) & 63L);
      out[29 + outPos] =
          //                [______10]
          //                      [54____]
            ((((long)in.get(21 + inPos)) <<  4) & 63L)
        | //                [7654____]
          //              [__3210]
            ((((long)in.get(22 + inPos)) >>  4) & 15L);
      out[30 + outPos] =
          //                [____3210]
          //                    [5432__]
            ((((long)in.get(22 + inPos)) <<  2) & 63L)
        | //                [76______]
          //            [____10]
            ((((long)in.get(23 + inPos)) >>  6) & 3L);
      out[31 + outPos] =
          //                [__543210]
          //                  [543210]
            ((((long)in.get(23 + inPos)) ) & 63L);
    }
  }

  private static final class Packer7 extends BytePackerForLong {

    private Packer7() {
      super(7);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                 [7654321_]
          //                 [6543210]
           ((in[ 0 + inPos] & 127L) <<  1)
        | //                 [_______0]
          //                        [6______]
           ((in[ 1 + inPos] & 127L) >>> 6)) & 255);
      out[ 1 + outPos] = (byte)((
          //                 [765432__]
          //                [_543210]
           ((in[ 1 + inPos] & 127L) <<  2)
        | //                 [______10]
          //                       [65_____]
           ((in[ 2 + inPos] & 127L) >>> 5)) & 255);
      out[ 2 + outPos] = (byte)((
          //                 [76543___]
          //               [__43210]
           ((in[ 2 + inPos] & 127L) <<  3)
        | //                 [_____210]
          //                      [654____]
           ((in[ 3 + inPos] & 127L) >>> 4)) & 255);
      out[ 3 + outPos] = (byte)((
          //                 [7654____]
          //              [___3210]
           ((in[ 3 + inPos] & 127L) <<  4)
        | //                 [____3210]
          //                     [6543___]
           ((in[ 4 + inPos] & 127L) >>> 3)) & 255);
      out[ 4 + outPos] = (byte)((
          //                 [765_____]
          //             [____210]
           ((in[ 4 + inPos] & 127L) <<  5)
        | //                 [___43210]
          //                    [65432__]
           ((in[ 5 + inPos] & 127L) >>> 2)) & 255);
      out[ 5 + outPos] = (byte)((
          //                 [76______]
          //            [_____10]
           ((in[ 5 + inPos] & 127L) <<  6)
        | //                 [__543210]
          //                   [654321_]
           ((in[ 6 + inPos] & 127L) >>> 1)) & 255);
      out[ 6 + outPos] = (byte)((
          //                 [7_______]
          //           [______0]
           ((in[ 6 + inPos] & 127L) <<  7)
        | //                 [_6543210]
          //                  [6543210]
           ((in[ 7 + inPos] & 127L))) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                 [7654321_]
          //                 [6543210]
           ((in[ 0 + inPos] & 127L) <<  1)
        | //                 [_______0]
          //                        [6______]
           ((in[ 1 + inPos] & 127L) >>> 6)) & 255);
      out[ 1 + outPos] = (byte)((
          //                 [765432__]
          //                [_543210]
           ((in[ 1 + inPos] & 127L) <<  2)
        | //                 [______10]
          //                       [65_____]
           ((in[ 2 + inPos] & 127L) >>> 5)) & 255);
      out[ 2 + outPos] = (byte)((
          //                 [76543___]
          //               [__43210]
           ((in[ 2 + inPos] & 127L) <<  3)
        | //                 [_____210]
          //                      [654____]
           ((in[ 3 + inPos] & 127L) >>> 4)) & 255);
      out[ 3 + outPos] = (byte)((
          //                 [7654____]
          //              [___3210]
           ((in[ 3 + inPos] & 127L) <<  4)
        | //                 [____3210]
          //                     [6543___]
           ((in[ 4 + inPos] & 127L) >>> 3)) & 255);
      out[ 4 + outPos] = (byte)((
          //                 [765_____]
          //             [____210]
           ((in[ 4 + inPos] & 127L) <<  5)
        | //                 [___43210]
          //                    [65432__]
           ((in[ 5 + inPos] & 127L) >>> 2)) & 255);
      out[ 5 + outPos] = (byte)((
          //                 [76______]
          //            [_____10]
           ((in[ 5 + inPos] & 127L) <<  6)
        | //                 [__543210]
          //                   [654321_]
           ((in[ 6 + inPos] & 127L) >>> 1)) & 255);
      out[ 6 + outPos] = (byte)((
          //                 [7_______]
          //           [______0]
           ((in[ 6 + inPos] & 127L) <<  7)
        | //                 [_6543210]
          //                  [6543210]
           ((in[ 7 + inPos] & 127L))) & 255);
      out[ 7 + outPos] = (byte)((
          //                 [7654321_]
          //                 [6543210]
           ((in[ 8 + inPos] & 127L) <<  1)
        | //                 [_______0]
          //                        [6______]
           ((in[ 9 + inPos] & 127L) >>> 6)) & 255);
      out[ 8 + outPos] = (byte)((
          //                 [765432__]
          //                [_543210]
           ((in[ 9 + inPos] & 127L) <<  2)
        | //                 [______10]
          //                       [65_____]
           ((in[10 + inPos] & 127L) >>> 5)) & 255);
      out[ 9 + outPos] = (byte)((
          //                 [76543___]
          //               [__43210]
           ((in[10 + inPos] & 127L) <<  3)
        | //                 [_____210]
          //                      [654____]
           ((in[11 + inPos] & 127L) >>> 4)) & 255);
      out[10 + outPos] = (byte)((
          //                 [7654____]
          //              [___3210]
           ((in[11 + inPos] & 127L) <<  4)
        | //                 [____3210]
          //                     [6543___]
           ((in[12 + inPos] & 127L) >>> 3)) & 255);
      out[11 + outPos] = (byte)((
          //                 [765_____]
          //             [____210]
           ((in[12 + inPos] & 127L) <<  5)
        | //                 [___43210]
          //                    [65432__]
           ((in[13 + inPos] & 127L) >>> 2)) & 255);
      out[12 + outPos] = (byte)((
          //                 [76______]
          //            [_____10]
           ((in[13 + inPos] & 127L) <<  6)
        | //                 [__543210]
          //                   [654321_]
           ((in[14 + inPos] & 127L) >>> 1)) & 255);
      out[13 + outPos] = (byte)((
          //                 [7_______]
          //           [______0]
           ((in[14 + inPos] & 127L) <<  7)
        | //                 [_6543210]
          //                  [6543210]
           ((in[15 + inPos] & 127L))) & 255);
      out[14 + outPos] = (byte)((
          //                 [7654321_]
          //                 [6543210]
           ((in[16 + inPos] & 127L) <<  1)
        | //                 [_______0]
          //                        [6______]
           ((in[17 + inPos] & 127L) >>> 6)) & 255);
      out[15 + outPos] = (byte)((
          //                 [765432__]
          //                [_543210]
           ((in[17 + inPos] & 127L) <<  2)
        | //                 [______10]
          //                       [65_____]
           ((in[18 + inPos] & 127L) >>> 5)) & 255);
      out[16 + outPos] = (byte)((
          //                 [76543___]
          //               [__43210]
           ((in[18 + inPos] & 127L) <<  3)
        | //                 [_____210]
          //                      [654____]
           ((in[19 + inPos] & 127L) >>> 4)) & 255);
      out[17 + outPos] = (byte)((
          //                 [7654____]
          //              [___3210]
           ((in[19 + inPos] & 127L) <<  4)
        | //                 [____3210]
          //                     [6543___]
           ((in[20 + inPos] & 127L) >>> 3)) & 255);
      out[18 + outPos] = (byte)((
          //                 [765_____]
          //             [____210]
           ((in[20 + inPos] & 127L) <<  5)
        | //                 [___43210]
          //                    [65432__]
           ((in[21 + inPos] & 127L) >>> 2)) & 255);
      out[19 + outPos] = (byte)((
          //                 [76______]
          //            [_____10]
           ((in[21 + inPos] & 127L) <<  6)
        | //                 [__543210]
          //                   [654321_]
           ((in[22 + inPos] & 127L) >>> 1)) & 255);
      out[20 + outPos] = (byte)((
          //                 [7_______]
          //           [______0]
           ((in[22 + inPos] & 127L) <<  7)
        | //                 [_6543210]
          //                  [6543210]
           ((in[23 + inPos] & 127L))) & 255);
      out[21 + outPos] = (byte)((
          //                 [7654321_]
          //                 [6543210]
           ((in[24 + inPos] & 127L) <<  1)
        | //                 [_______0]
          //                        [6______]
           ((in[25 + inPos] & 127L) >>> 6)) & 255);
      out[22 + outPos] = (byte)((
          //                 [765432__]
          //                [_543210]
           ((in[25 + inPos] & 127L) <<  2)
        | //                 [______10]
          //                       [65_____]
           ((in[26 + inPos] & 127L) >>> 5)) & 255);
      out[23 + outPos] = (byte)((
          //                 [76543___]
          //               [__43210]
           ((in[26 + inPos] & 127L) <<  3)
        | //                 [_____210]
          //                      [654____]
           ((in[27 + inPos] & 127L) >>> 4)) & 255);
      out[24 + outPos] = (byte)((
          //                 [7654____]
          //              [___3210]
           ((in[27 + inPos] & 127L) <<  4)
        | //                 [____3210]
          //                     [6543___]
           ((in[28 + inPos] & 127L) >>> 3)) & 255);
      out[25 + outPos] = (byte)((
          //                 [765_____]
          //             [____210]
           ((in[28 + inPos] & 127L) <<  5)
        | //                 [___43210]
          //                    [65432__]
           ((in[29 + inPos] & 127L) >>> 2)) & 255);
      out[26 + outPos] = (byte)((
          //                 [76______]
          //            [_____10]
           ((in[29 + inPos] & 127L) <<  6)
        | //                 [__543210]
          //                   [654321_]
           ((in[30 + inPos] & 127L) >>> 1)) & 255);
      out[27 + outPos] = (byte)((
          //                 [7_______]
          //           [______0]
           ((in[30 + inPos] & 127L) <<  7)
        | //                 [_6543210]
          //                  [6543210]
           ((in[31 + inPos] & 127L))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                 [7654321_]
          //                 [6543210]
            ((((long)in[ 0 + inPos]) >>  1) & 127L);
      out[ 1 + outPos] =
          //                 [_______0]
          //                        [6______]
            ((((long)in[ 0 + inPos]) <<  6) & 127L)
        | //                 [765432__]
          //                [_543210]
            ((((long)in[ 1 + inPos]) >>  2) & 63L);
      out[ 2 + outPos] =
          //                 [______10]
          //                       [65_____]
            ((((long)in[ 1 + inPos]) <<  5) & 127L)
        | //                 [76543___]
          //               [__43210]
            ((((long)in[ 2 + inPos]) >>  3) & 31L);
      out[ 3 + outPos] =
          //                 [_____210]
          //                      [654____]
            ((((long)in[ 2 + inPos]) <<  4) & 127L)
        | //                 [7654____]
          //              [___3210]
            ((((long)in[ 3 + inPos]) >>  4) & 15L);
      out[ 4 + outPos] =
          //                 [____3210]
          //                     [6543___]
            ((((long)in[ 3 + inPos]) <<  3) & 127L)
        | //                 [765_____]
          //             [____210]
            ((((long)in[ 4 + inPos]) >>  5) & 7L);
      out[ 5 + outPos] =
          //                 [___43210]
          //                    [65432__]
            ((((long)in[ 4 + inPos]) <<  2) & 127L)
        | //                 [76______]
          //            [_____10]
            ((((long)in[ 5 + inPos]) >>  6) & 3L);
      out[ 6 + outPos] =
          //                 [__543210]
          //                   [654321_]
            ((((long)in[ 5 + inPos]) <<  1) & 127L)
        | //                 [7_______]
          //           [______0]
            ((((long)in[ 6 + inPos]) >>  7) & 1L);
      out[ 7 + outPos] =
          //                 [_6543210]
          //                  [6543210]
            ((((long)in[ 6 + inPos]) ) & 127L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                 [7654321_]
          //                 [6543210]
            ((((long)in.get( 0 + inPos)) >>  1) & 127L);
      out[ 1 + outPos] =
          //                 [_______0]
          //                        [6______]
            ((((long)in.get( 0 + inPos)) <<  6) & 127L)
        | //                 [765432__]
          //                [_543210]
            ((((long)in.get( 1 + inPos)) >>  2) & 63L);
      out[ 2 + outPos] =
          //                 [______10]
          //                       [65_____]
            ((((long)in.get( 1 + inPos)) <<  5) & 127L)
        | //                 [76543___]
          //               [__43210]
            ((((long)in.get( 2 + inPos)) >>  3) & 31L);
      out[ 3 + outPos] =
          //                 [_____210]
          //                      [654____]
            ((((long)in.get( 2 + inPos)) <<  4) & 127L)
        | //                 [7654____]
          //              [___3210]
            ((((long)in.get( 3 + inPos)) >>  4) & 15L);
      out[ 4 + outPos] =
          //                 [____3210]
          //                     [6543___]
            ((((long)in.get( 3 + inPos)) <<  3) & 127L)
        | //                 [765_____]
          //             [____210]
            ((((long)in.get( 4 + inPos)) >>  5) & 7L);
      out[ 5 + outPos] =
          //                 [___43210]
          //                    [65432__]
            ((((long)in.get( 4 + inPos)) <<  2) & 127L)
        | //                 [76______]
          //            [_____10]
            ((((long)in.get( 5 + inPos)) >>  6) & 3L);
      out[ 6 + outPos] =
          //                 [__543210]
          //                   [654321_]
            ((((long)in.get( 5 + inPos)) <<  1) & 127L)
        | //                 [7_______]
          //           [______0]
            ((((long)in.get( 6 + inPos)) >>  7) & 1L);
      out[ 7 + outPos] =
          //                 [_6543210]
          //                  [6543210]
            ((((long)in.get( 6 + inPos)) ) & 127L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                 [7654321_]
          //                 [6543210]
            ((((long)in[ 0 + inPos]) >>  1) & 127L);
      out[ 1 + outPos] =
          //                 [_______0]
          //                        [6______]
            ((((long)in[ 0 + inPos]) <<  6) & 127L)
        | //                 [765432__]
          //                [_543210]
            ((((long)in[ 1 + inPos]) >>  2) & 63L);
      out[ 2 + outPos] =
          //                 [______10]
          //                       [65_____]
            ((((long)in[ 1 + inPos]) <<  5) & 127L)
        | //                 [76543___]
          //               [__43210]
            ((((long)in[ 2 + inPos]) >>  3) & 31L);
      out[ 3 + outPos] =
          //                 [_____210]
          //                      [654____]
            ((((long)in[ 2 + inPos]) <<  4) & 127L)
        | //                 [7654____]
          //              [___3210]
            ((((long)in[ 3 + inPos]) >>  4) & 15L);
      out[ 4 + outPos] =
          //                 [____3210]
          //                     [6543___]
            ((((long)in[ 3 + inPos]) <<  3) & 127L)
        | //                 [765_____]
          //             [____210]
            ((((long)in[ 4 + inPos]) >>  5) & 7L);
      out[ 5 + outPos] =
          //                 [___43210]
          //                    [65432__]
            ((((long)in[ 4 + inPos]) <<  2) & 127L)
        | //                 [76______]
          //            [_____10]
            ((((long)in[ 5 + inPos]) >>  6) & 3L);
      out[ 6 + outPos] =
          //                 [__543210]
          //                   [654321_]
            ((((long)in[ 5 + inPos]) <<  1) & 127L)
        | //                 [7_______]
          //           [______0]
            ((((long)in[ 6 + inPos]) >>  7) & 1L);
      out[ 7 + outPos] =
          //                 [_6543210]
          //                  [6543210]
            ((((long)in[ 6 + inPos]) ) & 127L);
      out[ 8 + outPos] =
          //                 [7654321_]
          //                 [6543210]
            ((((long)in[ 7 + inPos]) >>  1) & 127L);
      out[ 9 + outPos] =
          //                 [_______0]
          //                        [6______]
            ((((long)in[ 7 + inPos]) <<  6) & 127L)
        | //                 [765432__]
          //                [_543210]
            ((((long)in[ 8 + inPos]) >>  2) & 63L);
      out[10 + outPos] =
          //                 [______10]
          //                       [65_____]
            ((((long)in[ 8 + inPos]) <<  5) & 127L)
        | //                 [76543___]
          //               [__43210]
            ((((long)in[ 9 + inPos]) >>  3) & 31L);
      out[11 + outPos] =
          //                 [_____210]
          //                      [654____]
            ((((long)in[ 9 + inPos]) <<  4) & 127L)
        | //                 [7654____]
          //              [___3210]
            ((((long)in[10 + inPos]) >>  4) & 15L);
      out[12 + outPos] =
          //                 [____3210]
          //                     [6543___]
            ((((long)in[10 + inPos]) <<  3) & 127L)
        | //                 [765_____]
          //             [____210]
            ((((long)in[11 + inPos]) >>  5) & 7L);
      out[13 + outPos] =
          //                 [___43210]
          //                    [65432__]
            ((((long)in[11 + inPos]) <<  2) & 127L)
        | //                 [76______]
          //            [_____10]
            ((((long)in[12 + inPos]) >>  6) & 3L);
      out[14 + outPos] =
          //                 [__543210]
          //                   [654321_]
            ((((long)in[12 + inPos]) <<  1) & 127L)
        | //                 [7_______]
          //           [______0]
            ((((long)in[13 + inPos]) >>  7) & 1L);
      out[15 + outPos] =
          //                 [_6543210]
          //                  [6543210]
            ((((long)in[13 + inPos]) ) & 127L);
      out[16 + outPos] =
          //                 [7654321_]
          //                 [6543210]
            ((((long)in[14 + inPos]) >>  1) & 127L);
      out[17 + outPos] =
          //                 [_______0]
          //                        [6______]
            ((((long)in[14 + inPos]) <<  6) & 127L)
        | //                 [765432__]
          //                [_543210]
            ((((long)in[15 + inPos]) >>  2) & 63L);
      out[18 + outPos] =
          //                 [______10]
          //                       [65_____]
            ((((long)in[15 + inPos]) <<  5) & 127L)
        | //                 [76543___]
          //               [__43210]
            ((((long)in[16 + inPos]) >>  3) & 31L);
      out[19 + outPos] =
          //                 [_____210]
          //                      [654____]
            ((((long)in[16 + inPos]) <<  4) & 127L)
        | //                 [7654____]
          //              [___3210]
            ((((long)in[17 + inPos]) >>  4) & 15L);
      out[20 + outPos] =
          //                 [____3210]
          //                     [6543___]
            ((((long)in[17 + inPos]) <<  3) & 127L)
        | //                 [765_____]
          //             [____210]
            ((((long)in[18 + inPos]) >>  5) & 7L);
      out[21 + outPos] =
          //                 [___43210]
          //                    [65432__]
            ((((long)in[18 + inPos]) <<  2) & 127L)
        | //                 [76______]
          //            [_____10]
            ((((long)in[19 + inPos]) >>  6) & 3L);
      out[22 + outPos] =
          //                 [__543210]
          //                   [654321_]
            ((((long)in[19 + inPos]) <<  1) & 127L)
        | //                 [7_______]
          //           [______0]
            ((((long)in[20 + inPos]) >>  7) & 1L);
      out[23 + outPos] =
          //                 [_6543210]
          //                  [6543210]
            ((((long)in[20 + inPos]) ) & 127L);
      out[24 + outPos] =
          //                 [7654321_]
          //                 [6543210]
            ((((long)in[21 + inPos]) >>  1) & 127L);
      out[25 + outPos] =
          //                 [_______0]
          //                        [6______]
            ((((long)in[21 + inPos]) <<  6) & 127L)
        | //                 [765432__]
          //                [_543210]
            ((((long)in[22 + inPos]) >>  2) & 63L);
      out[26 + outPos] =
          //                 [______10]
          //                       [65_____]
            ((((long)in[22 + inPos]) <<  5) & 127L)
        | //                 [76543___]
          //               [__43210]
            ((((long)in[23 + inPos]) >>  3) & 31L);
      out[27 + outPos] =
          //                 [_____210]
          //                      [654____]
            ((((long)in[23 + inPos]) <<  4) & 127L)
        | //                 [7654____]
          //              [___3210]
            ((((long)in[24 + inPos]) >>  4) & 15L);
      out[28 + outPos] =
          //                 [____3210]
          //                     [6543___]
            ((((long)in[24 + inPos]) <<  3) & 127L)
        | //                 [765_____]
          //             [____210]
            ((((long)in[25 + inPos]) >>  5) & 7L);
      out[29 + outPos] =
          //                 [___43210]
          //                    [65432__]
            ((((long)in[25 + inPos]) <<  2) & 127L)
        | //                 [76______]
          //            [_____10]
            ((((long)in[26 + inPos]) >>  6) & 3L);
      out[30 + outPos] =
          //                 [__543210]
          //                   [654321_]
            ((((long)in[26 + inPos]) <<  1) & 127L)
        | //                 [7_______]
          //           [______0]
            ((((long)in[27 + inPos]) >>  7) & 1L);
      out[31 + outPos] =
          //                 [_6543210]
          //                  [6543210]
            ((((long)in[27 + inPos]) ) & 127L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                 [7654321_]
          //                 [6543210]
            ((((long)in.get( 0 + inPos)) >>  1) & 127L);
      out[ 1 + outPos] =
          //                 [_______0]
          //                        [6______]
            ((((long)in.get( 0 + inPos)) <<  6) & 127L)
        | //                 [765432__]
          //                [_543210]
            ((((long)in.get( 1 + inPos)) >>  2) & 63L);
      out[ 2 + outPos] =
          //                 [______10]
          //                       [65_____]
            ((((long)in.get( 1 + inPos)) <<  5) & 127L)
        | //                 [76543___]
          //               [__43210]
            ((((long)in.get( 2 + inPos)) >>  3) & 31L);
      out[ 3 + outPos] =
          //                 [_____210]
          //                      [654____]
            ((((long)in.get( 2 + inPos)) <<  4) & 127L)
        | //                 [7654____]
          //              [___3210]
            ((((long)in.get( 3 + inPos)) >>  4) & 15L);
      out[ 4 + outPos] =
          //                 [____3210]
          //                     [6543___]
            ((((long)in.get( 3 + inPos)) <<  3) & 127L)
        | //                 [765_____]
          //             [____210]
            ((((long)in.get( 4 + inPos)) >>  5) & 7L);
      out[ 5 + outPos] =
          //                 [___43210]
          //                    [65432__]
            ((((long)in.get( 4 + inPos)) <<  2) & 127L)
        | //                 [76______]
          //            [_____10]
            ((((long)in.get( 5 + inPos)) >>  6) & 3L);
      out[ 6 + outPos] =
          //                 [__543210]
          //                   [654321_]
            ((((long)in.get( 5 + inPos)) <<  1) & 127L)
        | //                 [7_______]
          //           [______0]
            ((((long)in.get( 6 + inPos)) >>  7) & 1L);
      out[ 7 + outPos] =
          //                 [_6543210]
          //                  [6543210]
            ((((long)in.get( 6 + inPos)) ) & 127L);
      out[ 8 + outPos] =
          //                 [7654321_]
          //                 [6543210]
            ((((long)in.get( 7 + inPos)) >>  1) & 127L);
      out[ 9 + outPos] =
          //                 [_______0]
          //                        [6______]
            ((((long)in.get( 7 + inPos)) <<  6) & 127L)
        | //                 [765432__]
          //                [_543210]
            ((((long)in.get( 8 + inPos)) >>  2) & 63L);
      out[10 + outPos] =
          //                 [______10]
          //                       [65_____]
            ((((long)in.get( 8 + inPos)) <<  5) & 127L)
        | //                 [76543___]
          //               [__43210]
            ((((long)in.get( 9 + inPos)) >>  3) & 31L);
      out[11 + outPos] =
          //                 [_____210]
          //                      [654____]
            ((((long)in.get( 9 + inPos)) <<  4) & 127L)
        | //                 [7654____]
          //              [___3210]
            ((((long)in.get(10 + inPos)) >>  4) & 15L);
      out[12 + outPos] =
          //                 [____3210]
          //                     [6543___]
            ((((long)in.get(10 + inPos)) <<  3) & 127L)
        | //                 [765_____]
          //             [____210]
            ((((long)in.get(11 + inPos)) >>  5) & 7L);
      out[13 + outPos] =
          //                 [___43210]
          //                    [65432__]
            ((((long)in.get(11 + inPos)) <<  2) & 127L)
        | //                 [76______]
          //            [_____10]
            ((((long)in.get(12 + inPos)) >>  6) & 3L);
      out[14 + outPos] =
          //                 [__543210]
          //                   [654321_]
            ((((long)in.get(12 + inPos)) <<  1) & 127L)
        | //                 [7_______]
          //           [______0]
            ((((long)in.get(13 + inPos)) >>  7) & 1L);
      out[15 + outPos] =
          //                 [_6543210]
          //                  [6543210]
            ((((long)in.get(13 + inPos)) ) & 127L);
      out[16 + outPos] =
          //                 [7654321_]
          //                 [6543210]
            ((((long)in.get(14 + inPos)) >>  1) & 127L);
      out[17 + outPos] =
          //                 [_______0]
          //                        [6______]
            ((((long)in.get(14 + inPos)) <<  6) & 127L)
        | //                 [765432__]
          //                [_543210]
            ((((long)in.get(15 + inPos)) >>  2) & 63L);
      out[18 + outPos] =
          //                 [______10]
          //                       [65_____]
            ((((long)in.get(15 + inPos)) <<  5) & 127L)
        | //                 [76543___]
          //               [__43210]
            ((((long)in.get(16 + inPos)) >>  3) & 31L);
      out[19 + outPos] =
          //                 [_____210]
          //                      [654____]
            ((((long)in.get(16 + inPos)) <<  4) & 127L)
        | //                 [7654____]
          //              [___3210]
            ((((long)in.get(17 + inPos)) >>  4) & 15L);
      out[20 + outPos] =
          //                 [____3210]
          //                     [6543___]
            ((((long)in.get(17 + inPos)) <<  3) & 127L)
        | //                 [765_____]
          //             [____210]
            ((((long)in.get(18 + inPos)) >>  5) & 7L);
      out[21 + outPos] =
          //                 [___43210]
          //                    [65432__]
            ((((long)in.get(18 + inPos)) <<  2) & 127L)
        | //                 [76______]
          //            [_____10]
            ((((long)in.get(19 + inPos)) >>  6) & 3L);
      out[22 + outPos] =
          //                 [__543210]
          //                   [654321_]
            ((((long)in.get(19 + inPos)) <<  1) & 127L)
        | //                 [7_______]
          //           [______0]
            ((((long)in.get(20 + inPos)) >>  7) & 1L);
      out[23 + outPos] =
          //                 [_6543210]
          //                  [6543210]
            ((((long)in.get(20 + inPos)) ) & 127L);
      out[24 + outPos] =
          //                 [7654321_]
          //                 [6543210]
            ((((long)in.get(21 + inPos)) >>  1) & 127L);
      out[25 + outPos] =
          //                 [_______0]
          //                        [6______]
            ((((long)in.get(21 + inPos)) <<  6) & 127L)
        | //                 [765432__]
          //                [_543210]
            ((((long)in.get(22 + inPos)) >>  2) & 63L);
      out[26 + outPos] =
          //                 [______10]
          //                       [65_____]
            ((((long)in.get(22 + inPos)) <<  5) & 127L)
        | //                 [76543___]
          //               [__43210]
            ((((long)in.get(23 + inPos)) >>  3) & 31L);
      out[27 + outPos] =
          //                 [_____210]
          //                      [654____]
            ((((long)in.get(23 + inPos)) <<  4) & 127L)
        | //                 [7654____]
          //              [___3210]
            ((((long)in.get(24 + inPos)) >>  4) & 15L);
      out[28 + outPos] =
          //                 [____3210]
          //                     [6543___]
            ((((long)in.get(24 + inPos)) <<  3) & 127L)
        | //                 [765_____]
          //             [____210]
            ((((long)in.get(25 + inPos)) >>  5) & 7L);
      out[29 + outPos] =
          //                 [___43210]
          //                    [65432__]
            ((((long)in.get(25 + inPos)) <<  2) & 127L)
        | //                 [76______]
          //            [_____10]
            ((((long)in.get(26 + inPos)) >>  6) & 3L);
      out[30 + outPos] =
          //                 [__543210]
          //                   [654321_]
            ((((long)in.get(26 + inPos)) <<  1) & 127L)
        | //                 [7_______]
          //           [______0]
            ((((long)in.get(27 + inPos)) >>  7) & 1L);
      out[31 + outPos] =
          //                 [_6543210]
          //                  [6543210]
            ((((long)in.get(27 + inPos)) ) & 127L);
    }
  }

  private static final class Packer8 extends BytePackerForLong {

    private Packer8() {
      super(8);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 0 + inPos] & 255L))) & 255);
      out[ 1 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 1 + inPos] & 255L))) & 255);
      out[ 2 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 2 + inPos] & 255L))) & 255);
      out[ 3 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 3 + inPos] & 255L))) & 255);
      out[ 4 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 4 + inPos] & 255L))) & 255);
      out[ 5 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 5 + inPos] & 255L))) & 255);
      out[ 6 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 6 + inPos] & 255L))) & 255);
      out[ 7 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 7 + inPos] & 255L))) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 0 + inPos] & 255L))) & 255);
      out[ 1 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 1 + inPos] & 255L))) & 255);
      out[ 2 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 2 + inPos] & 255L))) & 255);
      out[ 3 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 3 + inPos] & 255L))) & 255);
      out[ 4 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 4 + inPos] & 255L))) & 255);
      out[ 5 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 5 + inPos] & 255L))) & 255);
      out[ 6 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 6 + inPos] & 255L))) & 255);
      out[ 7 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 7 + inPos] & 255L))) & 255);
      out[ 8 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 8 + inPos] & 255L))) & 255);
      out[ 9 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 9 + inPos] & 255L))) & 255);
      out[10 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[10 + inPos] & 255L))) & 255);
      out[11 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[11 + inPos] & 255L))) & 255);
      out[12 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[12 + inPos] & 255L))) & 255);
      out[13 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[13 + inPos] & 255L))) & 255);
      out[14 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[14 + inPos] & 255L))) & 255);
      out[15 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[15 + inPos] & 255L))) & 255);
      out[16 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[16 + inPos] & 255L))) & 255);
      out[17 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[17 + inPos] & 255L))) & 255);
      out[18 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[18 + inPos] & 255L))) & 255);
      out[19 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[19 + inPos] & 255L))) & 255);
      out[20 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[20 + inPos] & 255L))) & 255);
      out[21 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[21 + inPos] & 255L))) & 255);
      out[22 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[22 + inPos] & 255L))) & 255);
      out[23 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[23 + inPos] & 255L))) & 255);
      out[24 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[24 + inPos] & 255L))) & 255);
      out[25 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[25 + inPos] & 255L))) & 255);
      out[26 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[26 + inPos] & 255L))) & 255);
      out[27 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[27 + inPos] & 255L))) & 255);
      out[28 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[28 + inPos] & 255L))) & 255);
      out[29 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[29 + inPos] & 255L))) & 255);
      out[30 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[30 + inPos] & 255L))) & 255);
      out[31 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[31 + inPos] & 255L))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[ 0 + inPos]) ) & 255L);
      out[ 1 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[ 1 + inPos]) ) & 255L);
      out[ 2 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[ 2 + inPos]) ) & 255L);
      out[ 3 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[ 3 + inPos]) ) & 255L);
      out[ 4 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[ 4 + inPos]) ) & 255L);
      out[ 5 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[ 5 + inPos]) ) & 255L);
      out[ 6 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[ 6 + inPos]) ) & 255L);
      out[ 7 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[ 7 + inPos]) ) & 255L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get( 0 + inPos)) ) & 255L);
      out[ 1 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get( 1 + inPos)) ) & 255L);
      out[ 2 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get( 2 + inPos)) ) & 255L);
      out[ 3 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get( 3 + inPos)) ) & 255L);
      out[ 4 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get( 4 + inPos)) ) & 255L);
      out[ 5 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get( 5 + inPos)) ) & 255L);
      out[ 6 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get( 6 + inPos)) ) & 255L);
      out[ 7 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get( 7 + inPos)) ) & 255L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[ 0 + inPos]) ) & 255L);
      out[ 1 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[ 1 + inPos]) ) & 255L);
      out[ 2 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[ 2 + inPos]) ) & 255L);
      out[ 3 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[ 3 + inPos]) ) & 255L);
      out[ 4 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[ 4 + inPos]) ) & 255L);
      out[ 5 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[ 5 + inPos]) ) & 255L);
      out[ 6 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[ 6 + inPos]) ) & 255L);
      out[ 7 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[ 7 + inPos]) ) & 255L);
      out[ 8 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[ 8 + inPos]) ) & 255L);
      out[ 9 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[ 9 + inPos]) ) & 255L);
      out[10 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[10 + inPos]) ) & 255L);
      out[11 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[11 + inPos]) ) & 255L);
      out[12 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[12 + inPos]) ) & 255L);
      out[13 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[13 + inPos]) ) & 255L);
      out[14 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[14 + inPos]) ) & 255L);
      out[15 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[15 + inPos]) ) & 255L);
      out[16 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[16 + inPos]) ) & 255L);
      out[17 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[17 + inPos]) ) & 255L);
      out[18 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[18 + inPos]) ) & 255L);
      out[19 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[19 + inPos]) ) & 255L);
      out[20 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[20 + inPos]) ) & 255L);
      out[21 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[21 + inPos]) ) & 255L);
      out[22 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[22 + inPos]) ) & 255L);
      out[23 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[23 + inPos]) ) & 255L);
      out[24 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[24 + inPos]) ) & 255L);
      out[25 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[25 + inPos]) ) & 255L);
      out[26 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[26 + inPos]) ) & 255L);
      out[27 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[27 + inPos]) ) & 255L);
      out[28 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[28 + inPos]) ) & 255L);
      out[29 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[29 + inPos]) ) & 255L);
      out[30 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[30 + inPos]) ) & 255L);
      out[31 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in[31 + inPos]) ) & 255L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get( 0 + inPos)) ) & 255L);
      out[ 1 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get( 1 + inPos)) ) & 255L);
      out[ 2 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get( 2 + inPos)) ) & 255L);
      out[ 3 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get( 3 + inPos)) ) & 255L);
      out[ 4 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get( 4 + inPos)) ) & 255L);
      out[ 5 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get( 5 + inPos)) ) & 255L);
      out[ 6 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get( 6 + inPos)) ) & 255L);
      out[ 7 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get( 7 + inPos)) ) & 255L);
      out[ 8 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get( 8 + inPos)) ) & 255L);
      out[ 9 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get( 9 + inPos)) ) & 255L);
      out[10 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(10 + inPos)) ) & 255L);
      out[11 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(11 + inPos)) ) & 255L);
      out[12 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(12 + inPos)) ) & 255L);
      out[13 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(13 + inPos)) ) & 255L);
      out[14 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(14 + inPos)) ) & 255L);
      out[15 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(15 + inPos)) ) & 255L);
      out[16 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(16 + inPos)) ) & 255L);
      out[17 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(17 + inPos)) ) & 255L);
      out[18 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(18 + inPos)) ) & 255L);
      out[19 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(19 + inPos)) ) & 255L);
      out[20 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(20 + inPos)) ) & 255L);
      out[21 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(21 + inPos)) ) & 255L);
      out[22 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(22 + inPos)) ) & 255L);
      out[23 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(23 + inPos)) ) & 255L);
      out[24 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(24 + inPos)) ) & 255L);
      out[25 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(25 + inPos)) ) & 255L);
      out[26 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(26 + inPos)) ) & 255L);
      out[27 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(27 + inPos)) ) & 255L);
      out[28 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(28 + inPos)) ) & 255L);
      out[29 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(29 + inPos)) ) & 255L);
      out[30 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(30 + inPos)) ) & 255L);
      out[31 + outPos] =
          //                  [76543210]
          //                  [76543210]
            ((((long)in.get(31 + inPos)) ) & 255L);
    }
  }

  private static final class Packer9 extends BytePackerForLong {

    private Packer9() {
      super(9);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                   [76543210]
          //                   [87654321_]
           ((in[ 0 + inPos] & 511L) >>> 1)) & 255);
      out[ 1 + outPos] = (byte)((
          //                   [7_______]
          //           [________0]
           ((in[ 0 + inPos] & 511L) <<  7)
        | //                   [_6543210]
          //                    [8765432__]
           ((in[ 1 + inPos] & 511L) >>> 2)) & 255);
      out[ 2 + outPos] = (byte)((
          //                   [76______]
          //            [_______10]
           ((in[ 1 + inPos] & 511L) <<  6)
        | //                   [__543210]
          //                     [876543___]
           ((in[ 2 + inPos] & 511L) >>> 3)) & 255);
      out[ 3 + outPos] = (byte)((
          //                   [765_____]
          //             [______210]
           ((in[ 2 + inPos] & 511L) <<  5)
        | //                   [___43210]
          //                      [87654____]
           ((in[ 3 + inPos] & 511L) >>> 4)) & 255);
      out[ 4 + outPos] = (byte)((
          //                   [7654____]
          //              [_____3210]
           ((in[ 3 + inPos] & 511L) <<  4)
        | //                   [____3210]
          //                       [8765_____]
           ((in[ 4 + inPos] & 511L) >>> 5)) & 255);
      out[ 5 + outPos] = (byte)((
          //                   [76543___]
          //               [____43210]
           ((in[ 4 + inPos] & 511L) <<  3)
        | //                   [_____210]
          //                        [876______]
           ((in[ 5 + inPos] & 511L) >>> 6)) & 255);
      out[ 6 + outPos] = (byte)((
          //                   [765432__]
          //                [___543210]
           ((in[ 5 + inPos] & 511L) <<  2)
        | //                   [______10]
          //                         [87_______]
           ((in[ 6 + inPos] & 511L) >>> 7)) & 255);
      out[ 7 + outPos] = (byte)((
          //                   [7654321_]
          //                 [__6543210]
           ((in[ 6 + inPos] & 511L) <<  1)
        | //                   [_______0]
          //                          [8________]
           ((in[ 7 + inPos] & 511L) >>> 8)) & 255);
      out[ 8 + outPos] = (byte)((
          //                   [76543210]
          //                  [_76543210]
           ((in[ 7 + inPos] & 511L))) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                   [76543210]
          //                   [87654321_]
           ((in[ 0 + inPos] & 511L) >>> 1)) & 255);
      out[ 1 + outPos] = (byte)((
          //                   [7_______]
          //           [________0]
           ((in[ 0 + inPos] & 511L) <<  7)
        | //                   [_6543210]
          //                    [8765432__]
           ((in[ 1 + inPos] & 511L) >>> 2)) & 255);
      out[ 2 + outPos] = (byte)((
          //                   [76______]
          //            [_______10]
           ((in[ 1 + inPos] & 511L) <<  6)
        | //                   [__543210]
          //                     [876543___]
           ((in[ 2 + inPos] & 511L) >>> 3)) & 255);
      out[ 3 + outPos] = (byte)((
          //                   [765_____]
          //             [______210]
           ((in[ 2 + inPos] & 511L) <<  5)
        | //                   [___43210]
          //                      [87654____]
           ((in[ 3 + inPos] & 511L) >>> 4)) & 255);
      out[ 4 + outPos] = (byte)((
          //                   [7654____]
          //              [_____3210]
           ((in[ 3 + inPos] & 511L) <<  4)
        | //                   [____3210]
          //                       [8765_____]
           ((in[ 4 + inPos] & 511L) >>> 5)) & 255);
      out[ 5 + outPos] = (byte)((
          //                   [76543___]
          //               [____43210]
           ((in[ 4 + inPos] & 511L) <<  3)
        | //                   [_____210]
          //                        [876______]
           ((in[ 5 + inPos] & 511L) >>> 6)) & 255);
      out[ 6 + outPos] = (byte)((
          //                   [765432__]
          //                [___543210]
           ((in[ 5 + inPos] & 511L) <<  2)
        | //                   [______10]
          //                         [87_______]
           ((in[ 6 + inPos] & 511L) >>> 7)) & 255);
      out[ 7 + outPos] = (byte)((
          //                   [7654321_]
          //                 [__6543210]
           ((in[ 6 + inPos] & 511L) <<  1)
        | //                   [_______0]
          //                          [8________]
           ((in[ 7 + inPos] & 511L) >>> 8)) & 255);
      out[ 8 + outPos] = (byte)((
          //                   [76543210]
          //                  [_76543210]
           ((in[ 7 + inPos] & 511L))) & 255);
      out[ 9 + outPos] = (byte)((
          //                   [76543210]
          //                   [87654321_]
           ((in[ 8 + inPos] & 511L) >>> 1)) & 255);
      out[10 + outPos] = (byte)((
          //                   [7_______]
          //           [________0]
           ((in[ 8 + inPos] & 511L) <<  7)
        | //                   [_6543210]
          //                    [8765432__]
           ((in[ 9 + inPos] & 511L) >>> 2)) & 255);
      out[11 + outPos] = (byte)((
          //                   [76______]
          //            [_______10]
           ((in[ 9 + inPos] & 511L) <<  6)
        | //                   [__543210]
          //                     [876543___]
           ((in[10 + inPos] & 511L) >>> 3)) & 255);
      out[12 + outPos] = (byte)((
          //                   [765_____]
          //             [______210]
           ((in[10 + inPos] & 511L) <<  5)
        | //                   [___43210]
          //                      [87654____]
           ((in[11 + inPos] & 511L) >>> 4)) & 255);
      out[13 + outPos] = (byte)((
          //                   [7654____]
          //              [_____3210]
           ((in[11 + inPos] & 511L) <<  4)
        | //                   [____3210]
          //                       [8765_____]
           ((in[12 + inPos] & 511L) >>> 5)) & 255);
      out[14 + outPos] = (byte)((
          //                   [76543___]
          //               [____43210]
           ((in[12 + inPos] & 511L) <<  3)
        | //                   [_____210]
          //                        [876______]
           ((in[13 + inPos] & 511L) >>> 6)) & 255);
      out[15 + outPos] = (byte)((
          //                   [765432__]
          //                [___543210]
           ((in[13 + inPos] & 511L) <<  2)
        | //                   [______10]
          //                         [87_______]
           ((in[14 + inPos] & 511L) >>> 7)) & 255);
      out[16 + outPos] = (byte)((
          //                   [7654321_]
          //                 [__6543210]
           ((in[14 + inPos] & 511L) <<  1)
        | //                   [_______0]
          //                          [8________]
           ((in[15 + inPos] & 511L) >>> 8)) & 255);
      out[17 + outPos] = (byte)((
          //                   [76543210]
          //                  [_76543210]
           ((in[15 + inPos] & 511L))) & 255);
      out[18 + outPos] = (byte)((
          //                   [76543210]
          //                   [87654321_]
           ((in[16 + inPos] & 511L) >>> 1)) & 255);
      out[19 + outPos] = (byte)((
          //                   [7_______]
          //           [________0]
           ((in[16 + inPos] & 511L) <<  7)
        | //                   [_6543210]
          //                    [8765432__]
           ((in[17 + inPos] & 511L) >>> 2)) & 255);
      out[20 + outPos] = (byte)((
          //                   [76______]
          //            [_______10]
           ((in[17 + inPos] & 511L) <<  6)
        | //                   [__543210]
          //                     [876543___]
           ((in[18 + inPos] & 511L) >>> 3)) & 255);
      out[21 + outPos] = (byte)((
          //                   [765_____]
          //             [______210]
           ((in[18 + inPos] & 511L) <<  5)
        | //                   [___43210]
          //                      [87654____]
           ((in[19 + inPos] & 511L) >>> 4)) & 255);
      out[22 + outPos] = (byte)((
          //                   [7654____]
          //              [_____3210]
           ((in[19 + inPos] & 511L) <<  4)
        | //                   [____3210]
          //                       [8765_____]
           ((in[20 + inPos] & 511L) >>> 5)) & 255);
      out[23 + outPos] = (byte)((
          //                   [76543___]
          //               [____43210]
           ((in[20 + inPos] & 511L) <<  3)
        | //                   [_____210]
          //                        [876______]
           ((in[21 + inPos] & 511L) >>> 6)) & 255);
      out[24 + outPos] = (byte)((
          //                   [765432__]
          //                [___543210]
           ((in[21 + inPos] & 511L) <<  2)
        | //                   [______10]
          //                         [87_______]
           ((in[22 + inPos] & 511L) >>> 7)) & 255);
      out[25 + outPos] = (byte)((
          //                   [7654321_]
          //                 [__6543210]
           ((in[22 + inPos] & 511L) <<  1)
        | //                   [_______0]
          //                          [8________]
           ((in[23 + inPos] & 511L) >>> 8)) & 255);
      out[26 + outPos] = (byte)((
          //                   [76543210]
          //                  [_76543210]
           ((in[23 + inPos] & 511L))) & 255);
      out[27 + outPos] = (byte)((
          //                   [76543210]
          //                   [87654321_]
           ((in[24 + inPos] & 511L) >>> 1)) & 255);
      out[28 + outPos] = (byte)((
          //                   [7_______]
          //           [________0]
           ((in[24 + inPos] & 511L) <<  7)
        | //                   [_6543210]
          //                    [8765432__]
           ((in[25 + inPos] & 511L) >>> 2)) & 255);
      out[29 + outPos] = (byte)((
          //                   [76______]
          //            [_______10]
           ((in[25 + inPos] & 511L) <<  6)
        | //                   [__543210]
          //                     [876543___]
           ((in[26 + inPos] & 511L) >>> 3)) & 255);
      out[30 + outPos] = (byte)((
          //                   [765_____]
          //             [______210]
           ((in[26 + inPos] & 511L) <<  5)
        | //                   [___43210]
          //                      [87654____]
           ((in[27 + inPos] & 511L) >>> 4)) & 255);
      out[31 + outPos] = (byte)((
          //                   [7654____]
          //              [_____3210]
           ((in[27 + inPos] & 511L) <<  4)
        | //                   [____3210]
          //                       [8765_____]
           ((in[28 + inPos] & 511L) >>> 5)) & 255);
      out[32 + outPos] = (byte)((
          //                   [76543___]
          //               [____43210]
           ((in[28 + inPos] & 511L) <<  3)
        | //                   [_____210]
          //                        [876______]
           ((in[29 + inPos] & 511L) >>> 6)) & 255);
      out[33 + outPos] = (byte)((
          //                   [765432__]
          //                [___543210]
           ((in[29 + inPos] & 511L) <<  2)
        | //                   [______10]
          //                         [87_______]
           ((in[30 + inPos] & 511L) >>> 7)) & 255);
      out[34 + outPos] = (byte)((
          //                   [7654321_]
          //                 [__6543210]
           ((in[30 + inPos] & 511L) <<  1)
        | //                   [_______0]
          //                          [8________]
           ((in[31 + inPos] & 511L) >>> 8)) & 255);
      out[35 + outPos] = (byte)((
          //                   [76543210]
          //                  [_76543210]
           ((in[31 + inPos] & 511L))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                   [76543210]
          //                   [87654321_]
            ((((long)in[ 0 + inPos]) <<  1) & 511L)
        | //                   [7_______]
          //           [________0]
            ((((long)in[ 1 + inPos]) >>  7) & 1L);
      out[ 1 + outPos] =
          //                   [_6543210]
          //                    [8765432__]
            ((((long)in[ 1 + inPos]) <<  2) & 511L)
        | //                   [76______]
          //            [_______10]
            ((((long)in[ 2 + inPos]) >>  6) & 3L);
      out[ 2 + outPos] =
          //                   [__543210]
          //                     [876543___]
            ((((long)in[ 2 + inPos]) <<  3) & 511L)
        | //                   [765_____]
          //             [______210]
            ((((long)in[ 3 + inPos]) >>  5) & 7L);
      out[ 3 + outPos] =
          //                   [___43210]
          //                      [87654____]
            ((((long)in[ 3 + inPos]) <<  4) & 511L)
        | //                   [7654____]
          //              [_____3210]
            ((((long)in[ 4 + inPos]) >>  4) & 15L);
      out[ 4 + outPos] =
          //                   [____3210]
          //                       [8765_____]
            ((((long)in[ 4 + inPos]) <<  5) & 511L)
        | //                   [76543___]
          //               [____43210]
            ((((long)in[ 5 + inPos]) >>  3) & 31L);
      out[ 5 + outPos] =
          //                   [_____210]
          //                        [876______]
            ((((long)in[ 5 + inPos]) <<  6) & 511L)
        | //                   [765432__]
          //                [___543210]
            ((((long)in[ 6 + inPos]) >>  2) & 63L);
      out[ 6 + outPos] =
          //                   [______10]
          //                         [87_______]
            ((((long)in[ 6 + inPos]) <<  7) & 511L)
        | //                   [7654321_]
          //                 [__6543210]
            ((((long)in[ 7 + inPos]) >>  1) & 127L);
      out[ 7 + outPos] =
          //                   [_______0]
          //                          [8________]
            ((((long)in[ 7 + inPos]) <<  8) & 511L)
        | //                   [76543210]
          //                  [_76543210]
            ((((long)in[ 8 + inPos]) ) & 255L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                   [76543210]
          //                   [87654321_]
            ((((long)in.get( 0 + inPos)) <<  1) & 511L)
        | //                   [7_______]
          //           [________0]
            ((((long)in.get( 1 + inPos)) >>  7) & 1L);
      out[ 1 + outPos] =
          //                   [_6543210]
          //                    [8765432__]
            ((((long)in.get( 1 + inPos)) <<  2) & 511L)
        | //                   [76______]
          //            [_______10]
            ((((long)in.get( 2 + inPos)) >>  6) & 3L);
      out[ 2 + outPos] =
          //                   [__543210]
          //                     [876543___]
            ((((long)in.get( 2 + inPos)) <<  3) & 511L)
        | //                   [765_____]
          //             [______210]
            ((((long)in.get( 3 + inPos)) >>  5) & 7L);
      out[ 3 + outPos] =
          //                   [___43210]
          //                      [87654____]
            ((((long)in.get( 3 + inPos)) <<  4) & 511L)
        | //                   [7654____]
          //              [_____3210]
            ((((long)in.get( 4 + inPos)) >>  4) & 15L);
      out[ 4 + outPos] =
          //                   [____3210]
          //                       [8765_____]
            ((((long)in.get( 4 + inPos)) <<  5) & 511L)
        | //                   [76543___]
          //               [____43210]
            ((((long)in.get( 5 + inPos)) >>  3) & 31L);
      out[ 5 + outPos] =
          //                   [_____210]
          //                        [876______]
            ((((long)in.get( 5 + inPos)) <<  6) & 511L)
        | //                   [765432__]
          //                [___543210]
            ((((long)in.get( 6 + inPos)) >>  2) & 63L);
      out[ 6 + outPos] =
          //                   [______10]
          //                         [87_______]
            ((((long)in.get( 6 + inPos)) <<  7) & 511L)
        | //                   [7654321_]
          //                 [__6543210]
            ((((long)in.get( 7 + inPos)) >>  1) & 127L);
      out[ 7 + outPos] =
          //                   [_______0]
          //                          [8________]
            ((((long)in.get( 7 + inPos)) <<  8) & 511L)
        | //                   [76543210]
          //                  [_76543210]
            ((((long)in.get( 8 + inPos)) ) & 255L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                   [76543210]
          //                   [87654321_]
            ((((long)in[ 0 + inPos]) <<  1) & 511L)
        | //                   [7_______]
          //           [________0]
            ((((long)in[ 1 + inPos]) >>  7) & 1L);
      out[ 1 + outPos] =
          //                   [_6543210]
          //                    [8765432__]
            ((((long)in[ 1 + inPos]) <<  2) & 511L)
        | //                   [76______]
          //            [_______10]
            ((((long)in[ 2 + inPos]) >>  6) & 3L);
      out[ 2 + outPos] =
          //                   [__543210]
          //                     [876543___]
            ((((long)in[ 2 + inPos]) <<  3) & 511L)
        | //                   [765_____]
          //             [______210]
            ((((long)in[ 3 + inPos]) >>  5) & 7L);
      out[ 3 + outPos] =
          //                   [___43210]
          //                      [87654____]
            ((((long)in[ 3 + inPos]) <<  4) & 511L)
        | //                   [7654____]
          //              [_____3210]
            ((((long)in[ 4 + inPos]) >>  4) & 15L);
      out[ 4 + outPos] =
          //                   [____3210]
          //                       [8765_____]
            ((((long)in[ 4 + inPos]) <<  5) & 511L)
        | //                   [76543___]
          //               [____43210]
            ((((long)in[ 5 + inPos]) >>  3) & 31L);
      out[ 5 + outPos] =
          //                   [_____210]
          //                        [876______]
            ((((long)in[ 5 + inPos]) <<  6) & 511L)
        | //                   [765432__]
          //                [___543210]
            ((((long)in[ 6 + inPos]) >>  2) & 63L);
      out[ 6 + outPos] =
          //                   [______10]
          //                         [87_______]
            ((((long)in[ 6 + inPos]) <<  7) & 511L)
        | //                   [7654321_]
          //                 [__6543210]
            ((((long)in[ 7 + inPos]) >>  1) & 127L);
      out[ 7 + outPos] =
          //                   [_______0]
          //                          [8________]
            ((((long)in[ 7 + inPos]) <<  8) & 511L)
        | //                   [76543210]
          //                  [_76543210]
            ((((long)in[ 8 + inPos]) ) & 255L);
      out[ 8 + outPos] =
          //                   [76543210]
          //                   [87654321_]
            ((((long)in[ 9 + inPos]) <<  1) & 511L)
        | //                   [7_______]
          //           [________0]
            ((((long)in[10 + inPos]) >>  7) & 1L);
      out[ 9 + outPos] =
          //                   [_6543210]
          //                    [8765432__]
            ((((long)in[10 + inPos]) <<  2) & 511L)
        | //                   [76______]
          //            [_______10]
            ((((long)in[11 + inPos]) >>  6) & 3L);
      out[10 + outPos] =
          //                   [__543210]
          //                     [876543___]
            ((((long)in[11 + inPos]) <<  3) & 511L)
        | //                   [765_____]
          //             [______210]
            ((((long)in[12 + inPos]) >>  5) & 7L);
      out[11 + outPos] =
          //                   [___43210]
          //                      [87654____]
            ((((long)in[12 + inPos]) <<  4) & 511L)
        | //                   [7654____]
          //              [_____3210]
            ((((long)in[13 + inPos]) >>  4) & 15L);
      out[12 + outPos] =
          //                   [____3210]
          //                       [8765_____]
            ((((long)in[13 + inPos]) <<  5) & 511L)
        | //                   [76543___]
          //               [____43210]
            ((((long)in[14 + inPos]) >>  3) & 31L);
      out[13 + outPos] =
          //                   [_____210]
          //                        [876______]
            ((((long)in[14 + inPos]) <<  6) & 511L)
        | //                   [765432__]
          //                [___543210]
            ((((long)in[15 + inPos]) >>  2) & 63L);
      out[14 + outPos] =
          //                   [______10]
          //                         [87_______]
            ((((long)in[15 + inPos]) <<  7) & 511L)
        | //                   [7654321_]
          //                 [__6543210]
            ((((long)in[16 + inPos]) >>  1) & 127L);
      out[15 + outPos] =
          //                   [_______0]
          //                          [8________]
            ((((long)in[16 + inPos]) <<  8) & 511L)
        | //                   [76543210]
          //                  [_76543210]
            ((((long)in[17 + inPos]) ) & 255L);
      out[16 + outPos] =
          //                   [76543210]
          //                   [87654321_]
            ((((long)in[18 + inPos]) <<  1) & 511L)
        | //                   [7_______]
          //           [________0]
            ((((long)in[19 + inPos]) >>  7) & 1L);
      out[17 + outPos] =
          //                   [_6543210]
          //                    [8765432__]
            ((((long)in[19 + inPos]) <<  2) & 511L)
        | //                   [76______]
          //            [_______10]
            ((((long)in[20 + inPos]) >>  6) & 3L);
      out[18 + outPos] =
          //                   [__543210]
          //                     [876543___]
            ((((long)in[20 + inPos]) <<  3) & 511L)
        | //                   [765_____]
          //             [______210]
            ((((long)in[21 + inPos]) >>  5) & 7L);
      out[19 + outPos] =
          //                   [___43210]
          //                      [87654____]
            ((((long)in[21 + inPos]) <<  4) & 511L)
        | //                   [7654____]
          //              [_____3210]
            ((((long)in[22 + inPos]) >>  4) & 15L);
      out[20 + outPos] =
          //                   [____3210]
          //                       [8765_____]
            ((((long)in[22 + inPos]) <<  5) & 511L)
        | //                   [76543___]
          //               [____43210]
            ((((long)in[23 + inPos]) >>  3) & 31L);
      out[21 + outPos] =
          //                   [_____210]
          //                        [876______]
            ((((long)in[23 + inPos]) <<  6) & 511L)
        | //                   [765432__]
          //                [___543210]
            ((((long)in[24 + inPos]) >>  2) & 63L);
      out[22 + outPos] =
          //                   [______10]
          //                         [87_______]
            ((((long)in[24 + inPos]) <<  7) & 511L)
        | //                   [7654321_]
          //                 [__6543210]
            ((((long)in[25 + inPos]) >>  1) & 127L);
      out[23 + outPos] =
          //                   [_______0]
          //                          [8________]
            ((((long)in[25 + inPos]) <<  8) & 511L)
        | //                   [76543210]
          //                  [_76543210]
            ((((long)in[26 + inPos]) ) & 255L);
      out[24 + outPos] =
          //                   [76543210]
          //                   [87654321_]
            ((((long)in[27 + inPos]) <<  1) & 511L)
        | //                   [7_______]
          //           [________0]
            ((((long)in[28 + inPos]) >>  7) & 1L);
      out[25 + outPos] =
          //                   [_6543210]
          //                    [8765432__]
            ((((long)in[28 + inPos]) <<  2) & 511L)
        | //                   [76______]
          //            [_______10]
            ((((long)in[29 + inPos]) >>  6) & 3L);
      out[26 + outPos] =
          //                   [__543210]
          //                     [876543___]
            ((((long)in[29 + inPos]) <<  3) & 511L)
        | //                   [765_____]
          //             [______210]
            ((((long)in[30 + inPos]) >>  5) & 7L);
      out[27 + outPos] =
          //                   [___43210]
          //                      [87654____]
            ((((long)in[30 + inPos]) <<  4) & 511L)
        | //                   [7654____]
          //              [_____3210]
            ((((long)in[31 + inPos]) >>  4) & 15L);
      out[28 + outPos] =
          //                   [____3210]
          //                       [8765_____]
            ((((long)in[31 + inPos]) <<  5) & 511L)
        | //                   [76543___]
          //               [____43210]
            ((((long)in[32 + inPos]) >>  3) & 31L);
      out[29 + outPos] =
          //                   [_____210]
          //                        [876______]
            ((((long)in[32 + inPos]) <<  6) & 511L)
        | //                   [765432__]
          //                [___543210]
            ((((long)in[33 + inPos]) >>  2) & 63L);
      out[30 + outPos] =
          //                   [______10]
          //                         [87_______]
            ((((long)in[33 + inPos]) <<  7) & 511L)
        | //                   [7654321_]
          //                 [__6543210]
            ((((long)in[34 + inPos]) >>  1) & 127L);
      out[31 + outPos] =
          //                   [_______0]
          //                          [8________]
            ((((long)in[34 + inPos]) <<  8) & 511L)
        | //                   [76543210]
          //                  [_76543210]
            ((((long)in[35 + inPos]) ) & 255L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                   [76543210]
          //                   [87654321_]
            ((((long)in.get( 0 + inPos)) <<  1) & 511L)
        | //                   [7_______]
          //           [________0]
            ((((long)in.get( 1 + inPos)) >>  7) & 1L);
      out[ 1 + outPos] =
          //                   [_6543210]
          //                    [8765432__]
            ((((long)in.get( 1 + inPos)) <<  2) & 511L)
        | //                   [76______]
          //            [_______10]
            ((((long)in.get( 2 + inPos)) >>  6) & 3L);
      out[ 2 + outPos] =
          //                   [__543210]
          //                     [876543___]
            ((((long)in.get( 2 + inPos)) <<  3) & 511L)
        | //                   [765_____]
          //             [______210]
            ((((long)in.get( 3 + inPos)) >>  5) & 7L);
      out[ 3 + outPos] =
          //                   [___43210]
          //                      [87654____]
            ((((long)in.get( 3 + inPos)) <<  4) & 511L)
        | //                   [7654____]
          //              [_____3210]
            ((((long)in.get( 4 + inPos)) >>  4) & 15L);
      out[ 4 + outPos] =
          //                   [____3210]
          //                       [8765_____]
            ((((long)in.get( 4 + inPos)) <<  5) & 511L)
        | //                   [76543___]
          //               [____43210]
            ((((long)in.get( 5 + inPos)) >>  3) & 31L);
      out[ 5 + outPos] =
          //                   [_____210]
          //                        [876______]
            ((((long)in.get( 5 + inPos)) <<  6) & 511L)
        | //                   [765432__]
          //                [___543210]
            ((((long)in.get( 6 + inPos)) >>  2) & 63L);
      out[ 6 + outPos] =
          //                   [______10]
          //                         [87_______]
            ((((long)in.get( 6 + inPos)) <<  7) & 511L)
        | //                   [7654321_]
          //                 [__6543210]
            ((((long)in.get( 7 + inPos)) >>  1) & 127L);
      out[ 7 + outPos] =
          //                   [_______0]
          //                          [8________]
            ((((long)in.get( 7 + inPos)) <<  8) & 511L)
        | //                   [76543210]
          //                  [_76543210]
            ((((long)in.get( 8 + inPos)) ) & 255L);
      out[ 8 + outPos] =
          //                   [76543210]
          //                   [87654321_]
            ((((long)in.get( 9 + inPos)) <<  1) & 511L)
        | //                   [7_______]
          //           [________0]
            ((((long)in.get(10 + inPos)) >>  7) & 1L);
      out[ 9 + outPos] =
          //                   [_6543210]
          //                    [8765432__]
            ((((long)in.get(10 + inPos)) <<  2) & 511L)
        | //                   [76______]
          //            [_______10]
            ((((long)in.get(11 + inPos)) >>  6) & 3L);
      out[10 + outPos] =
          //                   [__543210]
          //                     [876543___]
            ((((long)in.get(11 + inPos)) <<  3) & 511L)
        | //                   [765_____]
          //             [______210]
            ((((long)in.get(12 + inPos)) >>  5) & 7L);
      out[11 + outPos] =
          //                   [___43210]
          //                      [87654____]
            ((((long)in.get(12 + inPos)) <<  4) & 511L)
        | //                   [7654____]
          //              [_____3210]
            ((((long)in.get(13 + inPos)) >>  4) & 15L);
      out[12 + outPos] =
          //                   [____3210]
          //                       [8765_____]
            ((((long)in.get(13 + inPos)) <<  5) & 511L)
        | //                   [76543___]
          //               [____43210]
            ((((long)in.get(14 + inPos)) >>  3) & 31L);
      out[13 + outPos] =
          //                   [_____210]
          //                        [876______]
            ((((long)in.get(14 + inPos)) <<  6) & 511L)
        | //                   [765432__]
          //                [___543210]
            ((((long)in.get(15 + inPos)) >>  2) & 63L);
      out[14 + outPos] =
          //                   [______10]
          //                         [87_______]
            ((((long)in.get(15 + inPos)) <<  7) & 511L)
        | //                   [7654321_]
          //                 [__6543210]
            ((((long)in.get(16 + inPos)) >>  1) & 127L);
      out[15 + outPos] =
          //                   [_______0]
          //                          [8________]
            ((((long)in.get(16 + inPos)) <<  8) & 511L)
        | //                   [76543210]
          //                  [_76543210]
            ((((long)in.get(17 + inPos)) ) & 255L);
      out[16 + outPos] =
          //                   [76543210]
          //                   [87654321_]
            ((((long)in.get(18 + inPos)) <<  1) & 511L)
        | //                   [7_______]
          //           [________0]
            ((((long)in.get(19 + inPos)) >>  7) & 1L);
      out[17 + outPos] =
          //                   [_6543210]
          //                    [8765432__]
            ((((long)in.get(19 + inPos)) <<  2) & 511L)
        | //                   [76______]
          //            [_______10]
            ((((long)in.get(20 + inPos)) >>  6) & 3L);
      out[18 + outPos] =
          //                   [__543210]
          //                     [876543___]
            ((((long)in.get(20 + inPos)) <<  3) & 511L)
        | //                   [765_____]
          //             [______210]
            ((((long)in.get(21 + inPos)) >>  5) & 7L);
      out[19 + outPos] =
          //                   [___43210]
          //                      [87654____]
            ((((long)in.get(21 + inPos)) <<  4) & 511L)
        | //                   [7654____]
          //              [_____3210]
            ((((long)in.get(22 + inPos)) >>  4) & 15L);
      out[20 + outPos] =
          //                   [____3210]
          //                       [8765_____]
            ((((long)in.get(22 + inPos)) <<  5) & 511L)
        | //                   [76543___]
          //               [____43210]
            ((((long)in.get(23 + inPos)) >>  3) & 31L);
      out[21 + outPos] =
          //                   [_____210]
          //                        [876______]
            ((((long)in.get(23 + inPos)) <<  6) & 511L)
        | //                   [765432__]
          //                [___543210]
            ((((long)in.get(24 + inPos)) >>  2) & 63L);
      out[22 + outPos] =
          //                   [______10]
          //                         [87_______]
            ((((long)in.get(24 + inPos)) <<  7) & 511L)
        | //                   [7654321_]
          //                 [__6543210]
            ((((long)in.get(25 + inPos)) >>  1) & 127L);
      out[23 + outPos] =
          //                   [_______0]
          //                          [8________]
            ((((long)in.get(25 + inPos)) <<  8) & 511L)
        | //                   [76543210]
          //                  [_76543210]
            ((((long)in.get(26 + inPos)) ) & 255L);
      out[24 + outPos] =
          //                   [76543210]
          //                   [87654321_]
            ((((long)in.get(27 + inPos)) <<  1) & 511L)
        | //                   [7_______]
          //           [________0]
            ((((long)in.get(28 + inPos)) >>  7) & 1L);
      out[25 + outPos] =
          //                   [_6543210]
          //                    [8765432__]
            ((((long)in.get(28 + inPos)) <<  2) & 511L)
        | //                   [76______]
          //            [_______10]
            ((((long)in.get(29 + inPos)) >>  6) & 3L);
      out[26 + outPos] =
          //                   [__543210]
          //                     [876543___]
            ((((long)in.get(29 + inPos)) <<  3) & 511L)
        | //                   [765_____]
          //             [______210]
            ((((long)in.get(30 + inPos)) >>  5) & 7L);
      out[27 + outPos] =
          //                   [___43210]
          //                      [87654____]
            ((((long)in.get(30 + inPos)) <<  4) & 511L)
        | //                   [7654____]
          //              [_____3210]
            ((((long)in.get(31 + inPos)) >>  4) & 15L);
      out[28 + outPos] =
          //                   [____3210]
          //                       [8765_____]
            ((((long)in.get(31 + inPos)) <<  5) & 511L)
        | //                   [76543___]
          //               [____43210]
            ((((long)in.get(32 + inPos)) >>  3) & 31L);
      out[29 + outPos] =
          //                   [_____210]
          //                        [876______]
            ((((long)in.get(32 + inPos)) <<  6) & 511L)
        | //                   [765432__]
          //                [___543210]
            ((((long)in.get(33 + inPos)) >>  2) & 63L);
      out[30 + outPos] =
          //                   [______10]
          //                         [87_______]
            ((((long)in.get(33 + inPos)) <<  7) & 511L)
        | //                   [7654321_]
          //                 [__6543210]
            ((((long)in.get(34 + inPos)) >>  1) & 127L);
      out[31 + outPos] =
          //                   [_______0]
          //                          [8________]
            ((((long)in.get(34 + inPos)) <<  8) & 511L)
        | //                   [76543210]
          //                  [_76543210]
            ((((long)in.get(35 + inPos)) ) & 255L);
    }
  }

  private static final class Packer10 extends BytePackerForLong {

    private Packer10() {
      super(10);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                    [76543210]
          //                    [98765432__]
           ((in[ 0 + inPos] & 1023L) >>> 2)) & 255);
      out[ 1 + outPos] = (byte)((
          //                    [76______]
          //            [________10]
           ((in[ 0 + inPos] & 1023L) <<  6)
        | //                    [__543210]
          //                      [987654____]
           ((in[ 1 + inPos] & 1023L) >>> 4)) & 255);
      out[ 2 + outPos] = (byte)((
          //                    [7654____]
          //              [______3210]
           ((in[ 1 + inPos] & 1023L) <<  4)
        | //                    [____3210]
          //                        [9876______]
           ((in[ 2 + inPos] & 1023L) >>> 6)) & 255);
      out[ 3 + outPos] = (byte)((
          //                    [765432__]
          //                [____543210]
           ((in[ 2 + inPos] & 1023L) <<  2)
        | //                    [______10]
          //                          [98________]
           ((in[ 3 + inPos] & 1023L) >>> 8)) & 255);
      out[ 4 + outPos] = (byte)((
          //                    [76543210]
          //                  [__76543210]
           ((in[ 3 + inPos] & 1023L))) & 255);
      out[ 5 + outPos] = (byte)((
          //                    [76543210]
          //                    [98765432__]
           ((in[ 4 + inPos] & 1023L) >>> 2)) & 255);
      out[ 6 + outPos] = (byte)((
          //                    [76______]
          //            [________10]
           ((in[ 4 + inPos] & 1023L) <<  6)
        | //                    [__543210]
          //                      [987654____]
           ((in[ 5 + inPos] & 1023L) >>> 4)) & 255);
      out[ 7 + outPos] = (byte)((
          //                    [7654____]
          //              [______3210]
           ((in[ 5 + inPos] & 1023L) <<  4)
        | //                    [____3210]
          //                        [9876______]
           ((in[ 6 + inPos] & 1023L) >>> 6)) & 255);
      out[ 8 + outPos] = (byte)((
          //                    [765432__]
          //                [____543210]
           ((in[ 6 + inPos] & 1023L) <<  2)
        | //                    [______10]
          //                          [98________]
           ((in[ 7 + inPos] & 1023L) >>> 8)) & 255);
      out[ 9 + outPos] = (byte)((
          //                    [76543210]
          //                  [__76543210]
           ((in[ 7 + inPos] & 1023L))) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                    [76543210]
          //                    [98765432__]
           ((in[ 0 + inPos] & 1023L) >>> 2)) & 255);
      out[ 1 + outPos] = (byte)((
          //                    [76______]
          //            [________10]
           ((in[ 0 + inPos] & 1023L) <<  6)
        | //                    [__543210]
          //                      [987654____]
           ((in[ 1 + inPos] & 1023L) >>> 4)) & 255);
      out[ 2 + outPos] = (byte)((
          //                    [7654____]
          //              [______3210]
           ((in[ 1 + inPos] & 1023L) <<  4)
        | //                    [____3210]
          //                        [9876______]
           ((in[ 2 + inPos] & 1023L) >>> 6)) & 255);
      out[ 3 + outPos] = (byte)((
          //                    [765432__]
          //                [____543210]
           ((in[ 2 + inPos] & 1023L) <<  2)
        | //                    [______10]
          //                          [98________]
           ((in[ 3 + inPos] & 1023L) >>> 8)) & 255);
      out[ 4 + outPos] = (byte)((
          //                    [76543210]
          //                  [__76543210]
           ((in[ 3 + inPos] & 1023L))) & 255);
      out[ 5 + outPos] = (byte)((
          //                    [76543210]
          //                    [98765432__]
           ((in[ 4 + inPos] & 1023L) >>> 2)) & 255);
      out[ 6 + outPos] = (byte)((
          //                    [76______]
          //            [________10]
           ((in[ 4 + inPos] & 1023L) <<  6)
        | //                    [__543210]
          //                      [987654____]
           ((in[ 5 + inPos] & 1023L) >>> 4)) & 255);
      out[ 7 + outPos] = (byte)((
          //                    [7654____]
          //              [______3210]
           ((in[ 5 + inPos] & 1023L) <<  4)
        | //                    [____3210]
          //                        [9876______]
           ((in[ 6 + inPos] & 1023L) >>> 6)) & 255);
      out[ 8 + outPos] = (byte)((
          //                    [765432__]
          //                [____543210]
           ((in[ 6 + inPos] & 1023L) <<  2)
        | //                    [______10]
          //                          [98________]
           ((in[ 7 + inPos] & 1023L) >>> 8)) & 255);
      out[ 9 + outPos] = (byte)((
          //                    [76543210]
          //                  [__76543210]
           ((in[ 7 + inPos] & 1023L))) & 255);
      out[10 + outPos] = (byte)((
          //                    [76543210]
          //                    [98765432__]
           ((in[ 8 + inPos] & 1023L) >>> 2)) & 255);
      out[11 + outPos] = (byte)((
          //                    [76______]
          //            [________10]
           ((in[ 8 + inPos] & 1023L) <<  6)
        | //                    [__543210]
          //                      [987654____]
           ((in[ 9 + inPos] & 1023L) >>> 4)) & 255);
      out[12 + outPos] = (byte)((
          //                    [7654____]
          //              [______3210]
           ((in[ 9 + inPos] & 1023L) <<  4)
        | //                    [____3210]
          //                        [9876______]
           ((in[10 + inPos] & 1023L) >>> 6)) & 255);
      out[13 + outPos] = (byte)((
          //                    [765432__]
          //                [____543210]
           ((in[10 + inPos] & 1023L) <<  2)
        | //                    [______10]
          //                          [98________]
           ((in[11 + inPos] & 1023L) >>> 8)) & 255);
      out[14 + outPos] = (byte)((
          //                    [76543210]
          //                  [__76543210]
           ((in[11 + inPos] & 1023L))) & 255);
      out[15 + outPos] = (byte)((
          //                    [76543210]
          //                    [98765432__]
           ((in[12 + inPos] & 1023L) >>> 2)) & 255);
      out[16 + outPos] = (byte)((
          //                    [76______]
          //            [________10]
           ((in[12 + inPos] & 1023L) <<  6)
        | //                    [__543210]
          //                      [987654____]
           ((in[13 + inPos] & 1023L) >>> 4)) & 255);
      out[17 + outPos] = (byte)((
          //                    [7654____]
          //              [______3210]
           ((in[13 + inPos] & 1023L) <<  4)
        | //                    [____3210]
          //                        [9876______]
           ((in[14 + inPos] & 1023L) >>> 6)) & 255);
      out[18 + outPos] = (byte)((
          //                    [765432__]
          //                [____543210]
           ((in[14 + inPos] & 1023L) <<  2)
        | //                    [______10]
          //                          [98________]
           ((in[15 + inPos] & 1023L) >>> 8)) & 255);
      out[19 + outPos] = (byte)((
          //                    [76543210]
          //                  [__76543210]
           ((in[15 + inPos] & 1023L))) & 255);
      out[20 + outPos] = (byte)((
          //                    [76543210]
          //                    [98765432__]
           ((in[16 + inPos] & 1023L) >>> 2)) & 255);
      out[21 + outPos] = (byte)((
          //                    [76______]
          //            [________10]
           ((in[16 + inPos] & 1023L) <<  6)
        | //                    [__543210]
          //                      [987654____]
           ((in[17 + inPos] & 1023L) >>> 4)) & 255);
      out[22 + outPos] = (byte)((
          //                    [7654____]
          //              [______3210]
           ((in[17 + inPos] & 1023L) <<  4)
        | //                    [____3210]
          //                        [9876______]
           ((in[18 + inPos] & 1023L) >>> 6)) & 255);
      out[23 + outPos] = (byte)((
          //                    [765432__]
          //                [____543210]
           ((in[18 + inPos] & 1023L) <<  2)
        | //                    [______10]
          //                          [98________]
           ((in[19 + inPos] & 1023L) >>> 8)) & 255);
      out[24 + outPos] = (byte)((
          //                    [76543210]
          //                  [__76543210]
           ((in[19 + inPos] & 1023L))) & 255);
      out[25 + outPos] = (byte)((
          //                    [76543210]
          //                    [98765432__]
           ((in[20 + inPos] & 1023L) >>> 2)) & 255);
      out[26 + outPos] = (byte)((
          //                    [76______]
          //            [________10]
           ((in[20 + inPos] & 1023L) <<  6)
        | //                    [__543210]
          //                      [987654____]
           ((in[21 + inPos] & 1023L) >>> 4)) & 255);
      out[27 + outPos] = (byte)((
          //                    [7654____]
          //              [______3210]
           ((in[21 + inPos] & 1023L) <<  4)
        | //                    [____3210]
          //                        [9876______]
           ((in[22 + inPos] & 1023L) >>> 6)) & 255);
      out[28 + outPos] = (byte)((
          //                    [765432__]
          //                [____543210]
           ((in[22 + inPos] & 1023L) <<  2)
        | //                    [______10]
          //                          [98________]
           ((in[23 + inPos] & 1023L) >>> 8)) & 255);
      out[29 + outPos] = (byte)((
          //                    [76543210]
          //                  [__76543210]
           ((in[23 + inPos] & 1023L))) & 255);
      out[30 + outPos] = (byte)((
          //                    [76543210]
          //                    [98765432__]
           ((in[24 + inPos] & 1023L) >>> 2)) & 255);
      out[31 + outPos] = (byte)((
          //                    [76______]
          //            [________10]
           ((in[24 + inPos] & 1023L) <<  6)
        | //                    [__543210]
          //                      [987654____]
           ((in[25 + inPos] & 1023L) >>> 4)) & 255);
      out[32 + outPos] = (byte)((
          //                    [7654____]
          //              [______3210]
           ((in[25 + inPos] & 1023L) <<  4)
        | //                    [____3210]
          //                        [9876______]
           ((in[26 + inPos] & 1023L) >>> 6)) & 255);
      out[33 + outPos] = (byte)((
          //                    [765432__]
          //                [____543210]
           ((in[26 + inPos] & 1023L) <<  2)
        | //                    [______10]
          //                          [98________]
           ((in[27 + inPos] & 1023L) >>> 8)) & 255);
      out[34 + outPos] = (byte)((
          //                    [76543210]
          //                  [__76543210]
           ((in[27 + inPos] & 1023L))) & 255);
      out[35 + outPos] = (byte)((
          //                    [76543210]
          //                    [98765432__]
           ((in[28 + inPos] & 1023L) >>> 2)) & 255);
      out[36 + outPos] = (byte)((
          //                    [76______]
          //            [________10]
           ((in[28 + inPos] & 1023L) <<  6)
        | //                    [__543210]
          //                      [987654____]
           ((in[29 + inPos] & 1023L) >>> 4)) & 255);
      out[37 + outPos] = (byte)((
          //                    [7654____]
          //              [______3210]
           ((in[29 + inPos] & 1023L) <<  4)
        | //                    [____3210]
          //                        [9876______]
           ((in[30 + inPos] & 1023L) >>> 6)) & 255);
      out[38 + outPos] = (byte)((
          //                    [765432__]
          //                [____543210]
           ((in[30 + inPos] & 1023L) <<  2)
        | //                    [______10]
          //                          [98________]
           ((in[31 + inPos] & 1023L) >>> 8)) & 255);
      out[39 + outPos] = (byte)((
          //                    [76543210]
          //                  [__76543210]
           ((in[31 + inPos] & 1023L))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                    [76543210]
          //                    [98765432__]
            ((((long)in[ 0 + inPos]) <<  2) & 1023L)
        | //                    [76______]
          //            [________10]
            ((((long)in[ 1 + inPos]) >>  6) & 3L);
      out[ 1 + outPos] =
          //                    [__543210]
          //                      [987654____]
            ((((long)in[ 1 + inPos]) <<  4) & 1023L)
        | //                    [7654____]
          //              [______3210]
            ((((long)in[ 2 + inPos]) >>  4) & 15L);
      out[ 2 + outPos] =
          //                    [____3210]
          //                        [9876______]
            ((((long)in[ 2 + inPos]) <<  6) & 1023L)
        | //                    [765432__]
          //                [____543210]
            ((((long)in[ 3 + inPos]) >>  2) & 63L);
      out[ 3 + outPos] =
          //                    [______10]
          //                          [98________]
            ((((long)in[ 3 + inPos]) <<  8) & 1023L)
        | //                    [76543210]
          //                  [__76543210]
            ((((long)in[ 4 + inPos]) ) & 255L);
      out[ 4 + outPos] =
          //                    [76543210]
          //                    [98765432__]
            ((((long)in[ 5 + inPos]) <<  2) & 1023L)
        | //                    [76______]
          //            [________10]
            ((((long)in[ 6 + inPos]) >>  6) & 3L);
      out[ 5 + outPos] =
          //                    [__543210]
          //                      [987654____]
            ((((long)in[ 6 + inPos]) <<  4) & 1023L)
        | //                    [7654____]
          //              [______3210]
            ((((long)in[ 7 + inPos]) >>  4) & 15L);
      out[ 6 + outPos] =
          //                    [____3210]
          //                        [9876______]
            ((((long)in[ 7 + inPos]) <<  6) & 1023L)
        | //                    [765432__]
          //                [____543210]
            ((((long)in[ 8 + inPos]) >>  2) & 63L);
      out[ 7 + outPos] =
          //                    [______10]
          //                          [98________]
            ((((long)in[ 8 + inPos]) <<  8) & 1023L)
        | //                    [76543210]
          //                  [__76543210]
            ((((long)in[ 9 + inPos]) ) & 255L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                    [76543210]
          //                    [98765432__]
            ((((long)in.get( 0 + inPos)) <<  2) & 1023L)
        | //                    [76______]
          //            [________10]
            ((((long)in.get( 1 + inPos)) >>  6) & 3L);
      out[ 1 + outPos] =
          //                    [__543210]
          //                      [987654____]
            ((((long)in.get( 1 + inPos)) <<  4) & 1023L)
        | //                    [7654____]
          //              [______3210]
            ((((long)in.get( 2 + inPos)) >>  4) & 15L);
      out[ 2 + outPos] =
          //                    [____3210]
          //                        [9876______]
            ((((long)in.get( 2 + inPos)) <<  6) & 1023L)
        | //                    [765432__]
          //                [____543210]
            ((((long)in.get( 3 + inPos)) >>  2) & 63L);
      out[ 3 + outPos] =
          //                    [______10]
          //                          [98________]
            ((((long)in.get( 3 + inPos)) <<  8) & 1023L)
        | //                    [76543210]
          //                  [__76543210]
            ((((long)in.get( 4 + inPos)) ) & 255L);
      out[ 4 + outPos] =
          //                    [76543210]
          //                    [98765432__]
            ((((long)in.get( 5 + inPos)) <<  2) & 1023L)
        | //                    [76______]
          //            [________10]
            ((((long)in.get( 6 + inPos)) >>  6) & 3L);
      out[ 5 + outPos] =
          //                    [__543210]
          //                      [987654____]
            ((((long)in.get( 6 + inPos)) <<  4) & 1023L)
        | //                    [7654____]
          //              [______3210]
            ((((long)in.get( 7 + inPos)) >>  4) & 15L);
      out[ 6 + outPos] =
          //                    [____3210]
          //                        [9876______]
            ((((long)in.get( 7 + inPos)) <<  6) & 1023L)
        | //                    [765432__]
          //                [____543210]
            ((((long)in.get( 8 + inPos)) >>  2) & 63L);
      out[ 7 + outPos] =
          //                    [______10]
          //                          [98________]
            ((((long)in.get( 8 + inPos)) <<  8) & 1023L)
        | //                    [76543210]
          //                  [__76543210]
            ((((long)in.get( 9 + inPos)) ) & 255L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                    [76543210]
          //                    [98765432__]
            ((((long)in[ 0 + inPos]) <<  2) & 1023L)
        | //                    [76______]
          //            [________10]
            ((((long)in[ 1 + inPos]) >>  6) & 3L);
      out[ 1 + outPos] =
          //                    [__543210]
          //                      [987654____]
            ((((long)in[ 1 + inPos]) <<  4) & 1023L)
        | //                    [7654____]
          //              [______3210]
            ((((long)in[ 2 + inPos]) >>  4) & 15L);
      out[ 2 + outPos] =
          //                    [____3210]
          //                        [9876______]
            ((((long)in[ 2 + inPos]) <<  6) & 1023L)
        | //                    [765432__]
          //                [____543210]
            ((((long)in[ 3 + inPos]) >>  2) & 63L);
      out[ 3 + outPos] =
          //                    [______10]
          //                          [98________]
            ((((long)in[ 3 + inPos]) <<  8) & 1023L)
        | //                    [76543210]
          //                  [__76543210]
            ((((long)in[ 4 + inPos]) ) & 255L);
      out[ 4 + outPos] =
          //                    [76543210]
          //                    [98765432__]
            ((((long)in[ 5 + inPos]) <<  2) & 1023L)
        | //                    [76______]
          //            [________10]
            ((((long)in[ 6 + inPos]) >>  6) & 3L);
      out[ 5 + outPos] =
          //                    [__543210]
          //                      [987654____]
            ((((long)in[ 6 + inPos]) <<  4) & 1023L)
        | //                    [7654____]
          //              [______3210]
            ((((long)in[ 7 + inPos]) >>  4) & 15L);
      out[ 6 + outPos] =
          //                    [____3210]
          //                        [9876______]
            ((((long)in[ 7 + inPos]) <<  6) & 1023L)
        | //                    [765432__]
          //                [____543210]
            ((((long)in[ 8 + inPos]) >>  2) & 63L);
      out[ 7 + outPos] =
          //                    [______10]
          //                          [98________]
            ((((long)in[ 8 + inPos]) <<  8) & 1023L)
        | //                    [76543210]
          //                  [__76543210]
            ((((long)in[ 9 + inPos]) ) & 255L);
      out[ 8 + outPos] =
          //                    [76543210]
          //                    [98765432__]
            ((((long)in[10 + inPos]) <<  2) & 1023L)
        | //                    [76______]
          //            [________10]
            ((((long)in[11 + inPos]) >>  6) & 3L);
      out[ 9 + outPos] =
          //                    [__543210]
          //                      [987654____]
            ((((long)in[11 + inPos]) <<  4) & 1023L)
        | //                    [7654____]
          //              [______3210]
            ((((long)in[12 + inPos]) >>  4) & 15L);
      out[10 + outPos] =
          //                    [____3210]
          //                        [9876______]
            ((((long)in[12 + inPos]) <<  6) & 1023L)
        | //                    [765432__]
          //                [____543210]
            ((((long)in[13 + inPos]) >>  2) & 63L);
      out[11 + outPos] =
          //                    [______10]
          //                          [98________]
            ((((long)in[13 + inPos]) <<  8) & 1023L)
        | //                    [76543210]
          //                  [__76543210]
            ((((long)in[14 + inPos]) ) & 255L);
      out[12 + outPos] =
          //                    [76543210]
          //                    [98765432__]
            ((((long)in[15 + inPos]) <<  2) & 1023L)
        | //                    [76______]
          //            [________10]
            ((((long)in[16 + inPos]) >>  6) & 3L);
      out[13 + outPos] =
          //                    [__543210]
          //                      [987654____]
            ((((long)in[16 + inPos]) <<  4) & 1023L)
        | //                    [7654____]
          //              [______3210]
            ((((long)in[17 + inPos]) >>  4) & 15L);
      out[14 + outPos] =
          //                    [____3210]
          //                        [9876______]
            ((((long)in[17 + inPos]) <<  6) & 1023L)
        | //                    [765432__]
          //                [____543210]
            ((((long)in[18 + inPos]) >>  2) & 63L);
      out[15 + outPos] =
          //                    [______10]
          //                          [98________]
            ((((long)in[18 + inPos]) <<  8) & 1023L)
        | //                    [76543210]
          //                  [__76543210]
            ((((long)in[19 + inPos]) ) & 255L);
      out[16 + outPos] =
          //                    [76543210]
          //                    [98765432__]
            ((((long)in[20 + inPos]) <<  2) & 1023L)
        | //                    [76______]
          //            [________10]
            ((((long)in[21 + inPos]) >>  6) & 3L);
      out[17 + outPos] =
          //                    [__543210]
          //                      [987654____]
            ((((long)in[21 + inPos]) <<  4) & 1023L)
        | //                    [7654____]
          //              [______3210]
            ((((long)in[22 + inPos]) >>  4) & 15L);
      out[18 + outPos] =
          //                    [____3210]
          //                        [9876______]
            ((((long)in[22 + inPos]) <<  6) & 1023L)
        | //                    [765432__]
          //                [____543210]
            ((((long)in[23 + inPos]) >>  2) & 63L);
      out[19 + outPos] =
          //                    [______10]
          //                          [98________]
            ((((long)in[23 + inPos]) <<  8) & 1023L)
        | //                    [76543210]
          //                  [__76543210]
            ((((long)in[24 + inPos]) ) & 255L);
      out[20 + outPos] =
          //                    [76543210]
          //                    [98765432__]
            ((((long)in[25 + inPos]) <<  2) & 1023L)
        | //                    [76______]
          //            [________10]
            ((((long)in[26 + inPos]) >>  6) & 3L);
      out[21 + outPos] =
          //                    [__543210]
          //                      [987654____]
            ((((long)in[26 + inPos]) <<  4) & 1023L)
        | //                    [7654____]
          //              [______3210]
            ((((long)in[27 + inPos]) >>  4) & 15L);
      out[22 + outPos] =
          //                    [____3210]
          //                        [9876______]
            ((((long)in[27 + inPos]) <<  6) & 1023L)
        | //                    [765432__]
          //                [____543210]
            ((((long)in[28 + inPos]) >>  2) & 63L);
      out[23 + outPos] =
          //                    [______10]
          //                          [98________]
            ((((long)in[28 + inPos]) <<  8) & 1023L)
        | //                    [76543210]
          //                  [__76543210]
            ((((long)in[29 + inPos]) ) & 255L);
      out[24 + outPos] =
          //                    [76543210]
          //                    [98765432__]
            ((((long)in[30 + inPos]) <<  2) & 1023L)
        | //                    [76______]
          //            [________10]
            ((((long)in[31 + inPos]) >>  6) & 3L);
      out[25 + outPos] =
          //                    [__543210]
          //                      [987654____]
            ((((long)in[31 + inPos]) <<  4) & 1023L)
        | //                    [7654____]
          //              [______3210]
            ((((long)in[32 + inPos]) >>  4) & 15L);
      out[26 + outPos] =
          //                    [____3210]
          //                        [9876______]
            ((((long)in[32 + inPos]) <<  6) & 1023L)
        | //                    [765432__]
          //                [____543210]
            ((((long)in[33 + inPos]) >>  2) & 63L);
      out[27 + outPos] =
          //                    [______10]
          //                          [98________]
            ((((long)in[33 + inPos]) <<  8) & 1023L)
        | //                    [76543210]
          //                  [__76543210]
            ((((long)in[34 + inPos]) ) & 255L);
      out[28 + outPos] =
          //                    [76543210]
          //                    [98765432__]
            ((((long)in[35 + inPos]) <<  2) & 1023L)
        | //                    [76______]
          //            [________10]
            ((((long)in[36 + inPos]) >>  6) & 3L);
      out[29 + outPos] =
          //                    [__543210]
          //                      [987654____]
            ((((long)in[36 + inPos]) <<  4) & 1023L)
        | //                    [7654____]
          //              [______3210]
            ((((long)in[37 + inPos]) >>  4) & 15L);
      out[30 + outPos] =
          //                    [____3210]
          //                        [9876______]
            ((((long)in[37 + inPos]) <<  6) & 1023L)
        | //                    [765432__]
          //                [____543210]
            ((((long)in[38 + inPos]) >>  2) & 63L);
      out[31 + outPos] =
          //                    [______10]
          //                          [98________]
            ((((long)in[38 + inPos]) <<  8) & 1023L)
        | //                    [76543210]
          //                  [__76543210]
            ((((long)in[39 + inPos]) ) & 255L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                    [76543210]
          //                    [98765432__]
            ((((long)in.get( 0 + inPos)) <<  2) & 1023L)
        | //                    [76______]
          //            [________10]
            ((((long)in.get( 1 + inPos)) >>  6) & 3L);
      out[ 1 + outPos] =
          //                    [__543210]
          //                      [987654____]
            ((((long)in.get( 1 + inPos)) <<  4) & 1023L)
        | //                    [7654____]
          //              [______3210]
            ((((long)in.get( 2 + inPos)) >>  4) & 15L);
      out[ 2 + outPos] =
          //                    [____3210]
          //                        [9876______]
            ((((long)in.get( 2 + inPos)) <<  6) & 1023L)
        | //                    [765432__]
          //                [____543210]
            ((((long)in.get( 3 + inPos)) >>  2) & 63L);
      out[ 3 + outPos] =
          //                    [______10]
          //                          [98________]
            ((((long)in.get( 3 + inPos)) <<  8) & 1023L)
        | //                    [76543210]
          //                  [__76543210]
            ((((long)in.get( 4 + inPos)) ) & 255L);
      out[ 4 + outPos] =
          //                    [76543210]
          //                    [98765432__]
            ((((long)in.get( 5 + inPos)) <<  2) & 1023L)
        | //                    [76______]
          //            [________10]
            ((((long)in.get( 6 + inPos)) >>  6) & 3L);
      out[ 5 + outPos] =
          //                    [__543210]
          //                      [987654____]
            ((((long)in.get( 6 + inPos)) <<  4) & 1023L)
        | //                    [7654____]
          //              [______3210]
            ((((long)in.get( 7 + inPos)) >>  4) & 15L);
      out[ 6 + outPos] =
          //                    [____3210]
          //                        [9876______]
            ((((long)in.get( 7 + inPos)) <<  6) & 1023L)
        | //                    [765432__]
          //                [____543210]
            ((((long)in.get( 8 + inPos)) >>  2) & 63L);
      out[ 7 + outPos] =
          //                    [______10]
          //                          [98________]
            ((((long)in.get( 8 + inPos)) <<  8) & 1023L)
        | //                    [76543210]
          //                  [__76543210]
            ((((long)in.get( 9 + inPos)) ) & 255L);
      out[ 8 + outPos] =
          //                    [76543210]
          //                    [98765432__]
            ((((long)in.get(10 + inPos)) <<  2) & 1023L)
        | //                    [76______]
          //            [________10]
            ((((long)in.get(11 + inPos)) >>  6) & 3L);
      out[ 9 + outPos] =
          //                    [__543210]
          //                      [987654____]
            ((((long)in.get(11 + inPos)) <<  4) & 1023L)
        | //                    [7654____]
          //              [______3210]
            ((((long)in.get(12 + inPos)) >>  4) & 15L);
      out[10 + outPos] =
          //                    [____3210]
          //                        [9876______]
            ((((long)in.get(12 + inPos)) <<  6) & 1023L)
        | //                    [765432__]
          //                [____543210]
            ((((long)in.get(13 + inPos)) >>  2) & 63L);
      out[11 + outPos] =
          //                    [______10]
          //                          [98________]
            ((((long)in.get(13 + inPos)) <<  8) & 1023L)
        | //                    [76543210]
          //                  [__76543210]
            ((((long)in.get(14 + inPos)) ) & 255L);
      out[12 + outPos] =
          //                    [76543210]
          //                    [98765432__]
            ((((long)in.get(15 + inPos)) <<  2) & 1023L)
        | //                    [76______]
          //            [________10]
            ((((long)in.get(16 + inPos)) >>  6) & 3L);
      out[13 + outPos] =
          //                    [__543210]
          //                      [987654____]
            ((((long)in.get(16 + inPos)) <<  4) & 1023L)
        | //                    [7654____]
          //              [______3210]
            ((((long)in.get(17 + inPos)) >>  4) & 15L);
      out[14 + outPos] =
          //                    [____3210]
          //                        [9876______]
            ((((long)in.get(17 + inPos)) <<  6) & 1023L)
        | //                    [765432__]
          //                [____543210]
            ((((long)in.get(18 + inPos)) >>  2) & 63L);
      out[15 + outPos] =
          //                    [______10]
          //                          [98________]
            ((((long)in.get(18 + inPos)) <<  8) & 1023L)
        | //                    [76543210]
          //                  [__76543210]
            ((((long)in.get(19 + inPos)) ) & 255L);
      out[16 + outPos] =
          //                    [76543210]
          //                    [98765432__]
            ((((long)in.get(20 + inPos)) <<  2) & 1023L)
        | //                    [76______]
          //            [________10]
            ((((long)in.get(21 + inPos)) >>  6) & 3L);
      out[17 + outPos] =
          //                    [__543210]
          //                      [987654____]
            ((((long)in.get(21 + inPos)) <<  4) & 1023L)
        | //                    [7654____]
          //              [______3210]
            ((((long)in.get(22 + inPos)) >>  4) & 15L);
      out[18 + outPos] =
          //                    [____3210]
          //                        [9876______]
            ((((long)in.get(22 + inPos)) <<  6) & 1023L)
        | //                    [765432__]
          //                [____543210]
            ((((long)in.get(23 + inPos)) >>  2) & 63L);
      out[19 + outPos] =
          //                    [______10]
          //                          [98________]
            ((((long)in.get(23 + inPos)) <<  8) & 1023L)
        | //                    [76543210]
          //                  [__76543210]
            ((((long)in.get(24 + inPos)) ) & 255L);
      out[20 + outPos] =
          //                    [76543210]
          //                    [98765432__]
            ((((long)in.get(25 + inPos)) <<  2) & 1023L)
        | //                    [76______]
          //            [________10]
            ((((long)in.get(26 + inPos)) >>  6) & 3L);
      out[21 + outPos] =
          //                    [__543210]
          //                      [987654____]
            ((((long)in.get(26 + inPos)) <<  4) & 1023L)
        | //                    [7654____]
          //              [______3210]
            ((((long)in.get(27 + inPos)) >>  4) & 15L);
      out[22 + outPos] =
          //                    [____3210]
          //                        [9876______]
            ((((long)in.get(27 + inPos)) <<  6) & 1023L)
        | //                    [765432__]
          //                [____543210]
            ((((long)in.get(28 + inPos)) >>  2) & 63L);
      out[23 + outPos] =
          //                    [______10]
          //                          [98________]
            ((((long)in.get(28 + inPos)) <<  8) & 1023L)
        | //                    [76543210]
          //                  [__76543210]
            ((((long)in.get(29 + inPos)) ) & 255L);
      out[24 + outPos] =
          //                    [76543210]
          //                    [98765432__]
            ((((long)in.get(30 + inPos)) <<  2) & 1023L)
        | //                    [76______]
          //            [________10]
            ((((long)in.get(31 + inPos)) >>  6) & 3L);
      out[25 + outPos] =
          //                    [__543210]
          //                      [987654____]
            ((((long)in.get(31 + inPos)) <<  4) & 1023L)
        | //                    [7654____]
          //              [______3210]
            ((((long)in.get(32 + inPos)) >>  4) & 15L);
      out[26 + outPos] =
          //                    [____3210]
          //                        [9876______]
            ((((long)in.get(32 + inPos)) <<  6) & 1023L)
        | //                    [765432__]
          //                [____543210]
            ((((long)in.get(33 + inPos)) >>  2) & 63L);
      out[27 + outPos] =
          //                    [______10]
          //                          [98________]
            ((((long)in.get(33 + inPos)) <<  8) & 1023L)
        | //                    [76543210]
          //                  [__76543210]
            ((((long)in.get(34 + inPos)) ) & 255L);
      out[28 + outPos] =
          //                    [76543210]
          //                    [98765432__]
            ((((long)in.get(35 + inPos)) <<  2) & 1023L)
        | //                    [76______]
          //            [________10]
            ((((long)in.get(36 + inPos)) >>  6) & 3L);
      out[29 + outPos] =
          //                    [__543210]
          //                      [987654____]
            ((((long)in.get(36 + inPos)) <<  4) & 1023L)
        | //                    [7654____]
          //              [______3210]
            ((((long)in.get(37 + inPos)) >>  4) & 15L);
      out[30 + outPos] =
          //                    [____3210]
          //                        [9876______]
            ((((long)in.get(37 + inPos)) <<  6) & 1023L)
        | //                    [765432__]
          //                [____543210]
            ((((long)in.get(38 + inPos)) >>  2) & 63L);
      out[31 + outPos] =
          //                    [______10]
          //                          [98________]
            ((((long)in.get(38 + inPos)) <<  8) & 1023L)
        | //                    [76543210]
          //                  [__76543210]
            ((((long)in.get(39 + inPos)) ) & 255L);
    }
  }

  private static final class Packer11 extends BytePackerForLong {

    private Packer11() {
      super(11);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                     [76543210]
          //                     [09876543___]
           ((in[ 0 + inPos] & 2047L) >>> 3)) & 255);
      out[ 1 + outPos] = (byte)((
          //                     [765_____]
          //             [________210]
           ((in[ 0 + inPos] & 2047L) <<  5)
        | //                     [___43210]
          //                        [09876______]
           ((in[ 1 + inPos] & 2047L) >>> 6)) & 255);
      out[ 2 + outPos] = (byte)((
          //                     [765432__]
          //                [_____543210]
           ((in[ 1 + inPos] & 2047L) <<  2)
        | //                     [______10]
          //                           [09_________]
           ((in[ 2 + inPos] & 2047L) >>> 9)) & 255);
      out[ 3 + outPos] = (byte)((
          //                     [76543210]
          //                   [__87654321_]
           ((in[ 2 + inPos] & 2047L) >>> 1)) & 255);
      out[ 4 + outPos] = (byte)((
          //                     [7_______]
          //           [__________0]
           ((in[ 2 + inPos] & 2047L) <<  7)
        | //                     [_6543210]
          //                      [0987654____]
           ((in[ 3 + inPos] & 2047L) >>> 4)) & 255);
      out[ 5 + outPos] = (byte)((
          //                     [7654____]
          //              [_______3210]
           ((in[ 3 + inPos] & 2047L) <<  4)
        | //                     [____3210]
          //                         [0987_______]
           ((in[ 4 + inPos] & 2047L) >>> 7)) & 255);
      out[ 6 + outPos] = (byte)((
          //                     [7654321_]
          //                 [____6543210]
           ((in[ 4 + inPos] & 2047L) <<  1)
        | //                     [_______0]
          //                            [0__________]
           ((in[ 5 + inPos] & 2047L) >>> 10)) & 255);
      out[ 7 + outPos] = (byte)((
          //                     [76543210]
          //                    [_98765432__]
           ((in[ 5 + inPos] & 2047L) >>> 2)) & 255);
      out[ 8 + outPos] = (byte)((
          //                     [76______]
          //            [_________10]
           ((in[ 5 + inPos] & 2047L) <<  6)
        | //                     [__543210]
          //                       [098765_____]
           ((in[ 6 + inPos] & 2047L) >>> 5)) & 255);
      out[ 9 + outPos] = (byte)((
          //                     [76543___]
          //               [______43210]
           ((in[ 6 + inPos] & 2047L) <<  3)
        | //                     [_____210]
          //                          [098________]
           ((in[ 7 + inPos] & 2047L) >>> 8)) & 255);
      out[10 + outPos] = (byte)((
          //                     [76543210]
          //                  [___76543210]
           ((in[ 7 + inPos] & 2047L))) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                     [76543210]
          //                     [09876543___]
           ((in[ 0 + inPos] & 2047L) >>> 3)) & 255);
      out[ 1 + outPos] = (byte)((
          //                     [765_____]
          //             [________210]
           ((in[ 0 + inPos] & 2047L) <<  5)
        | //                     [___43210]
          //                        [09876______]
           ((in[ 1 + inPos] & 2047L) >>> 6)) & 255);
      out[ 2 + outPos] = (byte)((
          //                     [765432__]
          //                [_____543210]
           ((in[ 1 + inPos] & 2047L) <<  2)
        | //                     [______10]
          //                           [09_________]
           ((in[ 2 + inPos] & 2047L) >>> 9)) & 255);
      out[ 3 + outPos] = (byte)((
          //                     [76543210]
          //                   [__87654321_]
           ((in[ 2 + inPos] & 2047L) >>> 1)) & 255);
      out[ 4 + outPos] = (byte)((
          //                     [7_______]
          //           [__________0]
           ((in[ 2 + inPos] & 2047L) <<  7)
        | //                     [_6543210]
          //                      [0987654____]
           ((in[ 3 + inPos] & 2047L) >>> 4)) & 255);
      out[ 5 + outPos] = (byte)((
          //                     [7654____]
          //              [_______3210]
           ((in[ 3 + inPos] & 2047L) <<  4)
        | //                     [____3210]
          //                         [0987_______]
           ((in[ 4 + inPos] & 2047L) >>> 7)) & 255);
      out[ 6 + outPos] = (byte)((
          //                     [7654321_]
          //                 [____6543210]
           ((in[ 4 + inPos] & 2047L) <<  1)
        | //                     [_______0]
          //                            [0__________]
           ((in[ 5 + inPos] & 2047L) >>> 10)) & 255);
      out[ 7 + outPos] = (byte)((
          //                     [76543210]
          //                    [_98765432__]
           ((in[ 5 + inPos] & 2047L) >>> 2)) & 255);
      out[ 8 + outPos] = (byte)((
          //                     [76______]
          //            [_________10]
           ((in[ 5 + inPos] & 2047L) <<  6)
        | //                     [__543210]
          //                       [098765_____]
           ((in[ 6 + inPos] & 2047L) >>> 5)) & 255);
      out[ 9 + outPos] = (byte)((
          //                     [76543___]
          //               [______43210]
           ((in[ 6 + inPos] & 2047L) <<  3)
        | //                     [_____210]
          //                          [098________]
           ((in[ 7 + inPos] & 2047L) >>> 8)) & 255);
      out[10 + outPos] = (byte)((
          //                     [76543210]
          //                  [___76543210]
           ((in[ 7 + inPos] & 2047L))) & 255);
      out[11 + outPos] = (byte)((
          //                     [76543210]
          //                     [09876543___]
           ((in[ 8 + inPos] & 2047L) >>> 3)) & 255);
      out[12 + outPos] = (byte)((
          //                     [765_____]
          //             [________210]
           ((in[ 8 + inPos] & 2047L) <<  5)
        | //                     [___43210]
          //                        [09876______]
           ((in[ 9 + inPos] & 2047L) >>> 6)) & 255);
      out[13 + outPos] = (byte)((
          //                     [765432__]
          //                [_____543210]
           ((in[ 9 + inPos] & 2047L) <<  2)
        | //                     [______10]
          //                           [09_________]
           ((in[10 + inPos] & 2047L) >>> 9)) & 255);
      out[14 + outPos] = (byte)((
          //                     [76543210]
          //                   [__87654321_]
           ((in[10 + inPos] & 2047L) >>> 1)) & 255);
      out[15 + outPos] = (byte)((
          //                     [7_______]
          //           [__________0]
           ((in[10 + inPos] & 2047L) <<  7)
        | //                     [_6543210]
          //                      [0987654____]
           ((in[11 + inPos] & 2047L) >>> 4)) & 255);
      out[16 + outPos] = (byte)((
          //                     [7654____]
          //              [_______3210]
           ((in[11 + inPos] & 2047L) <<  4)
        | //                     [____3210]
          //                         [0987_______]
           ((in[12 + inPos] & 2047L) >>> 7)) & 255);
      out[17 + outPos] = (byte)((
          //                     [7654321_]
          //                 [____6543210]
           ((in[12 + inPos] & 2047L) <<  1)
        | //                     [_______0]
          //                            [0__________]
           ((in[13 + inPos] & 2047L) >>> 10)) & 255);
      out[18 + outPos] = (byte)((
          //                     [76543210]
          //                    [_98765432__]
           ((in[13 + inPos] & 2047L) >>> 2)) & 255);
      out[19 + outPos] = (byte)((
          //                     [76______]
          //            [_________10]
           ((in[13 + inPos] & 2047L) <<  6)
        | //                     [__543210]
          //                       [098765_____]
           ((in[14 + inPos] & 2047L) >>> 5)) & 255);
      out[20 + outPos] = (byte)((
          //                     [76543___]
          //               [______43210]
           ((in[14 + inPos] & 2047L) <<  3)
        | //                     [_____210]
          //                          [098________]
           ((in[15 + inPos] & 2047L) >>> 8)) & 255);
      out[21 + outPos] = (byte)((
          //                     [76543210]
          //                  [___76543210]
           ((in[15 + inPos] & 2047L))) & 255);
      out[22 + outPos] = (byte)((
          //                     [76543210]
          //                     [09876543___]
           ((in[16 + inPos] & 2047L) >>> 3)) & 255);
      out[23 + outPos] = (byte)((
          //                     [765_____]
          //             [________210]
           ((in[16 + inPos] & 2047L) <<  5)
        | //                     [___43210]
          //                        [09876______]
           ((in[17 + inPos] & 2047L) >>> 6)) & 255);
      out[24 + outPos] = (byte)((
          //                     [765432__]
          //                [_____543210]
           ((in[17 + inPos] & 2047L) <<  2)
        | //                     [______10]
          //                           [09_________]
           ((in[18 + inPos] & 2047L) >>> 9)) & 255);
      out[25 + outPos] = (byte)((
          //                     [76543210]
          //                   [__87654321_]
           ((in[18 + inPos] & 2047L) >>> 1)) & 255);
      out[26 + outPos] = (byte)((
          //                     [7_______]
          //           [__________0]
           ((in[18 + inPos] & 2047L) <<  7)
        | //                     [_6543210]
          //                      [0987654____]
           ((in[19 + inPos] & 2047L) >>> 4)) & 255);
      out[27 + outPos] = (byte)((
          //                     [7654____]
          //              [_______3210]
           ((in[19 + inPos] & 2047L) <<  4)
        | //                     [____3210]
          //                         [0987_______]
           ((in[20 + inPos] & 2047L) >>> 7)) & 255);
      out[28 + outPos] = (byte)((
          //                     [7654321_]
          //                 [____6543210]
           ((in[20 + inPos] & 2047L) <<  1)
        | //                     [_______0]
          //                            [0__________]
           ((in[21 + inPos] & 2047L) >>> 10)) & 255);
      out[29 + outPos] = (byte)((
          //                     [76543210]
          //                    [_98765432__]
           ((in[21 + inPos] & 2047L) >>> 2)) & 255);
      out[30 + outPos] = (byte)((
          //                     [76______]
          //            [_________10]
           ((in[21 + inPos] & 2047L) <<  6)
        | //                     [__543210]
          //                       [098765_____]
           ((in[22 + inPos] & 2047L) >>> 5)) & 255);
      out[31 + outPos] = (byte)((
          //                     [76543___]
          //               [______43210]
           ((in[22 + inPos] & 2047L) <<  3)
        | //                     [_____210]
          //                          [098________]
           ((in[23 + inPos] & 2047L) >>> 8)) & 255);
      out[32 + outPos] = (byte)((
          //                     [76543210]
          //                  [___76543210]
           ((in[23 + inPos] & 2047L))) & 255);
      out[33 + outPos] = (byte)((
          //                     [76543210]
          //                     [09876543___]
           ((in[24 + inPos] & 2047L) >>> 3)) & 255);
      out[34 + outPos] = (byte)((
          //                     [765_____]
          //             [________210]
           ((in[24 + inPos] & 2047L) <<  5)
        | //                     [___43210]
          //                        [09876______]
           ((in[25 + inPos] & 2047L) >>> 6)) & 255);
      out[35 + outPos] = (byte)((
          //                     [765432__]
          //                [_____543210]
           ((in[25 + inPos] & 2047L) <<  2)
        | //                     [______10]
          //                           [09_________]
           ((in[26 + inPos] & 2047L) >>> 9)) & 255);
      out[36 + outPos] = (byte)((
          //                     [76543210]
          //                   [__87654321_]
           ((in[26 + inPos] & 2047L) >>> 1)) & 255);
      out[37 + outPos] = (byte)((
          //                     [7_______]
          //           [__________0]
           ((in[26 + inPos] & 2047L) <<  7)
        | //                     [_6543210]
          //                      [0987654____]
           ((in[27 + inPos] & 2047L) >>> 4)) & 255);
      out[38 + outPos] = (byte)((
          //                     [7654____]
          //              [_______3210]
           ((in[27 + inPos] & 2047L) <<  4)
        | //                     [____3210]
          //                         [0987_______]
           ((in[28 + inPos] & 2047L) >>> 7)) & 255);
      out[39 + outPos] = (byte)((
          //                     [7654321_]
          //                 [____6543210]
           ((in[28 + inPos] & 2047L) <<  1)
        | //                     [_______0]
          //                            [0__________]
           ((in[29 + inPos] & 2047L) >>> 10)) & 255);
      out[40 + outPos] = (byte)((
          //                     [76543210]
          //                    [_98765432__]
           ((in[29 + inPos] & 2047L) >>> 2)) & 255);
      out[41 + outPos] = (byte)((
          //                     [76______]
          //            [_________10]
           ((in[29 + inPos] & 2047L) <<  6)
        | //                     [__543210]
          //                       [098765_____]
           ((in[30 + inPos] & 2047L) >>> 5)) & 255);
      out[42 + outPos] = (byte)((
          //                     [76543___]
          //               [______43210]
           ((in[30 + inPos] & 2047L) <<  3)
        | //                     [_____210]
          //                          [098________]
           ((in[31 + inPos] & 2047L) >>> 8)) & 255);
      out[43 + outPos] = (byte)((
          //                     [76543210]
          //                  [___76543210]
           ((in[31 + inPos] & 2047L))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                     [76543210]
          //                     [09876543___]
            ((((long)in[ 0 + inPos]) <<  3) & 2047L)
        | //                     [765_____]
          //             [________210]
            ((((long)in[ 1 + inPos]) >>  5) & 7L);
      out[ 1 + outPos] =
          //                     [___43210]
          //                        [09876______]
            ((((long)in[ 1 + inPos]) <<  6) & 2047L)
        | //                     [765432__]
          //                [_____543210]
            ((((long)in[ 2 + inPos]) >>  2) & 63L);
      out[ 2 + outPos] =
          //                     [______10]
          //                           [09_________]
            ((((long)in[ 2 + inPos]) <<  9) & 2047L)
        | //                     [76543210]
          //                   [__87654321_]
            ((((long)in[ 3 + inPos]) <<  1) & 511L)
        | //                     [7_______]
          //           [__________0]
            ((((long)in[ 4 + inPos]) >>  7) & 1L);
      out[ 3 + outPos] =
          //                     [_6543210]
          //                      [0987654____]
            ((((long)in[ 4 + inPos]) <<  4) & 2047L)
        | //                     [7654____]
          //              [_______3210]
            ((((long)in[ 5 + inPos]) >>  4) & 15L);
      out[ 4 + outPos] =
          //                     [____3210]
          //                         [0987_______]
            ((((long)in[ 5 + inPos]) <<  7) & 2047L)
        | //                     [7654321_]
          //                 [____6543210]
            ((((long)in[ 6 + inPos]) >>  1) & 127L);
      out[ 5 + outPos] =
          //                     [_______0]
          //                            [0__________]
            ((((long)in[ 6 + inPos]) <<  10) & 2047L)
        | //                     [76543210]
          //                    [_98765432__]
            ((((long)in[ 7 + inPos]) <<  2) & 1023L)
        | //                     [76______]
          //            [_________10]
            ((((long)in[ 8 + inPos]) >>  6) & 3L);
      out[ 6 + outPos] =
          //                     [__543210]
          //                       [098765_____]
            ((((long)in[ 8 + inPos]) <<  5) & 2047L)
        | //                     [76543___]
          //               [______43210]
            ((((long)in[ 9 + inPos]) >>  3) & 31L);
      out[ 7 + outPos] =
          //                     [_____210]
          //                          [098________]
            ((((long)in[ 9 + inPos]) <<  8) & 2047L)
        | //                     [76543210]
          //                  [___76543210]
            ((((long)in[10 + inPos]) ) & 255L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                     [76543210]
          //                     [09876543___]
            ((((long)in.get( 0 + inPos)) <<  3) & 2047L)
        | //                     [765_____]
          //             [________210]
            ((((long)in.get( 1 + inPos)) >>  5) & 7L);
      out[ 1 + outPos] =
          //                     [___43210]
          //                        [09876______]
            ((((long)in.get( 1 + inPos)) <<  6) & 2047L)
        | //                     [765432__]
          //                [_____543210]
            ((((long)in.get( 2 + inPos)) >>  2) & 63L);
      out[ 2 + outPos] =
          //                     [______10]
          //                           [09_________]
            ((((long)in.get( 2 + inPos)) <<  9) & 2047L)
        | //                     [76543210]
          //                   [__87654321_]
            ((((long)in.get( 3 + inPos)) <<  1) & 511L)
        | //                     [7_______]
          //           [__________0]
            ((((long)in.get( 4 + inPos)) >>  7) & 1L);
      out[ 3 + outPos] =
          //                     [_6543210]
          //                      [0987654____]
            ((((long)in.get( 4 + inPos)) <<  4) & 2047L)
        | //                     [7654____]
          //              [_______3210]
            ((((long)in.get( 5 + inPos)) >>  4) & 15L);
      out[ 4 + outPos] =
          //                     [____3210]
          //                         [0987_______]
            ((((long)in.get( 5 + inPos)) <<  7) & 2047L)
        | //                     [7654321_]
          //                 [____6543210]
            ((((long)in.get( 6 + inPos)) >>  1) & 127L);
      out[ 5 + outPos] =
          //                     [_______0]
          //                            [0__________]
            ((((long)in.get( 6 + inPos)) <<  10) & 2047L)
        | //                     [76543210]
          //                    [_98765432__]
            ((((long)in.get( 7 + inPos)) <<  2) & 1023L)
        | //                     [76______]
          //            [_________10]
            ((((long)in.get( 8 + inPos)) >>  6) & 3L);
      out[ 6 + outPos] =
          //                     [__543210]
          //                       [098765_____]
            ((((long)in.get( 8 + inPos)) <<  5) & 2047L)
        | //                     [76543___]
          //               [______43210]
            ((((long)in.get( 9 + inPos)) >>  3) & 31L);
      out[ 7 + outPos] =
          //                     [_____210]
          //                          [098________]
            ((((long)in.get( 9 + inPos)) <<  8) & 2047L)
        | //                     [76543210]
          //                  [___76543210]
            ((((long)in.get(10 + inPos)) ) & 255L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                     [76543210]
          //                     [09876543___]
            ((((long)in[ 0 + inPos]) <<  3) & 2047L)
        | //                     [765_____]
          //             [________210]
            ((((long)in[ 1 + inPos]) >>  5) & 7L);
      out[ 1 + outPos] =
          //                     [___43210]
          //                        [09876______]
            ((((long)in[ 1 + inPos]) <<  6) & 2047L)
        | //                     [765432__]
          //                [_____543210]
            ((((long)in[ 2 + inPos]) >>  2) & 63L);
      out[ 2 + outPos] =
          //                     [______10]
          //                           [09_________]
            ((((long)in[ 2 + inPos]) <<  9) & 2047L)
        | //                     [76543210]
          //                   [__87654321_]
            ((((long)in[ 3 + inPos]) <<  1) & 511L)
        | //                     [7_______]
          //           [__________0]
            ((((long)in[ 4 + inPos]) >>  7) & 1L);
      out[ 3 + outPos] =
          //                     [_6543210]
          //                      [0987654____]
            ((((long)in[ 4 + inPos]) <<  4) & 2047L)
        | //                     [7654____]
          //              [_______3210]
            ((((long)in[ 5 + inPos]) >>  4) & 15L);
      out[ 4 + outPos] =
          //                     [____3210]
          //                         [0987_______]
            ((((long)in[ 5 + inPos]) <<  7) & 2047L)
        | //                     [7654321_]
          //                 [____6543210]
            ((((long)in[ 6 + inPos]) >>  1) & 127L);
      out[ 5 + outPos] =
          //                     [_______0]
          //                            [0__________]
            ((((long)in[ 6 + inPos]) <<  10) & 2047L)
        | //                     [76543210]
          //                    [_98765432__]
            ((((long)in[ 7 + inPos]) <<  2) & 1023L)
        | //                     [76______]
          //            [_________10]
            ((((long)in[ 8 + inPos]) >>  6) & 3L);
      out[ 6 + outPos] =
          //                     [__543210]
          //                       [098765_____]
            ((((long)in[ 8 + inPos]) <<  5) & 2047L)
        | //                     [76543___]
          //               [______43210]
            ((((long)in[ 9 + inPos]) >>  3) & 31L);
      out[ 7 + outPos] =
          //                     [_____210]
          //                          [098________]
            ((((long)in[ 9 + inPos]) <<  8) & 2047L)
        | //                     [76543210]
          //                  [___76543210]
            ((((long)in[10 + inPos]) ) & 255L);
      out[ 8 + outPos] =
          //                     [76543210]
          //                     [09876543___]
            ((((long)in[11 + inPos]) <<  3) & 2047L)
        | //                     [765_____]
          //             [________210]
            ((((long)in[12 + inPos]) >>  5) & 7L);
      out[ 9 + outPos] =
          //                     [___43210]
          //                        [09876______]
            ((((long)in[12 + inPos]) <<  6) & 2047L)
        | //                     [765432__]
          //                [_____543210]
            ((((long)in[13 + inPos]) >>  2) & 63L);
      out[10 + outPos] =
          //                     [______10]
          //                           [09_________]
            ((((long)in[13 + inPos]) <<  9) & 2047L)
        | //                     [76543210]
          //                   [__87654321_]
            ((((long)in[14 + inPos]) <<  1) & 511L)
        | //                     [7_______]
          //           [__________0]
            ((((long)in[15 + inPos]) >>  7) & 1L);
      out[11 + outPos] =
          //                     [_6543210]
          //                      [0987654____]
            ((((long)in[15 + inPos]) <<  4) & 2047L)
        | //                     [7654____]
          //              [_______3210]
            ((((long)in[16 + inPos]) >>  4) & 15L);
      out[12 + outPos] =
          //                     [____3210]
          //                         [0987_______]
            ((((long)in[16 + inPos]) <<  7) & 2047L)
        | //                     [7654321_]
          //                 [____6543210]
            ((((long)in[17 + inPos]) >>  1) & 127L);
      out[13 + outPos] =
          //                     [_______0]
          //                            [0__________]
            ((((long)in[17 + inPos]) <<  10) & 2047L)
        | //                     [76543210]
          //                    [_98765432__]
            ((((long)in[18 + inPos]) <<  2) & 1023L)
        | //                     [76______]
          //            [_________10]
            ((((long)in[19 + inPos]) >>  6) & 3L);
      out[14 + outPos] =
          //                     [__543210]
          //                       [098765_____]
            ((((long)in[19 + inPos]) <<  5) & 2047L)
        | //                     [76543___]
          //               [______43210]
            ((((long)in[20 + inPos]) >>  3) & 31L);
      out[15 + outPos] =
          //                     [_____210]
          //                          [098________]
            ((((long)in[20 + inPos]) <<  8) & 2047L)
        | //                     [76543210]
          //                  [___76543210]
            ((((long)in[21 + inPos]) ) & 255L);
      out[16 + outPos] =
          //                     [76543210]
          //                     [09876543___]
            ((((long)in[22 + inPos]) <<  3) & 2047L)
        | //                     [765_____]
          //             [________210]
            ((((long)in[23 + inPos]) >>  5) & 7L);
      out[17 + outPos] =
          //                     [___43210]
          //                        [09876______]
            ((((long)in[23 + inPos]) <<  6) & 2047L)
        | //                     [765432__]
          //                [_____543210]
            ((((long)in[24 + inPos]) >>  2) & 63L);
      out[18 + outPos] =
          //                     [______10]
          //                           [09_________]
            ((((long)in[24 + inPos]) <<  9) & 2047L)
        | //                     [76543210]
          //                   [__87654321_]
            ((((long)in[25 + inPos]) <<  1) & 511L)
        | //                     [7_______]
          //           [__________0]
            ((((long)in[26 + inPos]) >>  7) & 1L);
      out[19 + outPos] =
          //                     [_6543210]
          //                      [0987654____]
            ((((long)in[26 + inPos]) <<  4) & 2047L)
        | //                     [7654____]
          //              [_______3210]
            ((((long)in[27 + inPos]) >>  4) & 15L);
      out[20 + outPos] =
          //                     [____3210]
          //                         [0987_______]
            ((((long)in[27 + inPos]) <<  7) & 2047L)
        | //                     [7654321_]
          //                 [____6543210]
            ((((long)in[28 + inPos]) >>  1) & 127L);
      out[21 + outPos] =
          //                     [_______0]
          //                            [0__________]
            ((((long)in[28 + inPos]) <<  10) & 2047L)
        | //                     [76543210]
          //                    [_98765432__]
            ((((long)in[29 + inPos]) <<  2) & 1023L)
        | //                     [76______]
          //            [_________10]
            ((((long)in[30 + inPos]) >>  6) & 3L);
      out[22 + outPos] =
          //                     [__543210]
          //                       [098765_____]
            ((((long)in[30 + inPos]) <<  5) & 2047L)
        | //                     [76543___]
          //               [______43210]
            ((((long)in[31 + inPos]) >>  3) & 31L);
      out[23 + outPos] =
          //                     [_____210]
          //                          [098________]
            ((((long)in[31 + inPos]) <<  8) & 2047L)
        | //                     [76543210]
          //                  [___76543210]
            ((((long)in[32 + inPos]) ) & 255L);
      out[24 + outPos] =
          //                     [76543210]
          //                     [09876543___]
            ((((long)in[33 + inPos]) <<  3) & 2047L)
        | //                     [765_____]
          //             [________210]
            ((((long)in[34 + inPos]) >>  5) & 7L);
      out[25 + outPos] =
          //                     [___43210]
          //                        [09876______]
            ((((long)in[34 + inPos]) <<  6) & 2047L)
        | //                     [765432__]
          //                [_____543210]
            ((((long)in[35 + inPos]) >>  2) & 63L);
      out[26 + outPos] =
          //                     [______10]
          //                           [09_________]
            ((((long)in[35 + inPos]) <<  9) & 2047L)
        | //                     [76543210]
          //                   [__87654321_]
            ((((long)in[36 + inPos]) <<  1) & 511L)
        | //                     [7_______]
          //           [__________0]
            ((((long)in[37 + inPos]) >>  7) & 1L);
      out[27 + outPos] =
          //                     [_6543210]
          //                      [0987654____]
            ((((long)in[37 + inPos]) <<  4) & 2047L)
        | //                     [7654____]
          //              [_______3210]
            ((((long)in[38 + inPos]) >>  4) & 15L);
      out[28 + outPos] =
          //                     [____3210]
          //                         [0987_______]
            ((((long)in[38 + inPos]) <<  7) & 2047L)
        | //                     [7654321_]
          //                 [____6543210]
            ((((long)in[39 + inPos]) >>  1) & 127L);
      out[29 + outPos] =
          //                     [_______0]
          //                            [0__________]
            ((((long)in[39 + inPos]) <<  10) & 2047L)
        | //                     [76543210]
          //                    [_98765432__]
            ((((long)in[40 + inPos]) <<  2) & 1023L)
        | //                     [76______]
          //            [_________10]
            ((((long)in[41 + inPos]) >>  6) & 3L);
      out[30 + outPos] =
          //                     [__543210]
          //                       [098765_____]
            ((((long)in[41 + inPos]) <<  5) & 2047L)
        | //                     [76543___]
          //               [______43210]
            ((((long)in[42 + inPos]) >>  3) & 31L);
      out[31 + outPos] =
          //                     [_____210]
          //                          [098________]
            ((((long)in[42 + inPos]) <<  8) & 2047L)
        | //                     [76543210]
          //                  [___76543210]
            ((((long)in[43 + inPos]) ) & 255L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                     [76543210]
          //                     [09876543___]
            ((((long)in.get( 0 + inPos)) <<  3) & 2047L)
        | //                     [765_____]
          //             [________210]
            ((((long)in.get( 1 + inPos)) >>  5) & 7L);
      out[ 1 + outPos] =
          //                     [___43210]
          //                        [09876______]
            ((((long)in.get( 1 + inPos)) <<  6) & 2047L)
        | //                     [765432__]
          //                [_____543210]
            ((((long)in.get( 2 + inPos)) >>  2) & 63L);
      out[ 2 + outPos] =
          //                     [______10]
          //                           [09_________]
            ((((long)in.get( 2 + inPos)) <<  9) & 2047L)
        | //                     [76543210]
          //                   [__87654321_]
            ((((long)in.get( 3 + inPos)) <<  1) & 511L)
        | //                     [7_______]
          //           [__________0]
            ((((long)in.get( 4 + inPos)) >>  7) & 1L);
      out[ 3 + outPos] =
          //                     [_6543210]
          //                      [0987654____]
            ((((long)in.get( 4 + inPos)) <<  4) & 2047L)
        | //                     [7654____]
          //              [_______3210]
            ((((long)in.get( 5 + inPos)) >>  4) & 15L);
      out[ 4 + outPos] =
          //                     [____3210]
          //                         [0987_______]
            ((((long)in.get( 5 + inPos)) <<  7) & 2047L)
        | //                     [7654321_]
          //                 [____6543210]
            ((((long)in.get( 6 + inPos)) >>  1) & 127L);
      out[ 5 + outPos] =
          //                     [_______0]
          //                            [0__________]
            ((((long)in.get( 6 + inPos)) <<  10) & 2047L)
        | //                     [76543210]
          //                    [_98765432__]
            ((((long)in.get( 7 + inPos)) <<  2) & 1023L)
        | //                     [76______]
          //            [_________10]
            ((((long)in.get( 8 + inPos)) >>  6) & 3L);
      out[ 6 + outPos] =
          //                     [__543210]
          //                       [098765_____]
            ((((long)in.get( 8 + inPos)) <<  5) & 2047L)
        | //                     [76543___]
          //               [______43210]
            ((((long)in.get( 9 + inPos)) >>  3) & 31L);
      out[ 7 + outPos] =
          //                     [_____210]
          //                          [098________]
            ((((long)in.get( 9 + inPos)) <<  8) & 2047L)
        | //                     [76543210]
          //                  [___76543210]
            ((((long)in.get(10 + inPos)) ) & 255L);
      out[ 8 + outPos] =
          //                     [76543210]
          //                     [09876543___]
            ((((long)in.get(11 + inPos)) <<  3) & 2047L)
        | //                     [765_____]
          //             [________210]
            ((((long)in.get(12 + inPos)) >>  5) & 7L);
      out[ 9 + outPos] =
          //                     [___43210]
          //                        [09876______]
            ((((long)in.get(12 + inPos)) <<  6) & 2047L)
        | //                     [765432__]
          //                [_____543210]
            ((((long)in.get(13 + inPos)) >>  2) & 63L);
      out[10 + outPos] =
          //                     [______10]
          //                           [09_________]
            ((((long)in.get(13 + inPos)) <<  9) & 2047L)
        | //                     [76543210]
          //                   [__87654321_]
            ((((long)in.get(14 + inPos)) <<  1) & 511L)
        | //                     [7_______]
          //           [__________0]
            ((((long)in.get(15 + inPos)) >>  7) & 1L);
      out[11 + outPos] =
          //                     [_6543210]
          //                      [0987654____]
            ((((long)in.get(15 + inPos)) <<  4) & 2047L)
        | //                     [7654____]
          //              [_______3210]
            ((((long)in.get(16 + inPos)) >>  4) & 15L);
      out[12 + outPos] =
          //                     [____3210]
          //                         [0987_______]
            ((((long)in.get(16 + inPos)) <<  7) & 2047L)
        | //                     [7654321_]
          //                 [____6543210]
            ((((long)in.get(17 + inPos)) >>  1) & 127L);
      out[13 + outPos] =
          //                     [_______0]
          //                            [0__________]
            ((((long)in.get(17 + inPos)) <<  10) & 2047L)
        | //                     [76543210]
          //                    [_98765432__]
            ((((long)in.get(18 + inPos)) <<  2) & 1023L)
        | //                     [76______]
          //            [_________10]
            ((((long)in.get(19 + inPos)) >>  6) & 3L);
      out[14 + outPos] =
          //                     [__543210]
          //                       [098765_____]
            ((((long)in.get(19 + inPos)) <<  5) & 2047L)
        | //                     [76543___]
          //               [______43210]
            ((((long)in.get(20 + inPos)) >>  3) & 31L);
      out[15 + outPos] =
          //                     [_____210]
          //                          [098________]
            ((((long)in.get(20 + inPos)) <<  8) & 2047L)
        | //                     [76543210]
          //                  [___76543210]
            ((((long)in.get(21 + inPos)) ) & 255L);
      out[16 + outPos] =
          //                     [76543210]
          //                     [09876543___]
            ((((long)in.get(22 + inPos)) <<  3) & 2047L)
        | //                     [765_____]
          //             [________210]
            ((((long)in.get(23 + inPos)) >>  5) & 7L);
      out[17 + outPos] =
          //                     [___43210]
          //                        [09876______]
            ((((long)in.get(23 + inPos)) <<  6) & 2047L)
        | //                     [765432__]
          //                [_____543210]
            ((((long)in.get(24 + inPos)) >>  2) & 63L);
      out[18 + outPos] =
          //                     [______10]
          //                           [09_________]
            ((((long)in.get(24 + inPos)) <<  9) & 2047L)
        | //                     [76543210]
          //                   [__87654321_]
            ((((long)in.get(25 + inPos)) <<  1) & 511L)
        | //                     [7_______]
          //           [__________0]
            ((((long)in.get(26 + inPos)) >>  7) & 1L);
      out[19 + outPos] =
          //                     [_6543210]
          //                      [0987654____]
            ((((long)in.get(26 + inPos)) <<  4) & 2047L)
        | //                     [7654____]
          //              [_______3210]
            ((((long)in.get(27 + inPos)) >>  4) & 15L);
      out[20 + outPos] =
          //                     [____3210]
          //                         [0987_______]
            ((((long)in.get(27 + inPos)) <<  7) & 2047L)
        | //                     [7654321_]
          //                 [____6543210]
            ((((long)in.get(28 + inPos)) >>  1) & 127L);
      out[21 + outPos] =
          //                     [_______0]
          //                            [0__________]
            ((((long)in.get(28 + inPos)) <<  10) & 2047L)
        | //                     [76543210]
          //                    [_98765432__]
            ((((long)in.get(29 + inPos)) <<  2) & 1023L)
        | //                     [76______]
          //            [_________10]
            ((((long)in.get(30 + inPos)) >>  6) & 3L);
      out[22 + outPos] =
          //                     [__543210]
          //                       [098765_____]
            ((((long)in.get(30 + inPos)) <<  5) & 2047L)
        | //                     [76543___]
          //               [______43210]
            ((((long)in.get(31 + inPos)) >>  3) & 31L);
      out[23 + outPos] =
          //                     [_____210]
          //                          [098________]
            ((((long)in.get(31 + inPos)) <<  8) & 2047L)
        | //                     [76543210]
          //                  [___76543210]
            ((((long)in.get(32 + inPos)) ) & 255L);
      out[24 + outPos] =
          //                     [76543210]
          //                     [09876543___]
            ((((long)in.get(33 + inPos)) <<  3) & 2047L)
        | //                     [765_____]
          //             [________210]
            ((((long)in.get(34 + inPos)) >>  5) & 7L);
      out[25 + outPos] =
          //                     [___43210]
          //                        [09876______]
            ((((long)in.get(34 + inPos)) <<  6) & 2047L)
        | //                     [765432__]
          //                [_____543210]
            ((((long)in.get(35 + inPos)) >>  2) & 63L);
      out[26 + outPos] =
          //                     [______10]
          //                           [09_________]
            ((((long)in.get(35 + inPos)) <<  9) & 2047L)
        | //                     [76543210]
          //                   [__87654321_]
            ((((long)in.get(36 + inPos)) <<  1) & 511L)
        | //                     [7_______]
          //           [__________0]
            ((((long)in.get(37 + inPos)) >>  7) & 1L);
      out[27 + outPos] =
          //                     [_6543210]
          //                      [0987654____]
            ((((long)in.get(37 + inPos)) <<  4) & 2047L)
        | //                     [7654____]
          //              [_______3210]
            ((((long)in.get(38 + inPos)) >>  4) & 15L);
      out[28 + outPos] =
          //                     [____3210]
          //                         [0987_______]
            ((((long)in.get(38 + inPos)) <<  7) & 2047L)
        | //                     [7654321_]
          //                 [____6543210]
            ((((long)in.get(39 + inPos)) >>  1) & 127L);
      out[29 + outPos] =
          //                     [_______0]
          //                            [0__________]
            ((((long)in.get(39 + inPos)) <<  10) & 2047L)
        | //                     [76543210]
          //                    [_98765432__]
            ((((long)in.get(40 + inPos)) <<  2) & 1023L)
        | //                     [76______]
          //            [_________10]
            ((((long)in.get(41 + inPos)) >>  6) & 3L);
      out[30 + outPos] =
          //                     [__543210]
          //                       [098765_____]
            ((((long)in.get(41 + inPos)) <<  5) & 2047L)
        | //                     [76543___]
          //               [______43210]
            ((((long)in.get(42 + inPos)) >>  3) & 31L);
      out[31 + outPos] =
          //                     [_____210]
          //                          [098________]
            ((((long)in.get(42 + inPos)) <<  8) & 2047L)
        | //                     [76543210]
          //                  [___76543210]
            ((((long)in.get(43 + inPos)) ) & 255L);
    }
  }

  private static final class Packer12 extends BytePackerForLong {

    private Packer12() {
      super(12);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[ 0 + inPos] & 4095L) >>> 4)) & 255);
      out[ 1 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[ 0 + inPos] & 4095L) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[ 1 + inPos] & 4095L) >>> 8)) & 255);
      out[ 2 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[ 1 + inPos] & 4095L))) & 255);
      out[ 3 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[ 2 + inPos] & 4095L) >>> 4)) & 255);
      out[ 4 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[ 2 + inPos] & 4095L) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[ 3 + inPos] & 4095L) >>> 8)) & 255);
      out[ 5 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[ 3 + inPos] & 4095L))) & 255);
      out[ 6 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[ 4 + inPos] & 4095L) >>> 4)) & 255);
      out[ 7 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[ 4 + inPos] & 4095L) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[ 5 + inPos] & 4095L) >>> 8)) & 255);
      out[ 8 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[ 5 + inPos] & 4095L))) & 255);
      out[ 9 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[ 6 + inPos] & 4095L) >>> 4)) & 255);
      out[10 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[ 6 + inPos] & 4095L) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[ 7 + inPos] & 4095L) >>> 8)) & 255);
      out[11 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[ 7 + inPos] & 4095L))) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[ 0 + inPos] & 4095L) >>> 4)) & 255);
      out[ 1 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[ 0 + inPos] & 4095L) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[ 1 + inPos] & 4095L) >>> 8)) & 255);
      out[ 2 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[ 1 + inPos] & 4095L))) & 255);
      out[ 3 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[ 2 + inPos] & 4095L) >>> 4)) & 255);
      out[ 4 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[ 2 + inPos] & 4095L) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[ 3 + inPos] & 4095L) >>> 8)) & 255);
      out[ 5 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[ 3 + inPos] & 4095L))) & 255);
      out[ 6 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[ 4 + inPos] & 4095L) >>> 4)) & 255);
      out[ 7 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[ 4 + inPos] & 4095L) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[ 5 + inPos] & 4095L) >>> 8)) & 255);
      out[ 8 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[ 5 + inPos] & 4095L))) & 255);
      out[ 9 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[ 6 + inPos] & 4095L) >>> 4)) & 255);
      out[10 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[ 6 + inPos] & 4095L) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[ 7 + inPos] & 4095L) >>> 8)) & 255);
      out[11 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[ 7 + inPos] & 4095L))) & 255);
      out[12 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[ 8 + inPos] & 4095L) >>> 4)) & 255);
      out[13 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[ 8 + inPos] & 4095L) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[ 9 + inPos] & 4095L) >>> 8)) & 255);
      out[14 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[ 9 + inPos] & 4095L))) & 255);
      out[15 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[10 + inPos] & 4095L) >>> 4)) & 255);
      out[16 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[10 + inPos] & 4095L) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[11 + inPos] & 4095L) >>> 8)) & 255);
      out[17 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[11 + inPos] & 4095L))) & 255);
      out[18 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[12 + inPos] & 4095L) >>> 4)) & 255);
      out[19 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[12 + inPos] & 4095L) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[13 + inPos] & 4095L) >>> 8)) & 255);
      out[20 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[13 + inPos] & 4095L))) & 255);
      out[21 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[14 + inPos] & 4095L) >>> 4)) & 255);
      out[22 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[14 + inPos] & 4095L) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[15 + inPos] & 4095L) >>> 8)) & 255);
      out[23 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[15 + inPos] & 4095L))) & 255);
      out[24 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[16 + inPos] & 4095L) >>> 4)) & 255);
      out[25 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[16 + inPos] & 4095L) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[17 + inPos] & 4095L) >>> 8)) & 255);
      out[26 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[17 + inPos] & 4095L))) & 255);
      out[27 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[18 + inPos] & 4095L) >>> 4)) & 255);
      out[28 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[18 + inPos] & 4095L) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[19 + inPos] & 4095L) >>> 8)) & 255);
      out[29 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[19 + inPos] & 4095L))) & 255);
      out[30 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[20 + inPos] & 4095L) >>> 4)) & 255);
      out[31 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[20 + inPos] & 4095L) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[21 + inPos] & 4095L) >>> 8)) & 255);
      out[32 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[21 + inPos] & 4095L))) & 255);
      out[33 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[22 + inPos] & 4095L) >>> 4)) & 255);
      out[34 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[22 + inPos] & 4095L) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[23 + inPos] & 4095L) >>> 8)) & 255);
      out[35 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[23 + inPos] & 4095L))) & 255);
      out[36 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[24 + inPos] & 4095L) >>> 4)) & 255);
      out[37 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[24 + inPos] & 4095L) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[25 + inPos] & 4095L) >>> 8)) & 255);
      out[38 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[25 + inPos] & 4095L))) & 255);
      out[39 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[26 + inPos] & 4095L) >>> 4)) & 255);
      out[40 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[26 + inPos] & 4095L) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[27 + inPos] & 4095L) >>> 8)) & 255);
      out[41 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[27 + inPos] & 4095L))) & 255);
      out[42 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[28 + inPos] & 4095L) >>> 4)) & 255);
      out[43 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[28 + inPos] & 4095L) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[29 + inPos] & 4095L) >>> 8)) & 255);
      out[44 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[29 + inPos] & 4095L))) & 255);
      out[45 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[30 + inPos] & 4095L) >>> 4)) & 255);
      out[46 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[30 + inPos] & 4095L) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[31 + inPos] & 4095L) >>> 8)) & 255);
      out[47 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[31 + inPos] & 4095L))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in[ 0 + inPos]) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in[ 1 + inPos]) >>  4) & 15L);
      out[ 1 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in[ 1 + inPos]) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in[ 2 + inPos]) ) & 255L);
      out[ 2 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in[ 3 + inPos]) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in[ 4 + inPos]) >>  4) & 15L);
      out[ 3 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in[ 4 + inPos]) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in[ 5 + inPos]) ) & 255L);
      out[ 4 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in[ 6 + inPos]) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in[ 7 + inPos]) >>  4) & 15L);
      out[ 5 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in[ 7 + inPos]) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in[ 8 + inPos]) ) & 255L);
      out[ 6 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in[ 9 + inPos]) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in[10 + inPos]) >>  4) & 15L);
      out[ 7 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in[10 + inPos]) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in[11 + inPos]) ) & 255L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in.get( 0 + inPos)) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in.get( 1 + inPos)) >>  4) & 15L);
      out[ 1 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in.get( 1 + inPos)) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in.get( 2 + inPos)) ) & 255L);
      out[ 2 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in.get( 3 + inPos)) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in.get( 4 + inPos)) >>  4) & 15L);
      out[ 3 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in.get( 4 + inPos)) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in.get( 5 + inPos)) ) & 255L);
      out[ 4 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in.get( 6 + inPos)) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in.get( 7 + inPos)) >>  4) & 15L);
      out[ 5 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in.get( 7 + inPos)) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in.get( 8 + inPos)) ) & 255L);
      out[ 6 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in.get( 9 + inPos)) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in.get(10 + inPos)) >>  4) & 15L);
      out[ 7 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in.get(10 + inPos)) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in.get(11 + inPos)) ) & 255L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in[ 0 + inPos]) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in[ 1 + inPos]) >>  4) & 15L);
      out[ 1 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in[ 1 + inPos]) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in[ 2 + inPos]) ) & 255L);
      out[ 2 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in[ 3 + inPos]) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in[ 4 + inPos]) >>  4) & 15L);
      out[ 3 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in[ 4 + inPos]) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in[ 5 + inPos]) ) & 255L);
      out[ 4 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in[ 6 + inPos]) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in[ 7 + inPos]) >>  4) & 15L);
      out[ 5 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in[ 7 + inPos]) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in[ 8 + inPos]) ) & 255L);
      out[ 6 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in[ 9 + inPos]) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in[10 + inPos]) >>  4) & 15L);
      out[ 7 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in[10 + inPos]) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in[11 + inPos]) ) & 255L);
      out[ 8 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in[12 + inPos]) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in[13 + inPos]) >>  4) & 15L);
      out[ 9 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in[13 + inPos]) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in[14 + inPos]) ) & 255L);
      out[10 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in[15 + inPos]) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in[16 + inPos]) >>  4) & 15L);
      out[11 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in[16 + inPos]) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in[17 + inPos]) ) & 255L);
      out[12 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in[18 + inPos]) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in[19 + inPos]) >>  4) & 15L);
      out[13 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in[19 + inPos]) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in[20 + inPos]) ) & 255L);
      out[14 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in[21 + inPos]) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in[22 + inPos]) >>  4) & 15L);
      out[15 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in[22 + inPos]) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in[23 + inPos]) ) & 255L);
      out[16 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in[24 + inPos]) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in[25 + inPos]) >>  4) & 15L);
      out[17 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in[25 + inPos]) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in[26 + inPos]) ) & 255L);
      out[18 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in[27 + inPos]) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in[28 + inPos]) >>  4) & 15L);
      out[19 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in[28 + inPos]) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in[29 + inPos]) ) & 255L);
      out[20 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in[30 + inPos]) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in[31 + inPos]) >>  4) & 15L);
      out[21 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in[31 + inPos]) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in[32 + inPos]) ) & 255L);
      out[22 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in[33 + inPos]) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in[34 + inPos]) >>  4) & 15L);
      out[23 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in[34 + inPos]) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in[35 + inPos]) ) & 255L);
      out[24 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in[36 + inPos]) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in[37 + inPos]) >>  4) & 15L);
      out[25 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in[37 + inPos]) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in[38 + inPos]) ) & 255L);
      out[26 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in[39 + inPos]) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in[40 + inPos]) >>  4) & 15L);
      out[27 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in[40 + inPos]) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in[41 + inPos]) ) & 255L);
      out[28 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in[42 + inPos]) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in[43 + inPos]) >>  4) & 15L);
      out[29 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in[43 + inPos]) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in[44 + inPos]) ) & 255L);
      out[30 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in[45 + inPos]) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in[46 + inPos]) >>  4) & 15L);
      out[31 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in[46 + inPos]) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in[47 + inPos]) ) & 255L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in.get( 0 + inPos)) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in.get( 1 + inPos)) >>  4) & 15L);
      out[ 1 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in.get( 1 + inPos)) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in.get( 2 + inPos)) ) & 255L);
      out[ 2 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in.get( 3 + inPos)) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in.get( 4 + inPos)) >>  4) & 15L);
      out[ 3 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in.get( 4 + inPos)) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in.get( 5 + inPos)) ) & 255L);
      out[ 4 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in.get( 6 + inPos)) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in.get( 7 + inPos)) >>  4) & 15L);
      out[ 5 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in.get( 7 + inPos)) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in.get( 8 + inPos)) ) & 255L);
      out[ 6 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in.get( 9 + inPos)) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in.get(10 + inPos)) >>  4) & 15L);
      out[ 7 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in.get(10 + inPos)) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in.get(11 + inPos)) ) & 255L);
      out[ 8 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in.get(12 + inPos)) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in.get(13 + inPos)) >>  4) & 15L);
      out[ 9 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in.get(13 + inPos)) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in.get(14 + inPos)) ) & 255L);
      out[10 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in.get(15 + inPos)) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in.get(16 + inPos)) >>  4) & 15L);
      out[11 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in.get(16 + inPos)) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in.get(17 + inPos)) ) & 255L);
      out[12 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in.get(18 + inPos)) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in.get(19 + inPos)) >>  4) & 15L);
      out[13 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in.get(19 + inPos)) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in.get(20 + inPos)) ) & 255L);
      out[14 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in.get(21 + inPos)) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in.get(22 + inPos)) >>  4) & 15L);
      out[15 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in.get(22 + inPos)) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in.get(23 + inPos)) ) & 255L);
      out[16 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in.get(24 + inPos)) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in.get(25 + inPos)) >>  4) & 15L);
      out[17 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in.get(25 + inPos)) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in.get(26 + inPos)) ) & 255L);
      out[18 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in.get(27 + inPos)) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in.get(28 + inPos)) >>  4) & 15L);
      out[19 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in.get(28 + inPos)) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in.get(29 + inPos)) ) & 255L);
      out[20 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in.get(30 + inPos)) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in.get(31 + inPos)) >>  4) & 15L);
      out[21 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in.get(31 + inPos)) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in.get(32 + inPos)) ) & 255L);
      out[22 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in.get(33 + inPos)) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in.get(34 + inPos)) >>  4) & 15L);
      out[23 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in.get(34 + inPos)) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in.get(35 + inPos)) ) & 255L);
      out[24 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in.get(36 + inPos)) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in.get(37 + inPos)) >>  4) & 15L);
      out[25 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in.get(37 + inPos)) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in.get(38 + inPos)) ) & 255L);
      out[26 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in.get(39 + inPos)) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in.get(40 + inPos)) >>  4) & 15L);
      out[27 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in.get(40 + inPos)) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in.get(41 + inPos)) ) & 255L);
      out[28 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in.get(42 + inPos)) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in.get(43 + inPos)) >>  4) & 15L);
      out[29 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in.get(43 + inPos)) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in.get(44 + inPos)) ) & 255L);
      out[30 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            ((((long)in.get(45 + inPos)) <<  4) & 4095L)
        | //                      [7654____]
          //              [________3210]
            ((((long)in.get(46 + inPos)) >>  4) & 15L);
      out[31 + outPos] =
          //                      [____3210]
          //                          [1098________]
            ((((long)in.get(46 + inPos)) <<  8) & 4095L)
        | //                      [76543210]
          //                  [____76543210]
            ((((long)in.get(47 + inPos)) ) & 255L);
    }
  }

  private static final class Packer13 extends BytePackerForLong {

    private Packer13() {
      super(13);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                       [76543210]
          //                       [21098765_____]
           ((in[ 0 + inPos] & 8191L) >>> 5)) & 255);
      out[ 1 + outPos] = (byte)((
          //                       [76543___]
          //               [________43210]
           ((in[ 0 + inPos] & 8191L) <<  3)
        | //                       [_____210]
          //                            [210__________]
           ((in[ 1 + inPos] & 8191L) >>> 10)) & 255);
      out[ 2 + outPos] = (byte)((
          //                       [76543210]
          //                    [___98765432__]
           ((in[ 1 + inPos] & 8191L) >>> 2)) & 255);
      out[ 3 + outPos] = (byte)((
          //                       [76______]
          //            [___________10]
           ((in[ 1 + inPos] & 8191L) <<  6)
        | //                       [__543210]
          //                         [210987_______]
           ((in[ 2 + inPos] & 8191L) >>> 7)) & 255);
      out[ 4 + outPos] = (byte)((
          //                       [7654321_]
          //                 [______6543210]
           ((in[ 2 + inPos] & 8191L) <<  1)
        | //                       [_______0]
          //                              [2____________]
           ((in[ 3 + inPos] & 8191L) >>> 12)) & 255);
      out[ 5 + outPos] = (byte)((
          //                       [76543210]
          //                      [_10987654____]
           ((in[ 3 + inPos] & 8191L) >>> 4)) & 255);
      out[ 6 + outPos] = (byte)((
          //                       [7654____]
          //              [_________3210]
           ((in[ 3 + inPos] & 8191L) <<  4)
        | //                       [____3210]
          //                           [2109_________]
           ((in[ 4 + inPos] & 8191L) >>> 9)) & 255);
      out[ 7 + outPos] = (byte)((
          //                       [76543210]
          //                   [____87654321_]
           ((in[ 4 + inPos] & 8191L) >>> 1)) & 255);
      out[ 8 + outPos] = (byte)((
          //                       [7_______]
          //           [____________0]
           ((in[ 4 + inPos] & 8191L) <<  7)
        | //                       [_6543210]
          //                        [2109876______]
           ((in[ 5 + inPos] & 8191L) >>> 6)) & 255);
      out[ 9 + outPos] = (byte)((
          //                       [765432__]
          //                [_______543210]
           ((in[ 5 + inPos] & 8191L) <<  2)
        | //                       [______10]
          //                             [21___________]
           ((in[ 6 + inPos] & 8191L) >>> 11)) & 255);
      out[10 + outPos] = (byte)((
          //                       [76543210]
          //                     [__09876543___]
           ((in[ 6 + inPos] & 8191L) >>> 3)) & 255);
      out[11 + outPos] = (byte)((
          //                       [765_____]
          //             [__________210]
           ((in[ 6 + inPos] & 8191L) <<  5)
        | //                       [___43210]
          //                          [21098________]
           ((in[ 7 + inPos] & 8191L) >>> 8)) & 255);
      out[12 + outPos] = (byte)((
          //                       [76543210]
          //                  [_____76543210]
           ((in[ 7 + inPos] & 8191L))) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                       [76543210]
          //                       [21098765_____]
           ((in[ 0 + inPos] & 8191L) >>> 5)) & 255);
      out[ 1 + outPos] = (byte)((
          //                       [76543___]
          //               [________43210]
           ((in[ 0 + inPos] & 8191L) <<  3)
        | //                       [_____210]
          //                            [210__________]
           ((in[ 1 + inPos] & 8191L) >>> 10)) & 255);
      out[ 2 + outPos] = (byte)((
          //                       [76543210]
          //                    [___98765432__]
           ((in[ 1 + inPos] & 8191L) >>> 2)) & 255);
      out[ 3 + outPos] = (byte)((
          //                       [76______]
          //            [___________10]
           ((in[ 1 + inPos] & 8191L) <<  6)
        | //                       [__543210]
          //                         [210987_______]
           ((in[ 2 + inPos] & 8191L) >>> 7)) & 255);
      out[ 4 + outPos] = (byte)((
          //                       [7654321_]
          //                 [______6543210]
           ((in[ 2 + inPos] & 8191L) <<  1)
        | //                       [_______0]
          //                              [2____________]
           ((in[ 3 + inPos] & 8191L) >>> 12)) & 255);
      out[ 5 + outPos] = (byte)((
          //                       [76543210]
          //                      [_10987654____]
           ((in[ 3 + inPos] & 8191L) >>> 4)) & 255);
      out[ 6 + outPos] = (byte)((
          //                       [7654____]
          //              [_________3210]
           ((in[ 3 + inPos] & 8191L) <<  4)
        | //                       [____3210]
          //                           [2109_________]
           ((in[ 4 + inPos] & 8191L) >>> 9)) & 255);
      out[ 7 + outPos] = (byte)((
          //                       [76543210]
          //                   [____87654321_]
           ((in[ 4 + inPos] & 8191L) >>> 1)) & 255);
      out[ 8 + outPos] = (byte)((
          //                       [7_______]
          //           [____________0]
           ((in[ 4 + inPos] & 8191L) <<  7)
        | //                       [_6543210]
          //                        [2109876______]
           ((in[ 5 + inPos] & 8191L) >>> 6)) & 255);
      out[ 9 + outPos] = (byte)((
          //                       [765432__]
          //                [_______543210]
           ((in[ 5 + inPos] & 8191L) <<  2)
        | //                       [______10]
          //                             [21___________]
           ((in[ 6 + inPos] & 8191L) >>> 11)) & 255);
      out[10 + outPos] = (byte)((
          //                       [76543210]
          //                     [__09876543___]
           ((in[ 6 + inPos] & 8191L) >>> 3)) & 255);
      out[11 + outPos] = (byte)((
          //                       [765_____]
          //             [__________210]
           ((in[ 6 + inPos] & 8191L) <<  5)
        | //                       [___43210]
          //                          [21098________]
           ((in[ 7 + inPos] & 8191L) >>> 8)) & 255);
      out[12 + outPos] = (byte)((
          //                       [76543210]
          //                  [_____76543210]
           ((in[ 7 + inPos] & 8191L))) & 255);
      out[13 + outPos] = (byte)((
          //                       [76543210]
          //                       [21098765_____]
           ((in[ 8 + inPos] & 8191L) >>> 5)) & 255);
      out[14 + outPos] = (byte)((
          //                       [76543___]
          //               [________43210]
           ((in[ 8 + inPos] & 8191L) <<  3)
        | //                       [_____210]
          //                            [210__________]
           ((in[ 9 + inPos] & 8191L) >>> 10)) & 255);
      out[15 + outPos] = (byte)((
          //                       [76543210]
          //                    [___98765432__]
           ((in[ 9 + inPos] & 8191L) >>> 2)) & 255);
      out[16 + outPos] = (byte)((
          //                       [76______]
          //            [___________10]
           ((in[ 9 + inPos] & 8191L) <<  6)
        | //                       [__543210]
          //                         [210987_______]
           ((in[10 + inPos] & 8191L) >>> 7)) & 255);
      out[17 + outPos] = (byte)((
          //                       [7654321_]
          //                 [______6543210]
           ((in[10 + inPos] & 8191L) <<  1)
        | //                       [_______0]
          //                              [2____________]
           ((in[11 + inPos] & 8191L) >>> 12)) & 255);
      out[18 + outPos] = (byte)((
          //                       [76543210]
          //                      [_10987654____]
           ((in[11 + inPos] & 8191L) >>> 4)) & 255);
      out[19 + outPos] = (byte)((
          //                       [7654____]
          //              [_________3210]
           ((in[11 + inPos] & 8191L) <<  4)
        | //                       [____3210]
          //                           [2109_________]
           ((in[12 + inPos] & 8191L) >>> 9)) & 255);
      out[20 + outPos] = (byte)((
          //                       [76543210]
          //                   [____87654321_]
           ((in[12 + inPos] & 8191L) >>> 1)) & 255);
      out[21 + outPos] = (byte)((
          //                       [7_______]
          //           [____________0]
           ((in[12 + inPos] & 8191L) <<  7)
        | //                       [_6543210]
          //                        [2109876______]
           ((in[13 + inPos] & 8191L) >>> 6)) & 255);
      out[22 + outPos] = (byte)((
          //                       [765432__]
          //                [_______543210]
           ((in[13 + inPos] & 8191L) <<  2)
        | //                       [______10]
          //                             [21___________]
           ((in[14 + inPos] & 8191L) >>> 11)) & 255);
      out[23 + outPos] = (byte)((
          //                       [76543210]
          //                     [__09876543___]
           ((in[14 + inPos] & 8191L) >>> 3)) & 255);
      out[24 + outPos] = (byte)((
          //                       [765_____]
          //             [__________210]
           ((in[14 + inPos] & 8191L) <<  5)
        | //                       [___43210]
          //                          [21098________]
           ((in[15 + inPos] & 8191L) >>> 8)) & 255);
      out[25 + outPos] = (byte)((
          //                       [76543210]
          //                  [_____76543210]
           ((in[15 + inPos] & 8191L))) & 255);
      out[26 + outPos] = (byte)((
          //                       [76543210]
          //                       [21098765_____]
           ((in[16 + inPos] & 8191L) >>> 5)) & 255);
      out[27 + outPos] = (byte)((
          //                       [76543___]
          //               [________43210]
           ((in[16 + inPos] & 8191L) <<  3)
        | //                       [_____210]
          //                            [210__________]
           ((in[17 + inPos] & 8191L) >>> 10)) & 255);
      out[28 + outPos] = (byte)((
          //                       [76543210]
          //                    [___98765432__]
           ((in[17 + inPos] & 8191L) >>> 2)) & 255);
      out[29 + outPos] = (byte)((
          //                       [76______]
          //            [___________10]
           ((in[17 + inPos] & 8191L) <<  6)
        | //                       [__543210]
          //                         [210987_______]
           ((in[18 + inPos] & 8191L) >>> 7)) & 255);
      out[30 + outPos] = (byte)((
          //                       [7654321_]
          //                 [______6543210]
           ((in[18 + inPos] & 8191L) <<  1)
        | //                       [_______0]
          //                              [2____________]
           ((in[19 + inPos] & 8191L) >>> 12)) & 255);
      out[31 + outPos] = (byte)((
          //                       [76543210]
          //                      [_10987654____]
           ((in[19 + inPos] & 8191L) >>> 4)) & 255);
      out[32 + outPos] = (byte)((
          //                       [7654____]
          //              [_________3210]
           ((in[19 + inPos] & 8191L) <<  4)
        | //                       [____3210]
          //                           [2109_________]
           ((in[20 + inPos] & 8191L) >>> 9)) & 255);
      out[33 + outPos] = (byte)((
          //                       [76543210]
          //                   [____87654321_]
           ((in[20 + inPos] & 8191L) >>> 1)) & 255);
      out[34 + outPos] = (byte)((
          //                       [7_______]
          //           [____________0]
           ((in[20 + inPos] & 8191L) <<  7)
        | //                       [_6543210]
          //                        [2109876______]
           ((in[21 + inPos] & 8191L) >>> 6)) & 255);
      out[35 + outPos] = (byte)((
          //                       [765432__]
          //                [_______543210]
           ((in[21 + inPos] & 8191L) <<  2)
        | //                       [______10]
          //                             [21___________]
           ((in[22 + inPos] & 8191L) >>> 11)) & 255);
      out[36 + outPos] = (byte)((
          //                       [76543210]
          //                     [__09876543___]
           ((in[22 + inPos] & 8191L) >>> 3)) & 255);
      out[37 + outPos] = (byte)((
          //                       [765_____]
          //             [__________210]
           ((in[22 + inPos] & 8191L) <<  5)
        | //                       [___43210]
          //                          [21098________]
           ((in[23 + inPos] & 8191L) >>> 8)) & 255);
      out[38 + outPos] = (byte)((
          //                       [76543210]
          //                  [_____76543210]
           ((in[23 + inPos] & 8191L))) & 255);
      out[39 + outPos] = (byte)((
          //                       [76543210]
          //                       [21098765_____]
           ((in[24 + inPos] & 8191L) >>> 5)) & 255);
      out[40 + outPos] = (byte)((
          //                       [76543___]
          //               [________43210]
           ((in[24 + inPos] & 8191L) <<  3)
        | //                       [_____210]
          //                            [210__________]
           ((in[25 + inPos] & 8191L) >>> 10)) & 255);
      out[41 + outPos] = (byte)((
          //                       [76543210]
          //                    [___98765432__]
           ((in[25 + inPos] & 8191L) >>> 2)) & 255);
      out[42 + outPos] = (byte)((
          //                       [76______]
          //            [___________10]
           ((in[25 + inPos] & 8191L) <<  6)
        | //                       [__543210]
          //                         [210987_______]
           ((in[26 + inPos] & 8191L) >>> 7)) & 255);
      out[43 + outPos] = (byte)((
          //                       [7654321_]
          //                 [______6543210]
           ((in[26 + inPos] & 8191L) <<  1)
        | //                       [_______0]
          //                              [2____________]
           ((in[27 + inPos] & 8191L) >>> 12)) & 255);
      out[44 + outPos] = (byte)((
          //                       [76543210]
          //                      [_10987654____]
           ((in[27 + inPos] & 8191L) >>> 4)) & 255);
      out[45 + outPos] = (byte)((
          //                       [7654____]
          //              [_________3210]
           ((in[27 + inPos] & 8191L) <<  4)
        | //                       [____3210]
          //                           [2109_________]
           ((in[28 + inPos] & 8191L) >>> 9)) & 255);
      out[46 + outPos] = (byte)((
          //                       [76543210]
          //                   [____87654321_]
           ((in[28 + inPos] & 8191L) >>> 1)) & 255);
      out[47 + outPos] = (byte)((
          //                       [7_______]
          //           [____________0]
           ((in[28 + inPos] & 8191L) <<  7)
        | //                       [_6543210]
          //                        [2109876______]
           ((in[29 + inPos] & 8191L) >>> 6)) & 255);
      out[48 + outPos] = (byte)((
          //                       [765432__]
          //                [_______543210]
           ((in[29 + inPos] & 8191L) <<  2)
        | //                       [______10]
          //                             [21___________]
           ((in[30 + inPos] & 8191L) >>> 11)) & 255);
      out[49 + outPos] = (byte)((
          //                       [76543210]
          //                     [__09876543___]
           ((in[30 + inPos] & 8191L) >>> 3)) & 255);
      out[50 + outPos] = (byte)((
          //                       [765_____]
          //             [__________210]
           ((in[30 + inPos] & 8191L) <<  5)
        | //                       [___43210]
          //                          [21098________]
           ((in[31 + inPos] & 8191L) >>> 8)) & 255);
      out[51 + outPos] = (byte)((
          //                       [76543210]
          //                  [_____76543210]
           ((in[31 + inPos] & 8191L))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                       [76543210]
          //                       [21098765_____]
            ((((long)in[ 0 + inPos]) <<  5) & 8191L)
        | //                       [76543___]
          //               [________43210]
            ((((long)in[ 1 + inPos]) >>  3) & 31L);
      out[ 1 + outPos] =
          //                       [_____210]
          //                            [210__________]
            ((((long)in[ 1 + inPos]) <<  10) & 8191L)
        | //                       [76543210]
          //                    [___98765432__]
            ((((long)in[ 2 + inPos]) <<  2) & 1023L)
        | //                       [76______]
          //            [___________10]
            ((((long)in[ 3 + inPos]) >>  6) & 3L);
      out[ 2 + outPos] =
          //                       [__543210]
          //                         [210987_______]
            ((((long)in[ 3 + inPos]) <<  7) & 8191L)
        | //                       [7654321_]
          //                 [______6543210]
            ((((long)in[ 4 + inPos]) >>  1) & 127L);
      out[ 3 + outPos] =
          //                       [_______0]
          //                              [2____________]
            ((((long)in[ 4 + inPos]) <<  12) & 8191L)
        | //                       [76543210]
          //                      [_10987654____]
            ((((long)in[ 5 + inPos]) <<  4) & 4095L)
        | //                       [7654____]
          //              [_________3210]
            ((((long)in[ 6 + inPos]) >>  4) & 15L);
      out[ 4 + outPos] =
          //                       [____3210]
          //                           [2109_________]
            ((((long)in[ 6 + inPos]) <<  9) & 8191L)
        | //                       [76543210]
          //                   [____87654321_]
            ((((long)in[ 7 + inPos]) <<  1) & 511L)
        | //                       [7_______]
          //           [____________0]
            ((((long)in[ 8 + inPos]) >>  7) & 1L);
      out[ 5 + outPos] =
          //                       [_6543210]
          //                        [2109876______]
            ((((long)in[ 8 + inPos]) <<  6) & 8191L)
        | //                       [765432__]
          //                [_______543210]
            ((((long)in[ 9 + inPos]) >>  2) & 63L);
      out[ 6 + outPos] =
          //                       [______10]
          //                             [21___________]
            ((((long)in[ 9 + inPos]) <<  11) & 8191L)
        | //                       [76543210]
          //                     [__09876543___]
            ((((long)in[10 + inPos]) <<  3) & 2047L)
        | //                       [765_____]
          //             [__________210]
            ((((long)in[11 + inPos]) >>  5) & 7L);
      out[ 7 + outPos] =
          //                       [___43210]
          //                          [21098________]
            ((((long)in[11 + inPos]) <<  8) & 8191L)
        | //                       [76543210]
          //                  [_____76543210]
            ((((long)in[12 + inPos]) ) & 255L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                       [76543210]
          //                       [21098765_____]
            ((((long)in.get( 0 + inPos)) <<  5) & 8191L)
        | //                       [76543___]
          //               [________43210]
            ((((long)in.get( 1 + inPos)) >>  3) & 31L);
      out[ 1 + outPos] =
          //                       [_____210]
          //                            [210__________]
            ((((long)in.get( 1 + inPos)) <<  10) & 8191L)
        | //                       [76543210]
          //                    [___98765432__]
            ((((long)in.get( 2 + inPos)) <<  2) & 1023L)
        | //                       [76______]
          //            [___________10]
            ((((long)in.get( 3 + inPos)) >>  6) & 3L);
      out[ 2 + outPos] =
          //                       [__543210]
          //                         [210987_______]
            ((((long)in.get( 3 + inPos)) <<  7) & 8191L)
        | //                       [7654321_]
          //                 [______6543210]
            ((((long)in.get( 4 + inPos)) >>  1) & 127L);
      out[ 3 + outPos] =
          //                       [_______0]
          //                              [2____________]
            ((((long)in.get( 4 + inPos)) <<  12) & 8191L)
        | //                       [76543210]
          //                      [_10987654____]
            ((((long)in.get( 5 + inPos)) <<  4) & 4095L)
        | //                       [7654____]
          //              [_________3210]
            ((((long)in.get( 6 + inPos)) >>  4) & 15L);
      out[ 4 + outPos] =
          //                       [____3210]
          //                           [2109_________]
            ((((long)in.get( 6 + inPos)) <<  9) & 8191L)
        | //                       [76543210]
          //                   [____87654321_]
            ((((long)in.get( 7 + inPos)) <<  1) & 511L)
        | //                       [7_______]
          //           [____________0]
            ((((long)in.get( 8 + inPos)) >>  7) & 1L);
      out[ 5 + outPos] =
          //                       [_6543210]
          //                        [2109876______]
            ((((long)in.get( 8 + inPos)) <<  6) & 8191L)
        | //                       [765432__]
          //                [_______543210]
            ((((long)in.get( 9 + inPos)) >>  2) & 63L);
      out[ 6 + outPos] =
          //                       [______10]
          //                             [21___________]
            ((((long)in.get( 9 + inPos)) <<  11) & 8191L)
        | //                       [76543210]
          //                     [__09876543___]
            ((((long)in.get(10 + inPos)) <<  3) & 2047L)
        | //                       [765_____]
          //             [__________210]
            ((((long)in.get(11 + inPos)) >>  5) & 7L);
      out[ 7 + outPos] =
          //                       [___43210]
          //                          [21098________]
            ((((long)in.get(11 + inPos)) <<  8) & 8191L)
        | //                       [76543210]
          //                  [_____76543210]
            ((((long)in.get(12 + inPos)) ) & 255L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                       [76543210]
          //                       [21098765_____]
            ((((long)in[ 0 + inPos]) <<  5) & 8191L)
        | //                       [76543___]
          //               [________43210]
            ((((long)in[ 1 + inPos]) >>  3) & 31L);
      out[ 1 + outPos] =
          //                       [_____210]
          //                            [210__________]
            ((((long)in[ 1 + inPos]) <<  10) & 8191L)
        | //                       [76543210]
          //                    [___98765432__]
            ((((long)in[ 2 + inPos]) <<  2) & 1023L)
        | //                       [76______]
          //            [___________10]
            ((((long)in[ 3 + inPos]) >>  6) & 3L);
      out[ 2 + outPos] =
          //                       [__543210]
          //                         [210987_______]
            ((((long)in[ 3 + inPos]) <<  7) & 8191L)
        | //                       [7654321_]
          //                 [______6543210]
            ((((long)in[ 4 + inPos]) >>  1) & 127L);
      out[ 3 + outPos] =
          //                       [_______0]
          //                              [2____________]
            ((((long)in[ 4 + inPos]) <<  12) & 8191L)
        | //                       [76543210]
          //                      [_10987654____]
            ((((long)in[ 5 + inPos]) <<  4) & 4095L)
        | //                       [7654____]
          //              [_________3210]
            ((((long)in[ 6 + inPos]) >>  4) & 15L);
      out[ 4 + outPos] =
          //                       [____3210]
          //                           [2109_________]
            ((((long)in[ 6 + inPos]) <<  9) & 8191L)
        | //                       [76543210]
          //                   [____87654321_]
            ((((long)in[ 7 + inPos]) <<  1) & 511L)
        | //                       [7_______]
          //           [____________0]
            ((((long)in[ 8 + inPos]) >>  7) & 1L);
      out[ 5 + outPos] =
          //                       [_6543210]
          //                        [2109876______]
            ((((long)in[ 8 + inPos]) <<  6) & 8191L)
        | //                       [765432__]
          //                [_______543210]
            ((((long)in[ 9 + inPos]) >>  2) & 63L);
      out[ 6 + outPos] =
          //                       [______10]
          //                             [21___________]
            ((((long)in[ 9 + inPos]) <<  11) & 8191L)
        | //                       [76543210]
          //                     [__09876543___]
            ((((long)in[10 + inPos]) <<  3) & 2047L)
        | //                       [765_____]
          //             [__________210]
            ((((long)in[11 + inPos]) >>  5) & 7L);
      out[ 7 + outPos] =
          //                       [___43210]
          //                          [21098________]
            ((((long)in[11 + inPos]) <<  8) & 8191L)
        | //                       [76543210]
          //                  [_____76543210]
            ((((long)in[12 + inPos]) ) & 255L);
      out[ 8 + outPos] =
          //                       [76543210]
          //                       [21098765_____]
            ((((long)in[13 + inPos]) <<  5) & 8191L)
        | //                       [76543___]
          //               [________43210]
            ((((long)in[14 + inPos]) >>  3) & 31L);
      out[ 9 + outPos] =
          //                       [_____210]
          //                            [210__________]
            ((((long)in[14 + inPos]) <<  10) & 8191L)
        | //                       [76543210]
          //                    [___98765432__]
            ((((long)in[15 + inPos]) <<  2) & 1023L)
        | //                       [76______]
          //            [___________10]
            ((((long)in[16 + inPos]) >>  6) & 3L);
      out[10 + outPos] =
          //                       [__543210]
          //                         [210987_______]
            ((((long)in[16 + inPos]) <<  7) & 8191L)
        | //                       [7654321_]
          //                 [______6543210]
            ((((long)in[17 + inPos]) >>  1) & 127L);
      out[11 + outPos] =
          //                       [_______0]
          //                              [2____________]
            ((((long)in[17 + inPos]) <<  12) & 8191L)
        | //                       [76543210]
          //                      [_10987654____]
            ((((long)in[18 + inPos]) <<  4) & 4095L)
        | //                       [7654____]
          //              [_________3210]
            ((((long)in[19 + inPos]) >>  4) & 15L);
      out[12 + outPos] =
          //                       [____3210]
          //                           [2109_________]
            ((((long)in[19 + inPos]) <<  9) & 8191L)
        | //                       [76543210]
          //                   [____87654321_]
            ((((long)in[20 + inPos]) <<  1) & 511L)
        | //                       [7_______]
          //           [____________0]
            ((((long)in[21 + inPos]) >>  7) & 1L);
      out[13 + outPos] =
          //                       [_6543210]
          //                        [2109876______]
            ((((long)in[21 + inPos]) <<  6) & 8191L)
        | //                       [765432__]
          //                [_______543210]
            ((((long)in[22 + inPos]) >>  2) & 63L);
      out[14 + outPos] =
          //                       [______10]
          //                             [21___________]
            ((((long)in[22 + inPos]) <<  11) & 8191L)
        | //                       [76543210]
          //                     [__09876543___]
            ((((long)in[23 + inPos]) <<  3) & 2047L)
        | //                       [765_____]
          //             [__________210]
            ((((long)in[24 + inPos]) >>  5) & 7L);
      out[15 + outPos] =
          //                       [___43210]
          //                          [21098________]
            ((((long)in[24 + inPos]) <<  8) & 8191L)
        | //                       [76543210]
          //                  [_____76543210]
            ((((long)in[25 + inPos]) ) & 255L);
      out[16 + outPos] =
          //                       [76543210]
          //                       [21098765_____]
            ((((long)in[26 + inPos]) <<  5) & 8191L)
        | //                       [76543___]
          //               [________43210]
            ((((long)in[27 + inPos]) >>  3) & 31L);
      out[17 + outPos] =
          //                       [_____210]
          //                            [210__________]
            ((((long)in[27 + inPos]) <<  10) & 8191L)
        | //                       [76543210]
          //                    [___98765432__]
            ((((long)in[28 + inPos]) <<  2) & 1023L)
        | //                       [76______]
          //            [___________10]
            ((((long)in[29 + inPos]) >>  6) & 3L);
      out[18 + outPos] =
          //                       [__543210]
          //                         [210987_______]
            ((((long)in[29 + inPos]) <<  7) & 8191L)
        | //                       [7654321_]
          //                 [______6543210]
            ((((long)in[30 + inPos]) >>  1) & 127L);
      out[19 + outPos] =
          //                       [_______0]
          //                              [2____________]
            ((((long)in[30 + inPos]) <<  12) & 8191L)
        | //                       [76543210]
          //                      [_10987654____]
            ((((long)in[31 + inPos]) <<  4) & 4095L)
        | //                       [7654____]
          //              [_________3210]
            ((((long)in[32 + inPos]) >>  4) & 15L);
      out[20 + outPos] =
          //                       [____3210]
          //                           [2109_________]
            ((((long)in[32 + inPos]) <<  9) & 8191L)
        | //                       [76543210]
          //                   [____87654321_]
            ((((long)in[33 + inPos]) <<  1) & 511L)
        | //                       [7_______]
          //           [____________0]
            ((((long)in[34 + inPos]) >>  7) & 1L);
      out[21 + outPos] =
          //                       [_6543210]
          //                        [2109876______]
            ((((long)in[34 + inPos]) <<  6) & 8191L)
        | //                       [765432__]
          //                [_______543210]
            ((((long)in[35 + inPos]) >>  2) & 63L);
      out[22 + outPos] =
          //                       [______10]
          //                             [21___________]
            ((((long)in[35 + inPos]) <<  11) & 8191L)
        | //                       [76543210]
          //                     [__09876543___]
            ((((long)in[36 + inPos]) <<  3) & 2047L)
        | //                       [765_____]
          //             [__________210]
            ((((long)in[37 + inPos]) >>  5) & 7L);
      out[23 + outPos] =
          //                       [___43210]
          //                          [21098________]
            ((((long)in[37 + inPos]) <<  8) & 8191L)
        | //                       [76543210]
          //                  [_____76543210]
            ((((long)in[38 + inPos]) ) & 255L);
      out[24 + outPos] =
          //                       [76543210]
          //                       [21098765_____]
            ((((long)in[39 + inPos]) <<  5) & 8191L)
        | //                       [76543___]
          //               [________43210]
            ((((long)in[40 + inPos]) >>  3) & 31L);
      out[25 + outPos] =
          //                       [_____210]
          //                            [210__________]
            ((((long)in[40 + inPos]) <<  10) & 8191L)
        | //                       [76543210]
          //                    [___98765432__]
            ((((long)in[41 + inPos]) <<  2) & 1023L)
        | //                       [76______]
          //            [___________10]
            ((((long)in[42 + inPos]) >>  6) & 3L);
      out[26 + outPos] =
          //                       [__543210]
          //                         [210987_______]
            ((((long)in[42 + inPos]) <<  7) & 8191L)
        | //                       [7654321_]
          //                 [______6543210]
            ((((long)in[43 + inPos]) >>  1) & 127L);
      out[27 + outPos] =
          //                       [_______0]
          //                              [2____________]
            ((((long)in[43 + inPos]) <<  12) & 8191L)
        | //                       [76543210]
          //                      [_10987654____]
            ((((long)in[44 + inPos]) <<  4) & 4095L)
        | //                       [7654____]
          //              [_________3210]
            ((((long)in[45 + inPos]) >>  4) & 15L);
      out[28 + outPos] =
          //                       [____3210]
          //                           [2109_________]
            ((((long)in[45 + inPos]) <<  9) & 8191L)
        | //                       [76543210]
          //                   [____87654321_]
            ((((long)in[46 + inPos]) <<  1) & 511L)
        | //                       [7_______]
          //           [____________0]
            ((((long)in[47 + inPos]) >>  7) & 1L);
      out[29 + outPos] =
          //                       [_6543210]
          //                        [2109876______]
            ((((long)in[47 + inPos]) <<  6) & 8191L)
        | //                       [765432__]
          //                [_______543210]
            ((((long)in[48 + inPos]) >>  2) & 63L);
      out[30 + outPos] =
          //                       [______10]
          //                             [21___________]
            ((((long)in[48 + inPos]) <<  11) & 8191L)
        | //                       [76543210]
          //                     [__09876543___]
            ((((long)in[49 + inPos]) <<  3) & 2047L)
        | //                       [765_____]
          //             [__________210]
            ((((long)in[50 + inPos]) >>  5) & 7L);
      out[31 + outPos] =
          //                       [___43210]
          //                          [21098________]
            ((((long)in[50 + inPos]) <<  8) & 8191L)
        | //                       [76543210]
          //                  [_____76543210]
            ((((long)in[51 + inPos]) ) & 255L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                       [76543210]
          //                       [21098765_____]
            ((((long)in.get( 0 + inPos)) <<  5) & 8191L)
        | //                       [76543___]
          //               [________43210]
            ((((long)in.get( 1 + inPos)) >>  3) & 31L);
      out[ 1 + outPos] =
          //                       [_____210]
          //                            [210__________]
            ((((long)in.get( 1 + inPos)) <<  10) & 8191L)
        | //                       [76543210]
          //                    [___98765432__]
            ((((long)in.get( 2 + inPos)) <<  2) & 1023L)
        | //                       [76______]
          //            [___________10]
            ((((long)in.get( 3 + inPos)) >>  6) & 3L);
      out[ 2 + outPos] =
          //                       [__543210]
          //                         [210987_______]
            ((((long)in.get( 3 + inPos)) <<  7) & 8191L)
        | //                       [7654321_]
          //                 [______6543210]
            ((((long)in.get( 4 + inPos)) >>  1) & 127L);
      out[ 3 + outPos] =
          //                       [_______0]
          //                              [2____________]
            ((((long)in.get( 4 + inPos)) <<  12) & 8191L)
        | //                       [76543210]
          //                      [_10987654____]
            ((((long)in.get( 5 + inPos)) <<  4) & 4095L)
        | //                       [7654____]
          //              [_________3210]
            ((((long)in.get( 6 + inPos)) >>  4) & 15L);
      out[ 4 + outPos] =
          //                       [____3210]
          //                           [2109_________]
            ((((long)in.get( 6 + inPos)) <<  9) & 8191L)
        | //                       [76543210]
          //                   [____87654321_]
            ((((long)in.get( 7 + inPos)) <<  1) & 511L)
        | //                       [7_______]
          //           [____________0]
            ((((long)in.get( 8 + inPos)) >>  7) & 1L);
      out[ 5 + outPos] =
          //                       [_6543210]
          //                        [2109876______]
            ((((long)in.get( 8 + inPos)) <<  6) & 8191L)
        | //                       [765432__]
          //                [_______543210]
            ((((long)in.get( 9 + inPos)) >>  2) & 63L);
      out[ 6 + outPos] =
          //                       [______10]
          //                             [21___________]
            ((((long)in.get( 9 + inPos)) <<  11) & 8191L)
        | //                       [76543210]
          //                     [__09876543___]
            ((((long)in.get(10 + inPos)) <<  3) & 2047L)
        | //                       [765_____]
          //             [__________210]
            ((((long)in.get(11 + inPos)) >>  5) & 7L);
      out[ 7 + outPos] =
          //                       [___43210]
          //                          [21098________]
            ((((long)in.get(11 + inPos)) <<  8) & 8191L)
        | //                       [76543210]
          //                  [_____76543210]
            ((((long)in.get(12 + inPos)) ) & 255L);
      out[ 8 + outPos] =
          //                       [76543210]
          //                       [21098765_____]
            ((((long)in.get(13 + inPos)) <<  5) & 8191L)
        | //                       [76543___]
          //               [________43210]
            ((((long)in.get(14 + inPos)) >>  3) & 31L);
      out[ 9 + outPos] =
          //                       [_____210]
          //                            [210__________]
            ((((long)in.get(14 + inPos)) <<  10) & 8191L)
        | //                       [76543210]
          //                    [___98765432__]
            ((((long)in.get(15 + inPos)) <<  2) & 1023L)
        | //                       [76______]
          //            [___________10]
            ((((long)in.get(16 + inPos)) >>  6) & 3L);
      out[10 + outPos] =
          //                       [__543210]
          //                         [210987_______]
            ((((long)in.get(16 + inPos)) <<  7) & 8191L)
        | //                       [7654321_]
          //                 [______6543210]
            ((((long)in.get(17 + inPos)) >>  1) & 127L);
      out[11 + outPos] =
          //                       [_______0]
          //                              [2____________]
            ((((long)in.get(17 + inPos)) <<  12) & 8191L)
        | //                       [76543210]
          //                      [_10987654____]
            ((((long)in.get(18 + inPos)) <<  4) & 4095L)
        | //                       [7654____]
          //              [_________3210]
            ((((long)in.get(19 + inPos)) >>  4) & 15L);
      out[12 + outPos] =
          //                       [____3210]
          //                           [2109_________]
            ((((long)in.get(19 + inPos)) <<  9) & 8191L)
        | //                       [76543210]
          //                   [____87654321_]
            ((((long)in.get(20 + inPos)) <<  1) & 511L)
        | //                       [7_______]
          //           [____________0]
            ((((long)in.get(21 + inPos)) >>  7) & 1L);
      out[13 + outPos] =
          //                       [_6543210]
          //                        [2109876______]
            ((((long)in.get(21 + inPos)) <<  6) & 8191L)
        | //                       [765432__]
          //                [_______543210]
            ((((long)in.get(22 + inPos)) >>  2) & 63L);
      out[14 + outPos] =
          //                       [______10]
          //                             [21___________]
            ((((long)in.get(22 + inPos)) <<  11) & 8191L)
        | //                       [76543210]
          //                     [__09876543___]
            ((((long)in.get(23 + inPos)) <<  3) & 2047L)
        | //                       [765_____]
          //             [__________210]
            ((((long)in.get(24 + inPos)) >>  5) & 7L);
      out[15 + outPos] =
          //                       [___43210]
          //                          [21098________]
            ((((long)in.get(24 + inPos)) <<  8) & 8191L)
        | //                       [76543210]
          //                  [_____76543210]
            ((((long)in.get(25 + inPos)) ) & 255L);
      out[16 + outPos] =
          //                       [76543210]
          //                       [21098765_____]
            ((((long)in.get(26 + inPos)) <<  5) & 8191L)
        | //                       [76543___]
          //               [________43210]
            ((((long)in.get(27 + inPos)) >>  3) & 31L);
      out[17 + outPos] =
          //                       [_____210]
          //                            [210__________]
            ((((long)in.get(27 + inPos)) <<  10) & 8191L)
        | //                       [76543210]
          //                    [___98765432__]
            ((((long)in.get(28 + inPos)) <<  2) & 1023L)
        | //                       [76______]
          //            [___________10]
            ((((long)in.get(29 + inPos)) >>  6) & 3L);
      out[18 + outPos] =
          //                       [__543210]
          //                         [210987_______]
            ((((long)in.get(29 + inPos)) <<  7) & 8191L)
        | //                       [7654321_]
          //                 [______6543210]
            ((((long)in.get(30 + inPos)) >>  1) & 127L);
      out[19 + outPos] =
          //                       [_______0]
          //                              [2____________]
            ((((long)in.get(30 + inPos)) <<  12) & 8191L)
        | //                       [76543210]
          //                      [_10987654____]
            ((((long)in.get(31 + inPos)) <<  4) & 4095L)
        | //                       [7654____]
          //              [_________3210]
            ((((long)in.get(32 + inPos)) >>  4) & 15L);
      out[20 + outPos] =
          //                       [____3210]
          //                           [2109_________]
            ((((long)in.get(32 + inPos)) <<  9) & 8191L)
        | //                       [76543210]
          //                   [____87654321_]
            ((((long)in.get(33 + inPos)) <<  1) & 511L)
        | //                       [7_______]
          //           [____________0]
            ((((long)in.get(34 + inPos)) >>  7) & 1L);
      out[21 + outPos] =
          //                       [_6543210]
          //                        [2109876______]
            ((((long)in.get(34 + inPos)) <<  6) & 8191L)
        | //                       [765432__]
          //                [_______543210]
            ((((long)in.get(35 + inPos)) >>  2) & 63L);
      out[22 + outPos] =
          //                       [______10]
          //                             [21___________]
            ((((long)in.get(35 + inPos)) <<  11) & 8191L)
        | //                       [76543210]
          //                     [__09876543___]
            ((((long)in.get(36 + inPos)) <<  3) & 2047L)
        | //                       [765_____]
          //             [__________210]
            ((((long)in.get(37 + inPos)) >>  5) & 7L);
      out[23 + outPos] =
          //                       [___43210]
          //                          [21098________]
            ((((long)in.get(37 + inPos)) <<  8) & 8191L)
        | //                       [76543210]
          //                  [_____76543210]
            ((((long)in.get(38 + inPos)) ) & 255L);
      out[24 + outPos] =
          //                       [76543210]
          //                       [21098765_____]
            ((((long)in.get(39 + inPos)) <<  5) & 8191L)
        | //                       [76543___]
          //               [________43210]
            ((((long)in.get(40 + inPos)) >>  3) & 31L);
      out[25 + outPos] =
          //                       [_____210]
          //                            [210__________]
            ((((long)in.get(40 + inPos)) <<  10) & 8191L)
        | //                       [76543210]
          //                    [___98765432__]
            ((((long)in.get(41 + inPos)) <<  2) & 1023L)
        | //                       [76______]
          //            [___________10]
            ((((long)in.get(42 + inPos)) >>  6) & 3L);
      out[26 + outPos] =
          //                       [__543210]
          //                         [210987_______]
            ((((long)in.get(42 + inPos)) <<  7) & 8191L)
        | //                       [7654321_]
          //                 [______6543210]
            ((((long)in.get(43 + inPos)) >>  1) & 127L);
      out[27 + outPos] =
          //                       [_______0]
          //                              [2____________]
            ((((long)in.get(43 + inPos)) <<  12) & 8191L)
        | //                       [76543210]
          //                      [_10987654____]
            ((((long)in.get(44 + inPos)) <<  4) & 4095L)
        | //                       [7654____]
          //              [_________3210]
            ((((long)in.get(45 + inPos)) >>  4) & 15L);
      out[28 + outPos] =
          //                       [____3210]
          //                           [2109_________]
            ((((long)in.get(45 + inPos)) <<  9) & 8191L)
        | //                       [76543210]
          //                   [____87654321_]
            ((((long)in.get(46 + inPos)) <<  1) & 511L)
        | //                       [7_______]
          //           [____________0]
            ((((long)in.get(47 + inPos)) >>  7) & 1L);
      out[29 + outPos] =
          //                       [_6543210]
          //                        [2109876______]
            ((((long)in.get(47 + inPos)) <<  6) & 8191L)
        | //                       [765432__]
          //                [_______543210]
            ((((long)in.get(48 + inPos)) >>  2) & 63L);
      out[30 + outPos] =
          //                       [______10]
          //                             [21___________]
            ((((long)in.get(48 + inPos)) <<  11) & 8191L)
        | //                       [76543210]
          //                     [__09876543___]
            ((((long)in.get(49 + inPos)) <<  3) & 2047L)
        | //                       [765_____]
          //             [__________210]
            ((((long)in.get(50 + inPos)) >>  5) & 7L);
      out[31 + outPos] =
          //                       [___43210]
          //                          [21098________]
            ((((long)in.get(50 + inPos)) <<  8) & 8191L)
        | //                       [76543210]
          //                  [_____76543210]
            ((((long)in.get(51 + inPos)) ) & 255L);
    }
  }

  private static final class Packer14 extends BytePackerForLong {

    private Packer14() {
      super(14);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                        [76543210]
          //                        [32109876______]
           ((in[ 0 + inPos] & 16383L) >>> 6)) & 255);
      out[ 1 + outPos] = (byte)((
          //                        [765432__]
          //                [________543210]
           ((in[ 0 + inPos] & 16383L) <<  2)
        | //                        [______10]
          //                              [32____________]
           ((in[ 1 + inPos] & 16383L) >>> 12)) & 255);
      out[ 2 + outPos] = (byte)((
          //                        [76543210]
          //                      [__10987654____]
           ((in[ 1 + inPos] & 16383L) >>> 4)) & 255);
      out[ 3 + outPos] = (byte)((
          //                        [7654____]
          //              [__________3210]
           ((in[ 1 + inPos] & 16383L) <<  4)
        | //                        [____3210]
          //                            [3210__________]
           ((in[ 2 + inPos] & 16383L) >>> 10)) & 255);
      out[ 4 + outPos] = (byte)((
          //                        [76543210]
          //                    [____98765432__]
           ((in[ 2 + inPos] & 16383L) >>> 2)) & 255);
      out[ 5 + outPos] = (byte)((
          //                        [76______]
          //            [____________10]
           ((in[ 2 + inPos] & 16383L) <<  6)
        | //                        [__543210]
          //                          [321098________]
           ((in[ 3 + inPos] & 16383L) >>> 8)) & 255);
      out[ 6 + outPos] = (byte)((
          //                        [76543210]
          //                  [______76543210]
           ((in[ 3 + inPos] & 16383L))) & 255);
      out[ 7 + outPos] = (byte)((
          //                        [76543210]
          //                        [32109876______]
           ((in[ 4 + inPos] & 16383L) >>> 6)) & 255);
      out[ 8 + outPos] = (byte)((
          //                        [765432__]
          //                [________543210]
           ((in[ 4 + inPos] & 16383L) <<  2)
        | //                        [______10]
          //                              [32____________]
           ((in[ 5 + inPos] & 16383L) >>> 12)) & 255);
      out[ 9 + outPos] = (byte)((
          //                        [76543210]
          //                      [__10987654____]
           ((in[ 5 + inPos] & 16383L) >>> 4)) & 255);
      out[10 + outPos] = (byte)((
          //                        [7654____]
          //              [__________3210]
           ((in[ 5 + inPos] & 16383L) <<  4)
        | //                        [____3210]
          //                            [3210__________]
           ((in[ 6 + inPos] & 16383L) >>> 10)) & 255);
      out[11 + outPos] = (byte)((
          //                        [76543210]
          //                    [____98765432__]
           ((in[ 6 + inPos] & 16383L) >>> 2)) & 255);
      out[12 + outPos] = (byte)((
          //                        [76______]
          //            [____________10]
           ((in[ 6 + inPos] & 16383L) <<  6)
        | //                        [__543210]
          //                          [321098________]
           ((in[ 7 + inPos] & 16383L) >>> 8)) & 255);
      out[13 + outPos] = (byte)((
          //                        [76543210]
          //                  [______76543210]
           ((in[ 7 + inPos] & 16383L))) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                        [76543210]
          //                        [32109876______]
           ((in[ 0 + inPos] & 16383L) >>> 6)) & 255);
      out[ 1 + outPos] = (byte)((
          //                        [765432__]
          //                [________543210]
           ((in[ 0 + inPos] & 16383L) <<  2)
        | //                        [______10]
          //                              [32____________]
           ((in[ 1 + inPos] & 16383L) >>> 12)) & 255);
      out[ 2 + outPos] = (byte)((
          //                        [76543210]
          //                      [__10987654____]
           ((in[ 1 + inPos] & 16383L) >>> 4)) & 255);
      out[ 3 + outPos] = (byte)((
          //                        [7654____]
          //              [__________3210]
           ((in[ 1 + inPos] & 16383L) <<  4)
        | //                        [____3210]
          //                            [3210__________]
           ((in[ 2 + inPos] & 16383L) >>> 10)) & 255);
      out[ 4 + outPos] = (byte)((
          //                        [76543210]
          //                    [____98765432__]
           ((in[ 2 + inPos] & 16383L) >>> 2)) & 255);
      out[ 5 + outPos] = (byte)((
          //                        [76______]
          //            [____________10]
           ((in[ 2 + inPos] & 16383L) <<  6)
        | //                        [__543210]
          //                          [321098________]
           ((in[ 3 + inPos] & 16383L) >>> 8)) & 255);
      out[ 6 + outPos] = (byte)((
          //                        [76543210]
          //                  [______76543210]
           ((in[ 3 + inPos] & 16383L))) & 255);
      out[ 7 + outPos] = (byte)((
          //                        [76543210]
          //                        [32109876______]
           ((in[ 4 + inPos] & 16383L) >>> 6)) & 255);
      out[ 8 + outPos] = (byte)((
          //                        [765432__]
          //                [________543210]
           ((in[ 4 + inPos] & 16383L) <<  2)
        | //                        [______10]
          //                              [32____________]
           ((in[ 5 + inPos] & 16383L) >>> 12)) & 255);
      out[ 9 + outPos] = (byte)((
          //                        [76543210]
          //                      [__10987654____]
           ((in[ 5 + inPos] & 16383L) >>> 4)) & 255);
      out[10 + outPos] = (byte)((
          //                        [7654____]
          //              [__________3210]
           ((in[ 5 + inPos] & 16383L) <<  4)
        | //                        [____3210]
          //                            [3210__________]
           ((in[ 6 + inPos] & 16383L) >>> 10)) & 255);
      out[11 + outPos] = (byte)((
          //                        [76543210]
          //                    [____98765432__]
           ((in[ 6 + inPos] & 16383L) >>> 2)) & 255);
      out[12 + outPos] = (byte)((
          //                        [76______]
          //            [____________10]
           ((in[ 6 + inPos] & 16383L) <<  6)
        | //                        [__543210]
          //                          [321098________]
           ((in[ 7 + inPos] & 16383L) >>> 8)) & 255);
      out[13 + outPos] = (byte)((
          //                        [76543210]
          //                  [______76543210]
           ((in[ 7 + inPos] & 16383L))) & 255);
      out[14 + outPos] = (byte)((
          //                        [76543210]
          //                        [32109876______]
           ((in[ 8 + inPos] & 16383L) >>> 6)) & 255);
      out[15 + outPos] = (byte)((
          //                        [765432__]
          //                [________543210]
           ((in[ 8 + inPos] & 16383L) <<  2)
        | //                        [______10]
          //                              [32____________]
           ((in[ 9 + inPos] & 16383L) >>> 12)) & 255);
      out[16 + outPos] = (byte)((
          //                        [76543210]
          //                      [__10987654____]
           ((in[ 9 + inPos] & 16383L) >>> 4)) & 255);
      out[17 + outPos] = (byte)((
          //                        [7654____]
          //              [__________3210]
           ((in[ 9 + inPos] & 16383L) <<  4)
        | //                        [____3210]
          //                            [3210__________]
           ((in[10 + inPos] & 16383L) >>> 10)) & 255);
      out[18 + outPos] = (byte)((
          //                        [76543210]
          //                    [____98765432__]
           ((in[10 + inPos] & 16383L) >>> 2)) & 255);
      out[19 + outPos] = (byte)((
          //                        [76______]
          //            [____________10]
           ((in[10 + inPos] & 16383L) <<  6)
        | //                        [__543210]
          //                          [321098________]
           ((in[11 + inPos] & 16383L) >>> 8)) & 255);
      out[20 + outPos] = (byte)((
          //                        [76543210]
          //                  [______76543210]
           ((in[11 + inPos] & 16383L))) & 255);
      out[21 + outPos] = (byte)((
          //                        [76543210]
          //                        [32109876______]
           ((in[12 + inPos] & 16383L) >>> 6)) & 255);
      out[22 + outPos] = (byte)((
          //                        [765432__]
          //                [________543210]
           ((in[12 + inPos] & 16383L) <<  2)
        | //                        [______10]
          //                              [32____________]
           ((in[13 + inPos] & 16383L) >>> 12)) & 255);
      out[23 + outPos] = (byte)((
          //                        [76543210]
          //                      [__10987654____]
           ((in[13 + inPos] & 16383L) >>> 4)) & 255);
      out[24 + outPos] = (byte)((
          //                        [7654____]
          //              [__________3210]
           ((in[13 + inPos] & 16383L) <<  4)
        | //                        [____3210]
          //                            [3210__________]
           ((in[14 + inPos] & 16383L) >>> 10)) & 255);
      out[25 + outPos] = (byte)((
          //                        [76543210]
          //                    [____98765432__]
           ((in[14 + inPos] & 16383L) >>> 2)) & 255);
      out[26 + outPos] = (byte)((
          //                        [76______]
          //            [____________10]
           ((in[14 + inPos] & 16383L) <<  6)
        | //                        [__543210]
          //                          [321098________]
           ((in[15 + inPos] & 16383L) >>> 8)) & 255);
      out[27 + outPos] = (byte)((
          //                        [76543210]
          //                  [______76543210]
           ((in[15 + inPos] & 16383L))) & 255);
      out[28 + outPos] = (byte)((
          //                        [76543210]
          //                        [32109876______]
           ((in[16 + inPos] & 16383L) >>> 6)) & 255);
      out[29 + outPos] = (byte)((
          //                        [765432__]
          //                [________543210]
           ((in[16 + inPos] & 16383L) <<  2)
        | //                        [______10]
          //                              [32____________]
           ((in[17 + inPos] & 16383L) >>> 12)) & 255);
      out[30 + outPos] = (byte)((
          //                        [76543210]
          //                      [__10987654____]
           ((in[17 + inPos] & 16383L) >>> 4)) & 255);
      out[31 + outPos] = (byte)((
          //                        [7654____]
          //              [__________3210]
           ((in[17 + inPos] & 16383L) <<  4)
        | //                        [____3210]
          //                            [3210__________]
           ((in[18 + inPos] & 16383L) >>> 10)) & 255);
      out[32 + outPos] = (byte)((
          //                        [76543210]
          //                    [____98765432__]
           ((in[18 + inPos] & 16383L) >>> 2)) & 255);
      out[33 + outPos] = (byte)((
          //                        [76______]
          //            [____________10]
           ((in[18 + inPos] & 16383L) <<  6)
        | //                        [__543210]
          //                          [321098________]
           ((in[19 + inPos] & 16383L) >>> 8)) & 255);
      out[34 + outPos] = (byte)((
          //                        [76543210]
          //                  [______76543210]
           ((in[19 + inPos] & 16383L))) & 255);
      out[35 + outPos] = (byte)((
          //                        [76543210]
          //                        [32109876______]
           ((in[20 + inPos] & 16383L) >>> 6)) & 255);
      out[36 + outPos] = (byte)((
          //                        [765432__]
          //                [________543210]
           ((in[20 + inPos] & 16383L) <<  2)
        | //                        [______10]
          //                              [32____________]
           ((in[21 + inPos] & 16383L) >>> 12)) & 255);
      out[37 + outPos] = (byte)((
          //                        [76543210]
          //                      [__10987654____]
           ((in[21 + inPos] & 16383L) >>> 4)) & 255);
      out[38 + outPos] = (byte)((
          //                        [7654____]
          //              [__________3210]
           ((in[21 + inPos] & 16383L) <<  4)
        | //                        [____3210]
          //                            [3210__________]
           ((in[22 + inPos] & 16383L) >>> 10)) & 255);
      out[39 + outPos] = (byte)((
          //                        [76543210]
          //                    [____98765432__]
           ((in[22 + inPos] & 16383L) >>> 2)) & 255);
      out[40 + outPos] = (byte)((
          //                        [76______]
          //            [____________10]
           ((in[22 + inPos] & 16383L) <<  6)
        | //                        [__543210]
          //                          [321098________]
           ((in[23 + inPos] & 16383L) >>> 8)) & 255);
      out[41 + outPos] = (byte)((
          //                        [76543210]
          //                  [______76543210]
           ((in[23 + inPos] & 16383L))) & 255);
      out[42 + outPos] = (byte)((
          //                        [76543210]
          //                        [32109876______]
           ((in[24 + inPos] & 16383L) >>> 6)) & 255);
      out[43 + outPos] = (byte)((
          //                        [765432__]
          //                [________543210]
           ((in[24 + inPos] & 16383L) <<  2)
        | //                        [______10]
          //                              [32____________]
           ((in[25 + inPos] & 16383L) >>> 12)) & 255);
      out[44 + outPos] = (byte)((
          //                        [76543210]
          //                      [__10987654____]
           ((in[25 + inPos] & 16383L) >>> 4)) & 255);
      out[45 + outPos] = (byte)((
          //                        [7654____]
          //              [__________3210]
           ((in[25 + inPos] & 16383L) <<  4)
        | //                        [____3210]
          //                            [3210__________]
           ((in[26 + inPos] & 16383L) >>> 10)) & 255);
      out[46 + outPos] = (byte)((
          //                        [76543210]
          //                    [____98765432__]
           ((in[26 + inPos] & 16383L) >>> 2)) & 255);
      out[47 + outPos] = (byte)((
          //                        [76______]
          //            [____________10]
           ((in[26 + inPos] & 16383L) <<  6)
        | //                        [__543210]
          //                          [321098________]
           ((in[27 + inPos] & 16383L) >>> 8)) & 255);
      out[48 + outPos] = (byte)((
          //                        [76543210]
          //                  [______76543210]
           ((in[27 + inPos] & 16383L))) & 255);
      out[49 + outPos] = (byte)((
          //                        [76543210]
          //                        [32109876______]
           ((in[28 + inPos] & 16383L) >>> 6)) & 255);
      out[50 + outPos] = (byte)((
          //                        [765432__]
          //                [________543210]
           ((in[28 + inPos] & 16383L) <<  2)
        | //                        [______10]
          //                              [32____________]
           ((in[29 + inPos] & 16383L) >>> 12)) & 255);
      out[51 + outPos] = (byte)((
          //                        [76543210]
          //                      [__10987654____]
           ((in[29 + inPos] & 16383L) >>> 4)) & 255);
      out[52 + outPos] = (byte)((
          //                        [7654____]
          //              [__________3210]
           ((in[29 + inPos] & 16383L) <<  4)
        | //                        [____3210]
          //                            [3210__________]
           ((in[30 + inPos] & 16383L) >>> 10)) & 255);
      out[53 + outPos] = (byte)((
          //                        [76543210]
          //                    [____98765432__]
           ((in[30 + inPos] & 16383L) >>> 2)) & 255);
      out[54 + outPos] = (byte)((
          //                        [76______]
          //            [____________10]
           ((in[30 + inPos] & 16383L) <<  6)
        | //                        [__543210]
          //                          [321098________]
           ((in[31 + inPos] & 16383L) >>> 8)) & 255);
      out[55 + outPos] = (byte)((
          //                        [76543210]
          //                  [______76543210]
           ((in[31 + inPos] & 16383L))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                        [76543210]
          //                        [32109876______]
            ((((long)in[ 0 + inPos]) <<  6) & 16383L)
        | //                        [765432__]
          //                [________543210]
            ((((long)in[ 1 + inPos]) >>  2) & 63L);
      out[ 1 + outPos] =
          //                        [______10]
          //                              [32____________]
            ((((long)in[ 1 + inPos]) <<  12) & 16383L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in[ 2 + inPos]) <<  4) & 4095L)
        | //                        [7654____]
          //              [__________3210]
            ((((long)in[ 3 + inPos]) >>  4) & 15L);
      out[ 2 + outPos] =
          //                        [____3210]
          //                            [3210__________]
            ((((long)in[ 3 + inPos]) <<  10) & 16383L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in[ 4 + inPos]) <<  2) & 1023L)
        | //                        [76______]
          //            [____________10]
            ((((long)in[ 5 + inPos]) >>  6) & 3L);
      out[ 3 + outPos] =
          //                        [__543210]
          //                          [321098________]
            ((((long)in[ 5 + inPos]) <<  8) & 16383L)
        | //                        [76543210]
          //                  [______76543210]
            ((((long)in[ 6 + inPos]) ) & 255L);
      out[ 4 + outPos] =
          //                        [76543210]
          //                        [32109876______]
            ((((long)in[ 7 + inPos]) <<  6) & 16383L)
        | //                        [765432__]
          //                [________543210]
            ((((long)in[ 8 + inPos]) >>  2) & 63L);
      out[ 5 + outPos] =
          //                        [______10]
          //                              [32____________]
            ((((long)in[ 8 + inPos]) <<  12) & 16383L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in[ 9 + inPos]) <<  4) & 4095L)
        | //                        [7654____]
          //              [__________3210]
            ((((long)in[10 + inPos]) >>  4) & 15L);
      out[ 6 + outPos] =
          //                        [____3210]
          //                            [3210__________]
            ((((long)in[10 + inPos]) <<  10) & 16383L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in[11 + inPos]) <<  2) & 1023L)
        | //                        [76______]
          //            [____________10]
            ((((long)in[12 + inPos]) >>  6) & 3L);
      out[ 7 + outPos] =
          //                        [__543210]
          //                          [321098________]
            ((((long)in[12 + inPos]) <<  8) & 16383L)
        | //                        [76543210]
          //                  [______76543210]
            ((((long)in[13 + inPos]) ) & 255L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                        [76543210]
          //                        [32109876______]
            ((((long)in.get( 0 + inPos)) <<  6) & 16383L)
        | //                        [765432__]
          //                [________543210]
            ((((long)in.get( 1 + inPos)) >>  2) & 63L);
      out[ 1 + outPos] =
          //                        [______10]
          //                              [32____________]
            ((((long)in.get( 1 + inPos)) <<  12) & 16383L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in.get( 2 + inPos)) <<  4) & 4095L)
        | //                        [7654____]
          //              [__________3210]
            ((((long)in.get( 3 + inPos)) >>  4) & 15L);
      out[ 2 + outPos] =
          //                        [____3210]
          //                            [3210__________]
            ((((long)in.get( 3 + inPos)) <<  10) & 16383L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in.get( 4 + inPos)) <<  2) & 1023L)
        | //                        [76______]
          //            [____________10]
            ((((long)in.get( 5 + inPos)) >>  6) & 3L);
      out[ 3 + outPos] =
          //                        [__543210]
          //                          [321098________]
            ((((long)in.get( 5 + inPos)) <<  8) & 16383L)
        | //                        [76543210]
          //                  [______76543210]
            ((((long)in.get( 6 + inPos)) ) & 255L);
      out[ 4 + outPos] =
          //                        [76543210]
          //                        [32109876______]
            ((((long)in.get( 7 + inPos)) <<  6) & 16383L)
        | //                        [765432__]
          //                [________543210]
            ((((long)in.get( 8 + inPos)) >>  2) & 63L);
      out[ 5 + outPos] =
          //                        [______10]
          //                              [32____________]
            ((((long)in.get( 8 + inPos)) <<  12) & 16383L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in.get( 9 + inPos)) <<  4) & 4095L)
        | //                        [7654____]
          //              [__________3210]
            ((((long)in.get(10 + inPos)) >>  4) & 15L);
      out[ 6 + outPos] =
          //                        [____3210]
          //                            [3210__________]
            ((((long)in.get(10 + inPos)) <<  10) & 16383L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in.get(11 + inPos)) <<  2) & 1023L)
        | //                        [76______]
          //            [____________10]
            ((((long)in.get(12 + inPos)) >>  6) & 3L);
      out[ 7 + outPos] =
          //                        [__543210]
          //                          [321098________]
            ((((long)in.get(12 + inPos)) <<  8) & 16383L)
        | //                        [76543210]
          //                  [______76543210]
            ((((long)in.get(13 + inPos)) ) & 255L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                        [76543210]
          //                        [32109876______]
            ((((long)in[ 0 + inPos]) <<  6) & 16383L)
        | //                        [765432__]
          //                [________543210]
            ((((long)in[ 1 + inPos]) >>  2) & 63L);
      out[ 1 + outPos] =
          //                        [______10]
          //                              [32____________]
            ((((long)in[ 1 + inPos]) <<  12) & 16383L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in[ 2 + inPos]) <<  4) & 4095L)
        | //                        [7654____]
          //              [__________3210]
            ((((long)in[ 3 + inPos]) >>  4) & 15L);
      out[ 2 + outPos] =
          //                        [____3210]
          //                            [3210__________]
            ((((long)in[ 3 + inPos]) <<  10) & 16383L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in[ 4 + inPos]) <<  2) & 1023L)
        | //                        [76______]
          //            [____________10]
            ((((long)in[ 5 + inPos]) >>  6) & 3L);
      out[ 3 + outPos] =
          //                        [__543210]
          //                          [321098________]
            ((((long)in[ 5 + inPos]) <<  8) & 16383L)
        | //                        [76543210]
          //                  [______76543210]
            ((((long)in[ 6 + inPos]) ) & 255L);
      out[ 4 + outPos] =
          //                        [76543210]
          //                        [32109876______]
            ((((long)in[ 7 + inPos]) <<  6) & 16383L)
        | //                        [765432__]
          //                [________543210]
            ((((long)in[ 8 + inPos]) >>  2) & 63L);
      out[ 5 + outPos] =
          //                        [______10]
          //                              [32____________]
            ((((long)in[ 8 + inPos]) <<  12) & 16383L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in[ 9 + inPos]) <<  4) & 4095L)
        | //                        [7654____]
          //              [__________3210]
            ((((long)in[10 + inPos]) >>  4) & 15L);
      out[ 6 + outPos] =
          //                        [____3210]
          //                            [3210__________]
            ((((long)in[10 + inPos]) <<  10) & 16383L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in[11 + inPos]) <<  2) & 1023L)
        | //                        [76______]
          //            [____________10]
            ((((long)in[12 + inPos]) >>  6) & 3L);
      out[ 7 + outPos] =
          //                        [__543210]
          //                          [321098________]
            ((((long)in[12 + inPos]) <<  8) & 16383L)
        | //                        [76543210]
          //                  [______76543210]
            ((((long)in[13 + inPos]) ) & 255L);
      out[ 8 + outPos] =
          //                        [76543210]
          //                        [32109876______]
            ((((long)in[14 + inPos]) <<  6) & 16383L)
        | //                        [765432__]
          //                [________543210]
            ((((long)in[15 + inPos]) >>  2) & 63L);
      out[ 9 + outPos] =
          //                        [______10]
          //                              [32____________]
            ((((long)in[15 + inPos]) <<  12) & 16383L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in[16 + inPos]) <<  4) & 4095L)
        | //                        [7654____]
          //              [__________3210]
            ((((long)in[17 + inPos]) >>  4) & 15L);
      out[10 + outPos] =
          //                        [____3210]
          //                            [3210__________]
            ((((long)in[17 + inPos]) <<  10) & 16383L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in[18 + inPos]) <<  2) & 1023L)
        | //                        [76______]
          //            [____________10]
            ((((long)in[19 + inPos]) >>  6) & 3L);
      out[11 + outPos] =
          //                        [__543210]
          //                          [321098________]
            ((((long)in[19 + inPos]) <<  8) & 16383L)
        | //                        [76543210]
          //                  [______76543210]
            ((((long)in[20 + inPos]) ) & 255L);
      out[12 + outPos] =
          //                        [76543210]
          //                        [32109876______]
            ((((long)in[21 + inPos]) <<  6) & 16383L)
        | //                        [765432__]
          //                [________543210]
            ((((long)in[22 + inPos]) >>  2) & 63L);
      out[13 + outPos] =
          //                        [______10]
          //                              [32____________]
            ((((long)in[22 + inPos]) <<  12) & 16383L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in[23 + inPos]) <<  4) & 4095L)
        | //                        [7654____]
          //              [__________3210]
            ((((long)in[24 + inPos]) >>  4) & 15L);
      out[14 + outPos] =
          //                        [____3210]
          //                            [3210__________]
            ((((long)in[24 + inPos]) <<  10) & 16383L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in[25 + inPos]) <<  2) & 1023L)
        | //                        [76______]
          //            [____________10]
            ((((long)in[26 + inPos]) >>  6) & 3L);
      out[15 + outPos] =
          //                        [__543210]
          //                          [321098________]
            ((((long)in[26 + inPos]) <<  8) & 16383L)
        | //                        [76543210]
          //                  [______76543210]
            ((((long)in[27 + inPos]) ) & 255L);
      out[16 + outPos] =
          //                        [76543210]
          //                        [32109876______]
            ((((long)in[28 + inPos]) <<  6) & 16383L)
        | //                        [765432__]
          //                [________543210]
            ((((long)in[29 + inPos]) >>  2) & 63L);
      out[17 + outPos] =
          //                        [______10]
          //                              [32____________]
            ((((long)in[29 + inPos]) <<  12) & 16383L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in[30 + inPos]) <<  4) & 4095L)
        | //                        [7654____]
          //              [__________3210]
            ((((long)in[31 + inPos]) >>  4) & 15L);
      out[18 + outPos] =
          //                        [____3210]
          //                            [3210__________]
            ((((long)in[31 + inPos]) <<  10) & 16383L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in[32 + inPos]) <<  2) & 1023L)
        | //                        [76______]
          //            [____________10]
            ((((long)in[33 + inPos]) >>  6) & 3L);
      out[19 + outPos] =
          //                        [__543210]
          //                          [321098________]
            ((((long)in[33 + inPos]) <<  8) & 16383L)
        | //                        [76543210]
          //                  [______76543210]
            ((((long)in[34 + inPos]) ) & 255L);
      out[20 + outPos] =
          //                        [76543210]
          //                        [32109876______]
            ((((long)in[35 + inPos]) <<  6) & 16383L)
        | //                        [765432__]
          //                [________543210]
            ((((long)in[36 + inPos]) >>  2) & 63L);
      out[21 + outPos] =
          //                        [______10]
          //                              [32____________]
            ((((long)in[36 + inPos]) <<  12) & 16383L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in[37 + inPos]) <<  4) & 4095L)
        | //                        [7654____]
          //              [__________3210]
            ((((long)in[38 + inPos]) >>  4) & 15L);
      out[22 + outPos] =
          //                        [____3210]
          //                            [3210__________]
            ((((long)in[38 + inPos]) <<  10) & 16383L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in[39 + inPos]) <<  2) & 1023L)
        | //                        [76______]
          //            [____________10]
            ((((long)in[40 + inPos]) >>  6) & 3L);
      out[23 + outPos] =
          //                        [__543210]
          //                          [321098________]
            ((((long)in[40 + inPos]) <<  8) & 16383L)
        | //                        [76543210]
          //                  [______76543210]
            ((((long)in[41 + inPos]) ) & 255L);
      out[24 + outPos] =
          //                        [76543210]
          //                        [32109876______]
            ((((long)in[42 + inPos]) <<  6) & 16383L)
        | //                        [765432__]
          //                [________543210]
            ((((long)in[43 + inPos]) >>  2) & 63L);
      out[25 + outPos] =
          //                        [______10]
          //                              [32____________]
            ((((long)in[43 + inPos]) <<  12) & 16383L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in[44 + inPos]) <<  4) & 4095L)
        | //                        [7654____]
          //              [__________3210]
            ((((long)in[45 + inPos]) >>  4) & 15L);
      out[26 + outPos] =
          //                        [____3210]
          //                            [3210__________]
            ((((long)in[45 + inPos]) <<  10) & 16383L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in[46 + inPos]) <<  2) & 1023L)
        | //                        [76______]
          //            [____________10]
            ((((long)in[47 + inPos]) >>  6) & 3L);
      out[27 + outPos] =
          //                        [__543210]
          //                          [321098________]
            ((((long)in[47 + inPos]) <<  8) & 16383L)
        | //                        [76543210]
          //                  [______76543210]
            ((((long)in[48 + inPos]) ) & 255L);
      out[28 + outPos] =
          //                        [76543210]
          //                        [32109876______]
            ((((long)in[49 + inPos]) <<  6) & 16383L)
        | //                        [765432__]
          //                [________543210]
            ((((long)in[50 + inPos]) >>  2) & 63L);
      out[29 + outPos] =
          //                        [______10]
          //                              [32____________]
            ((((long)in[50 + inPos]) <<  12) & 16383L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in[51 + inPos]) <<  4) & 4095L)
        | //                        [7654____]
          //              [__________3210]
            ((((long)in[52 + inPos]) >>  4) & 15L);
      out[30 + outPos] =
          //                        [____3210]
          //                            [3210__________]
            ((((long)in[52 + inPos]) <<  10) & 16383L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in[53 + inPos]) <<  2) & 1023L)
        | //                        [76______]
          //            [____________10]
            ((((long)in[54 + inPos]) >>  6) & 3L);
      out[31 + outPos] =
          //                        [__543210]
          //                          [321098________]
            ((((long)in[54 + inPos]) <<  8) & 16383L)
        | //                        [76543210]
          //                  [______76543210]
            ((((long)in[55 + inPos]) ) & 255L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                        [76543210]
          //                        [32109876______]
            ((((long)in.get( 0 + inPos)) <<  6) & 16383L)
        | //                        [765432__]
          //                [________543210]
            ((((long)in.get( 1 + inPos)) >>  2) & 63L);
      out[ 1 + outPos] =
          //                        [______10]
          //                              [32____________]
            ((((long)in.get( 1 + inPos)) <<  12) & 16383L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in.get( 2 + inPos)) <<  4) & 4095L)
        | //                        [7654____]
          //              [__________3210]
            ((((long)in.get( 3 + inPos)) >>  4) & 15L);
      out[ 2 + outPos] =
          //                        [____3210]
          //                            [3210__________]
            ((((long)in.get( 3 + inPos)) <<  10) & 16383L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in.get( 4 + inPos)) <<  2) & 1023L)
        | //                        [76______]
          //            [____________10]
            ((((long)in.get( 5 + inPos)) >>  6) & 3L);
      out[ 3 + outPos] =
          //                        [__543210]
          //                          [321098________]
            ((((long)in.get( 5 + inPos)) <<  8) & 16383L)
        | //                        [76543210]
          //                  [______76543210]
            ((((long)in.get( 6 + inPos)) ) & 255L);
      out[ 4 + outPos] =
          //                        [76543210]
          //                        [32109876______]
            ((((long)in.get( 7 + inPos)) <<  6) & 16383L)
        | //                        [765432__]
          //                [________543210]
            ((((long)in.get( 8 + inPos)) >>  2) & 63L);
      out[ 5 + outPos] =
          //                        [______10]
          //                              [32____________]
            ((((long)in.get( 8 + inPos)) <<  12) & 16383L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in.get( 9 + inPos)) <<  4) & 4095L)
        | //                        [7654____]
          //              [__________3210]
            ((((long)in.get(10 + inPos)) >>  4) & 15L);
      out[ 6 + outPos] =
          //                        [____3210]
          //                            [3210__________]
            ((((long)in.get(10 + inPos)) <<  10) & 16383L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in.get(11 + inPos)) <<  2) & 1023L)
        | //                        [76______]
          //            [____________10]
            ((((long)in.get(12 + inPos)) >>  6) & 3L);
      out[ 7 + outPos] =
          //                        [__543210]
          //                          [321098________]
            ((((long)in.get(12 + inPos)) <<  8) & 16383L)
        | //                        [76543210]
          //                  [______76543210]
            ((((long)in.get(13 + inPos)) ) & 255L);
      out[ 8 + outPos] =
          //                        [76543210]
          //                        [32109876______]
            ((((long)in.get(14 + inPos)) <<  6) & 16383L)
        | //                        [765432__]
          //                [________543210]
            ((((long)in.get(15 + inPos)) >>  2) & 63L);
      out[ 9 + outPos] =
          //                        [______10]
          //                              [32____________]
            ((((long)in.get(15 + inPos)) <<  12) & 16383L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in.get(16 + inPos)) <<  4) & 4095L)
        | //                        [7654____]
          //              [__________3210]
            ((((long)in.get(17 + inPos)) >>  4) & 15L);
      out[10 + outPos] =
          //                        [____3210]
          //                            [3210__________]
            ((((long)in.get(17 + inPos)) <<  10) & 16383L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in.get(18 + inPos)) <<  2) & 1023L)
        | //                        [76______]
          //            [____________10]
            ((((long)in.get(19 + inPos)) >>  6) & 3L);
      out[11 + outPos] =
          //                        [__543210]
          //                          [321098________]
            ((((long)in.get(19 + inPos)) <<  8) & 16383L)
        | //                        [76543210]
          //                  [______76543210]
            ((((long)in.get(20 + inPos)) ) & 255L);
      out[12 + outPos] =
          //                        [76543210]
          //                        [32109876______]
            ((((long)in.get(21 + inPos)) <<  6) & 16383L)
        | //                        [765432__]
          //                [________543210]
            ((((long)in.get(22 + inPos)) >>  2) & 63L);
      out[13 + outPos] =
          //                        [______10]
          //                              [32____________]
            ((((long)in.get(22 + inPos)) <<  12) & 16383L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in.get(23 + inPos)) <<  4) & 4095L)
        | //                        [7654____]
          //              [__________3210]
            ((((long)in.get(24 + inPos)) >>  4) & 15L);
      out[14 + outPos] =
          //                        [____3210]
          //                            [3210__________]
            ((((long)in.get(24 + inPos)) <<  10) & 16383L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in.get(25 + inPos)) <<  2) & 1023L)
        | //                        [76______]
          //            [____________10]
            ((((long)in.get(26 + inPos)) >>  6) & 3L);
      out[15 + outPos] =
          //                        [__543210]
          //                          [321098________]
            ((((long)in.get(26 + inPos)) <<  8) & 16383L)
        | //                        [76543210]
          //                  [______76543210]
            ((((long)in.get(27 + inPos)) ) & 255L);
      out[16 + outPos] =
          //                        [76543210]
          //                        [32109876______]
            ((((long)in.get(28 + inPos)) <<  6) & 16383L)
        | //                        [765432__]
          //                [________543210]
            ((((long)in.get(29 + inPos)) >>  2) & 63L);
      out[17 + outPos] =
          //                        [______10]
          //                              [32____________]
            ((((long)in.get(29 + inPos)) <<  12) & 16383L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in.get(30 + inPos)) <<  4) & 4095L)
        | //                        [7654____]
          //              [__________3210]
            ((((long)in.get(31 + inPos)) >>  4) & 15L);
      out[18 + outPos] =
          //                        [____3210]
          //                            [3210__________]
            ((((long)in.get(31 + inPos)) <<  10) & 16383L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in.get(32 + inPos)) <<  2) & 1023L)
        | //                        [76______]
          //            [____________10]
            ((((long)in.get(33 + inPos)) >>  6) & 3L);
      out[19 + outPos] =
          //                        [__543210]
          //                          [321098________]
            ((((long)in.get(33 + inPos)) <<  8) & 16383L)
        | //                        [76543210]
          //                  [______76543210]
            ((((long)in.get(34 + inPos)) ) & 255L);
      out[20 + outPos] =
          //                        [76543210]
          //                        [32109876______]
            ((((long)in.get(35 + inPos)) <<  6) & 16383L)
        | //                        [765432__]
          //                [________543210]
            ((((long)in.get(36 + inPos)) >>  2) & 63L);
      out[21 + outPos] =
          //                        [______10]
          //                              [32____________]
            ((((long)in.get(36 + inPos)) <<  12) & 16383L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in.get(37 + inPos)) <<  4) & 4095L)
        | //                        [7654____]
          //              [__________3210]
            ((((long)in.get(38 + inPos)) >>  4) & 15L);
      out[22 + outPos] =
          //                        [____3210]
          //                            [3210__________]
            ((((long)in.get(38 + inPos)) <<  10) & 16383L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in.get(39 + inPos)) <<  2) & 1023L)
        | //                        [76______]
          //            [____________10]
            ((((long)in.get(40 + inPos)) >>  6) & 3L);
      out[23 + outPos] =
          //                        [__543210]
          //                          [321098________]
            ((((long)in.get(40 + inPos)) <<  8) & 16383L)
        | //                        [76543210]
          //                  [______76543210]
            ((((long)in.get(41 + inPos)) ) & 255L);
      out[24 + outPos] =
          //                        [76543210]
          //                        [32109876______]
            ((((long)in.get(42 + inPos)) <<  6) & 16383L)
        | //                        [765432__]
          //                [________543210]
            ((((long)in.get(43 + inPos)) >>  2) & 63L);
      out[25 + outPos] =
          //                        [______10]
          //                              [32____________]
            ((((long)in.get(43 + inPos)) <<  12) & 16383L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in.get(44 + inPos)) <<  4) & 4095L)
        | //                        [7654____]
          //              [__________3210]
            ((((long)in.get(45 + inPos)) >>  4) & 15L);
      out[26 + outPos] =
          //                        [____3210]
          //                            [3210__________]
            ((((long)in.get(45 + inPos)) <<  10) & 16383L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in.get(46 + inPos)) <<  2) & 1023L)
        | //                        [76______]
          //            [____________10]
            ((((long)in.get(47 + inPos)) >>  6) & 3L);
      out[27 + outPos] =
          //                        [__543210]
          //                          [321098________]
            ((((long)in.get(47 + inPos)) <<  8) & 16383L)
        | //                        [76543210]
          //                  [______76543210]
            ((((long)in.get(48 + inPos)) ) & 255L);
      out[28 + outPos] =
          //                        [76543210]
          //                        [32109876______]
            ((((long)in.get(49 + inPos)) <<  6) & 16383L)
        | //                        [765432__]
          //                [________543210]
            ((((long)in.get(50 + inPos)) >>  2) & 63L);
      out[29 + outPos] =
          //                        [______10]
          //                              [32____________]
            ((((long)in.get(50 + inPos)) <<  12) & 16383L)
        | //                        [76543210]
          //                      [__10987654____]
            ((((long)in.get(51 + inPos)) <<  4) & 4095L)
        | //                        [7654____]
          //              [__________3210]
            ((((long)in.get(52 + inPos)) >>  4) & 15L);
      out[30 + outPos] =
          //                        [____3210]
          //                            [3210__________]
            ((((long)in.get(52 + inPos)) <<  10) & 16383L)
        | //                        [76543210]
          //                    [____98765432__]
            ((((long)in.get(53 + inPos)) <<  2) & 1023L)
        | //                        [76______]
          //            [____________10]
            ((((long)in.get(54 + inPos)) >>  6) & 3L);
      out[31 + outPos] =
          //                        [__543210]
          //                          [321098________]
            ((((long)in.get(54 + inPos)) <<  8) & 16383L)
        | //                        [76543210]
          //                  [______76543210]
            ((((long)in.get(55 + inPos)) ) & 255L);
    }
  }

  private static final class Packer15 extends BytePackerForLong {

    private Packer15() {
      super(15);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                         [76543210]
          //                         [43210987_______]
           ((in[ 0 + inPos] & 32767L) >>> 7)) & 255);
      out[ 1 + outPos] = (byte)((
          //                         [7654321_]
          //                 [________6543210]
           ((in[ 0 + inPos] & 32767L) <<  1)
        | //                         [_______0]
          //                                [4______________]
           ((in[ 1 + inPos] & 32767L) >>> 14)) & 255);
      out[ 2 + outPos] = (byte)((
          //                         [76543210]
          //                        [_32109876______]
           ((in[ 1 + inPos] & 32767L) >>> 6)) & 255);
      out[ 3 + outPos] = (byte)((
          //                         [765432__]
          //                [_________543210]
           ((in[ 1 + inPos] & 32767L) <<  2)
        | //                         [______10]
          //                               [43_____________]
           ((in[ 2 + inPos] & 32767L) >>> 13)) & 255);
      out[ 4 + outPos] = (byte)((
          //                         [76543210]
          //                       [__21098765_____]
           ((in[ 2 + inPos] & 32767L) >>> 5)) & 255);
      out[ 5 + outPos] = (byte)((
          //                         [76543___]
          //               [__________43210]
           ((in[ 2 + inPos] & 32767L) <<  3)
        | //                         [_____210]
          //                              [432____________]
           ((in[ 3 + inPos] & 32767L) >>> 12)) & 255);
      out[ 6 + outPos] = (byte)((
          //                         [76543210]
          //                      [___10987654____]
           ((in[ 3 + inPos] & 32767L) >>> 4)) & 255);
      out[ 7 + outPos] = (byte)((
          //                         [7654____]
          //              [___________3210]
           ((in[ 3 + inPos] & 32767L) <<  4)
        | //                         [____3210]
          //                             [4321___________]
           ((in[ 4 + inPos] & 32767L) >>> 11)) & 255);
      out[ 8 + outPos] = (byte)((
          //                         [76543210]
          //                     [____09876543___]
           ((in[ 4 + inPos] & 32767L) >>> 3)) & 255);
      out[ 9 + outPos] = (byte)((
          //                         [765_____]
          //             [____________210]
           ((in[ 4 + inPos] & 32767L) <<  5)
        | //                         [___43210]
          //                            [43210__________]
           ((in[ 5 + inPos] & 32767L) >>> 10)) & 255);
      out[10 + outPos] = (byte)((
          //                         [76543210]
          //                    [_____98765432__]
           ((in[ 5 + inPos] & 32767L) >>> 2)) & 255);
      out[11 + outPos] = (byte)((
          //                         [76______]
          //            [_____________10]
           ((in[ 5 + inPos] & 32767L) <<  6)
        | //                         [__543210]
          //                           [432109_________]
           ((in[ 6 + inPos] & 32767L) >>> 9)) & 255);
      out[12 + outPos] = (byte)((
          //                         [76543210]
          //                   [______87654321_]
           ((in[ 6 + inPos] & 32767L) >>> 1)) & 255);
      out[13 + outPos] = (byte)((
          //                         [7_______]
          //           [______________0]
           ((in[ 6 + inPos] & 32767L) <<  7)
        | //                         [_6543210]
          //                          [4321098________]
           ((in[ 7 + inPos] & 32767L) >>> 8)) & 255);
      out[14 + outPos] = (byte)((
          //                         [76543210]
          //                  [_______76543210]
           ((in[ 7 + inPos] & 32767L))) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                         [76543210]
          //                         [43210987_______]
           ((in[ 0 + inPos] & 32767L) >>> 7)) & 255);
      out[ 1 + outPos] = (byte)((
          //                         [7654321_]
          //                 [________6543210]
           ((in[ 0 + inPos] & 32767L) <<  1)
        | //                         [_______0]
          //                                [4______________]
           ((in[ 1 + inPos] & 32767L) >>> 14)) & 255);
      out[ 2 + outPos] = (byte)((
          //                         [76543210]
          //                        [_32109876______]
           ((in[ 1 + inPos] & 32767L) >>> 6)) & 255);
      out[ 3 + outPos] = (byte)((
          //                         [765432__]
          //                [_________543210]
           ((in[ 1 + inPos] & 32767L) <<  2)
        | //                         [______10]
          //                               [43_____________]
           ((in[ 2 + inPos] & 32767L) >>> 13)) & 255);
      out[ 4 + outPos] = (byte)((
          //                         [76543210]
          //                       [__21098765_____]
           ((in[ 2 + inPos] & 32767L) >>> 5)) & 255);
      out[ 5 + outPos] = (byte)((
          //                         [76543___]
          //               [__________43210]
           ((in[ 2 + inPos] & 32767L) <<  3)
        | //                         [_____210]
          //                              [432____________]
           ((in[ 3 + inPos] & 32767L) >>> 12)) & 255);
      out[ 6 + outPos] = (byte)((
          //                         [76543210]
          //                      [___10987654____]
           ((in[ 3 + inPos] & 32767L) >>> 4)) & 255);
      out[ 7 + outPos] = (byte)((
          //                         [7654____]
          //              [___________3210]
           ((in[ 3 + inPos] & 32767L) <<  4)
        | //                         [____3210]
          //                             [4321___________]
           ((in[ 4 + inPos] & 32767L) >>> 11)) & 255);
      out[ 8 + outPos] = (byte)((
          //                         [76543210]
          //                     [____09876543___]
           ((in[ 4 + inPos] & 32767L) >>> 3)) & 255);
      out[ 9 + outPos] = (byte)((
          //                         [765_____]
          //             [____________210]
           ((in[ 4 + inPos] & 32767L) <<  5)
        | //                         [___43210]
          //                            [43210__________]
           ((in[ 5 + inPos] & 32767L) >>> 10)) & 255);
      out[10 + outPos] = (byte)((
          //                         [76543210]
          //                    [_____98765432__]
           ((in[ 5 + inPos] & 32767L) >>> 2)) & 255);
      out[11 + outPos] = (byte)((
          //                         [76______]
          //            [_____________10]
           ((in[ 5 + inPos] & 32767L) <<  6)
        | //                         [__543210]
          //                           [432109_________]
           ((in[ 6 + inPos] & 32767L) >>> 9)) & 255);
      out[12 + outPos] = (byte)((
          //                         [76543210]
          //                   [______87654321_]
           ((in[ 6 + inPos] & 32767L) >>> 1)) & 255);
      out[13 + outPos] = (byte)((
          //                         [7_______]
          //           [______________0]
           ((in[ 6 + inPos] & 32767L) <<  7)
        | //                         [_6543210]
          //                          [4321098________]
           ((in[ 7 + inPos] & 32767L) >>> 8)) & 255);
      out[14 + outPos] = (byte)((
          //                         [76543210]
          //                  [_______76543210]
           ((in[ 7 + inPos] & 32767L))) & 255);
      out[15 + outPos] = (byte)((
          //                         [76543210]
          //                         [43210987_______]
           ((in[ 8 + inPos] & 32767L) >>> 7)) & 255);
      out[16 + outPos] = (byte)((
          //                         [7654321_]
          //                 [________6543210]
           ((in[ 8 + inPos] & 32767L) <<  1)
        | //                         [_______0]
          //                                [4______________]
           ((in[ 9 + inPos] & 32767L) >>> 14)) & 255);
      out[17 + outPos] = (byte)((
          //                         [76543210]
          //                        [_32109876______]
           ((in[ 9 + inPos] & 32767L) >>> 6)) & 255);
      out[18 + outPos] = (byte)((
          //                         [765432__]
          //                [_________543210]
           ((in[ 9 + inPos] & 32767L) <<  2)
        | //                         [______10]
          //                               [43_____________]
           ((in[10 + inPos] & 32767L) >>> 13)) & 255);
      out[19 + outPos] = (byte)((
          //                         [76543210]
          //                       [__21098765_____]
           ((in[10 + inPos] & 32767L) >>> 5)) & 255);
      out[20 + outPos] = (byte)((
          //                         [76543___]
          //               [__________43210]
           ((in[10 + inPos] & 32767L) <<  3)
        | //                         [_____210]
          //                              [432____________]
           ((in[11 + inPos] & 32767L) >>> 12)) & 255);
      out[21 + outPos] = (byte)((
          //                         [76543210]
          //                      [___10987654____]
           ((in[11 + inPos] & 32767L) >>> 4)) & 255);
      out[22 + outPos] = (byte)((
          //                         [7654____]
          //              [___________3210]
           ((in[11 + inPos] & 32767L) <<  4)
        | //                         [____3210]
          //                             [4321___________]
           ((in[12 + inPos] & 32767L) >>> 11)) & 255);
      out[23 + outPos] = (byte)((
          //                         [76543210]
          //                     [____09876543___]
           ((in[12 + inPos] & 32767L) >>> 3)) & 255);
      out[24 + outPos] = (byte)((
          //                         [765_____]
          //             [____________210]
           ((in[12 + inPos] & 32767L) <<  5)
        | //                         [___43210]
          //                            [43210__________]
           ((in[13 + inPos] & 32767L) >>> 10)) & 255);
      out[25 + outPos] = (byte)((
          //                         [76543210]
          //                    [_____98765432__]
           ((in[13 + inPos] & 32767L) >>> 2)) & 255);
      out[26 + outPos] = (byte)((
          //                         [76______]
          //            [_____________10]
           ((in[13 + inPos] & 32767L) <<  6)
        | //                         [__543210]
          //                           [432109_________]
           ((in[14 + inPos] & 32767L) >>> 9)) & 255);
      out[27 + outPos] = (byte)((
          //                         [76543210]
          //                   [______87654321_]
           ((in[14 + inPos] & 32767L) >>> 1)) & 255);
      out[28 + outPos] = (byte)((
          //                         [7_______]
          //           [______________0]
           ((in[14 + inPos] & 32767L) <<  7)
        | //                         [_6543210]
          //                          [4321098________]
           ((in[15 + inPos] & 32767L) >>> 8)) & 255);
      out[29 + outPos] = (byte)((
          //                         [76543210]
          //                  [_______76543210]
           ((in[15 + inPos] & 32767L))) & 255);
      out[30 + outPos] = (byte)((
          //                         [76543210]
          //                         [43210987_______]
           ((in[16 + inPos] & 32767L) >>> 7)) & 255);
      out[31 + outPos] = (byte)((
          //                         [7654321_]
          //                 [________6543210]
           ((in[16 + inPos] & 32767L) <<  1)
        | //                         [_______0]
          //                                [4______________]
           ((in[17 + inPos] & 32767L) >>> 14)) & 255);
      out[32 + outPos] = (byte)((
          //                         [76543210]
          //                        [_32109876______]
           ((in[17 + inPos] & 32767L) >>> 6)) & 255);
      out[33 + outPos] = (byte)((
          //                         [765432__]
          //                [_________543210]
           ((in[17 + inPos] & 32767L) <<  2)
        | //                         [______10]
          //                               [43_____________]
           ((in[18 + inPos] & 32767L) >>> 13)) & 255);
      out[34 + outPos] = (byte)((
          //                         [76543210]
          //                       [__21098765_____]
           ((in[18 + inPos] & 32767L) >>> 5)) & 255);
      out[35 + outPos] = (byte)((
          //                         [76543___]
          //               [__________43210]
           ((in[18 + inPos] & 32767L) <<  3)
        | //                         [_____210]
          //                              [432____________]
           ((in[19 + inPos] & 32767L) >>> 12)) & 255);
      out[36 + outPos] = (byte)((
          //                         [76543210]
          //                      [___10987654____]
           ((in[19 + inPos] & 32767L) >>> 4)) & 255);
      out[37 + outPos] = (byte)((
          //                         [7654____]
          //              [___________3210]
           ((in[19 + inPos] & 32767L) <<  4)
        | //                         [____3210]
          //                             [4321___________]
           ((in[20 + inPos] & 32767L) >>> 11)) & 255);
      out[38 + outPos] = (byte)((
          //                         [76543210]
          //                     [____09876543___]
           ((in[20 + inPos] & 32767L) >>> 3)) & 255);
      out[39 + outPos] = (byte)((
          //                         [765_____]
          //             [____________210]
           ((in[20 + inPos] & 32767L) <<  5)
        | //                         [___43210]
          //                            [43210__________]
           ((in[21 + inPos] & 32767L) >>> 10)) & 255);
      out[40 + outPos] = (byte)((
          //                         [76543210]
          //                    [_____98765432__]
           ((in[21 + inPos] & 32767L) >>> 2)) & 255);
      out[41 + outPos] = (byte)((
          //                         [76______]
          //            [_____________10]
           ((in[21 + inPos] & 32767L) <<  6)
        | //                         [__543210]
          //                           [432109_________]
           ((in[22 + inPos] & 32767L) >>> 9)) & 255);
      out[42 + outPos] = (byte)((
          //                         [76543210]
          //                   [______87654321_]
           ((in[22 + inPos] & 32767L) >>> 1)) & 255);
      out[43 + outPos] = (byte)((
          //                         [7_______]
          //           [______________0]
           ((in[22 + inPos] & 32767L) <<  7)
        | //                         [_6543210]
          //                          [4321098________]
           ((in[23 + inPos] & 32767L) >>> 8)) & 255);
      out[44 + outPos] = (byte)((
          //                         [76543210]
          //                  [_______76543210]
           ((in[23 + inPos] & 32767L))) & 255);
      out[45 + outPos] = (byte)((
          //                         [76543210]
          //                         [43210987_______]
           ((in[24 + inPos] & 32767L) >>> 7)) & 255);
      out[46 + outPos] = (byte)((
          //                         [7654321_]
          //                 [________6543210]
           ((in[24 + inPos] & 32767L) <<  1)
        | //                         [_______0]
          //                                [4______________]
           ((in[25 + inPos] & 32767L) >>> 14)) & 255);
      out[47 + outPos] = (byte)((
          //                         [76543210]
          //                        [_32109876______]
           ((in[25 + inPos] & 32767L) >>> 6)) & 255);
      out[48 + outPos] = (byte)((
          //                         [765432__]
          //                [_________543210]
           ((in[25 + inPos] & 32767L) <<  2)
        | //                         [______10]
          //                               [43_____________]
           ((in[26 + inPos] & 32767L) >>> 13)) & 255);
      out[49 + outPos] = (byte)((
          //                         [76543210]
          //                       [__21098765_____]
           ((in[26 + inPos] & 32767L) >>> 5)) & 255);
      out[50 + outPos] = (byte)((
          //                         [76543___]
          //               [__________43210]
           ((in[26 + inPos] & 32767L) <<  3)
        | //                         [_____210]
          //                              [432____________]
           ((in[27 + inPos] & 32767L) >>> 12)) & 255);
      out[51 + outPos] = (byte)((
          //                         [76543210]
          //                      [___10987654____]
           ((in[27 + inPos] & 32767L) >>> 4)) & 255);
      out[52 + outPos] = (byte)((
          //                         [7654____]
          //              [___________3210]
           ((in[27 + inPos] & 32767L) <<  4)
        | //                         [____3210]
          //                             [4321___________]
           ((in[28 + inPos] & 32767L) >>> 11)) & 255);
      out[53 + outPos] = (byte)((
          //                         [76543210]
          //                     [____09876543___]
           ((in[28 + inPos] & 32767L) >>> 3)) & 255);
      out[54 + outPos] = (byte)((
          //                         [765_____]
          //             [____________210]
           ((in[28 + inPos] & 32767L) <<  5)
        | //                         [___43210]
          //                            [43210__________]
           ((in[29 + inPos] & 32767L) >>> 10)) & 255);
      out[55 + outPos] = (byte)((
          //                         [76543210]
          //                    [_____98765432__]
           ((in[29 + inPos] & 32767L) >>> 2)) & 255);
      out[56 + outPos] = (byte)((
          //                         [76______]
          //            [_____________10]
           ((in[29 + inPos] & 32767L) <<  6)
        | //                         [__543210]
          //                           [432109_________]
           ((in[30 + inPos] & 32767L) >>> 9)) & 255);
      out[57 + outPos] = (byte)((
          //                         [76543210]
          //                   [______87654321_]
           ((in[30 + inPos] & 32767L) >>> 1)) & 255);
      out[58 + outPos] = (byte)((
          //                         [7_______]
          //           [______________0]
           ((in[30 + inPos] & 32767L) <<  7)
        | //                         [_6543210]
          //                          [4321098________]
           ((in[31 + inPos] & 32767L) >>> 8)) & 255);
      out[59 + outPos] = (byte)((
          //                         [76543210]
          //                  [_______76543210]
           ((in[31 + inPos] & 32767L))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                         [76543210]
          //                         [43210987_______]
            ((((long)in[ 0 + inPos]) <<  7) & 32767L)
        | //                         [7654321_]
          //                 [________6543210]
            ((((long)in[ 1 + inPos]) >>  1) & 127L);
      out[ 1 + outPos] =
          //                         [_______0]
          //                                [4______________]
            ((((long)in[ 1 + inPos]) <<  14) & 32767L)
        | //                         [76543210]
          //                        [_32109876______]
            ((((long)in[ 2 + inPos]) <<  6) & 16383L)
        | //                         [765432__]
          //                [_________543210]
            ((((long)in[ 3 + inPos]) >>  2) & 63L);
      out[ 2 + outPos] =
          //                         [______10]
          //                               [43_____________]
            ((((long)in[ 3 + inPos]) <<  13) & 32767L)
        | //                         [76543210]
          //                       [__21098765_____]
            ((((long)in[ 4 + inPos]) <<  5) & 8191L)
        | //                         [76543___]
          //               [__________43210]
            ((((long)in[ 5 + inPos]) >>  3) & 31L);
      out[ 3 + outPos] =
          //                         [_____210]
          //                              [432____________]
            ((((long)in[ 5 + inPos]) <<  12) & 32767L)
        | //                         [76543210]
          //                      [___10987654____]
            ((((long)in[ 6 + inPos]) <<  4) & 4095L)
        | //                         [7654____]
          //              [___________3210]
            ((((long)in[ 7 + inPos]) >>  4) & 15L);
      out[ 4 + outPos] =
          //                         [____3210]
          //                             [4321___________]
            ((((long)in[ 7 + inPos]) <<  11) & 32767L)
        | //                         [76543210]
          //                     [____09876543___]
            ((((long)in[ 8 + inPos]) <<  3) & 2047L)
        | //                         [765_____]
          //             [____________210]
            ((((long)in[ 9 + inPos]) >>  5) & 7L);
      out[ 5 + outPos] =
          //                         [___43210]
          //                            [43210__________]
            ((((long)in[ 9 + inPos]) <<  10) & 32767L)
        | //                         [76543210]
          //                    [_____98765432__]
            ((((long)in[10 + inPos]) <<  2) & 1023L)
        | //                         [76______]
          //            [_____________10]
            ((((long)in[11 + inPos]) >>  6) & 3L);
      out[ 6 + outPos] =
          //                         [__543210]
          //                           [432109_________]
            ((((long)in[11 + inPos]) <<  9) & 32767L)
        | //                         [76543210]
          //                   [______87654321_]
            ((((long)in[12 + inPos]) <<  1) & 511L)
        | //                         [7_______]
          //           [______________0]
            ((((long)in[13 + inPos]) >>  7) & 1L);
      out[ 7 + outPos] =
          //                         [_6543210]
          //                          [4321098________]
            ((((long)in[13 + inPos]) <<  8) & 32767L)
        | //                         [76543210]
          //                  [_______76543210]
            ((((long)in[14 + inPos]) ) & 255L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                         [76543210]
          //                         [43210987_______]
            ((((long)in.get( 0 + inPos)) <<  7) & 32767L)
        | //                         [7654321_]
          //                 [________6543210]
            ((((long)in.get( 1 + inPos)) >>  1) & 127L);
      out[ 1 + outPos] =
          //                         [_______0]
          //                                [4______________]
            ((((long)in.get( 1 + inPos)) <<  14) & 32767L)
        | //                         [76543210]
          //                        [_32109876______]
            ((((long)in.get( 2 + inPos)) <<  6) & 16383L)
        | //                         [765432__]
          //                [_________543210]
            ((((long)in.get( 3 + inPos)) >>  2) & 63L);
      out[ 2 + outPos] =
          //                         [______10]
          //                               [43_____________]
            ((((long)in.get( 3 + inPos)) <<  13) & 32767L)
        | //                         [76543210]
          //                       [__21098765_____]
            ((((long)in.get( 4 + inPos)) <<  5) & 8191L)
        | //                         [76543___]
          //               [__________43210]
            ((((long)in.get( 5 + inPos)) >>  3) & 31L);
      out[ 3 + outPos] =
          //                         [_____210]
          //                              [432____________]
            ((((long)in.get( 5 + inPos)) <<  12) & 32767L)
        | //                         [76543210]
          //                      [___10987654____]
            ((((long)in.get( 6 + inPos)) <<  4) & 4095L)
        | //                         [7654____]
          //              [___________3210]
            ((((long)in.get( 7 + inPos)) >>  4) & 15L);
      out[ 4 + outPos] =
          //                         [____3210]
          //                             [4321___________]
            ((((long)in.get( 7 + inPos)) <<  11) & 32767L)
        | //                         [76543210]
          //                     [____09876543___]
            ((((long)in.get( 8 + inPos)) <<  3) & 2047L)
        | //                         [765_____]
          //             [____________210]
            ((((long)in.get( 9 + inPos)) >>  5) & 7L);
      out[ 5 + outPos] =
          //                         [___43210]
          //                            [43210__________]
            ((((long)in.get( 9 + inPos)) <<  10) & 32767L)
        | //                         [76543210]
          //                    [_____98765432__]
            ((((long)in.get(10 + inPos)) <<  2) & 1023L)
        | //                         [76______]
          //            [_____________10]
            ((((long)in.get(11 + inPos)) >>  6) & 3L);
      out[ 6 + outPos] =
          //                         [__543210]
          //                           [432109_________]
            ((((long)in.get(11 + inPos)) <<  9) & 32767L)
        | //                         [76543210]
          //                   [______87654321_]
            ((((long)in.get(12 + inPos)) <<  1) & 511L)
        | //                         [7_______]
          //           [______________0]
            ((((long)in.get(13 + inPos)) >>  7) & 1L);
      out[ 7 + outPos] =
          //                         [_6543210]
          //                          [4321098________]
            ((((long)in.get(13 + inPos)) <<  8) & 32767L)
        | //                         [76543210]
          //                  [_______76543210]
            ((((long)in.get(14 + inPos)) ) & 255L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                         [76543210]
          //                         [43210987_______]
            ((((long)in[ 0 + inPos]) <<  7) & 32767L)
        | //                         [7654321_]
          //                 [________6543210]
            ((((long)in[ 1 + inPos]) >>  1) & 127L);
      out[ 1 + outPos] =
          //                         [_______0]
          //                                [4______________]
            ((((long)in[ 1 + inPos]) <<  14) & 32767L)
        | //                         [76543210]
          //                        [_32109876______]
            ((((long)in[ 2 + inPos]) <<  6) & 16383L)
        | //                         [765432__]
          //                [_________543210]
            ((((long)in[ 3 + inPos]) >>  2) & 63L);
      out[ 2 + outPos] =
          //                         [______10]
          //                               [43_____________]
            ((((long)in[ 3 + inPos]) <<  13) & 32767L)
        | //                         [76543210]
          //                       [__21098765_____]
            ((((long)in[ 4 + inPos]) <<  5) & 8191L)
        | //                         [76543___]
          //               [__________43210]
            ((((long)in[ 5 + inPos]) >>  3) & 31L);
      out[ 3 + outPos] =
          //                         [_____210]
          //                              [432____________]
            ((((long)in[ 5 + inPos]) <<  12) & 32767L)
        | //                         [76543210]
          //                      [___10987654____]
            ((((long)in[ 6 + inPos]) <<  4) & 4095L)
        | //                         [7654____]
          //              [___________3210]
            ((((long)in[ 7 + inPos]) >>  4) & 15L);
      out[ 4 + outPos] =
          //                         [____3210]
          //                             [4321___________]
            ((((long)in[ 7 + inPos]) <<  11) & 32767L)
        | //                         [76543210]
          //                     [____09876543___]
            ((((long)in[ 8 + inPos]) <<  3) & 2047L)
        | //                         [765_____]
          //             [____________210]
            ((((long)in[ 9 + inPos]) >>  5) & 7L);
      out[ 5 + outPos] =
          //                         [___43210]
          //                            [43210__________]
            ((((long)in[ 9 + inPos]) <<  10) & 32767L)
        | //                         [76543210]
          //                    [_____98765432__]
            ((((long)in[10 + inPos]) <<  2) & 1023L)
        | //                         [76______]
          //            [_____________10]
            ((((long)in[11 + inPos]) >>  6) & 3L);
      out[ 6 + outPos] =
          //                         [__543210]
          //                           [432109_________]
            ((((long)in[11 + inPos]) <<  9) & 32767L)
        | //                         [76543210]
          //                   [______87654321_]
            ((((long)in[12 + inPos]) <<  1) & 511L)
        | //                         [7_______]
          //           [______________0]
            ((((long)in[13 + inPos]) >>  7) & 1L);
      out[ 7 + outPos] =
          //                         [_6543210]
          //                          [4321098________]
            ((((long)in[13 + inPos]) <<  8) & 32767L)
        | //                         [76543210]
          //                  [_______76543210]
            ((((long)in[14 + inPos]) ) & 255L);
      out[ 8 + outPos] =
          //                         [76543210]
          //                         [43210987_______]
            ((((long)in[15 + inPos]) <<  7) & 32767L)
        | //                         [7654321_]
          //                 [________6543210]
            ((((long)in[16 + inPos]) >>  1) & 127L);
      out[ 9 + outPos] =
          //                         [_______0]
          //                                [4______________]
            ((((long)in[16 + inPos]) <<  14) & 32767L)
        | //                         [76543210]
          //                        [_32109876______]
            ((((long)in[17 + inPos]) <<  6) & 16383L)
        | //                         [765432__]
          //                [_________543210]
            ((((long)in[18 + inPos]) >>  2) & 63L);
      out[10 + outPos] =
          //                         [______10]
          //                               [43_____________]
            ((((long)in[18 + inPos]) <<  13) & 32767L)
        | //                         [76543210]
          //                       [__21098765_____]
            ((((long)in[19 + inPos]) <<  5) & 8191L)
        | //                         [76543___]
          //               [__________43210]
            ((((long)in[20 + inPos]) >>  3) & 31L);
      out[11 + outPos] =
          //                         [_____210]
          //                              [432____________]
            ((((long)in[20 + inPos]) <<  12) & 32767L)
        | //                         [76543210]
          //                      [___10987654____]
            ((((long)in[21 + inPos]) <<  4) & 4095L)
        | //                         [7654____]
          //              [___________3210]
            ((((long)in[22 + inPos]) >>  4) & 15L);
      out[12 + outPos] =
          //                         [____3210]
          //                             [4321___________]
            ((((long)in[22 + inPos]) <<  11) & 32767L)
        | //                         [76543210]
          //                     [____09876543___]
            ((((long)in[23 + inPos]) <<  3) & 2047L)
        | //                         [765_____]
          //             [____________210]
            ((((long)in[24 + inPos]) >>  5) & 7L);
      out[13 + outPos] =
          //                         [___43210]
          //                            [43210__________]
            ((((long)in[24 + inPos]) <<  10) & 32767L)
        | //                         [76543210]
          //                    [_____98765432__]
            ((((long)in[25 + inPos]) <<  2) & 1023L)
        | //                         [76______]
          //            [_____________10]
            ((((long)in[26 + inPos]) >>  6) & 3L);
      out[14 + outPos] =
          //                         [__543210]
          //                           [432109_________]
            ((((long)in[26 + inPos]) <<  9) & 32767L)
        | //                         [76543210]
          //                   [______87654321_]
            ((((long)in[27 + inPos]) <<  1) & 511L)
        | //                         [7_______]
          //           [______________0]
            ((((long)in[28 + inPos]) >>  7) & 1L);
      out[15 + outPos] =
          //                         [_6543210]
          //                          [4321098________]
            ((((long)in[28 + inPos]) <<  8) & 32767L)
        | //                         [76543210]
          //                  [_______76543210]
            ((((long)in[29 + inPos]) ) & 255L);
      out[16 + outPos] =
          //                         [76543210]
          //                         [43210987_______]
            ((((long)in[30 + inPos]) <<  7) & 32767L)
        | //                         [7654321_]
          //                 [________6543210]
            ((((long)in[31 + inPos]) >>  1) & 127L);
      out[17 + outPos] =
          //                         [_______0]
          //                                [4______________]
            ((((long)in[31 + inPos]) <<  14) & 32767L)
        | //                         [76543210]
          //                        [_32109876______]
            ((((long)in[32 + inPos]) <<  6) & 16383L)
        | //                         [765432__]
          //                [_________543210]
            ((((long)in[33 + inPos]) >>  2) & 63L);
      out[18 + outPos] =
          //                         [______10]
          //                               [43_____________]
            ((((long)in[33 + inPos]) <<  13) & 32767L)
        | //                         [76543210]
          //                       [__21098765_____]
            ((((long)in[34 + inPos]) <<  5) & 8191L)
        | //                         [76543___]
          //               [__________43210]
            ((((long)in[35 + inPos]) >>  3) & 31L);
      out[19 + outPos] =
          //                         [_____210]
          //                              [432____________]
            ((((long)in[35 + inPos]) <<  12) & 32767L)
        | //                         [76543210]
          //                      [___10987654____]
            ((((long)in[36 + inPos]) <<  4) & 4095L)
        | //                         [7654____]
          //              [___________3210]
            ((((long)in[37 + inPos]) >>  4) & 15L);
      out[20 + outPos] =
          //                         [____3210]
          //                             [4321___________]
            ((((long)in[37 + inPos]) <<  11) & 32767L)
        | //                         [76543210]
          //                     [____09876543___]
            ((((long)in[38 + inPos]) <<  3) & 2047L)
        | //                         [765_____]
          //             [____________210]
            ((((long)in[39 + inPos]) >>  5) & 7L);
      out[21 + outPos] =
          //                         [___43210]
          //                            [43210__________]
            ((((long)in[39 + inPos]) <<  10) & 32767L)
        | //                         [76543210]
          //                    [_____98765432__]
            ((((long)in[40 + inPos]) <<  2) & 1023L)
        | //                         [76______]
          //            [_____________10]
            ((((long)in[41 + inPos]) >>  6) & 3L);
      out[22 + outPos] =
          //                         [__543210]
          //                           [432109_________]
            ((((long)in[41 + inPos]) <<  9) & 32767L)
        | //                         [76543210]
          //                   [______87654321_]
            ((((long)in[42 + inPos]) <<  1) & 511L)
        | //                         [7_______]
          //           [______________0]
            ((((long)in[43 + inPos]) >>  7) & 1L);
      out[23 + outPos] =
          //                         [_6543210]
          //                          [4321098________]
            ((((long)in[43 + inPos]) <<  8) & 32767L)
        | //                         [76543210]
          //                  [_______76543210]
            ((((long)in[44 + inPos]) ) & 255L);
      out[24 + outPos] =
          //                         [76543210]
          //                         [43210987_______]
            ((((long)in[45 + inPos]) <<  7) & 32767L)
        | //                         [7654321_]
          //                 [________6543210]
            ((((long)in[46 + inPos]) >>  1) & 127L);
      out[25 + outPos] =
          //                         [_______0]
          //                                [4______________]
            ((((long)in[46 + inPos]) <<  14) & 32767L)
        | //                         [76543210]
          //                        [_32109876______]
            ((((long)in[47 + inPos]) <<  6) & 16383L)
        | //                         [765432__]
          //                [_________543210]
            ((((long)in[48 + inPos]) >>  2) & 63L);
      out[26 + outPos] =
          //                         [______10]
          //                               [43_____________]
            ((((long)in[48 + inPos]) <<  13) & 32767L)
        | //                         [76543210]
          //                       [__21098765_____]
            ((((long)in[49 + inPos]) <<  5) & 8191L)
        | //                         [76543___]
          //               [__________43210]
            ((((long)in[50 + inPos]) >>  3) & 31L);
      out[27 + outPos] =
          //                         [_____210]
          //                              [432____________]
            ((((long)in[50 + inPos]) <<  12) & 32767L)
        | //                         [76543210]
          //                      [___10987654____]
            ((((long)in[51 + inPos]) <<  4) & 4095L)
        | //                         [7654____]
          //              [___________3210]
            ((((long)in[52 + inPos]) >>  4) & 15L);
      out[28 + outPos] =
          //                         [____3210]
          //                             [4321___________]
            ((((long)in[52 + inPos]) <<  11) & 32767L)
        | //                         [76543210]
          //                     [____09876543___]
            ((((long)in[53 + inPos]) <<  3) & 2047L)
        | //                         [765_____]
          //             [____________210]
            ((((long)in[54 + inPos]) >>  5) & 7L);
      out[29 + outPos] =
          //                         [___43210]
          //                            [43210__________]
            ((((long)in[54 + inPos]) <<  10) & 32767L)
        | //                         [76543210]
          //                    [_____98765432__]
            ((((long)in[55 + inPos]) <<  2) & 1023L)
        | //                         [76______]
          //            [_____________10]
            ((((long)in[56 + inPos]) >>  6) & 3L);
      out[30 + outPos] =
          //                         [__543210]
          //                           [432109_________]
            ((((long)in[56 + inPos]) <<  9) & 32767L)
        | //                         [76543210]
          //                   [______87654321_]
            ((((long)in[57 + inPos]) <<  1) & 511L)
        | //                         [7_______]
          //           [______________0]
            ((((long)in[58 + inPos]) >>  7) & 1L);
      out[31 + outPos] =
          //                         [_6543210]
          //                          [4321098________]
            ((((long)in[58 + inPos]) <<  8) & 32767L)
        | //                         [76543210]
          //                  [_______76543210]
            ((((long)in[59 + inPos]) ) & 255L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                         [76543210]
          //                         [43210987_______]
            ((((long)in.get( 0 + inPos)) <<  7) & 32767L)
        | //                         [7654321_]
          //                 [________6543210]
            ((((long)in.get( 1 + inPos)) >>  1) & 127L);
      out[ 1 + outPos] =
          //                         [_______0]
          //                                [4______________]
            ((((long)in.get( 1 + inPos)) <<  14) & 32767L)
        | //                         [76543210]
          //                        [_32109876______]
            ((((long)in.get( 2 + inPos)) <<  6) & 16383L)
        | //                         [765432__]
          //                [_________543210]
            ((((long)in.get( 3 + inPos)) >>  2) & 63L);
      out[ 2 + outPos] =
          //                         [______10]
          //                               [43_____________]
            ((((long)in.get( 3 + inPos)) <<  13) & 32767L)
        | //                         [76543210]
          //                       [__21098765_____]
            ((((long)in.get( 4 + inPos)) <<  5) & 8191L)
        | //                         [76543___]
          //               [__________43210]
            ((((long)in.get( 5 + inPos)) >>  3) & 31L);
      out[ 3 + outPos] =
          //                         [_____210]
          //                              [432____________]
            ((((long)in.get( 5 + inPos)) <<  12) & 32767L)
        | //                         [76543210]
          //                      [___10987654____]
            ((((long)in.get( 6 + inPos)) <<  4) & 4095L)
        | //                         [7654____]
          //              [___________3210]
            ((((long)in.get( 7 + inPos)) >>  4) & 15L);
      out[ 4 + outPos] =
          //                         [____3210]
          //                             [4321___________]
            ((((long)in.get( 7 + inPos)) <<  11) & 32767L)
        | //                         [76543210]
          //                     [____09876543___]
            ((((long)in.get( 8 + inPos)) <<  3) & 2047L)
        | //                         [765_____]
          //             [____________210]
            ((((long)in.get( 9 + inPos)) >>  5) & 7L);
      out[ 5 + outPos] =
          //                         [___43210]
          //                            [43210__________]
            ((((long)in.get( 9 + inPos)) <<  10) & 32767L)
        | //                         [76543210]
          //                    [_____98765432__]
            ((((long)in.get(10 + inPos)) <<  2) & 1023L)
        | //                         [76______]
          //            [_____________10]
            ((((long)in.get(11 + inPos)) >>  6) & 3L);
      out[ 6 + outPos] =
          //                         [__543210]
          //                           [432109_________]
            ((((long)in.get(11 + inPos)) <<  9) & 32767L)
        | //                         [76543210]
          //                   [______87654321_]
            ((((long)in.get(12 + inPos)) <<  1) & 511L)
        | //                         [7_______]
          //           [______________0]
            ((((long)in.get(13 + inPos)) >>  7) & 1L);
      out[ 7 + outPos] =
          //                         [_6543210]
          //                          [4321098________]
            ((((long)in.get(13 + inPos)) <<  8) & 32767L)
        | //                         [76543210]
          //                  [_______76543210]
            ((((long)in.get(14 + inPos)) ) & 255L);
      out[ 8 + outPos] =
          //                         [76543210]
          //                         [43210987_______]
            ((((long)in.get(15 + inPos)) <<  7) & 32767L)
        | //                         [7654321_]
          //                 [________6543210]
            ((((long)in.get(16 + inPos)) >>  1) & 127L);
      out[ 9 + outPos] =
          //                         [_______0]
          //                                [4______________]
            ((((long)in.get(16 + inPos)) <<  14) & 32767L)
        | //                         [76543210]
          //                        [_32109876______]
            ((((long)in.get(17 + inPos)) <<  6) & 16383L)
        | //                         [765432__]
          //                [_________543210]
            ((((long)in.get(18 + inPos)) >>  2) & 63L);
      out[10 + outPos] =
          //                         [______10]
          //                               [43_____________]
            ((((long)in.get(18 + inPos)) <<  13) & 32767L)
        | //                         [76543210]
          //                       [__21098765_____]
            ((((long)in.get(19 + inPos)) <<  5) & 8191L)
        | //                         [76543___]
          //               [__________43210]
            ((((long)in.get(20 + inPos)) >>  3) & 31L);
      out[11 + outPos] =
          //                         [_____210]
          //                              [432____________]
            ((((long)in.get(20 + inPos)) <<  12) & 32767L)
        | //                         [76543210]
          //                      [___10987654____]
            ((((long)in.get(21 + inPos)) <<  4) & 4095L)
        | //                         [7654____]
          //              [___________3210]
            ((((long)in.get(22 + inPos)) >>  4) & 15L);
      out[12 + outPos] =
          //                         [____3210]
          //                             [4321___________]
            ((((long)in.get(22 + inPos)) <<  11) & 32767L)
        | //                         [76543210]
          //                     [____09876543___]
            ((((long)in.get(23 + inPos)) <<  3) & 2047L)
        | //                         [765_____]
          //             [____________210]
            ((((long)in.get(24 + inPos)) >>  5) & 7L);
      out[13 + outPos] =
          //                         [___43210]
          //                            [43210__________]
            ((((long)in.get(24 + inPos)) <<  10) & 32767L)
        | //                         [76543210]
          //                    [_____98765432__]
            ((((long)in.get(25 + inPos)) <<  2) & 1023L)
        | //                         [76______]
          //            [_____________10]
            ((((long)in.get(26 + inPos)) >>  6) & 3L);
      out[14 + outPos] =
          //                         [__543210]
          //                           [432109_________]
            ((((long)in.get(26 + inPos)) <<  9) & 32767L)
        | //                         [76543210]
          //                   [______87654321_]
            ((((long)in.get(27 + inPos)) <<  1) & 511L)
        | //                         [7_______]
          //           [______________0]
            ((((long)in.get(28 + inPos)) >>  7) & 1L);
      out[15 + outPos] =
          //                         [_6543210]
          //                          [4321098________]
            ((((long)in.get(28 + inPos)) <<  8) & 32767L)
        | //                         [76543210]
          //                  [_______76543210]
            ((((long)in.get(29 + inPos)) ) & 255L);
      out[16 + outPos] =
          //                         [76543210]
          //                         [43210987_______]
            ((((long)in.get(30 + inPos)) <<  7) & 32767L)
        | //                         [7654321_]
          //                 [________6543210]
            ((((long)in.get(31 + inPos)) >>  1) & 127L);
      out[17 + outPos] =
          //                         [_______0]
          //                                [4______________]
            ((((long)in.get(31 + inPos)) <<  14) & 32767L)
        | //                         [76543210]
          //                        [_32109876______]
            ((((long)in.get(32 + inPos)) <<  6) & 16383L)
        | //                         [765432__]
          //                [_________543210]
            ((((long)in.get(33 + inPos)) >>  2) & 63L);
      out[18 + outPos] =
          //                         [______10]
          //                               [43_____________]
            ((((long)in.get(33 + inPos)) <<  13) & 32767L)
        | //                         [76543210]
          //                       [__21098765_____]
            ((((long)in.get(34 + inPos)) <<  5) & 8191L)
        | //                         [76543___]
          //               [__________43210]
            ((((long)in.get(35 + inPos)) >>  3) & 31L);
      out[19 + outPos] =
          //                         [_____210]
          //                              [432____________]
            ((((long)in.get(35 + inPos)) <<  12) & 32767L)
        | //                         [76543210]
          //                      [___10987654____]
            ((((long)in.get(36 + inPos)) <<  4) & 4095L)
        | //                         [7654____]
          //              [___________3210]
            ((((long)in.get(37 + inPos)) >>  4) & 15L);
      out[20 + outPos] =
          //                         [____3210]
          //                             [4321___________]
            ((((long)in.get(37 + inPos)) <<  11) & 32767L)
        | //                         [76543210]
          //                     [____09876543___]
            ((((long)in.get(38 + inPos)) <<  3) & 2047L)
        | //                         [765_____]
          //             [____________210]
            ((((long)in.get(39 + inPos)) >>  5) & 7L);
      out[21 + outPos] =
          //                         [___43210]
          //                            [43210__________]
            ((((long)in.get(39 + inPos)) <<  10) & 32767L)
        | //                         [76543210]
          //                    [_____98765432__]
            ((((long)in.get(40 + inPos)) <<  2) & 1023L)
        | //                         [76______]
          //            [_____________10]
            ((((long)in.get(41 + inPos)) >>  6) & 3L);
      out[22 + outPos] =
          //                         [__543210]
          //                           [432109_________]
            ((((long)in.get(41 + inPos)) <<  9) & 32767L)
        | //                         [76543210]
          //                   [______87654321_]
            ((((long)in.get(42 + inPos)) <<  1) & 511L)
        | //                         [7_______]
          //           [______________0]
            ((((long)in.get(43 + inPos)) >>  7) & 1L);
      out[23 + outPos] =
          //                         [_6543210]
          //                          [4321098________]
            ((((long)in.get(43 + inPos)) <<  8) & 32767L)
        | //                         [76543210]
          //                  [_______76543210]
            ((((long)in.get(44 + inPos)) ) & 255L);
      out[24 + outPos] =
          //                         [76543210]
          //                         [43210987_______]
            ((((long)in.get(45 + inPos)) <<  7) & 32767L)
        | //                         [7654321_]
          //                 [________6543210]
            ((((long)in.get(46 + inPos)) >>  1) & 127L);
      out[25 + outPos] =
          //                         [_______0]
          //                                [4______________]
            ((((long)in.get(46 + inPos)) <<  14) & 32767L)
        | //                         [76543210]
          //                        [_32109876______]
            ((((long)in.get(47 + inPos)) <<  6) & 16383L)
        | //                         [765432__]
          //                [_________543210]
            ((((long)in.get(48 + inPos)) >>  2) & 63L);
      out[26 + outPos] =
          //                         [______10]
          //                               [43_____________]
            ((((long)in.get(48 + inPos)) <<  13) & 32767L)
        | //                         [76543210]
          //                       [__21098765_____]
            ((((long)in.get(49 + inPos)) <<  5) & 8191L)
        | //                         [76543___]
          //               [__________43210]
            ((((long)in.get(50 + inPos)) >>  3) & 31L);
      out[27 + outPos] =
          //                         [_____210]
          //                              [432____________]
            ((((long)in.get(50 + inPos)) <<  12) & 32767L)
        | //                         [76543210]
          //                      [___10987654____]
            ((((long)in.get(51 + inPos)) <<  4) & 4095L)
        | //                         [7654____]
          //              [___________3210]
            ((((long)in.get(52 + inPos)) >>  4) & 15L);
      out[28 + outPos] =
          //                         [____3210]
          //                             [4321___________]
            ((((long)in.get(52 + inPos)) <<  11) & 32767L)
        | //                         [76543210]
          //                     [____09876543___]
            ((((long)in.get(53 + inPos)) <<  3) & 2047L)
        | //                         [765_____]
          //             [____________210]
            ((((long)in.get(54 + inPos)) >>  5) & 7L);
      out[29 + outPos] =
          //                         [___43210]
          //                            [43210__________]
            ((((long)in.get(54 + inPos)) <<  10) & 32767L)
        | //                         [76543210]
          //                    [_____98765432__]
            ((((long)in.get(55 + inPos)) <<  2) & 1023L)
        | //                         [76______]
          //            [_____________10]
            ((((long)in.get(56 + inPos)) >>  6) & 3L);
      out[30 + outPos] =
          //                         [__543210]
          //                           [432109_________]
            ((((long)in.get(56 + inPos)) <<  9) & 32767L)
        | //                         [76543210]
          //                   [______87654321_]
            ((((long)in.get(57 + inPos)) <<  1) & 511L)
        | //                         [7_______]
          //           [______________0]
            ((((long)in.get(58 + inPos)) >>  7) & 1L);
      out[31 + outPos] =
          //                         [_6543210]
          //                          [4321098________]
            ((((long)in.get(58 + inPos)) <<  8) & 32767L)
        | //                         [76543210]
          //                  [_______76543210]
            ((((long)in.get(59 + inPos)) ) & 255L);
    }
  }

  private static final class Packer16 extends BytePackerForLong {

    private Packer16() {
      super(16);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 0 + inPos] & 65535L) >>> 8)) & 255);
      out[ 1 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 0 + inPos] & 65535L))) & 255);
      out[ 2 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 1 + inPos] & 65535L) >>> 8)) & 255);
      out[ 3 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 1 + inPos] & 65535L))) & 255);
      out[ 4 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 2 + inPos] & 65535L) >>> 8)) & 255);
      out[ 5 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 2 + inPos] & 65535L))) & 255);
      out[ 6 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 3 + inPos] & 65535L) >>> 8)) & 255);
      out[ 7 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 3 + inPos] & 65535L))) & 255);
      out[ 8 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 4 + inPos] & 65535L) >>> 8)) & 255);
      out[ 9 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 4 + inPos] & 65535L))) & 255);
      out[10 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 5 + inPos] & 65535L) >>> 8)) & 255);
      out[11 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 5 + inPos] & 65535L))) & 255);
      out[12 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 6 + inPos] & 65535L) >>> 8)) & 255);
      out[13 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 6 + inPos] & 65535L))) & 255);
      out[14 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 7 + inPos] & 65535L) >>> 8)) & 255);
      out[15 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 7 + inPos] & 65535L))) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 0 + inPos] & 65535L) >>> 8)) & 255);
      out[ 1 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 0 + inPos] & 65535L))) & 255);
      out[ 2 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 1 + inPos] & 65535L) >>> 8)) & 255);
      out[ 3 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 1 + inPos] & 65535L))) & 255);
      out[ 4 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 2 + inPos] & 65535L) >>> 8)) & 255);
      out[ 5 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 2 + inPos] & 65535L))) & 255);
      out[ 6 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 3 + inPos] & 65535L) >>> 8)) & 255);
      out[ 7 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 3 + inPos] & 65535L))) & 255);
      out[ 8 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 4 + inPos] & 65535L) >>> 8)) & 255);
      out[ 9 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 4 + inPos] & 65535L))) & 255);
      out[10 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 5 + inPos] & 65535L) >>> 8)) & 255);
      out[11 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 5 + inPos] & 65535L))) & 255);
      out[12 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 6 + inPos] & 65535L) >>> 8)) & 255);
      out[13 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 6 + inPos] & 65535L))) & 255);
      out[14 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 7 + inPos] & 65535L) >>> 8)) & 255);
      out[15 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 7 + inPos] & 65535L))) & 255);
      out[16 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 8 + inPos] & 65535L) >>> 8)) & 255);
      out[17 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 8 + inPos] & 65535L))) & 255);
      out[18 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 9 + inPos] & 65535L) >>> 8)) & 255);
      out[19 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 9 + inPos] & 65535L))) & 255);
      out[20 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[10 + inPos] & 65535L) >>> 8)) & 255);
      out[21 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[10 + inPos] & 65535L))) & 255);
      out[22 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[11 + inPos] & 65535L) >>> 8)) & 255);
      out[23 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[11 + inPos] & 65535L))) & 255);
      out[24 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[12 + inPos] & 65535L) >>> 8)) & 255);
      out[25 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[12 + inPos] & 65535L))) & 255);
      out[26 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[13 + inPos] & 65535L) >>> 8)) & 255);
      out[27 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[13 + inPos] & 65535L))) & 255);
      out[28 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[14 + inPos] & 65535L) >>> 8)) & 255);
      out[29 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[14 + inPos] & 65535L))) & 255);
      out[30 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[15 + inPos] & 65535L) >>> 8)) & 255);
      out[31 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[15 + inPos] & 65535L))) & 255);
      out[32 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[16 + inPos] & 65535L) >>> 8)) & 255);
      out[33 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[16 + inPos] & 65535L))) & 255);
      out[34 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[17 + inPos] & 65535L) >>> 8)) & 255);
      out[35 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[17 + inPos] & 65535L))) & 255);
      out[36 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[18 + inPos] & 65535L) >>> 8)) & 255);
      out[37 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[18 + inPos] & 65535L))) & 255);
      out[38 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[19 + inPos] & 65535L) >>> 8)) & 255);
      out[39 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[19 + inPos] & 65535L))) & 255);
      out[40 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[20 + inPos] & 65535L) >>> 8)) & 255);
      out[41 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[20 + inPos] & 65535L))) & 255);
      out[42 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[21 + inPos] & 65535L) >>> 8)) & 255);
      out[43 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[21 + inPos] & 65535L))) & 255);
      out[44 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[22 + inPos] & 65535L) >>> 8)) & 255);
      out[45 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[22 + inPos] & 65535L))) & 255);
      out[46 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[23 + inPos] & 65535L) >>> 8)) & 255);
      out[47 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[23 + inPos] & 65535L))) & 255);
      out[48 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[24 + inPos] & 65535L) >>> 8)) & 255);
      out[49 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[24 + inPos] & 65535L))) & 255);
      out[50 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[25 + inPos] & 65535L) >>> 8)) & 255);
      out[51 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[25 + inPos] & 65535L))) & 255);
      out[52 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[26 + inPos] & 65535L) >>> 8)) & 255);
      out[53 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[26 + inPos] & 65535L))) & 255);
      out[54 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[27 + inPos] & 65535L) >>> 8)) & 255);
      out[55 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[27 + inPos] & 65535L))) & 255);
      out[56 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[28 + inPos] & 65535L) >>> 8)) & 255);
      out[57 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[28 + inPos] & 65535L))) & 255);
      out[58 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[29 + inPos] & 65535L) >>> 8)) & 255);
      out[59 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[29 + inPos] & 65535L))) & 255);
      out[60 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[30 + inPos] & 65535L) >>> 8)) & 255);
      out[61 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[30 + inPos] & 65535L))) & 255);
      out[62 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[31 + inPos] & 65535L) >>> 8)) & 255);
      out[63 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[31 + inPos] & 65535L))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[ 0 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[ 1 + inPos]) ) & 255L);
      out[ 1 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[ 2 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[ 3 + inPos]) ) & 255L);
      out[ 2 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[ 4 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[ 5 + inPos]) ) & 255L);
      out[ 3 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[ 6 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[ 7 + inPos]) ) & 255L);
      out[ 4 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[ 8 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[ 9 + inPos]) ) & 255L);
      out[ 5 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[10 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[11 + inPos]) ) & 255L);
      out[ 6 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[12 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[13 + inPos]) ) & 255L);
      out[ 7 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[14 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[15 + inPos]) ) & 255L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get( 0 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get( 1 + inPos)) ) & 255L);
      out[ 1 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get( 2 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get( 3 + inPos)) ) & 255L);
      out[ 2 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get( 4 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get( 5 + inPos)) ) & 255L);
      out[ 3 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get( 6 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get( 7 + inPos)) ) & 255L);
      out[ 4 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get( 8 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get( 9 + inPos)) ) & 255L);
      out[ 5 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(10 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(11 + inPos)) ) & 255L);
      out[ 6 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(12 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(13 + inPos)) ) & 255L);
      out[ 7 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(14 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(15 + inPos)) ) & 255L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[ 0 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[ 1 + inPos]) ) & 255L);
      out[ 1 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[ 2 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[ 3 + inPos]) ) & 255L);
      out[ 2 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[ 4 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[ 5 + inPos]) ) & 255L);
      out[ 3 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[ 6 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[ 7 + inPos]) ) & 255L);
      out[ 4 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[ 8 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[ 9 + inPos]) ) & 255L);
      out[ 5 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[10 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[11 + inPos]) ) & 255L);
      out[ 6 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[12 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[13 + inPos]) ) & 255L);
      out[ 7 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[14 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[15 + inPos]) ) & 255L);
      out[ 8 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[16 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[17 + inPos]) ) & 255L);
      out[ 9 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[18 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[19 + inPos]) ) & 255L);
      out[10 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[20 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[21 + inPos]) ) & 255L);
      out[11 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[22 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[23 + inPos]) ) & 255L);
      out[12 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[24 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[25 + inPos]) ) & 255L);
      out[13 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[26 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[27 + inPos]) ) & 255L);
      out[14 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[28 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[29 + inPos]) ) & 255L);
      out[15 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[30 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[31 + inPos]) ) & 255L);
      out[16 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[32 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[33 + inPos]) ) & 255L);
      out[17 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[34 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[35 + inPos]) ) & 255L);
      out[18 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[36 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[37 + inPos]) ) & 255L);
      out[19 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[38 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[39 + inPos]) ) & 255L);
      out[20 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[40 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[41 + inPos]) ) & 255L);
      out[21 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[42 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[43 + inPos]) ) & 255L);
      out[22 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[44 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[45 + inPos]) ) & 255L);
      out[23 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[46 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[47 + inPos]) ) & 255L);
      out[24 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[48 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[49 + inPos]) ) & 255L);
      out[25 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[50 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[51 + inPos]) ) & 255L);
      out[26 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[52 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[53 + inPos]) ) & 255L);
      out[27 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[54 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[55 + inPos]) ) & 255L);
      out[28 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[56 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[57 + inPos]) ) & 255L);
      out[29 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[58 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[59 + inPos]) ) & 255L);
      out[30 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[60 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[61 + inPos]) ) & 255L);
      out[31 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in[62 + inPos]) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in[63 + inPos]) ) & 255L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get( 0 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get( 1 + inPos)) ) & 255L);
      out[ 1 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get( 2 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get( 3 + inPos)) ) & 255L);
      out[ 2 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get( 4 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get( 5 + inPos)) ) & 255L);
      out[ 3 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get( 6 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get( 7 + inPos)) ) & 255L);
      out[ 4 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get( 8 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get( 9 + inPos)) ) & 255L);
      out[ 5 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(10 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(11 + inPos)) ) & 255L);
      out[ 6 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(12 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(13 + inPos)) ) & 255L);
      out[ 7 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(14 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(15 + inPos)) ) & 255L);
      out[ 8 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(16 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(17 + inPos)) ) & 255L);
      out[ 9 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(18 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(19 + inPos)) ) & 255L);
      out[10 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(20 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(21 + inPos)) ) & 255L);
      out[11 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(22 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(23 + inPos)) ) & 255L);
      out[12 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(24 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(25 + inPos)) ) & 255L);
      out[13 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(26 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(27 + inPos)) ) & 255L);
      out[14 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(28 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(29 + inPos)) ) & 255L);
      out[15 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(30 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(31 + inPos)) ) & 255L);
      out[16 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(32 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(33 + inPos)) ) & 255L);
      out[17 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(34 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(35 + inPos)) ) & 255L);
      out[18 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(36 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(37 + inPos)) ) & 255L);
      out[19 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(38 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(39 + inPos)) ) & 255L);
      out[20 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(40 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(41 + inPos)) ) & 255L);
      out[21 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(42 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(43 + inPos)) ) & 255L);
      out[22 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(44 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(45 + inPos)) ) & 255L);
      out[23 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(46 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(47 + inPos)) ) & 255L);
      out[24 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(48 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(49 + inPos)) ) & 255L);
      out[25 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(50 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(51 + inPos)) ) & 255L);
      out[26 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(52 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(53 + inPos)) ) & 255L);
      out[27 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(54 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(55 + inPos)) ) & 255L);
      out[28 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(56 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(57 + inPos)) ) & 255L);
      out[29 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(58 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(59 + inPos)) ) & 255L);
      out[30 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(60 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(61 + inPos)) ) & 255L);
      out[31 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            ((((long)in.get(62 + inPos)) <<  8) & 65535L)
        | //                          [76543210]
          //                  [________76543210]
            ((((long)in.get(63 + inPos)) ) & 255L);
    }
  }

  private static final class Packer17 extends BytePackerForLong {

    private Packer17() {
      super(17);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                           [76543210]
          //                           [65432109_________]
           ((in[ 0 + inPos] & 131071L) >>> 9)) & 255);
      out[ 1 + outPos] = (byte)((
          //                           [76543210]
          //                   [________87654321_]
           ((in[ 0 + inPos] & 131071L) >>> 1)) & 255);
      out[ 2 + outPos] = (byte)((
          //                           [7_______]
          //           [________________0]
           ((in[ 0 + inPos] & 131071L) <<  7)
        | //                           [_6543210]
          //                            [6543210__________]
           ((in[ 1 + inPos] & 131071L) >>> 10)) & 255);
      out[ 3 + outPos] = (byte)((
          //                           [76543210]
          //                    [_______98765432__]
           ((in[ 1 + inPos] & 131071L) >>> 2)) & 255);
      out[ 4 + outPos] = (byte)((
          //                           [76______]
          //            [_______________10]
           ((in[ 1 + inPos] & 131071L) <<  6)
        | //                           [__543210]
          //                             [654321___________]
           ((in[ 2 + inPos] & 131071L) >>> 11)) & 255);
      out[ 5 + outPos] = (byte)((
          //                           [76543210]
          //                     [______09876543___]
           ((in[ 2 + inPos] & 131071L) >>> 3)) & 255);
      out[ 6 + outPos] = (byte)((
          //                           [765_____]
          //             [______________210]
           ((in[ 2 + inPos] & 131071L) <<  5)
        | //                           [___43210]
          //                              [65432____________]
           ((in[ 3 + inPos] & 131071L) >>> 12)) & 255);
      out[ 7 + outPos] = (byte)((
          //                           [76543210]
          //                      [_____10987654____]
           ((in[ 3 + inPos] & 131071L) >>> 4)) & 255);
      out[ 8 + outPos] = (byte)((
          //                           [7654____]
          //              [_____________3210]
           ((in[ 3 + inPos] & 131071L) <<  4)
        | //                           [____3210]
          //                               [6543_____________]
           ((in[ 4 + inPos] & 131071L) >>> 13)) & 255);
      out[ 9 + outPos] = (byte)((
          //                           [76543210]
          //                       [____21098765_____]
           ((in[ 4 + inPos] & 131071L) >>> 5)) & 255);
      out[10 + outPos] = (byte)((
          //                           [76543___]
          //               [____________43210]
           ((in[ 4 + inPos] & 131071L) <<  3)
        | //                           [_____210]
          //                                [654______________]
           ((in[ 5 + inPos] & 131071L) >>> 14)) & 255);
      out[11 + outPos] = (byte)((
          //                           [76543210]
          //                        [___32109876______]
           ((in[ 5 + inPos] & 131071L) >>> 6)) & 255);
      out[12 + outPos] = (byte)((
          //                           [765432__]
          //                [___________543210]
           ((in[ 5 + inPos] & 131071L) <<  2)
        | //                           [______10]
          //                                 [65_______________]
           ((in[ 6 + inPos] & 131071L) >>> 15)) & 255);
      out[13 + outPos] = (byte)((
          //                           [76543210]
          //                         [__43210987_______]
           ((in[ 6 + inPos] & 131071L) >>> 7)) & 255);
      out[14 + outPos] = (byte)((
          //                           [7654321_]
          //                 [__________6543210]
           ((in[ 6 + inPos] & 131071L) <<  1)
        | //                           [_______0]
          //                                  [6________________]
           ((in[ 7 + inPos] & 131071L) >>> 16)) & 255);
      out[15 + outPos] = (byte)((
          //                           [76543210]
          //                          [_54321098________]
           ((in[ 7 + inPos] & 131071L) >>> 8)) & 255);
      out[16 + outPos] = (byte)((
          //                           [76543210]
          //                  [_________76543210]
           ((in[ 7 + inPos] & 131071L))) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                           [76543210]
          //                           [65432109_________]
           ((in[ 0 + inPos] & 131071L) >>> 9)) & 255);
      out[ 1 + outPos] = (byte)((
          //                           [76543210]
          //                   [________87654321_]
           ((in[ 0 + inPos] & 131071L) >>> 1)) & 255);
      out[ 2 + outPos] = (byte)((
          //                           [7_______]
          //           [________________0]
           ((in[ 0 + inPos] & 131071L) <<  7)
        | //                           [_6543210]
          //                            [6543210__________]
           ((in[ 1 + inPos] & 131071L) >>> 10)) & 255);
      out[ 3 + outPos] = (byte)((
          //                           [76543210]
          //                    [_______98765432__]
           ((in[ 1 + inPos] & 131071L) >>> 2)) & 255);
      out[ 4 + outPos] = (byte)((
          //                           [76______]
          //            [_______________10]
           ((in[ 1 + inPos] & 131071L) <<  6)
        | //                           [__543210]
          //                             [654321___________]
           ((in[ 2 + inPos] & 131071L) >>> 11)) & 255);
      out[ 5 + outPos] = (byte)((
          //                           [76543210]
          //                     [______09876543___]
           ((in[ 2 + inPos] & 131071L) >>> 3)) & 255);
      out[ 6 + outPos] = (byte)((
          //                           [765_____]
          //             [______________210]
           ((in[ 2 + inPos] & 131071L) <<  5)
        | //                           [___43210]
          //                              [65432____________]
           ((in[ 3 + inPos] & 131071L) >>> 12)) & 255);
      out[ 7 + outPos] = (byte)((
          //                           [76543210]
          //                      [_____10987654____]
           ((in[ 3 + inPos] & 131071L) >>> 4)) & 255);
      out[ 8 + outPos] = (byte)((
          //                           [7654____]
          //              [_____________3210]
           ((in[ 3 + inPos] & 131071L) <<  4)
        | //                           [____3210]
          //                               [6543_____________]
           ((in[ 4 + inPos] & 131071L) >>> 13)) & 255);
      out[ 9 + outPos] = (byte)((
          //                           [76543210]
          //                       [____21098765_____]
           ((in[ 4 + inPos] & 131071L) >>> 5)) & 255);
      out[10 + outPos] = (byte)((
          //                           [76543___]
          //               [____________43210]
           ((in[ 4 + inPos] & 131071L) <<  3)
        | //                           [_____210]
          //                                [654______________]
           ((in[ 5 + inPos] & 131071L) >>> 14)) & 255);
      out[11 + outPos] = (byte)((
          //                           [76543210]
          //                        [___32109876______]
           ((in[ 5 + inPos] & 131071L) >>> 6)) & 255);
      out[12 + outPos] = (byte)((
          //                           [765432__]
          //                [___________543210]
           ((in[ 5 + inPos] & 131071L) <<  2)
        | //                           [______10]
          //                                 [65_______________]
           ((in[ 6 + inPos] & 131071L) >>> 15)) & 255);
      out[13 + outPos] = (byte)((
          //                           [76543210]
          //                         [__43210987_______]
           ((in[ 6 + inPos] & 131071L) >>> 7)) & 255);
      out[14 + outPos] = (byte)((
          //                           [7654321_]
          //                 [__________6543210]
           ((in[ 6 + inPos] & 131071L) <<  1)
        | //                           [_______0]
          //                                  [6________________]
           ((in[ 7 + inPos] & 131071L) >>> 16)) & 255);
      out[15 + outPos] = (byte)((
          //                           [76543210]
          //                          [_54321098________]
           ((in[ 7 + inPos] & 131071L) >>> 8)) & 255);
      out[16 + outPos] = (byte)((
          //                           [76543210]
          //                  [_________76543210]
           ((in[ 7 + inPos] & 131071L))) & 255);
      out[17 + outPos] = (byte)((
          //                           [76543210]
          //                           [65432109_________]
           ((in[ 8 + inPos] & 131071L) >>> 9)) & 255);
      out[18 + outPos] = (byte)((
          //                           [76543210]
          //                   [________87654321_]
           ((in[ 8 + inPos] & 131071L) >>> 1)) & 255);
      out[19 + outPos] = (byte)((
          //                           [7_______]
          //           [________________0]
           ((in[ 8 + inPos] & 131071L) <<  7)
        | //                           [_6543210]
          //                            [6543210__________]
           ((in[ 9 + inPos] & 131071L) >>> 10)) & 255);
      out[20 + outPos] = (byte)((
          //                           [76543210]
          //                    [_______98765432__]
           ((in[ 9 + inPos] & 131071L) >>> 2)) & 255);
      out[21 + outPos] = (byte)((
          //                           [76______]
          //            [_______________10]
           ((in[ 9 + inPos] & 131071L) <<  6)
        | //                           [__543210]
          //                             [654321___________]
           ((in[10 + inPos] & 131071L) >>> 11)) & 255);
      out[22 + outPos] = (byte)((
          //                           [76543210]
          //                     [______09876543___]
           ((in[10 + inPos] & 131071L) >>> 3)) & 255);
      out[23 + outPos] = (byte)((
          //                           [765_____]
          //             [______________210]
           ((in[10 + inPos] & 131071L) <<  5)
        | //                           [___43210]
          //                              [65432____________]
           ((in[11 + inPos] & 131071L) >>> 12)) & 255);
      out[24 + outPos] = (byte)((
          //                           [76543210]
          //                      [_____10987654____]
           ((in[11 + inPos] & 131071L) >>> 4)) & 255);
      out[25 + outPos] = (byte)((
          //                           [7654____]
          //              [_____________3210]
           ((in[11 + inPos] & 131071L) <<  4)
        | //                           [____3210]
          //                               [6543_____________]
           ((in[12 + inPos] & 131071L) >>> 13)) & 255);
      out[26 + outPos] = (byte)((
          //                           [76543210]
          //                       [____21098765_____]
           ((in[12 + inPos] & 131071L) >>> 5)) & 255);
      out[27 + outPos] = (byte)((
          //                           [76543___]
          //               [____________43210]
           ((in[12 + inPos] & 131071L) <<  3)
        | //                           [_____210]
          //                                [654______________]
           ((in[13 + inPos] & 131071L) >>> 14)) & 255);
      out[28 + outPos] = (byte)((
          //                           [76543210]
          //                        [___32109876______]
           ((in[13 + inPos] & 131071L) >>> 6)) & 255);
      out[29 + outPos] = (byte)((
          //                           [765432__]
          //                [___________543210]
           ((in[13 + inPos] & 131071L) <<  2)
        | //                           [______10]
          //                                 [65_______________]
           ((in[14 + inPos] & 131071L) >>> 15)) & 255);
      out[30 + outPos] = (byte)((
          //                           [76543210]
          //                         [__43210987_______]
           ((in[14 + inPos] & 131071L) >>> 7)) & 255);
      out[31 + outPos] = (byte)((
          //                           [7654321_]
          //                 [__________6543210]
           ((in[14 + inPos] & 131071L) <<  1)
        | //                           [_______0]
          //                                  [6________________]
           ((in[15 + inPos] & 131071L) >>> 16)) & 255);
      out[32 + outPos] = (byte)((
          //                           [76543210]
          //                          [_54321098________]
           ((in[15 + inPos] & 131071L) >>> 8)) & 255);
      out[33 + outPos] = (byte)((
          //                           [76543210]
          //                  [_________76543210]
           ((in[15 + inPos] & 131071L))) & 255);
      out[34 + outPos] = (byte)((
          //                           [76543210]
          //                           [65432109_________]
           ((in[16 + inPos] & 131071L) >>> 9)) & 255);
      out[35 + outPos] = (byte)((
          //                           [76543210]
          //                   [________87654321_]
           ((in[16 + inPos] & 131071L) >>> 1)) & 255);
      out[36 + outPos] = (byte)((
          //                           [7_______]
          //           [________________0]
           ((in[16 + inPos] & 131071L) <<  7)
        | //                           [_6543210]
          //                            [6543210__________]
           ((in[17 + inPos] & 131071L) >>> 10)) & 255);
      out[37 + outPos] = (byte)((
          //                           [76543210]
          //                    [_______98765432__]
           ((in[17 + inPos] & 131071L) >>> 2)) & 255);
      out[38 + outPos] = (byte)((
          //                           [76______]
          //            [_______________10]
           ((in[17 + inPos] & 131071L) <<  6)
        | //                           [__543210]
          //                             [654321___________]
           ((in[18 + inPos] & 131071L) >>> 11)) & 255);
      out[39 + outPos] = (byte)((
          //                           [76543210]
          //                     [______09876543___]
           ((in[18 + inPos] & 131071L) >>> 3)) & 255);
      out[40 + outPos] = (byte)((
          //                           [765_____]
          //             [______________210]
           ((in[18 + inPos] & 131071L) <<  5)
        | //                           [___43210]
          //                              [65432____________]
           ((in[19 + inPos] & 131071L) >>> 12)) & 255);
      out[41 + outPos] = (byte)((
          //                           [76543210]
          //                      [_____10987654____]
           ((in[19 + inPos] & 131071L) >>> 4)) & 255);
      out[42 + outPos] = (byte)((
          //                           [7654____]
          //              [_____________3210]
           ((in[19 + inPos] & 131071L) <<  4)
        | //                           [____3210]
          //                               [6543_____________]
           ((in[20 + inPos] & 131071L) >>> 13)) & 255);
      out[43 + outPos] = (byte)((
          //                           [76543210]
          //                       [____21098765_____]
           ((in[20 + inPos] & 131071L) >>> 5)) & 255);
      out[44 + outPos] = (byte)((
          //                           [76543___]
          //               [____________43210]
           ((in[20 + inPos] & 131071L) <<  3)
        | //                           [_____210]
          //                                [654______________]
           ((in[21 + inPos] & 131071L) >>> 14)) & 255);
      out[45 + outPos] = (byte)((
          //                           [76543210]
          //                        [___32109876______]
           ((in[21 + inPos] & 131071L) >>> 6)) & 255);
      out[46 + outPos] = (byte)((
          //                           [765432__]
          //                [___________543210]
           ((in[21 + inPos] & 131071L) <<  2)
        | //                           [______10]
          //                                 [65_______________]
           ((in[22 + inPos] & 131071L) >>> 15)) & 255);
      out[47 + outPos] = (byte)((
          //                           [76543210]
          //                         [__43210987_______]
           ((in[22 + inPos] & 131071L) >>> 7)) & 255);
      out[48 + outPos] = (byte)((
          //                           [7654321_]
          //                 [__________6543210]
           ((in[22 + inPos] & 131071L) <<  1)
        | //                           [_______0]
          //                                  [6________________]
           ((in[23 + inPos] & 131071L) >>> 16)) & 255);
      out[49 + outPos] = (byte)((
          //                           [76543210]
          //                          [_54321098________]
           ((in[23 + inPos] & 131071L) >>> 8)) & 255);
      out[50 + outPos] = (byte)((
          //                           [76543210]
          //                  [_________76543210]
           ((in[23 + inPos] & 131071L))) & 255);
      out[51 + outPos] = (byte)((
          //                           [76543210]
          //                           [65432109_________]
           ((in[24 + inPos] & 131071L) >>> 9)) & 255);
      out[52 + outPos] = (byte)((
          //                           [76543210]
          //                   [________87654321_]
           ((in[24 + inPos] & 131071L) >>> 1)) & 255);
      out[53 + outPos] = (byte)((
          //                           [7_______]
          //           [________________0]
           ((in[24 + inPos] & 131071L) <<  7)
        | //                           [_6543210]
          //                            [6543210__________]
           ((in[25 + inPos] & 131071L) >>> 10)) & 255);
      out[54 + outPos] = (byte)((
          //                           [76543210]
          //                    [_______98765432__]
           ((in[25 + inPos] & 131071L) >>> 2)) & 255);
      out[55 + outPos] = (byte)((
          //                           [76______]
          //            [_______________10]
           ((in[25 + inPos] & 131071L) <<  6)
        | //                           [__543210]
          //                             [654321___________]
           ((in[26 + inPos] & 131071L) >>> 11)) & 255);
      out[56 + outPos] = (byte)((
          //                           [76543210]
          //                     [______09876543___]
           ((in[26 + inPos] & 131071L) >>> 3)) & 255);
      out[57 + outPos] = (byte)((
          //                           [765_____]
          //             [______________210]
           ((in[26 + inPos] & 131071L) <<  5)
        | //                           [___43210]
          //                              [65432____________]
           ((in[27 + inPos] & 131071L) >>> 12)) & 255);
      out[58 + outPos] = (byte)((
          //                           [76543210]
          //                      [_____10987654____]
           ((in[27 + inPos] & 131071L) >>> 4)) & 255);
      out[59 + outPos] = (byte)((
          //                           [7654____]
          //              [_____________3210]
           ((in[27 + inPos] & 131071L) <<  4)
        | //                           [____3210]
          //                               [6543_____________]
           ((in[28 + inPos] & 131071L) >>> 13)) & 255);
      out[60 + outPos] = (byte)((
          //                           [76543210]
          //                       [____21098765_____]
           ((in[28 + inPos] & 131071L) >>> 5)) & 255);
      out[61 + outPos] = (byte)((
          //                           [76543___]
          //               [____________43210]
           ((in[28 + inPos] & 131071L) <<  3)
        | //                           [_____210]
          //                                [654______________]
           ((in[29 + inPos] & 131071L) >>> 14)) & 255);
      out[62 + outPos] = (byte)((
          //                           [76543210]
          //                        [___32109876______]
           ((in[29 + inPos] & 131071L) >>> 6)) & 255);
      out[63 + outPos] = (byte)((
          //                           [765432__]
          //                [___________543210]
           ((in[29 + inPos] & 131071L) <<  2)
        | //                           [______10]
          //                                 [65_______________]
           ((in[30 + inPos] & 131071L) >>> 15)) & 255);
      out[64 + outPos] = (byte)((
          //                           [76543210]
          //                         [__43210987_______]
           ((in[30 + inPos] & 131071L) >>> 7)) & 255);
      out[65 + outPos] = (byte)((
          //                           [7654321_]
          //                 [__________6543210]
           ((in[30 + inPos] & 131071L) <<  1)
        | //                           [_______0]
          //                                  [6________________]
           ((in[31 + inPos] & 131071L) >>> 16)) & 255);
      out[66 + outPos] = (byte)((
          //                           [76543210]
          //                          [_54321098________]
           ((in[31 + inPos] & 131071L) >>> 8)) & 255);
      out[67 + outPos] = (byte)((
          //                           [76543210]
          //                  [_________76543210]
           ((in[31 + inPos] & 131071L))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                           [76543210]
          //                           [65432109_________]
            ((((long)in[ 0 + inPos]) <<  9) & 131071L)
        | //                           [76543210]
          //                   [________87654321_]
            ((((long)in[ 1 + inPos]) <<  1) & 511L)
        | //                           [7_______]
          //           [________________0]
            ((((long)in[ 2 + inPos]) >>  7) & 1L);
      out[ 1 + outPos] =
          //                           [_6543210]
          //                            [6543210__________]
            ((((long)in[ 2 + inPos]) <<  10) & 131071L)
        | //                           [76543210]
          //                    [_______98765432__]
            ((((long)in[ 3 + inPos]) <<  2) & 1023L)
        | //                           [76______]
          //            [_______________10]
            ((((long)in[ 4 + inPos]) >>  6) & 3L);
      out[ 2 + outPos] =
          //                           [__543210]
          //                             [654321___________]
            ((((long)in[ 4 + inPos]) <<  11) & 131071L)
        | //                           [76543210]
          //                     [______09876543___]
            ((((long)in[ 5 + inPos]) <<  3) & 2047L)
        | //                           [765_____]
          //             [______________210]
            ((((long)in[ 6 + inPos]) >>  5) & 7L);
      out[ 3 + outPos] =
          //                           [___43210]
          //                              [65432____________]
            ((((long)in[ 6 + inPos]) <<  12) & 131071L)
        | //                           [76543210]
          //                      [_____10987654____]
            ((((long)in[ 7 + inPos]) <<  4) & 4095L)
        | //                           [7654____]
          //              [_____________3210]
            ((((long)in[ 8 + inPos]) >>  4) & 15L);
      out[ 4 + outPos] =
          //                           [____3210]
          //                               [6543_____________]
            ((((long)in[ 8 + inPos]) <<  13) & 131071L)
        | //                           [76543210]
          //                       [____21098765_____]
            ((((long)in[ 9 + inPos]) <<  5) & 8191L)
        | //                           [76543___]
          //               [____________43210]
            ((((long)in[10 + inPos]) >>  3) & 31L);
      out[ 5 + outPos] =
          //                           [_____210]
          //                                [654______________]
            ((((long)in[10 + inPos]) <<  14) & 131071L)
        | //                           [76543210]
          //                        [___32109876______]
            ((((long)in[11 + inPos]) <<  6) & 16383L)
        | //                           [765432__]
          //                [___________543210]
            ((((long)in[12 + inPos]) >>  2) & 63L);
      out[ 6 + outPos] =
          //                           [______10]
          //                                 [65_______________]
            ((((long)in[12 + inPos]) <<  15) & 131071L)
        | //                           [76543210]
          //                         [__43210987_______]
            ((((long)in[13 + inPos]) <<  7) & 32767L)
        | //                           [7654321_]
          //                 [__________6543210]
            ((((long)in[14 + inPos]) >>  1) & 127L);
      out[ 7 + outPos] =
          //                           [_______0]
          //                                  [6________________]
            ((((long)in[14 + inPos]) <<  16) & 131071L)
        | //                           [76543210]
          //                          [_54321098________]
            ((((long)in[15 + inPos]) <<  8) & 65535L)
        | //                           [76543210]
          //                  [_________76543210]
            ((((long)in[16 + inPos]) ) & 255L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                           [76543210]
          //                           [65432109_________]
            ((((long)in.get( 0 + inPos)) <<  9) & 131071L)
        | //                           [76543210]
          //                   [________87654321_]
            ((((long)in.get( 1 + inPos)) <<  1) & 511L)
        | //                           [7_______]
          //           [________________0]
            ((((long)in.get( 2 + inPos)) >>  7) & 1L);
      out[ 1 + outPos] =
          //                           [_6543210]
          //                            [6543210__________]
            ((((long)in.get( 2 + inPos)) <<  10) & 131071L)
        | //                           [76543210]
          //                    [_______98765432__]
            ((((long)in.get( 3 + inPos)) <<  2) & 1023L)
        | //                           [76______]
          //            [_______________10]
            ((((long)in.get( 4 + inPos)) >>  6) & 3L);
      out[ 2 + outPos] =
          //                           [__543210]
          //                             [654321___________]
            ((((long)in.get( 4 + inPos)) <<  11) & 131071L)
        | //                           [76543210]
          //                     [______09876543___]
            ((((long)in.get( 5 + inPos)) <<  3) & 2047L)
        | //                           [765_____]
          //             [______________210]
            ((((long)in.get( 6 + inPos)) >>  5) & 7L);
      out[ 3 + outPos] =
          //                           [___43210]
          //                              [65432____________]
            ((((long)in.get( 6 + inPos)) <<  12) & 131071L)
        | //                           [76543210]
          //                      [_____10987654____]
            ((((long)in.get( 7 + inPos)) <<  4) & 4095L)
        | //                           [7654____]
          //              [_____________3210]
            ((((long)in.get( 8 + inPos)) >>  4) & 15L);
      out[ 4 + outPos] =
          //                           [____3210]
          //                               [6543_____________]
            ((((long)in.get( 8 + inPos)) <<  13) & 131071L)
        | //                           [76543210]
          //                       [____21098765_____]
            ((((long)in.get( 9 + inPos)) <<  5) & 8191L)
        | //                           [76543___]
          //               [____________43210]
            ((((long)in.get(10 + inPos)) >>  3) & 31L);
      out[ 5 + outPos] =
          //                           [_____210]
          //                                [654______________]
            ((((long)in.get(10 + inPos)) <<  14) & 131071L)
        | //                           [76543210]
          //                        [___32109876______]
            ((((long)in.get(11 + inPos)) <<  6) & 16383L)
        | //                           [765432__]
          //                [___________543210]
            ((((long)in.get(12 + inPos)) >>  2) & 63L);
      out[ 6 + outPos] =
          //                           [______10]
          //                                 [65_______________]
            ((((long)in.get(12 + inPos)) <<  15) & 131071L)
        | //                           [76543210]
          //                         [__43210987_______]
            ((((long)in.get(13 + inPos)) <<  7) & 32767L)
        | //                           [7654321_]
          //                 [__________6543210]
            ((((long)in.get(14 + inPos)) >>  1) & 127L);
      out[ 7 + outPos] =
          //                           [_______0]
          //                                  [6________________]
            ((((long)in.get(14 + inPos)) <<  16) & 131071L)
        | //                           [76543210]
          //                          [_54321098________]
            ((((long)in.get(15 + inPos)) <<  8) & 65535L)
        | //                           [76543210]
          //                  [_________76543210]
            ((((long)in.get(16 + inPos)) ) & 255L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                           [76543210]
          //                           [65432109_________]
            ((((long)in[ 0 + inPos]) <<  9) & 131071L)
        | //                           [76543210]
          //                   [________87654321_]
            ((((long)in[ 1 + inPos]) <<  1) & 511L)
        | //                           [7_______]
          //           [________________0]
            ((((long)in[ 2 + inPos]) >>  7) & 1L);
      out[ 1 + outPos] =
          //                           [_6543210]
          //                            [6543210__________]
            ((((long)in[ 2 + inPos]) <<  10) & 131071L)
        | //                           [76543210]
          //                    [_______98765432__]
            ((((long)in[ 3 + inPos]) <<  2) & 1023L)
        | //                           [76______]
          //            [_______________10]
            ((((long)in[ 4 + inPos]) >>  6) & 3L);
      out[ 2 + outPos] =
          //                           [__543210]
          //                             [654321___________]
            ((((long)in[ 4 + inPos]) <<  11) & 131071L)
        | //                           [76543210]
          //                     [______09876543___]
            ((((long)in[ 5 + inPos]) <<  3) & 2047L)
        | //                           [765_____]
          //             [______________210]
            ((((long)in[ 6 + inPos]) >>  5) & 7L);
      out[ 3 + outPos] =
          //                           [___43210]
          //                              [65432____________]
            ((((long)in[ 6 + inPos]) <<  12) & 131071L)
        | //                           [76543210]
          //                      [_____10987654____]
            ((((long)in[ 7 + inPos]) <<  4) & 4095L)
        | //                           [7654____]
          //              [_____________3210]
            ((((long)in[ 8 + inPos]) >>  4) & 15L);
      out[ 4 + outPos] =
          //                           [____3210]
          //                               [6543_____________]
            ((((long)in[ 8 + inPos]) <<  13) & 131071L)
        | //                           [76543210]
          //                       [____21098765_____]
            ((((long)in[ 9 + inPos]) <<  5) & 8191L)
        | //                           [76543___]
          //               [____________43210]
            ((((long)in[10 + inPos]) >>  3) & 31L);
      out[ 5 + outPos] =
          //                           [_____210]
          //                                [654______________]
            ((((long)in[10 + inPos]) <<  14) & 131071L)
        | //                           [76543210]
          //                        [___32109876______]
            ((((long)in[11 + inPos]) <<  6) & 16383L)
        | //                           [765432__]
          //                [___________543210]
            ((((long)in[12 + inPos]) >>  2) & 63L);
      out[ 6 + outPos] =
          //                           [______10]
          //                                 [65_______________]
            ((((long)in[12 + inPos]) <<  15) & 131071L)
        | //                           [76543210]
          //                         [__43210987_______]
            ((((long)in[13 + inPos]) <<  7) & 32767L)
        | //                           [7654321_]
          //                 [__________6543210]
            ((((long)in[14 + inPos]) >>  1) & 127L);
      out[ 7 + outPos] =
          //                           [_______0]
          //                                  [6________________]
            ((((long)in[14 + inPos]) <<  16) & 131071L)
        | //                           [76543210]
          //                          [_54321098________]
            ((((long)in[15 + inPos]) <<  8) & 65535L)
        | //                           [76543210]
          //                  [_________76543210]
            ((((long)in[16 + inPos]) ) & 255L);
      out[ 8 + outPos] =
          //                           [76543210]
          //                           [65432109_________]
            ((((long)in[17 + inPos]) <<  9) & 131071L)
        | //                           [76543210]
          //                   [________87654321_]
            ((((long)in[18 + inPos]) <<  1) & 511L)
        | //                           [7_______]
          //           [________________0]
            ((((long)in[19 + inPos]) >>  7) & 1L);
      out[ 9 + outPos] =
          //                           [_6543210]
          //                            [6543210__________]
            ((((long)in[19 + inPos]) <<  10) & 131071L)
        | //                           [76543210]
          //                    [_______98765432__]
            ((((long)in[20 + inPos]) <<  2) & 1023L)
        | //                           [76______]
          //            [_______________10]
            ((((long)in[21 + inPos]) >>  6) & 3L);
      out[10 + outPos] =
          //                           [__543210]
          //                             [654321___________]
            ((((long)in[21 + inPos]) <<  11) & 131071L)
        | //                           [76543210]
          //                     [______09876543___]
            ((((long)in[22 + inPos]) <<  3) & 2047L)
        | //                           [765_____]
          //             [______________210]
            ((((long)in[23 + inPos]) >>  5) & 7L);
      out[11 + outPos] =
          //                           [___43210]
          //                              [65432____________]
            ((((long)in[23 + inPos]) <<  12) & 131071L)
        | //                           [76543210]
          //                      [_____10987654____]
            ((((long)in[24 + inPos]) <<  4) & 4095L)
        | //                           [7654____]
          //              [_____________3210]
            ((((long)in[25 + inPos]) >>  4) & 15L);
      out[12 + outPos] =
          //                           [____3210]
          //                               [6543_____________]
            ((((long)in[25 + inPos]) <<  13) & 131071L)
        | //                           [76543210]
          //                       [____21098765_____]
            ((((long)in[26 + inPos]) <<  5) & 8191L)
        | //                           [76543___]
          //               [____________43210]
            ((((long)in[27 + inPos]) >>  3) & 31L);
      out[13 + outPos] =
          //                           [_____210]
          //                                [654______________]
            ((((long)in[27 + inPos]) <<  14) & 131071L)
        | //                           [76543210]
          //                        [___32109876______]
            ((((long)in[28 + inPos]) <<  6) & 16383L)
        | //                           [765432__]
          //                [___________543210]
            ((((long)in[29 + inPos]) >>  2) & 63L);
      out[14 + outPos] =
          //                           [______10]
          //                                 [65_______________]
            ((((long)in[29 + inPos]) <<  15) & 131071L)
        | //                           [76543210]
          //                         [__43210987_______]
            ((((long)in[30 + inPos]) <<  7) & 32767L)
        | //                           [7654321_]
          //                 [__________6543210]
            ((((long)in[31 + inPos]) >>  1) & 127L);
      out[15 + outPos] =
          //                           [_______0]
          //                                  [6________________]
            ((((long)in[31 + inPos]) <<  16) & 131071L)
        | //                           [76543210]
          //                          [_54321098________]
            ((((long)in[32 + inPos]) <<  8) & 65535L)
        | //                           [76543210]
          //                  [_________76543210]
            ((((long)in[33 + inPos]) ) & 255L);
      out[16 + outPos] =
          //                           [76543210]
          //                           [65432109_________]
            ((((long)in[34 + inPos]) <<  9) & 131071L)
        | //                           [76543210]
          //                   [________87654321_]
            ((((long)in[35 + inPos]) <<  1) & 511L)
        | //                           [7_______]
          //           [________________0]
            ((((long)in[36 + inPos]) >>  7) & 1L);
      out[17 + outPos] =
          //                           [_6543210]
          //                            [6543210__________]
            ((((long)in[36 + inPos]) <<  10) & 131071L)
        | //                           [76543210]
          //                    [_______98765432__]
            ((((long)in[37 + inPos]) <<  2) & 1023L)
        | //                           [76______]
          //            [_______________10]
            ((((long)in[38 + inPos]) >>  6) & 3L);
      out[18 + outPos] =
          //                           [__543210]
          //                             [654321___________]
            ((((long)in[38 + inPos]) <<  11) & 131071L)
        | //                           [76543210]
          //                     [______09876543___]
            ((((long)in[39 + inPos]) <<  3) & 2047L)
        | //                           [765_____]
          //             [______________210]
            ((((long)in[40 + inPos]) >>  5) & 7L);
      out[19 + outPos] =
          //                           [___43210]
          //                              [65432____________]
            ((((long)in[40 + inPos]) <<  12) & 131071L)
        | //                           [76543210]
          //                      [_____10987654____]
            ((((long)in[41 + inPos]) <<  4) & 4095L)
        | //                           [7654____]
          //              [_____________3210]
            ((((long)in[42 + inPos]) >>  4) & 15L);
      out[20 + outPos] =
          //                           [____3210]
          //                               [6543_____________]
            ((((long)in[42 + inPos]) <<  13) & 131071L)
        | //                           [76543210]
          //                       [____21098765_____]
            ((((long)in[43 + inPos]) <<  5) & 8191L)
        | //                           [76543___]
          //               [____________43210]
            ((((long)in[44 + inPos]) >>  3) & 31L);
      out[21 + outPos] =
          //                           [_____210]
          //                                [654______________]
            ((((long)in[44 + inPos]) <<  14) & 131071L)
        | //                           [76543210]
          //                        [___32109876______]
            ((((long)in[45 + inPos]) <<  6) & 16383L)
        | //                           [765432__]
          //                [___________543210]
            ((((long)in[46 + inPos]) >>  2) & 63L);
      out[22 + outPos] =
          //                           [______10]
          //                                 [65_______________]
            ((((long)in[46 + inPos]) <<  15) & 131071L)
        | //                           [76543210]
          //                         [__43210987_______]
            ((((long)in[47 + inPos]) <<  7) & 32767L)
        | //                           [7654321_]
          //                 [__________6543210]
            ((((long)in[48 + inPos]) >>  1) & 127L);
      out[23 + outPos] =
          //                           [_______0]
          //                                  [6________________]
            ((((long)in[48 + inPos]) <<  16) & 131071L)
        | //                           [76543210]
          //                          [_54321098________]
            ((((long)in[49 + inPos]) <<  8) & 65535L)
        | //                           [76543210]
          //                  [_________76543210]
            ((((long)in[50 + inPos]) ) & 255L);
      out[24 + outPos] =
          //                           [76543210]
          //                           [65432109_________]
            ((((long)in[51 + inPos]) <<  9) & 131071L)
        | //                           [76543210]
          //                   [________87654321_]
            ((((long)in[52 + inPos]) <<  1) & 511L)
        | //                           [7_______]
          //           [________________0]
            ((((long)in[53 + inPos]) >>  7) & 1L);
      out[25 + outPos] =
          //                           [_6543210]
          //                            [6543210__________]
            ((((long)in[53 + inPos]) <<  10) & 131071L)
        | //                           [76543210]
          //                    [_______98765432__]
            ((((long)in[54 + inPos]) <<  2) & 1023L)
        | //                           [76______]
          //            [_______________10]
            ((((long)in[55 + inPos]) >>  6) & 3L);
      out[26 + outPos] =
          //                           [__543210]
          //                             [654321___________]
            ((((long)in[55 + inPos]) <<  11) & 131071L)
        | //                           [76543210]
          //                     [______09876543___]
            ((((long)in[56 + inPos]) <<  3) & 2047L)
        | //                           [765_____]
          //             [______________210]
            ((((long)in[57 + inPos]) >>  5) & 7L);
      out[27 + outPos] =
          //                           [___43210]
          //                              [65432____________]
            ((((long)in[57 + inPos]) <<  12) & 131071L)
        | //                           [76543210]
          //                      [_____10987654____]
            ((((long)in[58 + inPos]) <<  4) & 4095L)
        | //                           [7654____]
          //              [_____________3210]
            ((((long)in[59 + inPos]) >>  4) & 15L);
      out[28 + outPos] =
          //                           [____3210]
          //                               [6543_____________]
            ((((long)in[59 + inPos]) <<  13) & 131071L)
        | //                           [76543210]
          //                       [____21098765_____]
            ((((long)in[60 + inPos]) <<  5) & 8191L)
        | //                           [76543___]
          //               [____________43210]
            ((((long)in[61 + inPos]) >>  3) & 31L);
      out[29 + outPos] =
          //                           [_____210]
          //                                [654______________]
            ((((long)in[61 + inPos]) <<  14) & 131071L)
        | //                           [76543210]
          //                        [___32109876______]
            ((((long)in[62 + inPos]) <<  6) & 16383L)
        | //                           [765432__]
          //                [___________543210]
            ((((long)in[63 + inPos]) >>  2) & 63L);
      out[30 + outPos] =
          //                           [______10]
          //                                 [65_______________]
            ((((long)in[63 + inPos]) <<  15) & 131071L)
        | //                           [76543210]
          //                         [__43210987_______]
            ((((long)in[64 + inPos]) <<  7) & 32767L)
        | //                           [7654321_]
          //                 [__________6543210]
            ((((long)in[65 + inPos]) >>  1) & 127L);
      out[31 + outPos] =
          //                           [_______0]
          //                                  [6________________]
            ((((long)in[65 + inPos]) <<  16) & 131071L)
        | //                           [76543210]
          //                          [_54321098________]
            ((((long)in[66 + inPos]) <<  8) & 65535L)
        | //                           [76543210]
          //                  [_________76543210]
            ((((long)in[67 + inPos]) ) & 255L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                           [76543210]
          //                           [65432109_________]
            ((((long)in.get( 0 + inPos)) <<  9) & 131071L)
        | //                           [76543210]
          //                   [________87654321_]
            ((((long)in.get( 1 + inPos)) <<  1) & 511L)
        | //                           [7_______]
          //           [________________0]
            ((((long)in.get( 2 + inPos)) >>  7) & 1L);
      out[ 1 + outPos] =
          //                           [_6543210]
          //                            [6543210__________]
            ((((long)in.get( 2 + inPos)) <<  10) & 131071L)
        | //                           [76543210]
          //                    [_______98765432__]
            ((((long)in.get( 3 + inPos)) <<  2) & 1023L)
        | //                           [76______]
          //            [_______________10]
            ((((long)in.get( 4 + inPos)) >>  6) & 3L);
      out[ 2 + outPos] =
          //                           [__543210]
          //                             [654321___________]
            ((((long)in.get( 4 + inPos)) <<  11) & 131071L)
        | //                           [76543210]
          //                     [______09876543___]
            ((((long)in.get( 5 + inPos)) <<  3) & 2047L)
        | //                           [765_____]
          //             [______________210]
            ((((long)in.get( 6 + inPos)) >>  5) & 7L);
      out[ 3 + outPos] =
          //                           [___43210]
          //                              [65432____________]
            ((((long)in.get( 6 + inPos)) <<  12) & 131071L)
        | //                           [76543210]
          //                      [_____10987654____]
            ((((long)in.get( 7 + inPos)) <<  4) & 4095L)
        | //                           [7654____]
          //              [_____________3210]
            ((((long)in.get( 8 + inPos)) >>  4) & 15L);
      out[ 4 + outPos] =
          //                           [____3210]
          //                               [6543_____________]
            ((((long)in.get( 8 + inPos)) <<  13) & 131071L)
        | //                           [76543210]
          //                       [____21098765_____]
            ((((long)in.get( 9 + inPos)) <<  5) & 8191L)
        | //                           [76543___]
          //               [____________43210]
            ((((long)in.get(10 + inPos)) >>  3) & 31L);
      out[ 5 + outPos] =
          //                           [_____210]
          //                                [654______________]
            ((((long)in.get(10 + inPos)) <<  14) & 131071L)
        | //                           [76543210]
          //                        [___32109876______]
            ((((long)in.get(11 + inPos)) <<  6) & 16383L)
        | //                           [765432__]
          //                [___________543210]
            ((((long)in.get(12 + inPos)) >>  2) & 63L);
      out[ 6 + outPos] =
          //                           [______10]
          //                                 [65_______________]
            ((((long)in.get(12 + inPos)) <<  15) & 131071L)
        | //                           [76543210]
          //                         [__43210987_______]
            ((((long)in.get(13 + inPos)) <<  7) & 32767L)
        | //                           [7654321_]
          //                 [__________6543210]
            ((((long)in.get(14 + inPos)) >>  1) & 127L);
      out[ 7 + outPos] =
          //                           [_______0]
          //                                  [6________________]
            ((((long)in.get(14 + inPos)) <<  16) & 131071L)
        | //                           [76543210]
          //                          [_54321098________]
            ((((long)in.get(15 + inPos)) <<  8) & 65535L)
        | //                           [76543210]
          //                  [_________76543210]
            ((((long)in.get(16 + inPos)) ) & 255L);
      out[ 8 + outPos] =
          //                           [76543210]
          //                           [65432109_________]
            ((((long)in.get(17 + inPos)) <<  9) & 131071L)
        | //                           [76543210]
          //                   [________87654321_]
            ((((long)in.get(18 + inPos)) <<  1) & 511L)
        | //                           [7_______]
          //           [________________0]
            ((((long)in.get(19 + inPos)) >>  7) & 1L);
      out[ 9 + outPos] =
          //                           [_6543210]
          //                            [6543210__________]
            ((((long)in.get(19 + inPos)) <<  10) & 131071L)
        | //                           [76543210]
          //                    [_______98765432__]
            ((((long)in.get(20 + inPos)) <<  2) & 1023L)
        | //                           [76______]
          //            [_______________10]
            ((((long)in.get(21 + inPos)) >>  6) & 3L);
      out[10 + outPos] =
          //                           [__543210]
          //                             [654321___________]
            ((((long)in.get(21 + inPos)) <<  11) & 131071L)
        | //                           [76543210]
          //                     [______09876543___]
            ((((long)in.get(22 + inPos)) <<  3) & 2047L)
        | //                           [765_____]
          //             [______________210]
            ((((long)in.get(23 + inPos)) >>  5) & 7L);
      out[11 + outPos] =
          //                           [___43210]
          //                              [65432____________]
            ((((long)in.get(23 + inPos)) <<  12) & 131071L)
        | //                           [76543210]
          //                      [_____10987654____]
            ((((long)in.get(24 + inPos)) <<  4) & 4095L)
        | //                           [7654____]
          //              [_____________3210]
            ((((long)in.get(25 + inPos)) >>  4) & 15L);
      out[12 + outPos] =
          //                           [____3210]
          //                               [6543_____________]
            ((((long)in.get(25 + inPos)) <<  13) & 131071L)
        | //                           [76543210]
          //                       [____21098765_____]
            ((((long)in.get(26 + inPos)) <<  5) & 8191L)
        | //                           [76543___]
          //               [____________43210]
            ((((long)in.get(27 + inPos)) >>  3) & 31L);
      out[13 + outPos] =
          //                           [_____210]
          //                                [654______________]
            ((((long)in.get(27 + inPos)) <<  14) & 131071L)
        | //                           [76543210]
          //                        [___32109876______]
            ((((long)in.get(28 + inPos)) <<  6) & 16383L)
        | //                           [765432__]
          //                [___________543210]
            ((((long)in.get(29 + inPos)) >>  2) & 63L);
      out[14 + outPos] =
          //                           [______10]
          //                                 [65_______________]
            ((((long)in.get(29 + inPos)) <<  15) & 131071L)
        | //                           [76543210]
          //                         [__43210987_______]
            ((((long)in.get(30 + inPos)) <<  7) & 32767L)
        | //                           [7654321_]
          //                 [__________6543210]
            ((((long)in.get(31 + inPos)) >>  1) & 127L);
      out[15 + outPos] =
          //                           [_______0]
          //                                  [6________________]
            ((((long)in.get(31 + inPos)) <<  16) & 131071L)
        | //                           [76543210]
          //                          [_54321098________]
            ((((long)in.get(32 + inPos)) <<  8) & 65535L)
        | //                           [76543210]
          //                  [_________76543210]
            ((((long)in.get(33 + inPos)) ) & 255L);
      out[16 + outPos] =
          //                           [76543210]
          //                           [65432109_________]
            ((((long)in.get(34 + inPos)) <<  9) & 131071L)
        | //                           [76543210]
          //                   [________87654321_]
            ((((long)in.get(35 + inPos)) <<  1) & 511L)
        | //                           [7_______]
          //           [________________0]
            ((((long)in.get(36 + inPos)) >>  7) & 1L);
      out[17 + outPos] =
          //                           [_6543210]
          //                            [6543210__________]
            ((((long)in.get(36 + inPos)) <<  10) & 131071L)
        | //                           [76543210]
          //                    [_______98765432__]
            ((((long)in.get(37 + inPos)) <<  2) & 1023L)
        | //                           [76______]
          //            [_______________10]
            ((((long)in.get(38 + inPos)) >>  6) & 3L);
      out[18 + outPos] =
          //                           [__543210]
          //                             [654321___________]
            ((((long)in.get(38 + inPos)) <<  11) & 131071L)
        | //                           [76543210]
          //                     [______09876543___]
            ((((long)in.get(39 + inPos)) <<  3) & 2047L)
        | //                           [765_____]
          //             [______________210]
            ((((long)in.get(40 + inPos)) >>  5) & 7L);
      out[19 + outPos] =
          //                           [___43210]
          //                              [65432____________]
            ((((long)in.get(40 + inPos)) <<  12) & 131071L)
        | //                           [76543210]
          //                      [_____10987654____]
            ((((long)in.get(41 + inPos)) <<  4) & 4095L)
        | //                           [7654____]
          //              [_____________3210]
            ((((long)in.get(42 + inPos)) >>  4) & 15L);
      out[20 + outPos] =
          //                           [____3210]
          //                               [6543_____________]
            ((((long)in.get(42 + inPos)) <<  13) & 131071L)
        | //                           [76543210]
          //                       [____21098765_____]
            ((((long)in.get(43 + inPos)) <<  5) & 8191L)
        | //                           [76543___]
          //               [____________43210]
            ((((long)in.get(44 + inPos)) >>  3) & 31L);
      out[21 + outPos] =
          //                           [_____210]
          //                                [654______________]
            ((((long)in.get(44 + inPos)) <<  14) & 131071L)
        | //                           [76543210]
          //                        [___32109876______]
            ((((long)in.get(45 + inPos)) <<  6) & 16383L)
        | //                           [765432__]
          //                [___________543210]
            ((((long)in.get(46 + inPos)) >>  2) & 63L);
      out[22 + outPos] =
          //                           [______10]
          //                                 [65_______________]
            ((((long)in.get(46 + inPos)) <<  15) & 131071L)
        | //                           [76543210]
          //                         [__43210987_______]
            ((((long)in.get(47 + inPos)) <<  7) & 32767L)
        | //                           [7654321_]
          //                 [__________6543210]
            ((((long)in.get(48 + inPos)) >>  1) & 127L);
      out[23 + outPos] =
          //                           [_______0]
          //                                  [6________________]
            ((((long)in.get(48 + inPos)) <<  16) & 131071L)
        | //                           [76543210]
          //                          [_54321098________]
            ((((long)in.get(49 + inPos)) <<  8) & 65535L)
        | //                           [76543210]
          //                  [_________76543210]
            ((((long)in.get(50 + inPos)) ) & 255L);
      out[24 + outPos] =
          //                           [76543210]
          //                           [65432109_________]
            ((((long)in.get(51 + inPos)) <<  9) & 131071L)
        | //                           [76543210]
          //                   [________87654321_]
            ((((long)in.get(52 + inPos)) <<  1) & 511L)
        | //                           [7_______]
          //           [________________0]
            ((((long)in.get(53 + inPos)) >>  7) & 1L);
      out[25 + outPos] =
          //                           [_6543210]
          //                            [6543210__________]
            ((((long)in.get(53 + inPos)) <<  10) & 131071L)
        | //                           [76543210]
          //                    [_______98765432__]
            ((((long)in.get(54 + inPos)) <<  2) & 1023L)
        | //                           [76______]
          //            [_______________10]
            ((((long)in.get(55 + inPos)) >>  6) & 3L);
      out[26 + outPos] =
          //                           [__543210]
          //                             [654321___________]
            ((((long)in.get(55 + inPos)) <<  11) & 131071L)
        | //                           [76543210]
          //                     [______09876543___]
            ((((long)in.get(56 + inPos)) <<  3) & 2047L)
        | //                           [765_____]
          //             [______________210]
            ((((long)in.get(57 + inPos)) >>  5) & 7L);
      out[27 + outPos] =
          //                           [___43210]
          //                              [65432____________]
            ((((long)in.get(57 + inPos)) <<  12) & 131071L)
        | //                           [76543210]
          //                      [_____10987654____]
            ((((long)in.get(58 + inPos)) <<  4) & 4095L)
        | //                           [7654____]
          //              [_____________3210]
            ((((long)in.get(59 + inPos)) >>  4) & 15L);
      out[28 + outPos] =
          //                           [____3210]
          //                               [6543_____________]
            ((((long)in.get(59 + inPos)) <<  13) & 131071L)
        | //                           [76543210]
          //                       [____21098765_____]
            ((((long)in.get(60 + inPos)) <<  5) & 8191L)
        | //                           [76543___]
          //               [____________43210]
            ((((long)in.get(61 + inPos)) >>  3) & 31L);
      out[29 + outPos] =
          //                           [_____210]
          //                                [654______________]
            ((((long)in.get(61 + inPos)) <<  14) & 131071L)
        | //                           [76543210]
          //                        [___32109876______]
            ((((long)in.get(62 + inPos)) <<  6) & 16383L)
        | //                           [765432__]
          //                [___________543210]
            ((((long)in.get(63 + inPos)) >>  2) & 63L);
      out[30 + outPos] =
          //                           [______10]
          //                                 [65_______________]
            ((((long)in.get(63 + inPos)) <<  15) & 131071L)
        | //                           [76543210]
          //                         [__43210987_______]
            ((((long)in.get(64 + inPos)) <<  7) & 32767L)
        | //                           [7654321_]
          //                 [__________6543210]
            ((((long)in.get(65 + inPos)) >>  1) & 127L);
      out[31 + outPos] =
          //                           [_______0]
          //                                  [6________________]
            ((((long)in.get(65 + inPos)) <<  16) & 131071L)
        | //                           [76543210]
          //                          [_54321098________]
            ((((long)in.get(66 + inPos)) <<  8) & 65535L)
        | //                           [76543210]
          //                  [_________76543210]
            ((((long)in.get(67 + inPos)) ) & 255L);
    }
  }

  private static final class Packer18 extends BytePackerForLong {

    private Packer18() {
      super(18);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                            [76543210]
          //                            [76543210__________]
           ((in[ 0 + inPos] & 262143L) >>> 10)) & 255);
      out[ 1 + outPos] = (byte)((
          //                            [76543210]
          //                    [________98765432__]
           ((in[ 0 + inPos] & 262143L) >>> 2)) & 255);
      out[ 2 + outPos] = (byte)((
          //                            [76______]
          //            [________________10]
           ((in[ 0 + inPos] & 262143L) <<  6)
        | //                            [__543210]
          //                              [765432____________]
           ((in[ 1 + inPos] & 262143L) >>> 12)) & 255);
      out[ 3 + outPos] = (byte)((
          //                            [76543210]
          //                      [______10987654____]
           ((in[ 1 + inPos] & 262143L) >>> 4)) & 255);
      out[ 4 + outPos] = (byte)((
          //                            [7654____]
          //              [______________3210]
           ((in[ 1 + inPos] & 262143L) <<  4)
        | //                            [____3210]
          //                                [7654______________]
           ((in[ 2 + inPos] & 262143L) >>> 14)) & 255);
      out[ 5 + outPos] = (byte)((
          //                            [76543210]
          //                        [____32109876______]
           ((in[ 2 + inPos] & 262143L) >>> 6)) & 255);
      out[ 6 + outPos] = (byte)((
          //                            [765432__]
          //                [____________543210]
           ((in[ 2 + inPos] & 262143L) <<  2)
        | //                            [______10]
          //                                  [76________________]
           ((in[ 3 + inPos] & 262143L) >>> 16)) & 255);
      out[ 7 + outPos] = (byte)((
          //                            [76543210]
          //                          [__54321098________]
           ((in[ 3 + inPos] & 262143L) >>> 8)) & 255);
      out[ 8 + outPos] = (byte)((
          //                            [76543210]
          //                  [__________76543210]
           ((in[ 3 + inPos] & 262143L))) & 255);
      out[ 9 + outPos] = (byte)((
          //                            [76543210]
          //                            [76543210__________]
           ((in[ 4 + inPos] & 262143L) >>> 10)) & 255);
      out[10 + outPos] = (byte)((
          //                            [76543210]
          //                    [________98765432__]
           ((in[ 4 + inPos] & 262143L) >>> 2)) & 255);
      out[11 + outPos] = (byte)((
          //                            [76______]
          //            [________________10]
           ((in[ 4 + inPos] & 262143L) <<  6)
        | //                            [__543210]
          //                              [765432____________]
           ((in[ 5 + inPos] & 262143L) >>> 12)) & 255);
      out[12 + outPos] = (byte)((
          //                            [76543210]
          //                      [______10987654____]
           ((in[ 5 + inPos] & 262143L) >>> 4)) & 255);
      out[13 + outPos] = (byte)((
          //                            [7654____]
          //              [______________3210]
           ((in[ 5 + inPos] & 262143L) <<  4)
        | //                            [____3210]
          //                                [7654______________]
           ((in[ 6 + inPos] & 262143L) >>> 14)) & 255);
      out[14 + outPos] = (byte)((
          //                            [76543210]
          //                        [____32109876______]
           ((in[ 6 + inPos] & 262143L) >>> 6)) & 255);
      out[15 + outPos] = (byte)((
          //                            [765432__]
          //                [____________543210]
           ((in[ 6 + inPos] & 262143L) <<  2)
        | //                            [______10]
          //                                  [76________________]
           ((in[ 7 + inPos] & 262143L) >>> 16)) & 255);
      out[16 + outPos] = (byte)((
          //                            [76543210]
          //                          [__54321098________]
           ((in[ 7 + inPos] & 262143L) >>> 8)) & 255);
      out[17 + outPos] = (byte)((
          //                            [76543210]
          //                  [__________76543210]
           ((in[ 7 + inPos] & 262143L))) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                            [76543210]
          //                            [76543210__________]
           ((in[ 0 + inPos] & 262143L) >>> 10)) & 255);
      out[ 1 + outPos] = (byte)((
          //                            [76543210]
          //                    [________98765432__]
           ((in[ 0 + inPos] & 262143L) >>> 2)) & 255);
      out[ 2 + outPos] = (byte)((
          //                            [76______]
          //            [________________10]
           ((in[ 0 + inPos] & 262143L) <<  6)
        | //                            [__543210]
          //                              [765432____________]
           ((in[ 1 + inPos] & 262143L) >>> 12)) & 255);
      out[ 3 + outPos] = (byte)((
          //                            [76543210]
          //                      [______10987654____]
           ((in[ 1 + inPos] & 262143L) >>> 4)) & 255);
      out[ 4 + outPos] = (byte)((
          //                            [7654____]
          //              [______________3210]
           ((in[ 1 + inPos] & 262143L) <<  4)
        | //                            [____3210]
          //                                [7654______________]
           ((in[ 2 + inPos] & 262143L) >>> 14)) & 255);
      out[ 5 + outPos] = (byte)((
          //                            [76543210]
          //                        [____32109876______]
           ((in[ 2 + inPos] & 262143L) >>> 6)) & 255);
      out[ 6 + outPos] = (byte)((
          //                            [765432__]
          //                [____________543210]
           ((in[ 2 + inPos] & 262143L) <<  2)
        | //                            [______10]
          //                                  [76________________]
           ((in[ 3 + inPos] & 262143L) >>> 16)) & 255);
      out[ 7 + outPos] = (byte)((
          //                            [76543210]
          //                          [__54321098________]
           ((in[ 3 + inPos] & 262143L) >>> 8)) & 255);
      out[ 8 + outPos] = (byte)((
          //                            [76543210]
          //                  [__________76543210]
           ((in[ 3 + inPos] & 262143L))) & 255);
      out[ 9 + outPos] = (byte)((
          //                            [76543210]
          //                            [76543210__________]
           ((in[ 4 + inPos] & 262143L) >>> 10)) & 255);
      out[10 + outPos] = (byte)((
          //                            [76543210]
          //                    [________98765432__]
           ((in[ 4 + inPos] & 262143L) >>> 2)) & 255);
      out[11 + outPos] = (byte)((
          //                            [76______]
          //            [________________10]
           ((in[ 4 + inPos] & 262143L) <<  6)
        | //                            [__543210]
          //                              [765432____________]
           ((in[ 5 + inPos] & 262143L) >>> 12)) & 255);
      out[12 + outPos] = (byte)((
          //                            [76543210]
          //                      [______10987654____]
           ((in[ 5 + inPos] & 262143L) >>> 4)) & 255);
      out[13 + outPos] = (byte)((
          //                            [7654____]
          //              [______________3210]
           ((in[ 5 + inPos] & 262143L) <<  4)
        | //                            [____3210]
          //                                [7654______________]
           ((in[ 6 + inPos] & 262143L) >>> 14)) & 255);
      out[14 + outPos] = (byte)((
          //                            [76543210]
          //                        [____32109876______]
           ((in[ 6 + inPos] & 262143L) >>> 6)) & 255);
      out[15 + outPos] = (byte)((
          //                            [765432__]
          //                [____________543210]
           ((in[ 6 + inPos] & 262143L) <<  2)
        | //                            [______10]
          //                                  [76________________]
           ((in[ 7 + inPos] & 262143L) >>> 16)) & 255);
      out[16 + outPos] = (byte)((
          //                            [76543210]
          //                          [__54321098________]
           ((in[ 7 + inPos] & 262143L) >>> 8)) & 255);
      out[17 + outPos] = (byte)((
          //                            [76543210]
          //                  [__________76543210]
           ((in[ 7 + inPos] & 262143L))) & 255);
      out[18 + outPos] = (byte)((
          //                            [76543210]
          //                            [76543210__________]
           ((in[ 8 + inPos] & 262143L) >>> 10)) & 255);
      out[19 + outPos] = (byte)((
          //                            [76543210]
          //                    [________98765432__]
           ((in[ 8 + inPos] & 262143L) >>> 2)) & 255);
      out[20 + outPos] = (byte)((
          //                            [76______]
          //            [________________10]
           ((in[ 8 + inPos] & 262143L) <<  6)
        | //                            [__543210]
          //                              [765432____________]
           ((in[ 9 + inPos] & 262143L) >>> 12)) & 255);
      out[21 + outPos] = (byte)((
          //                            [76543210]
          //                      [______10987654____]
           ((in[ 9 + inPos] & 262143L) >>> 4)) & 255);
      out[22 + outPos] = (byte)((
          //                            [7654____]
          //              [______________3210]
           ((in[ 9 + inPos] & 262143L) <<  4)
        | //                            [____3210]
          //                                [7654______________]
           ((in[10 + inPos] & 262143L) >>> 14)) & 255);
      out[23 + outPos] = (byte)((
          //                            [76543210]
          //                        [____32109876______]
           ((in[10 + inPos] & 262143L) >>> 6)) & 255);
      out[24 + outPos] = (byte)((
          //                            [765432__]
          //                [____________543210]
           ((in[10 + inPos] & 262143L) <<  2)
        | //                            [______10]
          //                                  [76________________]
           ((in[11 + inPos] & 262143L) >>> 16)) & 255);
      out[25 + outPos] = (byte)((
          //                            [76543210]
          //                          [__54321098________]
           ((in[11 + inPos] & 262143L) >>> 8)) & 255);
      out[26 + outPos] = (byte)((
          //                            [76543210]
          //                  [__________76543210]
           ((in[11 + inPos] & 262143L))) & 255);
      out[27 + outPos] = (byte)((
          //                            [76543210]
          //                            [76543210__________]
           ((in[12 + inPos] & 262143L) >>> 10)) & 255);
      out[28 + outPos] = (byte)((
          //                            [76543210]
          //                    [________98765432__]
           ((in[12 + inPos] & 262143L) >>> 2)) & 255);
      out[29 + outPos] = (byte)((
          //                            [76______]
          //            [________________10]
           ((in[12 + inPos] & 262143L) <<  6)
        | //                            [__543210]
          //                              [765432____________]
           ((in[13 + inPos] & 262143L) >>> 12)) & 255);
      out[30 + outPos] = (byte)((
          //                            [76543210]
          //                      [______10987654____]
           ((in[13 + inPos] & 262143L) >>> 4)) & 255);
      out[31 + outPos] = (byte)((
          //                            [7654____]
          //              [______________3210]
           ((in[13 + inPos] & 262143L) <<  4)
        | //                            [____3210]
          //                                [7654______________]
           ((in[14 + inPos] & 262143L) >>> 14)) & 255);
      out[32 + outPos] = (byte)((
          //                            [76543210]
          //                        [____32109876______]
           ((in[14 + inPos] & 262143L) >>> 6)) & 255);
      out[33 + outPos] = (byte)((
          //                            [765432__]
          //                [____________543210]
           ((in[14 + inPos] & 262143L) <<  2)
        | //                            [______10]
          //                                  [76________________]
           ((in[15 + inPos] & 262143L) >>> 16)) & 255);
      out[34 + outPos] = (byte)((
          //                            [76543210]
          //                          [__54321098________]
           ((in[15 + inPos] & 262143L) >>> 8)) & 255);
      out[35 + outPos] = (byte)((
          //                            [76543210]
          //                  [__________76543210]
           ((in[15 + inPos] & 262143L))) & 255);
      out[36 + outPos] = (byte)((
          //                            [76543210]
          //                            [76543210__________]
           ((in[16 + inPos] & 262143L) >>> 10)) & 255);
      out[37 + outPos] = (byte)((
          //                            [76543210]
          //                    [________98765432__]
           ((in[16 + inPos] & 262143L) >>> 2)) & 255);
      out[38 + outPos] = (byte)((
          //                            [76______]
          //            [________________10]
           ((in[16 + inPos] & 262143L) <<  6)
        | //                            [__543210]
          //                              [765432____________]
           ((in[17 + inPos] & 262143L) >>> 12)) & 255);
      out[39 + outPos] = (byte)((
          //                            [76543210]
          //                      [______10987654____]
           ((in[17 + inPos] & 262143L) >>> 4)) & 255);
      out[40 + outPos] = (byte)((
          //                            [7654____]
          //              [______________3210]
           ((in[17 + inPos] & 262143L) <<  4)
        | //                            [____3210]
          //                                [7654______________]
           ((in[18 + inPos] & 262143L) >>> 14)) & 255);
      out[41 + outPos] = (byte)((
          //                            [76543210]
          //                        [____32109876______]
           ((in[18 + inPos] & 262143L) >>> 6)) & 255);
      out[42 + outPos] = (byte)((
          //                            [765432__]
          //                [____________543210]
           ((in[18 + inPos] & 262143L) <<  2)
        | //                            [______10]
          //                                  [76________________]
           ((in[19 + inPos] & 262143L) >>> 16)) & 255);
      out[43 + outPos] = (byte)((
          //                            [76543210]
          //                          [__54321098________]
           ((in[19 + inPos] & 262143L) >>> 8)) & 255);
      out[44 + outPos] = (byte)((
          //                            [76543210]
          //                  [__________76543210]
           ((in[19 + inPos] & 262143L))) & 255);
      out[45 + outPos] = (byte)((
          //                            [76543210]
          //                            [76543210__________]
           ((in[20 + inPos] & 262143L) >>> 10)) & 255);
      out[46 + outPos] = (byte)((
          //                            [76543210]
          //                    [________98765432__]
           ((in[20 + inPos] & 262143L) >>> 2)) & 255);
      out[47 + outPos] = (byte)((
          //                            [76______]
          //            [________________10]
           ((in[20 + inPos] & 262143L) <<  6)
        | //                            [__543210]
          //                              [765432____________]
           ((in[21 + inPos] & 262143L) >>> 12)) & 255);
      out[48 + outPos] = (byte)((
          //                            [76543210]
          //                      [______10987654____]
           ((in[21 + inPos] & 262143L) >>> 4)) & 255);
      out[49 + outPos] = (byte)((
          //                            [7654____]
          //              [______________3210]
           ((in[21 + inPos] & 262143L) <<  4)
        | //                            [____3210]
          //                                [7654______________]
           ((in[22 + inPos] & 262143L) >>> 14)) & 255);
      out[50 + outPos] = (byte)((
          //                            [76543210]
          //                        [____32109876______]
           ((in[22 + inPos] & 262143L) >>> 6)) & 255);
      out[51 + outPos] = (byte)((
          //                            [765432__]
          //                [____________543210]
           ((in[22 + inPos] & 262143L) <<  2)
        | //                            [______10]
          //                                  [76________________]
           ((in[23 + inPos] & 262143L) >>> 16)) & 255);
      out[52 + outPos] = (byte)((
          //                            [76543210]
          //                          [__54321098________]
           ((in[23 + inPos] & 262143L) >>> 8)) & 255);
      out[53 + outPos] = (byte)((
          //                            [76543210]
          //                  [__________76543210]
           ((in[23 + inPos] & 262143L))) & 255);
      out[54 + outPos] = (byte)((
          //                            [76543210]
          //                            [76543210__________]
           ((in[24 + inPos] & 262143L) >>> 10)) & 255);
      out[55 + outPos] = (byte)((
          //                            [76543210]
          //                    [________98765432__]
           ((in[24 + inPos] & 262143L) >>> 2)) & 255);
      out[56 + outPos] = (byte)((
          //                            [76______]
          //            [________________10]
           ((in[24 + inPos] & 262143L) <<  6)
        | //                            [__543210]
          //                              [765432____________]
           ((in[25 + inPos] & 262143L) >>> 12)) & 255);
      out[57 + outPos] = (byte)((
          //                            [76543210]
          //                      [______10987654____]
           ((in[25 + inPos] & 262143L) >>> 4)) & 255);
      out[58 + outPos] = (byte)((
          //                            [7654____]
          //              [______________3210]
           ((in[25 + inPos] & 262143L) <<  4)
        | //                            [____3210]
          //                                [7654______________]
           ((in[26 + inPos] & 262143L) >>> 14)) & 255);
      out[59 + outPos] = (byte)((
          //                            [76543210]
          //                        [____32109876______]
           ((in[26 + inPos] & 262143L) >>> 6)) & 255);
      out[60 + outPos] = (byte)((
          //                            [765432__]
          //                [____________543210]
           ((in[26 + inPos] & 262143L) <<  2)
        | //                            [______10]
          //                                  [76________________]
           ((in[27 + inPos] & 262143L) >>> 16)) & 255);
      out[61 + outPos] = (byte)((
          //                            [76543210]
          //                          [__54321098________]
           ((in[27 + inPos] & 262143L) >>> 8)) & 255);
      out[62 + outPos] = (byte)((
          //                            [76543210]
          //                  [__________76543210]
           ((in[27 + inPos] & 262143L))) & 255);
      out[63 + outPos] = (byte)((
          //                            [76543210]
          //                            [76543210__________]
           ((in[28 + inPos] & 262143L) >>> 10)) & 255);
      out[64 + outPos] = (byte)((
          //                            [76543210]
          //                    [________98765432__]
           ((in[28 + inPos] & 262143L) >>> 2)) & 255);
      out[65 + outPos] = (byte)((
          //                            [76______]
          //            [________________10]
           ((in[28 + inPos] & 262143L) <<  6)
        | //                            [__543210]
          //                              [765432____________]
           ((in[29 + inPos] & 262143L) >>> 12)) & 255);
      out[66 + outPos] = (byte)((
          //                            [76543210]
          //                      [______10987654____]
           ((in[29 + inPos] & 262143L) >>> 4)) & 255);
      out[67 + outPos] = (byte)((
          //                            [7654____]
          //              [______________3210]
           ((in[29 + inPos] & 262143L) <<  4)
        | //                            [____3210]
          //                                [7654______________]
           ((in[30 + inPos] & 262143L) >>> 14)) & 255);
      out[68 + outPos] = (byte)((
          //                            [76543210]
          //                        [____32109876______]
           ((in[30 + inPos] & 262143L) >>> 6)) & 255);
      out[69 + outPos] = (byte)((
          //                            [765432__]
          //                [____________543210]
           ((in[30 + inPos] & 262143L) <<  2)
        | //                            [______10]
          //                                  [76________________]
           ((in[31 + inPos] & 262143L) >>> 16)) & 255);
      out[70 + outPos] = (byte)((
          //                            [76543210]
          //                          [__54321098________]
           ((in[31 + inPos] & 262143L) >>> 8)) & 255);
      out[71 + outPos] = (byte)((
          //                            [76543210]
          //                  [__________76543210]
           ((in[31 + inPos] & 262143L))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                            [76543210]
          //                            [76543210__________]
            ((((long)in[ 0 + inPos]) <<  10) & 262143L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in[ 1 + inPos]) <<  2) & 1023L)
        | //                            [76______]
          //            [________________10]
            ((((long)in[ 2 + inPos]) >>  6) & 3L);
      out[ 1 + outPos] =
          //                            [__543210]
          //                              [765432____________]
            ((((long)in[ 2 + inPos]) <<  12) & 262143L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in[ 3 + inPos]) <<  4) & 4095L)
        | //                            [7654____]
          //              [______________3210]
            ((((long)in[ 4 + inPos]) >>  4) & 15L);
      out[ 2 + outPos] =
          //                            [____3210]
          //                                [7654______________]
            ((((long)in[ 4 + inPos]) <<  14) & 262143L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in[ 5 + inPos]) <<  6) & 16383L)
        | //                            [765432__]
          //                [____________543210]
            ((((long)in[ 6 + inPos]) >>  2) & 63L);
      out[ 3 + outPos] =
          //                            [______10]
          //                                  [76________________]
            ((((long)in[ 6 + inPos]) <<  16) & 262143L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in[ 7 + inPos]) <<  8) & 65535L)
        | //                            [76543210]
          //                  [__________76543210]
            ((((long)in[ 8 + inPos]) ) & 255L);
      out[ 4 + outPos] =
          //                            [76543210]
          //                            [76543210__________]
            ((((long)in[ 9 + inPos]) <<  10) & 262143L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in[10 + inPos]) <<  2) & 1023L)
        | //                            [76______]
          //            [________________10]
            ((((long)in[11 + inPos]) >>  6) & 3L);
      out[ 5 + outPos] =
          //                            [__543210]
          //                              [765432____________]
            ((((long)in[11 + inPos]) <<  12) & 262143L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in[12 + inPos]) <<  4) & 4095L)
        | //                            [7654____]
          //              [______________3210]
            ((((long)in[13 + inPos]) >>  4) & 15L);
      out[ 6 + outPos] =
          //                            [____3210]
          //                                [7654______________]
            ((((long)in[13 + inPos]) <<  14) & 262143L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in[14 + inPos]) <<  6) & 16383L)
        | //                            [765432__]
          //                [____________543210]
            ((((long)in[15 + inPos]) >>  2) & 63L);
      out[ 7 + outPos] =
          //                            [______10]
          //                                  [76________________]
            ((((long)in[15 + inPos]) <<  16) & 262143L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in[16 + inPos]) <<  8) & 65535L)
        | //                            [76543210]
          //                  [__________76543210]
            ((((long)in[17 + inPos]) ) & 255L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                            [76543210]
          //                            [76543210__________]
            ((((long)in.get( 0 + inPos)) <<  10) & 262143L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in.get( 1 + inPos)) <<  2) & 1023L)
        | //                            [76______]
          //            [________________10]
            ((((long)in.get( 2 + inPos)) >>  6) & 3L);
      out[ 1 + outPos] =
          //                            [__543210]
          //                              [765432____________]
            ((((long)in.get( 2 + inPos)) <<  12) & 262143L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in.get( 3 + inPos)) <<  4) & 4095L)
        | //                            [7654____]
          //              [______________3210]
            ((((long)in.get( 4 + inPos)) >>  4) & 15L);
      out[ 2 + outPos] =
          //                            [____3210]
          //                                [7654______________]
            ((((long)in.get( 4 + inPos)) <<  14) & 262143L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in.get( 5 + inPos)) <<  6) & 16383L)
        | //                            [765432__]
          //                [____________543210]
            ((((long)in.get( 6 + inPos)) >>  2) & 63L);
      out[ 3 + outPos] =
          //                            [______10]
          //                                  [76________________]
            ((((long)in.get( 6 + inPos)) <<  16) & 262143L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in.get( 7 + inPos)) <<  8) & 65535L)
        | //                            [76543210]
          //                  [__________76543210]
            ((((long)in.get( 8 + inPos)) ) & 255L);
      out[ 4 + outPos] =
          //                            [76543210]
          //                            [76543210__________]
            ((((long)in.get( 9 + inPos)) <<  10) & 262143L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in.get(10 + inPos)) <<  2) & 1023L)
        | //                            [76______]
          //            [________________10]
            ((((long)in.get(11 + inPos)) >>  6) & 3L);
      out[ 5 + outPos] =
          //                            [__543210]
          //                              [765432____________]
            ((((long)in.get(11 + inPos)) <<  12) & 262143L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in.get(12 + inPos)) <<  4) & 4095L)
        | //                            [7654____]
          //              [______________3210]
            ((((long)in.get(13 + inPos)) >>  4) & 15L);
      out[ 6 + outPos] =
          //                            [____3210]
          //                                [7654______________]
            ((((long)in.get(13 + inPos)) <<  14) & 262143L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in.get(14 + inPos)) <<  6) & 16383L)
        | //                            [765432__]
          //                [____________543210]
            ((((long)in.get(15 + inPos)) >>  2) & 63L);
      out[ 7 + outPos] =
          //                            [______10]
          //                                  [76________________]
            ((((long)in.get(15 + inPos)) <<  16) & 262143L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in.get(16 + inPos)) <<  8) & 65535L)
        | //                            [76543210]
          //                  [__________76543210]
            ((((long)in.get(17 + inPos)) ) & 255L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                            [76543210]
          //                            [76543210__________]
            ((((long)in[ 0 + inPos]) <<  10) & 262143L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in[ 1 + inPos]) <<  2) & 1023L)
        | //                            [76______]
          //            [________________10]
            ((((long)in[ 2 + inPos]) >>  6) & 3L);
      out[ 1 + outPos] =
          //                            [__543210]
          //                              [765432____________]
            ((((long)in[ 2 + inPos]) <<  12) & 262143L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in[ 3 + inPos]) <<  4) & 4095L)
        | //                            [7654____]
          //              [______________3210]
            ((((long)in[ 4 + inPos]) >>  4) & 15L);
      out[ 2 + outPos] =
          //                            [____3210]
          //                                [7654______________]
            ((((long)in[ 4 + inPos]) <<  14) & 262143L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in[ 5 + inPos]) <<  6) & 16383L)
        | //                            [765432__]
          //                [____________543210]
            ((((long)in[ 6 + inPos]) >>  2) & 63L);
      out[ 3 + outPos] =
          //                            [______10]
          //                                  [76________________]
            ((((long)in[ 6 + inPos]) <<  16) & 262143L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in[ 7 + inPos]) <<  8) & 65535L)
        | //                            [76543210]
          //                  [__________76543210]
            ((((long)in[ 8 + inPos]) ) & 255L);
      out[ 4 + outPos] =
          //                            [76543210]
          //                            [76543210__________]
            ((((long)in[ 9 + inPos]) <<  10) & 262143L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in[10 + inPos]) <<  2) & 1023L)
        | //                            [76______]
          //            [________________10]
            ((((long)in[11 + inPos]) >>  6) & 3L);
      out[ 5 + outPos] =
          //                            [__543210]
          //                              [765432____________]
            ((((long)in[11 + inPos]) <<  12) & 262143L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in[12 + inPos]) <<  4) & 4095L)
        | //                            [7654____]
          //              [______________3210]
            ((((long)in[13 + inPos]) >>  4) & 15L);
      out[ 6 + outPos] =
          //                            [____3210]
          //                                [7654______________]
            ((((long)in[13 + inPos]) <<  14) & 262143L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in[14 + inPos]) <<  6) & 16383L)
        | //                            [765432__]
          //                [____________543210]
            ((((long)in[15 + inPos]) >>  2) & 63L);
      out[ 7 + outPos] =
          //                            [______10]
          //                                  [76________________]
            ((((long)in[15 + inPos]) <<  16) & 262143L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in[16 + inPos]) <<  8) & 65535L)
        | //                            [76543210]
          //                  [__________76543210]
            ((((long)in[17 + inPos]) ) & 255L);
      out[ 8 + outPos] =
          //                            [76543210]
          //                            [76543210__________]
            ((((long)in[18 + inPos]) <<  10) & 262143L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in[19 + inPos]) <<  2) & 1023L)
        | //                            [76______]
          //            [________________10]
            ((((long)in[20 + inPos]) >>  6) & 3L);
      out[ 9 + outPos] =
          //                            [__543210]
          //                              [765432____________]
            ((((long)in[20 + inPos]) <<  12) & 262143L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in[21 + inPos]) <<  4) & 4095L)
        | //                            [7654____]
          //              [______________3210]
            ((((long)in[22 + inPos]) >>  4) & 15L);
      out[10 + outPos] =
          //                            [____3210]
          //                                [7654______________]
            ((((long)in[22 + inPos]) <<  14) & 262143L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in[23 + inPos]) <<  6) & 16383L)
        | //                            [765432__]
          //                [____________543210]
            ((((long)in[24 + inPos]) >>  2) & 63L);
      out[11 + outPos] =
          //                            [______10]
          //                                  [76________________]
            ((((long)in[24 + inPos]) <<  16) & 262143L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in[25 + inPos]) <<  8) & 65535L)
        | //                            [76543210]
          //                  [__________76543210]
            ((((long)in[26 + inPos]) ) & 255L);
      out[12 + outPos] =
          //                            [76543210]
          //                            [76543210__________]
            ((((long)in[27 + inPos]) <<  10) & 262143L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in[28 + inPos]) <<  2) & 1023L)
        | //                            [76______]
          //            [________________10]
            ((((long)in[29 + inPos]) >>  6) & 3L);
      out[13 + outPos] =
          //                            [__543210]
          //                              [765432____________]
            ((((long)in[29 + inPos]) <<  12) & 262143L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in[30 + inPos]) <<  4) & 4095L)
        | //                            [7654____]
          //              [______________3210]
            ((((long)in[31 + inPos]) >>  4) & 15L);
      out[14 + outPos] =
          //                            [____3210]
          //                                [7654______________]
            ((((long)in[31 + inPos]) <<  14) & 262143L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in[32 + inPos]) <<  6) & 16383L)
        | //                            [765432__]
          //                [____________543210]
            ((((long)in[33 + inPos]) >>  2) & 63L);
      out[15 + outPos] =
          //                            [______10]
          //                                  [76________________]
            ((((long)in[33 + inPos]) <<  16) & 262143L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in[34 + inPos]) <<  8) & 65535L)
        | //                            [76543210]
          //                  [__________76543210]
            ((((long)in[35 + inPos]) ) & 255L);
      out[16 + outPos] =
          //                            [76543210]
          //                            [76543210__________]
            ((((long)in[36 + inPos]) <<  10) & 262143L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in[37 + inPos]) <<  2) & 1023L)
        | //                            [76______]
          //            [________________10]
            ((((long)in[38 + inPos]) >>  6) & 3L);
      out[17 + outPos] =
          //                            [__543210]
          //                              [765432____________]
            ((((long)in[38 + inPos]) <<  12) & 262143L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in[39 + inPos]) <<  4) & 4095L)
        | //                            [7654____]
          //              [______________3210]
            ((((long)in[40 + inPos]) >>  4) & 15L);
      out[18 + outPos] =
          //                            [____3210]
          //                                [7654______________]
            ((((long)in[40 + inPos]) <<  14) & 262143L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in[41 + inPos]) <<  6) & 16383L)
        | //                            [765432__]
          //                [____________543210]
            ((((long)in[42 + inPos]) >>  2) & 63L);
      out[19 + outPos] =
          //                            [______10]
          //                                  [76________________]
            ((((long)in[42 + inPos]) <<  16) & 262143L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in[43 + inPos]) <<  8) & 65535L)
        | //                            [76543210]
          //                  [__________76543210]
            ((((long)in[44 + inPos]) ) & 255L);
      out[20 + outPos] =
          //                            [76543210]
          //                            [76543210__________]
            ((((long)in[45 + inPos]) <<  10) & 262143L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in[46 + inPos]) <<  2) & 1023L)
        | //                            [76______]
          //            [________________10]
            ((((long)in[47 + inPos]) >>  6) & 3L);
      out[21 + outPos] =
          //                            [__543210]
          //                              [765432____________]
            ((((long)in[47 + inPos]) <<  12) & 262143L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in[48 + inPos]) <<  4) & 4095L)
        | //                            [7654____]
          //              [______________3210]
            ((((long)in[49 + inPos]) >>  4) & 15L);
      out[22 + outPos] =
          //                            [____3210]
          //                                [7654______________]
            ((((long)in[49 + inPos]) <<  14) & 262143L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in[50 + inPos]) <<  6) & 16383L)
        | //                            [765432__]
          //                [____________543210]
            ((((long)in[51 + inPos]) >>  2) & 63L);
      out[23 + outPos] =
          //                            [______10]
          //                                  [76________________]
            ((((long)in[51 + inPos]) <<  16) & 262143L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in[52 + inPos]) <<  8) & 65535L)
        | //                            [76543210]
          //                  [__________76543210]
            ((((long)in[53 + inPos]) ) & 255L);
      out[24 + outPos] =
          //                            [76543210]
          //                            [76543210__________]
            ((((long)in[54 + inPos]) <<  10) & 262143L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in[55 + inPos]) <<  2) & 1023L)
        | //                            [76______]
          //            [________________10]
            ((((long)in[56 + inPos]) >>  6) & 3L);
      out[25 + outPos] =
          //                            [__543210]
          //                              [765432____________]
            ((((long)in[56 + inPos]) <<  12) & 262143L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in[57 + inPos]) <<  4) & 4095L)
        | //                            [7654____]
          //              [______________3210]
            ((((long)in[58 + inPos]) >>  4) & 15L);
      out[26 + outPos] =
          //                            [____3210]
          //                                [7654______________]
            ((((long)in[58 + inPos]) <<  14) & 262143L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in[59 + inPos]) <<  6) & 16383L)
        | //                            [765432__]
          //                [____________543210]
            ((((long)in[60 + inPos]) >>  2) & 63L);
      out[27 + outPos] =
          //                            [______10]
          //                                  [76________________]
            ((((long)in[60 + inPos]) <<  16) & 262143L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in[61 + inPos]) <<  8) & 65535L)
        | //                            [76543210]
          //                  [__________76543210]
            ((((long)in[62 + inPos]) ) & 255L);
      out[28 + outPos] =
          //                            [76543210]
          //                            [76543210__________]
            ((((long)in[63 + inPos]) <<  10) & 262143L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in[64 + inPos]) <<  2) & 1023L)
        | //                            [76______]
          //            [________________10]
            ((((long)in[65 + inPos]) >>  6) & 3L);
      out[29 + outPos] =
          //                            [__543210]
          //                              [765432____________]
            ((((long)in[65 + inPos]) <<  12) & 262143L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in[66 + inPos]) <<  4) & 4095L)
        | //                            [7654____]
          //              [______________3210]
            ((((long)in[67 + inPos]) >>  4) & 15L);
      out[30 + outPos] =
          //                            [____3210]
          //                                [7654______________]
            ((((long)in[67 + inPos]) <<  14) & 262143L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in[68 + inPos]) <<  6) & 16383L)
        | //                            [765432__]
          //                [____________543210]
            ((((long)in[69 + inPos]) >>  2) & 63L);
      out[31 + outPos] =
          //                            [______10]
          //                                  [76________________]
            ((((long)in[69 + inPos]) <<  16) & 262143L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in[70 + inPos]) <<  8) & 65535L)
        | //                            [76543210]
          //                  [__________76543210]
            ((((long)in[71 + inPos]) ) & 255L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                            [76543210]
          //                            [76543210__________]
            ((((long)in.get( 0 + inPos)) <<  10) & 262143L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in.get( 1 + inPos)) <<  2) & 1023L)
        | //                            [76______]
          //            [________________10]
            ((((long)in.get( 2 + inPos)) >>  6) & 3L);
      out[ 1 + outPos] =
          //                            [__543210]
          //                              [765432____________]
            ((((long)in.get( 2 + inPos)) <<  12) & 262143L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in.get( 3 + inPos)) <<  4) & 4095L)
        | //                            [7654____]
          //              [______________3210]
            ((((long)in.get( 4 + inPos)) >>  4) & 15L);
      out[ 2 + outPos] =
          //                            [____3210]
          //                                [7654______________]
            ((((long)in.get( 4 + inPos)) <<  14) & 262143L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in.get( 5 + inPos)) <<  6) & 16383L)
        | //                            [765432__]
          //                [____________543210]
            ((((long)in.get( 6 + inPos)) >>  2) & 63L);
      out[ 3 + outPos] =
          //                            [______10]
          //                                  [76________________]
            ((((long)in.get( 6 + inPos)) <<  16) & 262143L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in.get( 7 + inPos)) <<  8) & 65535L)
        | //                            [76543210]
          //                  [__________76543210]
            ((((long)in.get( 8 + inPos)) ) & 255L);
      out[ 4 + outPos] =
          //                            [76543210]
          //                            [76543210__________]
            ((((long)in.get( 9 + inPos)) <<  10) & 262143L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in.get(10 + inPos)) <<  2) & 1023L)
        | //                            [76______]
          //            [________________10]
            ((((long)in.get(11 + inPos)) >>  6) & 3L);
      out[ 5 + outPos] =
          //                            [__543210]
          //                              [765432____________]
            ((((long)in.get(11 + inPos)) <<  12) & 262143L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in.get(12 + inPos)) <<  4) & 4095L)
        | //                            [7654____]
          //              [______________3210]
            ((((long)in.get(13 + inPos)) >>  4) & 15L);
      out[ 6 + outPos] =
          //                            [____3210]
          //                                [7654______________]
            ((((long)in.get(13 + inPos)) <<  14) & 262143L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in.get(14 + inPos)) <<  6) & 16383L)
        | //                            [765432__]
          //                [____________543210]
            ((((long)in.get(15 + inPos)) >>  2) & 63L);
      out[ 7 + outPos] =
          //                            [______10]
          //                                  [76________________]
            ((((long)in.get(15 + inPos)) <<  16) & 262143L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in.get(16 + inPos)) <<  8) & 65535L)
        | //                            [76543210]
          //                  [__________76543210]
            ((((long)in.get(17 + inPos)) ) & 255L);
      out[ 8 + outPos] =
          //                            [76543210]
          //                            [76543210__________]
            ((((long)in.get(18 + inPos)) <<  10) & 262143L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in.get(19 + inPos)) <<  2) & 1023L)
        | //                            [76______]
          //            [________________10]
            ((((long)in.get(20 + inPos)) >>  6) & 3L);
      out[ 9 + outPos] =
          //                            [__543210]
          //                              [765432____________]
            ((((long)in.get(20 + inPos)) <<  12) & 262143L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in.get(21 + inPos)) <<  4) & 4095L)
        | //                            [7654____]
          //              [______________3210]
            ((((long)in.get(22 + inPos)) >>  4) & 15L);
      out[10 + outPos] =
          //                            [____3210]
          //                                [7654______________]
            ((((long)in.get(22 + inPos)) <<  14) & 262143L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in.get(23 + inPos)) <<  6) & 16383L)
        | //                            [765432__]
          //                [____________543210]
            ((((long)in.get(24 + inPos)) >>  2) & 63L);
      out[11 + outPos] =
          //                            [______10]
          //                                  [76________________]
            ((((long)in.get(24 + inPos)) <<  16) & 262143L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in.get(25 + inPos)) <<  8) & 65535L)
        | //                            [76543210]
          //                  [__________76543210]
            ((((long)in.get(26 + inPos)) ) & 255L);
      out[12 + outPos] =
          //                            [76543210]
          //                            [76543210__________]
            ((((long)in.get(27 + inPos)) <<  10) & 262143L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in.get(28 + inPos)) <<  2) & 1023L)
        | //                            [76______]
          //            [________________10]
            ((((long)in.get(29 + inPos)) >>  6) & 3L);
      out[13 + outPos] =
          //                            [__543210]
          //                              [765432____________]
            ((((long)in.get(29 + inPos)) <<  12) & 262143L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in.get(30 + inPos)) <<  4) & 4095L)
        | //                            [7654____]
          //              [______________3210]
            ((((long)in.get(31 + inPos)) >>  4) & 15L);
      out[14 + outPos] =
          //                            [____3210]
          //                                [7654______________]
            ((((long)in.get(31 + inPos)) <<  14) & 262143L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in.get(32 + inPos)) <<  6) & 16383L)
        | //                            [765432__]
          //                [____________543210]
            ((((long)in.get(33 + inPos)) >>  2) & 63L);
      out[15 + outPos] =
          //                            [______10]
          //                                  [76________________]
            ((((long)in.get(33 + inPos)) <<  16) & 262143L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in.get(34 + inPos)) <<  8) & 65535L)
        | //                            [76543210]
          //                  [__________76543210]
            ((((long)in.get(35 + inPos)) ) & 255L);
      out[16 + outPos] =
          //                            [76543210]
          //                            [76543210__________]
            ((((long)in.get(36 + inPos)) <<  10) & 262143L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in.get(37 + inPos)) <<  2) & 1023L)
        | //                            [76______]
          //            [________________10]
            ((((long)in.get(38 + inPos)) >>  6) & 3L);
      out[17 + outPos] =
          //                            [__543210]
          //                              [765432____________]
            ((((long)in.get(38 + inPos)) <<  12) & 262143L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in.get(39 + inPos)) <<  4) & 4095L)
        | //                            [7654____]
          //              [______________3210]
            ((((long)in.get(40 + inPos)) >>  4) & 15L);
      out[18 + outPos] =
          //                            [____3210]
          //                                [7654______________]
            ((((long)in.get(40 + inPos)) <<  14) & 262143L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in.get(41 + inPos)) <<  6) & 16383L)
        | //                            [765432__]
          //                [____________543210]
            ((((long)in.get(42 + inPos)) >>  2) & 63L);
      out[19 + outPos] =
          //                            [______10]
          //                                  [76________________]
            ((((long)in.get(42 + inPos)) <<  16) & 262143L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in.get(43 + inPos)) <<  8) & 65535L)
        | //                            [76543210]
          //                  [__________76543210]
            ((((long)in.get(44 + inPos)) ) & 255L);
      out[20 + outPos] =
          //                            [76543210]
          //                            [76543210__________]
            ((((long)in.get(45 + inPos)) <<  10) & 262143L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in.get(46 + inPos)) <<  2) & 1023L)
        | //                            [76______]
          //            [________________10]
            ((((long)in.get(47 + inPos)) >>  6) & 3L);
      out[21 + outPos] =
          //                            [__543210]
          //                              [765432____________]
            ((((long)in.get(47 + inPos)) <<  12) & 262143L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in.get(48 + inPos)) <<  4) & 4095L)
        | //                            [7654____]
          //              [______________3210]
            ((((long)in.get(49 + inPos)) >>  4) & 15L);
      out[22 + outPos] =
          //                            [____3210]
          //                                [7654______________]
            ((((long)in.get(49 + inPos)) <<  14) & 262143L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in.get(50 + inPos)) <<  6) & 16383L)
        | //                            [765432__]
          //                [____________543210]
            ((((long)in.get(51 + inPos)) >>  2) & 63L);
      out[23 + outPos] =
          //                            [______10]
          //                                  [76________________]
            ((((long)in.get(51 + inPos)) <<  16) & 262143L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in.get(52 + inPos)) <<  8) & 65535L)
        | //                            [76543210]
          //                  [__________76543210]
            ((((long)in.get(53 + inPos)) ) & 255L);
      out[24 + outPos] =
          //                            [76543210]
          //                            [76543210__________]
            ((((long)in.get(54 + inPos)) <<  10) & 262143L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in.get(55 + inPos)) <<  2) & 1023L)
        | //                            [76______]
          //            [________________10]
            ((((long)in.get(56 + inPos)) >>  6) & 3L);
      out[25 + outPos] =
          //                            [__543210]
          //                              [765432____________]
            ((((long)in.get(56 + inPos)) <<  12) & 262143L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in.get(57 + inPos)) <<  4) & 4095L)
        | //                            [7654____]
          //              [______________3210]
            ((((long)in.get(58 + inPos)) >>  4) & 15L);
      out[26 + outPos] =
          //                            [____3210]
          //                                [7654______________]
            ((((long)in.get(58 + inPos)) <<  14) & 262143L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in.get(59 + inPos)) <<  6) & 16383L)
        | //                            [765432__]
          //                [____________543210]
            ((((long)in.get(60 + inPos)) >>  2) & 63L);
      out[27 + outPos] =
          //                            [______10]
          //                                  [76________________]
            ((((long)in.get(60 + inPos)) <<  16) & 262143L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in.get(61 + inPos)) <<  8) & 65535L)
        | //                            [76543210]
          //                  [__________76543210]
            ((((long)in.get(62 + inPos)) ) & 255L);
      out[28 + outPos] =
          //                            [76543210]
          //                            [76543210__________]
            ((((long)in.get(63 + inPos)) <<  10) & 262143L)
        | //                            [76543210]
          //                    [________98765432__]
            ((((long)in.get(64 + inPos)) <<  2) & 1023L)
        | //                            [76______]
          //            [________________10]
            ((((long)in.get(65 + inPos)) >>  6) & 3L);
      out[29 + outPos] =
          //                            [__543210]
          //                              [765432____________]
            ((((long)in.get(65 + inPos)) <<  12) & 262143L)
        | //                            [76543210]
          //                      [______10987654____]
            ((((long)in.get(66 + inPos)) <<  4) & 4095L)
        | //                            [7654____]
          //              [______________3210]
            ((((long)in.get(67 + inPos)) >>  4) & 15L);
      out[30 + outPos] =
          //                            [____3210]
          //                                [7654______________]
            ((((long)in.get(67 + inPos)) <<  14) & 262143L)
        | //                            [76543210]
          //                        [____32109876______]
            ((((long)in.get(68 + inPos)) <<  6) & 16383L)
        | //                            [765432__]
          //                [____________543210]
            ((((long)in.get(69 + inPos)) >>  2) & 63L);
      out[31 + outPos] =
          //                            [______10]
          //                                  [76________________]
            ((((long)in.get(69 + inPos)) <<  16) & 262143L)
        | //                            [76543210]
          //                          [__54321098________]
            ((((long)in.get(70 + inPos)) <<  8) & 65535L)
        | //                            [76543210]
          //                  [__________76543210]
            ((((long)in.get(71 + inPos)) ) & 255L);
    }
  }

  private static final class Packer19 extends BytePackerForLong {

    private Packer19() {
      super(19);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                             [76543210]
          //                             [87654321___________]
           ((in[ 0 + inPos] & 524287L) >>> 11)) & 255);
      out[ 1 + outPos] = (byte)((
          //                             [76543210]
          //                     [________09876543___]
           ((in[ 0 + inPos] & 524287L) >>> 3)) & 255);
      out[ 2 + outPos] = (byte)((
          //                             [765_____]
          //             [________________210]
           ((in[ 0 + inPos] & 524287L) <<  5)
        | //                             [___43210]
          //                                [87654______________]
           ((in[ 1 + inPos] & 524287L) >>> 14)) & 255);
      out[ 3 + outPos] = (byte)((
          //                             [76543210]
          //                        [_____32109876______]
           ((in[ 1 + inPos] & 524287L) >>> 6)) & 255);
      out[ 4 + outPos] = (byte)((
          //                             [765432__]
          //                [_____________543210]
           ((in[ 1 + inPos] & 524287L) <<  2)
        | //                             [______10]
          //                                   [87_________________]
           ((in[ 2 + inPos] & 524287L) >>> 17)) & 255);
      out[ 5 + outPos] = (byte)((
          //                             [76543210]
          //                           [__65432109_________]
           ((in[ 2 + inPos] & 524287L) >>> 9)) & 255);
      out[ 6 + outPos] = (byte)((
          //                             [76543210]
          //                   [__________87654321_]
           ((in[ 2 + inPos] & 524287L) >>> 1)) & 255);
      out[ 7 + outPos] = (byte)((
          //                             [7_______]
          //           [__________________0]
           ((in[ 2 + inPos] & 524287L) <<  7)
        | //                             [_6543210]
          //                              [8765432____________]
           ((in[ 3 + inPos] & 524287L) >>> 12)) & 255);
      out[ 8 + outPos] = (byte)((
          //                             [76543210]
          //                      [_______10987654____]
           ((in[ 3 + inPos] & 524287L) >>> 4)) & 255);
      out[ 9 + outPos] = (byte)((
          //                             [7654____]
          //              [_______________3210]
           ((in[ 3 + inPos] & 524287L) <<  4)
        | //                             [____3210]
          //                                 [8765_______________]
           ((in[ 4 + inPos] & 524287L) >>> 15)) & 255);
      out[10 + outPos] = (byte)((
          //                             [76543210]
          //                         [____43210987_______]
           ((in[ 4 + inPos] & 524287L) >>> 7)) & 255);
      out[11 + outPos] = (byte)((
          //                             [7654321_]
          //                 [____________6543210]
           ((in[ 4 + inPos] & 524287L) <<  1)
        | //                             [_______0]
          //                                    [8__________________]
           ((in[ 5 + inPos] & 524287L) >>> 18)) & 255);
      out[12 + outPos] = (byte)((
          //                             [76543210]
          //                            [_76543210__________]
           ((in[ 5 + inPos] & 524287L) >>> 10)) & 255);
      out[13 + outPos] = (byte)((
          //                             [76543210]
          //                    [_________98765432__]
           ((in[ 5 + inPos] & 524287L) >>> 2)) & 255);
      out[14 + outPos] = (byte)((
          //                             [76______]
          //            [_________________10]
           ((in[ 5 + inPos] & 524287L) <<  6)
        | //                             [__543210]
          //                               [876543_____________]
           ((in[ 6 + inPos] & 524287L) >>> 13)) & 255);
      out[15 + outPos] = (byte)((
          //                             [76543210]
          //                       [______21098765_____]
           ((in[ 6 + inPos] & 524287L) >>> 5)) & 255);
      out[16 + outPos] = (byte)((
          //                             [76543___]
          //               [______________43210]
           ((in[ 6 + inPos] & 524287L) <<  3)
        | //                             [_____210]
          //                                  [876________________]
           ((in[ 7 + inPos] & 524287L) >>> 16)) & 255);
      out[17 + outPos] = (byte)((
          //                             [76543210]
          //                          [___54321098________]
           ((in[ 7 + inPos] & 524287L) >>> 8)) & 255);
      out[18 + outPos] = (byte)((
          //                             [76543210]
          //                  [___________76543210]
           ((in[ 7 + inPos] & 524287L))) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                             [76543210]
          //                             [87654321___________]
           ((in[ 0 + inPos] & 524287L) >>> 11)) & 255);
      out[ 1 + outPos] = (byte)((
          //                             [76543210]
          //                     [________09876543___]
           ((in[ 0 + inPos] & 524287L) >>> 3)) & 255);
      out[ 2 + outPos] = (byte)((
          //                             [765_____]
          //             [________________210]
           ((in[ 0 + inPos] & 524287L) <<  5)
        | //                             [___43210]
          //                                [87654______________]
           ((in[ 1 + inPos] & 524287L) >>> 14)) & 255);
      out[ 3 + outPos] = (byte)((
          //                             [76543210]
          //                        [_____32109876______]
           ((in[ 1 + inPos] & 524287L) >>> 6)) & 255);
      out[ 4 + outPos] = (byte)((
          //                             [765432__]
          //                [_____________543210]
           ((in[ 1 + inPos] & 524287L) <<  2)
        | //                             [______10]
          //                                   [87_________________]
           ((in[ 2 + inPos] & 524287L) >>> 17)) & 255);
      out[ 5 + outPos] = (byte)((
          //                             [76543210]
          //                           [__65432109_________]
           ((in[ 2 + inPos] & 524287L) >>> 9)) & 255);
      out[ 6 + outPos] = (byte)((
          //                             [76543210]
          //                   [__________87654321_]
           ((in[ 2 + inPos] & 524287L) >>> 1)) & 255);
      out[ 7 + outPos] = (byte)((
          //                             [7_______]
          //           [__________________0]
           ((in[ 2 + inPos] & 524287L) <<  7)
        | //                             [_6543210]
          //                              [8765432____________]
           ((in[ 3 + inPos] & 524287L) >>> 12)) & 255);
      out[ 8 + outPos] = (byte)((
          //                             [76543210]
          //                      [_______10987654____]
           ((in[ 3 + inPos] & 524287L) >>> 4)) & 255);
      out[ 9 + outPos] = (byte)((
          //                             [7654____]
          //              [_______________3210]
           ((in[ 3 + inPos] & 524287L) <<  4)
        | //                             [____3210]
          //                                 [8765_______________]
           ((in[ 4 + inPos] & 524287L) >>> 15)) & 255);
      out[10 + outPos] = (byte)((
          //                             [76543210]
          //                         [____43210987_______]
           ((in[ 4 + inPos] & 524287L) >>> 7)) & 255);
      out[11 + outPos] = (byte)((
          //                             [7654321_]
          //                 [____________6543210]
           ((in[ 4 + inPos] & 524287L) <<  1)
        | //                             [_______0]
          //                                    [8__________________]
           ((in[ 5 + inPos] & 524287L) >>> 18)) & 255);
      out[12 + outPos] = (byte)((
          //                             [76543210]
          //                            [_76543210__________]
           ((in[ 5 + inPos] & 524287L) >>> 10)) & 255);
      out[13 + outPos] = (byte)((
          //                             [76543210]
          //                    [_________98765432__]
           ((in[ 5 + inPos] & 524287L) >>> 2)) & 255);
      out[14 + outPos] = (byte)((
          //                             [76______]
          //            [_________________10]
           ((in[ 5 + inPos] & 524287L) <<  6)
        | //                             [__543210]
          //                               [876543_____________]
           ((in[ 6 + inPos] & 524287L) >>> 13)) & 255);
      out[15 + outPos] = (byte)((
          //                             [76543210]
          //                       [______21098765_____]
           ((in[ 6 + inPos] & 524287L) >>> 5)) & 255);
      out[16 + outPos] = (byte)((
          //                             [76543___]
          //               [______________43210]
           ((in[ 6 + inPos] & 524287L) <<  3)
        | //                             [_____210]
          //                                  [876________________]
           ((in[ 7 + inPos] & 524287L) >>> 16)) & 255);
      out[17 + outPos] = (byte)((
          //                             [76543210]
          //                          [___54321098________]
           ((in[ 7 + inPos] & 524287L) >>> 8)) & 255);
      out[18 + outPos] = (byte)((
          //                             [76543210]
          //                  [___________76543210]
           ((in[ 7 + inPos] & 524287L))) & 255);
      out[19 + outPos] = (byte)((
          //                             [76543210]
          //                             [87654321___________]
           ((in[ 8 + inPos] & 524287L) >>> 11)) & 255);
      out[20 + outPos] = (byte)((
          //                             [76543210]
          //                     [________09876543___]
           ((in[ 8 + inPos] & 524287L) >>> 3)) & 255);
      out[21 + outPos] = (byte)((
          //                             [765_____]
          //             [________________210]
           ((in[ 8 + inPos] & 524287L) <<  5)
        | //                             [___43210]
          //                                [87654______________]
           ((in[ 9 + inPos] & 524287L) >>> 14)) & 255);
      out[22 + outPos] = (byte)((
          //                             [76543210]
          //                        [_____32109876______]
           ((in[ 9 + inPos] & 524287L) >>> 6)) & 255);
      out[23 + outPos] = (byte)((
          //                             [765432__]
          //                [_____________543210]
           ((in[ 9 + inPos] & 524287L) <<  2)
        | //                             [______10]
          //                                   [87_________________]
           ((in[10 + inPos] & 524287L) >>> 17)) & 255);
      out[24 + outPos] = (byte)((
          //                             [76543210]
          //                           [__65432109_________]
           ((in[10 + inPos] & 524287L) >>> 9)) & 255);
      out[25 + outPos] = (byte)((
          //                             [76543210]
          //                   [__________87654321_]
           ((in[10 + inPos] & 524287L) >>> 1)) & 255);
      out[26 + outPos] = (byte)((
          //                             [7_______]
          //           [__________________0]
           ((in[10 + inPos] & 524287L) <<  7)
        | //                             [_6543210]
          //                              [8765432____________]
           ((in[11 + inPos] & 524287L) >>> 12)) & 255);
      out[27 + outPos] = (byte)((
          //                             [76543210]
          //                      [_______10987654____]
           ((in[11 + inPos] & 524287L) >>> 4)) & 255);
      out[28 + outPos] = (byte)((
          //                             [7654____]
          //              [_______________3210]
           ((in[11 + inPos] & 524287L) <<  4)
        | //                             [____3210]
          //                                 [8765_______________]
           ((in[12 + inPos] & 524287L) >>> 15)) & 255);
      out[29 + outPos] = (byte)((
          //                             [76543210]
          //                         [____43210987_______]
           ((in[12 + inPos] & 524287L) >>> 7)) & 255);
      out[30 + outPos] = (byte)((
          //                             [7654321_]
          //                 [____________6543210]
           ((in[12 + inPos] & 524287L) <<  1)
        | //                             [_______0]
          //                                    [8__________________]
           ((in[13 + inPos] & 524287L) >>> 18)) & 255);
      out[31 + outPos] = (byte)((
          //                             [76543210]
          //                            [_76543210__________]
           ((in[13 + inPos] & 524287L) >>> 10)) & 255);
      out[32 + outPos] = (byte)((
          //                             [76543210]
          //                    [_________98765432__]
           ((in[13 + inPos] & 524287L) >>> 2)) & 255);
      out[33 + outPos] = (byte)((
          //                             [76______]
          //            [_________________10]
           ((in[13 + inPos] & 524287L) <<  6)
        | //                             [__543210]
          //                               [876543_____________]
           ((in[14 + inPos] & 524287L) >>> 13)) & 255);
      out[34 + outPos] = (byte)((
          //                             [76543210]
          //                       [______21098765_____]
           ((in[14 + inPos] & 524287L) >>> 5)) & 255);
      out[35 + outPos] = (byte)((
          //                             [76543___]
          //               [______________43210]
           ((in[14 + inPos] & 524287L) <<  3)
        | //                             [_____210]
          //                                  [876________________]
           ((in[15 + inPos] & 524287L) >>> 16)) & 255);
      out[36 + outPos] = (byte)((
          //                             [76543210]
          //                          [___54321098________]
           ((in[15 + inPos] & 524287L) >>> 8)) & 255);
      out[37 + outPos] = (byte)((
          //                             [76543210]
          //                  [___________76543210]
           ((in[15 + inPos] & 524287L))) & 255);
      out[38 + outPos] = (byte)((
          //                             [76543210]
          //                             [87654321___________]
           ((in[16 + inPos] & 524287L) >>> 11)) & 255);
      out[39 + outPos] = (byte)((
          //                             [76543210]
          //                     [________09876543___]
           ((in[16 + inPos] & 524287L) >>> 3)) & 255);
      out[40 + outPos] = (byte)((
          //                             [765_____]
          //             [________________210]
           ((in[16 + inPos] & 524287L) <<  5)
        | //                             [___43210]
          //                                [87654______________]
           ((in[17 + inPos] & 524287L) >>> 14)) & 255);
      out[41 + outPos] = (byte)((
          //                             [76543210]
          //                        [_____32109876______]
           ((in[17 + inPos] & 524287L) >>> 6)) & 255);
      out[42 + outPos] = (byte)((
          //                             [765432__]
          //                [_____________543210]
           ((in[17 + inPos] & 524287L) <<  2)
        | //                             [______10]
          //                                   [87_________________]
           ((in[18 + inPos] & 524287L) >>> 17)) & 255);
      out[43 + outPos] = (byte)((
          //                             [76543210]
          //                           [__65432109_________]
           ((in[18 + inPos] & 524287L) >>> 9)) & 255);
      out[44 + outPos] = (byte)((
          //                             [76543210]
          //                   [__________87654321_]
           ((in[18 + inPos] & 524287L) >>> 1)) & 255);
      out[45 + outPos] = (byte)((
          //                             [7_______]
          //           [__________________0]
           ((in[18 + inPos] & 524287L) <<  7)
        | //                             [_6543210]
          //                              [8765432____________]
           ((in[19 + inPos] & 524287L) >>> 12)) & 255);
      out[46 + outPos] = (byte)((
          //                             [76543210]
          //                      [_______10987654____]
           ((in[19 + inPos] & 524287L) >>> 4)) & 255);
      out[47 + outPos] = (byte)((
          //                             [7654____]
          //              [_______________3210]
           ((in[19 + inPos] & 524287L) <<  4)
        | //                             [____3210]
          //                                 [8765_______________]
           ((in[20 + inPos] & 524287L) >>> 15)) & 255);
      out[48 + outPos] = (byte)((
          //                             [76543210]
          //                         [____43210987_______]
           ((in[20 + inPos] & 524287L) >>> 7)) & 255);
      out[49 + outPos] = (byte)((
          //                             [7654321_]
          //                 [____________6543210]
           ((in[20 + inPos] & 524287L) <<  1)
        | //                             [_______0]
          //                                    [8__________________]
           ((in[21 + inPos] & 524287L) >>> 18)) & 255);
      out[50 + outPos] = (byte)((
          //                             [76543210]
          //                            [_76543210__________]
           ((in[21 + inPos] & 524287L) >>> 10)) & 255);
      out[51 + outPos] = (byte)((
          //                             [76543210]
          //                    [_________98765432__]
           ((in[21 + inPos] & 524287L) >>> 2)) & 255);
      out[52 + outPos] = (byte)((
          //                             [76______]
          //            [_________________10]
           ((in[21 + inPos] & 524287L) <<  6)
        | //                             [__543210]
          //                               [876543_____________]
           ((in[22 + inPos] & 524287L) >>> 13)) & 255);
      out[53 + outPos] = (byte)((
          //                             [76543210]
          //                       [______21098765_____]
           ((in[22 + inPos] & 524287L) >>> 5)) & 255);
      out[54 + outPos] = (byte)((
          //                             [76543___]
          //               [______________43210]
           ((in[22 + inPos] & 524287L) <<  3)
        | //                             [_____210]
          //                                  [876________________]
           ((in[23 + inPos] & 524287L) >>> 16)) & 255);
      out[55 + outPos] = (byte)((
          //                             [76543210]
          //                          [___54321098________]
           ((in[23 + inPos] & 524287L) >>> 8)) & 255);
      out[56 + outPos] = (byte)((
          //                             [76543210]
          //                  [___________76543210]
           ((in[23 + inPos] & 524287L))) & 255);
      out[57 + outPos] = (byte)((
          //                             [76543210]
          //                             [87654321___________]
           ((in[24 + inPos] & 524287L) >>> 11)) & 255);
      out[58 + outPos] = (byte)((
          //                             [76543210]
          //                     [________09876543___]
           ((in[24 + inPos] & 524287L) >>> 3)) & 255);
      out[59 + outPos] = (byte)((
          //                             [765_____]
          //             [________________210]
           ((in[24 + inPos] & 524287L) <<  5)
        | //                             [___43210]
          //                                [87654______________]
           ((in[25 + inPos] & 524287L) >>> 14)) & 255);
      out[60 + outPos] = (byte)((
          //                             [76543210]
          //                        [_____32109876______]
           ((in[25 + inPos] & 524287L) >>> 6)) & 255);
      out[61 + outPos] = (byte)((
          //                             [765432__]
          //                [_____________543210]
           ((in[25 + inPos] & 524287L) <<  2)
        | //                             [______10]
          //                                   [87_________________]
           ((in[26 + inPos] & 524287L) >>> 17)) & 255);
      out[62 + outPos] = (byte)((
          //                             [76543210]
          //                           [__65432109_________]
           ((in[26 + inPos] & 524287L) >>> 9)) & 255);
      out[63 + outPos] = (byte)((
          //                             [76543210]
          //                   [__________87654321_]
           ((in[26 + inPos] & 524287L) >>> 1)) & 255);
      out[64 + outPos] = (byte)((
          //                             [7_______]
          //           [__________________0]
           ((in[26 + inPos] & 524287L) <<  7)
        | //                             [_6543210]
          //                              [8765432____________]
           ((in[27 + inPos] & 524287L) >>> 12)) & 255);
      out[65 + outPos] = (byte)((
          //                             [76543210]
          //                      [_______10987654____]
           ((in[27 + inPos] & 524287L) >>> 4)) & 255);
      out[66 + outPos] = (byte)((
          //                             [7654____]
          //              [_______________3210]
           ((in[27 + inPos] & 524287L) <<  4)
        | //                             [____3210]
          //                                 [8765_______________]
           ((in[28 + inPos] & 524287L) >>> 15)) & 255);
      out[67 + outPos] = (byte)((
          //                             [76543210]
          //                         [____43210987_______]
           ((in[28 + inPos] & 524287L) >>> 7)) & 255);
      out[68 + outPos] = (byte)((
          //                             [7654321_]
          //                 [____________6543210]
           ((in[28 + inPos] & 524287L) <<  1)
        | //                             [_______0]
          //                                    [8__________________]
           ((in[29 + inPos] & 524287L) >>> 18)) & 255);
      out[69 + outPos] = (byte)((
          //                             [76543210]
          //                            [_76543210__________]
           ((in[29 + inPos] & 524287L) >>> 10)) & 255);
      out[70 + outPos] = (byte)((
          //                             [76543210]
          //                    [_________98765432__]
           ((in[29 + inPos] & 524287L) >>> 2)) & 255);
      out[71 + outPos] = (byte)((
          //                             [76______]
          //            [_________________10]
           ((in[29 + inPos] & 524287L) <<  6)
        | //                             [__543210]
          //                               [876543_____________]
           ((in[30 + inPos] & 524287L) >>> 13)) & 255);
      out[72 + outPos] = (byte)((
          //                             [76543210]
          //                       [______21098765_____]
           ((in[30 + inPos] & 524287L) >>> 5)) & 255);
      out[73 + outPos] = (byte)((
          //                             [76543___]
          //               [______________43210]
           ((in[30 + inPos] & 524287L) <<  3)
        | //                             [_____210]
          //                                  [876________________]
           ((in[31 + inPos] & 524287L) >>> 16)) & 255);
      out[74 + outPos] = (byte)((
          //                             [76543210]
          //                          [___54321098________]
           ((in[31 + inPos] & 524287L) >>> 8)) & 255);
      out[75 + outPos] = (byte)((
          //                             [76543210]
          //                  [___________76543210]
           ((in[31 + inPos] & 524287L))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                             [76543210]
          //                             [87654321___________]
            ((((long)in[ 0 + inPos]) <<  11) & 524287L)
        | //                             [76543210]
          //                     [________09876543___]
            ((((long)in[ 1 + inPos]) <<  3) & 2047L)
        | //                             [765_____]
          //             [________________210]
            ((((long)in[ 2 + inPos]) >>  5) & 7L);
      out[ 1 + outPos] =
          //                             [___43210]
          //                                [87654______________]
            ((((long)in[ 2 + inPos]) <<  14) & 524287L)
        | //                             [76543210]
          //                        [_____32109876______]
            ((((long)in[ 3 + inPos]) <<  6) & 16383L)
        | //                             [765432__]
          //                [_____________543210]
            ((((long)in[ 4 + inPos]) >>  2) & 63L);
      out[ 2 + outPos] =
          //                             [______10]
          //                                   [87_________________]
            ((((long)in[ 4 + inPos]) <<  17) & 524287L)
        | //                             [76543210]
          //                           [__65432109_________]
            ((((long)in[ 5 + inPos]) <<  9) & 131071L)
        | //                             [76543210]
          //                   [__________87654321_]
            ((((long)in[ 6 + inPos]) <<  1) & 511L)
        | //                             [7_______]
          //           [__________________0]
            ((((long)in[ 7 + inPos]) >>  7) & 1L);
      out[ 3 + outPos] =
          //                             [_6543210]
          //                              [8765432____________]
            ((((long)in[ 7 + inPos]) <<  12) & 524287L)
        | //                             [76543210]
          //                      [_______10987654____]
            ((((long)in[ 8 + inPos]) <<  4) & 4095L)
        | //                             [7654____]
          //              [_______________3210]
            ((((long)in[ 9 + inPos]) >>  4) & 15L);
      out[ 4 + outPos] =
          //                             [____3210]
          //                                 [8765_______________]
            ((((long)in[ 9 + inPos]) <<  15) & 524287L)
        | //                             [76543210]
          //                         [____43210987_______]
            ((((long)in[10 + inPos]) <<  7) & 32767L)
        | //                             [7654321_]
          //                 [____________6543210]
            ((((long)in[11 + inPos]) >>  1) & 127L);
      out[ 5 + outPos] =
          //                             [_______0]
          //                                    [8__________________]
            ((((long)in[11 + inPos]) <<  18) & 524287L)
        | //                             [76543210]
          //                            [_76543210__________]
            ((((long)in[12 + inPos]) <<  10) & 262143L)
        | //                             [76543210]
          //                    [_________98765432__]
            ((((long)in[13 + inPos]) <<  2) & 1023L)
        | //                             [76______]
          //            [_________________10]
            ((((long)in[14 + inPos]) >>  6) & 3L);
      out[ 6 + outPos] =
          //                             [__543210]
          //                               [876543_____________]
            ((((long)in[14 + inPos]) <<  13) & 524287L)
        | //                             [76543210]
          //                       [______21098765_____]
            ((((long)in[15 + inPos]) <<  5) & 8191L)
        | //                             [76543___]
          //               [______________43210]
            ((((long)in[16 + inPos]) >>  3) & 31L);
      out[ 7 + outPos] =
          //                             [_____210]
          //                                  [876________________]
            ((((long)in[16 + inPos]) <<  16) & 524287L)
        | //                             [76543210]
          //                          [___54321098________]
            ((((long)in[17 + inPos]) <<  8) & 65535L)
        | //                             [76543210]
          //                  [___________76543210]
            ((((long)in[18 + inPos]) ) & 255L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                             [76543210]
          //                             [87654321___________]
            ((((long)in.get( 0 + inPos)) <<  11) & 524287L)
        | //                             [76543210]
          //                     [________09876543___]
            ((((long)in.get( 1 + inPos)) <<  3) & 2047L)
        | //                             [765_____]
          //             [________________210]
            ((((long)in.get( 2 + inPos)) >>  5) & 7L);
      out[ 1 + outPos] =
          //                             [___43210]
          //                                [87654______________]
            ((((long)in.get( 2 + inPos)) <<  14) & 524287L)
        | //                             [76543210]
          //                        [_____32109876______]
            ((((long)in.get( 3 + inPos)) <<  6) & 16383L)
        | //                             [765432__]
          //                [_____________543210]
            ((((long)in.get( 4 + inPos)) >>  2) & 63L);
      out[ 2 + outPos] =
          //                             [______10]
          //                                   [87_________________]
            ((((long)in.get( 4 + inPos)) <<  17) & 524287L)
        | //                             [76543210]
          //                           [__65432109_________]
            ((((long)in.get( 5 + inPos)) <<  9) & 131071L)
        | //                             [76543210]
          //                   [__________87654321_]
            ((((long)in.get( 6 + inPos)) <<  1) & 511L)
        | //                             [7_______]
          //           [__________________0]
            ((((long)in.get( 7 + inPos)) >>  7) & 1L);
      out[ 3 + outPos] =
          //                             [_6543210]
          //                              [8765432____________]
            ((((long)in.get( 7 + inPos)) <<  12) & 524287L)
        | //                             [76543210]
          //                      [_______10987654____]
            ((((long)in.get( 8 + inPos)) <<  4) & 4095L)
        | //                             [7654____]
          //              [_______________3210]
            ((((long)in.get( 9 + inPos)) >>  4) & 15L);
      out[ 4 + outPos] =
          //                             [____3210]
          //                                 [8765_______________]
            ((((long)in.get( 9 + inPos)) <<  15) & 524287L)
        | //                             [76543210]
          //                         [____43210987_______]
            ((((long)in.get(10 + inPos)) <<  7) & 32767L)
        | //                             [7654321_]
          //                 [____________6543210]
            ((((long)in.get(11 + inPos)) >>  1) & 127L);
      out[ 5 + outPos] =
          //                             [_______0]
          //                                    [8__________________]
            ((((long)in.get(11 + inPos)) <<  18) & 524287L)
        | //                             [76543210]
          //                            [_76543210__________]
            ((((long)in.get(12 + inPos)) <<  10) & 262143L)
        | //                             [76543210]
          //                    [_________98765432__]
            ((((long)in.get(13 + inPos)) <<  2) & 1023L)
        | //                             [76______]
          //            [_________________10]
            ((((long)in.get(14 + inPos)) >>  6) & 3L);
      out[ 6 + outPos] =
          //                             [__543210]
          //                               [876543_____________]
            ((((long)in.get(14 + inPos)) <<  13) & 524287L)
        | //                             [76543210]
          //                       [______21098765_____]
            ((((long)in.get(15 + inPos)) <<  5) & 8191L)
        | //                             [76543___]
          //               [______________43210]
            ((((long)in.get(16 + inPos)) >>  3) & 31L);
      out[ 7 + outPos] =
          //                             [_____210]
          //                                  [876________________]
            ((((long)in.get(16 + inPos)) <<  16) & 524287L)
        | //                             [76543210]
          //                          [___54321098________]
            ((((long)in.get(17 + inPos)) <<  8) & 65535L)
        | //                             [76543210]
          //                  [___________76543210]
            ((((long)in.get(18 + inPos)) ) & 255L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                             [76543210]
          //                             [87654321___________]
            ((((long)in[ 0 + inPos]) <<  11) & 524287L)
        | //                             [76543210]
          //                     [________09876543___]
            ((((long)in[ 1 + inPos]) <<  3) & 2047L)
        | //                             [765_____]
          //             [________________210]
            ((((long)in[ 2 + inPos]) >>  5) & 7L);
      out[ 1 + outPos] =
          //                             [___43210]
          //                                [87654______________]
            ((((long)in[ 2 + inPos]) <<  14) & 524287L)
        | //                             [76543210]
          //                        [_____32109876______]
            ((((long)in[ 3 + inPos]) <<  6) & 16383L)
        | //                             [765432__]
          //                [_____________543210]
            ((((long)in[ 4 + inPos]) >>  2) & 63L);
      out[ 2 + outPos] =
          //                             [______10]
          //                                   [87_________________]
            ((((long)in[ 4 + inPos]) <<  17) & 524287L)
        | //                             [76543210]
          //                           [__65432109_________]
            ((((long)in[ 5 + inPos]) <<  9) & 131071L)
        | //                             [76543210]
          //                   [__________87654321_]
            ((((long)in[ 6 + inPos]) <<  1) & 511L)
        | //                             [7_______]
          //           [__________________0]
            ((((long)in[ 7 + inPos]) >>  7) & 1L);
      out[ 3 + outPos] =
          //                             [_6543210]
          //                              [8765432____________]
            ((((long)in[ 7 + inPos]) <<  12) & 524287L)
        | //                             [76543210]
          //                      [_______10987654____]
            ((((long)in[ 8 + inPos]) <<  4) & 4095L)
        | //                             [7654____]
          //              [_______________3210]
            ((((long)in[ 9 + inPos]) >>  4) & 15L);
      out[ 4 + outPos] =
          //                             [____3210]
          //                                 [8765_______________]
            ((((long)in[ 9 + inPos]) <<  15) & 524287L)
        | //                             [76543210]
          //                         [____43210987_______]
            ((((long)in[10 + inPos]) <<  7) & 32767L)
        | //                             [7654321_]
          //                 [____________6543210]
            ((((long)in[11 + inPos]) >>  1) & 127L);
      out[ 5 + outPos] =
          //                             [_______0]
          //                                    [8__________________]
            ((((long)in[11 + inPos]) <<  18) & 524287L)
        | //                             [76543210]
          //                            [_76543210__________]
            ((((long)in[12 + inPos]) <<  10) & 262143L)
        | //                             [76543210]
          //                    [_________98765432__]
            ((((long)in[13 + inPos]) <<  2) & 1023L)
        | //                             [76______]
          //            [_________________10]
            ((((long)in[14 + inPos]) >>  6) & 3L);
      out[ 6 + outPos] =
          //                             [__543210]
          //                               [876543_____________]
            ((((long)in[14 + inPos]) <<  13) & 524287L)
        | //                             [76543210]
          //                       [______21098765_____]
            ((((long)in[15 + inPos]) <<  5) & 8191L)
        | //                             [76543___]
          //               [______________43210]
            ((((long)in[16 + inPos]) >>  3) & 31L);
      out[ 7 + outPos] =
          //                             [_____210]
          //                                  [876________________]
            ((((long)in[16 + inPos]) <<  16) & 524287L)
        | //                             [76543210]
          //                          [___54321098________]
            ((((long)in[17 + inPos]) <<  8) & 65535L)
        | //                             [76543210]
          //                  [___________76543210]
            ((((long)in[18 + inPos]) ) & 255L);
      out[ 8 + outPos] =
          //                             [76543210]
          //                             [87654321___________]
            ((((long)in[19 + inPos]) <<  11) & 524287L)
        | //                             [76543210]
          //                     [________09876543___]
            ((((long)in[20 + inPos]) <<  3) & 2047L)
        | //                             [765_____]
          //             [________________210]
            ((((long)in[21 + inPos]) >>  5) & 7L);
      out[ 9 + outPos] =
          //                             [___43210]
          //                                [87654______________]
            ((((long)in[21 + inPos]) <<  14) & 524287L)
        | //                             [76543210]
          //                        [_____32109876______]
            ((((long)in[22 + inPos]) <<  6) & 16383L)
        | //                             [765432__]
          //                [_____________543210]
            ((((long)in[23 + inPos]) >>  2) & 63L);
      out[10 + outPos] =
          //                             [______10]
          //                                   [87_________________]
            ((((long)in[23 + inPos]) <<  17) & 524287L)
        | //                             [76543210]
          //                           [__65432109_________]
            ((((long)in[24 + inPos]) <<  9) & 131071L)
        | //                             [76543210]
          //                   [__________87654321_]
            ((((long)in[25 + inPos]) <<  1) & 511L)
        | //                             [7_______]
          //           [__________________0]
            ((((long)in[26 + inPos]) >>  7) & 1L);
      out[11 + outPos] =
          //                             [_6543210]
          //                              [8765432____________]
            ((((long)in[26 + inPos]) <<  12) & 524287L)
        | //                             [76543210]
          //                      [_______10987654____]
            ((((long)in[27 + inPos]) <<  4) & 4095L)
        | //                             [7654____]
          //              [_______________3210]
            ((((long)in[28 + inPos]) >>  4) & 15L);
      out[12 + outPos] =
          //                             [____3210]
          //                                 [8765_______________]
            ((((long)in[28 + inPos]) <<  15) & 524287L)
        | //                             [76543210]
          //                         [____43210987_______]
            ((((long)in[29 + inPos]) <<  7) & 32767L)
        | //                             [7654321_]
          //                 [____________6543210]
            ((((long)in[30 + inPos]) >>  1) & 127L);
      out[13 + outPos] =
          //                             [_______0]
          //                                    [8__________________]
            ((((long)in[30 + inPos]) <<  18) & 524287L)
        | //                             [76543210]
          //                            [_76543210__________]
            ((((long)in[31 + inPos]) <<  10) & 262143L)
        | //                             [76543210]
          //                    [_________98765432__]
            ((((long)in[32 + inPos]) <<  2) & 1023L)
        | //                             [76______]
          //            [_________________10]
            ((((long)in[33 + inPos]) >>  6) & 3L);
      out[14 + outPos] =
          //                             [__543210]
          //                               [876543_____________]
            ((((long)in[33 + inPos]) <<  13) & 524287L)
        | //                             [76543210]
          //                       [______21098765_____]
            ((((long)in[34 + inPos]) <<  5) & 8191L)
        | //                             [76543___]
          //               [______________43210]
            ((((long)in[35 + inPos]) >>  3) & 31L);
      out[15 + outPos] =
          //                             [_____210]
          //                                  [876________________]
            ((((long)in[35 + inPos]) <<  16) & 524287L)
        | //                             [76543210]
          //                          [___54321098________]
            ((((long)in[36 + inPos]) <<  8) & 65535L)
        | //                             [76543210]
          //                  [___________76543210]
            ((((long)in[37 + inPos]) ) & 255L);
      out[16 + outPos] =
          //                             [76543210]
          //                             [87654321___________]
            ((((long)in[38 + inPos]) <<  11) & 524287L)
        | //                             [76543210]
          //                     [________09876543___]
            ((((long)in[39 + inPos]) <<  3) & 2047L)
        | //                             [765_____]
          //             [________________210]
            ((((long)in[40 + inPos]) >>  5) & 7L);
      out[17 + outPos] =
          //                             [___43210]
          //                                [87654______________]
            ((((long)in[40 + inPos]) <<  14) & 524287L)
        | //                             [76543210]
          //                        [_____32109876______]
            ((((long)in[41 + inPos]) <<  6) & 16383L)
        | //                             [765432__]
          //                [_____________543210]
            ((((long)in[42 + inPos]) >>  2) & 63L);
      out[18 + outPos] =
          //                             [______10]
          //                                   [87_________________]
            ((((long)in[42 + inPos]) <<  17) & 524287L)
        | //                             [76543210]
          //                           [__65432109_________]
            ((((long)in[43 + inPos]) <<  9) & 131071L)
        | //                             [76543210]
          //                   [__________87654321_]
            ((((long)in[44 + inPos]) <<  1) & 511L)
        | //                             [7_______]
          //           [__________________0]
            ((((long)in[45 + inPos]) >>  7) & 1L);
      out[19 + outPos] =
          //                             [_6543210]
          //                              [8765432____________]
            ((((long)in[45 + inPos]) <<  12) & 524287L)
        | //                             [76543210]
          //                      [_______10987654____]
            ((((long)in[46 + inPos]) <<  4) & 4095L)
        | //                             [7654____]
          //              [_______________3210]
            ((((long)in[47 + inPos]) >>  4) & 15L);
      out[20 + outPos] =
          //                             [____3210]
          //                                 [8765_______________]
            ((((long)in[47 + inPos]) <<  15) & 524287L)
        | //                             [76543210]
          //                         [____43210987_______]
            ((((long)in[48 + inPos]) <<  7) & 32767L)
        | //                             [7654321_]
          //                 [____________6543210]
            ((((long)in[49 + inPos]) >>  1) & 127L);
      out[21 + outPos] =
          //                             [_______0]
          //                                    [8__________________]
            ((((long)in[49 + inPos]) <<  18) & 524287L)
        | //                             [76543210]
          //                            [_76543210__________]
            ((((long)in[50 + inPos]) <<  10) & 262143L)
        | //                             [76543210]
          //                    [_________98765432__]
            ((((long)in[51 + inPos]) <<  2) & 1023L)
        | //                             [76______]
          //            [_________________10]
            ((((long)in[52 + inPos]) >>  6) & 3L);
      out[22 + outPos] =
          //                             [__543210]
          //                               [876543_____________]
            ((((long)in[52 + inPos]) <<  13) & 524287L)
        | //                             [76543210]
          //                       [______21098765_____]
            ((((long)in[53 + inPos]) <<  5) & 8191L)
        | //                             [76543___]
          //               [______________43210]
            ((((long)in[54 + inPos]) >>  3) & 31L);
      out[23 + outPos] =
          //                             [_____210]
          //                                  [876________________]
            ((((long)in[54 + inPos]) <<  16) & 524287L)
        | //                             [76543210]
          //                          [___54321098________]
            ((((long)in[55 + inPos]) <<  8) & 65535L)
        | //                             [76543210]
          //                  [___________76543210]
            ((((long)in[56 + inPos]) ) & 255L);
      out[24 + outPos] =
          //                             [76543210]
          //                             [87654321___________]
            ((((long)in[57 + inPos]) <<  11) & 524287L)
        | //                             [76543210]
          //                     [________09876543___]
            ((((long)in[58 + inPos]) <<  3) & 2047L)
        | //                             [765_____]
          //             [________________210]
            ((((long)in[59 + inPos]) >>  5) & 7L);
      out[25 + outPos] =
          //                             [___43210]
          //                                [87654______________]
            ((((long)in[59 + inPos]) <<  14) & 524287L)
        | //                             [76543210]
          //                        [_____32109876______]
            ((((long)in[60 + inPos]) <<  6) & 16383L)
        | //                             [765432__]
          //                [_____________543210]
            ((((long)in[61 + inPos]) >>  2) & 63L);
      out[26 + outPos] =
          //                             [______10]
          //                                   [87_________________]
            ((((long)in[61 + inPos]) <<  17) & 524287L)
        | //                             [76543210]
          //                           [__65432109_________]
            ((((long)in[62 + inPos]) <<  9) & 131071L)
        | //                             [76543210]
          //                   [__________87654321_]
            ((((long)in[63 + inPos]) <<  1) & 511L)
        | //                             [7_______]
          //           [__________________0]
            ((((long)in[64 + inPos]) >>  7) & 1L);
      out[27 + outPos] =
          //                             [_6543210]
          //                              [8765432____________]
            ((((long)in[64 + inPos]) <<  12) & 524287L)
        | //                             [76543210]
          //                      [_______10987654____]
            ((((long)in[65 + inPos]) <<  4) & 4095L)
        | //                             [7654____]
          //              [_______________3210]
            ((((long)in[66 + inPos]) >>  4) & 15L);
      out[28 + outPos] =
          //                             [____3210]
          //                                 [8765_______________]
            ((((long)in[66 + inPos]) <<  15) & 524287L)
        | //                             [76543210]
          //                         [____43210987_______]
            ((((long)in[67 + inPos]) <<  7) & 32767L)
        | //                             [7654321_]
          //                 [____________6543210]
            ((((long)in[68 + inPos]) >>  1) & 127L);
      out[29 + outPos] =
          //                             [_______0]
          //                                    [8__________________]
            ((((long)in[68 + inPos]) <<  18) & 524287L)
        | //                             [76543210]
          //                            [_76543210__________]
            ((((long)in[69 + inPos]) <<  10) & 262143L)
        | //                             [76543210]
          //                    [_________98765432__]
            ((((long)in[70 + inPos]) <<  2) & 1023L)
        | //                             [76______]
          //            [_________________10]
            ((((long)in[71 + inPos]) >>  6) & 3L);
      out[30 + outPos] =
          //                             [__543210]
          //                               [876543_____________]
            ((((long)in[71 + inPos]) <<  13) & 524287L)
        | //                             [76543210]
          //                       [______21098765_____]
            ((((long)in[72 + inPos]) <<  5) & 8191L)
        | //                             [76543___]
          //               [______________43210]
            ((((long)in[73 + inPos]) >>  3) & 31L);
      out[31 + outPos] =
          //                             [_____210]
          //                                  [876________________]
            ((((long)in[73 + inPos]) <<  16) & 524287L)
        | //                             [76543210]
          //                          [___54321098________]
            ((((long)in[74 + inPos]) <<  8) & 65535L)
        | //                             [76543210]
          //                  [___________76543210]
            ((((long)in[75 + inPos]) ) & 255L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                             [76543210]
          //                             [87654321___________]
            ((((long)in.get( 0 + inPos)) <<  11) & 524287L)
        | //                             [76543210]
          //                     [________09876543___]
            ((((long)in.get( 1 + inPos)) <<  3) & 2047L)
        | //                             [765_____]
          //             [________________210]
            ((((long)in.get( 2 + inPos)) >>  5) & 7L);
      out[ 1 + outPos] =
          //                             [___43210]
          //                                [87654______________]
            ((((long)in.get( 2 + inPos)) <<  14) & 524287L)
        | //                             [76543210]
          //                        [_____32109876______]
            ((((long)in.get( 3 + inPos)) <<  6) & 16383L)
        | //                             [765432__]
          //                [_____________543210]
            ((((long)in.get( 4 + inPos)) >>  2) & 63L);
      out[ 2 + outPos] =
          //                             [______10]
          //                                   [87_________________]
            ((((long)in.get( 4 + inPos)) <<  17) & 524287L)
        | //                             [76543210]
          //                           [__65432109_________]
            ((((long)in.get( 5 + inPos)) <<  9) & 131071L)
        | //                             [76543210]
          //                   [__________87654321_]
            ((((long)in.get( 6 + inPos)) <<  1) & 511L)
        | //                             [7_______]
          //           [__________________0]
            ((((long)in.get( 7 + inPos)) >>  7) & 1L);
      out[ 3 + outPos] =
          //                             [_6543210]
          //                              [8765432____________]
            ((((long)in.get( 7 + inPos)) <<  12) & 524287L)
        | //                             [76543210]
          //                      [_______10987654____]
            ((((long)in.get( 8 + inPos)) <<  4) & 4095L)
        | //                             [7654____]
          //              [_______________3210]
            ((((long)in.get( 9 + inPos)) >>  4) & 15L);
      out[ 4 + outPos] =
          //                             [____3210]
          //                                 [8765_______________]
            ((((long)in.get( 9 + inPos)) <<  15) & 524287L)
        | //                             [76543210]
          //                         [____43210987_______]
            ((((long)in.get(10 + inPos)) <<  7) & 32767L)
        | //                             [7654321_]
          //                 [____________6543210]
            ((((long)in.get(11 + inPos)) >>  1) & 127L);
      out[ 5 + outPos] =
          //                             [_______0]
          //                                    [8__________________]
            ((((long)in.get(11 + inPos)) <<  18) & 524287L)
        | //                             [76543210]
          //                            [_76543210__________]
            ((((long)in.get(12 + inPos)) <<  10) & 262143L)
        | //                             [76543210]
          //                    [_________98765432__]
            ((((long)in.get(13 + inPos)) <<  2) & 1023L)
        | //                             [76______]
          //            [_________________10]
            ((((long)in.get(14 + inPos)) >>  6) & 3L);
      out[ 6 + outPos] =
          //                             [__543210]
          //                               [876543_____________]
            ((((long)in.get(14 + inPos)) <<  13) & 524287L)
        | //                             [76543210]
          //                       [______21098765_____]
            ((((long)in.get(15 + inPos)) <<  5) & 8191L)
        | //                             [76543___]
          //               [______________43210]
            ((((long)in.get(16 + inPos)) >>  3) & 31L);
      out[ 7 + outPos] =
          //                             [_____210]
          //                                  [876________________]
            ((((long)in.get(16 + inPos)) <<  16) & 524287L)
        | //                             [76543210]
          //                          [___54321098________]
            ((((long)in.get(17 + inPos)) <<  8) & 65535L)
        | //                             [76543210]
          //                  [___________76543210]
            ((((long)in.get(18 + inPos)) ) & 255L);
      out[ 8 + outPos] =
          //                             [76543210]
          //                             [87654321___________]
            ((((long)in.get(19 + inPos)) <<  11) & 524287L)
        | //                             [76543210]
          //                     [________09876543___]
            ((((long)in.get(20 + inPos)) <<  3) & 2047L)
        | //                             [765_____]
          //             [________________210]
            ((((long)in.get(21 + inPos)) >>  5) & 7L);
      out[ 9 + outPos] =
          //                             [___43210]
          //                                [87654______________]
            ((((long)in.get(21 + inPos)) <<  14) & 524287L)
        | //                             [76543210]
          //                        [_____32109876______]
            ((((long)in.get(22 + inPos)) <<  6) & 16383L)
        | //                             [765432__]
          //                [_____________543210]
            ((((long)in.get(23 + inPos)) >>  2) & 63L);
      out[10 + outPos] =
          //                             [______10]
          //                                   [87_________________]
            ((((long)in.get(23 + inPos)) <<  17) & 524287L)
        | //                             [76543210]
          //                           [__65432109_________]
            ((((long)in.get(24 + inPos)) <<  9) & 131071L)
        | //                             [76543210]
          //                   [__________87654321_]
            ((((long)in.get(25 + inPos)) <<  1) & 511L)
        | //                             [7_______]
          //           [__________________0]
            ((((long)in.get(26 + inPos)) >>  7) & 1L);
      out[11 + outPos] =
          //                             [_6543210]
          //                              [8765432____________]
            ((((long)in.get(26 + inPos)) <<  12) & 524287L)
        | //                             [76543210]
          //                      [_______10987654____]
            ((((long)in.get(27 + inPos)) <<  4) & 4095L)
        | //                             [7654____]
          //              [_______________3210]
            ((((long)in.get(28 + inPos)) >>  4) & 15L);
      out[12 + outPos] =
          //                             [____3210]
          //                                 [8765_______________]
            ((((long)in.get(28 + inPos)) <<  15) & 524287L)
        | //                             [76543210]
          //                         [____43210987_______]
            ((((long)in.get(29 + inPos)) <<  7) & 32767L)
        | //                             [7654321_]
          //                 [____________6543210]
            ((((long)in.get(30 + inPos)) >>  1) & 127L);
      out[13 + outPos] =
          //                             [_______0]
          //                                    [8__________________]
            ((((long)in.get(30 + inPos)) <<  18) & 524287L)
        | //                             [76543210]
          //                            [_76543210__________]
            ((((long)in.get(31 + inPos)) <<  10) & 262143L)
        | //                             [76543210]
          //                    [_________98765432__]
            ((((long)in.get(32 + inPos)) <<  2) & 1023L)
        | //                             [76______]
          //            [_________________10]
            ((((long)in.get(33 + inPos)) >>  6) & 3L);
      out[14 + outPos] =
          //                             [__543210]
          //                               [876543_____________]
            ((((long)in.get(33 + inPos)) <<  13) & 524287L)
        | //                             [76543210]
          //                       [______21098765_____]
            ((((long)in.get(34 + inPos)) <<  5) & 8191L)
        | //                             [76543___]
          //               [______________43210]
            ((((long)in.get(35 + inPos)) >>  3) & 31L);
      out[15 + outPos] =
          //                             [_____210]
          //                                  [876________________]
            ((((long)in.get(35 + inPos)) <<  16) & 524287L)
        | //                             [76543210]
          //                          [___54321098________]
            ((((long)in.get(36 + inPos)) <<  8) & 65535L)
        | //                             [76543210]
          //                  [___________76543210]
            ((((long)in.get(37 + inPos)) ) & 255L);
      out[16 + outPos] =
          //                             [76543210]
          //                             [87654321___________]
            ((((long)in.get(38 + inPos)) <<  11) & 524287L)
        | //                             [76543210]
          //                     [________09876543___]
            ((((long)in.get(39 + inPos)) <<  3) & 2047L)
        | //                             [765_____]
          //             [________________210]
            ((((long)in.get(40 + inPos)) >>  5) & 7L);
      out[17 + outPos] =
          //                             [___43210]
          //                                [87654______________]
            ((((long)in.get(40 + inPos)) <<  14) & 524287L)
        | //                             [76543210]
          //                        [_____32109876______]
            ((((long)in.get(41 + inPos)) <<  6) & 16383L)
        | //                             [765432__]
          //                [_____________543210]
            ((((long)in.get(42 + inPos)) >>  2) & 63L);
      out[18 + outPos] =
          //                             [______10]
          //                                   [87_________________]
            ((((long)in.get(42 + inPos)) <<  17) & 524287L)
        | //                             [76543210]
          //                           [__65432109_________]
            ((((long)in.get(43 + inPos)) <<  9) & 131071L)
        | //                             [76543210]
          //                   [__________87654321_]
            ((((long)in.get(44 + inPos)) <<  1) & 511L)
        | //                             [7_______]
          //           [__________________0]
            ((((long)in.get(45 + inPos)) >>  7) & 1L);
      out[19 + outPos] =
          //                             [_6543210]
          //                              [8765432____________]
            ((((long)in.get(45 + inPos)) <<  12) & 524287L)
        | //                             [76543210]
          //                      [_______10987654____]
            ((((long)in.get(46 + inPos)) <<  4) & 4095L)
        | //                             [7654____]
          //              [_______________3210]
            ((((long)in.get(47 + inPos)) >>  4) & 15L);
      out[20 + outPos] =
          //                             [____3210]
          //                                 [8765_______________]
            ((((long)in.get(47 + inPos)) <<  15) & 524287L)
        | //                             [76543210]
          //                         [____43210987_______]
            ((((long)in.get(48 + inPos)) <<  7) & 32767L)
        | //                             [7654321_]
          //                 [____________6543210]
            ((((long)in.get(49 + inPos)) >>  1) & 127L);
      out[21 + outPos] =
          //                             [_______0]
          //                                    [8__________________]
            ((((long)in.get(49 + inPos)) <<  18) & 524287L)
        | //                             [76543210]
          //                            [_76543210__________]
            ((((long)in.get(50 + inPos)) <<  10) & 262143L)
        | //                             [76543210]
          //                    [_________98765432__]
            ((((long)in.get(51 + inPos)) <<  2) & 1023L)
        | //                             [76______]
          //            [_________________10]
            ((((long)in.get(52 + inPos)) >>  6) & 3L);
      out[22 + outPos] =
          //                             [__543210]
          //                               [876543_____________]
            ((((long)in.get(52 + inPos)) <<  13) & 524287L)
        | //                             [76543210]
          //                       [______21098765_____]
            ((((long)in.get(53 + inPos)) <<  5) & 8191L)
        | //                             [76543___]
          //               [______________43210]
            ((((long)in.get(54 + inPos)) >>  3) & 31L);
      out[23 + outPos] =
          //                             [_____210]
          //                                  [876________________]
            ((((long)in.get(54 + inPos)) <<  16) & 524287L)
        | //                             [76543210]
          //                          [___54321098________]
            ((((long)in.get(55 + inPos)) <<  8) & 65535L)
        | //                             [76543210]
          //                  [___________76543210]
            ((((long)in.get(56 + inPos)) ) & 255L);
      out[24 + outPos] =
          //                             [76543210]
          //                             [87654321___________]
            ((((long)in.get(57 + inPos)) <<  11) & 524287L)
        | //                             [76543210]
          //                     [________09876543___]
            ((((long)in.get(58 + inPos)) <<  3) & 2047L)
        | //                             [765_____]
          //             [________________210]
            ((((long)in.get(59 + inPos)) >>  5) & 7L);
      out[25 + outPos] =
          //                             [___43210]
          //                                [87654______________]
            ((((long)in.get(59 + inPos)) <<  14) & 524287L)
        | //                             [76543210]
          //                        [_____32109876______]
            ((((long)in.get(60 + inPos)) <<  6) & 16383L)
        | //                             [765432__]
          //                [_____________543210]
            ((((long)in.get(61 + inPos)) >>  2) & 63L);
      out[26 + outPos] =
          //                             [______10]
          //                                   [87_________________]
            ((((long)in.get(61 + inPos)) <<  17) & 524287L)
        | //                             [76543210]
          //                           [__65432109_________]
            ((((long)in.get(62 + inPos)) <<  9) & 131071L)
        | //                             [76543210]
          //                   [__________87654321_]
            ((((long)in.get(63 + inPos)) <<  1) & 511L)
        | //                             [7_______]
          //           [__________________0]
            ((((long)in.get(64 + inPos)) >>  7) & 1L);
      out[27 + outPos] =
          //                             [_6543210]
          //                              [8765432____________]
            ((((long)in.get(64 + inPos)) <<  12) & 524287L)
        | //                             [76543210]
          //                      [_______10987654____]
            ((((long)in.get(65 + inPos)) <<  4) & 4095L)
        | //                             [7654____]
          //              [_______________3210]
            ((((long)in.get(66 + inPos)) >>  4) & 15L);
      out[28 + outPos] =
          //                             [____3210]
          //                                 [8765_______________]
            ((((long)in.get(66 + inPos)) <<  15) & 524287L)
        | //                             [76543210]
          //                         [____43210987_______]
            ((((long)in.get(67 + inPos)) <<  7) & 32767L)
        | //                             [7654321_]
          //                 [____________6543210]
            ((((long)in.get(68 + inPos)) >>  1) & 127L);
      out[29 + outPos] =
          //                             [_______0]
          //                                    [8__________________]
            ((((long)in.get(68 + inPos)) <<  18) & 524287L)
        | //                             [76543210]
          //                            [_76543210__________]
            ((((long)in.get(69 + inPos)) <<  10) & 262143L)
        | //                             [76543210]
          //                    [_________98765432__]
            ((((long)in.get(70 + inPos)) <<  2) & 1023L)
        | //                             [76______]
          //            [_________________10]
            ((((long)in.get(71 + inPos)) >>  6) & 3L);
      out[30 + outPos] =
          //                             [__543210]
          //                               [876543_____________]
            ((((long)in.get(71 + inPos)) <<  13) & 524287L)
        | //                             [76543210]
          //                       [______21098765_____]
            ((((long)in.get(72 + inPos)) <<  5) & 8191L)
        | //                             [76543___]
          //               [______________43210]
            ((((long)in.get(73 + inPos)) >>  3) & 31L);
      out[31 + outPos] =
          //                             [_____210]
          //                                  [876________________]
            ((((long)in.get(73 + inPos)) <<  16) & 524287L)
        | //                             [76543210]
          //                          [___54321098________]
            ((((long)in.get(74 + inPos)) <<  8) & 65535L)
        | //                             [76543210]
          //                  [___________76543210]
            ((((long)in.get(75 + inPos)) ) & 255L);
    }
  }

  private static final class Packer20 extends BytePackerForLong {

    private Packer20() {
      super(20);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[ 0 + inPos] & 1048575L) >>> 12)) & 255);
      out[ 1 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[ 0 + inPos] & 1048575L) >>> 4)) & 255);
      out[ 2 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[ 0 + inPos] & 1048575L) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[ 1 + inPos] & 1048575L) >>> 16)) & 255);
      out[ 3 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[ 1 + inPos] & 1048575L) >>> 8)) & 255);
      out[ 4 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[ 1 + inPos] & 1048575L))) & 255);
      out[ 5 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[ 2 + inPos] & 1048575L) >>> 12)) & 255);
      out[ 6 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[ 2 + inPos] & 1048575L) >>> 4)) & 255);
      out[ 7 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[ 2 + inPos] & 1048575L) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[ 3 + inPos] & 1048575L) >>> 16)) & 255);
      out[ 8 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[ 3 + inPos] & 1048575L) >>> 8)) & 255);
      out[ 9 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[ 3 + inPos] & 1048575L))) & 255);
      out[10 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[ 4 + inPos] & 1048575L) >>> 12)) & 255);
      out[11 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[ 4 + inPos] & 1048575L) >>> 4)) & 255);
      out[12 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[ 4 + inPos] & 1048575L) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[ 5 + inPos] & 1048575L) >>> 16)) & 255);
      out[13 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[ 5 + inPos] & 1048575L) >>> 8)) & 255);
      out[14 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[ 5 + inPos] & 1048575L))) & 255);
      out[15 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[ 6 + inPos] & 1048575L) >>> 12)) & 255);
      out[16 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[ 6 + inPos] & 1048575L) >>> 4)) & 255);
      out[17 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[ 6 + inPos] & 1048575L) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[ 7 + inPos] & 1048575L) >>> 16)) & 255);
      out[18 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[ 7 + inPos] & 1048575L) >>> 8)) & 255);
      out[19 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[ 7 + inPos] & 1048575L))) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[ 0 + inPos] & 1048575L) >>> 12)) & 255);
      out[ 1 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[ 0 + inPos] & 1048575L) >>> 4)) & 255);
      out[ 2 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[ 0 + inPos] & 1048575L) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[ 1 + inPos] & 1048575L) >>> 16)) & 255);
      out[ 3 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[ 1 + inPos] & 1048575L) >>> 8)) & 255);
      out[ 4 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[ 1 + inPos] & 1048575L))) & 255);
      out[ 5 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[ 2 + inPos] & 1048575L) >>> 12)) & 255);
      out[ 6 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[ 2 + inPos] & 1048575L) >>> 4)) & 255);
      out[ 7 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[ 2 + inPos] & 1048575L) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[ 3 + inPos] & 1048575L) >>> 16)) & 255);
      out[ 8 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[ 3 + inPos] & 1048575L) >>> 8)) & 255);
      out[ 9 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[ 3 + inPos] & 1048575L))) & 255);
      out[10 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[ 4 + inPos] & 1048575L) >>> 12)) & 255);
      out[11 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[ 4 + inPos] & 1048575L) >>> 4)) & 255);
      out[12 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[ 4 + inPos] & 1048575L) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[ 5 + inPos] & 1048575L) >>> 16)) & 255);
      out[13 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[ 5 + inPos] & 1048575L) >>> 8)) & 255);
      out[14 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[ 5 + inPos] & 1048575L))) & 255);
      out[15 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[ 6 + inPos] & 1048575L) >>> 12)) & 255);
      out[16 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[ 6 + inPos] & 1048575L) >>> 4)) & 255);
      out[17 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[ 6 + inPos] & 1048575L) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[ 7 + inPos] & 1048575L) >>> 16)) & 255);
      out[18 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[ 7 + inPos] & 1048575L) >>> 8)) & 255);
      out[19 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[ 7 + inPos] & 1048575L))) & 255);
      out[20 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[ 8 + inPos] & 1048575L) >>> 12)) & 255);
      out[21 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[ 8 + inPos] & 1048575L) >>> 4)) & 255);
      out[22 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[ 8 + inPos] & 1048575L) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[ 9 + inPos] & 1048575L) >>> 16)) & 255);
      out[23 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[ 9 + inPos] & 1048575L) >>> 8)) & 255);
      out[24 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[ 9 + inPos] & 1048575L))) & 255);
      out[25 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[10 + inPos] & 1048575L) >>> 12)) & 255);
      out[26 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[10 + inPos] & 1048575L) >>> 4)) & 255);
      out[27 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[10 + inPos] & 1048575L) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[11 + inPos] & 1048575L) >>> 16)) & 255);
      out[28 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[11 + inPos] & 1048575L) >>> 8)) & 255);
      out[29 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[11 + inPos] & 1048575L))) & 255);
      out[30 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[12 + inPos] & 1048575L) >>> 12)) & 255);
      out[31 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[12 + inPos] & 1048575L) >>> 4)) & 255);
      out[32 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[12 + inPos] & 1048575L) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[13 + inPos] & 1048575L) >>> 16)) & 255);
      out[33 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[13 + inPos] & 1048575L) >>> 8)) & 255);
      out[34 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[13 + inPos] & 1048575L))) & 255);
      out[35 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[14 + inPos] & 1048575L) >>> 12)) & 255);
      out[36 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[14 + inPos] & 1048575L) >>> 4)) & 255);
      out[37 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[14 + inPos] & 1048575L) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[15 + inPos] & 1048575L) >>> 16)) & 255);
      out[38 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[15 + inPos] & 1048575L) >>> 8)) & 255);
      out[39 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[15 + inPos] & 1048575L))) & 255);
      out[40 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[16 + inPos] & 1048575L) >>> 12)) & 255);
      out[41 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[16 + inPos] & 1048575L) >>> 4)) & 255);
      out[42 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[16 + inPos] & 1048575L) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[17 + inPos] & 1048575L) >>> 16)) & 255);
      out[43 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[17 + inPos] & 1048575L) >>> 8)) & 255);
      out[44 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[17 + inPos] & 1048575L))) & 255);
      out[45 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[18 + inPos] & 1048575L) >>> 12)) & 255);
      out[46 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[18 + inPos] & 1048575L) >>> 4)) & 255);
      out[47 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[18 + inPos] & 1048575L) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[19 + inPos] & 1048575L) >>> 16)) & 255);
      out[48 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[19 + inPos] & 1048575L) >>> 8)) & 255);
      out[49 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[19 + inPos] & 1048575L))) & 255);
      out[50 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[20 + inPos] & 1048575L) >>> 12)) & 255);
      out[51 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[20 + inPos] & 1048575L) >>> 4)) & 255);
      out[52 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[20 + inPos] & 1048575L) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[21 + inPos] & 1048575L) >>> 16)) & 255);
      out[53 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[21 + inPos] & 1048575L) >>> 8)) & 255);
      out[54 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[21 + inPos] & 1048575L))) & 255);
      out[55 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[22 + inPos] & 1048575L) >>> 12)) & 255);
      out[56 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[22 + inPos] & 1048575L) >>> 4)) & 255);
      out[57 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[22 + inPos] & 1048575L) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[23 + inPos] & 1048575L) >>> 16)) & 255);
      out[58 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[23 + inPos] & 1048575L) >>> 8)) & 255);
      out[59 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[23 + inPos] & 1048575L))) & 255);
      out[60 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[24 + inPos] & 1048575L) >>> 12)) & 255);
      out[61 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[24 + inPos] & 1048575L) >>> 4)) & 255);
      out[62 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[24 + inPos] & 1048575L) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[25 + inPos] & 1048575L) >>> 16)) & 255);
      out[63 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[25 + inPos] & 1048575L) >>> 8)) & 255);
      out[64 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[25 + inPos] & 1048575L))) & 255);
      out[65 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[26 + inPos] & 1048575L) >>> 12)) & 255);
      out[66 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[26 + inPos] & 1048575L) >>> 4)) & 255);
      out[67 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[26 + inPos] & 1048575L) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[27 + inPos] & 1048575L) >>> 16)) & 255);
      out[68 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[27 + inPos] & 1048575L) >>> 8)) & 255);
      out[69 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[27 + inPos] & 1048575L))) & 255);
      out[70 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[28 + inPos] & 1048575L) >>> 12)) & 255);
      out[71 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[28 + inPos] & 1048575L) >>> 4)) & 255);
      out[72 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[28 + inPos] & 1048575L) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[29 + inPos] & 1048575L) >>> 16)) & 255);
      out[73 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[29 + inPos] & 1048575L) >>> 8)) & 255);
      out[74 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[29 + inPos] & 1048575L))) & 255);
      out[75 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[30 + inPos] & 1048575L) >>> 12)) & 255);
      out[76 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[30 + inPos] & 1048575L) >>> 4)) & 255);
      out[77 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[30 + inPos] & 1048575L) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[31 + inPos] & 1048575L) >>> 16)) & 255);
      out[78 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[31 + inPos] & 1048575L) >>> 8)) & 255);
      out[79 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[31 + inPos] & 1048575L))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in[ 0 + inPos]) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[ 1 + inPos]) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in[ 2 + inPos]) >>  4) & 15L);
      out[ 1 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in[ 2 + inPos]) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[ 3 + inPos]) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in[ 4 + inPos]) ) & 255L);
      out[ 2 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in[ 5 + inPos]) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[ 6 + inPos]) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in[ 7 + inPos]) >>  4) & 15L);
      out[ 3 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in[ 7 + inPos]) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[ 8 + inPos]) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in[ 9 + inPos]) ) & 255L);
      out[ 4 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in[10 + inPos]) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[11 + inPos]) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in[12 + inPos]) >>  4) & 15L);
      out[ 5 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in[12 + inPos]) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[13 + inPos]) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in[14 + inPos]) ) & 255L);
      out[ 6 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in[15 + inPos]) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[16 + inPos]) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in[17 + inPos]) >>  4) & 15L);
      out[ 7 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in[17 + inPos]) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[18 + inPos]) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in[19 + inPos]) ) & 255L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get( 0 + inPos)) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get( 1 + inPos)) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in.get( 2 + inPos)) >>  4) & 15L);
      out[ 1 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get( 2 + inPos)) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get( 3 + inPos)) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get( 4 + inPos)) ) & 255L);
      out[ 2 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get( 5 + inPos)) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get( 6 + inPos)) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in.get( 7 + inPos)) >>  4) & 15L);
      out[ 3 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get( 7 + inPos)) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get( 8 + inPos)) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get( 9 + inPos)) ) & 255L);
      out[ 4 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get(10 + inPos)) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get(11 + inPos)) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in.get(12 + inPos)) >>  4) & 15L);
      out[ 5 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get(12 + inPos)) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get(13 + inPos)) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get(14 + inPos)) ) & 255L);
      out[ 6 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get(15 + inPos)) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get(16 + inPos)) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in.get(17 + inPos)) >>  4) & 15L);
      out[ 7 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get(17 + inPos)) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get(18 + inPos)) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get(19 + inPos)) ) & 255L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in[ 0 + inPos]) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[ 1 + inPos]) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in[ 2 + inPos]) >>  4) & 15L);
      out[ 1 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in[ 2 + inPos]) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[ 3 + inPos]) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in[ 4 + inPos]) ) & 255L);
      out[ 2 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in[ 5 + inPos]) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[ 6 + inPos]) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in[ 7 + inPos]) >>  4) & 15L);
      out[ 3 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in[ 7 + inPos]) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[ 8 + inPos]) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in[ 9 + inPos]) ) & 255L);
      out[ 4 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in[10 + inPos]) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[11 + inPos]) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in[12 + inPos]) >>  4) & 15L);
      out[ 5 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in[12 + inPos]) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[13 + inPos]) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in[14 + inPos]) ) & 255L);
      out[ 6 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in[15 + inPos]) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[16 + inPos]) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in[17 + inPos]) >>  4) & 15L);
      out[ 7 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in[17 + inPos]) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[18 + inPos]) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in[19 + inPos]) ) & 255L);
      out[ 8 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in[20 + inPos]) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[21 + inPos]) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in[22 + inPos]) >>  4) & 15L);
      out[ 9 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in[22 + inPos]) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[23 + inPos]) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in[24 + inPos]) ) & 255L);
      out[10 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in[25 + inPos]) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[26 + inPos]) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in[27 + inPos]) >>  4) & 15L);
      out[11 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in[27 + inPos]) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[28 + inPos]) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in[29 + inPos]) ) & 255L);
      out[12 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in[30 + inPos]) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[31 + inPos]) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in[32 + inPos]) >>  4) & 15L);
      out[13 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in[32 + inPos]) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[33 + inPos]) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in[34 + inPos]) ) & 255L);
      out[14 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in[35 + inPos]) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[36 + inPos]) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in[37 + inPos]) >>  4) & 15L);
      out[15 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in[37 + inPos]) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[38 + inPos]) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in[39 + inPos]) ) & 255L);
      out[16 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in[40 + inPos]) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[41 + inPos]) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in[42 + inPos]) >>  4) & 15L);
      out[17 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in[42 + inPos]) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[43 + inPos]) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in[44 + inPos]) ) & 255L);
      out[18 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in[45 + inPos]) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[46 + inPos]) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in[47 + inPos]) >>  4) & 15L);
      out[19 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in[47 + inPos]) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[48 + inPos]) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in[49 + inPos]) ) & 255L);
      out[20 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in[50 + inPos]) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[51 + inPos]) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in[52 + inPos]) >>  4) & 15L);
      out[21 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in[52 + inPos]) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[53 + inPos]) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in[54 + inPos]) ) & 255L);
      out[22 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in[55 + inPos]) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[56 + inPos]) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in[57 + inPos]) >>  4) & 15L);
      out[23 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in[57 + inPos]) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[58 + inPos]) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in[59 + inPos]) ) & 255L);
      out[24 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in[60 + inPos]) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[61 + inPos]) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in[62 + inPos]) >>  4) & 15L);
      out[25 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in[62 + inPos]) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[63 + inPos]) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in[64 + inPos]) ) & 255L);
      out[26 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in[65 + inPos]) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[66 + inPos]) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in[67 + inPos]) >>  4) & 15L);
      out[27 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in[67 + inPos]) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[68 + inPos]) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in[69 + inPos]) ) & 255L);
      out[28 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in[70 + inPos]) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[71 + inPos]) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in[72 + inPos]) >>  4) & 15L);
      out[29 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in[72 + inPos]) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[73 + inPos]) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in[74 + inPos]) ) & 255L);
      out[30 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in[75 + inPos]) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in[76 + inPos]) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in[77 + inPos]) >>  4) & 15L);
      out[31 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in[77 + inPos]) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in[78 + inPos]) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in[79 + inPos]) ) & 255L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get( 0 + inPos)) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get( 1 + inPos)) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in.get( 2 + inPos)) >>  4) & 15L);
      out[ 1 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get( 2 + inPos)) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get( 3 + inPos)) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get( 4 + inPos)) ) & 255L);
      out[ 2 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get( 5 + inPos)) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get( 6 + inPos)) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in.get( 7 + inPos)) >>  4) & 15L);
      out[ 3 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get( 7 + inPos)) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get( 8 + inPos)) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get( 9 + inPos)) ) & 255L);
      out[ 4 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get(10 + inPos)) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get(11 + inPos)) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in.get(12 + inPos)) >>  4) & 15L);
      out[ 5 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get(12 + inPos)) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get(13 + inPos)) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get(14 + inPos)) ) & 255L);
      out[ 6 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get(15 + inPos)) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get(16 + inPos)) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in.get(17 + inPos)) >>  4) & 15L);
      out[ 7 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get(17 + inPos)) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get(18 + inPos)) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get(19 + inPos)) ) & 255L);
      out[ 8 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get(20 + inPos)) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get(21 + inPos)) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in.get(22 + inPos)) >>  4) & 15L);
      out[ 9 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get(22 + inPos)) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get(23 + inPos)) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get(24 + inPos)) ) & 255L);
      out[10 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get(25 + inPos)) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get(26 + inPos)) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in.get(27 + inPos)) >>  4) & 15L);
      out[11 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get(27 + inPos)) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get(28 + inPos)) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get(29 + inPos)) ) & 255L);
      out[12 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get(30 + inPos)) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get(31 + inPos)) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in.get(32 + inPos)) >>  4) & 15L);
      out[13 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get(32 + inPos)) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get(33 + inPos)) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get(34 + inPos)) ) & 255L);
      out[14 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get(35 + inPos)) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get(36 + inPos)) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in.get(37 + inPos)) >>  4) & 15L);
      out[15 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get(37 + inPos)) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get(38 + inPos)) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get(39 + inPos)) ) & 255L);
      out[16 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get(40 + inPos)) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get(41 + inPos)) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in.get(42 + inPos)) >>  4) & 15L);
      out[17 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get(42 + inPos)) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get(43 + inPos)) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get(44 + inPos)) ) & 255L);
      out[18 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get(45 + inPos)) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get(46 + inPos)) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in.get(47 + inPos)) >>  4) & 15L);
      out[19 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get(47 + inPos)) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get(48 + inPos)) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get(49 + inPos)) ) & 255L);
      out[20 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get(50 + inPos)) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get(51 + inPos)) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in.get(52 + inPos)) >>  4) & 15L);
      out[21 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get(52 + inPos)) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get(53 + inPos)) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get(54 + inPos)) ) & 255L);
      out[22 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get(55 + inPos)) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get(56 + inPos)) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in.get(57 + inPos)) >>  4) & 15L);
      out[23 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get(57 + inPos)) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get(58 + inPos)) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get(59 + inPos)) ) & 255L);
      out[24 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get(60 + inPos)) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get(61 + inPos)) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in.get(62 + inPos)) >>  4) & 15L);
      out[25 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get(62 + inPos)) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get(63 + inPos)) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get(64 + inPos)) ) & 255L);
      out[26 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get(65 + inPos)) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get(66 + inPos)) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in.get(67 + inPos)) >>  4) & 15L);
      out[27 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get(67 + inPos)) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get(68 + inPos)) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get(69 + inPos)) ) & 255L);
      out[28 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get(70 + inPos)) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get(71 + inPos)) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in.get(72 + inPos)) >>  4) & 15L);
      out[29 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get(72 + inPos)) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get(73 + inPos)) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get(74 + inPos)) ) & 255L);
      out[30 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            ((((long)in.get(75 + inPos)) <<  12) & 1048575L)
        | //                              [76543210]
          //                      [________10987654____]
            ((((long)in.get(76 + inPos)) <<  4) & 4095L)
        | //                              [7654____]
          //              [________________3210]
            ((((long)in.get(77 + inPos)) >>  4) & 15L);
      out[31 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            ((((long)in.get(77 + inPos)) <<  16) & 1048575L)
        | //                              [76543210]
          //                          [____54321098________]
            ((((long)in.get(78 + inPos)) <<  8) & 65535L)
        | //                              [76543210]
          //                  [____________76543210]
            ((((long)in.get(79 + inPos)) ) & 255L);
    }
  }

  private static final class Packer21 extends BytePackerForLong {

    private Packer21() {
      super(21);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                               [76543210]
          //                               [09876543_____________]
           ((in[ 0 + inPos] & 2097151L) >>> 13)) & 255);
      out[ 1 + outPos] = (byte)((
          //                               [76543210]
          //                       [________21098765_____]
           ((in[ 0 + inPos] & 2097151L) >>> 5)) & 255);
      out[ 2 + outPos] = (byte)((
          //                               [76543___]
          //               [________________43210]
           ((in[ 0 + inPos] & 2097151L) <<  3)
        | //                               [_____210]
          //                                    [098__________________]
           ((in[ 1 + inPos] & 2097151L) >>> 18)) & 255);
      out[ 3 + outPos] = (byte)((
          //                               [76543210]
          //                            [___76543210__________]
           ((in[ 1 + inPos] & 2097151L) >>> 10)) & 255);
      out[ 4 + outPos] = (byte)((
          //                               [76543210]
          //                    [___________98765432__]
           ((in[ 1 + inPos] & 2097151L) >>> 2)) & 255);
      out[ 5 + outPos] = (byte)((
          //                               [76______]
          //            [___________________10]
           ((in[ 1 + inPos] & 2097151L) <<  6)
        | //                               [__543210]
          //                                 [098765_______________]
           ((in[ 2 + inPos] & 2097151L) >>> 15)) & 255);
      out[ 6 + outPos] = (byte)((
          //                               [76543210]
          //                         [______43210987_______]
           ((in[ 2 + inPos] & 2097151L) >>> 7)) & 255);
      out[ 7 + outPos] = (byte)((
          //                               [7654321_]
          //                 [______________6543210]
           ((in[ 2 + inPos] & 2097151L) <<  1)
        | //                               [_______0]
          //                                      [0____________________]
           ((in[ 3 + inPos] & 2097151L) >>> 20)) & 255);
      out[ 8 + outPos] = (byte)((
          //                               [76543210]
          //                              [_98765432____________]
           ((in[ 3 + inPos] & 2097151L) >>> 12)) & 255);
      out[ 9 + outPos] = (byte)((
          //                               [76543210]
          //                      [_________10987654____]
           ((in[ 3 + inPos] & 2097151L) >>> 4)) & 255);
      out[10 + outPos] = (byte)((
          //                               [7654____]
          //              [_________________3210]
           ((in[ 3 + inPos] & 2097151L) <<  4)
        | //                               [____3210]
          //                                   [0987_________________]
           ((in[ 4 + inPos] & 2097151L) >>> 17)) & 255);
      out[11 + outPos] = (byte)((
          //                               [76543210]
          //                           [____65432109_________]
           ((in[ 4 + inPos] & 2097151L) >>> 9)) & 255);
      out[12 + outPos] = (byte)((
          //                               [76543210]
          //                   [____________87654321_]
           ((in[ 4 + inPos] & 2097151L) >>> 1)) & 255);
      out[13 + outPos] = (byte)((
          //                               [7_______]
          //           [____________________0]
           ((in[ 4 + inPos] & 2097151L) <<  7)
        | //                               [_6543210]
          //                                [0987654______________]
           ((in[ 5 + inPos] & 2097151L) >>> 14)) & 255);
      out[14 + outPos] = (byte)((
          //                               [76543210]
          //                        [_______32109876______]
           ((in[ 5 + inPos] & 2097151L) >>> 6)) & 255);
      out[15 + outPos] = (byte)((
          //                               [765432__]
          //                [_______________543210]
           ((in[ 5 + inPos] & 2097151L) <<  2)
        | //                               [______10]
          //                                     [09___________________]
           ((in[ 6 + inPos] & 2097151L) >>> 19)) & 255);
      out[16 + outPos] = (byte)((
          //                               [76543210]
          //                             [__87654321___________]
           ((in[ 6 + inPos] & 2097151L) >>> 11)) & 255);
      out[17 + outPos] = (byte)((
          //                               [76543210]
          //                     [__________09876543___]
           ((in[ 6 + inPos] & 2097151L) >>> 3)) & 255);
      out[18 + outPos] = (byte)((
          //                               [765_____]
          //             [__________________210]
           ((in[ 6 + inPos] & 2097151L) <<  5)
        | //                               [___43210]
          //                                  [09876________________]
           ((in[ 7 + inPos] & 2097151L) >>> 16)) & 255);
      out[19 + outPos] = (byte)((
          //                               [76543210]
          //                          [_____54321098________]
           ((in[ 7 + inPos] & 2097151L) >>> 8)) & 255);
      out[20 + outPos] = (byte)((
          //                               [76543210]
          //                  [_____________76543210]
           ((in[ 7 + inPos] & 2097151L))) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                               [76543210]
          //                               [09876543_____________]
           ((in[ 0 + inPos] & 2097151L) >>> 13)) & 255);
      out[ 1 + outPos] = (byte)((
          //                               [76543210]
          //                       [________21098765_____]
           ((in[ 0 + inPos] & 2097151L) >>> 5)) & 255);
      out[ 2 + outPos] = (byte)((
          //                               [76543___]
          //               [________________43210]
           ((in[ 0 + inPos] & 2097151L) <<  3)
        | //                               [_____210]
          //                                    [098__________________]
           ((in[ 1 + inPos] & 2097151L) >>> 18)) & 255);
      out[ 3 + outPos] = (byte)((
          //                               [76543210]
          //                            [___76543210__________]
           ((in[ 1 + inPos] & 2097151L) >>> 10)) & 255);
      out[ 4 + outPos] = (byte)((
          //                               [76543210]
          //                    [___________98765432__]
           ((in[ 1 + inPos] & 2097151L) >>> 2)) & 255);
      out[ 5 + outPos] = (byte)((
          //                               [76______]
          //            [___________________10]
           ((in[ 1 + inPos] & 2097151L) <<  6)
        | //                               [__543210]
          //                                 [098765_______________]
           ((in[ 2 + inPos] & 2097151L) >>> 15)) & 255);
      out[ 6 + outPos] = (byte)((
          //                               [76543210]
          //                         [______43210987_______]
           ((in[ 2 + inPos] & 2097151L) >>> 7)) & 255);
      out[ 7 + outPos] = (byte)((
          //                               [7654321_]
          //                 [______________6543210]
           ((in[ 2 + inPos] & 2097151L) <<  1)
        | //                               [_______0]
          //                                      [0____________________]
           ((in[ 3 + inPos] & 2097151L) >>> 20)) & 255);
      out[ 8 + outPos] = (byte)((
          //                               [76543210]
          //                              [_98765432____________]
           ((in[ 3 + inPos] & 2097151L) >>> 12)) & 255);
      out[ 9 + outPos] = (byte)((
          //                               [76543210]
          //                      [_________10987654____]
           ((in[ 3 + inPos] & 2097151L) >>> 4)) & 255);
      out[10 + outPos] = (byte)((
          //                               [7654____]
          //              [_________________3210]
           ((in[ 3 + inPos] & 2097151L) <<  4)
        | //                               [____3210]
          //                                   [0987_________________]
           ((in[ 4 + inPos] & 2097151L) >>> 17)) & 255);
      out[11 + outPos] = (byte)((
          //                               [76543210]
          //                           [____65432109_________]
           ((in[ 4 + inPos] & 2097151L) >>> 9)) & 255);
      out[12 + outPos] = (byte)((
          //                               [76543210]
          //                   [____________87654321_]
           ((in[ 4 + inPos] & 2097151L) >>> 1)) & 255);
      out[13 + outPos] = (byte)((
          //                               [7_______]
          //           [____________________0]
           ((in[ 4 + inPos] & 2097151L) <<  7)
        | //                               [_6543210]
          //                                [0987654______________]
           ((in[ 5 + inPos] & 2097151L) >>> 14)) & 255);
      out[14 + outPos] = (byte)((
          //                               [76543210]
          //                        [_______32109876______]
           ((in[ 5 + inPos] & 2097151L) >>> 6)) & 255);
      out[15 + outPos] = (byte)((
          //                               [765432__]
          //                [_______________543210]
           ((in[ 5 + inPos] & 2097151L) <<  2)
        | //                               [______10]
          //                                     [09___________________]
           ((in[ 6 + inPos] & 2097151L) >>> 19)) & 255);
      out[16 + outPos] = (byte)((
          //                               [76543210]
          //                             [__87654321___________]
           ((in[ 6 + inPos] & 2097151L) >>> 11)) & 255);
      out[17 + outPos] = (byte)((
          //                               [76543210]
          //                     [__________09876543___]
           ((in[ 6 + inPos] & 2097151L) >>> 3)) & 255);
      out[18 + outPos] = (byte)((
          //                               [765_____]
          //             [__________________210]
           ((in[ 6 + inPos] & 2097151L) <<  5)
        | //                               [___43210]
          //                                  [09876________________]
           ((in[ 7 + inPos] & 2097151L) >>> 16)) & 255);
      out[19 + outPos] = (byte)((
          //                               [76543210]
          //                          [_____54321098________]
           ((in[ 7 + inPos] & 2097151L) >>> 8)) & 255);
      out[20 + outPos] = (byte)((
          //                               [76543210]
          //                  [_____________76543210]
           ((in[ 7 + inPos] & 2097151L))) & 255);
      out[21 + outPos] = (byte)((
          //                               [76543210]
          //                               [09876543_____________]
           ((in[ 8 + inPos] & 2097151L) >>> 13)) & 255);
      out[22 + outPos] = (byte)((
          //                               [76543210]
          //                       [________21098765_____]
           ((in[ 8 + inPos] & 2097151L) >>> 5)) & 255);
      out[23 + outPos] = (byte)((
          //                               [76543___]
          //               [________________43210]
           ((in[ 8 + inPos] & 2097151L) <<  3)
        | //                               [_____210]
          //                                    [098__________________]
           ((in[ 9 + inPos] & 2097151L) >>> 18)) & 255);
      out[24 + outPos] = (byte)((
          //                               [76543210]
          //                            [___76543210__________]
           ((in[ 9 + inPos] & 2097151L) >>> 10)) & 255);
      out[25 + outPos] = (byte)((
          //                               [76543210]
          //                    [___________98765432__]
           ((in[ 9 + inPos] & 2097151L) >>> 2)) & 255);
      out[26 + outPos] = (byte)((
          //                               [76______]
          //            [___________________10]
           ((in[ 9 + inPos] & 2097151L) <<  6)
        | //                               [__543210]
          //                                 [098765_______________]
           ((in[10 + inPos] & 2097151L) >>> 15)) & 255);
      out[27 + outPos] = (byte)((
          //                               [76543210]
          //                         [______43210987_______]
           ((in[10 + inPos] & 2097151L) >>> 7)) & 255);
      out[28 + outPos] = (byte)((
          //                               [7654321_]
          //                 [______________6543210]
           ((in[10 + inPos] & 2097151L) <<  1)
        | //                               [_______0]
          //                                      [0____________________]
           ((in[11 + inPos] & 2097151L) >>> 20)) & 255);
      out[29 + outPos] = (byte)((
          //                               [76543210]
          //                              [_98765432____________]
           ((in[11 + inPos] & 2097151L) >>> 12)) & 255);
      out[30 + outPos] = (byte)((
          //                               [76543210]
          //                      [_________10987654____]
           ((in[11 + inPos] & 2097151L) >>> 4)) & 255);
      out[31 + outPos] = (byte)((
          //                               [7654____]
          //              [_________________3210]
           ((in[11 + inPos] & 2097151L) <<  4)
        | //                               [____3210]
          //                                   [0987_________________]
           ((in[12 + inPos] & 2097151L) >>> 17)) & 255);
      out[32 + outPos] = (byte)((
          //                               [76543210]
          //                           [____65432109_________]
           ((in[12 + inPos] & 2097151L) >>> 9)) & 255);
      out[33 + outPos] = (byte)((
          //                               [76543210]
          //                   [____________87654321_]
           ((in[12 + inPos] & 2097151L) >>> 1)) & 255);
      out[34 + outPos] = (byte)((
          //                               [7_______]
          //           [____________________0]
           ((in[12 + inPos] & 2097151L) <<  7)
        | //                               [_6543210]
          //                                [0987654______________]
           ((in[13 + inPos] & 2097151L) >>> 14)) & 255);
      out[35 + outPos] = (byte)((
          //                               [76543210]
          //                        [_______32109876______]
           ((in[13 + inPos] & 2097151L) >>> 6)) & 255);
      out[36 + outPos] = (byte)((
          //                               [765432__]
          //                [_______________543210]
           ((in[13 + inPos] & 2097151L) <<  2)
        | //                               [______10]
          //                                     [09___________________]
           ((in[14 + inPos] & 2097151L) >>> 19)) & 255);
      out[37 + outPos] = (byte)((
          //                               [76543210]
          //                             [__87654321___________]
           ((in[14 + inPos] & 2097151L) >>> 11)) & 255);
      out[38 + outPos] = (byte)((
          //                               [76543210]
          //                     [__________09876543___]
           ((in[14 + inPos] & 2097151L) >>> 3)) & 255);
      out[39 + outPos] = (byte)((
          //                               [765_____]
          //             [__________________210]
           ((in[14 + inPos] & 2097151L) <<  5)
        | //                               [___43210]
          //                                  [09876________________]
           ((in[15 + inPos] & 2097151L) >>> 16)) & 255);
      out[40 + outPos] = (byte)((
          //                               [76543210]
          //                          [_____54321098________]
           ((in[15 + inPos] & 2097151L) >>> 8)) & 255);
      out[41 + outPos] = (byte)((
          //                               [76543210]
          //                  [_____________76543210]
           ((in[15 + inPos] & 2097151L))) & 255);
      out[42 + outPos] = (byte)((
          //                               [76543210]
          //                               [09876543_____________]
           ((in[16 + inPos] & 2097151L) >>> 13)) & 255);
      out[43 + outPos] = (byte)((
          //                               [76543210]
          //                       [________21098765_____]
           ((in[16 + inPos] & 2097151L) >>> 5)) & 255);
      out[44 + outPos] = (byte)((
          //                               [76543___]
          //               [________________43210]
           ((in[16 + inPos] & 2097151L) <<  3)
        | //                               [_____210]
          //                                    [098__________________]
           ((in[17 + inPos] & 2097151L) >>> 18)) & 255);
      out[45 + outPos] = (byte)((
          //                               [76543210]
          //                            [___76543210__________]
           ((in[17 + inPos] & 2097151L) >>> 10)) & 255);
      out[46 + outPos] = (byte)((
          //                               [76543210]
          //                    [___________98765432__]
           ((in[17 + inPos] & 2097151L) >>> 2)) & 255);
      out[47 + outPos] = (byte)((
          //                               [76______]
          //            [___________________10]
           ((in[17 + inPos] & 2097151L) <<  6)
        | //                               [__543210]
          //                                 [098765_______________]
           ((in[18 + inPos] & 2097151L) >>> 15)) & 255);
      out[48 + outPos] = (byte)((
          //                               [76543210]
          //                         [______43210987_______]
           ((in[18 + inPos] & 2097151L) >>> 7)) & 255);
      out[49 + outPos] = (byte)((
          //                               [7654321_]
          //                 [______________6543210]
           ((in[18 + inPos] & 2097151L) <<  1)
        | //                               [_______0]
          //                                      [0____________________]
           ((in[19 + inPos] & 2097151L) >>> 20)) & 255);
      out[50 + outPos] = (byte)((
          //                               [76543210]
          //                              [_98765432____________]
           ((in[19 + inPos] & 2097151L) >>> 12)) & 255);
      out[51 + outPos] = (byte)((
          //                               [76543210]
          //                      [_________10987654____]
           ((in[19 + inPos] & 2097151L) >>> 4)) & 255);
      out[52 + outPos] = (byte)((
          //                               [7654____]
          //              [_________________3210]
           ((in[19 + inPos] & 2097151L) <<  4)
        | //                               [____3210]
          //                                   [0987_________________]
           ((in[20 + inPos] & 2097151L) >>> 17)) & 255);
      out[53 + outPos] = (byte)((
          //                               [76543210]
          //                           [____65432109_________]
           ((in[20 + inPos] & 2097151L) >>> 9)) & 255);
      out[54 + outPos] = (byte)((
          //                               [76543210]
          //                   [____________87654321_]
           ((in[20 + inPos] & 2097151L) >>> 1)) & 255);
      out[55 + outPos] = (byte)((
          //                               [7_______]
          //           [____________________0]
           ((in[20 + inPos] & 2097151L) <<  7)
        | //                               [_6543210]
          //                                [0987654______________]
           ((in[21 + inPos] & 2097151L) >>> 14)) & 255);
      out[56 + outPos] = (byte)((
          //                               [76543210]
          //                        [_______32109876______]
           ((in[21 + inPos] & 2097151L) >>> 6)) & 255);
      out[57 + outPos] = (byte)((
          //                               [765432__]
          //                [_______________543210]
           ((in[21 + inPos] & 2097151L) <<  2)
        | //                               [______10]
          //                                     [09___________________]
           ((in[22 + inPos] & 2097151L) >>> 19)) & 255);
      out[58 + outPos] = (byte)((
          //                               [76543210]
          //                             [__87654321___________]
           ((in[22 + inPos] & 2097151L) >>> 11)) & 255);
      out[59 + outPos] = (byte)((
          //                               [76543210]
          //                     [__________09876543___]
           ((in[22 + inPos] & 2097151L) >>> 3)) & 255);
      out[60 + outPos] = (byte)((
          //                               [765_____]
          //             [__________________210]
           ((in[22 + inPos] & 2097151L) <<  5)
        | //                               [___43210]
          //                                  [09876________________]
           ((in[23 + inPos] & 2097151L) >>> 16)) & 255);
      out[61 + outPos] = (byte)((
          //                               [76543210]
          //                          [_____54321098________]
           ((in[23 + inPos] & 2097151L) >>> 8)) & 255);
      out[62 + outPos] = (byte)((
          //                               [76543210]
          //                  [_____________76543210]
           ((in[23 + inPos] & 2097151L))) & 255);
      out[63 + outPos] = (byte)((
          //                               [76543210]
          //                               [09876543_____________]
           ((in[24 + inPos] & 2097151L) >>> 13)) & 255);
      out[64 + outPos] = (byte)((
          //                               [76543210]
          //                       [________21098765_____]
           ((in[24 + inPos] & 2097151L) >>> 5)) & 255);
      out[65 + outPos] = (byte)((
          //                               [76543___]
          //               [________________43210]
           ((in[24 + inPos] & 2097151L) <<  3)
        | //                               [_____210]
          //                                    [098__________________]
           ((in[25 + inPos] & 2097151L) >>> 18)) & 255);
      out[66 + outPos] = (byte)((
          //                               [76543210]
          //                            [___76543210__________]
           ((in[25 + inPos] & 2097151L) >>> 10)) & 255);
      out[67 + outPos] = (byte)((
          //                               [76543210]
          //                    [___________98765432__]
           ((in[25 + inPos] & 2097151L) >>> 2)) & 255);
      out[68 + outPos] = (byte)((
          //                               [76______]
          //            [___________________10]
           ((in[25 + inPos] & 2097151L) <<  6)
        | //                               [__543210]
          //                                 [098765_______________]
           ((in[26 + inPos] & 2097151L) >>> 15)) & 255);
      out[69 + outPos] = (byte)((
          //                               [76543210]
          //                         [______43210987_______]
           ((in[26 + inPos] & 2097151L) >>> 7)) & 255);
      out[70 + outPos] = (byte)((
          //                               [7654321_]
          //                 [______________6543210]
           ((in[26 + inPos] & 2097151L) <<  1)
        | //                               [_______0]
          //                                      [0____________________]
           ((in[27 + inPos] & 2097151L) >>> 20)) & 255);
      out[71 + outPos] = (byte)((
          //                               [76543210]
          //                              [_98765432____________]
           ((in[27 + inPos] & 2097151L) >>> 12)) & 255);
      out[72 + outPos] = (byte)((
          //                               [76543210]
          //                      [_________10987654____]
           ((in[27 + inPos] & 2097151L) >>> 4)) & 255);
      out[73 + outPos] = (byte)((
          //                               [7654____]
          //              [_________________3210]
           ((in[27 + inPos] & 2097151L) <<  4)
        | //                               [____3210]
          //                                   [0987_________________]
           ((in[28 + inPos] & 2097151L) >>> 17)) & 255);
      out[74 + outPos] = (byte)((
          //                               [76543210]
          //                           [____65432109_________]
           ((in[28 + inPos] & 2097151L) >>> 9)) & 255);
      out[75 + outPos] = (byte)((
          //                               [76543210]
          //                   [____________87654321_]
           ((in[28 + inPos] & 2097151L) >>> 1)) & 255);
      out[76 + outPos] = (byte)((
          //                               [7_______]
          //           [____________________0]
           ((in[28 + inPos] & 2097151L) <<  7)
        | //                               [_6543210]
          //                                [0987654______________]
           ((in[29 + inPos] & 2097151L) >>> 14)) & 255);
      out[77 + outPos] = (byte)((
          //                               [76543210]
          //                        [_______32109876______]
           ((in[29 + inPos] & 2097151L) >>> 6)) & 255);
      out[78 + outPos] = (byte)((
          //                               [765432__]
          //                [_______________543210]
           ((in[29 + inPos] & 2097151L) <<  2)
        | //                               [______10]
          //                                     [09___________________]
           ((in[30 + inPos] & 2097151L) >>> 19)) & 255);
      out[79 + outPos] = (byte)((
          //                               [76543210]
          //                             [__87654321___________]
           ((in[30 + inPos] & 2097151L) >>> 11)) & 255);
      out[80 + outPos] = (byte)((
          //                               [76543210]
          //                     [__________09876543___]
           ((in[30 + inPos] & 2097151L) >>> 3)) & 255);
      out[81 + outPos] = (byte)((
          //                               [765_____]
          //             [__________________210]
           ((in[30 + inPos] & 2097151L) <<  5)
        | //                               [___43210]
          //                                  [09876________________]
           ((in[31 + inPos] & 2097151L) >>> 16)) & 255);
      out[82 + outPos] = (byte)((
          //                               [76543210]
          //                          [_____54321098________]
           ((in[31 + inPos] & 2097151L) >>> 8)) & 255);
      out[83 + outPos] = (byte)((
          //                               [76543210]
          //                  [_____________76543210]
           ((in[31 + inPos] & 2097151L))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                               [76543210]
          //                               [09876543_____________]
            ((((long)in[ 0 + inPos]) <<  13) & 2097151L)
        | //                               [76543210]
          //                       [________21098765_____]
            ((((long)in[ 1 + inPos]) <<  5) & 8191L)
        | //                               [76543___]
          //               [________________43210]
            ((((long)in[ 2 + inPos]) >>  3) & 31L);
      out[ 1 + outPos] =
          //                               [_____210]
          //                                    [098__________________]
            ((((long)in[ 2 + inPos]) <<  18) & 2097151L)
        | //                               [76543210]
          //                            [___76543210__________]
            ((((long)in[ 3 + inPos]) <<  10) & 262143L)
        | //                               [76543210]
          //                    [___________98765432__]
            ((((long)in[ 4 + inPos]) <<  2) & 1023L)
        | //                               [76______]
          //            [___________________10]
            ((((long)in[ 5 + inPos]) >>  6) & 3L);
      out[ 2 + outPos] =
          //                               [__543210]
          //                                 [098765_______________]
            ((((long)in[ 5 + inPos]) <<  15) & 2097151L)
        | //                               [76543210]
          //                         [______43210987_______]
            ((((long)in[ 6 + inPos]) <<  7) & 32767L)
        | //                               [7654321_]
          //                 [______________6543210]
            ((((long)in[ 7 + inPos]) >>  1) & 127L);
      out[ 3 + outPos] =
          //                               [_______0]
          //                                      [0____________________]
            ((((long)in[ 7 + inPos]) <<  20) & 2097151L)
        | //                               [76543210]
          //                              [_98765432____________]
            ((((long)in[ 8 + inPos]) <<  12) & 1048575L)
        | //                               [76543210]
          //                      [_________10987654____]
            ((((long)in[ 9 + inPos]) <<  4) & 4095L)
        | //                               [7654____]
          //              [_________________3210]
            ((((long)in[10 + inPos]) >>  4) & 15L);
      out[ 4 + outPos] =
          //                               [____3210]
          //                                   [0987_________________]
            ((((long)in[10 + inPos]) <<  17) & 2097151L)
        | //                               [76543210]
          //                           [____65432109_________]
            ((((long)in[11 + inPos]) <<  9) & 131071L)
        | //                               [76543210]
          //                   [____________87654321_]
            ((((long)in[12 + inPos]) <<  1) & 511L)
        | //                               [7_______]
          //           [____________________0]
            ((((long)in[13 + inPos]) >>  7) & 1L);
      out[ 5 + outPos] =
          //                               [_6543210]
          //                                [0987654______________]
            ((((long)in[13 + inPos]) <<  14) & 2097151L)
        | //                               [76543210]
          //                        [_______32109876______]
            ((((long)in[14 + inPos]) <<  6) & 16383L)
        | //                               [765432__]
          //                [_______________543210]
            ((((long)in[15 + inPos]) >>  2) & 63L);
      out[ 6 + outPos] =
          //                               [______10]
          //                                     [09___________________]
            ((((long)in[15 + inPos]) <<  19) & 2097151L)
        | //                               [76543210]
          //                             [__87654321___________]
            ((((long)in[16 + inPos]) <<  11) & 524287L)
        | //                               [76543210]
          //                     [__________09876543___]
            ((((long)in[17 + inPos]) <<  3) & 2047L)
        | //                               [765_____]
          //             [__________________210]
            ((((long)in[18 + inPos]) >>  5) & 7L);
      out[ 7 + outPos] =
          //                               [___43210]
          //                                  [09876________________]
            ((((long)in[18 + inPos]) <<  16) & 2097151L)
        | //                               [76543210]
          //                          [_____54321098________]
            ((((long)in[19 + inPos]) <<  8) & 65535L)
        | //                               [76543210]
          //                  [_____________76543210]
            ((((long)in[20 + inPos]) ) & 255L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                               [76543210]
          //                               [09876543_____________]
            ((((long)in.get( 0 + inPos)) <<  13) & 2097151L)
        | //                               [76543210]
          //                       [________21098765_____]
            ((((long)in.get( 1 + inPos)) <<  5) & 8191L)
        | //                               [76543___]
          //               [________________43210]
            ((((long)in.get( 2 + inPos)) >>  3) & 31L);
      out[ 1 + outPos] =
          //                               [_____210]
          //                                    [098__________________]
            ((((long)in.get( 2 + inPos)) <<  18) & 2097151L)
        | //                               [76543210]
          //                            [___76543210__________]
            ((((long)in.get( 3 + inPos)) <<  10) & 262143L)
        | //                               [76543210]
          //                    [___________98765432__]
            ((((long)in.get( 4 + inPos)) <<  2) & 1023L)
        | //                               [76______]
          //            [___________________10]
            ((((long)in.get( 5 + inPos)) >>  6) & 3L);
      out[ 2 + outPos] =
          //                               [__543210]
          //                                 [098765_______________]
            ((((long)in.get( 5 + inPos)) <<  15) & 2097151L)
        | //                               [76543210]
          //                         [______43210987_______]
            ((((long)in.get( 6 + inPos)) <<  7) & 32767L)
        | //                               [7654321_]
          //                 [______________6543210]
            ((((long)in.get( 7 + inPos)) >>  1) & 127L);
      out[ 3 + outPos] =
          //                               [_______0]
          //                                      [0____________________]
            ((((long)in.get( 7 + inPos)) <<  20) & 2097151L)
        | //                               [76543210]
          //                              [_98765432____________]
            ((((long)in.get( 8 + inPos)) <<  12) & 1048575L)
        | //                               [76543210]
          //                      [_________10987654____]
            ((((long)in.get( 9 + inPos)) <<  4) & 4095L)
        | //                               [7654____]
          //              [_________________3210]
            ((((long)in.get(10 + inPos)) >>  4) & 15L);
      out[ 4 + outPos] =
          //                               [____3210]
          //                                   [0987_________________]
            ((((long)in.get(10 + inPos)) <<  17) & 2097151L)
        | //                               [76543210]
          //                           [____65432109_________]
            ((((long)in.get(11 + inPos)) <<  9) & 131071L)
        | //                               [76543210]
          //                   [____________87654321_]
            ((((long)in.get(12 + inPos)) <<  1) & 511L)
        | //                               [7_______]
          //           [____________________0]
            ((((long)in.get(13 + inPos)) >>  7) & 1L);
      out[ 5 + outPos] =
          //                               [_6543210]
          //                                [0987654______________]
            ((((long)in.get(13 + inPos)) <<  14) & 2097151L)
        | //                               [76543210]
          //                        [_______32109876______]
            ((((long)in.get(14 + inPos)) <<  6) & 16383L)
        | //                               [765432__]
          //                [_______________543210]
            ((((long)in.get(15 + inPos)) >>  2) & 63L);
      out[ 6 + outPos] =
          //                               [______10]
          //                                     [09___________________]
            ((((long)in.get(15 + inPos)) <<  19) & 2097151L)
        | //                               [76543210]
          //                             [__87654321___________]
            ((((long)in.get(16 + inPos)) <<  11) & 524287L)
        | //                               [76543210]
          //                     [__________09876543___]
            ((((long)in.get(17 + inPos)) <<  3) & 2047L)
        | //                               [765_____]
          //             [__________________210]
            ((((long)in.get(18 + inPos)) >>  5) & 7L);
      out[ 7 + outPos] =
          //                               [___43210]
          //                                  [09876________________]
            ((((long)in.get(18 + inPos)) <<  16) & 2097151L)
        | //                               [76543210]
          //                          [_____54321098________]
            ((((long)in.get(19 + inPos)) <<  8) & 65535L)
        | //                               [76543210]
          //                  [_____________76543210]
            ((((long)in.get(20 + inPos)) ) & 255L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                               [76543210]
          //                               [09876543_____________]
            ((((long)in[ 0 + inPos]) <<  13) & 2097151L)
        | //                               [76543210]
          //                       [________21098765_____]
            ((((long)in[ 1 + inPos]) <<  5) & 8191L)
        | //                               [76543___]
          //               [________________43210]
            ((((long)in[ 2 + inPos]) >>  3) & 31L);
      out[ 1 + outPos] =
          //                               [_____210]
          //                                    [098__________________]
            ((((long)in[ 2 + inPos]) <<  18) & 2097151L)
        | //                               [76543210]
          //                            [___76543210__________]
            ((((long)in[ 3 + inPos]) <<  10) & 262143L)
        | //                               [76543210]
          //                    [___________98765432__]
            ((((long)in[ 4 + inPos]) <<  2) & 1023L)
        | //                               [76______]
          //            [___________________10]
            ((((long)in[ 5 + inPos]) >>  6) & 3L);
      out[ 2 + outPos] =
          //                               [__543210]
          //                                 [098765_______________]
            ((((long)in[ 5 + inPos]) <<  15) & 2097151L)
        | //                               [76543210]
          //                         [______43210987_______]
            ((((long)in[ 6 + inPos]) <<  7) & 32767L)
        | //                               [7654321_]
          //                 [______________6543210]
            ((((long)in[ 7 + inPos]) >>  1) & 127L);
      out[ 3 + outPos] =
          //                               [_______0]
          //                                      [0____________________]
            ((((long)in[ 7 + inPos]) <<  20) & 2097151L)
        | //                               [76543210]
          //                              [_98765432____________]
            ((((long)in[ 8 + inPos]) <<  12) & 1048575L)
        | //                               [76543210]
          //                      [_________10987654____]
            ((((long)in[ 9 + inPos]) <<  4) & 4095L)
        | //                               [7654____]
          //              [_________________3210]
            ((((long)in[10 + inPos]) >>  4) & 15L);
      out[ 4 + outPos] =
          //                               [____3210]
          //                                   [0987_________________]
            ((((long)in[10 + inPos]) <<  17) & 2097151L)
        | //                               [76543210]
          //                           [____65432109_________]
            ((((long)in[11 + inPos]) <<  9) & 131071L)
        | //                               [76543210]
          //                   [____________87654321_]
            ((((long)in[12 + inPos]) <<  1) & 511L)
        | //                               [7_______]
          //           [____________________0]
            ((((long)in[13 + inPos]) >>  7) & 1L);
      out[ 5 + outPos] =
          //                               [_6543210]
          //                                [0987654______________]
            ((((long)in[13 + inPos]) <<  14) & 2097151L)
        | //                               [76543210]
          //                        [_______32109876______]
            ((((long)in[14 + inPos]) <<  6) & 16383L)
        | //                               [765432__]
          //                [_______________543210]
            ((((long)in[15 + inPos]) >>  2) & 63L);
      out[ 6 + outPos] =
          //                               [______10]
          //                                     [09___________________]
            ((((long)in[15 + inPos]) <<  19) & 2097151L)
        | //                               [76543210]
          //                             [__87654321___________]
            ((((long)in[16 + inPos]) <<  11) & 524287L)
        | //                               [76543210]
          //                     [__________09876543___]
            ((((long)in[17 + inPos]) <<  3) & 2047L)
        | //                               [765_____]
          //             [__________________210]
            ((((long)in[18 + inPos]) >>  5) & 7L);
      out[ 7 + outPos] =
          //                               [___43210]
          //                                  [09876________________]
            ((((long)in[18 + inPos]) <<  16) & 2097151L)
        | //                               [76543210]
          //                          [_____54321098________]
            ((((long)in[19 + inPos]) <<  8) & 65535L)
        | //                               [76543210]
          //                  [_____________76543210]
            ((((long)in[20 + inPos]) ) & 255L);
      out[ 8 + outPos] =
          //                               [76543210]
          //                               [09876543_____________]
            ((((long)in[21 + inPos]) <<  13) & 2097151L)
        | //                               [76543210]
          //                       [________21098765_____]
            ((((long)in[22 + inPos]) <<  5) & 8191L)
        | //                               [76543___]
          //               [________________43210]
            ((((long)in[23 + inPos]) >>  3) & 31L);
      out[ 9 + outPos] =
          //                               [_____210]
          //                                    [098__________________]
            ((((long)in[23 + inPos]) <<  18) & 2097151L)
        | //                               [76543210]
          //                            [___76543210__________]
            ((((long)in[24 + inPos]) <<  10) & 262143L)
        | //                               [76543210]
          //                    [___________98765432__]
            ((((long)in[25 + inPos]) <<  2) & 1023L)
        | //                               [76______]
          //            [___________________10]
            ((((long)in[26 + inPos]) >>  6) & 3L);
      out[10 + outPos] =
          //                               [__543210]
          //                                 [098765_______________]
            ((((long)in[26 + inPos]) <<  15) & 2097151L)
        | //                               [76543210]
          //                         [______43210987_______]
            ((((long)in[27 + inPos]) <<  7) & 32767L)
        | //                               [7654321_]
          //                 [______________6543210]
            ((((long)in[28 + inPos]) >>  1) & 127L);
      out[11 + outPos] =
          //                               [_______0]
          //                                      [0____________________]
            ((((long)in[28 + inPos]) <<  20) & 2097151L)
        | //                               [76543210]
          //                              [_98765432____________]
            ((((long)in[29 + inPos]) <<  12) & 1048575L)
        | //                               [76543210]
          //                      [_________10987654____]
            ((((long)in[30 + inPos]) <<  4) & 4095L)
        | //                               [7654____]
          //              [_________________3210]
            ((((long)in[31 + inPos]) >>  4) & 15L);
      out[12 + outPos] =
          //                               [____3210]
          //                                   [0987_________________]
            ((((long)in[31 + inPos]) <<  17) & 2097151L)
        | //                               [76543210]
          //                           [____65432109_________]
            ((((long)in[32 + inPos]) <<  9) & 131071L)
        | //                               [76543210]
          //                   [____________87654321_]
            ((((long)in[33 + inPos]) <<  1) & 511L)
        | //                               [7_______]
          //           [____________________0]
            ((((long)in[34 + inPos]) >>  7) & 1L);
      out[13 + outPos] =
          //                               [_6543210]
          //                                [0987654______________]
            ((((long)in[34 + inPos]) <<  14) & 2097151L)
        | //                               [76543210]
          //                        [_______32109876______]
            ((((long)in[35 + inPos]) <<  6) & 16383L)
        | //                               [765432__]
          //                [_______________543210]
            ((((long)in[36 + inPos]) >>  2) & 63L);
      out[14 + outPos] =
          //                               [______10]
          //                                     [09___________________]
            ((((long)in[36 + inPos]) <<  19) & 2097151L)
        | //                               [76543210]
          //                             [__87654321___________]
            ((((long)in[37 + inPos]) <<  11) & 524287L)
        | //                               [76543210]
          //                     [__________09876543___]
            ((((long)in[38 + inPos]) <<  3) & 2047L)
        | //                               [765_____]
          //             [__________________210]
            ((((long)in[39 + inPos]) >>  5) & 7L);
      out[15 + outPos] =
          //                               [___43210]
          //                                  [09876________________]
            ((((long)in[39 + inPos]) <<  16) & 2097151L)
        | //                               [76543210]
          //                          [_____54321098________]
            ((((long)in[40 + inPos]) <<  8) & 65535L)
        | //                               [76543210]
          //                  [_____________76543210]
            ((((long)in[41 + inPos]) ) & 255L);
      out[16 + outPos] =
          //                               [76543210]
          //                               [09876543_____________]
            ((((long)in[42 + inPos]) <<  13) & 2097151L)
        | //                               [76543210]
          //                       [________21098765_____]
            ((((long)in[43 + inPos]) <<  5) & 8191L)
        | //                               [76543___]
          //               [________________43210]
            ((((long)in[44 + inPos]) >>  3) & 31L);
      out[17 + outPos] =
          //                               [_____210]
          //                                    [098__________________]
            ((((long)in[44 + inPos]) <<  18) & 2097151L)
        | //                               [76543210]
          //                            [___76543210__________]
            ((((long)in[45 + inPos]) <<  10) & 262143L)
        | //                               [76543210]
          //                    [___________98765432__]
            ((((long)in[46 + inPos]) <<  2) & 1023L)
        | //                               [76______]
          //            [___________________10]
            ((((long)in[47 + inPos]) >>  6) & 3L);
      out[18 + outPos] =
          //                               [__543210]
          //                                 [098765_______________]
            ((((long)in[47 + inPos]) <<  15) & 2097151L)
        | //                               [76543210]
          //                         [______43210987_______]
            ((((long)in[48 + inPos]) <<  7) & 32767L)
        | //                               [7654321_]
          //                 [______________6543210]
            ((((long)in[49 + inPos]) >>  1) & 127L);
      out[19 + outPos] =
          //                               [_______0]
          //                                      [0____________________]
            ((((long)in[49 + inPos]) <<  20) & 2097151L)
        | //                               [76543210]
          //                              [_98765432____________]
            ((((long)in[50 + inPos]) <<  12) & 1048575L)
        | //                               [76543210]
          //                      [_________10987654____]
            ((((long)in[51 + inPos]) <<  4) & 4095L)
        | //                               [7654____]
          //              [_________________3210]
            ((((long)in[52 + inPos]) >>  4) & 15L);
      out[20 + outPos] =
          //                               [____3210]
          //                                   [0987_________________]
            ((((long)in[52 + inPos]) <<  17) & 2097151L)
        | //                               [76543210]
          //                           [____65432109_________]
            ((((long)in[53 + inPos]) <<  9) & 131071L)
        | //                               [76543210]
          //                   [____________87654321_]
            ((((long)in[54 + inPos]) <<  1) & 511L)
        | //                               [7_______]
          //           [____________________0]
            ((((long)in[55 + inPos]) >>  7) & 1L);
      out[21 + outPos] =
          //                               [_6543210]
          //                                [0987654______________]
            ((((long)in[55 + inPos]) <<  14) & 2097151L)
        | //                               [76543210]
          //                        [_______32109876______]
            ((((long)in[56 + inPos]) <<  6) & 16383L)
        | //                               [765432__]
          //                [_______________543210]
            ((((long)in[57 + inPos]) >>  2) & 63L);
      out[22 + outPos] =
          //                               [______10]
          //                                     [09___________________]
            ((((long)in[57 + inPos]) <<  19) & 2097151L)
        | //                               [76543210]
          //                             [__87654321___________]
            ((((long)in[58 + inPos]) <<  11) & 524287L)
        | //                               [76543210]
          //                     [__________09876543___]
            ((((long)in[59 + inPos]) <<  3) & 2047L)
        | //                               [765_____]
          //             [__________________210]
            ((((long)in[60 + inPos]) >>  5) & 7L);
      out[23 + outPos] =
          //                               [___43210]
          //                                  [09876________________]
            ((((long)in[60 + inPos]) <<  16) & 2097151L)
        | //                               [76543210]
          //                          [_____54321098________]
            ((((long)in[61 + inPos]) <<  8) & 65535L)
        | //                               [76543210]
          //                  [_____________76543210]
            ((((long)in[62 + inPos]) ) & 255L);
      out[24 + outPos] =
          //                               [76543210]
          //                               [09876543_____________]
            ((((long)in[63 + inPos]) <<  13) & 2097151L)
        | //                               [76543210]
          //                       [________21098765_____]
            ((((long)in[64 + inPos]) <<  5) & 8191L)
        | //                               [76543___]
          //               [________________43210]
            ((((long)in[65 + inPos]) >>  3) & 31L);
      out[25 + outPos] =
          //                               [_____210]
          //                                    [098__________________]
            ((((long)in[65 + inPos]) <<  18) & 2097151L)
        | //                               [76543210]
          //                            [___76543210__________]
            ((((long)in[66 + inPos]) <<  10) & 262143L)
        | //                               [76543210]
          //                    [___________98765432__]
            ((((long)in[67 + inPos]) <<  2) & 1023L)
        | //                               [76______]
          //            [___________________10]
            ((((long)in[68 + inPos]) >>  6) & 3L);
      out[26 + outPos] =
          //                               [__543210]
          //                                 [098765_______________]
            ((((long)in[68 + inPos]) <<  15) & 2097151L)
        | //                               [76543210]
          //                         [______43210987_______]
            ((((long)in[69 + inPos]) <<  7) & 32767L)
        | //                               [7654321_]
          //                 [______________6543210]
            ((((long)in[70 + inPos]) >>  1) & 127L);
      out[27 + outPos] =
          //                               [_______0]
          //                                      [0____________________]
            ((((long)in[70 + inPos]) <<  20) & 2097151L)
        | //                               [76543210]
          //                              [_98765432____________]
            ((((long)in[71 + inPos]) <<  12) & 1048575L)
        | //                               [76543210]
          //                      [_________10987654____]
            ((((long)in[72 + inPos]) <<  4) & 4095L)
        | //                               [7654____]
          //              [_________________3210]
            ((((long)in[73 + inPos]) >>  4) & 15L);
      out[28 + outPos] =
          //                               [____3210]
          //                                   [0987_________________]
            ((((long)in[73 + inPos]) <<  17) & 2097151L)
        | //                               [76543210]
          //                           [____65432109_________]
            ((((long)in[74 + inPos]) <<  9) & 131071L)
        | //                               [76543210]
          //                   [____________87654321_]
            ((((long)in[75 + inPos]) <<  1) & 511L)
        | //                               [7_______]
          //           [____________________0]
            ((((long)in[76 + inPos]) >>  7) & 1L);
      out[29 + outPos] =
          //                               [_6543210]
          //                                [0987654______________]
            ((((long)in[76 + inPos]) <<  14) & 2097151L)
        | //                               [76543210]
          //                        [_______32109876______]
            ((((long)in[77 + inPos]) <<  6) & 16383L)
        | //                               [765432__]
          //                [_______________543210]
            ((((long)in[78 + inPos]) >>  2) & 63L);
      out[30 + outPos] =
          //                               [______10]
          //                                     [09___________________]
            ((((long)in[78 + inPos]) <<  19) & 2097151L)
        | //                               [76543210]
          //                             [__87654321___________]
            ((((long)in[79 + inPos]) <<  11) & 524287L)
        | //                               [76543210]
          //                     [__________09876543___]
            ((((long)in[80 + inPos]) <<  3) & 2047L)
        | //                               [765_____]
          //             [__________________210]
            ((((long)in[81 + inPos]) >>  5) & 7L);
      out[31 + outPos] =
          //                               [___43210]
          //                                  [09876________________]
            ((((long)in[81 + inPos]) <<  16) & 2097151L)
        | //                               [76543210]
          //                          [_____54321098________]
            ((((long)in[82 + inPos]) <<  8) & 65535L)
        | //                               [76543210]
          //                  [_____________76543210]
            ((((long)in[83 + inPos]) ) & 255L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                               [76543210]
          //                               [09876543_____________]
            ((((long)in.get( 0 + inPos)) <<  13) & 2097151L)
        | //                               [76543210]
          //                       [________21098765_____]
            ((((long)in.get( 1 + inPos)) <<  5) & 8191L)
        | //                               [76543___]
          //               [________________43210]
            ((((long)in.get( 2 + inPos)) >>  3) & 31L);
      out[ 1 + outPos] =
          //                               [_____210]
          //                                    [098__________________]
            ((((long)in.get( 2 + inPos)) <<  18) & 2097151L)
        | //                               [76543210]
          //                            [___76543210__________]
            ((((long)in.get( 3 + inPos)) <<  10) & 262143L)
        | //                               [76543210]
          //                    [___________98765432__]
            ((((long)in.get( 4 + inPos)) <<  2) & 1023L)
        | //                               [76______]
          //            [___________________10]
            ((((long)in.get( 5 + inPos)) >>  6) & 3L);
      out[ 2 + outPos] =
          //                               [__543210]
          //                                 [098765_______________]
            ((((long)in.get( 5 + inPos)) <<  15) & 2097151L)
        | //                               [76543210]
          //                         [______43210987_______]
            ((((long)in.get( 6 + inPos)) <<  7) & 32767L)
        | //                               [7654321_]
          //                 [______________6543210]
            ((((long)in.get( 7 + inPos)) >>  1) & 127L);
      out[ 3 + outPos] =
          //                               [_______0]
          //                                      [0____________________]
            ((((long)in.get( 7 + inPos)) <<  20) & 2097151L)
        | //                               [76543210]
          //                              [_98765432____________]
            ((((long)in.get( 8 + inPos)) <<  12) & 1048575L)
        | //                               [76543210]
          //                      [_________10987654____]
            ((((long)in.get( 9 + inPos)) <<  4) & 4095L)
        | //                               [7654____]
          //              [_________________3210]
            ((((long)in.get(10 + inPos)) >>  4) & 15L);
      out[ 4 + outPos] =
          //                               [____3210]
          //                                   [0987_________________]
            ((((long)in.get(10 + inPos)) <<  17) & 2097151L)
        | //                               [76543210]
          //                           [____65432109_________]
            ((((long)in.get(11 + inPos)) <<  9) & 131071L)
        | //                               [76543210]
          //                   [____________87654321_]
            ((((long)in.get(12 + inPos)) <<  1) & 511L)
        | //                               [7_______]
          //           [____________________0]
            ((((long)in.get(13 + inPos)) >>  7) & 1L);
      out[ 5 + outPos] =
          //                               [_6543210]
          //                                [0987654______________]
            ((((long)in.get(13 + inPos)) <<  14) & 2097151L)
        | //                               [76543210]
          //                        [_______32109876______]
            ((((long)in.get(14 + inPos)) <<  6) & 16383L)
        | //                               [765432__]
          //                [_______________543210]
            ((((long)in.get(15 + inPos)) >>  2) & 63L);
      out[ 6 + outPos] =
          //                               [______10]
          //                                     [09___________________]
            ((((long)in.get(15 + inPos)) <<  19) & 2097151L)
        | //                               [76543210]
          //                             [__87654321___________]
            ((((long)in.get(16 + inPos)) <<  11) & 524287L)
        | //                               [76543210]
          //                     [__________09876543___]
            ((((long)in.get(17 + inPos)) <<  3) & 2047L)
        | //                               [765_____]
          //             [__________________210]
            ((((long)in.get(18 + inPos)) >>  5) & 7L);
      out[ 7 + outPos] =
          //                               [___43210]
          //                                  [09876________________]
            ((((long)in.get(18 + inPos)) <<  16) & 2097151L)
        | //                               [76543210]
          //                          [_____54321098________]
            ((((long)in.get(19 + inPos)) <<  8) & 65535L)
        | //                               [76543210]
          //                  [_____________76543210]
            ((((long)in.get(20 + inPos)) ) & 255L);
      out[ 8 + outPos] =
          //                               [76543210]
          //                               [09876543_____________]
            ((((long)in.get(21 + inPos)) <<  13) & 2097151L)
        | //                               [76543210]
          //                       [________21098765_____]
            ((((long)in.get(22 + inPos)) <<  5) & 8191L)
        | //                               [76543___]
          //               [________________43210]
            ((((long)in.get(23 + inPos)) >>  3) & 31L);
      out[ 9 + outPos] =
          //                               [_____210]
          //                                    [098__________________]
            ((((long)in.get(23 + inPos)) <<  18) & 2097151L)
        | //                               [76543210]
          //                            [___76543210__________]
            ((((long)in.get(24 + inPos)) <<  10) & 262143L)
        | //                               [76543210]
          //                    [___________98765432__]
            ((((long)in.get(25 + inPos)) <<  2) & 1023L)
        | //                               [76______]
          //            [___________________10]
            ((((long)in.get(26 + inPos)) >>  6) & 3L);
      out[10 + outPos] =
          //                               [__543210]
          //                                 [098765_______________]
            ((((long)in.get(26 + inPos)) <<  15) & 2097151L)
        | //                               [76543210]
          //                         [______43210987_______]
            ((((long)in.get(27 + inPos)) <<  7) & 32767L)
        | //                               [7654321_]
          //                 [______________6543210]
            ((((long)in.get(28 + inPos)) >>  1) & 127L);
      out[11 + outPos] =
          //                               [_______0]
          //                                      [0____________________]
            ((((long)in.get(28 + inPos)) <<  20) & 2097151L)
        | //                               [76543210]
          //                              [_98765432____________]
            ((((long)in.get(29 + inPos)) <<  12) & 1048575L)
        | //                               [76543210]
          //                      [_________10987654____]
            ((((long)in.get(30 + inPos)) <<  4) & 4095L)
        | //                               [7654____]
          //              [_________________3210]
            ((((long)in.get(31 + inPos)) >>  4) & 15L);
      out[12 + outPos] =
          //                               [____3210]
          //                                   [0987_________________]
            ((((long)in.get(31 + inPos)) <<  17) & 2097151L)
        | //                               [76543210]
          //                           [____65432109_________]
            ((((long)in.get(32 + inPos)) <<  9) & 131071L)
        | //                               [76543210]
          //                   [____________87654321_]
            ((((long)in.get(33 + inPos)) <<  1) & 511L)
        | //                               [7_______]
          //           [____________________0]
            ((((long)in.get(34 + inPos)) >>  7) & 1L);
      out[13 + outPos] =
          //                               [_6543210]
          //                                [0987654______________]
            ((((long)in.get(34 + inPos)) <<  14) & 2097151L)
        | //                               [76543210]
          //                        [_______32109876______]
            ((((long)in.get(35 + inPos)) <<  6) & 16383L)
        | //                               [765432__]
          //                [_______________543210]
            ((((long)in.get(36 + inPos)) >>  2) & 63L);
      out[14 + outPos] =
          //                               [______10]
          //                                     [09___________________]
            ((((long)in.get(36 + inPos)) <<  19) & 2097151L)
        | //                               [76543210]
          //                             [__87654321___________]
            ((((long)in.get(37 + inPos)) <<  11) & 524287L)
        | //                               [76543210]
          //                     [__________09876543___]
            ((((long)in.get(38 + inPos)) <<  3) & 2047L)
        | //                               [765_____]
          //             [__________________210]
            ((((long)in.get(39 + inPos)) >>  5) & 7L);
      out[15 + outPos] =
          //                               [___43210]
          //                                  [09876________________]
            ((((long)in.get(39 + inPos)) <<  16) & 2097151L)
        | //                               [76543210]
          //                          [_____54321098________]
            ((((long)in.get(40 + inPos)) <<  8) & 65535L)
        | //                               [76543210]
          //                  [_____________76543210]
            ((((long)in.get(41 + inPos)) ) & 255L);
      out[16 + outPos] =
          //                               [76543210]
          //                               [09876543_____________]
            ((((long)in.get(42 + inPos)) <<  13) & 2097151L)
        | //                               [76543210]
          //                       [________21098765_____]
            ((((long)in.get(43 + inPos)) <<  5) & 8191L)
        | //                               [76543___]
          //               [________________43210]
            ((((long)in.get(44 + inPos)) >>  3) & 31L);
      out[17 + outPos] =
          //                               [_____210]
          //                                    [098__________________]
            ((((long)in.get(44 + inPos)) <<  18) & 2097151L)
        | //                               [76543210]
          //                            [___76543210__________]
            ((((long)in.get(45 + inPos)) <<  10) & 262143L)
        | //                               [76543210]
          //                    [___________98765432__]
            ((((long)in.get(46 + inPos)) <<  2) & 1023L)
        | //                               [76______]
          //            [___________________10]
            ((((long)in.get(47 + inPos)) >>  6) & 3L);
      out[18 + outPos] =
          //                               [__543210]
          //                                 [098765_______________]
            ((((long)in.get(47 + inPos)) <<  15) & 2097151L)
        | //                               [76543210]
          //                         [______43210987_______]
            ((((long)in.get(48 + inPos)) <<  7) & 32767L)
        | //                               [7654321_]
          //                 [______________6543210]
            ((((long)in.get(49 + inPos)) >>  1) & 127L);
      out[19 + outPos] =
          //                               [_______0]
          //                                      [0____________________]
            ((((long)in.get(49 + inPos)) <<  20) & 2097151L)
        | //                               [76543210]
          //                              [_98765432____________]
            ((((long)in.get(50 + inPos)) <<  12) & 1048575L)
        | //                               [76543210]
          //                      [_________10987654____]
            ((((long)in.get(51 + inPos)) <<  4) & 4095L)
        | //                               [7654____]
          //              [_________________3210]
            ((((long)in.get(52 + inPos)) >>  4) & 15L);
      out[20 + outPos] =
          //                               [____3210]
          //                                   [0987_________________]
            ((((long)in.get(52 + inPos)) <<  17) & 2097151L)
        | //                               [76543210]
          //                           [____65432109_________]
            ((((long)in.get(53 + inPos)) <<  9) & 131071L)
        | //                               [76543210]
          //                   [____________87654321_]
            ((((long)in.get(54 + inPos)) <<  1) & 511L)
        | //                               [7_______]
          //           [____________________0]
            ((((long)in.get(55 + inPos)) >>  7) & 1L);
      out[21 + outPos] =
          //                               [_6543210]
          //                                [0987654______________]
            ((((long)in.get(55 + inPos)) <<  14) & 2097151L)
        | //                               [76543210]
          //                        [_______32109876______]
            ((((long)in.get(56 + inPos)) <<  6) & 16383L)
        | //                               [765432__]
          //                [_______________543210]
            ((((long)in.get(57 + inPos)) >>  2) & 63L);
      out[22 + outPos] =
          //                               [______10]
          //                                     [09___________________]
            ((((long)in.get(57 + inPos)) <<  19) & 2097151L)
        | //                               [76543210]
          //                             [__87654321___________]
            ((((long)in.get(58 + inPos)) <<  11) & 524287L)
        | //                               [76543210]
          //                     [__________09876543___]
            ((((long)in.get(59 + inPos)) <<  3) & 2047L)
        | //                               [765_____]
          //             [__________________210]
            ((((long)in.get(60 + inPos)) >>  5) & 7L);
      out[23 + outPos] =
          //                               [___43210]
          //                                  [09876________________]
            ((((long)in.get(60 + inPos)) <<  16) & 2097151L)
        | //                               [76543210]
          //                          [_____54321098________]
            ((((long)in.get(61 + inPos)) <<  8) & 65535L)
        | //                               [76543210]
          //                  [_____________76543210]
            ((((long)in.get(62 + inPos)) ) & 255L);
      out[24 + outPos] =
          //                               [76543210]
          //                               [09876543_____________]
            ((((long)in.get(63 + inPos)) <<  13) & 2097151L)
        | //                               [76543210]
          //                       [________21098765_____]
            ((((long)in.get(64 + inPos)) <<  5) & 8191L)
        | //                               [76543___]
          //               [________________43210]
            ((((long)in.get(65 + inPos)) >>  3) & 31L);
      out[25 + outPos] =
          //                               [_____210]
          //                                    [098__________________]
            ((((long)in.get(65 + inPos)) <<  18) & 2097151L)
        | //                               [76543210]
          //                            [___76543210__________]
            ((((long)in.get(66 + inPos)) <<  10) & 262143L)
        | //                               [76543210]
          //                    [___________98765432__]
            ((((long)in.get(67 + inPos)) <<  2) & 1023L)
        | //                               [76______]
          //            [___________________10]
            ((((long)in.get(68 + inPos)) >>  6) & 3L);
      out[26 + outPos] =
          //                               [__543210]
          //                                 [098765_______________]
            ((((long)in.get(68 + inPos)) <<  15) & 2097151L)
        | //                               [76543210]
          //                         [______43210987_______]
            ((((long)in.get(69 + inPos)) <<  7) & 32767L)
        | //                               [7654321_]
          //                 [______________6543210]
            ((((long)in.get(70 + inPos)) >>  1) & 127L);
      out[27 + outPos] =
          //                               [_______0]
          //                                      [0____________________]
            ((((long)in.get(70 + inPos)) <<  20) & 2097151L)
        | //                               [76543210]
          //                              [_98765432____________]
            ((((long)in.get(71 + inPos)) <<  12) & 1048575L)
        | //                               [76543210]
          //                      [_________10987654____]
            ((((long)in.get(72 + inPos)) <<  4) & 4095L)
        | //                               [7654____]
          //              [_________________3210]
            ((((long)in.get(73 + inPos)) >>  4) & 15L);
      out[28 + outPos] =
          //                               [____3210]
          //                                   [0987_________________]
            ((((long)in.get(73 + inPos)) <<  17) & 2097151L)
        | //                               [76543210]
          //                           [____65432109_________]
            ((((long)in.get(74 + inPos)) <<  9) & 131071L)
        | //                               [76543210]
          //                   [____________87654321_]
            ((((long)in.get(75 + inPos)) <<  1) & 511L)
        | //                               [7_______]
          //           [____________________0]
            ((((long)in.get(76 + inPos)) >>  7) & 1L);
      out[29 + outPos] =
          //                               [_6543210]
          //                                [0987654______________]
            ((((long)in.get(76 + inPos)) <<  14) & 2097151L)
        | //                               [76543210]
          //                        [_______32109876______]
            ((((long)in.get(77 + inPos)) <<  6) & 16383L)
        | //                               [765432__]
          //                [_______________543210]
            ((((long)in.get(78 + inPos)) >>  2) & 63L);
      out[30 + outPos] =
          //                               [______10]
          //                                     [09___________________]
            ((((long)in.get(78 + inPos)) <<  19) & 2097151L)
        | //                               [76543210]
          //                             [__87654321___________]
            ((((long)in.get(79 + inPos)) <<  11) & 524287L)
        | //                               [76543210]
          //                     [__________09876543___]
            ((((long)in.get(80 + inPos)) <<  3) & 2047L)
        | //                               [765_____]
          //             [__________________210]
            ((((long)in.get(81 + inPos)) >>  5) & 7L);
      out[31 + outPos] =
          //                               [___43210]
          //                                  [09876________________]
            ((((long)in.get(81 + inPos)) <<  16) & 2097151L)
        | //                               [76543210]
          //                          [_____54321098________]
            ((((long)in.get(82 + inPos)) <<  8) & 65535L)
        | //                               [76543210]
          //                  [_____________76543210]
            ((((long)in.get(83 + inPos)) ) & 255L);
    }
  }

  private static final class Packer22 extends BytePackerForLong {

    private Packer22() {
      super(22);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                                [76543210]
          //                                [10987654______________]
           ((in[ 0 + inPos] & 4194303L) >>> 14)) & 255);
      out[ 1 + outPos] = (byte)((
          //                                [76543210]
          //                        [________32109876______]
           ((in[ 0 + inPos] & 4194303L) >>> 6)) & 255);
      out[ 2 + outPos] = (byte)((
          //                                [765432__]
          //                [________________543210]
           ((in[ 0 + inPos] & 4194303L) <<  2)
        | //                                [______10]
          //                                      [10____________________]
           ((in[ 1 + inPos] & 4194303L) >>> 20)) & 255);
      out[ 3 + outPos] = (byte)((
          //                                [76543210]
          //                              [__98765432____________]
           ((in[ 1 + inPos] & 4194303L) >>> 12)) & 255);
      out[ 4 + outPos] = (byte)((
          //                                [76543210]
          //                      [__________10987654____]
           ((in[ 1 + inPos] & 4194303L) >>> 4)) & 255);
      out[ 5 + outPos] = (byte)((
          //                                [7654____]
          //              [__________________3210]
           ((in[ 1 + inPos] & 4194303L) <<  4)
        | //                                [____3210]
          //                                    [1098__________________]
           ((in[ 2 + inPos] & 4194303L) >>> 18)) & 255);
      out[ 6 + outPos] = (byte)((
          //                                [76543210]
          //                            [____76543210__________]
           ((in[ 2 + inPos] & 4194303L) >>> 10)) & 255);
      out[ 7 + outPos] = (byte)((
          //                                [76543210]
          //                    [____________98765432__]
           ((in[ 2 + inPos] & 4194303L) >>> 2)) & 255);
      out[ 8 + outPos] = (byte)((
          //                                [76______]
          //            [____________________10]
           ((in[ 2 + inPos] & 4194303L) <<  6)
        | //                                [__543210]
          //                                  [109876________________]
           ((in[ 3 + inPos] & 4194303L) >>> 16)) & 255);
      out[ 9 + outPos] = (byte)((
          //                                [76543210]
          //                          [______54321098________]
           ((in[ 3 + inPos] & 4194303L) >>> 8)) & 255);
      out[10 + outPos] = (byte)((
          //                                [76543210]
          //                  [______________76543210]
           ((in[ 3 + inPos] & 4194303L))) & 255);
      out[11 + outPos] = (byte)((
          //                                [76543210]
          //                                [10987654______________]
           ((in[ 4 + inPos] & 4194303L) >>> 14)) & 255);
      out[12 + outPos] = (byte)((
          //                                [76543210]
          //                        [________32109876______]
           ((in[ 4 + inPos] & 4194303L) >>> 6)) & 255);
      out[13 + outPos] = (byte)((
          //                                [765432__]
          //                [________________543210]
           ((in[ 4 + inPos] & 4194303L) <<  2)
        | //                                [______10]
          //                                      [10____________________]
           ((in[ 5 + inPos] & 4194303L) >>> 20)) & 255);
      out[14 + outPos] = (byte)((
          //                                [76543210]
          //                              [__98765432____________]
           ((in[ 5 + inPos] & 4194303L) >>> 12)) & 255);
      out[15 + outPos] = (byte)((
          //                                [76543210]
          //                      [__________10987654____]
           ((in[ 5 + inPos] & 4194303L) >>> 4)) & 255);
      out[16 + outPos] = (byte)((
          //                                [7654____]
          //              [__________________3210]
           ((in[ 5 + inPos] & 4194303L) <<  4)
        | //                                [____3210]
          //                                    [1098__________________]
           ((in[ 6 + inPos] & 4194303L) >>> 18)) & 255);
      out[17 + outPos] = (byte)((
          //                                [76543210]
          //                            [____76543210__________]
           ((in[ 6 + inPos] & 4194303L) >>> 10)) & 255);
      out[18 + outPos] = (byte)((
          //                                [76543210]
          //                    [____________98765432__]
           ((in[ 6 + inPos] & 4194303L) >>> 2)) & 255);
      out[19 + outPos] = (byte)((
          //                                [76______]
          //            [____________________10]
           ((in[ 6 + inPos] & 4194303L) <<  6)
        | //                                [__543210]
          //                                  [109876________________]
           ((in[ 7 + inPos] & 4194303L) >>> 16)) & 255);
      out[20 + outPos] = (byte)((
          //                                [76543210]
          //                          [______54321098________]
           ((in[ 7 + inPos] & 4194303L) >>> 8)) & 255);
      out[21 + outPos] = (byte)((
          //                                [76543210]
          //                  [______________76543210]
           ((in[ 7 + inPos] & 4194303L))) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                                [76543210]
          //                                [10987654______________]
           ((in[ 0 + inPos] & 4194303L) >>> 14)) & 255);
      out[ 1 + outPos] = (byte)((
          //                                [76543210]
          //                        [________32109876______]
           ((in[ 0 + inPos] & 4194303L) >>> 6)) & 255);
      out[ 2 + outPos] = (byte)((
          //                                [765432__]
          //                [________________543210]
           ((in[ 0 + inPos] & 4194303L) <<  2)
        | //                                [______10]
          //                                      [10____________________]
           ((in[ 1 + inPos] & 4194303L) >>> 20)) & 255);
      out[ 3 + outPos] = (byte)((
          //                                [76543210]
          //                              [__98765432____________]
           ((in[ 1 + inPos] & 4194303L) >>> 12)) & 255);
      out[ 4 + outPos] = (byte)((
          //                                [76543210]
          //                      [__________10987654____]
           ((in[ 1 + inPos] & 4194303L) >>> 4)) & 255);
      out[ 5 + outPos] = (byte)((
          //                                [7654____]
          //              [__________________3210]
           ((in[ 1 + inPos] & 4194303L) <<  4)
        | //                                [____3210]
          //                                    [1098__________________]
           ((in[ 2 + inPos] & 4194303L) >>> 18)) & 255);
      out[ 6 + outPos] = (byte)((
          //                                [76543210]
          //                            [____76543210__________]
           ((in[ 2 + inPos] & 4194303L) >>> 10)) & 255);
      out[ 7 + outPos] = (byte)((
          //                                [76543210]
          //                    [____________98765432__]
           ((in[ 2 + inPos] & 4194303L) >>> 2)) & 255);
      out[ 8 + outPos] = (byte)((
          //                                [76______]
          //            [____________________10]
           ((in[ 2 + inPos] & 4194303L) <<  6)
        | //                                [__543210]
          //                                  [109876________________]
           ((in[ 3 + inPos] & 4194303L) >>> 16)) & 255);
      out[ 9 + outPos] = (byte)((
          //                                [76543210]
          //                          [______54321098________]
           ((in[ 3 + inPos] & 4194303L) >>> 8)) & 255);
      out[10 + outPos] = (byte)((
          //                                [76543210]
          //                  [______________76543210]
           ((in[ 3 + inPos] & 4194303L))) & 255);
      out[11 + outPos] = (byte)((
          //                                [76543210]
          //                                [10987654______________]
           ((in[ 4 + inPos] & 4194303L) >>> 14)) & 255);
      out[12 + outPos] = (byte)((
          //                                [76543210]
          //                        [________32109876______]
           ((in[ 4 + inPos] & 4194303L) >>> 6)) & 255);
      out[13 + outPos] = (byte)((
          //                                [765432__]
          //                [________________543210]
           ((in[ 4 + inPos] & 4194303L) <<  2)
        | //                                [______10]
          //                                      [10____________________]
           ((in[ 5 + inPos] & 4194303L) >>> 20)) & 255);
      out[14 + outPos] = (byte)((
          //                                [76543210]
          //                              [__98765432____________]
           ((in[ 5 + inPos] & 4194303L) >>> 12)) & 255);
      out[15 + outPos] = (byte)((
          //                                [76543210]
          //                      [__________10987654____]
           ((in[ 5 + inPos] & 4194303L) >>> 4)) & 255);
      out[16 + outPos] = (byte)((
          //                                [7654____]
          //              [__________________3210]
           ((in[ 5 + inPos] & 4194303L) <<  4)
        | //                                [____3210]
          //                                    [1098__________________]
           ((in[ 6 + inPos] & 4194303L) >>> 18)) & 255);
      out[17 + outPos] = (byte)((
          //                                [76543210]
          //                            [____76543210__________]
           ((in[ 6 + inPos] & 4194303L) >>> 10)) & 255);
      out[18 + outPos] = (byte)((
          //                                [76543210]
          //                    [____________98765432__]
           ((in[ 6 + inPos] & 4194303L) >>> 2)) & 255);
      out[19 + outPos] = (byte)((
          //                                [76______]
          //            [____________________10]
           ((in[ 6 + inPos] & 4194303L) <<  6)
        | //                                [__543210]
          //                                  [109876________________]
           ((in[ 7 + inPos] & 4194303L) >>> 16)) & 255);
      out[20 + outPos] = (byte)((
          //                                [76543210]
          //                          [______54321098________]
           ((in[ 7 + inPos] & 4194303L) >>> 8)) & 255);
      out[21 + outPos] = (byte)((
          //                                [76543210]
          //                  [______________76543210]
           ((in[ 7 + inPos] & 4194303L))) & 255);
      out[22 + outPos] = (byte)((
          //                                [76543210]
          //                                [10987654______________]
           ((in[ 8 + inPos] & 4194303L) >>> 14)) & 255);
      out[23 + outPos] = (byte)((
          //                                [76543210]
          //                        [________32109876______]
           ((in[ 8 + inPos] & 4194303L) >>> 6)) & 255);
      out[24 + outPos] = (byte)((
          //                                [765432__]
          //                [________________543210]
           ((in[ 8 + inPos] & 4194303L) <<  2)
        | //                                [______10]
          //                                      [10____________________]
           ((in[ 9 + inPos] & 4194303L) >>> 20)) & 255);
      out[25 + outPos] = (byte)((
          //                                [76543210]
          //                              [__98765432____________]
           ((in[ 9 + inPos] & 4194303L) >>> 12)) & 255);
      out[26 + outPos] = (byte)((
          //                                [76543210]
          //                      [__________10987654____]
           ((in[ 9 + inPos] & 4194303L) >>> 4)) & 255);
      out[27 + outPos] = (byte)((
          //                                [7654____]
          //              [__________________3210]
           ((in[ 9 + inPos] & 4194303L) <<  4)
        | //                                [____3210]
          //                                    [1098__________________]
           ((in[10 + inPos] & 4194303L) >>> 18)) & 255);
      out[28 + outPos] = (byte)((
          //                                [76543210]
          //                            [____76543210__________]
           ((in[10 + inPos] & 4194303L) >>> 10)) & 255);
      out[29 + outPos] = (byte)((
          //                                [76543210]
          //                    [____________98765432__]
           ((in[10 + inPos] & 4194303L) >>> 2)) & 255);
      out[30 + outPos] = (byte)((
          //                                [76______]
          //            [____________________10]
           ((in[10 + inPos] & 4194303L) <<  6)
        | //                                [__543210]
          //                                  [109876________________]
           ((in[11 + inPos] & 4194303L) >>> 16)) & 255);
      out[31 + outPos] = (byte)((
          //                                [76543210]
          //                          [______54321098________]
           ((in[11 + inPos] & 4194303L) >>> 8)) & 255);
      out[32 + outPos] = (byte)((
          //                                [76543210]
          //                  [______________76543210]
           ((in[11 + inPos] & 4194303L))) & 255);
      out[33 + outPos] = (byte)((
          //                                [76543210]
          //                                [10987654______________]
           ((in[12 + inPos] & 4194303L) >>> 14)) & 255);
      out[34 + outPos] = (byte)((
          //                                [76543210]
          //                        [________32109876______]
           ((in[12 + inPos] & 4194303L) >>> 6)) & 255);
      out[35 + outPos] = (byte)((
          //                                [765432__]
          //                [________________543210]
           ((in[12 + inPos] & 4194303L) <<  2)
        | //                                [______10]
          //                                      [10____________________]
           ((in[13 + inPos] & 4194303L) >>> 20)) & 255);
      out[36 + outPos] = (byte)((
          //                                [76543210]
          //                              [__98765432____________]
           ((in[13 + inPos] & 4194303L) >>> 12)) & 255);
      out[37 + outPos] = (byte)((
          //                                [76543210]
          //                      [__________10987654____]
           ((in[13 + inPos] & 4194303L) >>> 4)) & 255);
      out[38 + outPos] = (byte)((
          //                                [7654____]
          //              [__________________3210]
           ((in[13 + inPos] & 4194303L) <<  4)
        | //                                [____3210]
          //                                    [1098__________________]
           ((in[14 + inPos] & 4194303L) >>> 18)) & 255);
      out[39 + outPos] = (byte)((
          //                                [76543210]
          //                            [____76543210__________]
           ((in[14 + inPos] & 4194303L) >>> 10)) & 255);
      out[40 + outPos] = (byte)((
          //                                [76543210]
          //                    [____________98765432__]
           ((in[14 + inPos] & 4194303L) >>> 2)) & 255);
      out[41 + outPos] = (byte)((
          //                                [76______]
          //            [____________________10]
           ((in[14 + inPos] & 4194303L) <<  6)
        | //                                [__543210]
          //                                  [109876________________]
           ((in[15 + inPos] & 4194303L) >>> 16)) & 255);
      out[42 + outPos] = (byte)((
          //                                [76543210]
          //                          [______54321098________]
           ((in[15 + inPos] & 4194303L) >>> 8)) & 255);
      out[43 + outPos] = (byte)((
          //                                [76543210]
          //                  [______________76543210]
           ((in[15 + inPos] & 4194303L))) & 255);
      out[44 + outPos] = (byte)((
          //                                [76543210]
          //                                [10987654______________]
           ((in[16 + inPos] & 4194303L) >>> 14)) & 255);
      out[45 + outPos] = (byte)((
          //                                [76543210]
          //                        [________32109876______]
           ((in[16 + inPos] & 4194303L) >>> 6)) & 255);
      out[46 + outPos] = (byte)((
          //                                [765432__]
          //                [________________543210]
           ((in[16 + inPos] & 4194303L) <<  2)
        | //                                [______10]
          //                                      [10____________________]
           ((in[17 + inPos] & 4194303L) >>> 20)) & 255);
      out[47 + outPos] = (byte)((
          //                                [76543210]
          //                              [__98765432____________]
           ((in[17 + inPos] & 4194303L) >>> 12)) & 255);
      out[48 + outPos] = (byte)((
          //                                [76543210]
          //                      [__________10987654____]
           ((in[17 + inPos] & 4194303L) >>> 4)) & 255);
      out[49 + outPos] = (byte)((
          //                                [7654____]
          //              [__________________3210]
           ((in[17 + inPos] & 4194303L) <<  4)
        | //                                [____3210]
          //                                    [1098__________________]
           ((in[18 + inPos] & 4194303L) >>> 18)) & 255);
      out[50 + outPos] = (byte)((
          //                                [76543210]
          //                            [____76543210__________]
           ((in[18 + inPos] & 4194303L) >>> 10)) & 255);
      out[51 + outPos] = (byte)((
          //                                [76543210]
          //                    [____________98765432__]
           ((in[18 + inPos] & 4194303L) >>> 2)) & 255);
      out[52 + outPos] = (byte)((
          //                                [76______]
          //            [____________________10]
           ((in[18 + inPos] & 4194303L) <<  6)
        | //                                [__543210]
          //                                  [109876________________]
           ((in[19 + inPos] & 4194303L) >>> 16)) & 255);
      out[53 + outPos] = (byte)((
          //                                [76543210]
          //                          [______54321098________]
           ((in[19 + inPos] & 4194303L) >>> 8)) & 255);
      out[54 + outPos] = (byte)((
          //                                [76543210]
          //                  [______________76543210]
           ((in[19 + inPos] & 4194303L))) & 255);
      out[55 + outPos] = (byte)((
          //                                [76543210]
          //                                [10987654______________]
           ((in[20 + inPos] & 4194303L) >>> 14)) & 255);
      out[56 + outPos] = (byte)((
          //                                [76543210]
          //                        [________32109876______]
           ((in[20 + inPos] & 4194303L) >>> 6)) & 255);
      out[57 + outPos] = (byte)((
          //                                [765432__]
          //                [________________543210]
           ((in[20 + inPos] & 4194303L) <<  2)
        | //                                [______10]
          //                                      [10____________________]
           ((in[21 + inPos] & 4194303L) >>> 20)) & 255);
      out[58 + outPos] = (byte)((
          //                                [76543210]
          //                              [__98765432____________]
           ((in[21 + inPos] & 4194303L) >>> 12)) & 255);
      out[59 + outPos] = (byte)((
          //                                [76543210]
          //                      [__________10987654____]
           ((in[21 + inPos] & 4194303L) >>> 4)) & 255);
      out[60 + outPos] = (byte)((
          //                                [7654____]
          //              [__________________3210]
           ((in[21 + inPos] & 4194303L) <<  4)
        | //                                [____3210]
          //                                    [1098__________________]
           ((in[22 + inPos] & 4194303L) >>> 18)) & 255);
      out[61 + outPos] = (byte)((
          //                                [76543210]
          //                            [____76543210__________]
           ((in[22 + inPos] & 4194303L) >>> 10)) & 255);
      out[62 + outPos] = (byte)((
          //                                [76543210]
          //                    [____________98765432__]
           ((in[22 + inPos] & 4194303L) >>> 2)) & 255);
      out[63 + outPos] = (byte)((
          //                                [76______]
          //            [____________________10]
           ((in[22 + inPos] & 4194303L) <<  6)
        | //                                [__543210]
          //                                  [109876________________]
           ((in[23 + inPos] & 4194303L) >>> 16)) & 255);
      out[64 + outPos] = (byte)((
          //                                [76543210]
          //                          [______54321098________]
           ((in[23 + inPos] & 4194303L) >>> 8)) & 255);
      out[65 + outPos] = (byte)((
          //                                [76543210]
          //                  [______________76543210]
           ((in[23 + inPos] & 4194303L))) & 255);
      out[66 + outPos] = (byte)((
          //                                [76543210]
          //                                [10987654______________]
           ((in[24 + inPos] & 4194303L) >>> 14)) & 255);
      out[67 + outPos] = (byte)((
          //                                [76543210]
          //                        [________32109876______]
           ((in[24 + inPos] & 4194303L) >>> 6)) & 255);
      out[68 + outPos] = (byte)((
          //                                [765432__]
          //                [________________543210]
           ((in[24 + inPos] & 4194303L) <<  2)
        | //                                [______10]
          //                                      [10____________________]
           ((in[25 + inPos] & 4194303L) >>> 20)) & 255);
      out[69 + outPos] = (byte)((
          //                                [76543210]
          //                              [__98765432____________]
           ((in[25 + inPos] & 4194303L) >>> 12)) & 255);
      out[70 + outPos] = (byte)((
          //                                [76543210]
          //                      [__________10987654____]
           ((in[25 + inPos] & 4194303L) >>> 4)) & 255);
      out[71 + outPos] = (byte)((
          //                                [7654____]
          //              [__________________3210]
           ((in[25 + inPos] & 4194303L) <<  4)
        | //                                [____3210]
          //                                    [1098__________________]
           ((in[26 + inPos] & 4194303L) >>> 18)) & 255);
      out[72 + outPos] = (byte)((
          //                                [76543210]
          //                            [____76543210__________]
           ((in[26 + inPos] & 4194303L) >>> 10)) & 255);
      out[73 + outPos] = (byte)((
          //                                [76543210]
          //                    [____________98765432__]
           ((in[26 + inPos] & 4194303L) >>> 2)) & 255);
      out[74 + outPos] = (byte)((
          //                                [76______]
          //            [____________________10]
           ((in[26 + inPos] & 4194303L) <<  6)
        | //                                [__543210]
          //                                  [109876________________]
           ((in[27 + inPos] & 4194303L) >>> 16)) & 255);
      out[75 + outPos] = (byte)((
          //                                [76543210]
          //                          [______54321098________]
           ((in[27 + inPos] & 4194303L) >>> 8)) & 255);
      out[76 + outPos] = (byte)((
          //                                [76543210]
          //                  [______________76543210]
           ((in[27 + inPos] & 4194303L))) & 255);
      out[77 + outPos] = (byte)((
          //                                [76543210]
          //                                [10987654______________]
           ((in[28 + inPos] & 4194303L) >>> 14)) & 255);
      out[78 + outPos] = (byte)((
          //                                [76543210]
          //                        [________32109876______]
           ((in[28 + inPos] & 4194303L) >>> 6)) & 255);
      out[79 + outPos] = (byte)((
          //                                [765432__]
          //                [________________543210]
           ((in[28 + inPos] & 4194303L) <<  2)
        | //                                [______10]
          //                                      [10____________________]
           ((in[29 + inPos] & 4194303L) >>> 20)) & 255);
      out[80 + outPos] = (byte)((
          //                                [76543210]
          //                              [__98765432____________]
           ((in[29 + inPos] & 4194303L) >>> 12)) & 255);
      out[81 + outPos] = (byte)((
          //                                [76543210]
          //                      [__________10987654____]
           ((in[29 + inPos] & 4194303L) >>> 4)) & 255);
      out[82 + outPos] = (byte)((
          //                                [7654____]
          //              [__________________3210]
           ((in[29 + inPos] & 4194303L) <<  4)
        | //                                [____3210]
          //                                    [1098__________________]
           ((in[30 + inPos] & 4194303L) >>> 18)) & 255);
      out[83 + outPos] = (byte)((
          //                                [76543210]
          //                            [____76543210__________]
           ((in[30 + inPos] & 4194303L) >>> 10)) & 255);
      out[84 + outPos] = (byte)((
          //                                [76543210]
          //                    [____________98765432__]
           ((in[30 + inPos] & 4194303L) >>> 2)) & 255);
      out[85 + outPos] = (byte)((
          //                                [76______]
          //            [____________________10]
           ((in[30 + inPos] & 4194303L) <<  6)
        | //                                [__543210]
          //                                  [109876________________]
           ((in[31 + inPos] & 4194303L) >>> 16)) & 255);
      out[86 + outPos] = (byte)((
          //                                [76543210]
          //                          [______54321098________]
           ((in[31 + inPos] & 4194303L) >>> 8)) & 255);
      out[87 + outPos] = (byte)((
          //                                [76543210]
          //                  [______________76543210]
           ((in[31 + inPos] & 4194303L))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                                [76543210]
          //                                [10987654______________]
            ((((long)in[ 0 + inPos]) <<  14) & 4194303L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in[ 1 + inPos]) <<  6) & 16383L)
        | //                                [765432__]
          //                [________________543210]
            ((((long)in[ 2 + inPos]) >>  2) & 63L);
      out[ 1 + outPos] =
          //                                [______10]
          //                                      [10____________________]
            ((((long)in[ 2 + inPos]) <<  20) & 4194303L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in[ 3 + inPos]) <<  12) & 1048575L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in[ 4 + inPos]) <<  4) & 4095L)
        | //                                [7654____]
          //              [__________________3210]
            ((((long)in[ 5 + inPos]) >>  4) & 15L);
      out[ 2 + outPos] =
          //                                [____3210]
          //                                    [1098__________________]
            ((((long)in[ 5 + inPos]) <<  18) & 4194303L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in[ 6 + inPos]) <<  10) & 262143L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in[ 7 + inPos]) <<  2) & 1023L)
        | //                                [76______]
          //            [____________________10]
            ((((long)in[ 8 + inPos]) >>  6) & 3L);
      out[ 3 + outPos] =
          //                                [__543210]
          //                                  [109876________________]
            ((((long)in[ 8 + inPos]) <<  16) & 4194303L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in[ 9 + inPos]) <<  8) & 65535L)
        | //                                [76543210]
          //                  [______________76543210]
            ((((long)in[10 + inPos]) ) & 255L);
      out[ 4 + outPos] =
          //                                [76543210]
          //                                [10987654______________]
            ((((long)in[11 + inPos]) <<  14) & 4194303L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in[12 + inPos]) <<  6) & 16383L)
        | //                                [765432__]
          //                [________________543210]
            ((((long)in[13 + inPos]) >>  2) & 63L);
      out[ 5 + outPos] =
          //                                [______10]
          //                                      [10____________________]
            ((((long)in[13 + inPos]) <<  20) & 4194303L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in[14 + inPos]) <<  12) & 1048575L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in[15 + inPos]) <<  4) & 4095L)
        | //                                [7654____]
          //              [__________________3210]
            ((((long)in[16 + inPos]) >>  4) & 15L);
      out[ 6 + outPos] =
          //                                [____3210]
          //                                    [1098__________________]
            ((((long)in[16 + inPos]) <<  18) & 4194303L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in[17 + inPos]) <<  10) & 262143L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in[18 + inPos]) <<  2) & 1023L)
        | //                                [76______]
          //            [____________________10]
            ((((long)in[19 + inPos]) >>  6) & 3L);
      out[ 7 + outPos] =
          //                                [__543210]
          //                                  [109876________________]
            ((((long)in[19 + inPos]) <<  16) & 4194303L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in[20 + inPos]) <<  8) & 65535L)
        | //                                [76543210]
          //                  [______________76543210]
            ((((long)in[21 + inPos]) ) & 255L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                                [76543210]
          //                                [10987654______________]
            ((((long)in.get( 0 + inPos)) <<  14) & 4194303L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in.get( 1 + inPos)) <<  6) & 16383L)
        | //                                [765432__]
          //                [________________543210]
            ((((long)in.get( 2 + inPos)) >>  2) & 63L);
      out[ 1 + outPos] =
          //                                [______10]
          //                                      [10____________________]
            ((((long)in.get( 2 + inPos)) <<  20) & 4194303L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in.get( 3 + inPos)) <<  12) & 1048575L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in.get( 4 + inPos)) <<  4) & 4095L)
        | //                                [7654____]
          //              [__________________3210]
            ((((long)in.get( 5 + inPos)) >>  4) & 15L);
      out[ 2 + outPos] =
          //                                [____3210]
          //                                    [1098__________________]
            ((((long)in.get( 5 + inPos)) <<  18) & 4194303L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in.get( 6 + inPos)) <<  10) & 262143L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in.get( 7 + inPos)) <<  2) & 1023L)
        | //                                [76______]
          //            [____________________10]
            ((((long)in.get( 8 + inPos)) >>  6) & 3L);
      out[ 3 + outPos] =
          //                                [__543210]
          //                                  [109876________________]
            ((((long)in.get( 8 + inPos)) <<  16) & 4194303L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in.get( 9 + inPos)) <<  8) & 65535L)
        | //                                [76543210]
          //                  [______________76543210]
            ((((long)in.get(10 + inPos)) ) & 255L);
      out[ 4 + outPos] =
          //                                [76543210]
          //                                [10987654______________]
            ((((long)in.get(11 + inPos)) <<  14) & 4194303L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in.get(12 + inPos)) <<  6) & 16383L)
        | //                                [765432__]
          //                [________________543210]
            ((((long)in.get(13 + inPos)) >>  2) & 63L);
      out[ 5 + outPos] =
          //                                [______10]
          //                                      [10____________________]
            ((((long)in.get(13 + inPos)) <<  20) & 4194303L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in.get(14 + inPos)) <<  12) & 1048575L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in.get(15 + inPos)) <<  4) & 4095L)
        | //                                [7654____]
          //              [__________________3210]
            ((((long)in.get(16 + inPos)) >>  4) & 15L);
      out[ 6 + outPos] =
          //                                [____3210]
          //                                    [1098__________________]
            ((((long)in.get(16 + inPos)) <<  18) & 4194303L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in.get(17 + inPos)) <<  10) & 262143L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in.get(18 + inPos)) <<  2) & 1023L)
        | //                                [76______]
          //            [____________________10]
            ((((long)in.get(19 + inPos)) >>  6) & 3L);
      out[ 7 + outPos] =
          //                                [__543210]
          //                                  [109876________________]
            ((((long)in.get(19 + inPos)) <<  16) & 4194303L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in.get(20 + inPos)) <<  8) & 65535L)
        | //                                [76543210]
          //                  [______________76543210]
            ((((long)in.get(21 + inPos)) ) & 255L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                                [76543210]
          //                                [10987654______________]
            ((((long)in[ 0 + inPos]) <<  14) & 4194303L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in[ 1 + inPos]) <<  6) & 16383L)
        | //                                [765432__]
          //                [________________543210]
            ((((long)in[ 2 + inPos]) >>  2) & 63L);
      out[ 1 + outPos] =
          //                                [______10]
          //                                      [10____________________]
            ((((long)in[ 2 + inPos]) <<  20) & 4194303L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in[ 3 + inPos]) <<  12) & 1048575L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in[ 4 + inPos]) <<  4) & 4095L)
        | //                                [7654____]
          //              [__________________3210]
            ((((long)in[ 5 + inPos]) >>  4) & 15L);
      out[ 2 + outPos] =
          //                                [____3210]
          //                                    [1098__________________]
            ((((long)in[ 5 + inPos]) <<  18) & 4194303L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in[ 6 + inPos]) <<  10) & 262143L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in[ 7 + inPos]) <<  2) & 1023L)
        | //                                [76______]
          //            [____________________10]
            ((((long)in[ 8 + inPos]) >>  6) & 3L);
      out[ 3 + outPos] =
          //                                [__543210]
          //                                  [109876________________]
            ((((long)in[ 8 + inPos]) <<  16) & 4194303L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in[ 9 + inPos]) <<  8) & 65535L)
        | //                                [76543210]
          //                  [______________76543210]
            ((((long)in[10 + inPos]) ) & 255L);
      out[ 4 + outPos] =
          //                                [76543210]
          //                                [10987654______________]
            ((((long)in[11 + inPos]) <<  14) & 4194303L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in[12 + inPos]) <<  6) & 16383L)
        | //                                [765432__]
          //                [________________543210]
            ((((long)in[13 + inPos]) >>  2) & 63L);
      out[ 5 + outPos] =
          //                                [______10]
          //                                      [10____________________]
            ((((long)in[13 + inPos]) <<  20) & 4194303L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in[14 + inPos]) <<  12) & 1048575L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in[15 + inPos]) <<  4) & 4095L)
        | //                                [7654____]
          //              [__________________3210]
            ((((long)in[16 + inPos]) >>  4) & 15L);
      out[ 6 + outPos] =
          //                                [____3210]
          //                                    [1098__________________]
            ((((long)in[16 + inPos]) <<  18) & 4194303L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in[17 + inPos]) <<  10) & 262143L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in[18 + inPos]) <<  2) & 1023L)
        | //                                [76______]
          //            [____________________10]
            ((((long)in[19 + inPos]) >>  6) & 3L);
      out[ 7 + outPos] =
          //                                [__543210]
          //                                  [109876________________]
            ((((long)in[19 + inPos]) <<  16) & 4194303L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in[20 + inPos]) <<  8) & 65535L)
        | //                                [76543210]
          //                  [______________76543210]
            ((((long)in[21 + inPos]) ) & 255L);
      out[ 8 + outPos] =
          //                                [76543210]
          //                                [10987654______________]
            ((((long)in[22 + inPos]) <<  14) & 4194303L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in[23 + inPos]) <<  6) & 16383L)
        | //                                [765432__]
          //                [________________543210]
            ((((long)in[24 + inPos]) >>  2) & 63L);
      out[ 9 + outPos] =
          //                                [______10]
          //                                      [10____________________]
            ((((long)in[24 + inPos]) <<  20) & 4194303L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in[25 + inPos]) <<  12) & 1048575L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in[26 + inPos]) <<  4) & 4095L)
        | //                                [7654____]
          //              [__________________3210]
            ((((long)in[27 + inPos]) >>  4) & 15L);
      out[10 + outPos] =
          //                                [____3210]
          //                                    [1098__________________]
            ((((long)in[27 + inPos]) <<  18) & 4194303L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in[28 + inPos]) <<  10) & 262143L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in[29 + inPos]) <<  2) & 1023L)
        | //                                [76______]
          //            [____________________10]
            ((((long)in[30 + inPos]) >>  6) & 3L);
      out[11 + outPos] =
          //                                [__543210]
          //                                  [109876________________]
            ((((long)in[30 + inPos]) <<  16) & 4194303L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in[31 + inPos]) <<  8) & 65535L)
        | //                                [76543210]
          //                  [______________76543210]
            ((((long)in[32 + inPos]) ) & 255L);
      out[12 + outPos] =
          //                                [76543210]
          //                                [10987654______________]
            ((((long)in[33 + inPos]) <<  14) & 4194303L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in[34 + inPos]) <<  6) & 16383L)
        | //                                [765432__]
          //                [________________543210]
            ((((long)in[35 + inPos]) >>  2) & 63L);
      out[13 + outPos] =
          //                                [______10]
          //                                      [10____________________]
            ((((long)in[35 + inPos]) <<  20) & 4194303L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in[36 + inPos]) <<  12) & 1048575L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in[37 + inPos]) <<  4) & 4095L)
        | //                                [7654____]
          //              [__________________3210]
            ((((long)in[38 + inPos]) >>  4) & 15L);
      out[14 + outPos] =
          //                                [____3210]
          //                                    [1098__________________]
            ((((long)in[38 + inPos]) <<  18) & 4194303L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in[39 + inPos]) <<  10) & 262143L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in[40 + inPos]) <<  2) & 1023L)
        | //                                [76______]
          //            [____________________10]
            ((((long)in[41 + inPos]) >>  6) & 3L);
      out[15 + outPos] =
          //                                [__543210]
          //                                  [109876________________]
            ((((long)in[41 + inPos]) <<  16) & 4194303L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in[42 + inPos]) <<  8) & 65535L)
        | //                                [76543210]
          //                  [______________76543210]
            ((((long)in[43 + inPos]) ) & 255L);
      out[16 + outPos] =
          //                                [76543210]
          //                                [10987654______________]
            ((((long)in[44 + inPos]) <<  14) & 4194303L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in[45 + inPos]) <<  6) & 16383L)
        | //                                [765432__]
          //                [________________543210]
            ((((long)in[46 + inPos]) >>  2) & 63L);
      out[17 + outPos] =
          //                                [______10]
          //                                      [10____________________]
            ((((long)in[46 + inPos]) <<  20) & 4194303L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in[47 + inPos]) <<  12) & 1048575L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in[48 + inPos]) <<  4) & 4095L)
        | //                                [7654____]
          //              [__________________3210]
            ((((long)in[49 + inPos]) >>  4) & 15L);
      out[18 + outPos] =
          //                                [____3210]
          //                                    [1098__________________]
            ((((long)in[49 + inPos]) <<  18) & 4194303L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in[50 + inPos]) <<  10) & 262143L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in[51 + inPos]) <<  2) & 1023L)
        | //                                [76______]
          //            [____________________10]
            ((((long)in[52 + inPos]) >>  6) & 3L);
      out[19 + outPos] =
          //                                [__543210]
          //                                  [109876________________]
            ((((long)in[52 + inPos]) <<  16) & 4194303L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in[53 + inPos]) <<  8) & 65535L)
        | //                                [76543210]
          //                  [______________76543210]
            ((((long)in[54 + inPos]) ) & 255L);
      out[20 + outPos] =
          //                                [76543210]
          //                                [10987654______________]
            ((((long)in[55 + inPos]) <<  14) & 4194303L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in[56 + inPos]) <<  6) & 16383L)
        | //                                [765432__]
          //                [________________543210]
            ((((long)in[57 + inPos]) >>  2) & 63L);
      out[21 + outPos] =
          //                                [______10]
          //                                      [10____________________]
            ((((long)in[57 + inPos]) <<  20) & 4194303L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in[58 + inPos]) <<  12) & 1048575L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in[59 + inPos]) <<  4) & 4095L)
        | //                                [7654____]
          //              [__________________3210]
            ((((long)in[60 + inPos]) >>  4) & 15L);
      out[22 + outPos] =
          //                                [____3210]
          //                                    [1098__________________]
            ((((long)in[60 + inPos]) <<  18) & 4194303L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in[61 + inPos]) <<  10) & 262143L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in[62 + inPos]) <<  2) & 1023L)
        | //                                [76______]
          //            [____________________10]
            ((((long)in[63 + inPos]) >>  6) & 3L);
      out[23 + outPos] =
          //                                [__543210]
          //                                  [109876________________]
            ((((long)in[63 + inPos]) <<  16) & 4194303L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in[64 + inPos]) <<  8) & 65535L)
        | //                                [76543210]
          //                  [______________76543210]
            ((((long)in[65 + inPos]) ) & 255L);
      out[24 + outPos] =
          //                                [76543210]
          //                                [10987654______________]
            ((((long)in[66 + inPos]) <<  14) & 4194303L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in[67 + inPos]) <<  6) & 16383L)
        | //                                [765432__]
          //                [________________543210]
            ((((long)in[68 + inPos]) >>  2) & 63L);
      out[25 + outPos] =
          //                                [______10]
          //                                      [10____________________]
            ((((long)in[68 + inPos]) <<  20) & 4194303L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in[69 + inPos]) <<  12) & 1048575L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in[70 + inPos]) <<  4) & 4095L)
        | //                                [7654____]
          //              [__________________3210]
            ((((long)in[71 + inPos]) >>  4) & 15L);
      out[26 + outPos] =
          //                                [____3210]
          //                                    [1098__________________]
            ((((long)in[71 + inPos]) <<  18) & 4194303L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in[72 + inPos]) <<  10) & 262143L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in[73 + inPos]) <<  2) & 1023L)
        | //                                [76______]
          //            [____________________10]
            ((((long)in[74 + inPos]) >>  6) & 3L);
      out[27 + outPos] =
          //                                [__543210]
          //                                  [109876________________]
            ((((long)in[74 + inPos]) <<  16) & 4194303L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in[75 + inPos]) <<  8) & 65535L)
        | //                                [76543210]
          //                  [______________76543210]
            ((((long)in[76 + inPos]) ) & 255L);
      out[28 + outPos] =
          //                                [76543210]
          //                                [10987654______________]
            ((((long)in[77 + inPos]) <<  14) & 4194303L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in[78 + inPos]) <<  6) & 16383L)
        | //                                [765432__]
          //                [________________543210]
            ((((long)in[79 + inPos]) >>  2) & 63L);
      out[29 + outPos] =
          //                                [______10]
          //                                      [10____________________]
            ((((long)in[79 + inPos]) <<  20) & 4194303L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in[80 + inPos]) <<  12) & 1048575L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in[81 + inPos]) <<  4) & 4095L)
        | //                                [7654____]
          //              [__________________3210]
            ((((long)in[82 + inPos]) >>  4) & 15L);
      out[30 + outPos] =
          //                                [____3210]
          //                                    [1098__________________]
            ((((long)in[82 + inPos]) <<  18) & 4194303L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in[83 + inPos]) <<  10) & 262143L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in[84 + inPos]) <<  2) & 1023L)
        | //                                [76______]
          //            [____________________10]
            ((((long)in[85 + inPos]) >>  6) & 3L);
      out[31 + outPos] =
          //                                [__543210]
          //                                  [109876________________]
            ((((long)in[85 + inPos]) <<  16) & 4194303L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in[86 + inPos]) <<  8) & 65535L)
        | //                                [76543210]
          //                  [______________76543210]
            ((((long)in[87 + inPos]) ) & 255L);
    }
    public final void unpack32Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                                [76543210]
          //                                [10987654______________]
            ((((long)in.get( 0 + inPos)) <<  14) & 4194303L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in.get( 1 + inPos)) <<  6) & 16383L)
        | //                                [765432__]
          //                [________________543210]
            ((((long)in.get( 2 + inPos)) >>  2) & 63L);
      out[ 1 + outPos] =
          //                                [______10]
          //                                      [10____________________]
            ((((long)in.get( 2 + inPos)) <<  20) & 4194303L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in.get( 3 + inPos)) <<  12) & 1048575L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in.get( 4 + inPos)) <<  4) & 4095L)
        | //                                [7654____]
          //              [__________________3210]
            ((((long)in.get( 5 + inPos)) >>  4) & 15L);
      out[ 2 + outPos] =
          //                                [____3210]
          //                                    [1098__________________]
            ((((long)in.get( 5 + inPos)) <<  18) & 4194303L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in.get( 6 + inPos)) <<  10) & 262143L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in.get( 7 + inPos)) <<  2) & 1023L)
        | //                                [76______]
          //            [____________________10]
            ((((long)in.get( 8 + inPos)) >>  6) & 3L);
      out[ 3 + outPos] =
          //                                [__543210]
          //                                  [109876________________]
            ((((long)in.get( 8 + inPos)) <<  16) & 4194303L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in.get( 9 + inPos)) <<  8) & 65535L)
        | //                                [76543210]
          //                  [______________76543210]
            ((((long)in.get(10 + inPos)) ) & 255L);
      out[ 4 + outPos] =
          //                                [76543210]
          //                                [10987654______________]
            ((((long)in.get(11 + inPos)) <<  14) & 4194303L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in.get(12 + inPos)) <<  6) & 16383L)
        | //                                [765432__]
          //                [________________543210]
            ((((long)in.get(13 + inPos)) >>  2) & 63L);
      out[ 5 + outPos] =
          //                                [______10]
          //                                      [10____________________]
            ((((long)in.get(13 + inPos)) <<  20) & 4194303L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in.get(14 + inPos)) <<  12) & 1048575L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in.get(15 + inPos)) <<  4) & 4095L)
        | //                                [7654____]
          //              [__________________3210]
            ((((long)in.get(16 + inPos)) >>  4) & 15L);
      out[ 6 + outPos] =
          //                                [____3210]
          //                                    [1098__________________]
            ((((long)in.get(16 + inPos)) <<  18) & 4194303L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in.get(17 + inPos)) <<  10) & 262143L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in.get(18 + inPos)) <<  2) & 1023L)
        | //                                [76______]
          //            [____________________10]
            ((((long)in.get(19 + inPos)) >>  6) & 3L);
      out[ 7 + outPos] =
          //                                [__543210]
          //                                  [109876________________]
            ((((long)in.get(19 + inPos)) <<  16) & 4194303L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in.get(20 + inPos)) <<  8) & 65535L)
        | //                                [76543210]
          //                  [______________76543210]
            ((((long)in.get(21 + inPos)) ) & 255L);
      out[ 8 + outPos] =
          //                                [76543210]
          //                                [10987654______________]
            ((((long)in.get(22 + inPos)) <<  14) & 4194303L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in.get(23 + inPos)) <<  6) & 16383L)
        | //                                [765432__]
          //                [________________543210]
            ((((long)in.get(24 + inPos)) >>  2) & 63L);
      out[ 9 + outPos] =
          //                                [______10]
          //                                      [10____________________]
            ((((long)in.get(24 + inPos)) <<  20) & 4194303L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in.get(25 + inPos)) <<  12) & 1048575L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in.get(26 + inPos)) <<  4) & 4095L)
        | //                                [7654____]
          //              [__________________3210]
            ((((long)in.get(27 + inPos)) >>  4) & 15L);
      out[10 + outPos] =
          //                                [____3210]
          //                                    [1098__________________]
            ((((long)in.get(27 + inPos)) <<  18) & 4194303L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in.get(28 + inPos)) <<  10) & 262143L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in.get(29 + inPos)) <<  2) & 1023L)
        | //                                [76______]
          //            [____________________10]
            ((((long)in.get(30 + inPos)) >>  6) & 3L);
      out[11 + outPos] =
          //                                [__543210]
          //                                  [109876________________]
            ((((long)in.get(30 + inPos)) <<  16) & 4194303L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in.get(31 + inPos)) <<  8) & 65535L)
        | //                                [76543210]
          //                  [______________76543210]
            ((((long)in.get(32 + inPos)) ) & 255L);
      out[12 + outPos] =
          //                                [76543210]
          //                                [10987654______________]
            ((((long)in.get(33 + inPos)) <<  14) & 4194303L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in.get(34 + inPos)) <<  6) & 16383L)
        | //                                [765432__]
          //                [________________543210]
            ((((long)in.get(35 + inPos)) >>  2) & 63L);
      out[13 + outPos] =
          //                                [______10]
          //                                      [10____________________]
            ((((long)in.get(35 + inPos)) <<  20) & 4194303L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in.get(36 + inPos)) <<  12) & 1048575L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in.get(37 + inPos)) <<  4) & 4095L)
        | //                                [7654____]
          //              [__________________3210]
            ((((long)in.get(38 + inPos)) >>  4) & 15L);
      out[14 + outPos] =
          //                                [____3210]
          //                                    [1098__________________]
            ((((long)in.get(38 + inPos)) <<  18) & 4194303L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in.get(39 + inPos)) <<  10) & 262143L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in.get(40 + inPos)) <<  2) & 1023L)
        | //                                [76______]
          //            [____________________10]
            ((((long)in.get(41 + inPos)) >>  6) & 3L);
      out[15 + outPos] =
          //                                [__543210]
          //                                  [109876________________]
            ((((long)in.get(41 + inPos)) <<  16) & 4194303L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in.get(42 + inPos)) <<  8) & 65535L)
        | //                                [76543210]
          //                  [______________76543210]
            ((((long)in.get(43 + inPos)) ) & 255L);
      out[16 + outPos] =
          //                                [76543210]
          //                                [10987654______________]
            ((((long)in.get(44 + inPos)) <<  14) & 4194303L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in.get(45 + inPos)) <<  6) & 16383L)
        | //                                [765432__]
          //                [________________543210]
            ((((long)in.get(46 + inPos)) >>  2) & 63L);
      out[17 + outPos] =
          //                                [______10]
          //                                      [10____________________]
            ((((long)in.get(46 + inPos)) <<  20) & 4194303L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in.get(47 + inPos)) <<  12) & 1048575L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in.get(48 + inPos)) <<  4) & 4095L)
        | //                                [7654____]
          //              [__________________3210]
            ((((long)in.get(49 + inPos)) >>  4) & 15L);
      out[18 + outPos] =
          //                                [____3210]
          //                                    [1098__________________]
            ((((long)in.get(49 + inPos)) <<  18) & 4194303L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in.get(50 + inPos)) <<  10) & 262143L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in.get(51 + inPos)) <<  2) & 1023L)
        | //                                [76______]
          //            [____________________10]
            ((((long)in.get(52 + inPos)) >>  6) & 3L);
      out[19 + outPos] =
          //                                [__543210]
          //                                  [109876________________]
            ((((long)in.get(52 + inPos)) <<  16) & 4194303L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in.get(53 + inPos)) <<  8) & 65535L)
        | //                                [76543210]
          //                  [______________76543210]
            ((((long)in.get(54 + inPos)) ) & 255L);
      out[20 + outPos] =
          //                                [76543210]
          //                                [10987654______________]
            ((((long)in.get(55 + inPos)) <<  14) & 4194303L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in.get(56 + inPos)) <<  6) & 16383L)
        | //                                [765432__]
          //                [________________543210]
            ((((long)in.get(57 + inPos)) >>  2) & 63L);
      out[21 + outPos] =
          //                                [______10]
          //                                      [10____________________]
            ((((long)in.get(57 + inPos)) <<  20) & 4194303L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in.get(58 + inPos)) <<  12) & 1048575L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in.get(59 + inPos)) <<  4) & 4095L)
        | //                                [7654____]
          //              [__________________3210]
            ((((long)in.get(60 + inPos)) >>  4) & 15L);
      out[22 + outPos] =
          //                                [____3210]
          //                                    [1098__________________]
            ((((long)in.get(60 + inPos)) <<  18) & 4194303L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in.get(61 + inPos)) <<  10) & 262143L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in.get(62 + inPos)) <<  2) & 1023L)
        | //                                [76______]
          //            [____________________10]
            ((((long)in.get(63 + inPos)) >>  6) & 3L);
      out[23 + outPos] =
          //                                [__543210]
          //                                  [109876________________]
            ((((long)in.get(63 + inPos)) <<  16) & 4194303L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in.get(64 + inPos)) <<  8) & 65535L)
        | //                                [76543210]
          //                  [______________76543210]
            ((((long)in.get(65 + inPos)) ) & 255L);
      out[24 + outPos] =
          //                                [76543210]
          //                                [10987654______________]
            ((((long)in.get(66 + inPos)) <<  14) & 4194303L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in.get(67 + inPos)) <<  6) & 16383L)
        | //                                [765432__]
          //                [________________543210]
            ((((long)in.get(68 + inPos)) >>  2) & 63L);
      out[25 + outPos] =
          //                                [______10]
          //                                      [10____________________]
            ((((long)in.get(68 + inPos)) <<  20) & 4194303L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in.get(69 + inPos)) <<  12) & 1048575L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in.get(70 + inPos)) <<  4) & 4095L)
        | //                                [7654____]
          //              [__________________3210]
            ((((long)in.get(71 + inPos)) >>  4) & 15L);
      out[26 + outPos] =
          //                                [____3210]
          //                                    [1098__________________]
            ((((long)in.get(71 + inPos)) <<  18) & 4194303L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in.get(72 + inPos)) <<  10) & 262143L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in.get(73 + inPos)) <<  2) & 1023L)
        | //                                [76______]
          //            [____________________10]
            ((((long)in.get(74 + inPos)) >>  6) & 3L);
      out[27 + outPos] =
          //                                [__543210]
          //                                  [109876________________]
            ((((long)in.get(74 + inPos)) <<  16) & 4194303L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in.get(75 + inPos)) <<  8) & 65535L)
        | //                                [76543210]
          //                  [______________76543210]
            ((((long)in.get(76 + inPos)) ) & 255L);
      out[28 + outPos] =
          //                                [76543210]
          //                                [10987654______________]
            ((((long)in.get(77 + inPos)) <<  14) & 4194303L)
        | //                                [76543210]
          //                        [________32109876______]
            ((((long)in.get(78 + inPos)) <<  6) & 16383L)
        | //                                [765432__]
          //                [________________543210]
            ((((long)in.get(79 + inPos)) >>  2) & 63L);
      out[29 + outPos] =
          //                                [______10]
          //                                      [10____________________]
            ((((long)in.get(79 + inPos)) <<  20) & 4194303L)
        | //                                [76543210]
          //                              [__98765432____________]
            ((((long)in.get(80 + inPos)) <<  12) & 1048575L)
        | //                                [76543210]
          //                      [__________10987654____]
            ((((long)in.get(81 + inPos)) <<  4) & 4095L)
        | //                                [7654____]
          //              [__________________3210]
            ((((long)in.get(82 + inPos)) >>  4) & 15L);
      out[30 + outPos] =
          //                                [____3210]
          //                                    [1098__________________]
            ((((long)in.get(82 + inPos)) <<  18) & 4194303L)
        | //                                [76543210]
          //                            [____76543210__________]
            ((((long)in.get(83 + inPos)) <<  10) & 262143L)
        | //                                [76543210]
          //                    [____________98765432__]
            ((((long)in.get(84 + inPos)) <<  2) & 1023L)
        | //                                [76______]
          //            [____________________10]
            ((((long)in.get(85 + inPos)) >>  6) & 3L);
      out[31 + outPos] =
          //                                [__543210]
          //                                  [109876________________]
            ((((long)in.get(85 + inPos)) <<  16) & 4194303L)
        | //                                [76543210]
          //                          [______54321098________]
            ((((long)in.get(86 + inPos)) <<  8) & 65535L)
        | //                                [76543210]
          //                  [______________76543210]
            ((((long)in.get(87 + inPos)) ) & 255L);
    }
  }

  private static final class Packer23 extends BytePackerForLong {

    private Packer23() {
      super(23);
    }

    public final void pack8Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                                 [76543210]
          //                                 [21098765_______________]
           ((in[ 0 + inPos] & 8388607L) >>> 15)) & 255);
      out[ 1 + outPos] = (byte)((
          //                                 [76543210]
          //                         [________43210987_______]
           ((in[ 0 + inPos] & 8388607L) >>> 7)) & 255);
      out[ 2 + outPos] = (byte)((
          //                                 [7654321_]
          //                 [________________6543210]
           ((in[ 0 + inPos] & 8388607L) <<  1)
        | //                                 [_______0]
          //                                        [2______________________]
           ((in[ 1 + inPos] & 8388607L) >>> 22)) & 255);
      out[ 3 + outPos] = (byte)((
          //                                 [76543210]
          //                                [_10987654______________]
           ((in[ 1 + inPos] & 8388607L) >>> 14)) & 255);
      out[ 4 + outPos] = (byte)((
          //                                 [76543210]
          //                        [_________32109876______]
           ((in[ 1 + inPos] & 8388607L) >>> 6)) & 255);
      out[ 5 + outPos] = (byte)((
          //                                 [765432__]
          //                [_________________543210]
           ((in[ 1 + inPos] & 8388607L) <<  2)
        | //                                 [______10]
          //                                       [21_____________________]
           ((in[ 2 + inPos] & 8388607L) >>> 21)) & 255);
      out[ 6 + outPos] = (byte)((
          //                                 [76543210]
          //                               [__09876543_____________]
           ((in[ 2 + inPos] & 8388607L) >>> 13)) & 255);
      out[ 7 + outPos] = (byte)((
          //                                 [76543210]
          //                       [__________21098765_____]
           ((in[ 2 + inPos] & 8388607L) >>> 5)) & 255);
      out[ 8 + outPos] = (byte)((
          //                                 [76543___]
          //               [__________________43210]
           ((in[ 2 + inPos] & 8388607L) <<  3)
        | //                                 [_____210]
          //                                      [210____________________]
           ((in[ 3 + inPos] & 8388607L) >>> 20)) & 255);
      out[ 9 + outPos] = (byte)((
          //                                 [76543210]
          //                              [___98765432____________]
           ((in[ 3 + inPos] & 8388607L) >>> 12)) & 255);
      out[10 + outPos] = (byte)((
          //                                 [76543210]
          //                      [___________10987654____]
           ((in[ 3 + inPos] & 8388607L) >>> 4)) & 255);
      out[11 + outPos] = (byte)((
          //                                 [7654____]
          //              [___________________3210]
           ((in[ 3 + inPos] & 8388607L) <<  4)
        | //                                 [____3210]
          //                                     [2109___________________]
           ((in[ 4 + inPos] & 8388607L) >>> 19)) & 255);
      out[12 + outPos] = (byte)((
          //                                 [76543210]
          //                             [____87654321___________]
           ((in[ 4 + inPos] & 8388607L) >>> 11)) & 255);
      out[13 + outPos] = (byte)((
          //                                 [76543210]
          //                     [____________09876543___]
           ((in[ 4 + inPos] & 8388607L) >>> 3)) & 255);
      out[14 + outPos] = (byte)((
          //                                 [765_____]
          //             [____________________210]
           ((in[ 4 + inPos] & 8388607L) <<  5)
        | //                                 [___43210]
          //                                    [21098__________________]
           ((in[ 5 + inPos] & 8388607L) >>> 18)) & 255);
      out[15 + outPos] = (byte)((
          //                                 [76543210]
          //                            [_____76543210__________]
           ((in[ 5 + inPos] & 8388607L) >>> 10)) & 255);
      out[16 + outPos] = (byte)((
          //                                 [76543210]
          //                    [_____________98765432__]
           ((in[ 5 + inPos] & 8388607L) >>> 2)) & 255);
      out[17 + outPos] = (byte)((
          //                                 [76______]
          //            [_____________________10]
           ((in[ 5 + inPos] & 8388607L) <<  6)
        | //                                 [__543210]
          //                                   [210987_________________]
           ((in[ 6 + inPos] & 8388607L) >>> 17)) & 255);
      out[18 + outPos] = (byte)((
          //                                 [76543210]
          //                           [______65432109_________]
           ((in[ 6 + inPos] & 8388607L) >>> 9)) & 255);
      out[19 + outPos] = (byte)((
          //                                 [76543210]
          //                   [______________87654321_]
           ((in[ 6 + inPos] & 8388607L) >>> 1)) & 255);
      out[20 + outPos] = (byte)((
          //                                 [7_______]
          //           [______________________0]
           ((in[ 6 + inPos] & 8388607L) <<  7)
        | //                                 [_6543210]
          //                                  [2109876________________]
           ((in[ 7 + inPos] & 8388607L) >>> 16)) & 255);
      out[21 + outPos] = (byte)((
          //                                 [76543210]
          //                          [_______54321098________]
           ((in[ 7 + inPos] & 8388607L) >>> 8)) & 255);
      out[22 + outPos] = (byte)((
          //                                 [76543210]
          //                  [_______________76543210]
           ((in[ 7 + inPos] & 8388607L))) & 255);
    }
    public final void pack32Values(final long[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                                 [76543210]
          //                                 [21098765_______________]
           ((in[ 0 + inPos] & 8388607L) >>> 15)) & 255);
      out[ 1 + outPos] = (byte)((
          //                                 [76543210]
          //                         [________43210987_______]
           ((in[ 0 + inPos] & 8388607L) >>> 7)) & 255);
      out[ 2 + outPos] = (byte)((
          //                                 [7654321_]
          //                 [________________6543210]
           ((in[ 0 + inPos] & 8388607L) <<  1)
        | //                                 [_______0]
          //                                        [2______________________]
           ((in[ 1 + inPos] & 8388607L) >>> 22)) & 255);
      out[ 3 + outPos] = (byte)((
          //                                 [76543210]
          //                                [_10987654______________]
           ((in[ 1 + inPos] & 8388607L) >>> 14)) & 255);
      out[ 4 + outPos] = (byte)((
          //                                 [76543210]
          //                        [_________32109876______]
           ((in[ 1 + inPos] & 8388607L) >>> 6)) & 255);
      out[ 5 + outPos] = (byte)((
          //                                 [765432__]
          //                [_________________543210]
           ((in[ 1 + inPos] & 8388607L) <<  2)
        | //                                 [______10]
          //                                       [21_____________________]
           ((in[ 2 + inPos] & 8388607L) >>> 21)) & 255);
      out[ 6 + outPos] = (byte)((
          //                                 [76543210]
          //                               [__09876543_____________]
           ((in[ 2 + inPos] & 8388607L) >>> 13)) & 255);
      out[ 7 + outPos] = (byte)((
          //                                 [76543210]
          //                       [__________21098765_____]
           ((in[ 2 + inPos] & 8388607L) >>> 5)) & 255);
      out[ 8 + outPos] = (byte)((
          //                                 [76543___]
          //               [__________________43210]
           ((in[ 2 + inPos] & 8388607L) <<  3)
        | //                                 [_____210]
          //                                      [210____________________]
           ((in[ 3 + inPos] & 8388607L) >>> 20)) & 255);
      out[ 9 + outPos] = (byte)((
          //                                 [76543210]
          //                              [___98765432____________]
           ((in[ 3 + inPos] & 8388607L) >>> 12)) & 255);
      out[10 + outPos] = (byte)((
          //                                 [76543210]
          //                      [___________10987654____]
           ((in[ 3 + inPos] & 8388607L) >>> 4)) & 255);
      out[11 + outPos] = (byte)((
          //                                 [7654____]
          //              [___________________3210]
           ((in[ 3 + inPos] & 8388607L) <<  4)
        | //                                 [____3210]
          //                                     [2109___________________]
           ((in[ 4 + inPos] & 8388607L) >>> 19)) & 255);
      out[12 + outPos] = (byte)((
          //                                 [76543210]
          //                             [____87654321___________]
           ((in[ 4 + inPos] & 8388607L) >>> 11)) & 255);
      out[13 + outPos] = (byte)((
          //                                 [76543210]
          //                     [____________09876543___]
           ((in[ 4 + inPos] & 8388607L) >>> 3)) & 255);
      out[14 + outPos] = (byte)((
          //                                 [765_____]
          //             [____________________210]
           ((in[ 4 + inPos] & 8388607L) <<  5)
        | //                                 [___43210]
          //                                    [21098__________________]
           ((in[ 5 + inPos] & 8388607L) >>> 18)) & 255);
      out[15 + outPos] = (byte)((
          //                                 [76543210]
          //                            [_____76543210__________]
           ((in[ 5 + inPos] & 8388607L) >>> 10)) & 255);
      out[16 + outPos] = (byte)((
          //                                 [76543210]
          //                    [_____________98765432__]
           ((in[ 5 + inPos] & 8388607L) >>> 2)) & 255);
      out[17 + outPos] = (byte)((
          //                                 [76______]
          //            [_____________________10]
           ((in[ 5 + inPos] & 8388607L) <<  6)
        | //                                 [__543210]
          //                                   [210987_________________]
           ((in[ 6 + inPos] & 8388607L) >>> 17)) & 255);
      out[18 + outPos] = (byte)((
          //                                 [76543210]
          //                           [______65432109_________]
           ((in[ 6 + inPos] & 8388607L) >>> 9)) & 255);
      out[19 + outPos] = (byte)((
          //                                 [76543210]
          //                   [______________87654321_]
           ((in[ 6 + inPos] & 8388607L) >>> 1)) & 255);
      out[20 + outPos] = (byte)((
          //                                 [7_______]
          //           [______________________0]
           ((in[ 6 + inPos] & 8388607L) <<  7)
        | //                                 [_6543210]
          //                                  [2109876________________]
           ((in[ 7 + inPos] & 8388607L) >>> 16)) & 255);
      out[21 + outPos] = (byte)((
          //                                 [76543210]
          //                          [_______54321098________]
           ((in[ 7 + inPos] & 8388607L) >>> 8)) & 255);
      out[22 + outPos] = (byte)((
          //                                 [76543210]
          //                  [_______________76543210]
           ((in[ 7 + inPos] & 8388607L))) & 255);
      out[23 + outPos] = (byte)((
          //                                 [76543210]
          //                                 [21098765_______________]
           ((in[ 8 + inPos] & 8388607L) >>> 15)) & 255);
      out[24 + outPos] = (byte)((
          //                                 [76543210]
          //                         [________43210987_______]
           ((in[ 8 + inPos] & 8388607L) >>> 7)) & 255);
      out[25 + outPos] = (byte)((
          //                                 [7654321_]
          //                 [________________6543210]
           ((in[ 8 + inPos] & 8388607L) <<  1)
        | //                                 [_______0]
          //                                        [2______________________]
           ((in[ 9 + inPos] & 8388607L) >>> 22)) & 255);
      out[26 + outPos] = (byte)((
          //                                 [76543210]
          //                                [_10987654______________]
           ((in[ 9 + inPos] & 8388607L) >>> 14)) & 255);
      out[27 + outPos] = (byte)((
          //                                 [76543210]
          //                        [_________32109876______]
           ((in[ 9 + inPos] & 8388607L) >>> 6)) & 255);
      out[28 + outPos] = (byte)((
          //                                 [765432__]
          //                [_________________543210]
           ((in[ 9 + inPos] & 8388607L) <<  2)
        | //                                 [______10]
          //                                       [21_____________________]
           ((in[10 + inPos] & 8388607L) >>> 21)) & 255);
      out[29 + outPos] = (byte)((
          //                                 [76543210]
          //                               [__09876543_____________]
           ((in[10 + inPos] & 8388607L) >>> 13)) & 255);
      out[30 + outPos] = (byte)((
          //                                 [76543210]
          //                       [__________21098765_____]
           ((in[10 + inPos] & 8388607L) >>> 5)) & 255);
      out[31 + outPos] = (byte)((
          //                                 [76543___]
          //               [__________________43210]
           ((in[10 + inPos] & 8388607L) <<  3)
        | //                                 [_____210]
          //                                      [210____________________]
           ((in[11 + inPos] & 8388607L) >>> 20)) & 255);
      out[32 + outPos] = (byte)((
          //                                 [76543210]
          //                              [___98765432____________]
           ((in[11 + inPos] & 8388607L) >>> 12)) & 255);
      out[33 + outPos] = (byte)((
          //                                 [76543210]
          //                      [___________10987654____]
           ((in[11 + inPos] & 8388607L) >>> 4)) & 255);
      out[34 + outPos] = (byte)((
          //                                 [7654____]
          //              [___________________3210]
           ((in[11 + inPos] & 8388607L) <<  4)
        | //                                 [____3210]
          //                                     [2109___________________]
           ((in[12 + inPos] & 8388607L) >>> 19)) & 255);
      out[35 + outPos] = (byte)((
          //                                 [76543210]
          //                             [____87654321___________]
           ((in[12 + inPos] & 8388607L) >>> 11)) & 255);
      out[36 + outPos] = (byte)((
          //                                 [76543210]
          //                     [____________09876543___]
           ((in[12 + inPos] & 8388607L) >>> 3)) & 255);
      out[37 + outPos] = (byte)((
          //                                 [765_____]
          //             [____________________210]
           ((in[12 + inPos] & 8388607L) <<  5)
        | //                                 [___43210]
          //                                    [21098__________________]
           ((in[13 + inPos] & 8388607L) >>> 18)) & 255);
      out[38 + outPos] = (byte)((
          //                                 [76543210]
          //                            [_____76543210__________]
           ((in[13 + inPos] & 8388607L) >>> 10)) & 255);
      out[39 + outPos] = (byte)((
          //                                 [76543210]
          //                    [_____________98765432__]
           ((in[13 + inPos] & 8388607L) >>> 2)) & 255);
      out[40 + outPos] = (byte)((
          //                                 [76______]
          //            [_____________________10]
           ((in[13 + inPos] & 8388607L) <<  6)
        | //                                 [__543210]
          //                                   [210987_________________]
           ((in[14 + inPos] & 8388607L) >>> 17)) & 255);
      out[41 + outPos] = (byte)((
          //                                 [76543210]
          //                           [______65432109_________]
           ((in[14 + inPos] & 8388607L) >>> 9)) & 255);
      out[42 + outPos] = (byte)((
          //                                 [76543210]
          //                   [______________87654321_]
           ((in[14 + inPos] & 8388607L) >>> 1)) & 255);
      out[43 + outPos] = (byte)((
          //                                 [7_______]
          //           [______________________0]
           ((in[14 + inPos] & 8388607L) <<  7)
        | //                                 [_6543210]
          //                                  [2109876________________]
           ((in[15 + inPos] & 8388607L) >>> 16)) & 255);
      out[44 + outPos] = (byte)((
          //                                 [76543210]
          //                          [_______54321098________]
           ((in[15 + inPos] & 8388607L) >>> 8)) & 255);
      out[45 + outPos] = (byte)((
          //                                 [76543210]
          //                  [_______________76543210]
           ((in[15 + inPos] & 8388607L))) & 255);
      out[46 + outPos] = (byte)((
          //                                 [76543210]
          //                                 [21098765_______________]
           ((in[16 + inPos] & 8388607L) >>> 15)) & 255);
      out[47 + outPos] = (byte)((
          //                                 [76543210]
          //                         [________43210987_______]
           ((in[16 + inPos] & 8388607L) >>> 7)) & 255);
      out[48 + outPos] = (byte)((
          //                                 [7654321_]
          //                 [________________6543210]
           ((in[16 + inPos] & 8388607L) <<  1)
        | //                                 [_______0]
          //                                        [2______________________]
           ((in[17 + inPos] & 8388607L) >>> 22)) & 255);
      out[49 + outPos] = (byte)((
          //                                 [76543210]
          //                                [_10987654______________]
           ((in[17 + inPos] & 8388607L) >>> 14)) & 255);
      out[50 + outPos] = (byte)((
          //                                 [76543210]
          //                        [_________32109876______]
           ((in[17 + inPos] & 8388607L) >>> 6)) & 255);
      out[51 + outPos] = (byte)((
          //                                 [765432__]
          //                [_________________543210]
           ((in[17 + inPos] & 8388607L) <<  2)
        | //                                 [______10]
          //                                       [21_____________________]
           ((in[18 + inPos] & 8388607L) >>> 21)) & 255);
      out[52 + outPos] = (byte)((
          //                                 [76543210]
          //                               [__09876543_____________]
           ((in[18 + inPos] & 8388607L) >>> 13)) & 255);
      out[53 + outPos] = (byte)((
          //                                 [76543210]
          //                       [__________21098765_____]
           ((in[18 + inPos] & 8388607L) >>> 5)) & 255);
      out[54 + outPos] = (byte)((
          //                                 [76543___]
          //               [__________________43210]
           ((in[18 + inPos] & 8388607L) <<  3)
        | //                                 [_____210]
          //                                      [210____________________]
           ((in[19 + inPos] & 8388607L) >>> 20)) & 255);
      out[55 + outPos] = (byte)((
          //                                 [76543210]
          //                              [___98765432____________]
           ((in[19 + inPos] & 8388607L) >>> 12)) & 255);
      out[56 + outPos] = (byte)((
          //                                 [76543210]
          //                      [___________10987654____]
           ((in[19 + inPos] & 8388607L) >>> 4)) & 255);
      out[57 + outPos] = (byte)((
          //                                 [7654____]
          //              [___________________3210]
           ((in[19 + inPos] & 8388607L) <<  4)
        | //                                 [____3210]
          //                                     [2109___________________]
           ((in[20 + inPos] & 8388607L) >>> 19)) & 255);
      out[58 + outPos] = (byte)((
          //                                 [76543210]
          //                             [____87654321___________]
           ((in[20 + inPos] & 8388607L) >>> 11)) & 255);
      out[59 + outPos] = (byte)((
          //                                 [76543210]
          //                     [____________09876543___]
           ((in[20 + inPos] & 8388607L) >>> 3)) & 255);
      out[60 + outPos] = (byte)((
          //                                 [765_____]
          //             [____________________210]
           ((in[20 + inPos] & 8388607L) <<  5)
        | //                                 [___43210]
          //                                    [21098__________________]
           ((in[21 + inPos] & 8388607L) >>> 18)) & 255);
      out[61 + outPos] = (byte)((
          //                                 [76543210]
          //                            [_____76543210__________]
           ((in[21 + inPos] & 8388607L) >>> 10)) & 255);
      out[62 + outPos] = (byte)((
          //                                 [76543210]
          //                    [_____________98765432__]
           ((in[21 + inPos] & 8388607L) >>> 2)) & 255);
      out[63 + outPos] = (byte)((
          //                                 [76______]
          //            [_____________________10]
           ((in[21 + inPos] & 8388607L) <<  6)
        | //                                 [__543210]
          //                                   [210987_________________]
           ((in[22 + inPos] & 8388607L) >>> 17)) & 255);
      out[64 + outPos] = (byte)((
          //                                 [76543210]
          //                           [______65432109_________]
           ((in[22 + inPos] & 8388607L) >>> 9)) & 255);
      out[65 + outPos] = (byte)((
          //                                 [76543210]
          //                   [______________87654321_]
           ((in[22 + inPos] & 8388607L) >>> 1)) & 255);
      out[66 + outPos] = (byte)((
          //                                 [7_______]
          //           [______________________0]
           ((in[22 + inPos] & 8388607L) <<  7)
        | //                                 [_6543210]
          //                                  [2109876________________]
           ((in[23 + inPos] & 8388607L) >>> 16)) & 255);
      out[67 + outPos] = (byte)((
          //                                 [76543210]
          //                          [_______54321098________]
           ((in[23 + inPos] & 8388607L) >>> 8)) & 255);
      out[68 + outPos] = (byte)((
          //                                 [76543210]
          //                  [_______________76543210]
           ((in[23 + inPos] & 8388607L))) & 255);
      out[69 + outPos] = (byte)((
          //                                 [76543210]
          //                                 [21098765_______________]
           ((in[24 + inPos] & 8388607L) >>> 15)) & 255);
      out[70 + outPos] = (byte)((
          //                                 [76543210]
          //                         [________43210987_______]
           ((in[24 + inPos] & 8388607L) >>> 7)) & 255);
      out[71 + outPos] = (byte)((
          //                                 [7654321_]
          //                 [________________6543210]
           ((in[24 + inPos] & 8388607L) <<  1)
        | //                                 [_______0]
          //                                        [2______________________]
           ((in[25 + inPos] & 8388607L) >>> 22)) & 255);
      out[72 + outPos] = (byte)((
          //                                 [76543210]
          //                                [_10987654______________]
           ((in[25 + inPos] & 8388607L) >>> 14)) & 255);
      out[73 + outPos] = (byte)((
          //                                 [76543210]
          //                        [_________32109876______]
           ((in[25 + inPos] & 8388607L) >>> 6)) & 255);
      out[74 + outPos] = (byte)((
          //                                 [765432__]
          //                [_________________543210]
           ((in[25 + inPos] & 8388607L) <<  2)
        | //                                 [______10]
          //                                       [21_____________________]
           ((in[26 + inPos] & 8388607L) >>> 21)) & 255);
      out[75 + outPos] = (byte)((
          //                                 [76543210]
          //                               [__09876543_____________]
           ((in[26 + inPos] & 8388607L) >>> 13)) & 255);
      out[76 + outPos] = (byte)((
          //                                 [76543210]
          //                       [__________21098765_____]
           ((in[26 + inPos] & 8388607L) >>> 5)) & 255);
      out[77 + outPos] = (byte)((
          //                                 [76543___]
          //               [__________________43210]
           ((in[26 + inPos] & 8388607L) <<  3)
        | //                                 [_____210]
          //                                      [210____________________]
           ((in[27 + inPos] & 8388607L) >>> 20)) & 255);
      out[78 + outPos] = (byte)((
          //                                 [76543210]
          //                              [___98765432____________]
           ((in[27 + inPos] & 8388607L) >>> 12)) & 255);
      out[79 + outPos] = (byte)((
          //                                 [76543210]
          //                      [___________10987654____]
           ((in[27 + inPos] & 8388607L) >>> 4)) & 255);
      out[80 + outPos] = (byte)((
          //                                 [7654____]
          //              [___________________3210]
           ((in[27 + inPos] & 8388607L) <<  4)
        | //                                 [____3210]
          //                                     [2109___________________]
           ((in[28 + inPos] & 8388607L) >>> 19)) & 255);
      out[81 + outPos] = (byte)((
          //                                 [76543210]
          //                             [____87654321___________]
           ((in[28 + inPos] & 8388607L) >>> 11)) & 255);
      out[82 + outPos] = (byte)((
          //                                 [76543210]
          //                     [____________09876543___]
           ((in[28 + inPos] & 8388607L) >>> 3)) & 255);
      out[83 + outPos] = (byte)((
          //                                 [765_____]
          //             [____________________210]
           ((in[28 + inPos] & 8388607L) <<  5)
        | //                                 [___43210]
          //                                    [21098__________________]
           ((in[29 + inPos] & 8388607L) >>> 18)) & 255);
      out[84 + outPos] = (byte)((
          //                                 [76543210]
          //                            [_____76543210__________]
           ((in[29 + inPos] & 8388607L) >>> 10)) & 255);
      out[85 + outPos] = (byte)((
          //                                 [76543210]
          //                    [_____________98765432__]
           ((in[29 + inPos] & 8388607L) >>> 2)) & 255);
      out[86 + outPos] = (byte)((
          //                                 [76______]
          //            [_____________________10]
           ((in[29 + inPos] & 8388607L) <<  6)
        | //                                 [__543210]
          //                                   [210987_________________]
           ((in[30 + inPos] & 8388607L) >>> 17)) & 255);
      out[87 + outPos] = (byte)((
          //                                 [76543210]
          //                           [______65432109_________]
           ((in[30 + inPos] & 8388607L) >>> 9)) & 255);
      out[88 + outPos] = (byte)((
          //                                 [76543210]
          //                   [______________87654321_]
           ((in[30 + inPos] & 8388607L) >>> 1)) & 255);
      out[89 + outPos] = (byte)((
          //                                 [7_______]
          //           [______________________0]
           ((in[30 + inPos] & 8388607L) <<  7)
        | //                                 [_6543210]
          //                                  [2109876________________]
           ((in[31 + inPos] & 8388607L) >>> 16)) & 255);
      out[90 + outPos] = (byte)((
          //                                 [76543210]
          //                          [_______54321098________]
           ((in[31 + inPos] & 8388607L) >>> 8)) & 255);
      out[91 + outPos] = (byte)((
          //                                 [76543210]
          //                  [_______________76543210]
           ((in[31 + inPos] & 8388607L))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                                 [76543210]
          //                                 [21098765_______________]
            ((((long)in[ 0 + inPos]) <<  15) & 8388607L)
        | //                                 [76543210]
          //                         [________43210987_______]
            ((((long)in[ 1 + inPos]) <<  7) & 32767L)
        | //                                 [7654321_]
          //                 [________________6543210]
            ((((long)in[ 2 + inPos]) >>  1) & 127L);
      out[ 1 + outPos] =
          //                                 [_______0]
          //                                        [2______________________]
            ((((long)in[ 2 + inPos]) <<  22) & 8388607L)
        | //                                 [76543210]
          //                                [_10987654______________]
            ((((long)in[ 3 + inPos]) <<  14) & 4194303L)
        | //                                 [76543210]
          //                        [_________32109876______]
            ((((long)in[ 4 + inPos]) <<  6) & 16383L)
        | //                                 [765432__]
          //                [_________________543210]
            ((((long)in[ 5 + inPos]) >>  2) & 63L);
      out[ 2 + outPos] =
          //                                 [______10]
          //                                       [21_____________________]
            ((((long)in[ 5 + inPos]) <<  21) & 8388607L)
        | //                                 [76543210]
          //                               [__09876543_____________]
            ((((long)in[ 6 + inPos]) <<  13) & 2097151L)
        | //                                 [76543210]
          //                       [__________21098765_____]
            ((((long)in[ 7 + inPos]) <<  5) & 8191L)
        | //                                 [76543___]
          //               [__________________43210]
            ((((long)in[ 8 + inPos]) >>  3) & 31L);
      out[ 3 + outPos] =
          //                                 [_____210]
          //                                      [210____________________]
            ((((long)in[ 8 + inPos]) <<  20) & 8388607L)
        | //                                 [76543210]
          //                              [___98765432____________]
            ((((long)in[ 9 + inPos]) <<  12) & 1048575L)
        | //                                 [76543210]
          //                      [___________10987654____]
            ((((long)in[10 + inPos]) <<  4) & 4095L)
        | //                                 [7654____]
          //              [___________________3210]
            ((((long)in[11 + inPos]) >>  4) & 15L);
      out[ 4 + outPos] =
          //                                 [____3210]
          //                                     [2109___________________]
            ((((long)in[11 + inPos]) <<  19) & 8388607L)
        | //                                 [76543210]
          //                             [____87654321___________]
            ((((long)in[12 + inPos]) <<  11) & 524287L)
        | //                                 [76543210]
          //                     [____________09876543___]
            ((((long)in[13 + inPos]) <<  3) & 2047L)
        | //                                 [765_____]
          //             [____________________210]
            ((((long)in[14 + inPos]) >>  5) & 7L);
      out[ 5 + outPos] =
          //                                 [___43210]
          //                                    [21098__________________]
            ((((long)in[14 + inPos]) <<  18) & 8388607L)
        | //                                 [76543210]
          //                            [_____76543210__________]
            ((((long)in[15 + inPos]) <<  10) & 262143L)
        | //                                 [76543210]
          //                    [_____________98765432__]
            ((((long)in[16 + inPos]) <<  2) & 1023L)
        | //                                 [76______]
          //            [_____________________10]
            ((((long)in[17 + inPos]) >>  6) & 3L);
      out[ 6 + outPos] =
          //                                 [__543210]
          //                                   [210987_________________]
            ((((long)in[17 + inPos]) <<  17) & 8388607L)
        | //                                 [76543210]
          //                           [______65432109_________]
            ((((long)in[18 + inPos]) <<  9) & 131071L)
        | //                                 [76543210]
          //                   [______________87654321_]
            ((((long)in[19 + inPos]) <<  1) & 511L)
        | //                                 [7_______]
          //           [______________________0]
            ((((long)in[20 + inPos]) >>  7) & 1L);
      out[ 7 + outPos] =
          //                                 [_6543210]
          //                                  [2109876________________]
            ((((long)in[20 + inPos]) <<  16) & 8388607L)
        | //                                 [76543210]
          //                          [_______54321098________]
            ((((long)in[21 + inPos]) <<  8) & 65535L)
        | //                                 [76543210]
          //                  [_______________76543210]
            ((((long)in[22 + inPos]) ) & 255L);
    }
    public final void unpack8Values(final ByteBuffer in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                                 [76543210]
          //                                 [21098765_______________]
            ((((long)in.get( 0 + inPos)) <<  15) & 8388607L)
        | //                                 [76543210]
          //                         [________43210987_______]
            ((((long)in.get( 1 + inPos)) <<  7) & 32767L)
        | //                                 [7654321_]
          //                 [________________6543210]
            ((((long)in.get( 2 + inPos)) >>  1) & 127L);
      out[ 1 + outPos] =
          //                                 [_______0]
          //                                        [2______________________]
            ((((long)in.get( 2 + inPos)) <<  22) & 8388607L)
        | //                                 [76543210]
          //                                [_10987654______________]
            ((((long)in.get( 3 + inPos)) <<  14) & 4194303L)
        | //                                 [76543210]
          //                        [_________32109876______]
            ((((long)in.get( 4 + inPos)) <<  6) & 16383L)
        | //                                 [765432__]
          //                [_________________543210]
            ((((long)in.get( 5 + inPos)) >>  2) & 63L);
      out[ 2 + outPos] =
          //                                 [______10]
          //                                       [21_____________________]
            ((((long)in.get( 5 + inPos)) <<  21) & 8388607L)
        | //                                 [76543210]
          //                               [__09876543_____________]
            ((((long)in.get( 6 + inPos)) <<  13) & 2097151L)
        | //                                 [76543210]
          //                       [__________21098765_____]
            ((((long)in.get( 7 + inPos)) <<  5) & 8191L)
        | //                                 [76543___]
          //               [__________________43210]
            ((((long)in.get( 8 + inPos)) >>  3) & 31L);
      out[ 3 + outPos] =
          //                                 [_____210]
          //                                      [210____________________]
            ((((long)in.get( 8 + inPos)) <<  20) & 8388607L)
        | //                                 [76543210]
          //                              [___98765432____________]
            ((((long)in.get( 9 + inPos)) <<  12) & 1048575L)
        | //                                 [76543210]
          //                      [___________10987654____]
            ((((long)in.get(10 + inPos)) <<  4) & 4095L)
        | //                                 [7654____]
          //              [___________________3210]
            ((((long)in.get(11 + inPos)) >>  4) & 15L);
      out[ 4 + outPos] =
          //                                 [____3210]
          //                                     [2109___________________]
            ((((long)in.get(11 + inPos)) <<  19) & 8388607L)
        | //                                 [76543210]
          //                             [____87654321___________]
            ((((long)in.get(12 + inPos)) <<  11) & 524287L)
        | //                                 [76543210]
          //                     [____________09876543___]
            ((((long)in.get(13 + inPos)) <<  3) & 2047L)
        | //                                 [765_____]
          //             [____________________210]
            ((((long)in.get(14 + inPos)) >>  5) & 7L);
      out[ 5 + outPos] =
          //                                 [___43210]
          //                                    [21098__________________]
            ((((long)in.get(14 + inPos)) <<  18) & 8388607L)
        | //                                 [76543210]
          //                            [_____76543210__________]
            ((((long)in.get(15 + inPos)) <<  10) & 262143L)
        | //                                 [76543210]
          //                    [_____________98765432__]
            ((((long)in.get(16 + inPos)) <<  2) & 1023L)
        | //                                 [76______]
          //            [_____________________10]
            ((((long)in.get(17 + inPos)) >>  6) & 3L);
      out[ 6 + outPos] =
          //                                 [__543210]
          //                                   [210987_________________]
            ((((long)in.get(17 + inPos)) <<  17) & 8388607L)
        | //                                 [76543210]
          //                           [______65432109_________]
            ((((long)in.get(18 + inPos)) <<  9) & 131071L)
        | //                                 [76543210]
          //                   [______________87654321_]
            ((((long)in.get(19 + inPos)) <<  1) & 511L)
        | //                                 [7_______]
          //           [______________________0]
            ((((long)in.get(20 + inPos)) >>  7) & 1L);
      out[ 7 + outPos] =
          //                                 [_6543210]
          //                                  [2109876________________]
            ((((long)in.get(20 + inPos)) <<  16) & 8388607L)
        | //                                 [76543210]
          //                          [_______54321098________]
            ((((long)in.get(21 + inPos)) <<  8) & 65535L)
        | //                                 [76543210]
          //                  [_______________76543210]
            ((((long)in.get(22 + inPos)) ) & 255L);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final long[] out, final int outPos) {
      out[ 0 + outPos] =
          //                                 [76543210]
          //                                 [21098765_______________]
            ((((long)in[ 0 + inPos]) <<  15) & 8388607L)
        | //                                 [76543210]
          //                         [________43210987_______]
            ((((long)in[ 1 + inPos]) <<  7) & 32767L)
        | //                                 [7654321_]
          //                 [________________6543210]
            ((((long)in[ 2 + inPos]) >>  1) & 127L);
      out[ 1 + outPos] =
          //                                 [_______0]
          //                                        [2______________________]
            ((((long)in[ 2 + inPos]) <<  22) & 8388607L)
        | //                                 [76543210]
          //                                [_10987654______________]
            ((((long)in[ 3 + inPos]) <<  14) & 4194303L)
        | //                                 [76543210]
          //                        [_________32109876______]
            ((((long)in[ 4 + inPos]) <<  6) & 16383L)
        | //                                 [765432__]
          //                [_________________543210]
            ((((long)in[ 5 + inPos]) >>  2) & 63L);
      out[ 2 + outPos] =
          //                                 [______10]
          //                                       [21_____________________]
            ((((long)in[ 5 + inPos]) <<  21) & 8388607L)
        | //                                 [76543210]
          //                               [__09876543_____________]
            ((((long)in[ 6 + inPos]) <<  13) & 2097151L)
        | //                                 [76543210]
          //                       [__________21098765_____]
            ((((long)in[ 7 + inPos]) <<  5) & 8191L)
        | //                                 [76543___]
          //               [__________________43210]
            ((((long)in[ 8 + inPos]) >>  3) & 31L);
      out[ 3 + outPos] =
          //                                 [_____210]
          //                                      [210____________________]
            ((((long)in[ 8 + inPos]) <<  20) & 8388607L)
        | //                                 [76543210]
          //                              [___98765432____________]
            ((((long)in[ 9 + inPos]) <<  12) & 1048575L)
        | //                                 [76543210]
          //        