/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.junit.Assert;
import org.junit.Test;

public class TestParquetOutputFormatJobSummaryLevel {
    @Test
    public void testDefault() throws Exception {
        Configuration conf = new Configuration();
        Assert.assertEquals((Object)ParquetOutputFormat.JobSummaryLevel.ALL, (Object)ParquetOutputFormat.getJobSummaryLevel((Configuration)conf));
    }

    @Test
    public void testDeprecatedStillWorks() throws Exception {
        Configuration conf = new Configuration();
        conf.set("parquet.enable.summary-metadata", "true");
        Assert.assertEquals((Object)ParquetOutputFormat.JobSummaryLevel.ALL, (Object)ParquetOutputFormat.getJobSummaryLevel((Configuration)conf));
        conf.set("parquet.enable.summary-metadata", "false");
        Assert.assertEquals((Object)ParquetOutputFormat.JobSummaryLevel.NONE, (Object)ParquetOutputFormat.getJobSummaryLevel((Configuration)conf));
    }

    @Test
    public void testLevelParses() throws Exception {
        Configuration conf = new Configuration();
        conf.set("parquet.summary.metadata.level", "all");
        Assert.assertEquals((Object)ParquetOutputFormat.JobSummaryLevel.ALL, (Object)ParquetOutputFormat.getJobSummaryLevel((Configuration)conf));
        conf.set("parquet.summary.metadata.level", "common_only");
        Assert.assertEquals((Object)ParquetOutputFormat.JobSummaryLevel.COMMON_ONLY, (Object)ParquetOutputFormat.getJobSummaryLevel((Configuration)conf));
        conf.set("parquet.summary.metadata.level", "none");
        Assert.assertEquals((Object)ParquetOutputFormat.JobSummaryLevel.NONE, (Object)ParquetOutputFormat.getJobSummaryLevel((Configuration)conf));
    }

    @Test
    public void testLevelTakesPrecedence() throws Exception {
        Configuration conf = new Configuration();
        conf.set("parquet.summary.metadata.level", "common_only");
        conf.set("parquet.enable.summary-metadata", "false");
        Assert.assertEquals((Object)ParquetOutputFormat.JobSummaryLevel.COMMON_ONLY, (Object)ParquetOutputFormat.getJobSummaryLevel((Configuration)conf));
    }
}

