/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.example;

import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.junit.Assert;
import org.junit.Test;

public class GroupReadSupportTest {
    private String fullSchemaStr = "message example {\nrequired int32 line;\noptional binary content;\n}";
    private String partialSchemaStr = "message example {\nrequired int32 line;\n}";

    @Test
    public void testInitWithoutSpecifyingRequestSchema() throws Exception {
        GroupReadSupport s = new GroupReadSupport();
        Configuration configuration = new Configuration();
        HashMap keyValueMetaData = new HashMap();
        MessageType fileSchema = MessageTypeParser.parseMessageType((String)this.fullSchemaStr);
        ReadSupport.ReadContext context = s.init(configuration, keyValueMetaData, fileSchema);
        Assert.assertEquals((Object)context.getRequestedSchema(), (Object)fileSchema);
    }

    @Test
    public void testInitWithPartialSchema() {
        GroupReadSupport s = new GroupReadSupport();
        Configuration configuration = new Configuration();
        HashMap keyValueMetaData = new HashMap();
        MessageType fileSchema = MessageTypeParser.parseMessageType((String)this.fullSchemaStr);
        MessageType partialSchema = MessageTypeParser.parseMessageType((String)this.partialSchemaStr);
        configuration.set("parquet.read.schema", this.partialSchemaStr);
        ReadSupport.ReadContext context = s.init(configuration, keyValueMetaData, fileSchema);
        Assert.assertEquals((Object)context.getRequestedSchema(), (Object)partialSchema);
    }
}

