/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.crypto.keytools.mocks;

import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.apache.parquet.crypto.KeyAccessDeniedException;
import org.apache.parquet.crypto.ParquetCryptoRuntimeException;
import org.apache.parquet.crypto.keytools.LocalWrapKmsClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalWrapInMemoryKMS
extends LocalWrapKmsClient {
    private static final Logger LOG = LoggerFactory.getLogger(LocalWrapInMemoryKMS.class);
    public static final String KEY_LIST_PROPERTY_NAME = "parquet.encryption.key.list";
    private static Map<String, byte[]> masterKeyMap;

    protected synchronized void initializeInternal() throws KeyAccessDeniedException {
        String[] masterKeys = this.hadoopConfiguration.getTrimmedStrings(KEY_LIST_PROPERTY_NAME);
        if (null == masterKeys || masterKeys.length == 0) {
            throw new ParquetCryptoRuntimeException("No encryption key list");
        }
        masterKeyMap = LocalWrapInMemoryKMS.parseKeyList(masterKeys);
    }

    private static Map<String, byte[]> parseKeyList(String[] masterKeys) {
        HashMap<String, byte[]> keyMap = new HashMap<String, byte[]>();
        int nKeys = masterKeys.length;
        for (int i = 0; i < nKeys; ++i) {
            String[] parts = masterKeys[i].split(":");
            String keyName = parts[0].trim();
            if (parts.length != 2) {
                throw new IllegalArgumentException("Key '" + keyName + "' is not formatted correctly");
            }
            String key = parts[1].trim();
            try {
                byte[] keyBytes = Base64.getDecoder().decode(key);
                keyMap.put(keyName, keyBytes);
                continue;
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Could not decode key '" + keyName + "'!");
                throw e;
            }
        }
        return keyMap;
    }

    protected synchronized byte[] getMasterKeyFromServer(String masterKeyIdentifier) throws KeyAccessDeniedException, UnsupportedOperationException {
        return masterKeyMap.get(masterKeyIdentifier);
    }
}

