/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.crypto.keytools.samples;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import okhttp3.ConnectionSpec;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.crypto.KeyAccessDeniedException;
import org.apache.parquet.crypto.ParquetCryptoRuntimeException;
import org.apache.parquet.crypto.keytools.KmsClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VaultClient
implements KmsClient {
    private static final Logger LOG = LoggerFactory.getLogger(VaultClient.class);
    private static final MediaType JSON_MEDIA_TYPE = MediaType.get((String)"application/json; charset=utf-8");
    private static final String DEFAULT_TRANSIT_ENGINE = "/v1/transit/";
    private static final String transitWrapEndpoint = "encrypt/";
    private static final String transitUnwrapEndpoint = "decrypt/";
    private static final String tokenHeader = "X-Vault-Token";
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private String kmsToken;
    private Configuration hadoopConfiguration;
    private String endPointPrefix;
    private OkHttpClient httpClient = new OkHttpClient.Builder().connectionSpecs(Arrays.asList(ConnectionSpec.MODERN_TLS, ConnectionSpec.COMPATIBLE_TLS)).build();

    public void initialize(Configuration configuration, String kmsInstanceID, String kmsInstanceURL, String accessToken) throws KeyAccessDeniedException {
        this.hadoopConfiguration = configuration;
        this.checkToken(accessToken);
        this.kmsToken = accessToken;
        if (kmsInstanceURL.equals("DEFAULT")) {
            throw new ParquetCryptoRuntimeException("Vault URL not provided");
        }
        if (!kmsInstanceURL.endsWith("/")) {
            kmsInstanceURL = kmsInstanceURL + "/";
        }
        String transitEngine = DEFAULT_TRANSIT_ENGINE;
        if (!kmsInstanceID.equals("DEFAULT") && !(transitEngine = "/v1/" + kmsInstanceID).endsWith("/")) {
            transitEngine = transitEngine + "/";
        }
        this.endPointPrefix = kmsInstanceURL + transitEngine;
    }

    public String wrapKey(byte[] keyBytes, String masterKeyIdentifier) throws KeyAccessDeniedException {
        this.refreshToken();
        HashMap<String, String> writeKeyMap = new HashMap<String, String>(1);
        String dataKeyStr = Base64.getEncoder().encodeToString(keyBytes);
        writeKeyMap.put("plaintext", dataKeyStr);
        String response = this.getContentFromTransitEngine(this.endPointPrefix + transitWrapEndpoint, this.buildPayload(writeKeyMap), masterKeyIdentifier);
        String ciphertext = VaultClient.parseReturn(response, "ciphertext");
        return ciphertext;
    }

    public byte[] unwrapKey(String wrappedKey, String masterKeyIdentifier) throws KeyAccessDeniedException {
        this.refreshToken();
        HashMap<String, String> writeKeyMap = new HashMap<String, String>(1);
        writeKeyMap.put("ciphertext", wrappedKey);
        String response = this.getContentFromTransitEngine(this.endPointPrefix + transitUnwrapEndpoint, this.buildPayload(writeKeyMap), masterKeyIdentifier);
        String plaintext = VaultClient.parseReturn(response, "plaintext");
        byte[] key = Base64.getDecoder().decode(plaintext);
        return key;
    }

    private String buildPayload(Map<String, String> paramMap) {
        String jsonValue;
        try {
            jsonValue = objectMapper.writeValueAsString(paramMap);
        }
        catch (IOException e) {
            throw new ParquetCryptoRuntimeException("Failed to build payload", (Throwable)e);
        }
        return jsonValue;
    }

    private void checkToken(String token) {
        if (null == token || token.isEmpty() || token.equals("DEFAULT")) {
            throw new ParquetCryptoRuntimeException("Wrong Vault token : " + token);
        }
    }

    private void refreshToken() {
        this.kmsToken = this.hadoopConfiguration.getTrimmed("parquet.encryption.key.access.token");
        this.checkToken(this.kmsToken);
    }

    private String getContentFromTransitEngine(String endPoint, String jPayload, String masterKeyIdentifier) {
        LOG.info("masterKeyIdentifier: " + masterKeyIdentifier);
        RequestBody requestBody = RequestBody.create((MediaType)JSON_MEDIA_TYPE, (String)jPayload);
        Request request = new Request.Builder().url(endPoint + masterKeyIdentifier).header(tokenHeader, this.kmsToken).post(requestBody).build();
        return this.executeAndGetResponse(endPoint, request);
    }

    private String executeAndGetResponse(String endPoint, Request request) {
        Response response = null;
        try {
            response = this.httpClient.newCall(request).execute();
            String responseBody = response.body().string();
            if (response.isSuccessful()) {
                String string = responseBody;
                return string;
            }
            try {
                if (401 == response.code() || 403 == response.code()) {
                    throw new KeyAccessDeniedException(responseBody);
                }
                throw new IOException("Vault call [" + endPoint + "] didn't succeed: " + responseBody);
            }
            catch (IOException e) {
                throw new ParquetCryptoRuntimeException("Vault call [" + request.url().toString() + endPoint + "] didn't succeed", (Throwable)e);
            }
        }
        finally {
            if (null != response) {
                response.close();
            }
        }
    }

    private static String parseReturn(String response, String searchKey) {
        String matchingValue;
        try {
            matchingValue = objectMapper.readTree(response).findValue(searchKey).textValue();
        }
        catch (IOException e) {
            throw new ParquetCryptoRuntimeException("Failed to parse vault response. " + searchKey + " not found." + response, (Throwable)e);
        }
        if (null == matchingValue) {
            throw new ParquetCryptoRuntimeException("Failed to match vault response. " + searchKey + " not found." + response);
        }
        return matchingValue;
    }
}

