/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.filter2.recordlevel;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.LongStream;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.predicate.Operators;
import org.apache.parquet.filter2.predicate.Statistics;
import org.apache.parquet.filter2.predicate.UserDefinedPredicate;
import org.apache.parquet.filter2.recordlevel.PhoneBookWriter;
import org.apache.parquet.io.api.Binary;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestRecordLevelFilters {
    private static File phonebookFile;
    private static List<PhoneBookWriter.User> users;

    public static List<PhoneBookWriter.User> makeUsers() {
        ArrayList<PhoneBookWriter.User> users = new ArrayList<PhoneBookWriter.User>();
        users.add(new PhoneBookWriter.User(17L, null, null, null, (Map<String, Double>)ImmutableMap.of((Object)"business", (Object)1000.0, (Object)"personal", (Object)500.0)));
        users.add(new PhoneBookWriter.User(18L, "bob", null, null));
        users.add(new PhoneBookWriter.User(19L, "alice", new ArrayList<PhoneBookWriter.PhoneNumber>(), null, (Map<String, Double>)ImmutableMap.of((Object)"business", (Object)2000.0, (Object)"retirement", (Object)1000.0)));
        users.add(new PhoneBookWriter.User(20L, "thing1", Arrays.asList(new PhoneBookWriter.PhoneNumber(5555555555L, null)), null));
        users.add(new PhoneBookWriter.User(27L, "thing2", Arrays.asList(new PhoneBookWriter.PhoneNumber(1111111111L, "home"), new PhoneBookWriter.PhoneNumber(2222222222L, "cell")), null));
        users.add(new PhoneBookWriter.User(28L, "popular", Arrays.asList(new PhoneBookWriter.PhoneNumber(1111111111L, "home"), new PhoneBookWriter.PhoneNumber(1111111111L, "apartment"), new PhoneBookWriter.PhoneNumber(2222222222L, null), new PhoneBookWriter.PhoneNumber(3333333333L, "mobile")), null));
        users.add(new PhoneBookWriter.User(30L, null, Arrays.asList(new PhoneBookWriter.PhoneNumber(1111111111L, "home")), null));
        users.add(new PhoneBookWriter.User(31L, null, Arrays.asList(new PhoneBookWriter.PhoneNumber(2222222222L, "business")), null));
        for (int i = 100; i < 200; ++i) {
            PhoneBookWriter.Location location = null;
            if (i % 3 == 1) {
                location = new PhoneBookWriter.Location(Double.valueOf(i), (double)i * 2.0);
            }
            if (i % 3 == 2) {
                location = new PhoneBookWriter.Location(Double.valueOf(i), null);
            }
            users.add(new PhoneBookWriter.User(i, "p" + i, Arrays.asList(new PhoneBookWriter.PhoneNumber(i, "cell")), location));
        }
        return users;
    }

    @BeforeClass
    public static void setup() throws IOException {
        users = TestRecordLevelFilters.makeUsers();
        phonebookFile = PhoneBookWriter.writeToFile(users);
    }

    private static List<Group> getExpected(UserFilter f) {
        ArrayList<Group> expected = new ArrayList<Group>();
        for (PhoneBookWriter.User u : users) {
            if (!f.keep(u)) continue;
            expected.add((Group)PhoneBookWriter.groupFromUser(u));
        }
        return expected;
    }

    private static void assertFilter(List<Group> found, UserFilter f) {
        List<Group> expected = TestRecordLevelFilters.getExpected(f);
        Assert.assertEquals((long)expected.size(), (long)found.size());
        Iterator<Group> expectedIter = expected.iterator();
        Iterator<Group> foundIter = found.iterator();
        while (expectedIter.hasNext()) {
            Assert.assertEquals((Object)expectedIter.next().toString(), (Object)foundIter.next().toString());
        }
    }

    private static void assertPredicate(FilterPredicate predicate, long ... expectedIds) throws IOException {
        List<Group> found = PhoneBookWriter.readFile(phonebookFile, FilterCompat.get((FilterPredicate)predicate));
        Assert.assertEquals((long)expectedIds.length, (long)found.size());
        for (int i = 0; i < expectedIds.length; ++i) {
            Assert.assertEquals((long)expectedIds[i], (long)found.get(i).getLong("id", 0));
        }
    }

    @Test
    public void testNoFilter() throws Exception {
        List<Group> found = PhoneBookWriter.readFile(phonebookFile, FilterCompat.NOOP);
        TestRecordLevelFilters.assertFilter(found, new UserFilter(){

            @Override
            public boolean keep(PhoneBookWriter.User u) {
                return true;
            }
        });
    }

    @Test
    public void testAllFilter() throws Exception {
        Operators.BinaryColumn name = FilterApi.binaryColumn((String)"name");
        Operators.Eq pred = FilterApi.eq((Operators.Column)name, (Comparable)Binary.fromString((String)"no matches"));
        List<Group> found = PhoneBookWriter.readFile(phonebookFile, FilterCompat.get((FilterPredicate)pred));
        Assert.assertEquals(new ArrayList(), found);
    }

    @Test
    public void testInFilter() throws Exception {
        int i;
        Operators.BinaryColumn name = FilterApi.binaryColumn((String)"name");
        HashSet<Binary> nameSet = new HashSet<Binary>();
        nameSet.add(Binary.fromString((String)"thing2"));
        nameSet.add(Binary.fromString((String)"thing1"));
        for (int i2 = 100; i2 < 200; ++i2) {
            nameSet.add(Binary.fromString((String)("p" + i2)));
        }
        Operators.In pred = FilterApi.in((Operators.Column)name, nameSet);
        List<Group> found = PhoneBookWriter.readFile(phonebookFile, FilterCompat.get((FilterPredicate)pred));
        ArrayList<String> expectedNames = new ArrayList<String>();
        expectedNames.add("thing1");
        expectedNames.add("thing2");
        for (i = 100; i < 200; ++i) {
            expectedNames.add("p" + i);
        }
        expectedNames.add("dummy1");
        expectedNames.add("dummy2");
        expectedNames.add("dummy3");
        Assert.assertEquals(expectedNames.get(0), (Object)found.get(0).getString("name", 0));
        Assert.assertEquals(expectedNames.get(1), (Object)found.get(1).getString("name", 0));
        for (i = 2; i < 102; ++i) {
            Assert.assertEquals(expectedNames.get(i), (Object)found.get(i).getString("name", 0));
        }
        assert (found.size() == 102);
    }

    @Test
    public void testArrayContains() throws Exception {
        TestRecordLevelFilters.assertPredicate((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"phoneNumbers.phone.kind"), (Comparable)Binary.fromString((String)"home"))), 27L, 28L, 30L);
        TestRecordLevelFilters.assertPredicate((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.notEq((Operators.Column)FilterApi.binaryColumn((String)"phoneNumbers.phone.kind"), (Comparable)Binary.fromString((String)"cell"))), 27L, 28L, 30L, 31L);
        TestRecordLevelFilters.assertPredicate((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.gt((Operators.Column)FilterApi.longColumn((String)"phoneNumbers.phone.number"), (Comparable)Long.valueOf(1111111111L))), 20L, 27L, 28L, 31L);
        TestRecordLevelFilters.assertPredicate((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.gtEq((Operators.Column)FilterApi.longColumn((String)"phoneNumbers.phone.number"), (Comparable)Long.valueOf(1111111111L))), 20L, 27L, 28L, 30L, 31L);
        TestRecordLevelFilters.assertPredicate((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.lt((Operators.Column)FilterApi.longColumn((String)"phoneNumbers.phone.number"), (Comparable)Long.valueOf(105L))), 100L, 101L, 102L, 103L, 104L);
        TestRecordLevelFilters.assertPredicate((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.ltEq((Operators.Column)FilterApi.longColumn((String)"phoneNumbers.phone.number"), (Comparable)Long.valueOf(105L))), 100L, 101L, 102L, 103L, 104L, 105L);
        TestRecordLevelFilters.assertPredicate((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.in((Operators.Column)FilterApi.binaryColumn((String)"phoneNumbers.phone.kind"), (Set)ImmutableSet.of((Object)Binary.fromString((String)"apartment"), (Object)Binary.fromString((String)"home")))), 27L, 28L, 30L);
        TestRecordLevelFilters.assertPredicate((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.notIn((Operators.Column)FilterApi.binaryColumn((String)"phoneNumbers.phone.kind"), (Set)ImmutableSet.of((Object)Binary.fromString((String)"cell")))), 27L, 28L, 30L, 31L);
    }

    @Test
    public void testArrayDoesNotContains() throws Exception {
        TestRecordLevelFilters.assertPredicate(FilterApi.not((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"phoneNumbers.phone.kind"), (Comparable)Binary.fromString((String)"cell")))), 17L, 18L, 19L, 20L, 28L, 30L, 31L);
        TestRecordLevelFilters.assertPredicate(FilterApi.and((FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"phoneNumbers.phone.kind"), (Comparable)Binary.fromString((String)"cell")))), (FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"phoneNumbers.phone.kind"), (Comparable)Binary.fromString((String)"home"))))), 17L, 18L, 19L, 20L, 31L);
        TestRecordLevelFilters.assertPredicate(FilterApi.and((FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"phoneNumbers.phone.kind"), (Comparable)Binary.fromString((String)"cell")))), (FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"phoneNumbers.phone.kind"), (Comparable)Binary.fromString((String)"home")))), (FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"phoneNumbers.phone.kind"), (Comparable)Binary.fromString((String)"business")))))), 17L, 18L, 19L, 20L);
        TestRecordLevelFilters.assertPredicate(FilterApi.or((FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"phoneNumbers.phone.kind"), (Comparable)Binary.fromString((String)"cell")))), (FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"phoneNumbers.phone.kind"), (Comparable)Binary.fromString((String)"home"))))), LongStream.concat(LongStream.of(17L, 18L, 19L, 20L, 28L, 30L, 31L), LongStream.range(100L, 200L)).toArray());
        TestRecordLevelFilters.assertPredicate(FilterApi.or((FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"phoneNumbers.phone.kind"), (Comparable)Binary.fromString((String)"cell")))), (FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"phoneNumbers.phone.kind"), (Comparable)Binary.fromString((String)"home")))), (FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"phoneNumbers.phone.kind"), (Comparable)Binary.fromString((String)"mobile")))))), LongStream.concat(LongStream.of(17L, 18L, 19L, 20L, 28L, 30L, 31L), LongStream.range(100L, 200L)).toArray());
        TestRecordLevelFilters.assertPredicate(FilterApi.and((FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"phoneNumbers.phone.kind"), (Comparable)Binary.fromString((String)"cell")))), (FilterPredicate)FilterApi.or((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"phoneNumbers.phone.kind"), (Comparable)Binary.fromString((String)"home"))), (FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"phoneNumbers.phone.kind"), (Comparable)Binary.fromString((String)"business"))))), 28L, 30L, 31L);
        TestRecordLevelFilters.assertPredicate(FilterApi.or((FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"phoneNumbers.phone.kind"), (Comparable)Binary.fromString((String)"cell")))), (FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"phoneNumbers.phone.kind"), (Comparable)Binary.fromString((String)"home"))), (FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"phoneNumbers.phone.kind"), (Comparable)Binary.fromString((String)"apartment"))))), 17L, 18L, 19L, 20L, 28L, 30L, 31L);
    }

    @Test
    public void testArrayContainsSimpleAndFilter() throws Exception {
        TestRecordLevelFilters.assertPredicate(FilterApi.and((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.longColumn((String)"phoneNumbers.phone.number"), (Comparable)Long.valueOf(1111111111L))), (FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.longColumn((String)"phoneNumbers.phone.number"), (Comparable)Long.valueOf(3333333333L)))), 28L);
        TestRecordLevelFilters.assertPredicate(FilterApi.and((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.longColumn((String)"phoneNumbers.phone.number"), (Comparable)Long.valueOf(1111111111L))), (FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.longColumn((String)"phoneNumbers.phone.number"), (Comparable)Long.valueOf(-123L)))), new long[0]);
    }

    @Test
    public void testArrayContainsNestedAndFilter() throws Exception {
        TestRecordLevelFilters.assertPredicate(FilterApi.and((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.longColumn((String)"phoneNumbers.phone.number"), (Comparable)Long.valueOf(1111111111L))), (FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.longColumn((String)"phoneNumbers.phone.number"), (Comparable)Long.valueOf(2222222222L))), (FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.longColumn((String)"phoneNumbers.phone.number"), (Comparable)Long.valueOf(3333333333L))))), 28L);
    }

    @Test
    public void testArrayContainsSimpleOrFilter() throws Exception {
        TestRecordLevelFilters.assertPredicate(FilterApi.or((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.longColumn((String)"phoneNumbers.phone.number"), (Comparable)Long.valueOf(5555555555L))), (FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.longColumn((String)"phoneNumbers.phone.number"), (Comparable)Long.valueOf(2222222222L)))), 20L, 27L, 28L, 31L);
        TestRecordLevelFilters.assertPredicate(FilterApi.or((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.longColumn((String)"phoneNumbers.phone.number"), (Comparable)Long.valueOf(5555555555L))), (FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.longColumn((String)"phoneNumbers.phone.number"), (Comparable)Long.valueOf(-123L)))), 20L);
    }

    @Test
    public void testArrayContainsNestedOrFilter() throws Exception {
        TestRecordLevelFilters.assertPredicate(FilterApi.or((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.longColumn((String)"phoneNumbers.phone.number"), (Comparable)Long.valueOf(5555555555L))), (FilterPredicate)FilterApi.or((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.longColumn((String)"phoneNumbers.phone.number"), (Comparable)Long.valueOf(-10000000L))), (FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.longColumn((String)"phoneNumbers.phone.number"), (Comparable)Long.valueOf(2222222222L))))), 20L, 27L, 28L, 31L);
    }

    @Test
    public void testMapContains() throws Exception {
        TestRecordLevelFilters.assertPredicate((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"accounts.key_value.key"), (Comparable)Binary.fromString((String)"business"))), 17L, 19L);
        TestRecordLevelFilters.assertPredicate((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.doubleColumn((String)"accounts.key_value.value"), (Comparable)Double.valueOf(1000.0))), 17L, 19L);
    }

    @Test
    public void testArrayContainsMixedColumns() throws Exception {
        TestRecordLevelFilters.assertPredicate(FilterApi.and((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"phoneNumbers.phone.kind"), (Comparable)Binary.fromString((String)"home"))), (FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.longColumn((String)"phoneNumbers.phone.number"), (Comparable)Long.valueOf(2222222222L))))), 30L);
    }

    @Test
    public void testNameNotNull() throws Exception {
        Operators.BinaryColumn name = FilterApi.binaryColumn((String)"name");
        Operators.NotEq pred = FilterApi.notEq((Operators.Column)name, null);
        List<Group> found = PhoneBookWriter.readFile(phonebookFile, FilterCompat.get((FilterPredicate)pred));
        TestRecordLevelFilters.assertFilter(found, new UserFilter(){

            @Override
            public boolean keep(PhoneBookWriter.User u) {
                return u.getName() != null;
            }
        });
    }

    @Test
    public void testNameNotStartWithP() throws Exception {
        Operators.BinaryColumn name = FilterApi.binaryColumn((String)"name");
        FilterPredicate pred = FilterApi.not((FilterPredicate)FilterApi.userDefined((Operators.Column)name, StartWithP.class));
        List<Group> found = PhoneBookWriter.readFile(phonebookFile, FilterCompat.get((FilterPredicate)pred));
        TestRecordLevelFilters.assertFilter(found, new UserFilter(){

            @Override
            public boolean keep(PhoneBookWriter.User u) {
                return u.getName() == null || !u.getName().startsWith("p");
            }
        });
    }

    @Test
    public void testUserDefinedByInstance() throws Exception {
        Operators.LongColumn name = FilterApi.longColumn((String)"id");
        final HashSet<Long> h = new HashSet<Long>();
        h.add(20L);
        h.add(27L);
        h.add(28L);
        Operators.UserDefined pred = FilterApi.userDefined((Operators.Column)name, (UserDefinedPredicate)new SetInFilter(h));
        List<Group> found = PhoneBookWriter.readFile(phonebookFile, FilterCompat.get((FilterPredicate)pred));
        TestRecordLevelFilters.assertFilter(found, new UserFilter(){

            @Override
            public boolean keep(PhoneBookWriter.User u) {
                return u != null && h.contains(u.getId());
            }
        });
    }

    @Test
    public void testComplex() throws Exception {
        Operators.BinaryColumn name = FilterApi.binaryColumn((String)"name");
        Operators.DoubleColumn lon = FilterApi.doubleColumn((String)"location.lon");
        Operators.DoubleColumn lat = FilterApi.doubleColumn((String)"location.lat");
        FilterPredicate pred = FilterApi.or((FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.gt((Operators.Column)lon, (Comparable)Double.valueOf(150.0)), (FilterPredicate)FilterApi.notEq((Operators.Column)lat, null)), (FilterPredicate)FilterApi.eq((Operators.Column)name, (Comparable)Binary.fromString((String)"alice")));
        List<Group> found = PhoneBookWriter.readFile(phonebookFile, FilterCompat.get((FilterPredicate)pred));
        TestRecordLevelFilters.assertFilter(found, new UserFilter(){

            @Override
            public boolean keep(PhoneBookWriter.User u) {
                String name = u.getName();
                Double lat = null;
                Double lon = null;
                if (u.getLocation() != null) {
                    lat = u.getLocation().getLat();
                    lon = u.getLocation().getLon();
                }
                return lon != null && lon > 150.0 && lat != null || "alice".equals(name);
            }
        });
    }

    public static class SetInFilter
    extends UserDefinedPredicate<Long>
    implements Serializable {
        private HashSet<Long> hSet;

        public SetInFilter(HashSet<Long> phSet) {
            this.hSet = phSet;
        }

        public boolean keep(Long value) {
            if (value == null) {
                return false;
            }
            return this.hSet.contains(value);
        }

        public boolean canDrop(Statistics<Long> statistics) {
            return false;
        }

        public boolean inverseCanDrop(Statistics<Long> statistics) {
            return false;
        }
    }

    public static class StartWithP
    extends UserDefinedPredicate<Binary> {
        public boolean keep(Binary value) {
            if (value == null) {
                return false;
            }
            return value.toStringUsingUTF8().startsWith("p");
        }

        public boolean canDrop(Statistics<Binary> statistics) {
            return false;
        }

        public boolean inverseCanDrop(Statistics<Binary> statistics) {
            return false;
        }
    }

    private static interface UserFilter {
        public boolean keep(PhoneBookWriter.User var1);
    }
}

