/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.filter2.statisticslevel;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.statistics.DoubleStatistics;
import org.apache.parquet.column.statistics.IntStatistics;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.predicate.LogicalInverseRewriter;
import org.apache.parquet.filter2.predicate.Operators;
import org.apache.parquet.filter2.predicate.UserDefinedPredicate;
import org.apache.parquet.filter2.statisticslevel.StatisticsFilter;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;
import org.junit.Assert;
import org.junit.Test;

public class TestStatisticsFilter {
    private static final Operators.IntColumn intColumn = FilterApi.intColumn((String)"int.column");
    private static final Operators.DoubleColumn doubleColumn = FilterApi.doubleColumn((String)"double.column");
    private static final Operators.BinaryColumn missingColumn = FilterApi.binaryColumn((String)"missing");
    private static final Operators.IntColumn missingColumn2 = FilterApi.intColumn((String)"missing.int");
    private static final IntStatistics intStats = new IntStatistics();
    private static final IntStatistics nullIntStats = new IntStatistics();
    private static final Statistics<?> emptyIntStats = Statistics.getBuilderForReading((PrimitiveType)((PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named("test_int32"))).build();
    private static final DoubleStatistics doubleStats = new DoubleStatistics();
    private static final Statistics<?> missingMinMaxDoubleStats = Statistics.getBuilderForReading((PrimitiveType)((PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE).named("test_double"))).withNumNulls(100L).build();
    private static final List<ColumnChunkMetaData> columnMetas;
    private static final List<ColumnChunkMetaData> nullColumnMetas;
    private static final List<ColumnChunkMetaData> missingMinMaxColumnMetas;

    private static ColumnChunkMetaData getIntColumnMeta(Statistics<?> stats, long valueCount) {
        return ColumnChunkMetaData.get((ColumnPath)ColumnPath.get((String[])new String[]{"int", "column"}), (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (CompressionCodecName)CompressionCodecName.GZIP, new HashSet<Encoding>(Arrays.asList(Encoding.PLAIN)), stats, (long)0L, (long)0L, (long)valueCount, (long)0L, (long)0L);
    }

    private static ColumnChunkMetaData getDoubleColumnMeta(Statistics<?> stats, long valueCount) {
        return ColumnChunkMetaData.get((ColumnPath)ColumnPath.get((String[])new String[]{"double", "column"}), (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (CompressionCodecName)CompressionCodecName.GZIP, new HashSet<Encoding>(Arrays.asList(Encoding.PLAIN)), stats, (long)0L, (long)0L, (long)valueCount, (long)0L, (long)0L);
    }

    @Test
    public void testEqNonNull() {
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(9)), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(10)), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(100)), columnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(101)), columnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(0)), nullColumnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.eq((Operators.Column)missingColumn, (Comparable)Binary.fromString((String)"any")), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(50)), missingMinMaxColumnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.eq((Operators.Column)doubleColumn, (Comparable)Double.valueOf(50.0)), missingMinMaxColumnMetas));
    }

    @Test
    public void testEqNull() {
        IntStatistics statsNoNulls = new IntStatistics();
        statsNoNulls.setMinMax(10, 100);
        statsNoNulls.setNumNulls(0L);
        IntStatistics statsSomeNulls = new IntStatistics();
        statsSomeNulls.setMinMax(10, 100);
        statsSomeNulls.setNumNulls(3L);
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.eq((Operators.Column)intColumn, null), Arrays.asList(TestStatisticsFilter.getIntColumnMeta(statsNoNulls, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.eq((Operators.Column)intColumn, null), Arrays.asList(TestStatisticsFilter.getIntColumnMeta(statsSomeNulls, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.eq((Operators.Column)missingColumn, null), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.eq((Operators.Column)intColumn, null), missingMinMaxColumnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.eq((Operators.Column)doubleColumn, null), missingMinMaxColumnMetas));
    }

    @Test
    public void testNotEqNonNull() {
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.notEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(9)), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.notEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(10)), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.notEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(100)), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.notEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(101)), columnMetas));
        IntStatistics allSevens = new IntStatistics();
        allSevens.setMinMax(7, 7);
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.notEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(7)), Arrays.asList(TestStatisticsFilter.getIntColumnMeta(allSevens, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
        allSevens.setNumNulls(100L);
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.notEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(7)), Arrays.asList(TestStatisticsFilter.getIntColumnMeta(allSevens, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
        allSevens.setNumNulls(177L);
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.notEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(7)), Arrays.asList(TestStatisticsFilter.getIntColumnMeta(allSevens, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.notEq((Operators.Column)missingColumn, (Comparable)Binary.fromString((String)"any")), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.notEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(50)), missingMinMaxColumnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.notEq((Operators.Column)doubleColumn, (Comparable)Double.valueOf(50.0)), missingMinMaxColumnMetas));
    }

    @Test
    public void testNotEqNull() {
        IntStatistics statsNoNulls = new IntStatistics();
        statsNoNulls.setMinMax(10, 100);
        statsNoNulls.setNumNulls(0L);
        IntStatistics statsSomeNulls = new IntStatistics();
        statsSomeNulls.setMinMax(10, 100);
        statsSomeNulls.setNumNulls(3L);
        IntStatistics statsAllNulls = new IntStatistics();
        statsAllNulls.setMinMax(0, 0);
        statsAllNulls.setNumNulls(177L);
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.notEq((Operators.Column)intColumn, null), Arrays.asList(TestStatisticsFilter.getIntColumnMeta(statsNoNulls, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.notEq((Operators.Column)intColumn, null), Arrays.asList(TestStatisticsFilter.getIntColumnMeta(statsSomeNulls, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.notEq((Operators.Column)intColumn, null), Arrays.asList(TestStatisticsFilter.getIntColumnMeta(statsAllNulls, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.notEq((Operators.Column)missingColumn, null), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.notEq((Operators.Column)intColumn, null), missingMinMaxColumnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.notEq((Operators.Column)doubleColumn, null), missingMinMaxColumnMetas));
    }

    @Test
    public void testLt() {
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.lt((Operators.Column)intColumn, (Comparable)Integer.valueOf(9)), columnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.lt((Operators.Column)intColumn, (Comparable)Integer.valueOf(10)), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.lt((Operators.Column)intColumn, (Comparable)Integer.valueOf(100)), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.lt((Operators.Column)intColumn, (Comparable)Integer.valueOf(101)), columnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.lt((Operators.Column)intColumn, (Comparable)Integer.valueOf(0)), nullColumnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.lt((Operators.Column)intColumn, (Comparable)Integer.valueOf(7)), nullColumnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.lt((Operators.Column)missingColumn, (Comparable)Binary.fromString((String)"any")), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.lt((Operators.Column)intColumn, (Comparable)Integer.valueOf(0)), missingMinMaxColumnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.lt((Operators.Column)doubleColumn, (Comparable)Double.valueOf(0.0)), missingMinMaxColumnMetas));
    }

    @Test
    public void testLtEq() {
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.ltEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(9)), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.ltEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(10)), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.ltEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(100)), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.ltEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(101)), columnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.ltEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(0)), nullColumnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.ltEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(7)), nullColumnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.ltEq((Operators.Column)missingColumn, (Comparable)Binary.fromString((String)"any")), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.ltEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(-1)), missingMinMaxColumnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.ltEq((Operators.Column)doubleColumn, (Comparable)Double.valueOf(-0.1)), missingMinMaxColumnMetas));
    }

    @Test
    public void testGt() {
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.gt((Operators.Column)intColumn, (Comparable)Integer.valueOf(9)), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.gt((Operators.Column)intColumn, (Comparable)Integer.valueOf(10)), columnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.gt((Operators.Column)intColumn, (Comparable)Integer.valueOf(100)), columnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.gt((Operators.Column)intColumn, (Comparable)Integer.valueOf(101)), columnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.gt((Operators.Column)intColumn, (Comparable)Integer.valueOf(0)), nullColumnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.gt((Operators.Column)intColumn, (Comparable)Integer.valueOf(7)), nullColumnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.gt((Operators.Column)missingColumn, (Comparable)Binary.fromString((String)"any")), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.gt((Operators.Column)intColumn, (Comparable)Integer.valueOf(0)), missingMinMaxColumnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.gt((Operators.Column)doubleColumn, (Comparable)Double.valueOf(0.0)), missingMinMaxColumnMetas));
    }

    @Test
    public void testGtEq() {
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.gtEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(9)), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.gtEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(10)), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.gtEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(100)), columnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.gtEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(101)), columnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.gtEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(0)), nullColumnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.gtEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(7)), nullColumnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.gtEq((Operators.Column)missingColumn, (Comparable)Binary.fromString((String)"any")), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.gtEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(1)), missingMinMaxColumnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.gtEq((Operators.Column)doubleColumn, (Comparable)Double.valueOf(0.1)), missingMinMaxColumnMetas));
    }

    @Test
    public void testInNotIn() {
        HashSet<Integer> values1 = new HashSet<Integer>();
        values1.add(10);
        values1.add(12);
        values1.add(15);
        values1.add(17);
        values1.add(19);
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.in((Operators.Column)intColumn, values1), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.notIn((Operators.Column)intColumn, values1), columnMetas));
        HashSet<Integer> values2 = new HashSet<Integer>();
        values2.add(109);
        values2.add(2);
        values2.add(5);
        values2.add(117);
        values2.add(101);
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.in((Operators.Column)intColumn, values2), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.notIn((Operators.Column)intColumn, values2), columnMetas));
        HashSet<Integer> values3 = new HashSet<Integer>();
        values3.add(1);
        values3.add(2);
        values3.add(5);
        values3.add(7);
        values3.add(10);
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.in((Operators.Column)intColumn, values3), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.notIn((Operators.Column)intColumn, values3), columnMetas));
        HashSet<Integer> values4 = new HashSet<Integer>();
        values4.add(50);
        values4.add(60);
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.in((Operators.Column)intColumn, values4), missingMinMaxColumnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.notIn((Operators.Column)intColumn, values4), missingMinMaxColumnMetas));
        HashSet<Double> values5 = new HashSet<Double>();
        values5.add(1.0);
        values5.add(2.0);
        values5.add(95.0);
        values5.add(107.0);
        values5.add(99.0);
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.in((Operators.Column)doubleColumn, values5), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.notIn((Operators.Column)doubleColumn, values5), columnMetas));
        HashSet<Binary> values6 = new HashSet<Binary>();
        values6.add(Binary.fromString((String)"test1"));
        values6.add(Binary.fromString((String)"test2"));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.in((Operators.Column)missingColumn, values6), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.notIn((Operators.Column)missingColumn, values6), columnMetas));
        HashSet<Object> values7 = new HashSet<Object>();
        values7.add(null);
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.in((Operators.Column)intColumn, values7), nullColumnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.notIn((Operators.Column)intColumn, values7), nullColumnMetas));
        HashSet<Object> values8 = new HashSet<Object>();
        values8.add(null);
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.in((Operators.Column)missingColumn, values8), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.notIn((Operators.Column)missingColumn, values8), columnMetas));
        IntStatistics statsNoNulls = new IntStatistics();
        statsNoNulls.setMinMax(10, 100);
        statsNoNulls.setNumNulls(0L);
        IntStatistics statsSomeNulls = new IntStatistics();
        statsSomeNulls.setMinMax(10, 100);
        statsSomeNulls.setNumNulls(3L);
        HashSet<Object> values9 = new HashSet<Object>();
        values9.add(null);
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.in((Operators.Column)intColumn, values9), Arrays.asList(TestStatisticsFilter.getIntColumnMeta(statsNoNulls, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.notIn((Operators.Column)intColumn, values9), Arrays.asList(TestStatisticsFilter.getIntColumnMeta(statsNoNulls, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.in((Operators.Column)intColumn, values9), Arrays.asList(TestStatisticsFilter.getIntColumnMeta(statsSomeNulls, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.notIn((Operators.Column)intColumn, values9), Arrays.asList(TestStatisticsFilter.getIntColumnMeta(statsSomeNulls, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
    }

    @Test
    public void testContainsEqNonNull() {
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(9))), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(10))), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(100))), columnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(101))), columnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(0))), nullColumnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(50))), missingMinMaxColumnMetas));
    }

    @Test
    public void testContainsAnd() {
        Operators.Contains yes = FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(9)));
        Operators.Contains no = FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)doubleColumn, (Comparable)Double.valueOf(50.0)));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.and((FilterPredicate)yes, (FilterPredicate)yes), columnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.and((FilterPredicate)yes, (FilterPredicate)no), columnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.and((FilterPredicate)no, (FilterPredicate)yes), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.and((FilterPredicate)no, (FilterPredicate)no), columnMetas));
    }

    @Test
    public void testContainsOr() {
        Operators.Contains yes = FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(9)));
        Operators.Contains no = FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)doubleColumn, (Comparable)Double.valueOf(50.0)));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.or((FilterPredicate)yes, (FilterPredicate)yes), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.or((FilterPredicate)yes, (FilterPredicate)no), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.or((FilterPredicate)no, (FilterPredicate)yes), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.or((FilterPredicate)no, (FilterPredicate)no), columnMetas));
    }

    @Test
    public void testAnd() {
        Operators.Eq yes = FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(9));
        Operators.Eq no = FilterApi.eq((Operators.Column)doubleColumn, (Comparable)Double.valueOf(50.0));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.and((FilterPredicate)yes, (FilterPredicate)yes), columnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.and((FilterPredicate)yes, (FilterPredicate)no), columnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.and((FilterPredicate)no, (FilterPredicate)yes), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.and((FilterPredicate)no, (FilterPredicate)no), columnMetas));
    }

    @Test
    public void testOr() {
        Operators.Eq yes = FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(9));
        Operators.Eq no = FilterApi.eq((Operators.Column)doubleColumn, (Comparable)Double.valueOf(50.0));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.or((FilterPredicate)yes, (FilterPredicate)yes), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.or((FilterPredicate)yes, (FilterPredicate)no), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.or((FilterPredicate)no, (FilterPredicate)yes), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.or((FilterPredicate)no, (FilterPredicate)no), columnMetas));
    }

    @Test
    public void testUdp() {
        Operators.UserDefined pred = FilterApi.userDefined((Operators.Column)intColumn, SevensAndEightsUdp.class);
        FilterPredicate invPred = LogicalInverseRewriter.rewrite((FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.userDefined((Operators.Column)intColumn, SevensAndEightsUdp.class)));
        Operators.UserDefined udpDropMissingColumn = FilterApi.userDefined((Operators.Column)missingColumn2, DropNullUdp.class);
        FilterPredicate invUdpDropMissingColumn = LogicalInverseRewriter.rewrite((FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.userDefined((Operators.Column)missingColumn2, DropNullUdp.class)));
        Operators.UserDefined udpKeepMissingColumn = FilterApi.userDefined((Operators.Column)missingColumn2, SevensAndEightsUdp.class);
        FilterPredicate invUdpKeepMissingColumn = LogicalInverseRewriter.rewrite((FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.userDefined((Operators.Column)missingColumn2, SevensAndEightsUdp.class)));
        Operators.UserDefined allPositivePred = FilterApi.userDefined((Operators.Column)doubleColumn, AllPositiveUdp.class);
        IntStatistics seven = new IntStatistics();
        seven.setMinMax(7, 7);
        IntStatistics eight = new IntStatistics();
        eight.setMinMax(8, 8);
        IntStatistics neither = new IntStatistics();
        neither.setMinMax(1, 2);
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)pred, Arrays.asList(TestStatisticsFilter.getIntColumnMeta(seven, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)pred, Arrays.asList(TestStatisticsFilter.getIntColumnMeta(eight, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)pred, Arrays.asList(TestStatisticsFilter.getIntColumnMeta(neither, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)invPred, Arrays.asList(TestStatisticsFilter.getIntColumnMeta(seven, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)invPred, Arrays.asList(TestStatisticsFilter.getIntColumnMeta(eight, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)invPred, Arrays.asList(TestStatisticsFilter.getIntColumnMeta(neither, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)udpDropMissingColumn, Arrays.asList(TestStatisticsFilter.getIntColumnMeta(seven, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)udpDropMissingColumn, Arrays.asList(TestStatisticsFilter.getIntColumnMeta(eight, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)udpDropMissingColumn, Arrays.asList(TestStatisticsFilter.getIntColumnMeta(neither, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)invUdpDropMissingColumn, Arrays.asList(TestStatisticsFilter.getIntColumnMeta(seven, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)invUdpDropMissingColumn, Arrays.asList(TestStatisticsFilter.getIntColumnMeta(eight, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)invUdpDropMissingColumn, Arrays.asList(TestStatisticsFilter.getIntColumnMeta(neither, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)udpKeepMissingColumn, Arrays.asList(TestStatisticsFilter.getIntColumnMeta(seven, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)udpKeepMissingColumn, Arrays.asList(TestStatisticsFilter.getIntColumnMeta(eight, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)udpKeepMissingColumn, Arrays.asList(TestStatisticsFilter.getIntColumnMeta(neither, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)invUdpKeepMissingColumn, Arrays.asList(TestStatisticsFilter.getIntColumnMeta(seven, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)invUdpKeepMissingColumn, Arrays.asList(TestStatisticsFilter.getIntColumnMeta(eight, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)invUdpKeepMissingColumn, Arrays.asList(TestStatisticsFilter.getIntColumnMeta(neither, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)allPositivePred, missingMinMaxColumnMetas));
    }

    @Test
    public void testClearExceptionForNots() {
        List<ColumnChunkMetaData> columnMetas = Arrays.asList(TestStatisticsFilter.getDoubleColumnMeta(new DoubleStatistics(), 0L), TestStatisticsFilter.getIntColumnMeta(new IntStatistics(), 0L));
        FilterPredicate pred = FilterApi.and((FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.eq((Operators.Column)doubleColumn, (Comparable)Double.valueOf(12.0))), (FilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)));
        try {
            StatisticsFilter.canDrop((FilterPredicate)pred, columnMetas);
            Assert.fail((String)"This should throw");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"This predicate contains a not! Did you forget to run this predicate through LogicalInverseRewriter? not(eq(double.column, 12.0))", (Object)e.getMessage());
        }
    }

    static {
        intStats.setMinMax(10, 100);
        doubleStats.setMinMax(10.0, 100.0);
        nullIntStats.setNumNulls(177L);
        columnMetas = Arrays.asList(TestStatisticsFilter.getIntColumnMeta(intStats, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L));
        nullColumnMetas = Arrays.asList(TestStatisticsFilter.getIntColumnMeta(nullIntStats, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L));
        missingMinMaxColumnMetas = Arrays.asList(TestStatisticsFilter.getIntColumnMeta(emptyIntStats, 177L), TestStatisticsFilter.getDoubleColumnMeta(missingMinMaxDoubleStats, 177L));
    }

    public static class AllPositiveUdp
    extends UserDefinedPredicate<Double> {
        public boolean keep(Double value) {
            if (value == null) {
                return true;
            }
            throw new RuntimeException("this method should not be called with value != null");
        }

        public boolean canDrop(org.apache.parquet.filter2.predicate.Statistics<Double> statistics) {
            return (Double)statistics.getMin() <= 0.0;
        }

        public boolean inverseCanDrop(org.apache.parquet.filter2.predicate.Statistics<Double> statistics) {
            return (Double)statistics.getMin() > 0.0;
        }
    }

    public static class DropNullUdp
    extends SevensAndEightsUdp {
        @Override
        public boolean keep(Integer value) {
            if (value == null) {
                return false;
            }
            throw new RuntimeException("this method should not be called with value != null");
        }
    }

    public static class SevensAndEightsUdp
    extends UserDefinedPredicate<Integer> {
        public boolean keep(Integer value) {
            if (value == null) {
                return true;
            }
            throw new RuntimeException("this method should not be called with value != null");
        }

        public boolean canDrop(org.apache.parquet.filter2.predicate.Statistics<Integer> statistics) {
            return (Integer)statistics.getMin() == 7 && (Integer)statistics.getMax() == 7;
        }

        public boolean inverseCanDrop(org.apache.parquet.filter2.predicate.Statistics<Integer> statistics) {
            return (Integer)statistics.getMin() == 8 && (Integer)statistics.getMax() == 8;
        }
    }
}

