/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.ByteBufferReleaser;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.DirectByteBufferAllocator;
import org.apache.parquet.bytes.HeapByteBufferAllocator;
import org.apache.parquet.bytes.TrackingByteBufferAllocator;
import org.apache.parquet.compression.CompressionCodecFactory;
import org.apache.parquet.hadoop.CodecFactory;
import org.apache.parquet.hadoop.DirectCodecFactory;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDirectCodecFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TestDirectCodecFactory.class);
    private final int pageSize = 65536;

    private void test(int size, CompressionCodecName codec, boolean useOnHeapCompression, Decompression decomp) {
        try (TrackingByteBufferAllocator allocator = TrackingByteBufferAllocator.wrap((ByteBufferAllocator)new DirectByteBufferAllocator());
             ByteBufferReleaser releaser = new ByteBufferReleaser((ByteBufferAllocator)allocator);){
            CodecFactory directCodecFactory = CodecFactory.createDirectCodecFactory((Configuration)new Configuration(), (ByteBufferAllocator)allocator, (int)65536);
            CodecFactory heapCodecFactory = new CodecFactory(new Configuration(), 65536);
            ByteBuffer rawBuf = allocator.allocate(size);
            releaser.releaseLater(rawBuf);
            byte[] rawArr = new byte[size];
            Random r = new Random();
            byte[] random = new byte[1024];
            for (int pos = 0; pos < size; pos += random.length) {
                r.nextBytes(random);
                rawBuf.put(random);
                System.arraycopy(random, 0, rawArr, pos, random.length);
            }
            rawBuf.flip();
            CodecFactory.BytesCompressor directCompressor = directCodecFactory.getCompressor(codec);
            CodecFactory.BytesDecompressor directDecompressor = directCodecFactory.getDecompressor(codec);
            CodecFactory.BytesCompressor heapCompressor = heapCodecFactory.getCompressor(codec);
            CodecFactory.BytesDecompressor heapDecompressor = heapCodecFactory.getDecompressor(codec);
            if (codec == CompressionCodecName.LZ4_RAW) {
                Assert.assertTrue((String)String.format("The hadoop codec %s should support direct decompression", codec), (boolean)(directDecompressor instanceof DirectCodecFactory.FullDirectDecompressor));
            }
            BytesInput directCompressed = useOnHeapCompression ? directCompressor.compress(BytesInput.from((byte[])rawArr)) : directCompressor.compress(BytesInput.from((ByteBuffer[])new ByteBuffer[]{rawBuf}));
            BytesInput heapCompressed = heapCompressor.compress(BytesInput.from((byte[])rawArr));
            TestDirectCodecFactory.validateDecompress(size, codec, decomp, directCompressed.copy(releaser), (ByteBufferAllocator)allocator, (CompressionCodecFactory.BytesInputDecompressor)directDecompressor, rawBuf, rawArr);
            TestDirectCodecFactory.validateDecompress(size, codec, decomp, heapCompressed, (ByteBufferAllocator)allocator, (CompressionCodecFactory.BytesInputDecompressor)directDecompressor, rawBuf, rawArr);
            TestDirectCodecFactory.validateDecompress(size, codec, decomp, directCompressed, (ByteBufferAllocator)allocator, (CompressionCodecFactory.BytesInputDecompressor)heapDecompressor, rawBuf, rawArr);
            directCompressor.release();
            directDecompressor.release();
            directCodecFactory.release();
            heapCompressor.release();
            heapDecompressor.release();
            heapCodecFactory.release();
        }
        catch (Exception e) {
            String msg = String.format("Failure while testing Codec: %s, OnHeapCompressionInput: %s, Decompression Mode: %s, Data Size: %d", codec.name(), useOnHeapCompression, decomp.name(), size);
            LOG.error(msg);
            throw new RuntimeException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void validateDecompress(int size, CompressionCodecName codec, Decompression decomp, BytesInput compressed, ByteBufferAllocator allocator, CompressionCodecFactory.BytesInputDecompressor d, ByteBuffer rawBuf, byte[] rawArr) throws IOException {
        switch (decomp) {
            case OFF_HEAP: {
                ByteBuffer buf = compressed.toByteBuffer();
                ByteBuffer b = allocator.allocate(buf.capacity() + 20);
                ByteBuffer outBuf = allocator.allocate(size + 20);
                int shift = 10;
                try {
                    b.position(10);
                    b.put(buf);
                    b.position(10);
                    outBuf.position(10);
                    d.decompress(b, (int)compressed.size(), outBuf, size);
                    Assert.assertEquals((String)("Input buffer position mismatch for codec " + codec), (long)(compressed.size() + 10L), (long)b.position());
                    Assert.assertEquals((String)("Output buffer position mismatch for codec " + codec), (long)(size + 10), (long)outBuf.position());
                    for (int i = 0; i < size; ++i) {
                        Assert.assertTrue((String)String.format("Data didn't match at %d, while testing codec %s", i, codec), (outBuf.get(10 + i) == rawBuf.get(i) ? 1 : 0) != 0);
                    }
                    break;
                }
                finally {
                    allocator.release(b);
                    allocator.release(outBuf);
                }
            }
            case OFF_HEAP_BYTES_INPUT: {
                ByteBuffer buf = compressed.toByteBuffer();
                ByteBuffer b = allocator.allocate(buf.limit());
                try {
                    b.put(buf);
                    b.flip();
                    BytesInput input = d.decompress(BytesInput.from((ByteBuffer[])new ByteBuffer[]{b}), size);
                    Assert.assertArrayEquals((String)String.format("While testing codec %s", codec), (byte[])input.toByteArray(), (byte[])rawArr);
                    break;
                }
                finally {
                    allocator.release(b);
                }
            }
            case ON_HEAP: {
                byte[] buf = compressed.toByteArray();
                BytesInput input = d.decompress(BytesInput.from((byte[])buf), size);
                Assert.assertArrayEquals((String)String.format("While testing codec %s", codec), (byte[])input.toByteArray(), (byte[])rawArr);
                break;
            }
        }
    }

    @Test
    public void createDirectFactoryWithHeapAllocatorFails() {
        String errorMsg = "Test failed, creation of a direct codec factory should have failed when passed a non-direct allocator.";
        try {
            CodecFactory.createDirectCodecFactory((Configuration)new Configuration(), (ByteBufferAllocator)new HeapByteBufferAllocator(), (int)0);
            throw new RuntimeException(errorMsg);
        }
        catch (IllegalStateException ex) {
            Assert.assertTrue((String)"Missing expected error message.", (boolean)ex.getMessage().contains("A DirectCodecFactory requires a direct buffer allocator be provided."));
        }
        catch (Exception ex) {
            throw new RuntimeException(errorMsg + " Failed with the wrong error.");
        }
    }

    @Test
    public void compressionCodecs() {
        int[] sizes = new int[]{4096, 0x100000};
        boolean[] comp = new boolean[]{true, false};
        HashSet<CompressionCodecName> codecsToSkip = new HashSet<CompressionCodecName>();
        codecsToSkip.add(CompressionCodecName.LZO);
        codecsToSkip.add(CompressionCodecName.LZ4);
        String arch = System.getProperty("os.arch");
        if ("aarch64".equals(arch)) {
            codecsToSkip.add(CompressionCodecName.BROTLI);
        }
        for (int size : sizes) {
            for (boolean useOnHeapComp : comp) {
                for (Decompression decomp : Decompression.values()) {
                    for (CompressionCodecName codec : CompressionCodecName.values()) {
                        if (codecsToSkip.contains(codec)) continue;
                        this.test(size, codec, useOnHeapComp, decomp);
                    }
                }
            }
        }
    }

    @Test
    public void cachingKeysGzip() {
        Configuration config_zlib_2 = new Configuration();
        config_zlib_2.set("zlib.compress.level", "2");
        Configuration config_zlib_5 = new Configuration();
        config_zlib_5.set("zlib.compress.level", "5");
        PublicCodecFactory codecFactory_2 = new PublicCodecFactory(config_zlib_2, 65536);
        PublicCodecFactory codecFactory_5 = new PublicCodecFactory(config_zlib_5, 65536);
        CompressionCodec codec_2_1 = codecFactory_2.getCodec(CompressionCodecName.GZIP);
        CompressionCodec codec_2_2 = codecFactory_2.getCodec(CompressionCodecName.GZIP);
        CompressionCodec codec_5_1 = codecFactory_5.getCodec(CompressionCodecName.GZIP);
        Assert.assertEquals((Object)codec_2_1, (Object)codec_2_2);
        Assert.assertNotEquals((Object)codec_2_1, (Object)codec_5_1);
    }

    @Test
    public void cachingKeysZstd() {
        Configuration config_zstd_2 = new Configuration();
        config_zstd_2.set("parquet.compression.codec.zstd.level", "2");
        Configuration config_zstd_5 = new Configuration();
        config_zstd_5.set("parquet.compression.codec.zstd.level", "5");
        PublicCodecFactory codecFactory_2 = new PublicCodecFactory(config_zstd_2, 65536);
        PublicCodecFactory codecFactory_5 = new PublicCodecFactory(config_zstd_5, 65536);
        CompressionCodec codec_2_1 = codecFactory_2.getCodec(CompressionCodecName.ZSTD);
        CompressionCodec codec_2_2 = codecFactory_2.getCodec(CompressionCodecName.ZSTD);
        CompressionCodec codec_5_1 = codecFactory_5.getCodec(CompressionCodecName.ZSTD);
        Assert.assertEquals((Object)codec_2_1, (Object)codec_2_2);
        Assert.assertNotEquals((Object)codec_2_1, (Object)codec_5_1);
    }

    static class PublicCodecFactory
    extends CodecFactory {
        public PublicCodecFactory(Configuration configuration, int pageSize) {
            super(configuration, pageSize);
        }

        public CompressionCodec getCodec(CompressionCodecName name) {
            return super.getCodec(name);
        }
    }

    private static enum Decompression {
        ON_HEAP,
        OFF_HEAP,
        OFF_HEAP_BYTES_INPUT;

    }
}

