/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.example.ExampleInputFormat;
import org.apache.parquet.hadoop.example.ExampleOutputFormat;
import org.apache.parquet.hadoop.util.ContextUtil;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestInputFormatColumnProjection {
    public static final String FILE_CONTENT = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ,abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ,abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static MessageType PARQUET_TYPE = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("uuid")).required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("char")).named("FormatTestObject");
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private final boolean readType;

    @Parameterized.Parameters(name="vectored : {0}")
    public static List<Boolean> params() {
        return Arrays.asList(true, false);
    }

    public TestInputFormatColumnProjection(boolean readType) {
        this.readType = readType;
    }

    @Test
    public void testProjectionSize() throws Exception {
        Assume.assumeTrue((boolean)JobContext.class.isInterface());
        File inputFile = this.temp.newFile();
        FileOutputStream out = new FileOutputStream(inputFile);
        out.write(FILE_CONTENT.getBytes("UTF-8"));
        out.close();
        File tempFolder = this.temp.newFolder();
        tempFolder.delete();
        Path tempPath = new Path(tempFolder.toURI());
        File outputFolder = this.temp.newFile();
        outputFolder.delete();
        Configuration conf = new Configuration();
        conf.setBoolean("parquet.hadoop.vectored.io.enabled", this.readType);
        conf.set("parquet.read.schema", ((MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("char")).named("FormatTestObject")).toString());
        conf.set("parquet.enable.summary-metadata", "false");
        conf.set("parquet.example.schema", PARQUET_TYPE.toString());
        Job writeJob = new Job(conf, "write");
        writeJob.setInputFormatClass(TextInputFormat.class);
        TextInputFormat.addInputPath((Job)writeJob, (Path)new Path(inputFile.toString()));
        writeJob.setOutputFormatClass(ExampleOutputFormat.class);
        writeJob.setMapperClass(Writer.class);
        writeJob.setNumReduceTasks(0);
        ParquetOutputFormat.setBlockSize((Job)writeJob, (int)10240);
        ParquetOutputFormat.setPageSize((Job)writeJob, (int)512);
        ParquetOutputFormat.setDictionaryPageSize((Job)writeJob, (int)1024);
        ParquetOutputFormat.setEnableDictionary((Job)writeJob, (boolean)true);
        ParquetOutputFormat.setMaxPaddingSize((JobContext)writeJob, (int)1023);
        ParquetOutputFormat.setOutputPath((Job)writeJob, (Path)tempPath);
        this.waitForJob(writeJob);
        long bytesWritten = 0L;
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        for (FileStatus file : fs.listStatus(tempPath)) {
            bytesWritten += file.getLen();
        }
        Job readJob = new Job(conf, "read");
        readJob.setInputFormatClass(ExampleInputFormat.class);
        TextInputFormat.addInputPath((Job)readJob, (Path)tempPath);
        readJob.setOutputFormatClass(TextOutputFormat.class);
        readJob.setMapperClass(Reader.class);
        readJob.setNumReduceTasks(0);
        TextOutputFormat.setOutputPath((Job)readJob, (Path)new Path(outputFolder.toString()));
        this.waitForJob(readJob);
        long bytesRead = Reader.bytesReadCounter.getValue();
        Assert.assertTrue((String)("Should read (" + bytesRead + " bytes) less than 10% of the input file size (" + bytesWritten + ")"), (bytesRead < bytesWritten / 10L ? 1 : 0) != 0);
    }

    private void waitForJob(Job job) throws Exception {
        job.submit();
        while (!job.isComplete()) {
            Thread.sleep(100L);
        }
        if (!job.isSuccessful()) {
            throw new RuntimeException("job failed " + job.getJobName());
        }
    }

    public static class Reader
    extends Mapper<Void, Group, LongWritable, Text> {
        public static Counter bytesReadCounter = null;

        public static void setBytesReadCounter(Counter bytesRead) {
            bytesReadCounter = bytesRead;
        }

        protected void map(Void key, Group value, Mapper.Context context) throws IOException, InterruptedException {
            Reader.setBytesReadCounter(ContextUtil.getCounter((TaskAttemptContext)context, (String)"parquet", (String)"bytesread"));
        }
    }

    public static class Writer
    extends Mapper<LongWritable, Text, Void, Group> {
        public static final SimpleGroupFactory GROUP_FACTORY = new SimpleGroupFactory(PARQUET_TYPE);

        protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            String line = value.toString();
            for (int i = 0; i < line.length(); ++i) {
                Group group = GROUP_FACTORY.newGroup();
                group.add(0, Binary.fromString((String)UUID.randomUUID().toString()));
                group.add(1, Binary.fromString((String)line.substring(i, i + 1)));
                context.write(null, (Object)group);
            }
        }
    }
}

